/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.controller;

import com.seeyon.cap4.desensitization.constant.DesensConstant;
import com.seeyon.cap4.desensitization.manager.DesenseManagerImpl;
import com.seeyon.ctp.common.controller.BaseController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;

public class DesensitizationController
extends BaseController {
    private static final Log logger = LogFactory.getLog(DesenseManagerImpl.class);

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("cap4/desensitization/ddapp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadLocalFile(HttpServletRequest request, HttpServletResponse response) {
        String fileName = request.getParameter("fileName");
        String url = DesensConstant.TEMPDIR + File.separator + fileName;
        try {
            response.setHeader("content-disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)"Encoding not supported", (Throwable)e);
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(url);
            int len = 0;
            byte[] buf = new byte[1024];
            out = response.getOutputStream();
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Reading file error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.info((Object)"Close steam exception", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.info((Object)"Close steam exception", (Throwable)e);
                }
            }
        }
    }
}

