/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.foundation.impl;

import com.seeyon.cap4.desensitization.bean.BaseInfo;
import com.seeyon.cap4.desensitization.bean.BizToForms;
import com.seeyon.cap4.desensitization.bean.FieldBean;
import com.seeyon.cap4.desensitization.bean.FormBean;
import com.seeyon.cap4.desensitization.bean.TableBean;
import com.seeyon.cap4.desensitization.bean.ToTables;
import com.seeyon.cap4.desensitization.bean.ViewBean;
import com.seeyon.cap4.desensitization.foundation.BussinessInfoManager;
import com.seeyon.cap4.desensitization.utils.OrderedProperties;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BussinessInfoManagerImpl
implements BussinessInfoManager {
    private static Map<String, Object> bizInfoCache = new LinkedHashMap<String, Object>();
    private final String BASEKEY = "fuzzy.biz.summary";
    private final String FORMKEY = "fuzzy.biz.form";
    private final String SPACER = ";";

    @Override
    public Map<String, Object> getBussinessBaseInfo(String rootPath, String tempPath, String saveFilePath, boolean isCreateFile) throws Exception {
        File dataFile = new File(rootPath);
        File baseFile = new File(tempPath);
        if (baseFile == null && dataFile == null) {
            return null;
        }
        String baseJsonStr = this.getFileToString(baseFile);
        BaseInfo baseInfo = new BaseInfo();
        Map base = (Map)JSONUtil.parseJSONString((String)baseJsonStr);
        baseInfo.setSystemVersion(String.valueOf(base.get("platformVersion")));
        baseInfo.setBizVersion(String.valueOf(base.get("fileVersion")));
        String dataJsonStr = this.getFileToString(dataFile);
        BizToForms datas = (BizToForms)JSONUtil.parseJSONString((String)dataJsonStr, BizToForms.class);
        List<FormBean> forms = datas.getForms();
        Collections.sort(forms, new Comparator<FormBean>(){

            @Override
            public int compare(FormBean o1, FormBean o2) {
                return Long.parseLong(o1.getId()) > Long.parseLong(o2.getId()) ? 1 : -1;
            }
        });
        int viewTotal = 0;
        int fieldTotal = 0;
        LinkedHashMap<String, Object> showDatas = new LinkedHashMap<String, Object>();
        showDatas.put("FormTotal", forms.size());
        for (int i = 0; i < forms.size(); ++i) {
            int tableIndex = i + 1;
            FormBean fb = forms.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            int tableTotal = fb.getTableList().size();
            ToTables toTables = fb.getFieldInfo();
            TableBean mainTable = toTables.getFront_formmain();
            List<TableBean> subTables = toTables.getFormsons();
            showDatas.put("FieldTotal", fieldTotal);
            baseInfo.setFieldTotal(fieldTotal);
            showDatas.put("FormName" + tableIndex + "-TableTotal", subTables.size() + 1);
            showDatas.put("FormName" + tableIndex + "-FieldTotal", 0);
            stringBuilder.append(fb.getFormName()).append(";").append(subTables.size() + 1).append(";");
            StringBuilder sb = new StringBuilder();
            fieldTotal = this.getFieldTotal(fieldTotal, sb, showDatas, tableIndex, toTables, mainTable);
            tableTotal = Integer.parseInt(String.valueOf(showDatas.get("FormName" + tableIndex + "-FieldTotal")));
            stringBuilder.append(tableTotal).append(";");
            stringBuilder.append((CharSequence)sb);
            int ii = 1;
            for (String key : fb.getViewInfo().keySet()) {
                for (ViewBean viewBean : fb.getViewInfo().get(key)) {
                    ++viewTotal;
                    StringBuilder s = new StringBuilder();
                    s.append("FormName").append(tableIndex);
                    stringBuilder.append(key + "_" + viewBean.getName()).append(";");
                    showDatas.put(s.toString() + "-ViewType" + ii, viewBean.getType());
                    showDatas.put(s.toString() + "-ViewFieldTotal" + ii, viewBean.getFieldnames().size());
                    ++ii;
                }
            }
            showDatas.put("FieldTotal", fieldTotal);
            bizInfoCache.put("fuzzy.biz.form" + tableIndex, stringBuilder.toString());
        }
        showDatas.put("ViewTotal", viewTotal);
        baseInfo.setFormTotal(forms.size());
        baseInfo.setViewTotal(viewTotal);
        baseInfo.setFieldTotal(fieldTotal);
        this.putBaseInfoCache(baseInfo);
        if (isCreateFile) {
            this.createFuzzyPkgDesc(showDatas, saveFilePath);
        }
        return bizInfoCache;
    }

    private int getFieldTotal(int fieldTotal, StringBuilder stringBuilder, LinkedHashMap<String, Object> showDatas, int tableIndex, ToTables toTables, TableBean mainTable) {
        this.getFieldInFo(showDatas, tableIndex, mainTable, stringBuilder, Integer.parseInt(String.valueOf(showDatas.get("FormName" + tableIndex + "-FieldTotal"))));
        if (toTables.getFormsons() != null && toTables.getFormsons().size() > 0) {
            for (TableBean t : toTables.getFormsons()) {
                this.getFieldInFo(showDatas, tableIndex, t, stringBuilder, Integer.parseInt(String.valueOf(showDatas.get("FormName" + tableIndex + "-FieldTotal"))));
            }
        }
        return fieldTotal += Integer.parseInt(String.valueOf(showDatas.get("FormName" + tableIndex + "-FieldTotal")));
    }

    private void putBaseInfoCache(BaseInfo baseInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(baseInfo.getFormTotal()).append(";").append(baseInfo.getViewTotal()).append(";").append(baseInfo.getFieldTotal()).append(";");
        bizInfoCache.put("fuzzy.biz.summary", stringBuilder.toString());
    }

    @Override
    public void cleanCache() throws Exception {
        bizInfoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFuzzyPkgDesc(LinkedHashMap<String, Object> data, String saveFilePath) throws Exception {
        FileOutputStream oFile = null;
        try {
            File file = new File(saveFilePath);
            OrderedProperties prop = new OrderedProperties();
            oFile = new FileOutputStream(file, false);
            for (String key : data.keySet()) {
                prop.setProperty(key, String.valueOf(data.get(key)));
            }
            prop.store(new OutputStreamWriter((OutputStream)oFile, "utf-8"), "\u4fdd\u5b58FuzzyPkgDesc");
        }
        finally {
            if (oFile != null) {
                oFile.close();
            }
        }
    }

    private void getFieldInFo(Map<String, Object> resultMap, int tableIndex, TableBean tableBean, StringBuilder stringBuilder, int fieldCount) {
        StringBuilder key = new StringBuilder();
        key.append("FormName").append(tableIndex).append("-").append(tableBean.getTableName());
        stringBuilder.append(tableBean.getTableName()).append(";");
        StringBuilder fieldKey = new StringBuilder(key);
        resultMap.put(key + "-FieldTotal", fieldCount);
        int i = 0;
        List<FieldBean> fieldBeans = tableBean.getFieldInfo();
        Collections.sort(fieldBeans, new Comparator<FieldBean>(){

            @Override
            public int compare(FieldBean o1, FieldBean o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (FieldBean fieldBean : fieldBeans) {
            if (!fieldBean.getName().contains("field")) continue;
            ++i;
            resultMap.put(fieldKey.toString() + "-" + fieldBean.getName(), fieldBean.getName() + "_" + fieldBean.getType() + "_" + fieldBean.getFieldLength());
            stringBuilder.append(fieldBean.getName()).append(";");
        }
        resultMap.put(key + "-FieldTotal", i);
        resultMap.put("FormName" + tableIndex + "-FieldTotal", fieldCount += i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileToString(File jsonFile) throws IOException {
        FileInputStream fileIn = null;
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            fileIn = new FileInputStream(jsonFile);
            isr = new InputStreamReader((InputStream)fileIn, "UTF-8");
            bf = new BufferedReader(isr);
            String results = "";
            String tempStr = "";
            while ((tempStr = bf.readLine()) != null) {
                results = results + tempStr;
            }
            String string = results;
            return string;
        }
        finally {
            if (bf != null) {
                bf.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fileIn != null) {
                fileIn.close();
            }
        }
    }

    public static void main(String[] a) throws Exception {
    }
}

