/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.foundation.impl;

import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.apps.mplus.api.MplusExtApi;
import com.seeyon.cap4.desensitization.bean.GoodsPackageInfo;
import com.seeyon.cap4.desensitization.foundation.IDeSensExtractService;
import com.seeyon.cap4.desensitization.foundation.UnsportPackageTypeException;
import com.seeyon.cap4.desensitization.foundation.impl.BussinessInfoManagerImpl;
import com.seeyon.cap4.desensitization.utils.ExtensionJsonUtil;
import com.seeyon.cap4.desensitization.utils.FuzzyPkgUtils;
import com.seeyon.cap4.desensitization.utils.FuzzyUtils;
import com.seeyon.cap4.desensitization.utils.ValidateAndHash;
import com.seeyon.cap4.desensitization.utils.ZipUtil;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class DeSensExtractServiceImpl
implements IDeSensExtractService {
    private static final Log LOGGER = CtpLogFactory.getLog(DeSensExtractServiceImpl.class);
    private static MplusExtApi mplusExtApi = (MplusExtApi)AppContext.getBean((String)"mplusExtApi");
    private static MplusApi mplusApi = (MplusApi)AppContext.getBean((String)"mplusApi");
    private File syzFile;
    private String workPath;
    private String fullWorkPath;
    private String manifestPath;
    private String zipFilePath;
    private String fuzzyKeyFileName;
    private String pkgInfoJsonPath;
    private String pkgExtInfoJsonPath;
    private GoodsPackageInfo pkgInfo;
    private String fuzzyKey = "";
    private volatile boolean bInited = false;

    @Override
    public void init(File syzFile) throws BusinessException, UnsportPackageTypeException {
        this.syzFile = syzFile;
        this.workPath = syzFile.getParentFile().getAbsolutePath();
        String subWorkPath = UUID.randomUUID().toString();
        this.fullWorkPath = this.workPath + File.separator + subWorkPath + File.separator;
        if (!syzFile.exists()) {
            throw new BusinessException("Init DeSens pkg : syz file is not found:" + syzFile.getAbsolutePath());
        }
        String pkgPwd = this.getPackagePwd(syzFile);
        try {
            ZipUtil.unzip(syzFile.getAbsolutePath(), this.fullWorkPath, "");
        }
        catch (ZipException e) {
            LOGGER.error((Object)"Init DeSens pkg : unzip syz file is error!", (Throwable)e);
            throw new BusinessException("Init DeSens pkg : unzip syz file is error:" + syzFile.getAbsolutePath(), (Throwable)e);
        }
        this.manifestPath = this.fullWorkPath + "META-INF" + File.separator + "MANIFEST.MF";
        if (!new File(this.manifestPath).exists()) {
            throw new UnsportPackageTypeException("Desense does not support the type of the trial package.");
        }
        File workFile = new File(this.fullWorkPath);
        for (File file : workFile.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            this.zipFilePath = this.fullWorkPath + file.getName();
            break;
        }
        if (this.zipFilePath == "") {
            throw new BusinessException("Init DeSens pkg : The zip file is not founded in syz file\uff1a" + syzFile.getAbsolutePath());
        }
        String unzipFilePath = this.fullWorkPath + "zip" + File.separator;
        try {
            ZipUtil.unzip(this.zipFilePath, unzipFilePath, pkgPwd);
        }
        catch (ZipException e) {
            LOGGER.error((Object)"Init DeSens pkg : unzip secret zip file is error!", (Throwable)e);
            throw new BusinessException("Init DeSens pkg : unzip secret zip  file is not founded:" + this.zipFilePath);
        }
        File unzipFiles = new File(unzipFilePath);
        String jsonRootPath = "";
        for (File file : unzipFiles.listFiles()) {
            if (!file.isDirectory() || !new File((jsonRootPath = unzipFilePath + file.getName() + File.separator) + "cappackageinfo.json").exists() || !new File(jsonRootPath + "extension.json").exists()) continue;
            this.pkgInfoJsonPath = jsonRootPath + "cappackageinfo.json";
            this.pkgExtInfoJsonPath = jsonRootPath + "extension.json";
            break;
        }
        if (this.pkgExtInfoJsonPath == "" || this.pkgInfoJsonPath == "") {
            throw new BusinessException("Init DeSens pkg : json files is not founded:" + syzFile.getAbsolutePath());
        }
        ExtensionJsonUtil extensionJsonUtil = new ExtensionJsonUtil();
        try {
            this.pkgInfo = extensionJsonUtil.readExtensionJSON(new File(this.pkgExtInfoJsonPath));
        }
        catch (Exception ex) {
            throw new BusinessException("Read the manifest file error.", (Throwable)ex);
        }
        String typeInExtJson = this.pkgInfo.getCreateType();
        LOGGER.info((Object)("Densense : In extendjson ,The pkg type is : " + typeInExtJson));
        boolean bGoodsTypeInExtJsonValidate = this.isGoodsPackage(typeInExtJson);
        Map<String, String> map = null;
        try {
            map = FuzzyPkgUtils.getMapFromPropertiesFile(this.manifestPath);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Desense read file error : " + this.manifestPath));
            throw new BusinessException("Desense read file error : " + this.manifestPath, (Throwable)e);
        }
        String typeInMainfest = map.get("Type");
        LOGGER.info((Object)("Densense : In Manifest ,The pkg type is : " + typeInMainfest));
        boolean bGoodsTypeInMainfest = this.isGoodsPackage(typeInMainfest);
        if (bGoodsTypeInExtJsonValidate || bGoodsTypeInMainfest) {
            LOGGER.error((Object)"Desense does not support the type of the package.");
            throw new UnsportPackageTypeException("Desense does not support the type of the package.");
        }
        this.fuzzyKey = UUID.randomUUID().toString();
        this.bInited = true;
    }

    private boolean isGoodsPackage(String type) {
        boolean bGoodsPkg = true;
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            String commic = new Integer(BizEnums.BizCreateSourceType.ImportFromMall.getKey()).toString();
            bGoodsPkg = type.compareTo(commic) == 0;
        }
        return bGoodsPkg;
    }

    public Map<String, String> genManifestMap() throws BusinessException {
        LinkedHashMap<String, String> manifestMap = new LinkedHashMap<String, String>();
        HashMap<String, String> ret = new HashMap<String, String>();
        File file = new File(this.manifestPath);
        if (!file.exists()) {
            throw new BusinessException("The MANIFEST.MF file of Fuzzy package is not exist\uff1a" + this.manifestPath);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.manifestPath));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] vals = line.split(":");
                ret.put(vals[0], vals[1]);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Read manifest file is error : " + this.manifestPath), (Throwable)ex);
            throw new BusinessException("Read manifest file is error \uff1a" + this.manifestPath, (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Close manifest file is error : " + this.manifestPath), (Throwable)e);
                }
            }
        }
        String createOrgName = StringUtils.isEmpty((CharSequence)this.pkgInfo.getCreateOrgName()) ? "" : this.pkgInfo.getCreateOrgName();
        String creator = StringUtils.isEmpty((CharSequence)this.pkgInfo.getCreator()) ? "" : this.pkgInfo.getCreator();
        try {
            String hash = ValidateAndHash.shaHashCode(new File(this.zipFilePath));
            String zipDigest = ValidateAndHash.makeDigest(new File(this.zipFilePath));
            manifestMap.put("CorpId", (String)mplusApi.getCorpInfo().get("corpid"));
            manifestMap.put("Id", (String)ret.get("Id"));
            manifestMap.put("Hash", hash);
            manifestMap.put("ZipDigest", zipDigest);
            manifestMap.put("Version", this.getPkgVersion(this.pkgExtInfoJsonPath));
            manifestMap.put("ResignedPkgType", (String)ret.get("Type"));
            manifestMap.put("Key", (String)ret.get("Key"));
            manifestMap.put("AppVer", "8.16");
            manifestMap.put("CreateOrgName", createOrgName);
            manifestMap.put("Creator", creator);
            String sign = this.signManifestMap(manifestMap);
            manifestMap.put("Sign", sign);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Get corpid or sign manifest  is error : " + ex.getMessage()));
            throw new BusinessException("Get corpid or sign manifest  is error", (Throwable)ex);
        }
        return manifestMap;
    }

    private String getPkgVersion(String extJsonPath) throws Exception {
        File extJsonFile = new File(extJsonPath);
        String extension = FileUtils.readFileToString((File)extJsonFile, (String)"UTF-8");
        Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
        String fileVersion = "";
        if (extensionMap.containsKey("fileVersion")) {
            fileVersion = extensionMap.get("fileVersion").toString();
        }
        return fileVersion;
    }

    public void genMainfestFile(String outFilePath) throws BusinessException {
        Map<String, String> manifestMap = this.genManifestMap();
        String content = FuzzyUtils.genMainfestFileContent(manifestMap);
        try {
            String genManifestPath = outFilePath;
            FuzzyUtils.writeFile(genManifestPath, content, "UTF-8", false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Write Manifest file  is error : " + ex.getMessage()));
            throw new BusinessException("Write Manifest file  is error ", (Throwable)ex);
        }
    }

    public String genDeSensFiles(String outPlanFilePath, String outName) throws BusinessException {
        BussinessInfoManagerImpl bizInfo1 = new BussinessInfoManagerImpl();
        try {
            bizInfo1.cleanCache();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Fuzzy cache clean  is error : ", (Throwable)e);
        }
        String infoJsonPath = this.pkgInfoJsonPath;
        String extInfoJsonPath = this.pkgExtInfoJsonPath;
        try {
            File newDzzFile;
            File outFile = new File(outPlanFilePath);
            if (!outFile.exists()) {
                outFile.mkdirs();
            }
            String signInfPath = outPlanFilePath + File.separator + "SIGN-INF";
            String metaInfPath = outPlanFilePath + File.separator + "META-INF";
            File signInfFile = new File(signInfPath);
            File metaInfFile = new File(metaInfPath);
            if (!signInfFile.exists()) {
                signInfFile.mkdirs();
            }
            if (!metaInfFile.exists()) {
                metaInfFile.mkdirs();
            }
            String fuzzyPkgDescFilePath = signInfPath + File.separator + "fuzzy.pkg.desc";
            Map<String, Object> pkgTotalInfoMap = bizInfo1.getBussinessBaseInfo(infoJsonPath, extInfoJsonPath, fuzzyPkgDescFilePath, true);
            this.appendSignForPkgBizFile(fuzzyPkgDescFilePath);
            String fuzzySignChecksumFilePath = signInfPath + File.separator + "fuzzy.sign.checksum.cer1";
            Map<String, Object> appendFuzzyKeyMap = FuzzyUtils.appendFuzzyKeyFuzzySignChecksumMap(pkgTotalInfoMap, this.fuzzyKey);
            Map<String, Object> signedMap = FuzzyUtils.signFuzzySignChecksumMap(appendFuzzyKeyMap);
            FuzzyUtils.writeToFuzzySignChecksumFile(signedMap, fuzzySignChecksumFilePath);
            String manifestFilePath = metaInfPath + File.separator + "MANIFEST.MF";
            this.genMainfestFile(manifestFilePath);
            String emptyZipFilePath = outPlanFilePath + File.separator + "empty.zip";
            new File(emptyZipFilePath).createNewFile();
            ArrayList<File> ddzFils = new ArrayList<File>();
            File manifestFileFile = new File(metaInfPath);
            File emptyZipFile = new File(emptyZipFilePath);
            ddzFils.add(signInfFile);
            ddzFils.add(manifestFileFile);
            ddzFils.add(emptyZipFile);
            String ddzPkgFilePath = outPlanFilePath + File.separator + outName + ".ddz";
            if (!ddzPkgFilePath.endsWith(".ddz")) {
                ddzPkgFilePath = ddzPkgFilePath + ".ddz";
            }
            if ((newDzzFile = new File(ddzPkgFilePath)).exists()) {
                newDzzFile.delete();
            }
            ZipUtil.zip(ddzFils, newDzzFile, "");
            FuzzyUtils.delDir(signInfFile.getAbsolutePath());
            FuzzyUtils.delDir(metaInfFile.getAbsolutePath());
            new File(signInfFile.getAbsolutePath()).delete();
            new File(metaInfFile.getAbsolutePath()).delete();
            emptyZipFile.delete();
            return newDzzFile.getName();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Write the DeSens file is error.", (Throwable)e);
            throw new BusinessException("Write the DeSens file is error.");
        }
    }

    public String genFuzzyKeyFile(String outPath, String outName) throws BusinessException {
        try {
            this.fuzzyKeyFileName = outName + "-" + "\u7cca\u540dkey\u6587\u4ef6.txt";
            String fuzzyKeyFileFullPath = outPath + File.separator + this.fuzzyKeyFileName;
            File fuzzyParentFile = new File(outPath);
            if (!fuzzyParentFile.exists()) {
                fuzzyParentFile.mkdirs();
            }
            String fuzzyKey = this.fuzzyKey;
            fuzzyKey = "FuzzyKey=" + fuzzyKey;
            FuzzyUtils.writeFile(fuzzyKeyFileFullPath, fuzzyKey, "utf-8", false);
            return this.fuzzyKeyFileName;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Write the fuzzy key is error : " + outPath));
            throw new BusinessException("Write the fuzzy key is error : " + outPath);
        }
    }

    private void appendSignForPkgBizFile(String path) throws BusinessException {
        try {
            String totalBizInfo = FuzzyUtils.getPkgBizTotalInfo(path);
            String signMsg = this.signMessage(totalBizInfo);
            signMsg = "Sign=" + signMsg;
            FuzzyUtils.writeFile(path, signMsg, "utf-8", true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Append the sign msg is error : " + path), (Throwable)ex);
            throw new BusinessException("Append the sign msg is error : " + path);
        }
    }

    private String signManifestMap(Map<String, String> manifestMap) throws BusinessException {
        String strManifest = FuzzyUtils.genSignManifestContentExcludeSign(manifestMap);
        return this.signMessage(strManifest);
    }

    private String signMessage(String strManifest) throws BusinessException {
        byte[] manifestBytes = new byte[]{};
        Object[] signManifestBytes = new Object[]{};
        try {
            manifestBytes = strManifest.getBytes("utf-8");
            signManifestBytes = mplusExtApi.signMessage(manifestBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessException("Sign msg is error, unsupport encoding\uff1a" + e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            throw new BusinessException("Sign msg is error\uff1a" + e.getMessage(), (Throwable)e);
        }
        String signTsignManifestBase64 = new String(Base64.encodeBase64((byte[])((byte[])signManifestBytes[0])));
        return signTsignManifestBase64;
    }

    @Override
    public void cleanup() throws BusinessException {
        try {
            FuzzyUtils.delDir(this.fullWorkPath);
        }
        catch (IOException e) {
            throw new BusinessException("delete dir is failed \uff1a" + this.fullWorkPath, (Throwable)e);
        }
    }

    private String getPackagePwd(File signedFile) throws BusinessException {
        Map verifyResult = mplusApi.verifyPackage(signedFile);
        String password = (String)verifyResult.get("pwd");
        return password;
    }

    @Override
    public Map<String, String> extractPkgToFuzzyPkg(String fuzzyPkgOutpath, String outName) throws BusinessException {
        if (!this.bInited) {
            throw new BusinessException("DeSens package must be init first, you should call init()");
        }
        String fuzzyKeyFileName = this.genFuzzyKeyFile(fuzzyPkgOutpath, outName);
        String ddzFileName = this.genDeSensFiles(fuzzyPkgOutpath, outName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KEY_FILE_NAME", fuzzyKeyFileName);
        map.put("DDZ_FILE_NAME", ddzFileName);
        return map;
    }
}

