/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.foundation.impl;

import com.seeyon.cap4.desensitization.foundation.IDeSensPackageService;
import com.seeyon.cap4.desensitization.utils.FuzzyUtils;
import com.seeyon.cap4.desensitization.utils.ZipUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;

public class DeSensPackageServiceImpl
implements IDeSensPackageService {
    private static final Log LOGGER = CtpLogFactory.getLog(DeSensPackageServiceImpl.class);
    private String outputPath;

    public DeSensPackageServiceImpl(String outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public Map<String, String> packageDeSensPkg(File syzFile, File dzzFile, File fuzzyKeyFile, String outName) throws BusinessException {
        File outputPathFile = new File(this.outputPath);
        if (!outputPathFile.exists()) {
            outputPathFile.mkdirs();
        }
        String workDirPath = this.outputPath + File.separator + UUID.randomUUID().toString();
        String syzDirPath = workDirPath + File.separator + "syz";
        String ddzDirPath = workDirPath + File.separator + "ddz";
        File syzDirFile = new File(syzDirPath);
        File ddzDirFile = new File(ddzDirPath);
        if (!syzDirFile.exists()) {
            syzDirFile.mkdirs();
        }
        if (!ddzDirFile.exists()) {
            ddzDirFile.mkdirs();
        }
        try {
            ZipUtil.unzip(syzFile.getAbsolutePath(), syzDirFile.getAbsolutePath(), "");
            ZipUtil.unzip(dzzFile.getAbsolutePath(), ddzDirFile.getAbsolutePath(), "");
        }
        catch (ZipException e) {
            LOGGER.error((Object)("unzip syzFile or dzzFile errro : " + syzDirPath + ";" + dzzFile), (Throwable)e);
            throw new BusinessException("unzip file error");
        }
        String fuzzyMetaInfoDirPath = ddzDirPath + File.separator + "META-INF" + File.separator;
        File bizPackageFile = null;
        for (File file : syzDirFile.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            bizPackageFile = file;
            break;
        }
        if (bizPackageFile == null) {
            throw new BusinessException("The syz file does't contain zip file : " + syzFile.getAbsolutePath());
        }
        String fuzzySignInfoDirPath = ddzDirPath + File.separator + "SIGN-INF" + File.separator;
        String fuzzySignChecksumFilePath = fuzzySignInfoDirPath + "fuzzy.sign.checksum.cer1";
        File metainfFile = new File(fuzzyMetaInfoDirPath);
        File signinfFile = new File(fuzzySignInfoDirPath);
        if (!metainfFile.exists()) {
            throw new BusinessException("The ddz file does't contain MANI-INF file : " + dzzFile.getAbsolutePath());
        }
        if (!signinfFile.exists()) {
            throw new BusinessException("The ddz file does't contain SIGN-INF file : " + dzzFile.getAbsolutePath());
        }
        try {
            String fuzzyKey = FuzzyUtils.getFuzzyKey(fuzzyKeyFile.getAbsolutePath());
            if (fuzzyKey.equals("")) {
                LOGGER.error((Object)("The fuzzy key file does not contain FUZZY_KEY : " + fuzzyKeyFile.getAbsolutePath()));
                throw new BusinessException("The fuzzy key file does not contain FUZZY_KEY : " + fuzzyKeyFile.getAbsolutePath());
            }
            String fuzzyKeyContent = "FuzzyKey=" + fuzzyKey;
            FuzzyUtils.writeFile(fuzzySignChecksumFilePath, fuzzyKeyContent, "UTF-8", true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("get fuzzy key error : " + fuzzyKeyFile.getAbsolutePath()), (Throwable)e);
            throw new BusinessException("get fuzzy key error!", (Throwable)e);
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(metainfFile);
        files.add(signinfFile);
        files.add(bizPackageFile);
        String outsyzFilePath = this.outputPath + File.separator + outName;
        File outSyzFile = new File(outsyzFilePath);
        try {
            if (outSyzFile.exists()) {
                outSyzFile.delete();
            }
            ZipUtil.zip(files, outSyzFile, "");
        }
        catch (ZipException e) {
            LOGGER.error((Object)"zip fils error", (Throwable)e);
            throw new BusinessException("zip fils error!", (Throwable)e);
        }
        try {
            FuzzyUtils.delDir(workDirPath);
            new File(workDirPath).delete();
        }
        catch (IOException e) {
            LOGGER.error((Object)("clean work fils error: " + workDirPath), (Throwable)e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SYZ_FILE_NAME", outSyzFile.getName());
        return map;
    }
}

