/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.manager;

import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.desensitization.constant.DesensConstant;
import com.seeyon.cap4.desensitization.foundation.UnsportPackageTypeException;
import com.seeyon.cap4.desensitization.foundation.impl.DeSensExtractServiceImpl;
import com.seeyon.cap4.desensitization.foundation.impl.DeSensPackageServiceImpl;
import com.seeyon.cap4.desensitization.manager.DesenseManager;
import com.seeyon.cap4.desensitization.utils.FuzzyUtils;
import com.seeyon.cap4.desensitization.utils.ZipUtil;
import com.seeyon.cap4.desensitization.vo.DesensResultVO;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import www.seeyon.com.utils.FileUtil;

public class DesenseManagerImpl
implements DesenseManager {
    private static final Log logger = LogFactory.getLog(DesenseManagerImpl.class);
    private static final String dssFileFolder = DesensConstant.TEMPDIR;
    private FileManager fileManager;
    private MplusApi mplusApi;

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    @Override
    @AjaxAccess
    public void downloadCallback(Long fileId) {
        try {
            File file = this.fileManager.getFile(fileId);
            FileUtil.delDir((File)file);
        }
        catch (Exception e) {
            logger.info((Object)("delete desense's temp file failed, fileId is :" + fileId));
        }
    }

    @Override
    @AjaxAccess
    public Map<String, Object> verify(Map<String, Object> params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        try {
            Long fileId = CAPParamUtil.getLong(params, (String)"fileId");
            int type = CAPParamUtil.getInteger(params, (String)"type");
            File file = this.fileManager.getFile(fileId);
            this.verifyFile(file, type);
        }
        catch (UnsportPackageTypeException e) {
            logger.error((Object)("Desensitize failed:" + e + ", params:" + params), (Throwable)e);
            resultMap.put("success", false);
            resultMap.put("msg", "\u8be5\u4e1a\u52a1\u5305\u7c7b\u578b\u4e0d\u652f\u6301\u8131\u654f");
            return resultMap;
        }
        catch (BusinessException e) {
            logger.error((Object)("Desensitize failed:" + (Object)((Object)e) + ", params:" + params), (Throwable)e);
            resultMap.put("success", false);
            resultMap.put("msg", "\u4e0d\u662f\u672c\u5355\u4f4d\u7684\u4e1a\u52a1\u5305\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return resultMap;
        }
        return resultMap;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> desensitize(Map<String, Object> params) {
        logger.info(params);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        try {
            Long fileId = CAPParamUtil.getLong(params, (String)"fileId");
            String originalFileName = CAPParamUtil.getString(params, (String)"fileName");
            String fileName = this.delSuffix(originalFileName);
            ArrayList<DesensResultVO> list = new ArrayList<DesensResultVO>();
            File file = this.fileManager.getFile(fileId);
            DeSensExtractServiceImpl dssSerivce = new DeSensExtractServiceImpl();
            dssSerivce.init(file);
            Map<String, String> filenames = dssSerivce.extractPkgToFuzzyPkg(dssFileFolder, fileName);
            dssSerivce.extractPkgToFuzzyPkg(dssFileFolder, fileName);
            dssSerivce.cleanup();
            DesensResultVO ddzResult = new DesensResultVO();
            ddzResult.setDownloadUrl(dssFileFolder + File.separator + filenames.get("DDZ_FILE_NAME"));
            ddzResult.setFileName(filenames.get("DDZ_FILE_NAME"));
            ddzResult.setType(1);
            list.add(ddzResult);
            DesensResultVO txtResult = new DesensResultVO();
            txtResult.setDownloadUrl(dssFileFolder + File.separator + filenames.get("KEY_FILE_NAME"));
            txtResult.setFileName(filenames.get("KEY_FILE_NAME"));
            txtResult.setType(2);
            list.add(txtResult);
            resultMap.put("list", list);
        }
        catch (UnsportPackageTypeException e) {
            logger.error((Object)"generate desensitization file failed", (Throwable)e);
            resultMap.put("success", false);
            resultMap.put("msg", "\u8be5\u4e1a\u52a1\u5305\u7c7b\u578b\u4e0d\u652f\u6301\u8131\u654f");
        }
        catch (BusinessException e) {
            logger.error((Object)"generate desensitization file failed", (Throwable)e);
            resultMap.put("success", false);
            resultMap.put("msg", "\u8131\u654f\u5305\u751f\u6210\u5931\u8d25\uff01");
        }
        return resultMap;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> packageItems(List<Map<String, Object>> list) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        File ddzFile = null;
        File txtFile = null;
        File syzFile = null;
        String outFileName = "";
        if (list != null) {
            for (Map<String, Object> fileObj : list) {
                Long fileId = CAPParamUtil.getLong(fileObj, (String)"fileId");
                String fileName = CAPParamUtil.getString(fileObj, (String)"fileName");
                File file = null;
                try {
                    file = this.fileManager.getFile(fileId);
                }
                catch (BusinessException e) {
                    logger.error((Object)"get File error");
                }
                if (fileName.endsWith(".ddz")) {
                    ddzFile = file;
                    continue;
                }
                if (fileName.endsWith(".txt")) {
                    txtFile = file;
                    continue;
                }
                if (fileName.endsWith(".syz")) {
                    outFileName = fileName.substring(0, fileName.length() - 4) + "_\u5df2\u5c01\u88c5.syz";
                    syzFile = file;
                    continue;
                }
                logger.error((Object)("Desensitize package error, param:" + list));
                resultMap.put("success", false);
                resultMap.put("msg", "\u6587\u4ef6\u683c\u5f0f\u4e0a\u4f20\u9519\u8bef");
            }
            try {
                this.packageConsistency(ddzFile, syzFile);
            }
            catch (BusinessException e) {
                logger.error((Object)"Package files verify error", (Throwable)e);
                resultMap.put("success", false);
                resultMap.put("msg", e.getMessage());
            }
            try {
                DeSensPackageServiceImpl dsspService = new DeSensPackageServiceImpl(dssFileFolder);
                dsspService.packageDeSensPkg(syzFile, ddzFile, txtFile, outFileName);
                DesensResultVO ddzResult = new DesensResultVO();
                ddzResult.setDownloadUrl(dssFileFolder + File.separator + outFileName);
                ddzResult.setFileName(outFileName);
                ddzResult.setType(3);
                resultMap.put("data", ddzResult);
            }
            catch (BusinessException e) {
                logger.error((Object)"Desensitize package error", (Throwable)e);
                resultMap.put("success", false);
                resultMap.put("msg", "\u5c01\u88c5\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5339\u914d");
            }
        }
        return resultMap;
    }

    private String delSuffix(String fileName) {
        if (Strings.isNotEmpty((String)fileName)) {
            int index = fileName.lastIndexOf(".");
            return fileName.substring(0, index);
        }
        return fileName;
    }

    private void packageConsistency(File ddzFile, File syzFile) throws BusinessException {
        if (ddzFile == null || syzFile == null) {
            throw new BusinessException("\u8131\u654f\u6587\u4ef6\u4e0e\u4e1a\u52a1\u5305\u4e0d\u662f\u540c\u4e00\u4e2a\u539f\u59cb\u4e1a\u52a1\u5305\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        Map<String, Object> ddzMap = this.getManifestData(ddzFile, "ddz");
        Map<String, Object> syzMap = this.getManifestData(syzFile, "syz");
        if (CAPParamUtil.getString(ddzMap, (String)"Id") == null || !CAPParamUtil.getString(ddzMap, (String)"Id").equals(CAPParamUtil.getString(syzMap, (String)"Id"))) {
            throw new BusinessException("\u8131\u654f\u6587\u4ef6\u4e0e\u4e1a\u52a1\u5305\u4e0d\u662f\u540c\u4e00\u4e2a\u539f\u59cb\u4e1a\u52a1\u5305\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
    }

    private void verifyFile(File file, int type) throws BusinessException, UnsportPackageTypeException {
        if (type != 1) {
            if (type == 3) {
                DeSensExtractServiceImpl iDeSensExtractService = new DeSensExtractServiceImpl();
                iDeSensExtractService.init(file);
                iDeSensExtractService.cleanup();
            } else {
                logger.info((Object)"\u65e0\u9700\u68c0\u9a8c\u6587\u4ef6\u7c7b\u578b");
            }
        }
    }

    private Map<String, Object> getManifestData(File file, String type) throws BusinessException {
        String signRSAPath;
        File signRSAFile;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String workDirPath = dssFileFolder + File.separator + UUID.randomUUID().toString();
        String ddzDirPath = workDirPath + File.separator + "ddz";
        File ddzDirFile = new File(ddzDirPath);
        if (!ddzDirFile.exists()) {
            ddzDirFile.mkdirs();
        }
        try {
            ZipUtil.unzip(file.getAbsolutePath(), ddzDirFile.getAbsolutePath(), "");
        }
        catch (ZipException e) {
            logger.error((Object)"ddz\u6587\u4ef6\u89e3\u538b\u5931\u8d25", (Throwable)e);
            throw new BusinessException("Unzip file '.ddz' failed");
        }
        if ("ddz".equals(type) && !(signRSAFile = new File(signRSAPath = ddzDirPath + File.separator + "META-INF" + File.separator + "SIGN.RSA")).exists()) {
            throw new BusinessException("\u8bf7\u4e0a\u4f20\u8ba4\u8bc1\u540e\u7684\u8131\u654f\u5305");
        }
        String manifestPath = ddzDirPath + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            String line;
            fileReader = new FileReader(manifestPath);
            reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null && line.contains(":")) {
                String[] vals = line.split(":");
                if (vals.length <= 1) continue;
                ret.put(vals[0], vals[1]);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Read manifest file is error : " + manifestPath), (Throwable)ex);
            throw new BusinessException("Read manifest file is error \uff1a" + manifestPath, (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    FuzzyUtils.delDir(workDirPath);
                    new File(workDirPath).delete();
                }
                catch (IOException e) {
                    logger.error((Object)("Close manifest file is error : " + manifestPath), (Throwable)e);
                }
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Close stream error", (Throwable)e);
                }
            }
        }
        return ret;
    }
}

