/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.utils;

import com.seeyon.cap4.desensitization.constant.DesensConstant;
import com.seeyon.cap4.desensitization.foundation.impl.BussinessInfoManagerImpl;
import com.seeyon.cap4.desensitization.utils.FuzzyUtils;
import com.seeyon.cap4.desensitization.utils.ZipUtil;
import com.seeyon.cap4.validity.util.CertificateUtils;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.lingala.zip4j.exception.ZipException;

public class FuzzyPkgUtils {
    public static Map<String, Object> genFuzzyInfoBeforSign(String infoJsonPath, String extInfoJsonPath, String fuzzyKeyPath) throws Exception {
        String fuzzyKey = FuzzyUtils.getFuzzyKey(fuzzyKeyPath);
        BussinessInfoManagerImpl bizInfo1 = new BussinessInfoManagerImpl();
        bizInfo1.cleanCache();
        String fuzzyPkgDescFilePath = new File(infoJsonPath).getCanonicalPath() + File.separator + "fuzzyPkgDesc";
        Map<String, Object> pkgTotalInfoMap = bizInfo1.getBussinessBaseInfo(infoJsonPath, extInfoJsonPath, fuzzyPkgDescFilePath, false);
        Map<String, Object> appendFuzzyKeyMap = FuzzyUtils.appendFuzzyKeyFuzzySignChecksumMap(pkgTotalInfoMap, fuzzyKey);
        Map<String, Object> signedMap = FuzzyUtils.signFuzzySignChecksumMap(appendFuzzyKeyMap);
        return signedMap;
    }

    public static Map<String, String> getSignMapFromSyzPackageSignFile(String signFile) throws Exception {
        Map<String, String> signMap = FuzzyPkgUtils.getMapFromPropertiesFile(signFile);
        return signMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateFuzzyPackage(File unZipFile, String password) throws BusinessException {
        File[] files = unZipFile.listFiles();
        File zipPkgFile = null;
        for (File tempFile : files) {
            if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
            zipPkgFile = tempFile;
            break;
        }
        if (zipPkgFile == null) {
            throw new BusinessException("Desens package file does not exist zip file ");
        }
        String resultPath = UUID.randomUUID().toString();
        resultPath = DesensConstant.TEMPDIR + File.separator + resultPath + File.separator;
        try {
            int signSize;
            try {
                ZipUtil.unzip(zipPkgFile.getAbsolutePath(), resultPath, password);
            }
            catch (ZipException ex) {
                throw new BusinessException("zip file is error : " + ex.getMessage());
            }
            String pkgInfoJsonPath = "";
            String pkgExtInfoJsonPath = "";
            File unzipFiles = new File(resultPath);
            String jsonRootPath = "";
            for (File file : unzipFiles.listFiles()) {
                if (!file.isDirectory() || !new File((jsonRootPath = resultPath + file.getName() + File.separator) + "cappackageinfo.json").exists() || !new File(jsonRootPath + "extension.json").exists()) continue;
                pkgInfoJsonPath = jsonRootPath + "cappackageinfo.json";
                pkgExtInfoJsonPath = jsonRootPath + "extension.json";
                break;
            }
            if (pkgExtInfoJsonPath == "" || pkgInfoJsonPath == "") {
                throw new BusinessException("json files is not founded:");
            }
            String signInfDirPath = unZipFile.getAbsolutePath() + File.separator + "SIGN-INF" + File.separator;
            String pkgFuzzyKeyPath = signInfDirPath + "fuzzy.sign.checksum.cer1";
            String certFilePath = signInfDirPath + "cer.cer";
            if (!new File(certFilePath).exists()) {
                throw new BusinessException("Cert file : cer.cer is not exist !");
            }
            Map<String, Object> signedMapFromJson = null;
            try {
                signedMapFromJson = FuzzyPkgUtils.genFuzzyInfoBeforSign(pkgInfoJsonPath, pkgExtInfoJsonPath, pkgFuzzyKeyPath);
            }
            catch (Exception ex) {
                throw new BusinessException("get sign from json error!", (Throwable)ex);
            }
            String signInfFilePath = "";
            try {
                signInfFilePath = unZipFile.getCanonicalPath() + File.separator + "SIGN-INF";
            }
            catch (IOException ex) {
                throw new BusinessException("Desens package file does not exist : " + ex.getMessage());
            }
            String fuzzySignChecksumFilePath = signInfFilePath + File.separator + "fuzzy.sign.checksum.cer1";
            String fuzzyPkgDescFilePath = signInfFilePath + File.separator + "fuzzy.pkg.desc";
            File fuzzySignChecksumFile = new File(fuzzySignChecksumFilePath);
            File fuzzyPkgDescFile = new File(fuzzyPkgDescFilePath);
            if (!fuzzySignChecksumFile.exists() || !fuzzyPkgDescFile.exists()) {
                throw new BusinessException("Desens package does not contain the following files : " + fuzzyPkgDescFilePath + ";" + fuzzySignChecksumFilePath);
            }
            Map<String, String> signedMapFromFile = null;
            try {
                signedMapFromFile = FuzzyPkgUtils.getSignMapFromSyzPackageSignFile(fuzzySignChecksumFilePath);
            }
            catch (Exception ex) {
                throw new BusinessException("get sign from pkg file error : " + fuzzySignChecksumFilePath, (Throwable)ex);
            }
            int n = signSize = signedMapFromJson == null ? 0 : signedMapFromJson.keySet().size();
            if (signSize == 0) {
                throw new BusinessException("get sign from json error! The count of key is Zero!");
            }
            for (Map.Entry<String, Object> entry : signedMapFromJson.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                if (!signedMapFromFile.containsKey(key)) {
                    throw new BusinessException("The package sign file does not contain the  key : " + key);
                }
                String signedValue = signedMapFromFile.get(key);
                try {
                    byte[] valueBytes = value.getBytes("utf-8");
                    if (CertificateUtils.verifySign(valueBytes, signedValue, certFilePath)) continue;
                    throw new BusinessException("Vertify sign is false!");
                }
                catch (Exception ex) {
                    throw new BusinessException("Vertify sign is error!");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                File workFile = new File(resultPath);
                if (workFile.exists()) {
                    FuzzyUtils.delDir(resultPath);
                    workFile.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, String> getMapFromPropertiesFile(String path) throws Exception {
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(path));
        properties.load(bufferedReader);
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return map;
    }
}

