/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.utils;

import com.seeyon.cap4.desensitization.utils.ValidateAndHash;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class FuzzyUtils {
    private static final String CORPID = "CorpId";
    private static final String ID = "Id";
    private static final String HASH = "Hash";
    private static final String ZIPDIGEST = "ZipDigest";
    private static final String VERSION = "Version";
    private static final String RESIGN_PKG_TYPE = "ResignedPkgType";
    private static final String KEY = "Key";
    private static final String SIGN = "Sign";
    private static final String APPVER = "AppVer";
    public static final String PKG_CREATOR_B = "Creator";
    public static final String PKG_CREATE_ORG_NAME_B = "CreateOrgName";

    public static String genSignManifestContentExcludeSign(Map<String, String> manifestMap) {
        String corpid = manifestMap.get(CORPID);
        String id = manifestMap.get(ID);
        String hash = manifestMap.get(HASH);
        String zipdigest = manifestMap.get(ZIPDIGEST);
        String verison = manifestMap.get(VERSION);
        String appVerison = manifestMap.get(APPVER);
        String resignPkgTyep = manifestMap.get(RESIGN_PKG_TYPE);
        String key = manifestMap.get(KEY);
        String separator = "##";
        StringBuffer sbManifest = new StringBuffer();
        sbManifest.append(corpid).append(separator).append(id).append(separator).append(hash).append(separator).append(zipdigest).append(separator).append(verison).append(separator).append(appVerison).append(separator).append(resignPkgTyep).append(separator).append(key);
        return sbManifest.toString();
    }

    public static String genMainfestFileContent(Map<String, String> manifestMap) {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\r\n";
        }
        String corpid = manifestMap.get(CORPID);
        String id = manifestMap.get(ID);
        String hash = manifestMap.get(HASH);
        String zipdigest = manifestMap.get(ZIPDIGEST);
        String verison = manifestMap.get(VERSION);
        String appVerison = manifestMap.get(APPVER);
        String resignPkgTyep = manifestMap.get(RESIGN_PKG_TYPE);
        String key = manifestMap.get(KEY);
        String creator = manifestMap.get(PKG_CREATOR_B);
        String createOrgName = manifestMap.get(PKG_CREATE_ORG_NAME_B);
        String sign = manifestMap.get(SIGN);
        StringBuffer sbManifest = new StringBuffer();
        sbManifest.append("CorpId:" + corpid).append(lineSeparator).append("Id:" + id).append(lineSeparator).append("Hash:" + hash).append(lineSeparator).append("ZipDigest:" + zipdigest).append(lineSeparator).append("Version:" + verison).append(lineSeparator).append("AppVer:" + appVerison).append(lineSeparator).append("ResignedPkgType:" + resignPkgTyep).append(lineSeparator).append("Key:" + key).append(lineSeparator).append("Creator:" + creator).append(lineSeparator).append("CreateOrgName:" + createOrgName).append(lineSeparator).append("Sign:" + sign).append(lineSeparator);
        return sbManifest.toString();
    }

    public static String getPkgBizTotalInfo(String path) throws Exception {
        BufferedReader reader = null;
        LinkedHashMap<String, String> totalInfoMap = new LinkedHashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        String separator = "##";
        try {
            reader = new BufferedReader(new FileReader(path));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] vals = line.split("=");
                if (vals[0].equals("FormTotal")) {
                    totalInfoMap.put("FormTotal", vals[1]);
                } else if (vals[0].equals("FieldTotal")) {
                    totalInfoMap.put("FieldTotal", vals[1]);
                } else if (vals[0].equals("ViewTotal")) {
                    totalInfoMap.put("ViewTotal", vals[1]);
                }
                if (totalInfoMap.keySet().size() != 3) continue;
                break;
            }
        }
        catch (Exception ex) {
            throw new Exception("Read fuzzy.pkg.desc file is error : " + path);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new Exception("Close manifest file is error : " + path);
                }
            }
        }
        if (totalInfoMap.keySet().size() != 3) {
            throw new Exception("The count of manifest element is not equal 3  : " + path);
        }
        sb.append((String)totalInfoMap.get("FormTotal")).append(separator).append((String)totalInfoMap.get("FieldTotal")).append(separator).append((String)totalInfoMap.get("ViewTotal"));
        return sb.toString();
    }

    public static Map<String, Object> appendFuzzyKeyFuzzySignChecksumMap(Map<String, Object> map, String fuzzyKey) {
        LinkedHashMap<String, Object> signedMap = new LinkedHashMap<String, Object>();
        for (String key : map.keySet()) {
            String value = map.get(key).toString();
            value = value + fuzzyKey;
            signedMap.put(key, value);
        }
        return signedMap;
    }

    public static void writeToFuzzySignChecksumFile(Map<String, Object> fuzzSignMap, String path) throws Exception {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\r\n";
        }
        StringBuffer sb = new StringBuffer();
        for (String key : fuzzSignMap.keySet()) {
            sb.append(key).append("=").append(fuzzSignMap.get(key)).append(lineSeparator);
        }
        FuzzyUtils.writeFile(path, sb.toString(), "UTF-8", false);
    }

    public static void delDir(String filepath) throws IOException {
        File f = new File(filepath);
        if (f.exists() && f.isDirectory()) {
            if (f.listFiles().length == 0) {
                f.delete();
            } else {
                File[] delFile = f.listFiles();
                int i = f.listFiles().length;
                for (int j = 0; j < i; ++j) {
                    if (delFile[j].isDirectory()) {
                        FuzzyUtils.delDir(delFile[j].getAbsolutePath());
                    }
                    delFile[j].delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String filepath, String content, String enc, boolean append) throws Exception {
        OutputStream out = null;
        PrintWriter printwriter = null;
        try {
            File outFile = new File(filepath);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            out = new FileOutputStream(filepath, append);
            printwriter = new PrintWriter(new OutputStreamWriter(out, enc));
            printwriter.println(content);
            printwriter.flush();
        }
        finally {
            if (out != null) {
                out.close();
                printwriter.close();
            }
        }
    }

    public static <T> T bytesToObject(byte[] bytes, Class clazz) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object object = ois.readObject();
        return (T)object;
    }

    public static String getFuzzyKey(String fuzzyKeyPath) throws Exception {
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(fuzzyKeyPath));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] vals = line.split("=");
                if (!vals[0].equals("FuzzyKey")) continue;
                String string = vals[1];
                return string;
            }
        }
        catch (Exception ex) {
            throw new Exception("Read fuzzy.pkg.desc file is error : " + fuzzyKeyPath);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new Exception("Close manifest file is error : " + fuzzyKeyPath);
                }
            }
        }
        return "";
    }

    public static Map<String, Object> signFuzzySignChecksumMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> signedMap = new LinkedHashMap<String, Object>();
        for (String key : map.keySet()) {
            String value = map.get(key).toString();
            value = ValidateAndHash.getDigest(value);
            signedMap.put(key, value);
        }
        return signedMap;
    }
}

