/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import sun.nio.ch.FileChannelImpl;

public class ValidateAndHash {
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String STRING_CHARSET = "utf-8";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String shaHashCode(File file) throws Exception {
        FileInputStream in = null;
        AbstractInterruptibleChannel ch = null;
        String result = "";
        try {
            in = new FileInputStream(file);
            ch = in.getChannel();
            MappedByteBuffer buffer = ((FileChannel)ch).map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            result = ValidateAndHash.shaHashCode(buffer);
            Method m = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            m.setAccessible(true);
            m.invoke(FileChannelImpl.class, buffer);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != ch) {
                ch.close();
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return result;
    }

    private static String shaHashCode(ByteBuffer buffer) throws Exception {
        String s = "";
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(buffer);
        byte[] tmp = md.digest();
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
            str[k++] = HEX_DIGITS[byte0 & 0xF];
        }
        s = new String(str);
        return s;
    }

    public static String makeDigest(File originZipFile) throws Exception {
        ZipFile file = new ZipFile(originZipFile);
        StringBuilder buf = new StringBuilder();
        List lst = file.getFileHeaders();
        for (FileHeader fh : lst) {
            buf.append(fh.getCrc32());
        }
        String digest = ValidateAndHash.getDigest(buf.toString());
        return digest;
    }

    public static String getDigest(String param) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            md.update(param.getBytes(STRING_CHARSET));
            byte[] digest = md.digest();
            return ValidateAndHash.to64String(digest);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized String to64String(byte[] data) {
        Base64 base64 = new Base64();
        return base64.encodeAsString(data);
    }

    public static boolean vertifySign(String origMsg, String base64Sign, PublicKey pk, String sigAlgName) throws Exception {
        byte[] origBytes = origMsg.getBytes(STRING_CHARSET);
        byte[] signBytes = Base64.decodeBase64((String)base64Sign);
        Signature signature = Signature.getInstance(sigAlgName);
        signature.initVerify(pk);
        signature.update(origBytes);
        return signature.verify(signBytes);
    }

    public boolean vertifySign(String origMsg, String base64Sign, PublicKey pk) throws Exception {
        return ValidateAndHash.vertifySign(origMsg, base64Sign, pk, SIGNATURE_ALGORITHM);
    }
}

