/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.desensitization.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class ZipUtil {
    public static void zip(File directory, File target, String password, boolean isIncludeCurrentDirectory) throws ZipException {
        ZipFile zipFile = new ZipFile(target);
        ZipParameters parameters = ZipUtil.initZipParameters(password);
        if (isIncludeCurrentDirectory) {
            if (directory.isDirectory()) {
                zipFile.addFolder(directory, parameters);
            } else {
                zipFile.addFile(directory, parameters);
            }
        } else {
            ArrayList<File> l = new ArrayList<File>();
            File[] fl = directory.listFiles();
            if (fl != null && fl.length > 0) {
                for (File file2 : fl) {
                    l.add(file2);
                }
            }
            ZipUtil.zip(l, target, password);
        }
    }

    public static void zip(Collection<File> files, File target, String password) throws ZipException {
        ZipFile zipFile = new ZipFile(target);
        ZipParameters parameters = ZipUtil.initZipParameters(password);
        for (File file : files) {
            if (file.isDirectory()) {
                zipFile.addFolder(file, parameters);
                continue;
            }
            zipFile.addFile(file, parameters);
        }
    }

    private static ZipParameters initZipParameters(String password) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setEncryptFiles(false);
        if (password != null && !password.equals("")) {
            parameters.setEncryptFiles(true);
        }
        parameters.setEncryptionMethod(0);
        parameters.setPassword(password);
        return parameters;
    }

    public static void unzip(String zipFileName, String dir, String password) throws ZipException {
        ZipFile zipFile = new ZipFile(zipFileName);
        if (!zipFile.isValidZipFile()) {
            throw new ZipException("invalid zip file!");
        }
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String basePath = directory.getAbsolutePath();
        if (zipFile.isEncrypted()) {
            zipFile.setPassword(password);
        }
        zipFile.extractAll(basePath);
    }

    public static void addFile(String srczipFile, String addfile) throws Exception {
        ZipFile zip = new ZipFile(srczipFile);
        ZipParameters para = new ZipParameters();
        FileInputStream fis = new FileInputStream(addfile);
        String fileName = new File(addfile).getName();
        System.out.println(fileName);
        para.setFileNameInZip(fileName);
        para.setSourceExternalStream(true);
        zip.addStream((InputStream)fis, para);
        fis.close();
        System.out.println("\u6dfb\u52a0\u6210\u529f\uff01");
    }
}

