/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.api.libra;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.api.LibraCAP4Service;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.ImpResultBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerFireEvent;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.content.mainbody.CtpContentAllBean;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.content.mainbody.MainbodyStatus;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.form.api.libra.ConvertFieldKey;
import com.seeyon.ctp.form.api.libra.FormDataPO;
import com.seeyon.ctp.form.api.libra.ResultInfo;
import com.seeyon.ctp.form.api.libra.TableDataBean;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.principal.NoSuchPrincipalException;
import com.seeyon.ctp.organization.principal.PrincipalManager;
import com.seeyon.ctp.services.ErrorServiceMessage;
import com.seeyon.ctp.services.ServiceException;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class LibraCAP4ServiceImpl
implements LibraCAP4Service {
    private CAP4FormDataDAO cap4FormDataDAO = null;
    private FormApi4Cap4 formApi4Cap4 = null;
    private PrincipalManager principalManager = (PrincipalManager)AppContext.getBean((String)"principalManager");
    private OrgManager orgManager = null;
    private static final Log LOGGER = CtpLogFactory.getLog(LibraCAP4ServiceImpl.class);

    public CAP4FormDataDAO getCap4FormDataDAO() {
        if (this.cap4FormDataDAO == null) {
            this.cap4FormDataDAO = (CAP4FormDataDAO)AppContext.getBean((String)"cap4FormDataDAO");
        }
        return this.cap4FormDataDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public OrgManager getOrgManager() {
        if (this.orgManager == null) {
            this.orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        }
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public PrincipalManager getPrincipalManager() {
        if (this.principalManager == null) {
            this.principalManager = (PrincipalManager)AppContext.getBean((String)"principalManager");
        }
        return this.principalManager;
    }

    public void setPrincipalManager(PrincipalManager principalManager) {
        this.principalManager = principalManager;
    }

    public String saveOrUpdateUnFlow(FormDataPO formDataPO) {
        this.checkInterFaceRole("");
        this.checkUserRole("");
        ResultInfo returnMessage = new ResultInfo();
        int successCount = 0;
        int errCount = 0;
        HashMap<String, Object> returnInfo = new HashMap<String, Object>();
        HashMap<String, String> err = new HashMap<String, String>();
        ArrayList<FormDataMasterBean> addList = new ArrayList<FormDataMasterBean>();
        ArrayList<FormDataMasterBean> updateList = new ArrayList<FormDataMasterBean>();
        Object ctpContentAll = null;
        Object ctpContentAllBean = null;
        MainbodyService mainBodyService = MainbodyService.getInstance();
        FormBean formBean = null;
        try {
            formBean = this.formApi4Cap4.getFormByFormCode(formDataPO.getCode());
        }
        catch (BusinessException e) {
            err.put("errMsg", "\u6ca1\u627e\u5230\u7f16\u53f7[" + formDataPO.getCode() + "]\u7684\u8868\u5355\uff0c\u8bf7\u68c0\u67e5!");
            return JSONUtil.toJSONString(err);
        }
        List<String> check = this.checkParm(formDataPO, formBean);
        if (check != null && check.size() > 0) {
            err.put("errMsg", check.get(0));
            return JSONUtil.toJSONString(err);
        }
        FormViewBean tempFormViewBean = (FormViewBean)formBean.getFormViewList().get(0);
        List addAuths = tempFormViewBean.getFormAuthViewBeanListByType(Enums.FormAuthorizationType.add);
        String rightid = String.valueOf(((FormAuthViewBean)addAuths.get(0)).getId());
        List t = formDataPO.getDatas();
        formDataPO.setRightId(rightid);
        String isInit = returnMessage.initResult(formDataPO);
        if (isInit != null) {
            err.put("errMsg", isInit);
            return JSONUtil.toJSONString(err);
        }
        for (int i = 0; i < t.size(); ++i) {
            FormDataMasterBean formDataMasterBean;
            HashMap mainData = new HashMap();
            Map subDatas = new HashMap();
            TableDataBean data = (TableDataBean)t.get(i);
            Map mainTemp = data.getMainData();
            data = (TableDataBean)t.get(i);
            subDatas = data.getSubData();
            HashMap<String, String> t1 = new HashMap<String, String>();
            ArrayList<Map<String, String>> t2 = new ArrayList<Map<String, String>>();
            for (Map m : mainTemp.values()) {
                mainData.putAll(m);
            }
            for (String key : mainData.keySet()) {
                t1.put(key, String.valueOf(mainData.get(key)));
            }
            if (subDatas != null && subDatas.size() > 0) {
                for (List sub : subDatas.values()) {
                    for (Map s : sub) {
                        HashMap<String, String> t3 = new HashMap<String, String>();
                        for (String m : s.keySet()) {
                            t3.put(m, String.valueOf(s.get(m)));
                        }
                        t2.add(t3);
                    }
                }
            }
            if ((formDataMasterBean = this.getMasterData(formBean, data, returnMessage, addList, updateList)) == null) continue;
            boolean isValtie = false;
            try {
                isValtie = this.checkInputData(formBean, -1L, Long.parseLong(rightid), t1, t2, -1L, formDataPO.isDisplayName());
            }
            catch (Exception e) {
                returnMessage.putErrMessage(data, e.getMessage());
                this.removeFormData(addList, updateList, formDataMasterBean);
                continue;
            }
            if (!isValtie) {
                returnMessage.putErrMessage(data, "\u83b7\u53d6formbean\u4e3a\u7a7a");
                this.removeFormData(addList, updateList, formDataMasterBean);
                continue;
            }
            ArrayList<FormDataMasterBean> formDataMasterBeans = new ArrayList<FormDataMasterBean>();
            formDataMasterBeans.add(formDataMasterBean);
            String isValidate = null;
            try {
                isValidate = this.formApi4Cap4.validateDataUnique(formBean, formDataMasterBeans);
            }
            catch (SQLException e) {
                returnMessage.putErrMessage(data, e.getMessage());
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.removeFormData(addList, updateList, formDataMasterBean);
                continue;
            }
            catch (BusinessException e) {
                returnMessage.putErrMessage(data, e.getMessage());
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.removeFormData(addList, updateList, formDataMasterBean);
                continue;
            }
            if (Strings.isNotBlank((String)isValidate)) {
                returnMessage.putErrMessage(data, "\u6570\u636e\u8fdd\u53cd\u552f\u4e00\u6807\u8bc6");
                this.removeFormData(addList, updateList, formDataMasterBean);
                continue;
            }
            if (!formDataPO.isCalc()) continue;
            try {
                this.formApi4Cap4.calcAll(formBean, formDataMasterBean, formBean.getNewFormAuthViewBean(), true, formDataPO.isSn(), formDataPO.isRelation(), true);
                AppContext.removeThreadContext((String)"fieldChangeTag");
                continue;
            }
            catch (BusinessException e) {
                returnMessage.putErrMessage(data, "\u8ba1\u7b97\u5173\u8054\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.removeFormData(addList, updateList, formDataMasterBean);
            }
        }
        returnMessage = this.saveFormData(formBean, addList, updateList, returnMessage, formDataPO);
        returnInfo.put("successINFO", returnMessage.getSuccess());
        returnInfo.put("errorINFO", returnMessage.getErr());
        if (null != returnMessage.getSuccess() && returnMessage.getSuccess().size() > 0) {
            for (List s : returnMessage.getSuccess().values()) {
                successCount += s.size();
            }
        }
        if (null != returnMessage.getErr() && returnMessage.getErr().size() > 0) {
            for (List s : returnMessage.getErr().values()) {
                errCount += s.size();
            }
        }
        returnInfo.put("message", "\u6570\u636e\u6267\u884c\u6210\u529f\uff1a" + successCount + " \u6761\uff0c\u6570\u636e\u6267\u884c\u5931\u8d25\uff1a " + errCount + " \u6761");
        returnMessage.getErrMsg().addAll(err.values());
        returnInfo.put("errMsg", returnMessage.getErrMsg());
        return JSONUtil.toJSONString(returnInfo);
    }

    private void removeFormData(List<FormDataMasterBean> addList, List<FormDataMasterBean> updateList, FormDataMasterBean formDataMasterBean) {
        if (addList.contains(formDataMasterBean)) {
            addList.remove(formDataMasterBean);
        } else if (updateList.contains(formDataMasterBean)) {
            updateList.remove(formDataMasterBean);
        }
    }

    private List<String> checkParm(FormDataPO formDataPO, FormBean formBean) {
        ArrayList<String> err = new ArrayList<String>();
        if (formDataPO == null || formDataPO.getCondition() == null) {
            err.add("\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a");
            return err;
        }
        long userid = 0L;
        try {
            userid = this.principalManager.getMemberIdByLoginName(formDataPO.getUserName());
            formDataPO.setUserId(userid);
        }
        catch (NoSuchPrincipalException e) {
            err.add("A8\u767b\u5f55\u540d[" + formDataPO.getUserName() + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
            return err;
        }
        if (formBean == null) {
            err.add("\u6839\u636e\u7f16\u53f7\u6ca1\u6709\u627e\u5230\u8868\u5355!");
            return err;
        }
        if (formBean.getFormViewList() == null || formBean.getFormViewList().size() == 0) {
            err.add("\u65e0\u89c6\u56fe\u6743\u9650");
            return err;
        }
        boolean isAuth = false;
        try {
            isAuth = this.checkAuth(formBean.getBind().getUnFlowTemplateMap(), userid, formBean);
        }
        catch (ServiceException e) {
            err.add("\u6821\u9a8c\u6743\u9650\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7!");
            return err;
        }
        catch (BusinessException e) {
            err.add("\u7528\u6237\u65e0\u65b0\u5efa\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
            return err;
        }
        return err;
    }

    private void doTrigger(FormBean formBean, FormDataMasterBean formDataMasterBean) {
        Enums.FormType formTypeArg = Enums.FormType.getEnumByKey((int)formBean.getFormType());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("current_user_id", AppContext.currentUserId());
        map.put("formId", formBean.getId());
        map.put("current_user_id", AppContext.currentUserId());
        CAP4FormTriggerFireEvent event = new CAP4FormTriggerFireEvent((Object)this);
        event.setModuleType(Integer.valueOf(formTypeArg.getModuleType().getKey()));
        event.setModuleId(formDataMasterBean.getId());
        event.setMasterId(formDataMasterBean.getId());
        event.setParam(map);
        EventDispatcher.fireEventAfterCommit((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInfo saveFormData(FormBean formBean, List<FormDataMasterBean> addList, List<FormDataMasterBean> updateList, ResultInfo returnMessage, FormDataPO formDataPO) {
        Map conditions = formDataPO.getCondition();
        long userid = formDataPO.getUserId();
        String rightid = formDataPO.getRightId();
        ArrayList<String> errMsg = new ArrayList<String>();
        Connection con = null;
        try {
            int i;
            String mainTableName;
            if (null != addList) {
                con = JDBCAgent.getRawConnection();
                con.setAutoCommit(false);
                for (FormDataMasterBean formDataMasterBean : addList) {
                    mainTableName = formDataMasterBean.getFormTable().getTableName();
                    boolean isSave = this.insertMainData(formDataMasterBean.getFormTable(), formDataMasterBean.getRowData(), con, returnMessage, formDataPO.isDisplayName());
                    if (!isSave) continue;
                    i = 0;
                    for (String tableName : formDataMasterBean.getSubTables().keySet()) {
                        ArrayList<Map<String, Object>> subDataList = new ArrayList<Map<String, Object>>();
                        ++i;
                        List formDataSubBeans = formDataMasterBean.getSubData(tableName);
                        for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                            if (formDataSubBean.isEmpty()) continue;
                            Map subData = formDataSubBean.getRowData();
                            subDataList.add(subData);
                        }
                        this.insertIntoTable(formBean.getTableByTableName(tableName), subDataList, con, returnMessage, formDataPO.isDisplayName());
                    }
                    if (i <= 200) continue;
                    con.commit();
                    i = 0;
                }
                con.commit();
                con.close();
            }
            if (null != updateList) {
                con = JDBCAgent.getRawConnection();
                con.setAutoCommit(false);
                for (FormDataMasterBean formDataMasterBean : updateList) {
                    mainTableName = formDataMasterBean.getFormTable().getTableName();
                    if (null == updateList) continue;
                    ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
                    data.add(formDataMasterBean.getRowData());
                    this.updateDataBatch(formDataMasterBean.getFormTable(), data, (List)returnMessage.getConditions().get(mainTableName), formDataMasterBean.getId(), returnMessage, con, formDataPO.isDisplayName());
                    i = 0;
                    for (String tableName : formDataMasterBean.getSubTables().keySet()) {
                        ++i;
                        FormTableBean subTableBean = formBean.getTableByTableName(tableName);
                        ArrayList<Map<String, Object>> updateSubs = new ArrayList<Map<String, Object>>();
                        ArrayList<Map<String, Object>> insertSubs = new ArrayList<Map<String, Object>>();
                        for (FormDataSubBean formDataSubBean : formDataMasterBean.getSubData(tableName)) {
                            if (formDataSubBean.isEmpty()) continue;
                            Map dataMap = formDataSubBean.getRowData();
                            List addSubs = (List)formDataMasterBean.getExtraAttr("addSub");
                            if (addSubs != null && addSubs.contains(formDataSubBean.getId())) {
                                insertSubs.add(dataMap);
                                continue;
                            }
                            updateSubs.add(dataMap);
                        }
                        this.updateDataBatch(subTableBean, updateSubs, (List)returnMessage.getConditions().get(tableName), formDataMasterBean.getId(), returnMessage, con, formDataPO.isDisplayName());
                        this.insertIntoTable(subTableBean, insertSubs, con, returnMessage, formDataPO.isDisplayName());
                        if (i <= 200) continue;
                        con.commit();
                        i = 0;
                    }
                }
                con.commit();
                con.close();
            }
            addList.addAll(updateList);
            for (FormDataMasterBean formDataMasterBean : addList) {
                CtpContentAll ctpContentAll = null;
                MainbodyService mainBodyService = MainbodyService.getInstance();
                ctpContentAll = mainBodyService.getContent(this.getModuleType(formBean), formDataMasterBean.getId().longValue());
                if (null == ctpContentAll) {
                    ctpContentAll = this.saveContentAllForForm(ctpContentAll, formDataMasterBean.getId(), userid, formBean, rightid);
                    mainBodyService.saveOrUpdateContentAll(ctpContentAll);
                }
                this.doTrigger(formBean, formDataMasterBean);
            }
        }
        catch (SQLException e) {
            errMsg.add("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519");
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            errMsg.add(e.getMessage());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != con && !con.isClosed()) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        errMsg.add("\u94fe\u63a5\u5173\u95ed\u5931\u8d25");
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            returnMessage.getErrMsg().addAll(errMsg);
        }
        return returnMessage;
    }

    private List<Long> getSubData(FormTableBean table, Map<String, Object> data, List<String> conditions) throws BusinessException, SQLException {
        if (data == null || data.size() == 0) {
            return null;
        }
        JDBCAgent jdbcAgent = new JDBCAgent();
        ArrayList<Long> ids = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select  id from ").append(table.getTableName()).append(" where formmain_id= " + data.get("formmain_id"));
        ArrayList values = new ArrayList();
        for (String fieldName : conditions) {
            int i = 1;
            Object value = this.getValue4DB(table, data, fieldName);
            sql.append(" and ").append(fieldName).append(" = '").append(data.get(fieldName)).append("'");
            ++i;
        }
        jdbcAgent.execute(sql.toString());
        ResultSet resultSet = jdbcAgent.getQueryResult();
        while (resultSet.next()) {
            ids = new ArrayList<Long>();
            ids.add(resultSet.getLong(1));
        }
        jdbcAgent.close();
        return ids;
    }

    private CtpContentAll saveContentAllForForm(CtpContentAll ctpContentAll, long masterId, long userid, FormBean formBean, String rightId) throws BusinessException {
        Timestamp timestamp = DateUtil.currentTimestamp();
        if (ctpContentAll != null) {
            ctpContentAll.setModifyId(Long.valueOf(userid));
            ctpContentAll.setModifyDate((java.util.Date)timestamp);
            return ctpContentAll;
        }
        CtpContentAllBean content = new CtpContentAllBean();
        FormBindBean bindBean = formBean.getBind();
        if (bindBean != null) {
            content.setModuleTemplateId(bindBean.getId());
            Map bindAuth = bindBean.getUnFlowTemplateMap();
            if (CollectionUtils.isEmpty(bindAuth.values())) {
                throw new BusinessException("\u65e0\u5e94\u7528\u7ed1\u5b9a");
            }
            for (FormBindAuthBean authBean : bindAuth.values()) {
                content.setTitle(authBean.getName());
            }
        }
        content.setModuleType(Integer.valueOf(this.getModuleType(formBean)));
        content.setCreateId(Long.valueOf(userid));
        content.setCreateDate((java.util.Date)timestamp);
        content.setSort(Integer.valueOf(0));
        content.setId(Long.valueOf(UUIDLong.longUUID()));
        content.setStatus(MainbodyStatus.STATUS_POST_SAVE);
        content.setContentType(Integer.valueOf(MainbodyType.FORM.getKey()));
        content.setContentTemplateId(formBean.getId());
        content.setContentDataId(Long.valueOf(masterId));
        content.setModuleId(Long.valueOf(masterId));
        content.setModifyDate((java.util.Date)timestamp);
        content.setModifyId(Long.valueOf(userid));
        content.setRightId(rightId);
        return content.toContentAll();
    }

    private int getModuleType(FormBean formBean) throws BusinessException {
        boolean moduleType = false;
        Enums.FormType formType = Enums.FormType.getEnumByKey((int)formBean.getFormType());
        if (formType != null) {
            return formType.getModuleType().getKey();
        }
        LOGGER.error((Object)"\u65e0\u6548\u8868\u7c7b\u578b");
        throw new BusinessException("\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25");
    }

    private FormDataMasterBean getMainData(FormBean formBean, Map<String, Object> data, ResultInfo resultInfo) throws SQLException, BusinessException {
        if (data == null || data.size() == 0) {
            resultInfo.setNullCount(1);
            throw new BusinessException("\u4e3b\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        HashMap<String, Object> t = new HashMap<String, Object>(data);
        resultInfo.mergeResultData((List)resultInfo.getConditions().get(formBean.getMasterTableBean().getTableName()), t);
        FormDataMasterBean formDataMasterBean = this.selectDataByMasterFields(formBean, t);
        return formDataMasterBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDataMasterBean selectDataByMasterFields(FormBean formBean, Map<String, Object> masterRealFieldMap) throws BusinessException, SQLException {
        if (null == masterRealFieldMap || masterRealFieldMap.isEmpty()) {
            throw new BusinessException("\u66f4\u65b0\u65e0\u6d41\u7a0b\u8868\u5355\u6570\u636e-\u67e5\u8be2\u4e3b\u8868\u6570\u636e\u9519\u8bef\uff1a\u6ca1\u6709\u6307\u5b9a\u4e3b\u8868\u5b57\u6bb5,\u65e0\u6cd5\u67e5\u8be2");
        }
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        String tableName = masterTableBean.getTableName();
        StringBuilder sql = new StringBuilder("select * from ").append(tableName).append(" where 1 = 1");
        for (Map.Entry<String, Object> entry : masterRealFieldMap.entrySet()) {
            sql.append(" and ").append(entry.getKey()).append(" = '").append(entry.getValue()).append("'");
        }
        sql.append(" order by sort asc");
        JDBCAgent jdbc = new JDBCAgent();
        List dataList = null;
        try {
            jdbc.execute(sql.toString());
            dataList = jdbc.resultSetToList();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        FormDataMasterBean formDataMasterBean = null;
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        if (null != dataList && dataList.size() != 1) {
            throw new BusinessException("\u66f4\u65b0\u65e0\u6d41\u7a0b\u8868\u5355-\u67e5\u8be2\u4e3b\u8868\u6570\u636e\u4e0d\u552f\u4e00");
        }
        formDataMasterBean = new FormDataMasterBean((Map)dataList.get(0), masterTableBean, new boolean[0]);
        return formDataMasterBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoTable(FormTableBean table, List<Map<String, Object>> dataList, Connection con, ResultInfo resultInfo, boolean isDisplay) throws SQLException {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        StringBuilder fieldNames = new StringBuilder("");
        StringBuilder ps = new StringBuilder("");
        Map<String, Object> rowDataMap = dataList.get(0);
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, Object> map : dataList) {
            keys.addAll(map.keySet());
        }
        int count = 0;
        for (String string : keys) {
            ++count;
            String fieldName = string;
            fieldNames.append(fieldName).append(",");
            ps.append("?").append(",");
        }
        fieldNames = new StringBuilder(fieldNames.substring(0, fieldNames.length() - 1));
        ps = new StringBuilder(ps.substring(0, ps.length() - 1));
        String string = "insert into " + table.getTableName() + " (" + fieldNames.toString() + ") values (" + ps.toString() + ")";
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> errList = new ArrayList<Map<String, Object>>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(string);
            for (int i = 0; i < dataList.size(); ++i) {
                successList.add(rowDataMap);
                rowDataMap = dataList.get(i);
                int index = 1;
                for (String string2 : keys) {
                    Object value = this.getValue4DB(table, rowDataMap, string2);
                    if (value != null && value instanceof java.util.Date && !(value instanceof Date)) {
                        value = new Timestamp(((java.util.Date)value).getTime());
                    }
                    preparedStatement.setObject(index, value);
                    ++index;
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e) {
            successList.remove(rowDataMap);
            rowDataMap.put("errMsg", "\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u53c2\u89c1\u540e\u53f0\u9519\u8bef\u65e5\u5fd7\uff01");
            errList.add(rowDataMap);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        resultInfo.formatResult(table.getTableName(), successList, errList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertMainData(FormTableBean table, Map<String, Object> rowDataMap, Connection con, ResultInfo resultInfo, boolean isDisplay) throws SQLException {
        if (rowDataMap == null || rowDataMap.size() == 0) {
            return false;
        }
        StringBuilder fieldNames = new StringBuilder("");
        StringBuilder ps = new StringBuilder("");
        Set<String> keys = rowDataMap.keySet();
        int count = 0;
        ArrayList t = new ArrayList();
        for (String string : keys) {
            ++count;
            String fieldName = string;
            fieldNames.append(fieldName).append(",");
            ps.append("?").append(",");
        }
        fieldNames = new StringBuilder(fieldNames.substring(0, fieldNames.length() - 1));
        ps = new StringBuilder(ps.substring(0, ps.length() - 1));
        keys.removeAll(t);
        String sql = "insert into " + table.getTableName() + " (" + fieldNames.toString() + ") values (" + ps.toString() + ")";
        ArrayList successList = new ArrayList();
        ArrayList errList = new ArrayList();
        PreparedStatement preparedStatement = null;
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        try {
            preparedStatement = con.prepareStatement(sql);
            int index = 1;
            for (String string : keys) {
                Object value = this.getValue4DB(table, rowDataMap, string);
                rowData.put(string, value);
                if (value != null && value instanceof java.util.Date && !(value instanceof Date)) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
                preparedStatement.setObject(index, value);
                ++index;
            }
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            successList.add(rowData);
        }
        catch (Exception e) {
            successList.remove(rowData);
            rowData.put("errMsg", "\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u53c2\u89c1\u540e\u53f0\u9519\u8bef\u65e5\u5fd7\uff01");
            errList.add(rowData);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        resultInfo.formatResult(table.getTableName(), successList, errList);
        return true;
    }

    private void initResultInfo(ResultInfo resultInfo, String tableName, List<Map<String, Object>> successList, List<Map<String, Object>> errList) {
        HashMap<String, List> s;
        if (null != resultInfo.getSuccess() && resultInfo.getSuccess().get(tableName) != null) {
            successList = (List)resultInfo.getSuccess().get(tableName);
        } else {
            successList = new ArrayList<Map<String, Object>>();
            s = new HashMap<String, List>();
            s.put(tableName, successList);
            resultInfo.setSuccess(s);
        }
        if (null != resultInfo.getErr() && resultInfo.getErr().get(tableName) != null) {
            errList = (List)resultInfo.getErr().get(tableName);
        } else {
            errList = new ArrayList<Map<String, Object>>();
            s = new HashMap();
            s.put(tableName, errList);
            resultInfo.setErr(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> updateDataBatch(FormTableBean table, List<Map<String, Object>> dataList, List<String> conditions, long formMasterId, ResultInfo resultInfo, Connection con, boolean isDisplay) {
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        Map<String, Object> errData = new HashMap<String, String>();
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> errList = new ArrayList<Map<String, Object>>();
        StringBuilder sqls = new StringBuilder();
        Statement preparedStatement = null;
        try {
            Set<String> updateFildes = dataList.get(0).keySet();
            sqls.append("update ").append(table.getTableName()).append(" set ");
            int count = 0;
            ArrayList<String> t = new ArrayList<String>();
            for (String fieldName : updateFildes) {
                ++count;
                FormFieldBean fb = table.getFieldBeanByName(fieldName);
                if (fb == null || fb.isConstantField()) {
                    t.add(fieldName);
                    continue;
                }
                sqls.append(fieldName);
                sqls.append(" = ? ");
                sqls.append(",");
            }
            sqls = new StringBuilder(sqls.substring(0, sqls.length() - 1));
            updateFildes.removeAll(t);
            if (!table.isMainTable()) {
                sqls.append(" where formmain_id = ?");
            } else {
                sqls.append(" where id = ?");
            }
            for (String condiction : conditions) {
                sqls.append(" and ").append(condiction).append(" = ? ");
            }
            preparedStatement = con.prepareStatement(sqls.toString());
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> rowDataMap = dataList.get(i);
                int j = 0;
                for (String string : updateFildes) {
                    Object value = this.getValue4DB(table, rowDataMap, string);
                    preparedStatement.setObject(++j, value);
                }
                preparedStatement.setObject(++j, formMasterId);
                for (String condiction : conditions) {
                    preparedStatement.setObject(++j, this.getValue4DB(table, rowDataMap, condiction));
                }
                errData = rowDataMap;
                successList.add(rowDataMap);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            successList.remove(errData);
            errData.put("errMsg", "\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u53c2\u89c1\u540e\u53f0\u9519\u8bef\u65e5\u5fd7\uff01");
            errList.add(errData);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != preparedStatement) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                resultInfo.setMessage("\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38");
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        resultInfo.formatResult(table.getTableName(), successList, errList);
        return errList;
    }

    private Object getValue4DB(FormTableBean table, Map<String, Object> rowDataMap, String string) {
        Enums.MasterTableField e;
        FormFieldBean field = table.getFieldBeanByName(string);
        if (field == null && (e = Enums.MasterTableField.getEnumByKey((String)string)) != null) {
            field = e.getFormFieldBean();
        }
        Object value = null;
        value = rowDataMap.get(string);
        if (field != null && !StringUtil.checkNull((String)String.valueOf(value))) {
            if (field.getFieldType().equalsIgnoreCase(Enums.FieldType.DATETIME.getKey())) {
                if (value instanceof java.util.Date) {
                    if (field.isConstantField()) {
                        String s = Datetimes.formatNoTimeZone((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                        value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd HH:mm:ss").getTime());
                    } else {
                        String s = Datetimes.formatNoTimeZone((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm");
                        value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd HH:mm").getTime());
                    }
                } else if (value instanceof String) {
                    value = field.isConstantField() ? new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm:ss").getTime()) : new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm").getTime());
                }
            } else if (field.getFieldType().equalsIgnoreCase(Enums.FieldType.TIMESTAMP.getKey())) {
                if (value instanceof java.util.Date) {
                    String s = DateUtil.getDate((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd");
                    value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd").getTime());
                } else if (value instanceof String) {
                    value = new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd").getTime());
                }
            }
        }
        return value;
    }

    private void getSubDatas(FormBean formBean, TableDataBean data, FormDataMasterBean formDataMasterBean, ResultInfo resultInfo, boolean isNew) {
        if (data == null || data.getSubData() == null || data.getSubData().size() == 0) {
            return;
        }
        Map subDataTemp = data.getSubData();
        ArrayList diffDatas = new ArrayList();
        for (String tableName : subDataTemp.keySet()) {
            List tableData = (List)subDataTemp.get(tableName);
            if (tableData == null || tableData.size() == 0) continue;
            for (Map rowData : tableData) {
                if (rowData == null || rowData.size() == 0) {
                    resultInfo.setNullCount(1);
                    continue;
                }
                FormTableBean formTableBean = formBean.getTableByTableName(tableName);
                if (null == formTableBean) {
                    if (resultInfo.isDisplay()) {
                        for (Object key : rowData.keySet()) {
                            rowData.put(((Map)ConvertFieldKey.display2Name.get(tableName)).get(key), rowData.get(key));
                        }
                    }
                    resultInfo.putErrMsg(rowData, "\u672a\u627e\u5230" + tableName, tableName);
                    continue;
                }
                HashMap subData = new HashMap();
                if (resultInfo.isDisplay()) {
                    Object key;
                    key = rowData.keySet().iterator();
                    while (key.hasNext()) {
                        String key2 = (String)key.next();
                        subData.put(((Map)ConvertFieldKey.display2Name.get(tableName)).get(key2), rowData.get(key2));
                    }
                } else {
                    subData.putAll(rowData);
                }
                HashMap diffData = new HashMap(subData);
                resultInfo.mergeResultData((List)resultInfo.getConditions().get(tableName), diffData);
                if (diffDatas == null) {
                    diffDatas.add(diffData);
                } else {
                    if (diffDatas.contains(diffData)) {
                        resultInfo.putErrMsg(subData, "\u51fa\u73b0\u91cd\u590d\u6570\u636e\uff1a" + tableName + subData, tableName);
                        continue;
                    }
                    diffDatas.add(diffData);
                }
                ArrayList sudatas = new ArrayList();
                sudatas.add(subData);
                subData.put(Enums.SubTableField.formmain_id.getKey(), formDataMasterBean.getId());
                FormDataSubBean subBean = null;
                if (isNew) {
                    subBean = new FormDataSubBean(subData, formTableBean, formDataMasterBean, new boolean[]{true});
                    formDataMasterBean.addSubData(tableName, subBean);
                    continue;
                }
                try {
                    HashMap<String, Object> conditionMap = new HashMap<String, Object>(subData);
                    resultInfo.mergeResultData((List)resultInfo.getConditions().get(tableName), conditionMap);
                    subBean = this.selectDataBySlaveFields(formTableBean, formDataMasterBean, tableName, conditionMap);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("\u91cd\u590d\u8868\u67e5\u8be2\u51fa\u9519:" + e.getMessage()));
                    resultInfo.putErrMsg(subData, "\u91cd\u590d\u8868\u67e5\u8be2\u51fa\u9519", tableName);
                    continue;
                }
                catch (BusinessException e) {
                    resultInfo.putErrMsg(subData, e.getMessage(), tableName);
                    continue;
                }
                if (subBean == null) {
                    subBean = new FormDataSubBean(subData, formTableBean, formDataMasterBean, new boolean[]{true});
                    ArrayList<Long> addSubs = (ArrayList<Long>)formDataMasterBean.getExtraAttr("addSub");
                    if (null == addSubs) {
                        addSubs = new ArrayList<Long>();
                    }
                    addSubs.add(subBean.getId());
                    formDataMasterBean.putExtraAttr("addSub", addSubs);
                } else {
                    subBean.addFieldValue(subData);
                }
                formDataMasterBean.addSubData(tableName, subBean);
            }
        }
    }

    private FormDataMasterBean getMasterData(FormBean formBean, TableDataBean data, ResultInfo resultInfo, List<FormDataMasterBean> addList, List<FormDataMasterBean> updateList) {
        FormDataMasterBean formDataMasterBean = null;
        Map rowData = data.getMainData();
        for (String key : rowData.keySet()) {
            Map s = (Map)rowData.get(key);
            if (s == null) {
                resultInfo.setNullCount(1);
                continue;
            }
            HashMap<String, Object> mainData = new HashMap<String, Object>();
            if (resultInfo.isDisplay()) {
                for (String displayName : s.keySet()) {
                    mainData.put((String)((Map)ConvertFieldKey.display2Name.get(formBean.getMasterTableBean().getTableName())).get(displayName), s.get(displayName));
                }
            } else {
                mainData.putAll(s);
            }
            try {
                formDataMasterBean = this.getMainData(formBean, mainData, resultInfo);
            }
            catch (SQLException e) {
                LOGGER.error((Object)("\u4e3b\u8868\u6570\u636e\u67e5\u8be2\u5f02\u5e38" + mainData));
                resultInfo.putErrMessage(data, "\u4e3b\u8868\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
                continue;
            }
            catch (BusinessException e) {
                continue;
            }
            if (formDataMasterBean != null) {
                formDataMasterBean.addFieldValue(mainData);
                String tableName = formDataMasterBean.getFormTable().getTableName();
                this.getSubDatas(formBean, data, formDataMasterBean, resultInfo, false);
                updateList.add(formDataMasterBean);
            } else {
                formDataMasterBean = new FormDataMasterBean(mainData, formBean.getMasterTableBean(), new boolean[]{true});
                this.getSubDatas(formBean, data, formDataMasterBean, resultInfo, true);
                formDataMasterBean.setConstantFieldValue();
                formDataMasterBean.setStartMemberId(resultInfo.getUserId());
                formDataMasterBean.putExtraAttr("isNew", true);
                addList.add(formDataMasterBean);
            }
            Map<String, Map<String, Boolean>> changeTag = this.getUpdateFields(formDataMasterBean, mainData);
            AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
        }
        if (resultInfo.isSn()) {
            formDataMasterBean.putExtraAttr("needProduceValue", "true");
        }
        return formDataMasterBean;
    }

    private Map<String, Map<String, Boolean>> getUpdateFields(FormDataMasterBean formDataMasterBean, Map<String, Object> mainData) {
        HashMap<String, Map<String, Boolean>> changeTag = new HashMap<String, Map<String, Boolean>>();
        for (String mainKey : formDataMasterBean.getRowData().keySet()) {
            FormFieldBean fb = null;
            try {
                fb = formDataMasterBean.getFieldBeanByFieldName(mainKey);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e);
            }
            if (null == fb || fb.isConstantField()) continue;
            HashMap<String, Boolean> t = new HashMap<String, Boolean>();
            t.put(mainKey, true);
            if (changeTag.get(formDataMasterBean.getFormTable().getTableName()) != null) {
                ((Map)changeTag.get(formDataMasterBean.getFormTable().getTableName())).putAll(t);
                continue;
            }
            changeTag.put(formDataMasterBean.getFormTable().getTableName(), t);
        }
        if (null != formDataMasterBean.getSubTables()) {
            for (String tableName : formDataMasterBean.getSubTables().keySet()) {
                for (FormDataSubBean formDataSubBean : (List)formDataMasterBean.getSubTables().get(tableName)) {
                    if (formDataSubBean.getRowData().isEmpty()) continue;
                    for (String subFidle : formDataSubBean.getRowData().keySet()) {
                        FormFieldBean fb = null;
                        try {
                            fb = formDataMasterBean.getFieldBeanByFieldName(subFidle);
                        }
                        catch (BusinessException e) {
                            LOGGER.error((Object)e);
                        }
                        if (null == fb || fb.isConstantField()) continue;
                        HashMap<String, Boolean> t = new HashMap<String, Boolean>();
                        String fieldName = subFidle + "_" + formDataSubBean.getId();
                        t.put(fieldName, true);
                        if (changeTag.get(formDataSubBean.getFormTable().getTableName()) != null) {
                            ((Map)changeTag.get(formDataSubBean.getFormTable().getTableName())).putAll(t);
                            continue;
                        }
                        changeTag.put(formDataSubBean.getFormTable().getTableName(), t);
                    }
                }
            }
        }
        return changeTag;
    }

    private boolean checkAuth(Map<String, FormBindAuthBean> bindAuth, long userid, FormBean formBean) throws ServiceException, BusinessException {
        boolean checkPass = false;
        long authOperationId = -1L;
        for (FormBindAuthBean authBean : bindAuth.values()) {
            if (checkPass) break;
            if (formBean.getFormType() != Enums.FormType.unFlowForm.getKey()) continue;
            checkPass = authBean.checkRight(userid);
        }
        if (!checkPass) {
            throw new ServiceException(ErrorServiceMessage.formImportServiceAuth.getErroCode(), ErrorServiceMessage.formImportServiceAuth.getValue());
        }
        return checkPass;
    }

    private Object formatFieldDBValue(Map<String, Object> rowDataMap, String string, FormFieldBean field) {
        Enums.MasterTableField e;
        if (field == null && (e = Enums.MasterTableField.getEnumByKey((String)string)) != null) {
            field = e.getFormFieldBean();
        }
        Object value = rowDataMap.get(string);
        if (field != null && !StringUtil.checkNull((String)String.valueOf(value))) {
            if (field.getFieldType().equalsIgnoreCase(Enums.FieldType.DATETIME.getKey())) {
                if (value instanceof java.util.Date) {
                    if (field.isConstantField()) {
                        String s = Datetimes.formatNoTimeZone((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                        value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd HH:mm:ss").getTime());
                    } else {
                        String s = Datetimes.formatNoTimeZone((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm");
                        value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd HH:mm").getTime());
                    }
                } else if (value instanceof String) {
                    value = field.isConstantField() ? new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm:ss").getTime()) : new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm").getTime());
                }
            } else if (field.getFieldType().equalsIgnoreCase(Enums.FieldType.TIMESTAMP.getKey())) {
                if (value instanceof java.util.Date) {
                    String s = DateUtil.getDate((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd");
                    value = new Timestamp(Datetimes.parseNoTimeZone((String)s, (String)"yyyy-MM-dd").getTime());
                } else if (value instanceof String) {
                    value = new Timestamp(Datetimes.parseNoTimeZone((String)String.valueOf(value), (String)"yyyy-MM-dd").getTime());
                }
            }
        }
        return value;
    }

    private boolean checkInputData(FormBean fb, long viewId, long operationId, Map<String, String> masterNameValues, List<Map<String, String>> slaveNameValues, long id, boolean isDisplay) throws BusinessException {
        if (fb == null) {
            return false;
        }
        StringBuilder errorMsg = new StringBuilder();
        FormAuthViewBean auth = fb.getAuthViewBeanById(Long.valueOf(operationId));
        String masterError = this.checkMapInputDate(fb, masterNameValues, auth, id, false, isDisplay);
        if (Strings.isNotBlank((String)masterError) && errorMsg.toString().indexOf(masterError) == -1) {
            errorMsg.append(masterError);
        }
        if (slaveNameValues != null) {
            for (Map<String, String> map : slaveNameValues) {
                String error = this.checkMapInputDate(fb, map, auth, id, true, isDisplay);
                if (!Strings.isNotBlank((String)error) || errorMsg.toString().indexOf(error) != -1) continue;
                errorMsg.append(error);
            }
        }
        if (errorMsg.length() > 0) {
            LOGGER.error((Object)("\u6821\u9a8c\u6570\u636e\u51fa\u9519:" + errorMsg.toString()));
            throw new BusinessException("\u6821\u9a8c\u6570\u636e\u51fa\u9519:" + errorMsg.toString());
        }
        return true;
    }

    private String checkMapInputDate(FormBean fb, Map<String, String> map, FormAuthViewBean auth, long id, boolean isSub, boolean isDisplay) throws BusinessException {
        StringBuilder errorMsg = new StringBuilder();
        if (map != null) {
            for (String display : map.keySet()) {
                int fieldLength;
                FormFieldBean ffb = isDisplay ? fb.getFieldBeanByDisplay(display) : fb.getFieldBeanByName(display);
                String data = map.get(display);
                Object objValue = null;
                if (ffb == null) {
                    errorMsg.append(display).append("\u5b57\u6bb5\u4e0d\u5b58\u5728;");
                    continue;
                }
                String res = FormFieldUtil.checkFormat((String)ffb.getInputType(), (String)ffb.getFieldType(), (String)data, (boolean)false);
                if (res != null) {
                    errorMsg.append(display).append(ResourceUtil.getString((String)res)).append(";");
                    continue;
                }
                try {
                    ImpResultBean resultBean = ffb.getValue4Import((Object)data, true);
                    if (null != resultBean) {
                        objValue = resultBean.getResult();
                    }
                }
                catch (Exception e1) {
                    LOGGER.error((Object)("\u67e5\u8be2\u8868\u5355\u503c\u5bfc\u5e38,\u8868\u5355id:" + fb.getId() + " \u5b57\u6bb5\uff1a" + ffb.getName() + " " + ffb.getDisplay() + " \u7c7b\u578b\uff1a" + ffb.getInputType() + " value:" + data), (Throwable)e1);
                }
                if (objValue == null && Strings.isNotBlank((String)data)) {
                    errorMsg.append(display).append("\u5bfc\u5165\u6570\u636e\u5f02\u5e38").append(";");
                    continue;
                }
                if (auth != null) {
                    FormAuthorizationTableBean formAuthorizationTableBean;
                    String tableName;
                    FormTableBean formTableBean;
                    FormAuthViewFieldBean fieldAuth = auth.getFormAuthorizationField(ffb.getName());
                    if (fieldAuth != null && (Enums.FieldAccessType.add.getKey().equalsIgnoreCase(fieldAuth.getAccess()) || Enums.FieldAccessType.edit.getKey().equalsIgnoreCase(fieldAuth.getAccess())) && !fieldAuth.isNull() && Strings.isBlank((String)data)) {
                        errorMsg.append(display).append("\u4e0d\u53ef\u4e3a\u7a7a").append(";");
                        continue;
                    }
                    if (isSub && (formTableBean = fb.getTableByTableName(tableName = ffb.getOwnerTableName())) != null && (formAuthorizationTableBean = auth.getSubTableAuth(formTableBean.getDisplay())) != null && !formAuthorizationTableBean.isAdd()) {
                        errorMsg.append(display).append("\u6240\u5728\u7684\u91cd\u590d\u8868\u4e0d\u5141\u8bb8\u6dfb\u52a0;");
                        break;
                    }
                }
                if (objValue == null) continue;
                String strVal = String.valueOf(objValue);
                int strLength = 0;
                try {
                    strLength = strVal.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(ffb.getFieldType()) && strLength > (fieldLength = Integer.parseInt(ffb.getFieldLength()))) {
                    errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u636e\u957f\u5ea6(").append(strLength).append(")\u8d85\u8fc7\u4e86\u8868\u5355\u8bbe\u7f6e\u957f\u5ea6(").append(fieldLength).append(")");
                    continue;
                }
                if (!Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(ffb.getFieldType())) continue;
                int length = strVal.length();
                if (strVal.contains(".")) {
                    --length;
                }
                int fieldLength2 = Integer.parseInt(ffb.getFieldLength());
                if (length > Integer.parseInt(ffb.getFieldLength())) {
                    errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u636e\u957f\u5ea6(").append(length).append(")\u8d85\u8fc7\u4e86\u8868\u5355\u8bbe\u7f6e\u957f\u5ea6(").append(fieldLength2).append(")");
                    continue;
                }
                FormRelation formRelation = ffb.getFormRelation();
                boolean isRelationEnum = false;
                if (formRelation != null && FormRelationEnums.ToRelationAttrType.data_relation_multiEnum.getKey() == formRelation.getToRelationAttrType().intValue()) {
                    isRelationEnum = true;
                }
                if (FormFieldComEnum.RADIO.getKey().equalsIgnoreCase(ffb.getInputType()) || FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(ffb.getInputType()) || isRelationEnum || FormFieldUtil.checkNumberDigitLength((FormFieldBean)ffb, (Object)strVal)) continue;
                errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u5b57\u5c0f\u6570\u4f4d\u4e0d\u6b63\u786e\u5e94\u4e3a" + ffb.getDigitNum() + ";");
            }
        }
        return errorMsg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDataSubBean selectDataBySlaveFields(FormTableBean formTableBean, FormDataMasterBean formDataMasterBean, String slaveTableName, Map<String, Object> salveRealFieldMap) throws BusinessException, SQLException {
        StringBuilder sql = new StringBuilder("select * from ").append(slaveTableName).append(" where 1=1");
        for (Map.Entry<String, Object> entry : salveRealFieldMap.entrySet()) {
            sql.append(" and ").append(entry.getKey()).append(" = '").append(entry.getValue()).append("'");
        }
        sql.append(" and ").append("formmain_id").append(" = ").append(formDataMasterBean.getId());
        sql.append(" order by sort asc");
        JDBCAgent jdbc = new JDBCAgent();
        List dataList = null;
        try {
            jdbc.execute(sql.toString());
            dataList = jdbc.resultSetToList();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        if (null == dataList || dataList.isEmpty()) {
            return null;
        }
        if (dataList.size() > 1) {
            throw new BusinessException("\u66f4\u65b0\u65e0\u6d41\u7a0b\u8868\u5355-\u67e5\u8be2\u4ece\u8868\u6570\u636e\u4e0d\u552f\u4e00");
        }
        Map rowData = (Map)dataList.get(0);
        FormDataSubBean formDataSubBean = new FormDataSubBean(rowData, formTableBean, formDataMasterBean, new boolean[0]);
        return formDataSubBean;
    }

    private String checkInterFaceRole(String roleStr) {
        return null;
    }

    private String checkUserRole(String roleStr) {
        return null;
    }

    public FormApi4Cap4 getFormApi4Cap4() {
        if (this.formApi4Cap4 == null) {
            this.formApi4Cap4 = (FormApi4Cap4)AppContext.getBean((String)"formApi4Cap4");
        }
        return this.formApi4Cap4;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }
}

