/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.bean.fieldCtrl;

import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldOrgCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.formula.CustomSelectEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;

public class FormFieldDepartment
extends FormFieldOrgCtrl {
    private static final Log LOGGER = CtpLogFactory.getLog(FormFieldDepartment.class);
    public static String BUSINESS_DEPARTMENT = Enums.FormModuleAuthOrgType.BusinessDepartment.getText();
    public static String DEPARTMENT = Enums.FormModuleAuthOrgType.Department.getText();
    public static String SEPARATOR = "|";
    public static String SEPARATOR_COMMA = ",";

    public boolean authNotNullAndValIsNull(FormDataMasterBean formDataMasterBean, FormFieldBean field, FormAuthViewFieldBean authViewFieldBean, Object val) {
        return super.authNotNullAndValIsNull(formDataMasterBean, field, authViewFieldBean, val);
    }

    public void init() {
        this.setIcon("xuanbumen");
    }

    public String getKey() {
        return FormFieldComEnum.EXTEND_DEPARTMENT.getKey();
    }

    public String getText() {
        return FormFieldComEnum.EXTEND_DEPARTMENT.getText();
    }

    public Integer getSort() {
        return FormFieldComEnum.EXTEND_DEPARTMENT.ordinal();
    }

    public Enums.FieldType[] getFieldType() {
        return new Enums.FieldType[]{Enums.FieldType.VARCHAR};
    }

    List<V3xOrgEntity> getV3xOrgEntityList(List<V3xOrgAccount> accountList, String string, String name, String code, int externalType) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        List orgEntityList = orgManager.getEntityNoRelation(V3xOrgDepartment.class.getSimpleName(), "name", (Object)name, null, false, true, Boolean.valueOf(true));
        return orgEntityList;
    }

    public void getDisplayValue4Ctrl(FormFieldBean fieldBean, Object[] returnArr, String valueStr, boolean needSub, boolean forExport) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        if (Strings.isNotEmpty((String)valueStr)) {
            valueStr = valueStr.replace("BusinessDepartment|", "");
            String type = DEPARTMENT;
            if (NumberUtils.isNumber((String)valueStr)) {
                V3xOrgDepartment department = orgManager.getDepartmentById(Long.valueOf(Long.parseLong(valueStr)));
                if (department != null) {
                    int departmentNums;
                    if (4 == department.getExternalType()) {
                        type = BUSINESS_DEPARTMENT;
                    }
                    String showName = department.getName();
                    if (type.equals(BUSINESS_DEPARTMENT)) {
                        showName = this.getBusinessDepartmentName(orgManager, department);
                    }
                    returnArr[1] = forExport && Strings.isNotBlank((String)department.getCode()) ? ((departmentNums = this.getOrgNum(fieldBean, department.getName())) > 1 ? department.getName() + "(" + department.getCode() + ")" : department.getName()) : (forExport ? department.getName() : showName);
                    returnArr[2] = type + SEPARATOR + valueStr;
                } else {
                    LOGGER.warn((Object)("\u83b7\u53d6\u8868\u5355\u6570\u636e\u5931\u8d25\uff1a\u90e8\u95e8ID\uff08" + valueStr + ")"));
                    returnArr[0] = null;
                    returnArr[1] = "";
                    returnArr[2] = "";
                }
            } else if (valueStr.indexOf(SEPARATOR) == valueStr.length() - 2) {
                String orialValue = valueStr.substring(0, valueStr.indexOf(SEPARATOR));
                V3xOrgDepartment department = orgManager.getDepartmentById(Long.valueOf(Long.parseLong(orialValue)));
                if (department != null) {
                    if (4 == department.getExternalType()) {
                        type = BUSINESS_DEPARTMENT;
                    }
                    String showName = department.getName();
                    if (type.equals(BUSINESS_DEPARTMENT)) {
                        showName = this.getBusinessDepartmentName(orgManager, department);
                    }
                    returnArr[0] = orialValue;
                    returnArr[1] = showName + "(" + ResourceUtil.getString((String)"selectPeople.excludeChildDepartment") + ")";
                    returnArr[2] = type + SEPARATOR + valueStr;
                } else {
                    returnArr[1] = "";
                }
            } else {
                returnArr[1] = valueStr;
            }
        } else {
            returnArr[0] = null;
            returnArr[1] = "";
            returnArr[2] = "";
        }
    }

    protected String getBusinessDepartmentName(OrgManager orgManager, V3xOrgDepartment department) throws BusinessException {
        V3xOrgAccount father = orgManager.getAccountById(department.getOrgAccountId());
        V3xOrgAccount grandfather = (V3xOrgAccount)orgManager.getAllParentAccount(department.getOrgAccountId()).get(0);
        return father.getShortName() + "(" + grandfather.getShortName() + ")-" + department.getName();
    }

    public String getProtectedValue(Object value) {
        String valueStr = this.getDbValue(value);
        if (Strings.isNotBlank((String)valueStr)) {
            try {
                OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
                V3xOrgDepartment department = orgManager.getDepartmentById(Long.valueOf(Long.parseLong(valueStr)));
                return department.getName() + "(" + valueStr + ")";
            }
            catch (Exception e) {
                LOGGER.warn((Object)("\u83b7\u53d6\u90e8\u95e8\u6570\u636e\u5931\u8d25" + valueStr), (Throwable)e);
            }
        }
        return valueStr;
    }

    public List<String[]> getListShowDefaultVal(Integer externalType) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (externalType.intValue() == OrgConstants.ExternalType.Inner.ordinal()) {
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserDepartmentId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserDepartmentId.getText()});
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserSuperiorDeptId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserSuperiorDeptId.getText()});
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserJZDeptId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserJZDeptId.getText()});
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildDepartmentId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildDepartmentId.getText()});
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildSuperiorDeptId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildSuperiorDeptId.getText()});
            result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildFirstDeptId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserIncludeChildFirstDeptId.getText()});
        } else if (externalType.intValue() == OrgConstants.ExternalType.Interconnect1.ordinal()) {
            result.add(new String[]{FormulaEnums.FormulaVar.org_currentUserExternalSuperiorDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserExternalSuperiorDepartmentId.getText()});
        } else if (externalType.intValue() == OrgConstants.ExternalType.Interconnect2.ordinal()) {
            result.add(new String[]{FormulaEnums.FormulaVar.org_currentUserExternalDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserExternalDepartmentId.getText()});
        }
        return result;
    }

    public String[] getDefaultVal(String defaultValue) {
        String[] returnValue = new String[2];
        if (defaultValue.startsWith("org")) {
            returnValue[0] = FormulaEnums.FormulaVar.getEnumByKey((String)defaultValue).getValue();
            returnValue[1] = FormulaEnums.FormulaVar.getEnumByKey((String)defaultValue.substring(0, defaultValue.length() - 2)).getValue();
        } else {
            returnValue[0] = returnValue[1] = (defaultValue = defaultValue.replace("BusinessDepartment|", ""));
        }
        return returnValue;
    }

    public Map<String, Object> getAuthDefaultValueMap(FormFieldBean fieldBean, Long formId) throws BusinessException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        ArrayList<String[]> data_system = new ArrayList<String[]>();
        Map disableMap = FormFieldUtil.getDisableMap2AuthDefaultValue((String)"", (String)"", (String)"");
        if (fieldBean.getExternalType().intValue() == OrgConstants.ExternalType.Inner.ordinal()) {
            data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserDepartmentId.getText()});
            data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserSuperiorDeptId.getKey(), FormulaEnums.FormulaVar.org_currentUserSuperiorDeptId.getText()});
            data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserFirstDeptId.getKey(), FormulaEnums.FormulaVar.org_currentUserFirstDeptId.getText()});
        } else if (fieldBean.getExternalType().intValue() == OrgConstants.ExternalType.Interconnect1.ordinal()) {
            data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserExternalSuperiorDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserExternalSuperiorDepartmentId.getText()});
        } else if (fieldBean.getExternalType().intValue() == OrgConstants.ExternalType.Interconnect2.ordinal()) {
            data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserExternalDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserExternalDepartmentId.getText()});
        }
        returnMap.put("disableMap", disableMap);
        returnMap.put("data_handWork", null);
        returnMap.put("data_system", data_system);
        return returnMap;
    }
}

