/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.bean.fieldCtrl;

import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldDepartment;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.formula.CustomSelectEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class FormFieldMultiDepartment
extends FormFieldDepartment {
    private static final Log LOGGER = CtpLogFactory.getLog(FormFieldMultiDepartment.class);

    @Override
    public String getKey() {
        return FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey();
    }

    @Override
    public boolean authNotNullAndValIsNull(FormDataMasterBean formDataMasterBean, FormFieldBean field, FormAuthViewFieldBean authViewFieldBean, Object val) {
        return super.authNotNullAndValIsNull(formDataMasterBean, field, authViewFieldBean, val);
    }

    @Override
    public void init() {
        this.setIcon("xuanduobumen");
    }

    @Override
    public String getText() {
        return FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getText();
    }

    @Override
    public Integer getSort() {
        return FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.ordinal();
    }

    @Override
    public Enums.FieldType[] getFieldType() {
        return new Enums.FieldType[]{Enums.FieldType.VARCHAR, Enums.FieldType.LONGTEXT};
    }

    @Override
    public void getDisplayValue4Ctrl(FormFieldBean fieldBean, Object[] returnArr, String valueStr, boolean needSub, boolean forExport) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        if (Strings.isNotEmpty((String)valueStr)) {
            valueStr = valueStr.replace("BusinessDepartment|", "");
            String[] deptIds = valueStr.split(SEPARATOR_COMMA);
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            String[] stringArray = deptIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String deptId;
                String orgId = deptId = stringArray[i];
                if (deptId.contains(SEPARATOR)) {
                    orgId = deptId.substring(0, deptId.indexOf(SEPARATOR));
                }
                V3xOrgDepartment orgDepartment = orgManager.getDepartmentById(Long.valueOf(Long.parseLong(orgId)));
                String type = DEPARTMENT;
                if (orgDepartment != null) {
                    if (4 == orgDepartment.getExternalType()) {
                        type = BUSINESS_DEPARTMENT;
                    }
                    if (needSub) {
                        ids.add(type + SEPARATOR + deptId);
                    } else {
                        ids.add(type + SEPARATOR + orgId);
                    }
                    String fix = "";
                    if (needSub && AppContext.getThreadContext((String)"isCalc") == null && !orgId.equals(deptId)) {
                        fix = "(" + ResourceUtil.getString((String)"selectPeople.excludeChildDepartment") + ")";
                    }
                    String showName = orgDepartment.getName();
                    if (type.equals(BUSINESS_DEPARTMENT)) {
                        showName = this.getBusinessDepartmentName(orgManager, orgDepartment);
                    }
                    String code = "";
                    if (forExport && Strings.isNotBlank((String)orgDepartment.getCode())) {
                        int departmentNums = this.getOrgNum(fieldBean, orgDepartment.getName());
                        if (departmentNums > 1) {
                            code = "(" + orgDepartment.getCode() + ")";
                        }
                        showName = orgDepartment.getName();
                    } else if (forExport) {
                        showName = orgDepartment.getName();
                    }
                    names.add(showName + code + fix);
                    continue;
                }
                LOGGER.warn((Object)("\u83b7\u53d6\u8868\u5355\u6570\u636e\u5931\u8d25\uff1a\u90e8\u95e8ID\uff08" + orgId + ")"));
            }
            returnArr[2] = StringUtils.join(ids, (String)SEPARATOR_COMMA);
            returnArr[1] = StringUtils.join(names, (String)SEPARATOR_COMMA);
        } else {
            returnArr[0] = null;
            returnArr[1] = "";
            returnArr[2] = "";
        }
    }

    @Override
    public String getProtectedValue(Object value) {
        String valueStr = this.getDbValue(value);
        if (Strings.isNotBlank((String)valueStr)) {
            String[] deptIds = valueStr.split(",");
            StringBuilder sb = new StringBuilder();
            for (String depId : deptIds) {
                sb.append(super.getProtectedValue(depId) + ",");
            }
            String sbStr = sb.toString();
            return sbStr.substring(0, sb.length() - 1);
        }
        return valueStr;
    }

    @Override
    public List<String[]> getListShowDefaultVal(Integer externalType) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(new String[]{FormulaEnums.FormulaVar.org_currentUserDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserDepartmentId.getText()});
        result.add(new String[]{FormulaEnums.FormulaVar.org_currentUserSuperiorDeptId.getKey(), FormulaEnums.FormulaVar.org_currentUserSuperiorDeptId.getText()});
        result.add(new String[]{CustomSelectEnums.SystemVar4CustomSelect.org_currentUserJZDeptId.getKey(), CustomSelectEnums.SystemVar4CustomSelect.org_currentUserJZDeptId.getText()});
        return result;
    }

    @Override
    public String[] getDefaultVal(String defaultValue) {
        String[] returnValue = new String[2];
        returnValue[0] = defaultValue.startsWith("org") ? (returnValue[1] = FormulaEnums.FormulaVar.getEnumByKey((String)defaultValue).getValue()) : (returnValue[1] = (defaultValue = defaultValue.replace("BusinessDepartment|", "")));
        return returnValue;
    }

    @Override
    public Map<String, Object> getAuthDefaultValueMap(FormFieldBean fieldBean, Long formId) throws BusinessException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        ArrayList<String[]> data_system = new ArrayList<String[]>();
        Map disableMap = FormFieldUtil.getDisableMap2AuthDefaultValue((String)"", (String)"", (String)"");
        data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserManagerDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserManagerDepartmentId.getText()});
        data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserLeaderDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserLeaderDepartmentId.getText()});
        data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserDeputyPostDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserDeputyPostDepartmentId.getText()});
        data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserDeptAndDeputyPostDeptId.getKey(), FormulaEnums.FormulaVar.org_currentUserDeptAndDeputyPostDeptId.getText()});
        data_system.add(new String[]{FormulaEnums.FormulaVar.org_currentUserBusinessDepartmentId.getKey(), FormulaEnums.FormulaVar.org_currentUserBusinessDepartmentId.getText()});
        returnMap.put("disableMap", disableMap);
        returnMap.put("data_handWork", null);
        returnMap.put("data_system", data_system);
        return returnMap;
    }
}

