/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.biz.manager;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.biz.vo.BizValidateResultVO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormDefinitionDAO;
import com.seeyon.ctp.form.po.FormDefinition;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.form.util.FormUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import www.seeyon.com.biz.BizChicken;
import www.seeyon.com.biz.BizEgg;
import www.seeyon.com.biz.enums.BizOperationEnum;
import www.seeyon.com.biz.enums.FormSourceTypeEnum;

public class BizValidateManager {
    private FormDefinitionDAO definitionDAO;
    private FormCacheManager cacheManager;
    private static BizValidateManager manager;
    private final Log logger = CtpLogFactory.getLog(BizValidateManager.class);
    private String MODIFY_CUSTOMER_NAME_PLUGIN_ID = "MDFCN";
    private String MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_OLD_NAME = "MDFCN.MD1";
    private String MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_NEW_NAME = "MDFCN.MD2";
    private String MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_DATE = "MDFCN.MD3";

    private BizValidateManager() {
    }

    public static synchronized BizValidateManager getInstance() throws BusinessException {
        if (manager == null) {
            manager = new BizValidateManager();
            manager.init();
        }
        return manager;
    }

    private void init() throws BusinessException {
        this.setDefinitionDAO((FormDefinitionDAO)AppContext.getBean((String)"formDefinitionDAO"));
        this.cacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
        this.updateFormCustomerName();
        this.initUsedCount();
    }

    private void initUsedCount() throws BusinessException {
        List<Map<String, Object>> formDefinitionList = this.getNeedCheckRightFormList();
        try {
            List ids = BizChicken.initUsedCount(formDefinitionList);
            this.cacheManager.transDisableForms(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u521d\u59cb\u5316\u4ea7\u80fd\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getNeedCheckRightFormList() throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder types = new StringBuilder("");
        for (Enums.FormType type : Enums.FormType.values()) {
            if (!type.isCheckNum()) continue;
            types.append(type.getKey()).append(",");
        }
        String typeStr = types.toString();
        if (Strings.isBlank((String)typeStr)) {
            return new ArrayList<Map<String, Object>>();
        }
        typeStr = typeStr.substring(0, typeStr.length() - 1);
        map.put("formtype", typeStr);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(Enums.FormStateEnum.draft.getKey());
        states.add(Enums.FormStateEnum.inactive.getKey());
        states.add(Enums.FormStateEnum.partialactivation.getKey());
        states.add(Enums.FormStateEnum.published.getKey());
        map.put("stateList", states);
        return this.definitionDAO.selectByFlipInfo(null, map);
    }

    public boolean needControlCount() {
        return this.getTotalCount() != -1;
    }

    public boolean checkCount4Dev() {
        return SystemEnvironment.isDev() || AppContext.isRunningModeDevelop();
    }

    public synchronized BizValidateResultVO preValidateBiz(BizOperationEnum operation) {
        return this.preValidateBiz(operation, 1);
    }

    public synchronized BizValidateResultVO preValidateBiz(BizOperationEnum operation, int addNum) {
        return this.validateBiz(operation, addNum, false);
    }

    public synchronized BizValidateResultVO validateBiz(BizOperationEnum operation) {
        return this.validateBiz(operation, 1);
    }

    public synchronized BizValidateResultVO validateBiz(BizOperationEnum operation, int addNum) {
        return this.validateBiz(operation, addNum, true);
    }

    public synchronized BizValidateResultVO validateBiz(BizOperationEnum operation, int addNum, boolean isNotPre) {
        BizValidateResultVO resultVO = new BizValidateResultVO();
        if (!this.needControlCount()) {
            resultVO.setSuccess(true);
            return resultVO;
        }
        this.logger.info((Object)("\u4ea7\u80fd\u6821\u9a8c\u65e5\u5fd7\uff0c\u6821\u9a8c\u524d\uff1a\u64cd\u4f5c\u7c7b\u578b\uff1a" + operation.getName() + " total:" + this.getTotalCount() + " used:" + BizChicken.getUsedNum() + " \u6821\u9a8c\u6570\uff1a" + addNum + " \u662f\u5426\u9884\u6821\u9a8c\uff1a" + isNotPre));
        if (operation.isAddCount()) {
            if (BizChicken.isAllowAdd((int)addNum)) {
                if (isNotPre) {
                    this.modifyUsedCount(operation, addNum);
                }
                resultVO.setSuccess(true);
            } else {
                resultVO.setSuccess(false);
                resultVO.setCode(operation.getErrorCode());
            }
        }
        if (operation.isMinusCount()) {
            this.modifyUsedCount(operation, addNum);
            resultVO.setSuccess(true);
        }
        if (operation.isModifyUpgradeCount()) {
            this.modifyUsedCount(operation, addNum);
            resultVO.setSuccess(true);
        }
        this.logger.info((Object)("\u4ea7\u80fd\u6821\u9a8c\u65e5\u5fd7\uff0c\u6821\u9a8c\u540e\uff1a\u64cd\u4f5c\u7c7b\u578b\uff1a" + operation.getName() + " total:" + this.getTotalCount() + " used:" + BizChicken.getUsedNum() + " \u662f\u5426\u9884\u6821\u9a8c\uff1a" + isNotPre));
        return resultVO;
    }

    public synchronized void modifyUsedCount(BizOperationEnum operation, int addNum) {
        for (int i = 1; i <= addNum; ++i) {
            BizChicken.modifyUsedCount((BizOperationEnum)operation);
        }
    }

    public void setDefinitionDAO(FormDefinitionDAO definitionDAO) {
        this.definitionDAO = definitionDAO;
    }

    public static String getEncodeString(FormSourceTypeEnum type, Long formId) throws BusinessException {
        try {
            return BizChicken.getEncodeString((FormSourceTypeEnum)type, (Long)formId);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public static String getEncodeString(BizEgg egg, Long formId) throws BusinessException {
        try {
            return BizChicken.getEncodeString((BizEgg)egg, (Long)formId);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public int getTotalCount() {
        return BizChicken.getTotalNum();
    }

    public FormSourceTypeEnum getCreateSourceType(BizOperationEnum operation) {
        if (SystemEnvironment.isDev() || AppContext.isRunningModeDevelop()) {
            return FormSourceTypeEnum.create_form_self;
        }
        return BizChicken.getCreateSourceType((BizOperationEnum)operation);
    }

    public boolean isEffectNum(String sourceStr, Long formId) throws BusinessException {
        try {
            return BizChicken.isEffectNum((String)sourceStr, (Long)formId);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public static FormSourceTypeEnum getFormSourceType(String sourceType, Long id) throws BusinessException {
        try {
            return BizChicken.getFormSourceType((String)sourceType, (Long)id);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public Map<String, Object> countUpdateFormCustomerName(String customerName) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List definitions = this.definitionDAO.selectAll();
        map.put("total", definitions.size());
        int updateCount = 0;
        for (FormDefinition definition : definitions) {
            if (!BizValidateManager.isSameCustomName(definition.getSourceType(), definition.getId(), customerName)) continue;
            ++updateCount;
        }
        map.put("updateCount", updateCount);
        return map;
    }

    private void updateFormCustomerName() {
        if (AppContext.hasPlugin((String)this.MODIFY_CUSTOMER_NAME_PLUGIN_ID)) {
            String oldName = AppContext.getPlugin((String)this.MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_OLD_NAME);
            String newName = AppContext.getPlugin((String)this.MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_NEW_NAME);
            String dateStr = AppContext.getPlugin((String)this.MODIFY_CUSTOMER_NAME_PLUGIN_ID_PARAM_DATE);
            try {
                if (Strings.isBlank((String)oldName) || Strings.isBlank((String)newName)) {
                    this.logger.warn((Object)("\u66f4\u65b0\u8868\u5355\u4e2d\u5ba2\u6237\u540d\u79f0\u65f6\uff0c\u65b0\u540d\u79f0\u6216\u8005\u65e7\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\uff01oldName:" + oldName + ", newName:" + newName));
                    return;
                }
                if (Strings.isBlank((String)dateStr)) {
                    this.logger.warn((Object)"\u66f4\u65b0\u8868\u5355\u4e2d\u5ba2\u6237\u540d\u79f0\u65f6\uff0c\u6709\u6548\u671f\u9650\u4e3a\u7a7a\uff0c\u5c06\u5728\u6bcf\u6b21\u542f\u52a8\u65f6\u90fd\u66f4\u65b0\u4e00\u6b21\uff01");
                } else {
                    Date date = DateUtil.parse((String)dateStr);
                    if (DateUtil.currentDate().after(date)) {
                        this.logger.warn((Object)("\u66f4\u65b0\u8868\u5355\u4e2d\u5ba2\u6237\u540d\u79f0\u65f6\uff0c\u6709\u6548\u671f\u9650\u5df2\u8fc7\uff0c\u4e0d\u6267\u884c\uff01\u6709\u6548\u671f\uff1a" + dateStr));
                        return;
                    }
                }
                Map<String, Object> result = this.updateFormCustomerName(oldName, newName);
                this.logger.info((Object)("\u6210\u529f\u5c06\u5ba2\u6237\u540d\u79f0\u7531 " + oldName + " \u4fee\u6539\u4e3a " + newName + ", \u4fee\u6539\u7684\u8868\u5355\u6570\u4e3a\uff1a" + result.get("updateCount")));
            }
            catch (Exception e) {
                this.logger.error((Object)"\u66f4\u65b0\u8868\u5355\u4e2d\u5ba2\u6237\u540d\u79f0\u65f6,\u53d1\u751f\u5f02\u5e38\uff0c\u8054\u7cfb\u81f4\u8fdc\u5546\u52a1\uff01", (Throwable)e);
            }
        }
    }

    public Map<String, Object> updateFormCustomerName(String oldName, String newName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List definitions = this.definitionDAO.selectAll();
        int updateCount = 0;
        ArrayList params = new ArrayList();
        for (FormDefinition definition : definitions) {
            if (!BizValidateManager.isSameCustomName(definition.getSourceType(), definition.getId(), oldName)) continue;
            ++updateCount;
            String sourceInfo = BizValidateManager.updateSourceInfo4CustomName(definition.getSourceType(), newName);
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(sourceInfo);
            param.add(definition.getId());
            params.add(param);
        }
        Collection collection = FormUtil.splitCollection(params, (int)800);
        for (Collection c : collection) {
            this.exeUpdateBatch(c);
        }
        map.put("updateCount", updateCount);
        return map;
    }

    public void exeUpdateBatch(Collection<List<Object>> parameters) throws Exception {
        JDBCAgent jdbcAgent = new JDBCAgent();
        try {
            String sql = "update form_definition set source_type = ? where id = ?";
            jdbcAgent.batch1Prepare(sql);
            for (List<Object> o : parameters) {
                jdbcAgent.batch2Add(o);
            }
            jdbcAgent.batch3Execute();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            jdbcAgent.close();
        }
    }

    public static boolean isSameCustomName(String sourceStr, Long formId, String customerName) {
        return BizChicken.isSameCustomName((String)sourceStr, (Long)formId, (String)customerName);
    }

    public static String updateSourceInfo4CustomName(String sourceStr, String customerName) throws Exception {
        return BizChicken.updateSourceInfo4CustomName((String)sourceStr, (String)customerName);
    }
}

