/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.button;

import com.seeyon.cap4.form.bean.button.CommonBtn;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.button.ButtonDAO;
import com.seeyon.cap4.form.button.ButtonManager;
import com.seeyon.cap4.form.po.CAPButton;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.validity.constant.ValidityEnum;
import com.seeyon.cap4.validity.po.CAPCloudResource;
import com.seeyon.cap4.validity.service.CloudResourceDAO;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class ButtonManagerImpl
implements ButtonManager {
    private static final Log logger = CtpLogFactory.getLog(ButtonManagerImpl.class);
    private ButtonDAO buttonDAO;
    private CloudResourceDAO cloudResourceDAO;
    private ValidateManager validateManager;
    private Map<String, CAPButton> formFieldCtrlMap = new ConcurrentHashMap<String, CAPButton>();

    public void setValidateManager(ValidateManager validateManager) {
        this.validateManager = validateManager;
    }

    public void setCloudResourceDAO(CloudResourceDAO cloudResourceDAO) {
        this.cloudResourceDAO = cloudResourceDAO;
    }

    public void setButtonDAO(ButtonDAO buttonDAO) {
        this.buttonDAO = buttonDAO;
    }

    @Override
    public void validateFormFieldButton(List<CommonBtn> buttons) throws BusinessException {
        if (this.formFieldCtrlMap.isEmpty()) {
            this.getAllButtons();
        }
        for (CommonBtn commonBtn : buttons) {
            if (AppContext.isRunningModeDevelop()) {
                commonBtn.setValid(true);
            } else {
                CAPButton capButton = this.formFieldCtrlMap.get(commonBtn.getKey());
                if (capButton != null) {
                    commonBtn.setValid(capButton.isValid());
                }
            }
            logger.info((Object)("\u81ea\u5b9a\u4e49\u6309\u94ae\uff1a\u3010text:" + commonBtn.getText() + " key:" + commonBtn.getKey() + "\u3011\u6821\u9a8c\u7ed3\u679c\uff1a" + commonBtn.isValid()));
        }
    }

    @Override
    public Map<String, CAPButton> getAllButtons() throws BusinessException {
        List<CAPButton> capButtons = this.buttonDAO.getAllButtons();
        for (CAPButton capButton : capButtons) {
            CAPCloudResource capCloudResource = this.cloudResourceDAO.getById(capButton.getResourceId());
            if (capCloudResource != null && this.validateManager.validateRuntime((Object)capCloudResource)) {
                capButton.setValid(true);
            }
            this.formFieldCtrlMap.put(capButton.getKey(), capButton);
        }
        return this.formFieldCtrlMap;
    }

    @Override
    public boolean setupButton(Map<String, Object> params) throws BusinessException {
        CAPButton capButton;
        File buttonPackage = (File)params.get("buttonPackage");
        Map<String, Object> validateResult = this.validateManager.validateCtrl(buttonPackage);
        if (!validateResult.get("code").equals(ValidityEnum.ValidityResult.AppSuccess.getKey())) {
            BusinessException exception = new BusinessException("\u6309\u94ae\u5305\u9a8c\u8bc1\u5f02\u5e38");
            exception.setCode("1002");
            throw exception;
        }
        File resultFile = (File)validateResult.get("resultFile");
        int sourceValue = ParamUtil.getInt(validateResult, (String)"sourceValue");
        String goodsId = ParamUtil.getString(params, (String)"goodsId");
        String goodsName = ParamUtil.getString(params, (String)"goodsName");
        Properties properties = PropertiesUtil.getFromFile((File)new File(resultFile, "control.properties"));
        String key = properties.getProperty("key");
        String plugin = properties.getProperty("plugin");
        if (Strings.isNotEmpty((String)plugin) && !AppContext.hasPlugin((String)plugin)) {
            throw new BusinessException("\u8bf7\u8d2d\u4e70\u63d2\u4ef6\u540e\u518d\u4f7f\u7528\uff01");
        }
        if (Strings.isNotEmpty((String)key)) {
            capButton = this.buttonDAO.getByKeyValue(key);
            if (capButton != null) {
                CAPCloudResource capCloudResource = this.cloudResourceDAO.getById(capButton.getResourceId());
                if (capCloudResource != null) {
                    capButton.setCapCloudResource(capCloudResource);
                }
            } else {
                capButton = new CAPButton();
                capButton.setCreateUser(AppContext.currentUserId());
                capButton.setCreateDate(new Date());
            }
        } else {
            throw new BusinessException("button invalid!");
        }
        capButton.setKey(key);
        capButton.setName(goodsName);
        capButton.setCreateType(sourceValue);
        capButton.setUpdateDate(new Date());
        capButton.getCapCloudResource().setGoodsId(goodsId);
        capButton.getCapCloudResource().setGoodsName(goodsName);
        capButton.getCapCloudResource().setResourceType(Integer.valueOf(ValidityEnum.ResourceType.Button.getKey()));
        this.addButton(capButton);
        return true;
    }

    @Override
    public boolean addButton(CAPButton capButton) throws BusinessException {
        CAPCloudResource capCloudResource;
        boolean isContrlNew = false;
        boolean isResNew = false;
        if (capButton.isNew()) {
            capButton.setIdIfNew();
            isContrlNew = true;
        }
        if ((capCloudResource = capButton.getCapCloudResource()).isNew()) {
            capCloudResource.setIdIfNew();
            isResNew = true;
        }
        capButton.setResourceId(capCloudResource.getId());
        if (isContrlNew) {
            this.buttonDAO.addButton(capButton);
        } else {
            this.buttonDAO.updateButton(capButton);
        }
        capCloudResource.setCreateType(capButton.getCreateType());
        capCloudResource.setCreateDate(capButton.getCreateDate());
        capCloudResource.setCreateUser(capButton.getCreateUser());
        capCloudResource.setResourceInfo(this.validateManager.generateValidate((Object)capCloudResource));
        if (isResNew) {
            this.cloudResourceDAO.addCAPCloudResource(capCloudResource);
        } else {
            this.cloudResourceDAO.upateCAPCloudResource(capCloudResource);
        }
        this.reloadButton(capButton.getKey());
        return true;
    }

    @Override
    public CAPButton reloadButton(String buttonKey) throws BusinessException {
        CAPButton capButton = this.buttonDAO.getByKeyValue(buttonKey);
        FormFieldCustomCtrl formFieldCustomCtrl = FormFieldUtil.getCustomCtrlByKey((String)capButton.getKey());
        if (formFieldCustomCtrl != null) {
            formFieldCustomCtrl.setValid(true);
            FormFieldUtil.addCustomCtrl((FormFieldCustomCtrl)formFieldCustomCtrl);
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(0, (Object)CAP4FormCache.FormCacheType.CustomControl_Reload);
            args.add(1, capButton.getKey());
            NotificationManager.getInstance().send(NotificationType.CapFormAppReload, args);
        }
        return capButton;
    }
}

