/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.control;

import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.control.ControlDAO;
import com.seeyon.cap4.form.control.ControlManager;
import com.seeyon.cap4.form.po.CAPControl;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.validity.constant.ValidityEnum;
import com.seeyon.cap4.validity.po.CAPCloudResource;
import com.seeyon.cap4.validity.service.CloudResourceDAO;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class ControlManagerImpl
implements ControlManager {
    private static final Log logger = CtpLogFactory.getLog(ControlManagerImpl.class);
    private ControlDAO controlDAO;
    private CloudResourceDAO cloudResourceDAO;
    private ValidateManager validateManager;
    private Map<String, CAPControl> formFieldCtrlMap = new ConcurrentHashMap<String, CAPControl>();

    public void setValidateManager(ValidateManager validateManager) {
        this.validateManager = validateManager;
    }

    public void setCloudResourceDAO(CloudResourceDAO cloudResourceDAO) {
        this.cloudResourceDAO = cloudResourceDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    @Override
    public void validateFormFieldCtrl(List<FormFieldCtrl> ctrls) throws BusinessException {
        if (this.formFieldCtrlMap.isEmpty()) {
            this.getAllControls();
        }
        for (FormFieldCtrl formFieldCtrl : ctrls) {
            if (AppContext.isRunningModeDevelop()) {
                formFieldCtrl.setValid(true);
            } else {
                CAPControl capControl = this.formFieldCtrlMap.get(formFieldCtrl.getKey());
                if (capControl != null) {
                    formFieldCtrl.setValid(capControl.isValid());
                }
            }
            logger.info((Object)("\u81ea\u5b9a\u4e49\u63a7\u4ef6\uff1a\u3010text:" + formFieldCtrl.getText() + " key:" + formFieldCtrl.getKey() + "\u3011\u6821\u9a8c\u7ed3\u679c\uff1a" + formFieldCtrl.isValid()));
            FormFieldUtil.addCustomCtrl2SortedMap((FormFieldCustomCtrl)((FormFieldCustomCtrl)formFieldCtrl));
        }
    }

    @Override
    public Map<String, CAPControl> getAllControls() throws BusinessException {
        List<CAPControl> capControls = this.controlDAO.getAllControls();
        for (CAPControl capControl : capControls) {
            CAPCloudResource capCloudResource = this.cloudResourceDAO.getById(capControl.getResourceId());
            if (capCloudResource != null && this.validateManager.validateRuntime((Object)capCloudResource)) {
                capControl.setValid(true);
            }
            this.formFieldCtrlMap.put(capControl.getKey(), capControl);
        }
        return this.formFieldCtrlMap;
    }

    @Override
    public boolean setupContrl(Map<String, Object> params) throws BusinessException {
        CAPControl capControl;
        File contrlPackage = (File)params.get("contrlPackage");
        Map<String, Object> validateResult = this.validateManager.validateCtrl(contrlPackage);
        if (!validateResult.get("code").equals(ValidityEnum.ValidityResult.AppSuccess.getKey())) {
            BusinessException exception = new BusinessException("\u63a7\u4ef6\u5305\u9a8c\u8bc1\u5f02\u5e38");
            exception.setCode("1002");
            throw exception;
        }
        File resultFile = (File)validateResult.get("resultFile");
        int sourceValue = ParamUtil.getInt(validateResult, (String)"sourceValue");
        String goodsId = ParamUtil.getString(params, (String)"goodsId");
        String goodsName = ParamUtil.getString(params, (String)"goodsName");
        Properties properties = PropertiesUtil.getFromFile((File)new File(resultFile, "control.properties"));
        String key = properties.getProperty("key");
        String plugin = properties.getProperty("plugin");
        if (!Strings.isNotEmpty((String)plugin) || !AppContext.hasPlugin((String)plugin)) {
            // empty if block
        }
        if (Strings.isNotEmpty((String)key)) {
            capControl = this.controlDAO.getByKeyValue(key);
            if (capControl != null) {
                CAPCloudResource capCloudResource = this.cloudResourceDAO.getById(capControl.getResourceId());
                if (capCloudResource != null) {
                    capControl.setCapCloudResource(capCloudResource);
                }
            } else {
                capControl = new CAPControl();
                capControl.setCreateUser(AppContext.currentUserId());
                capControl.setCreateDate(new Date());
            }
        } else {
            throw new BusinessException("\u63a7\u4ef6\u5305\u9a8c\u8bc1\u5f02\u5e38");
        }
        capControl.setKey(key);
        capControl.setName(goodsName);
        capControl.setCreateType(sourceValue);
        capControl.setUpdateDate(new Date());
        capControl.getCapCloudResource().setGoodsId(goodsId);
        capControl.getCapCloudResource().setGoodsName(goodsName);
        capControl.getCapCloudResource().setResourceType(Integer.valueOf(ValidityEnum.ResourceType.Control.getKey()));
        this.addContrl(capControl);
        return true;
    }

    @Override
    public boolean addContrl(CAPControl capControl) throws BusinessException {
        CAPCloudResource capCloudResource;
        boolean isContrlNew = false;
        boolean isResNew = false;
        if (capControl.isNew()) {
            capControl.setIdIfNew();
            isContrlNew = true;
        }
        if ((capCloudResource = capControl.getCapCloudResource()).isNew()) {
            capCloudResource.setIdIfNew();
            isResNew = true;
        }
        capControl.setResourceId(capCloudResource.getId());
        if (isContrlNew) {
            this.controlDAO.addContrl(capControl);
        } else {
            this.controlDAO.updateContrl(capControl);
        }
        capCloudResource.setCreateType(capControl.getCreateType());
        capCloudResource.setCreateDate(capControl.getCreateDate());
        capCloudResource.setCreateUser(capControl.getCreateUser());
        capCloudResource.setResourceInfo(this.validateManager.generateValidate((Object)capCloudResource));
        if (isResNew) {
            this.cloudResourceDAO.addCAPCloudResource(capCloudResource);
        } else {
            this.cloudResourceDAO.upateCAPCloudResource(capCloudResource);
        }
        this.reloadControl(capControl.getKey());
        return true;
    }

    @Override
    public CAPControl reloadControl(String controlKey) throws BusinessException {
        return this.reloadControl(controlKey, true);
    }

    @Override
    public CAPControl reloadControl(String controlKey, boolean sendNotify) throws BusinessException {
        CAPControl capControl = this.controlDAO.getByKeyValue(controlKey);
        FormFieldCustomCtrl formFieldCustomCtrl = FormFieldUtil.getCustomCtrlByKey((String)capControl.getKey());
        if (formFieldCustomCtrl != null) {
            formFieldCustomCtrl.setValid(true);
            FormFieldUtil.addCustomCtrl((FormFieldCustomCtrl)formFieldCustomCtrl);
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(0, (Object)CAP4FormCache.FormCacheType.CustomControl_Reload);
            args.add(1, capControl.getKey());
            if (sendNotify) {
                NotificationManager.getInstance().send(NotificationType.CapFormAppReload, args);
            }
        }
        return capControl;
    }
}

