/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.logo;

import com.seeyon.cap4.form.logo.CAPLogoDao;
import com.seeyon.cap4.form.logo.CAPLogoManager;
import com.seeyon.cap4.form.po.CAPLogo;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.util.DateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAPLogoManagerImpl
implements CAPLogoManager {
    private CAPLogoDao capLogoDAO;
    private FileManager fileManager;

    @Override
    public List<Map<String, Object>> getAllLogos() throws BusinessException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<CAPLogo> allLogos = this.capLogoDAO.getAllLogos();
        Collections.sort(allLogos, new Comparator<CAPLogo>(){

            @Override
            public int compare(CAPLogo o1, CAPLogo o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        for (CAPLogo capLogo : allLogos) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", String.valueOf(capLogo.getId()));
            map.put("sort", capLogo.getSort());
            Long fileUrl = capLogo.getFileUrl();
            map.put("fileUrl", String.valueOf(fileUrl));
            Date createDate = capLogo.getCreateDate();
            map.put("createDate", DateUtil.format((Date)createDate, (String)"yyyy-MM-dd"));
            File file = this.fileManager.getFile(fileUrl, createDate);
            map.put("exist", null != file);
            result.add(map);
        }
        return result;
    }

    @Override
    public boolean updateLogo(CAPLogo logo) throws BusinessException {
        return false;
    }

    @Override
    public CAPLogo findByFileUrl(Long fileUrl) throws BusinessException {
        return this.capLogoDAO.findByFileUrl(fileUrl);
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setCapLogoDAO(CAPLogoDao capLogoDAO) {
        this.capLogoDAO = capLogoDAO;
    }
}

