/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business;

import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessDAO;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.manager.OrgManagerDirect;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusinessDAOImpl
implements BusinessDAO {
    private OrgManagerDirect orgManagerDirect;
    public static final String SEARCH_BY_NAME = "name";
    public static final String SEARCH_BY_CREATOR = "creator";
    public static final String SEARCH_BY_CREATEDATE = "createDate";

    @Override
    public final List<CapBizConfig> getAllCtpBizConfig() {
        String hql = "from CapBizConfig ";
        return DBAgent.find((String)hql);
    }

    @Override
    public final List<Map<String, Object>> findAllByCondition(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        int businessType;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        User user = AppContext.getCurrentUser();
        boolean isAdmin = AppContext.isAdministrator();
        Long accountId = user.getLoginAccount();
        String businessSource = "";
        if (params.containsKey("businessSource")) {
            businessSource = (String)params.get("businessSource");
        }
        String sql = "select new map(c.id as id, c.menuId as menuId,c.name as name,c.bizState as state,c.createUser as createUser,c.createName as createUserName,c.createDate as createDate,c.updateDate as updateDate,c.bizDashboardId as bizDashboardId,c.ownerId as ownerId,m.name as ownerName,c.publishFlag as publishFlag,c.bizIcon as bizIcon,c.bizVersion as bizVersion,c.bizCreateType as bizCreateType,c.endDate as endDate,c.trial as trial,c.licenseUpdateDate as licenseUpdateDate ) from CapBizConfig c, OrgMember m where ";
        if (isAdmin) {
            sql = sql + "c.orgAccountId=:accountId and c.ownerId=m.id";
        } else {
            List roleIds = (List)params.get("roleids");
            StringBuilder inStr = new StringBuilder();
            if (Strings.isEmpty((Collection)roleIds) || roleIds.size() < 1000) {
                inStr.append("c.menuId in (:roleids)");
                parameterMap.put("roleids", params.get("roleids"));
            } else {
                List[] array = Strings.splitList((List)roleIds, (int)1000);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    List list = array[i];
                    inStr.append("c.menuId in (:roleids").append(i).append(")");
                    if (i < len - 1) {
                        inStr.append(" or ");
                    }
                    parameterMap.put("roleids" + i, list);
                }
            }
            sql = sql + "c.ownerId = m.id  and (c.orgAccountId=:accountId or (" + inStr.toString() + ")) ";
        }
        StringBuilder hqlStr = new StringBuilder("");
        parameterMap.put("accountId", accountId);
        if (SEARCH_BY_NAME.equals(params.get("condition")) && Strings.isNotBlank((String)((String)params.get("nameSearch")))) {
            hqlStr.append(" and " + SQLWildcardUtil.likeLowerCase((String)"c.name") + " like :name " + SQLWildcardUtil.setEscapeCharacter());
            parameterMap.put(SEARCH_BY_NAME, "%" + SQLWildcardUtil.escape((String)((String)params.get("nameSearch")).trim()).toLowerCase() + "%");
        } else if (SEARCH_BY_CREATOR.equals(params.get("condition")) && Strings.isNotBlank((String)((String)params.get("creatorSearch")))) {
            hqlStr.append(" and m.name like :creatorName ");
            parameterMap.put("creatorName", "%" + SQLWildcardUtil.escape((String)((String)params.get("creatorSearch")).trim()) + "%");
        } else if (SEARCH_BY_CREATEDATE.equals(params.get("condition"))) {
            if (Strings.isNotBlank((String)((String)params.get("createDateSearch1")))) {
                hqlStr.append(" and c.createDate >= :startDate ");
                parameterMap.put("startDate", Datetimes.getTodayFirstTime((String)((String)params.get("createDateSearch1"))));
            }
            if (Strings.isNotBlank((String)((String)params.get("createDateSearch2")))) {
                hqlStr.append(" and c.createDate <= :endDate ");
                parameterMap.put("endDate", Datetimes.getTodayLastTime((String)((String)params.get("createDateSearch2"))));
            }
        }
        if (!isAdmin && !"businessSelector".equals(businessSource)) {
            String activeTab = (String)params.get("activeTab");
            if (Strings.isNotBlank((String)activeTab) && "shareapp".equals(activeTab)) {
                hqlStr.append("  and c.ownerId !=:userId");
            } else {
                hqlStr.append("  and c.ownerId =:userId");
            }
            parameterMap.put("userId", user.getId());
        }
        if ((businessType = ParamUtil.getInt(params, (String)"businessType", (int)-1).intValue()) == BizEnums.BizOrderPlatformType.managementCenter.getKey()) {
            hqlStr.append(" and c.bizCreateType in(:bizCreateType) ");
            ArrayList<Integer> valueList = new ArrayList<Integer>();
            valueList.add(BizEnums.BizCreateSourceType.Import.getKey());
            valueList.add(BizEnums.BizCreateSourceType.ImportFromMall.getKey());
            valueList.add(BizEnums.BizCreateSourceType.ImportFromRequir.getKey());
            parameterMap.put("bizCreateType", valueList);
        }
        if (businessType == BizEnums.BizOrderPlatformType.operationCenter.getKey()) {
            hqlStr.append(" and ( c.useFlag is null or c.useFlag =:useFlag ) ");
            parameterMap.put("useFlag", BizEnums.BizUseFlag.enable.getKey());
        }
        if (params.containsKey("publishFlag")) {
            hqlStr.append("  and c.publishFlag =:publishFlag");
            parameterMap.put("publishFlag", params.get("publishFlag"));
        }
        if (params.containsKey("orderByEndDate")) {
            hqlStr.append(" order by c.endDate asc");
        } else {
            hqlStr.append(" order by c.createDate desc");
        }
        return DBAgent.find((String)(sql + hqlStr.toString()), parameterMap, (FlipInfo)fi);
    }

    @Override
    public void updateBizIcon(Long bizId, Map<String, Object> params) throws BusinessException {
        if (bizId != null) {
            CapBizConfig bizConfig;
            int bizImageType = ParamUtil.getInt(params, (String)"bizImageType", (int)-1);
            String bizIcon = ParamUtil.getString(params, (String)"bizIcon", (String)"");
            if (bizImageType > 0 && Strings.isNotEmpty((String)bizIcon) && (bizConfig = this.findBizConfigById(bizId)) != null) {
                bizConfig.setBizIcon(bizIcon);
                DBAgent.merge((Object)bizConfig);
            }
        }
    }

    @Override
    public final CapBizConfig findBizConfigByMenuId(Long menuId) {
        String hql = "from CapBizConfig as c where c.menuId=:menuId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("menuId", menuId);
        List list = DBAgent.find((String)hql, map);
        if (list != null && !list.isEmpty()) {
            return (CapBizConfig)list.get(0);
        }
        return null;
    }

    @Override
    public final void deleteBizConfig(List<Long> bizConfigIds) {
        String hql = "delete from " + CapBizConfig.class.getName() + " fbf where fbf.id in (:bizConfigIds)";
        HashMap<String, List<Long>> parameterMap = new HashMap<String, List<Long>>();
        parameterMap.put("bizConfigIds", bizConfigIds);
        DBAgent.bulkUpdate((String)hql, parameterMap);
    }

    @Override
    public final List<Long> findBizConfigsByName(String name, Long accountId, String bizConfigId) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String hql = "select biz from CapBizConfig biz, OrgMember m where biz.createUser=m.id and biz.name=:name and biz.orgAccountId=:accountId";
        parameterMap.put(SEARCH_BY_NAME, name);
        parameterMap.put("accountId", accountId);
        if (Strings.isNotBlank((String)bizConfigId)) {
            hql = hql + " and biz.id<>:bizConfigId";
            parameterMap.put("bizConfigId", Long.parseLong(bizConfigId));
        }
        return DBAgent.find((String)hql, parameterMap);
    }

    @Override
    public final void saveOrUpdateBizConfig(CapBizConfig bizConfig) throws BusinessException {
        CapBizConfig biz = (CapBizConfig)DBAgent.get(CapBizConfig.class, (Serializable)bizConfig.getId());
        if (null == biz) {
            DBAgent.save((Object)bizConfig);
        } else {
            DBAgent.merge((Object)bizConfig);
        }
    }

    @Override
    public final void deleteBizConfig(Long bizId) throws BusinessException {
        CapBizConfig biz = this.findBizConfigById(bizId);
        if (null != biz) {
            DBAgent.delete((Object)biz);
        }
    }

    @Override
    public final CapBizConfig findBizConfigById(Long bizId) throws BusinessException {
        return (CapBizConfig)DBAgent.get(CapBizConfig.class, (Serializable)bizId);
    }

    public OrgManagerDirect getOrgManagerDirect() {
        return this.orgManagerDirect;
    }

    public void setOrgManagerDirect(OrgManagerDirect orgManagerDirect) {
        this.orgManagerDirect = orgManagerDirect;
    }

    @Override
    public Integer findMaxSort() throws BusinessException {
        Object result;
        String sql = "select max(bizSort) from CapBizConfig";
        List lsit = DBAgent.find((String)sql);
        if (Strings.isNotEmpty((Collection)lsit) && (result = lsit.get(0)) != null) {
            return Integer.parseInt(result.toString()) + 1;
        }
        return 990;
    }

    @Override
    public Date findMaxUpdateDate() throws BusinessException {
        Object result;
        String sql = "select max(updateDate) from CapBizConfig";
        List lsit = DBAgent.find((String)sql);
        if (Strings.isNotEmpty((Collection)lsit) && (result = lsit.get(0)) != null) {
            return (Date)result;
        }
        return new Date();
    }

    @Override
    public void initOrgAccocunt() throws BusinessException {
        String hql = "from CapBizConfig c where c.orgAccountId is null or bizState is null or bizCreateType is null";
        List list = DBAgent.find((String)hql);
        if (Strings.isNotEmpty((Collection)list)) {
            OrgManager manager = (OrgManager)AppContext.getBean((String)"orgManager");
            for (CapBizConfig ctpBizConfig : list) {
                V3xOrgMember member = manager.getMemberById(ctpBizConfig.getCreateUser());
                if (member != null) {
                    ctpBizConfig.setOrgAccountId(member.getOrgAccountId());
                }
                ctpBizConfig.setBizState(Integer.valueOf(BizEnums.BizState.Activated.getKey()));
                ctpBizConfig.setBizCreateType(Integer.valueOf(BizEnums.BizCreateSourceType.SelfCreate.getKey()));
            }
            DBAgent.mergeAll((List)list);
        }
    }

    @Override
    public void updateBizState(Long bizId, int state) throws BusinessException {
        String hql = "update CapBizConfig set bizState = :state where id=:Id";
        HashMap<String, Number> parameterMap = new HashMap<String, Number>();
        parameterMap.put("Id", bizId);
        parameterMap.put("state", state);
        DBAgent.bulkUpdate((String)hql, parameterMap);
    }

    @Override
    public void updateBizState(List<Long> bizId, int state) throws BusinessException {
        bizId.add(0L);
        String hql = "update CapBizConfig set bizState = :state where id in (:Id)";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("Id", bizId);
        parameterMap.put("state", state);
        DBAgent.bulkUpdate((String)hql, parameterMap);
    }

    @Override
    public List<CapBizConfig> selectBizListByState(int state) throws BusinessException {
        HashMap<String, Number> parameterMap = new HashMap<String, Number>();
        String hql = "from CapBizConfig c  where c.createUser =:createId and c.orgAccountId=:accountId and c.bizState=:state";
        parameterMap.put("createId", AppContext.currentUserId());
        parameterMap.put("accountId", AppContext.currentAccountId());
        parameterMap.put("state", state);
        return DBAgent.find((String)hql, parameterMap);
    }

    @Override
    public boolean hasSameBizById(Long bizId) throws BusinessException {
        String hql = "select count(id) from CapBizConfig c  where c.id =:createId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("createId", bizId);
        List list = DBAgent.find((String)hql, map);
        int count = Strings.isEmpty((Collection)list) ? 0 : ((Long)list.get(0)).intValue();
        return count > 0;
    }

    @Override
    public boolean updatePeopleBelongBatch(String bizConfigIds, Long ownerId, String ownerName, String moduleFlag, Long accountId) throws BusinessException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String hql = "";
        if ("form".equals(moduleFlag)) {
            hql = "update FormOwner set ownerId = :ownerId " + (null != accountId ? ",orgAccountId = :orgAccountId" : "") + " where formId in (:bizConfigIds) ";
            if (null != accountId) {
                parameterMap.put("orgAccountId", accountId);
            }
        } else if ("biz".equals(moduleFlag)) {
            hql = "update CapBizConfig set ownerId = :ownerId, updateDate = :updateDate where id in (:bizConfigIds) ";
            parameterMap.put("updateDate", DateUtil.currentTimestamp());
        } else if ("bizMap".equals(moduleFlag)) {
            hql = "update CtpBizMap set creatorId = :ownerId, modifierId = :ownerId, modifyTime = :updateDate, orgId = :orgId where id in (:bizConfigIds) ";
            parameterMap.put("updateDate", DateUtil.currentTimestamp());
            parameterMap.put("orgId", accountId);
        }
        String[] idsStr = bizConfigIds.split(",");
        Long[] ids = new Long[idsStr.length];
        for (int i = 0; i < idsStr.length; ++i) {
            ids[i] = Long.parseLong(idsStr[i]);
        }
        parameterMap.put("ownerId", ownerId);
        parameterMap.put("bizConfigIds", ids);
        DBAgent.bulkUpdate((String)hql, parameterMap);
        return true;
    }
}

