/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business;

import com.google.common.collect.Lists;
import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.bizportal.api.BizPortalApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.biz.exception.BizException;
import com.seeyon.cap4.form.biz.vo.BizValidateResultVO;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BizExpireJob;
import com.seeyon.cap4.form.modules.business.BizLicUpdateJob;
import com.seeyon.cap4.form.modules.business.BizMenuAuthCheckInterface;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessDAO;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormOperationBaseManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.event.CapBizConfigChangeEvent;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.modules.importandexport.CapConflictMappingDao;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.po.CapRunningLog;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BizUtil;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.AppInfo;
import com.seeyon.cap4.form.vo.FormTreeNode;
import com.seeyon.cap4.form.vo.ResultInfoVO;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.monitor.service.SlowSqlService;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.config.MessageChannel;
import com.seeyon.ctp.common.config.MessageListener;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.form.modules.bizmap.manager.BizMapManager;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.po.CtpBizMap;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.MemberRole;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.manager.OrgManagerDirect;
import com.seeyon.ctp.organization.manager.RoleManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.portal.nav.bo.PortalNavBo;
import com.seeyon.ctp.portal.portlet.ImagePortletLayout;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.enums.PrivMenuTypeEnums;
import com.seeyon.ctp.privilege.manager.PrivilegeManager;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.privilege.po.PrivMenu;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.BeanUtils;
import com.seeyon.ctp.util.CommonTools;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import www.seeyon.com.biz.BizChicken4;
import www.seeyon.com.biz.enums.BizOperationEnum4;
import www.seeyon.com.utils.DesUtil;
import www.seeyon.com.utils.ReflectUtil;
import www.seeyon.com.utils.StringUtil;

public class BusinessManagerImpl
implements BusinessManager {
    private final Log logger = CtpLogFactory.getLog(BusinessManagerImpl.class);
    private OrgManager orgManager;
    private BusinessDAO businessDAO4;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private PrivilegeManager privilegeManager;
    private RoleManager roleManager;
    private PrivilegeMenuManager privilegeMenuManager;
    private FormAuthModuleDAO formAuthModuleDAO;
    private OrgManagerDirect orgManagerDirect;
    private AppLogManager appLogManager;
    private CAP4FormListManager cap4FormListManager;
    private EnumManager enumManagerNew;
    private CAP4FormDesignManager cap4FormDesignManager;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private FileManager fileManager;
    private CAP4FormBusinessRelationManager cap4FormBusinessRelationManager;
    private BusinessImportAndExportManager businessImportAndExportManager;
    private ValidateManager validateManager;
    private PortalApi portalApi;
    private CapRunningLogManager capRunningLogManager;
    private ReportApi reportApi;
    private ICAP4MagicManager cap4MagicManager;
    private CapBizConfigItemManager capBizConfigItemManager;
    private BizMapManager bizMapManager;
    private CapConflictMappingDao capConflictMappingDao;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private static CacheMap<Long, BizConfigBean> CONFIG_MAP;
    private static CacheMap<Long, BizConfigBean> MENU_MAP;
    private MplusApi mplusApi;
    private MallApi mallApi;
    private BizPortalApi bizPortalApi;
    private AtomicBoolean exit = new AtomicBoolean(false);
    private final ExecutorService executorService = Executors.newCachedThreadPool(new CacheSyncThreadFactory());
    private final long sleepTime = 1800000L;

    public void destroy() throws BusinessException {
        this.exit.set(true);
        this.executorService.shutdownNow();
    }

    public void init() throws BusinessException {
        if (null == CONFIG_MAP) {
            this.businessDAO4.initOrgAccocunt();
            CacheAccessable cacheFactory = CacheFactory.getInstance(BusinessManagerImpl.class);
            CONFIG_MAP = cacheFactory.createMap("CONFIG_MAP");
            MENU_MAP = cacheFactory.createMap("MENU_MAP");
            this.initConfigMap();
        }
        if (SystemEnvironment.isDistributedMode()) {
            PlatformConfigUtil.addMessageListener((MessageChannel)MessageChannel.MPLUS_SERVICE_STARTED, (MessageListener)new MessageListener(){

                public void onMessage(String message) {
                    try {
                        BusinessManagerImpl.this.initConfigMap();
                    }
                    catch (Exception e) {
                        BusinessManagerImpl.this.logger.error((Object)"\u5e94\u7528\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                    }
                }
            });
        }
        this.executorService.submit(new Executor());
        QuartzHolder.deleteQuartzJob((String)BizExpireJob.JOB_NAME);
        QuartzHolder.deleteQuartzJobByGroup((String)BizExpireJob.JOB_GROUP_NAME);
        if (!QuartzHolder.hasQuartzJob((String)BizExpireJob.JOB_GROUP_NAME, (String)BizExpireJob.JOB_NAME)) {
            String HHmmss = "01:00:00";
            try {
                Date beginTime = DateUtil.parse((String)(DateUtil.getDate((Date)DateUtil.currentDate(), (String)"yyyy-MM-dd") + " " + HHmmss), (String)"yyyy-MM-dd HH:mm:ss");
                QuartzHolder.newQuartzJobPerDay((String)BizExpireJob.JOB_GROUP_NAME, (String)BizExpireJob.JOB_NAME, (Date)beginTime, (String)BizExpireJob.JOB_NAME, null);
            }
            catch (Exception e) {
                this.logger.error((Object)"\u5e94\u7528\u5230\u671f\u5b9a\u65f6\u63d0\u9192\u4efb\u52a1\u52a0\u5165\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        QuartzHolder.deleteQuartzJob((String)BizLicUpdateJob.JOB_NAME);
        try {
            QuartzHolder.newQuartzJob((String)BizLicUpdateJob.JOB_NAME, (Date)new Date(), (long)86400000L, (String)BizLicUpdateJob.JOB_NAME, null);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u5e94\u7528\u8bb8\u53ef\u5b9a\u65f6\u66f4\u65b0\u4efb\u52a1\u52a0\u5165\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private void initConfigMap() throws BusinessException {
        CONFIG_MAP.clear();
        MENU_MAP.clear();
        List<CapBizConfig> configs = this.businessDAO4.getAllCtpBizConfig();
        for (CapBizConfig config : configs) {
            BizConfigBean configBean = this.initConfigBean(config);
            this.addCache(configBean);
        }
        for (BizConfigBean bizConfigBean : CONFIG_MAP.values()) {
            this.validateBizConfigBean(bizConfigBean);
            if (bizConfigBean.getAppInfo() == null || bizConfigBean.getAppInfo().getForms() != 0 && bizConfigBean.getAppInfo().getBizRelations() != 0) continue;
            try {
                this.loadBizCounts(bizConfigBean);
            }
            catch (Exception e) {
                this.logger.error((Object)"\u521d\u59cb\u5316\u8868\u5355\u6570\u91cf\u76f8\u5173\u6570\u636e\u540e\u4fdd\u5b58\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    @Override
    public void loadBizCounts(BizConfigBean bizConfigBean) throws Exception {
        Map<String, Object> resultInfoCount = this.getCap4BizInfoCount(bizConfigBean.getId());
        AppInfo appInfo = bizConfigBean.getAppInfo();
        if (StringUtil.isEmpty((String)appInfo.getCreateCorpId())) {
            appInfo.setCreateCorpId(ValidityUtil.getMplusCorpId());
            appInfo.setCreateCorpName(ValidityUtil.getMplusCorpName());
        }
        appInfo.setForms(ParamUtil.getInt(resultInfoCount, (String)"bizFormCount").intValue());
        appInfo.setFields(ParamUtil.getInt(resultInfoCount, (String)"bizFormFieldCount").intValue());
        appInfo.setDataMagics(ParamUtil.getInt(resultInfoCount, (String)"bizMagicCubeCount").intValue());
        appInfo.setBizRelations(ParamUtil.getInt(resultInfoCount, (String)"bizRelationCount").intValue());
        appInfo.setViews(ParamUtil.getInt(resultInfoCount, (String)"bizFormViewCount").intValue());
        bizConfigBean.setBizSourceInfo(DesUtil.encode((String)JSONUtil.toJSONString((Object)appInfo), (String)(bizConfigBean.getId() + "")));
        this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
    }

    private void validateBizConfigBean(BizConfigBean configBean) throws BusinessException {
        if (configBean == null) {
            return;
        }
        if (!this.validateManager.validateRuntime(configBean)) {
            this.logger.info((Object)("\u5e94\u7528\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff1a" + configBean.getName() + "-" + configBean.getId()));
            configBean.setValid(false);
        } else {
            this.logger.info((Object)("\u5e94\u7528\u9a8c\u8bc1\u901a\u8fc7\uff1a" + configBean.getName() + "-" + configBean.getId()));
        }
        ArrayList<CAP4FormCache.FormCacheType> args = new ArrayList<CAP4FormCache.FormCacheType>();
        args.add(0, CAP4FormCache.FormCacheType.BizConfig_Valid_ModiFied);
        args.add(1, (CAP4FormCache.FormCacheType)configBean);
        NotificationManager.getInstance().send(NotificationType.CapFormAppReload, args);
        try {
            if (!configBean.isValid() || configBean.isExpireNoStop()) {
                this.stopBizBean(configBean);
            } else if (configBean.getUseFlag() != null && configBean.getUseFlag().intValue() == BizEnums.BizUseFlag.disable.getKey()) {
                this.stopBizBean(configBean);
            } else {
                this.startBizBean(configBean, true);
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("\u5904\u7406\u5e94\u7528\u542f\u505c\u7528\u5f02\u5e38---" + configBean.getName()), e);
        }
    }

    private void addCache(BizConfigBean configBean) throws BusinessException {
        if (configBean == null) {
            return;
        }
        CONFIG_MAP.put((Serializable)configBean.getId(), (Serializable)configBean);
        MENU_MAP.put((Serializable)configBean.getMenuId(), (Serializable)configBean);
    }

    private BizConfigBean initConfigBean(Long configId) throws BusinessException {
        CapBizConfig config = this.businessDAO4.findBizConfigById(configId);
        if (config == null) {
            return null;
        }
        return this.initConfigBean(config);
    }

    private BizConfigBean initConfigBean(CapBizConfig config) throws BusinessException {
        BizConfigBean configBean = new BizConfigBean();
        BeanUtils.convert((Object)configBean, (Object)config);
        if (configBean.getBizSort() == null) {
            configBean.setBizSort(this.businessDAO4.findMaxSort());
        }
        List list = this.privilegeMenuManager.getListByRole(new Long[]{configBean.getMenuId()});
        PrivMenuBO privMenuBO = this.privilegeManager.findMenuById(config.getMenuId());
        if (privMenuBO != null && Strings.isNotEmpty((String)privMenuBO.getRealName()) && !privMenuBO.getRealName().equals(privMenuBO.getName())) {
            configBean.setAppResourceNameKey(privMenuBO.getRealName());
        }
        List<CtpBizConfigItem> items = BusinessUtil.getConfigItem(list, config);
        configBean.setItems(items);
        configBean.setMenuList(list);
        String[] auth = BusinessUtil.getAuthName(config.getMenuId());
        configBean.setAuthValue(auth[0]);
        configBean.setAuthText(auth[1]);
        V3xOrgMember owner = this.orgManager.getMemberById(configBean.getOwnerId());
        if (owner != null) {
            configBean.setOwnerName(owner.getName());
        }
        this.businessImportAndExportManager.initConflictMappingInfo(configBean);
        return configBean;
    }

    @Override
    public BizConfigBean findBizConfigByFormId(Long formId) throws BusinessException {
        CapBizConfigItem capBizConfigItem;
        if (formId != null && (capBizConfigItem = this.capBizConfigItemManager.findBizInfoByFormId(formId)) != null) {
            return this.findBizConfigById(capBizConfigItem.getBizId());
        }
        return null;
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public BizConfigBean initBizConfig(Long configId, boolean needValidate) throws BusinessException {
        if (configId != null) {
            BizConfigBean bizConfigBean = this.initConfigBean(configId);
            this.addCache(bizConfigBean);
            if (needValidate) {
                this.validateBizConfigBean(bizConfigBean);
            }
            return bizConfigBean;
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public Map<String, Object> listBusiness(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        int businessType = ParamUtil.getInt(params, (String)"businessType", (int)-1);
        boolean showInvalid = Boolean.valueOf(ParamUtil.getString(params, (String)"showInvalid", (String)"false"));
        boolean showNotUse = Boolean.valueOf(ParamUtil.getString(params, (String)"showNotUse", (String)"false"));
        if (businessType == BizEnums.BizOrderPlatformType.operationCenter.getKey()) {
            params.put("publishFlag", BizEnums.BizPublishState.published.getKey());
        }
        List roles = this.orgManager.getMemberRoles(Long.valueOf(AppContext.currentUserId()), null);
        ArrayList<Long> rolesIds = new ArrayList<Long>();
        rolesIds.add(0L);
        for (MemberRole memberRole : roles) {
            if (memberRole.getRole() == null) continue;
            rolesIds.add(memberRole.getRole().getId());
        }
        params.put("roleids", rolesIds);
        List<Object> listMap = new ArrayList();
        if (!showInvalid) {
            int n;
            List<Map<String, Object>> listMapAll = this.businessDAO4.findAllByCondition(null, params);
            Iterator<Map<String, Object>> iterator = listMapAll.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> map = iterator.next();
                Long l = ParamUtil.getLong(map, (String)"id");
                BizConfigBean bizConfigBean = this.findBizConfigById(l);
                if (bizConfigBean == null) {
                    iterator.remove();
                    continue;
                }
                if (!bizConfigBean.isValid() || bizConfigBean.isExpire()) {
                    iterator.remove();
                    continue;
                }
                if (showNotUse || null == bizConfigBean.getUseFlag() || 0 != bizConfigBean.getUseFlag()) continue;
                iterator.remove();
            }
            fi.setTotal(listMapAll.size());
            int fromIndex = (fi.getPage() - 1) * fi.getSize();
            int n2 = fi.getPage() * fi.getSize();
            if (n2 >= listMapAll.size()) {
                n = listMapAll.size();
            }
            try {
                if (!listMapAll.isEmpty()) {
                    listMap = listMapAll.subList(fromIndex, n);
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"\u5206\u9875\u53c2\u6570\u5f02\u5e38\uff0c\u4e0d\u7528\u5206\u9875");
                listMap = listMapAll;
            }
        } else {
            listMap = this.businessDAO4.findAllByCondition(fi, params);
        }
        ArrayList<Map> returnMap = new ArrayList<Map>();
        try {
            if (listMap != null) {
                ArrayList cloudAppMapList = CAPParamUtil.getParamsListByKey(params, (String)"cloudApp");
                if (cloudAppMapList == null) {
                    cloudAppMapList = new ArrayList();
                }
                for (Map map : listMap) {
                    Date endDate;
                    Long bizConfigId = ParamUtil.getLong((Map)map, (String)"id");
                    BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
                    String[] auth = BusinessUtil.getAuthName((Long)map.get("menuId"));
                    map.put("ownerName", this.orgManager.getMemberById(ParamUtil.getLong((Map)map, (String)"ownerId")).getName());
                    map.put("createUserName", this.orgManager.getMemberById(ParamUtil.getLong((Map)map, (String)"createUser")).getName());
                    map.put("authName", auth[1]);
                    map.put("authId", auth[0]);
                    int publishState = ParamUtil.getInt((Map)map, (String)"publishFlag", (int)0);
                    map.put("publishState", publishState);
                    map.put("publishStateValue", BizEnums.BizPublishState.getStateByKey((int)publishState).getName());
                    if (Strings.isEmpty((String)ParamUtil.getString((Map)map, (String)"bizIcon"))) {
                        map.put("bizIcon", "vp-application");
                    }
                    map.put("useFlag", bizConfigBean.getUseFlag() == null ? "1" : bizConfigBean.getUseFlag());
                    map.put("endLineFlag", bizConfigBean.isExpire());
                    map.put("endLineDay", bizConfigBean.getExpDates());
                    map.put("validFlag", bizConfigBean.isValid());
                    String bizVersion = ParamUtil.getString((Map)map, (String)"bizVersion", (String)"");
                    map.put("bizVersion", Strings.isNotEmpty((String)bizVersion) && bizVersion.contains(".") ? bizVersion : "");
                    map.put("appSourceValue", bizConfigBean.getAppSourceValue());
                    map.put("total", bizConfigBean.getTotal());
                    map.put("rest", bizConfigBean.getRest());
                    map.put("authto", bizConfigBean.getAuthto());
                    map.put("authtoState", bizConfigBean.getAuthtoState());
                    map.put("authtime", bizConfigBean.getAuthTime());
                    map.put("fileId", "");
                    map.put("versionFlag", false);
                    map.put("versionLocalFlag", false);
                    if (null != cloudAppMapList) {
                        for (Map cloudApp : cloudAppMapList) {
                            if (!bizConfigId.equals(CAPParamUtil.getLong((Map)cloudApp, (String)"goodsAppId"))) continue;
                            String currentVersion = CAPParamUtil.getString((Map)cloudApp, (String)"currentVersion");
                            String version = CAPParamUtil.getString((Map)cloudApp, (String)"version");
                            map.put("orderGoodsId", CAPParamUtil.getString((Map)cloudApp, (String)"orderGoodsId"));
                            map.put("versionId", CAPParamUtil.getString((Map)cloudApp, (String)"versionId"));
                            map.put("adaptationPlatform", CAPParamUtil.getString((Map)cloudApp, (String)"adaptationPlatform"));
                            map.put("adaptationVersion", CAPParamUtil.getString((Map)cloudApp, (String)"adaptationVersion"));
                            map.put("versionDesc", CAPParamUtil.getString((Map)cloudApp, (String)"versionDesc"));
                            map.put("createTime", CAPParamUtil.getString((Map)cloudApp, (String)"createTime"));
                            map.put("currentVersion", CAPParamUtil.getString((Map)cloudApp, (String)"currentVersion"));
                            map.put("name", CAPParamUtil.getString((Map)cloudApp, (String)"name"));
                            try {
                                if (!this.versionCompare(bizVersion, currentVersion)) {
                                    map.put("versionLocalFlag", true);
                                    map.put("fileId", CAPParamUtil.getString((Map)cloudApp, (String)"downloadUrl"));
                                }
                                if (this.versionCompare(version, currentVersion)) continue;
                                map.put("versionFlag", true);
                            }
                            catch (Exception e) {
                                this.logger.error((Object)("\u5e94\u7528\u7248\u672c\u65e0\u6cd5\u89e3\u6790, bizVersion:" + bizVersion + ", currentVersion" + currentVersion));
                            }
                        }
                    }
                    if (map.containsKey("endDate") && map.get("endDate") instanceof Date && DateUtil.getDate((Date)(endDate = (Date)map.get("endDate")), (String)"yyyy-MM-dd").equals(ValidityUtil.MAX_END_DATE_STR)) {
                        map.remove("endDate");
                    }
                    returnMap.add(map);
                }
            }
            fi.setData(returnMap);
            HashMap invalidBusiness = new HashMap();
            for (BizConfigBean bizConfigBean : CONFIG_MAP.values()) {
                if (bizConfigBean.isValid()) continue;
                if (!invalidBusiness.containsKey(bizConfigBean.getInvalidReson())) {
                    invalidBusiness.put(bizConfigBean.getInvalidReson(), new ArrayList());
                }
                ((List)invalidBusiness.get(bizConfigBean.getInvalidReson())).add(bizConfigBean);
            }
            resultMap.put("invalidBusiness", invalidBusiness);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        resultMap.put("validBusiness", fi);
        return resultMap;
    }

    @Override
    public List<BizConfigBean> getAllBizConfigInCache() throws BusinessException {
        ArrayList<BizConfigBean> configs = new ArrayList<BizConfigBean>();
        for (BizConfigBean bizConfigBean : CONFIG_MAP.values()) {
            configs.add(bizConfigBean);
        }
        return configs;
    }

    @Override
    public List getBusinessList4CurrentUser() throws BusinessException {
        return this.getBusinessList4CurrentUser(false);
    }

    @Override
    public List getBusinessList4CurrentUser(boolean showNotUse) throws BusinessException {
        HashMap<String, String> flParam = new HashMap<String, String>();
        flParam.put("page", "1");
        flParam.put("size", "-1");
        flParam.put("sortField", "UPDATE_DATE");
        flParam.put("sortOrder", "DESC");
        FlipInfo fl = new FlipInfo(flParam);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("businessType", 0);
        param.put("showNotUse", String.valueOf(showNotUse));
        Map<String, Object> business = this.listBusiness(fl, param);
        FlipInfo validBusiness = (FlipInfo)business.get("validBusiness");
        List data = null;
        if (validBusiness != null) {
            data = validBusiness.getData();
        }
        return data;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public FlipInfo listBusinessLicenses(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        List roles = this.orgManager.getMemberRoles(Long.valueOf(AppContext.currentUserId()), null);
        ArrayList<Long> rolesIds = new ArrayList<Long>();
        rolesIds.add(0L);
        for (Object memberRole : roles) {
            if (memberRole.getRole() == null) continue;
            rolesIds.add(memberRole.getRole().getId());
        }
        params.put("roleids", rolesIds);
        params.put("orderByEndDate", true);
        List<Map<String, Object>> listMap = this.businessDAO4.findAllByCondition(fi, params);
        try {
            if (listMap != null) {
                for (Map map : listMap) {
                    Date endDate;
                    String bizVersion;
                    Long bizConfigId = ParamUtil.getLong((Map)map, (String)"id");
                    BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
                    BizEnums.BizCreateSourceType bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)bizConfigBean.getBizCreateType());
                    String source = bizCreateSourceType.getName(true);
                    if (map.containsKey("trial") && map.get("trial") != null && BizEnums.BizTrial.trial.getKey() == Integer.valueOf(map.get("trial").toString()).intValue()) {
                        source = bizCreateSourceType.getTrialName(true);
                    }
                    map.put("source", source);
                    map.put("ownerName", this.orgManager.getMemberById(ParamUtil.getLong((Map)map, (String)"ownerId")).getName());
                    map.put("createUserName", this.orgManager.getMemberById(ParamUtil.getLong((Map)map, (String)"createUser")).getName());
                    String authto = bizConfigBean.getAuthto();
                    map.put("total", bizConfigBean.getTotal());
                    map.put("rest", bizConfigBean.getRest());
                    map.put("authto", authto);
                    int authtoState = 0;
                    if (Strings.isEmpty((String)authto)) {
                        authtoState = 1;
                    } else if (!ValidityUtil.getMplusCorpName().equalsIgnoreCase(authto)) {
                        authtoState = 2;
                    }
                    map.put("authtoState", authtoState);
                    String[] auth = BusinessUtil.getAuthName((Long)map.get("menuId"));
                    map.put("authName", auth[1]);
                    map.put("authtime", bizConfigBean.getAuthTime());
                    map.put("authId", auth[0]);
                    int publishState = ParamUtil.getInt((Map)map, (String)"publishFlag", (int)0);
                    map.put("publishState", publishState);
                    map.put("publishStateValue", BizEnums.BizPublishState.getStateByKey((int)publishState).getName());
                    if (Strings.isEmpty((String)ParamUtil.getString((Map)map, (String)"bizIcon"))) {
                        map.put("bizIcon", "vp-application");
                    }
                    map.put("bizVersion", Strings.isNotEmpty((String)(bizVersion = ParamUtil.getString((Map)map, (String)"bizVersion", (String)""))) && bizVersion.contains(".") ? bizVersion : "");
                    if (map.containsKey("endDate") && map.get("endDate") instanceof Date && DateUtil.getDate((Date)(endDate = (Date)map.get("endDate")), (String)"yyyy-MM-dd").equals(ValidityUtil.MAX_END_DATE_STR)) {
                        map.remove("endDate");
                    }
                    map.put("showUpdate", true);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> listBusinessInstall() throws BusinessException {
        HashMap<String, Object> businessMap = new HashMap<String, Object>();
        businessMap.put("bindFlag", BusinessUtil.isBindMplusAccount());
        ArrayList<Map<String, Object>> cloudAppMapList = new ArrayList<Map<String, Object>>();
        this.addNewMallList(cloudAppMapList);
        this.addOldMallList(cloudAppMapList);
        businessMap.put("cloudApp", cloudAppMapList);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessType", BizEnums.BizOrderPlatformType.managementCenter.getKey());
        params.put("cloudApp", cloudAppMapList);
        FlipInfo fi = new FlipInfo(-1, -1);
        this.listBusiness(fi, params);
        businessMap.put("installedApp", fi.getData());
        return businessMap;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public BizConfigBean findBizConfigById(Long bizConfigId) throws BusinessException {
        BizConfigBean configBean = (BizConfigBean)CONFIG_MAP.get((Serializable)bizConfigId);
        if (configBean == null && (configBean = this.initConfigBean(bizConfigId)) != null) {
            this.addCache(configBean);
            this.validateBizConfigBean(configBean);
        }
        return configBean;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo listUnifiedAuth(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId");
        String queryType = ParamUtil.getString(params, (String)"queryType");
        String queryValue = ParamUtil.getString(params, (String)"queryValue");
        if (bizConfigId != null) {
            List<FormAppBO> formList = this.getFormListByBizId(bizConfigId);
            if (Strings.isNotBlank((String)queryType) && Strings.isNotBlank((String)queryValue)) {
                ArrayList<FormAppBO> formListReturn = new ArrayList<FormAppBO>();
                for (FormAppBO fabo : formList) {
                    if ("tName".equals(queryType)) {
                        if (fabo.getName().indexOf(queryValue) == -1) continue;
                        formListReturn.add(fabo);
                        continue;
                    }
                    if (!"tType".equals(queryType) || fabo.getSourceType() != Integer.parseInt(queryValue)) continue;
                    formListReturn.add(fabo);
                }
                formList = formListReturn;
            }
            if (fi == null) {
                fi = new FlipInfo();
            }
            int size = fi.getSize();
            int curpage = fi.getPage();
            int totle = formList != null && formList.size() > 0 ? formList.size() : 0;
            fi.setTotal(totle);
            if (formList != null && formList.size() > 0) {
                if (totle <= size) {
                    fi.setData(formList);
                    fi.setPage(1);
                } else {
                    fi.setData(formList.subList((curpage - 1) * size, size * curpage > totle ? totle : size * curpage));
                }
            }
        }
        return fi;
    }

    @Override
    public List<FormAppBO> getFormListByBizId(Long bizConfigId) throws BusinessException {
        BizConfigBean bizConfig = this.findBizConfigById(bizConfigId);
        if (bizConfig != null) {
            ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
            List<BusinessAuthorityManager> managerList = BusinessUtil.getSortedManagerList();
            if (!managerList.isEmpty()) {
                for (BusinessAuthorityManager manager : managerList) {
                    formBoList.addAll(manager.getFormAppBOList(bizConfigId));
                }
            }
            BusinessUtil.authSort(formBoList);
            return formBoList;
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<Map<String, Object>> getPublishedFormListByBizId(Long bizConfigId) throws BusinessException {
        if (bizConfigId != null) {
            ArrayList<Map<String, Object>> formList = new ArrayList<Map<String, Object>>();
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                FormBean fb;
                Long formId = capBizConfigItem.getFormId();
                if (formId == null || (fb = this.cap4FormCacheManager.getForm(formId)).getPublishFlag() != Enums.FormPublishFlagEnum.published.getKey()) continue;
                HashMap<String, String> formMap = new HashMap<String, String>();
                formMap.put("entityId", formId.toString());
                formMap.put("displayName", fb.getFormName());
                formList.add(formMap);
            }
            return formList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<FormBean> getFormBeanListByBizId(Long bizConfigId) throws BusinessException {
        if (bizConfigId != null) {
            ArrayList<FormBean> formList = new ArrayList<FormBean>();
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                Long formId = capBizConfigItem.getFormId();
                if (formId == null) continue;
                FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                if (null != formBean) {
                    formList.add(formBean);
                    continue;
                }
                this.logger.error((Object)("\u8868\u5355id\uff1a" + formId + "\u5728\u7f13\u5b58\u4e2d\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7f13\u5b58\u3002"));
            }
            return formList;
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void unifiedAuthSave(String auths) throws Exception {
        if (Strings.isNotEmpty((String)auths)) {
            List jsonArray = (List)JSONUtil.parseJSONString((String)auths);
            for (Map jsonObject : jsonArray) {
                BusinessAuthorityManager businessAuthorityManager;
                FormAppBO fabo = (FormAppBO)JSONUtil.parseJSONString((String)jsonObject.toString(), FormAppBO.class);
                if (fabo == null || (businessAuthorityManager = BusinessUtil.getBusinessAuthorityManager(fabo.getSourceType())) == null) continue;
                businessAuthorityManager.saveAuthority(fabo);
            }
            this.privilegeMenuManager.updateBiz();
            this.portalApi.clearPortalMenusCache();
        }
    }

    @Override
    public List<CAPFormDefinition> getCAP4FormByBizId(Long bizConfigId) throws BusinessException {
        return this.cap4FormDefinitionDAO.queryBizForms(bizConfigId, null);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    @Deprecated
    public Map<String, Object> getUnifiedAuth(String bizConfigId) throws BusinessException {
        if (Strings.isNotEmpty((String)bizConfigId)) {
            BizConfigBean bizConfig = this.findBizConfigById(Long.parseLong(bizConfigId));
            HashMap<String, Object> returnValue = new HashMap<String, Object>();
            returnValue.put("scopeIds", bizConfig.getAuthValue());
            returnValue.put("scopeNames", bizConfig.getAuthText());
            return returnValue;
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void unifiedAuthRemove(String auths) throws Exception {
        if (Strings.isNotEmpty((String)auths)) {
            List jsonArray = (List)JSONUtil.parseJSONString((String)auths);
            for (Map jsonObject : jsonArray) {
                BusinessAuthorityManager businessAuthorityManager;
                FormAppBO fabo = (FormAppBO)JSONUtil.parseJSONString((String)jsonObject.toString(), FormAppBO.class);
                if (fabo == null || (businessAuthorityManager = BusinessUtil.getBusinessAuthorityManager(fabo.getSourceType())) == null) continue;
                businessAuthorityManager.removeAuthority(fabo);
            }
            this.privilegeMenuManager.updateBiz();
            this.portalApi.clearPortalMenusCache();
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<FormTreeNode> getBizFormTree(String bizConfigId, Map<String, Object> queryParame) throws BusinessException {
        ArrayList<FormTreeNode> formTreeNodes = new ArrayList<FormTreeNode>();
        if (Strings.isNotEmpty((String)bizConfigId)) {
            Long bizId = Long.parseLong(bizConfigId);
            BizConfigBean bizConfigBean = this.findBizConfigById(bizId);
            FormTreeNode formTreeNode = new FormTreeNode();
            formTreeNode.setId(bizConfigBean.getId() + "");
            formTreeNode.setName(bizConfigBean.getName());
            formTreeNode.setParentId("-1");
            formTreeNode.setType("1");
            formTreeNodes.add(formTreeNode);
            List<CAPFormDefinition> bizForms = this.cap4FormDefinitionDAO.queryBizForms(bizConfigBean.getId(), queryParame);
            for (CAPFormDefinition capFormDefinition : bizForms) {
                formTreeNode = new FormTreeNode();
                formTreeNode.setId(capFormDefinition.getId() + "");
                formTreeNode.setName(capFormDefinition.getName());
                formTreeNode.setParentId(bizConfigId);
                formTreeNode.setType(capFormDefinition.getFormType() + "");
                if (capFormDefinition.getState().equals(Enums.FormStateEnum.official.getKey())) {
                    formTreeNode.setCanSelect(true);
                } else {
                    formTreeNode.setCanSelect(false);
                }
                HashMap<String, String> formInfo = new HashMap<String, String>();
                FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(capFormDefinition.getId());
                if (formOwner != null) {
                    V3xOrgMember member = this.orgManager.getMemberById(formOwner.getOwnerId());
                    formInfo.put("creator", member.getName());
                }
                FormBean formBean = this.cap4FormCacheManager.getForm(capFormDefinition.getId());
                formInfo.put("goods", BusinessEnums.FormAttribute.NORMAL.getKey());
                String authTo = bizConfigBean.getAuthto();
                if (formBean != null) {
                    BusinessEnums.FormAttribute formAttribute = formBean.getFormAttribute();
                    if (null == formAttribute) {
                        formAttribute = BusinessEnums.FormAttribute.NORMAL;
                    }
                    formInfo.put("goods", formAttribute.getKey());
                    formInfo.put("sourceType", ResourceUtil.getString((String)formAttribute.getText()));
                    if (!"".equals(formBean.getFormAuthTo())) {
                        authTo = formBean.getFormAuthTo();
                    }
                }
                formInfo.put("bizName", bizConfigBean.getName());
                formInfo.put("createTime", DateUtil.format((Date)capFormDefinition.getCreateTime(), (String)"yyyy-MM-dd HH:mm"));
                formInfo.put("modifyTime", DateUtil.format((Date)capFormDefinition.getModifyTime(), (String)"yyyy-MM-dd HH:mm"));
                formInfo.put("authto", authTo);
                formTreeNode.setProperties(formInfo);
                formTreeNodes.add(formTreeNode);
            }
        } else {
            FormTreeNode formTreeNode = new FormTreeNode();
            formTreeNode.setId("0");
            formTreeNode.setName(ResourceUtil.getString((String)"com.cap.biz.nonamebiz"));
            formTreeNode.setParentId("-1");
            formTreeNode.setType("1");
            formTreeNodes.add(formTreeNode);
        }
        return formTreeNodes;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> getCap4BizRealtion(String bizConfigId, String sourceFormId) throws BusinessException {
        if (Strings.isNotEmpty((String)sourceFormId)) {
            Long sFormId = Long.parseLong(sourceFormId);
            List<CAPFormBusinessRelation> capFormBusinessRelations = this.cap4FormCacheManager.getCap4FormBusinessRelationDAO().selectAll(sFormId);
            List<CAPFormBusinessRelation> targetcapFormBusinessRelations = this.cap4FormCacheManager.getCap4FormBusinessRelationDAO().selectByTargetFormId(sFormId);
            HashSet<Long> targetFormIdSet = new HashSet<Long>();
            for (CAPFormBusinessRelation cAPFormBusinessRelation : capFormBusinessRelations) {
                targetFormIdSet.add(cAPFormBusinessRelation.getTargetFormId());
            }
            HashSet<Long> othersFormIdSet = new HashSet<Long>();
            for (CAPFormBusinessRelation cbr : targetcapFormBusinessRelations) {
                if (!targetFormIdSet.contains(cbr.getSourceFormId())) {
                    othersFormIdSet.add(cbr.getSourceFormId());
                }
                targetFormIdSet.add(cbr.getSourceFormId());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("targetFormIdSet", targetFormIdSet);
            hashMap.put("othersFormIdSet", othersFormIdSet);
            return this.cap4FormBusinessRelationManager.getRelationOrTriggerCountByFormId(sFormId, hashMap);
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> showCap4FormView(String bizConfigId, String formId) throws BusinessException {
        if (Strings.isNotEmpty((String)formId)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
            if (formBean != null) {
                map.put("formId", formId);
                map.put("formName", formBean.getFormName());
                map.put("formState", formBean.getState());
                map.put("formStateName", Enums.FormStateEnum.getEnumByKey((int)formBean.getState()).getText());
                List formViewList = formBean.getFormViewList();
                if (CollectionUtils.isNotEmpty((Collection)formViewList)) {
                    ArrayList viewList = new ArrayList();
                    ArrayList phoneViewList = new ArrayList();
                    for (FormViewBean formViewBean : formViewList) {
                        HashMap<String, Object> viewMap = new HashMap<String, Object>();
                        viewMap.put("viewId", formViewBean.getId());
                        viewMap.put("viewName", formViewBean.getFormViewName());
                        viewMap.put("viewType", formViewBean.getFormViewType());
                        if (formViewBean.getFormViewType().equals(Enums.ViewType.SeeyonForm.getText())) {
                            viewList.add(viewMap);
                            continue;
                        }
                        if (!formViewBean.getFormViewType().equals(Enums.ViewType.Phone.getText())) continue;
                        phoneViewList.add(viewMap);
                    }
                    map.put("viewData", viewList);
                    map.put("phoneViewData", phoneViewList);
                }
                return map;
            }
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void menuAuthSave(Long bizConfigId, String authValue) throws Exception {
        if (bizConfigId != null) {
            BizConfigBean bizConfig = this.findBizConfigById(bizConfigId);
            CapBizConfig capBizConfig = bizConfig.getConfig();
            capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", authValue);
            this.doSaveOrUpdateBizConfig(capBizConfig);
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> deleteCap4BizConfig(String bizConfigId) throws BusinessException, SQLException {
        Long bizId;
        BizConfigBean bizConfig;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (Strings.isNotEmpty((String)bizConfigId) && (bizConfig = this.findBizConfigById(bizId = Long.valueOf(Long.parseLong(bizConfigId)))) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizId);
            if (CollectionUtils.isNotEmpty(capBizConfigItemList)) {
                String formIds = "";
                for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                    formIds = Strings.joinDelNull((String)",", (String[])new String[]{formIds, capBizConfigItem.getFormId().toString()});
                }
                List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
                if (Strings.isNotEmpty(checkFormEdit)) {
                    result.put("success", false);
                    result.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                    return result;
                }
                String checkFormData = this.cap4FormListManager.checkForm(formIds);
                if (Strings.isNotEmpty((String)checkFormData)) {
                    result.put("success", false);
                    result.put("message", checkFormData);
                    return result;
                }
                this.capBusinessTemplateManager.deleteCAPBusinessTemplatesByBizId(bizConfig.getId());
                this.cap4FormListManager.deleteForms(formIds);
                this.reportApi.deleteReportDesign(ApplicationCategoryEnum.cap4biz.name(), bizConfig.getId());
                this.capBizConfigItemManager.deleteAll(capBizConfigItemList);
            }
            this.capConflictMappingDao.deleteConflictMappingByAppId(bizConfig.getId());
            List ctpBizMapListByBiz = this.bizMapManager.getBizMapByBizId(bizId);
            if (Strings.isNotEmpty((Collection)ctpBizMapListByBiz)) {
                ArrayList<Long> bizMapIdList = new ArrayList<Long>();
                for (CtpBizMap ctpBizMap : ctpBizMapListByBiz) {
                    bizMapIdList.add(ctpBizMap.getId());
                }
                this.bizMapManager.deleteBizMap(bizMapIdList);
            }
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_Delete, new String[]{AppContext.currentUserName(), bizConfig.getName()});
            this.logger.info((Object)ResourceUtil.getString((String)"appLog.action.213", (Object)AppContext.currentUserName(), (Object)bizConfig.getName()));
            this.orgManagerDirect.deleteRole2Entity(bizConfig.getMenuId(), null, null);
            try {
                if (CollectionUtils.isNotEmpty((Collection)bizConfig.getItems())) {
                    this.privilegeManager.cleanFormPrivData(bizConfig.getMenuId());
                    BusinessUtil.deleteI18n(bizConfig.getMenuList());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"cleanFormPrivData error:", (Throwable)e);
            }
            this.bizPortalApi.deleteBizPortalSpaceAll(bizId, AppContext.getCurrentUser());
            BusinessUtil.removeBizPortalInfo(bizConfig);
            this.portalApi.transDeletePortalSet(bizConfig.getId() + "");
            BusinessUtil.sendMsg(null, bizConfig);
            CONFIG_MAP.remove((Serializable)bizConfig.getId());
            MENU_MAP.remove((Serializable)bizConfig.getMenuId());
            this.businessDAO4.deleteBizConfig(bizId);
            BizValidateResultVO bizValidateResultVO = this.validateManager.validateBiz(bizConfig, BizOperationEnum4.delete_app_save);
            if (!bizValidateResultVO.isSuccess()) {
                this.logger.info((Object)("bizValidateResultVO\uff1a" + bizValidateResultVO.getCode()));
            }
            this.roleManager.deleteRole(new Long[]{bizConfig.getMenuId()});
            this.privilegeMenuManager.updateBiz();
            this.dispatcherBizFireEvent(bizConfig, "delete");
        }
        result.put("success", true);
        return result;
    }

    @Override
    public void cap4BizImportRollBack(Long bizConfigId) throws BusinessException {
        Long menuId;
        BizConfigBean bizConfig;
        if (bizConfigId != null && (bizConfig = this.findBizConfigById(bizConfigId)) != null && (menuId = bizConfig.getMenuId()) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            this.capBizConfigItemManager.deleteAll(capBizConfigItemList);
            this.orgManagerDirect.deleteRole2Entity(menuId, null, null);
            try {
                if (CollectionUtils.isNotEmpty((Collection)bizConfig.getItems())) {
                    this.privilegeManager.cleanFormPrivData(menuId);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"cleanFormPrivData error:", (Throwable)e);
            }
            CONFIG_MAP.remove((Serializable)bizConfig.getId());
            MENU_MAP.remove((Serializable)bizConfig.getMenuId());
            this.businessDAO4.deleteBizConfig(bizConfigId);
            this.capConflictMappingDao.deleteConflictMappingByAppId(bizConfigId);
            BizValidateResultVO bizValidateResultVO = this.validateManager.validateBiz(bizConfig, BizOperationEnum4.delete_app_save);
            if (!bizValidateResultVO.isSuccess()) {
                this.logger.info((Object)("cap4BizImportRollBack\uff1a" + bizValidateResultVO.getCode()));
            }
            this.roleManager.deleteRole(new Long[]{menuId});
            this.privilegeMenuManager.updateBiz();
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void validateNewBiz() throws Exception {
        BizValidateResultVO bizValidateResultVO = this.validateManager.preValidateBiz(BizEnums.BizCreateSourceType.SelfCreate.getKey(), BizOperationEnum4.create_app_save);
        if (!bizValidateResultVO.isSuccess()) {
            throw new BizException(bizValidateResultVO.getCode(), BizChicken4.getTotalNum() + "");
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> deleteFormBelongsBiz(Long formId, Long bizConfigId) throws BusinessException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (formId != null && bizConfigId != null) {
            BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
            FormBean fb = this.cap4FormCacheManager.getForm(formId);
            HashSet<Long> menuIdList = new HashSet<Long>();
            ArrayList<Long> templateIdList = new ArrayList<Long>();
            List privMenuBOList = bizConfigBean.getMenuList();
            if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
                List templateList = this.templateManager.getCtpTemplates(formId.longValue(), false);
                for (CtpTemplate ctpTemplate : templateList) {
                    templateIdList.add(ctpTemplate.getId());
                }
            } else if (fb.getFormType() == Enums.FormType.unFlowForm.getKey() && fb.getBind() != null) {
                Map unTemplates = fb.getBind().getUnFlowTemplateMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    FormBindAuthBean template = (FormBindAuthBean)entry.getValue();
                    templateIdList.add(template.getId());
                }
            }
            if (Strings.isNotEmpty((Collection)privMenuBOList) && Strings.isNotEmpty(templateIdList)) {
                for (PrivMenuBO privMenuBO : privMenuBOList) {
                    if (!templateIdList.contains(privMenuBO.getExt17()) || privMenuBO.getType().intValue() != PrivMenuTypeEnums.businessCap4Menu.getKey() || privMenuBO.getExt12() != 1 && privMenuBO.getExt12() != 2) continue;
                    menuIdList.add(privMenuBO.getId());
                }
            }
            this.cap4FormListManager.deleteForms(formId.toString());
            this.capBizConfigItemManager.deleteByBizIdAndFormId(bizConfigId, formId);
            if (Strings.isNotEmpty(menuIdList)) {
                try {
                    this.privilegeMenuManager.deleteMenu(menuIdList.toArray(new Long[menuIdList.size()]));
                    this.addCache(this.initConfigBean(bizConfigBean.getId()));
                }
                catch (Exception e) {
                    this.logger.error((Object)"deleteFormBelongsBiz error:", (Throwable)e);
                }
                this.privilegeMenuManager.updateBiz();
                this.portalApi.clearPortalMenusCache();
            }
            result.put("success", true);
        }
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> checkFormBelongsBiz(Long formId, Long bizConfigId) throws BusinessException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (formId != null && bizConfigId != null) {
            FormBean currentForm = this.cap4FormCacheManager.getForm(formId);
            List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formId + "");
            if (Strings.isNotEmpty(checkFormEdit)) {
                result.put("success", false);
                result.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                return result;
            }
            String checkFormData = this.cap4FormListManager.checkForm(formId + "");
            if (Strings.isNotEmpty((String)checkFormData)) {
                result.put("success", false);
                result.put("message", checkFormData);
                return result;
            }
            List<FormRelationshipBean> formRelationshipBeanList = this.cap4FormBusinessRelationManager.getFormRelationshipBeanByTargetFormId(formId);
            for (FormRelationshipBean formRelationshipBean : formRelationshipBeanList) {
                if (!FormRelationEnums.relationApplicationType.between.getKey().equals(formRelationshipBean.getApplicationType())) continue;
                Long l = formRelationshipBean.getSourceFormId();
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"com.cap.biz.relation.cannotdel", (Object)formRelationshipBean.getName(), (Object)this.cap4FormCacheManager.getForm(l).getFormName()));
                return result;
            }
            List<FormTriggerBean> formTriggerBeanList = this.cap4FormBusinessRelationManager.getFormTriggerBeanByTargetFormId(formId);
            for (FormTriggerBean formTriggerBean : formTriggerBeanList) {
                if (FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(formTriggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(formTriggerBean.getType())) continue;
                Long relSourceFormId = formTriggerBean.getSourceFormId();
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"com.cap.biz.trigger.cannotdel", (Object)formTriggerBean.getName(), (Object)this.cap4FormCacheManager.getForm(relSourceFormId).getFormName()));
                return result;
            }
            List<CAPFormBusinessRelation> list = this.cap4FormCacheManager.getCap4FormBusinessRelationDAO().selectAll(formId);
            for (CAPFormBusinessRelation capFormBusinessRelation : list) {
                String relationName;
                String string = relationName = capFormBusinessRelation != null ? capFormBusinessRelation.getName() : "";
                if (Enums.FormBusinessRelationType.RELATION.getKey().equals(capFormBusinessRelation.getType())) {
                    if (FormRelationEnums.relationApplicationType.between.getKey().equals(capFormBusinessRelation.getAppType())) {
                        Long relTargetFormId = capFormBusinessRelation.getTargetFormId();
                        result.put("success", false);
                        result.put("message", ResourceUtil.getString((String)"com.cap.biz.relation.cannotdel", (Object)relationName, (Object)this.cap4FormCacheManager.getForm(relTargetFormId).getFormName()));
                        return result;
                    }
                    result.put("success", false);
                    result.put("message", ResourceUtil.getString((String)"com.cap.biz.relation.cannotdel.notable", (Object)relationName));
                    return result;
                }
                if (!Enums.FormBusinessRelationType.TRIGGER.getKey().equals(capFormBusinessRelation.getType())) continue;
                Long relTargetFormId = capFormBusinessRelation.getTargetFormId();
                FormBean formBean = this.cap4FormCacheManager.getForm(relTargetFormId);
                if (null == formBean) {
                    result.put("message", ResourceUtil.getString((String)"com.cap.biz.trigger.cannotdel.notable", (Object)relationName));
                } else {
                    result.put("message", ResourceUtil.getString((String)"com.cap.biz.trigger.cannotdel", (Object)relationName, (Object)formBean.getFormName()));
                }
                result.put("success", false);
                return result;
            }
            List<FormRelationshipMapBean> list2 = this.cap4MagicManager.getRelationBeansByFormId(formId);
            if (list2 != null && !list2.isEmpty()) {
                FormRelationshipMapBean values = list2.get(0);
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"com.cap.biz.relation.cannotdel.notable", (Object)values.getRelationshipBean().getName()));
                return result;
            }
            List<FormTriggerActionBean> magicTriggers = this.cap4MagicManager.getTriggerBeanByFormId(formId);
            if (magicTriggers != null && !magicTriggers.isEmpty()) {
                FormTriggerActionBean action = magicTriggers.get(0);
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"com.cap.biz.trigger.cannotdel.notable", (Object)action.getName()));
                return result;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("categoryId", bizConfigId.toString());
            params.put("category", ApplicationCategoryEnum.cap4biz.name());
            params.put("designTypeList", new String[]{ReportConstants.DesignType.QUERY.name(), ReportConstants.DesignType.STATISTICS.name(), ReportConstants.DesignType.MULTSTATS.name(), ReportConstants.DesignType.SCHEDULEDSTATS.name()});
            List results = this.reportApi.findDesignWithoutAuth(params);
            for (Map map : results) {
                String[] formIdArray;
                String title = ParamUtil.getString((Map)map, (String)"title");
                String type = map.get("designType").toString();
                String formIds = ParamUtil.getString((Map)map, (String)"formmainIds");
                if (!Strings.isNotEmpty((String)formIds)) continue;
                for (String fid : formIdArray = formIds.split(",")) {
                    if (!formId.equals(Long.valueOf(fid))) continue;
                    result.put("success", false);
                    result.put("message", ResourceUtil.getString((String)"com.cap.biz.relation.cannotdel.othertype", (Object)ResourceUtil.getString((String)ReportConstants.DesignType.getByName((String)type).getI18n()), (Object)title));
                    return result;
                }
            }
            List<CAP4FormOperationBaseManager> checkManagers = this.cap4FormDesignManager.getCheckManagerList(currentForm.getFormType());
            ResultInfoVO resultInfoVO = null;
            for (CAP4FormOperationBaseManager manager : checkManagers) {
                resultInfoVO = manager.checkFormBean4Delete(currentForm);
                if (resultInfoVO.isSuccess()) continue;
                result.put("success", false);
                result.put("message", resultInfoVO.getMsg());
                return result;
            }
        }
        result.put("success", true);
        return result;
    }

    @Override
    public BizConfigBean findBizConfigByMenuId(Long menuId) throws BusinessException {
        BizConfigBean configBean = (BizConfigBean)MENU_MAP.get((Serializable)menuId);
        if (configBean == null) {
            CapBizConfig bizConfig = this.businessDAO4.findBizConfigByMenuId(menuId);
            if (bizConfig == null) {
                return null;
            }
            configBean = this.initConfigBean(bizConfig);
            this.addCache(configBean);
        }
        return configBean;
    }

    @Override
    public List<CtpBizConfigItem> findBizConfigItemByBizConfigId(Long bizConfigId) throws BusinessException {
        BizConfigBean c = this.findBizConfigById(bizConfigId);
        return c == null ? new ArrayList(0) : c.getItems();
    }

    @Override
    public void doSaveOrUpdateBizConfig(CapBizConfig ctpBizConfig) throws Exception {
        V3xOrgRole orgRole;
        BizConfigBean config;
        String isNew = (String)ctpBizConfig.getExtraAttr("isNew");
        if ("true".equals(isNew)) {
            if (BusinessUtil.isA6pOrNoCapAdvance()) {
                throw new BusinessException(ResourceUtil.getString((String)"form.over.power.tips"));
            }
            BizValidateResultVO bizValidateResultVO = this.validateManager.validateBiz(BizEnums.BizCreateSourceType.SelfCreate.getKey(), BizOperationEnum4.create_app_save);
            if (!bizValidateResultVO.isSuccess()) {
                throw new BizException(bizValidateResultVO.getCode(), BizChicken4.getTotalNum() + "");
            }
            config = new BizConfigBean(ctpBizConfig);
            config.setMenuId(Long.valueOf(UUIDLong.longUUID()));
            config.setCreateDate(DateUtil.currentDate());
            config.setCreateUser(Long.valueOf(AppContext.currentUserId()));
            config.setCreateName(AppContext.currentUserName());
            config.setPublishFlag(Integer.valueOf(BizEnums.BizPublishState.initState.getKey()));
            config.setUpdateDate(DateUtil.currentDate());
            config.setBizSort(this.businessDAO4.findMaxSort());
            config.setBizCreateType(Integer.valueOf(BizEnums.BizCreateSourceType.SelfCreate.getKey()));
            config.setBizSourceInfo(this.validateManager.generateValidate(config));
            AppInfo appInfo = config.getAppInfo();
            if (appInfo != null) {
                appInfo.setCreateCorpName(ValidityUtil.getMplusCorpName());
                appInfo.setCreateCorpId(ValidityUtil.getMplusCorpId());
                appInfo.setCreateDogNo(CAPBusinessUtil.getDogNo());
            }
            this.genCreateAppLog((CapBizConfig)config);
            orgRole = new V3xOrgRole();
            orgRole.setId(config.getMenuId());
            orgRole.setName(config.getRoleName());
            orgRole.setCode(config.getMenuId().toString());
            orgRole.setCreateTime((Date)DateUtil.currentTimestamp());
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_New, new String[]{AppContext.currentUserName(), config.getName()});
            this.logger.info((Object)ResourceUtil.getString((String)"appLog.action.211", (Object)AppContext.currentUserName(), (Object)config.getName()));
        } else {
            config = this.findBizConfigById(ctpBizConfig.getId());
            config.setUpdateDate(DateUtil.currentDate());
            config.setName(ctpBizConfig.getName());
            config.setBizMerge(ctpBizConfig.getBizMerge());
            config.setBizMergeName(ctpBizConfig.getBizMergeName());
            config.setCreateUser(ctpBizConfig.getCreateUser());
            orgRole = this.orgManager.getRoleById(config.getMenuId());
            if (orgRole == null) {
                this.logger.info((Object)(config.getName() + ": role not exits!" + config.getId() + config.getMenuId()));
                orgRole = new V3xOrgRole();
                orgRole.setId(config.getMenuId());
                orgRole.setCode(config.getMenuId().toString());
                orgRole.setCreateTime((Date)DateUtil.currentTimestamp());
            }
            orgRole.setName(config.getRoleName());
            orgRole.setUpdateTime((Date)DateUtil.currentTimestamp());
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_Edit, new String[]{AppContext.currentUserName(), config.getName()});
            this.logger.info((Object)ResourceUtil.getString((String)"appLog.action.212", (Object)AppContext.currentUserName(), (Object)config.getName()));
            config.setUseFlag(ctpBizConfig.getUseFlag());
        }
        if (Strings.isNotEmpty((String)ctpBizConfig.getBizIcon())) {
            config.setBizIcon(ctpBizConfig.getBizIcon());
        }
        config.setBizState(Integer.valueOf(BizEnums.BizState.Activated.getKey()));
        config.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
        orgRole.setBond(OrgConstants.ROLE_BOND.BUSINESS.ordinal());
        ArrayList<PrivMenuBO> list = new ArrayList<PrivMenuBO>();
        PrivMenuBO menuBO = new PrivMenuBO();
        menuBO.setId(config.getMenuId());
        String appResourceName = (String)ctpBizConfig.getExtraAttr("BIZ_CONFIG_MENU_APPNAME_ARRAY");
        if (Strings.isNotEmpty((String)appResourceName)) {
            String bizConfigNameI18N = ctpBizConfig.getExtraAttr("BIZ_CONFIG_MENU_APPNAME_ARRAY").toString();
            menuBO.setName(bizConfigNameI18N);
        } else if (Strings.isNotEmpty((String)config.getAppResourceNameKey())) {
            menuBO.setName(config.getAppResourceNameKey());
        } else {
            menuBO.setName(config.getName());
        }
        menuBO.setParentId(Long.valueOf(0L));
        menuBO.setCreatedate((Date)DateUtil.currentTimestamp());
        menuBO.setExt2("1");
        menuBO.setExt12(Integer.valueOf(-1));
        menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
        menuBO.setSortid(config.getBizSort());
        if (Strings.isNotEmpty((String)config.getBizIcon())) {
            menuBO.setIcon(config.getBizIcon());
        } else {
            menuBO.setIcon("common.png");
        }
        list.add(menuBO);
        String[] bizConfigItemNameAry = (String[])ctpBizConfig.getExtraAttr("BIZ_CONFIG_MENU_NAME_ARRAY");
        if (config.getMenuList() != null && config.getMenuList().size() > 0 && bizConfigItemNameAry == null) {
            List listMenu = config.getMenuList();
            for (PrivMenuBO privMenuBO : listMenu) {
                if (privMenuBO.getParentId() == 0L) continue;
                list.add(privMenuBO);
            }
        } else {
            BusinessUtil.getConfigItem(config, ctpBizConfig);
            List bos = config.getMenuList();
            list.addAll(bos);
        }
        BusinessUtil.sendMsg(ctpBizConfig, config);
        boolean clearBizFlag = false;
        if (ctpBizConfig.getExtraAttr("ClearBizAuth") != null) {
            clearBizFlag = (Boolean)ctpBizConfig.getExtraAttr("ClearBizAuth");
        }
        if (clearBizFlag) {
            config.setAuthValue("");
        }
        String sAuthorityValue = "";
        if (Strings.isNotEmpty((String)((String)ctpBizConfig.getExtraAttr("BIZ_AUTHORITY_VALUE")))) {
            sAuthorityValue = (String)ctpBizConfig.getExtraAttr("BIZ_AUTHORITY_VALUE");
        } else if (Strings.isNotEmpty((String)config.getAuthValue())) {
            sAuthorityValue = config.getAuthValue();
        }
        try {
            this.insertMenus(list, orgRole, sAuthorityValue, config);
        }
        catch (Exception e) {
            Long roleId = orgRole.getId();
            this.logger.info((Object)(roleId + "::::Cap4Auth::::" + config.getName() + "=" + DateUtil.currentTimestamp()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.businessDAO4.saveOrUpdateBizConfig(config.getConfig());
        this.addCache(this.initConfigBean(config.getId()));
        config = this.findBizConfigById(config.getId());
        this.cap4FormCacheManager.sendNotification((Object)config.getId(), CAP4FormCache.FormCacheType.FromBizConfig_Reload, config.getId());
        String auth = config.getAuthText();
        if (Strings.isBlank((String)auth)) {
            auth = ResourceUtil.getString((String)"common.none");
        }
        this.logger.info((Object)ResourceUtil.getString((String)"appLog.action.214", (Object)config.getName(), (Object)auth));
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_Auth, new String[]{config.getName(), auth});
        this.privilegeMenuManager.updateBiz();
        String newOrUpdate = "true".equals(isNew) ? "new" : "update";
        this.dispatcherBizFireEvent(config, newOrUpdate);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> bizStatisticalInfo() throws BusinessException {
        ConcurrentMap<Long, FormBean> formBeanConcurrentMap;
        HashMap<String, Object> bizInfoMap = new HashMap<String, Object>();
        int bizPublished = 0;
        int bizTotle = 0;
        int bizImport = 0;
        int formFlowTotle = 0;
        int formUnFlowTotle = 0;
        int monitorTotalCapacity = 0;
        int monitorResidualCapacity = 0;
        int monitorWaitExecutedJob = 0;
        int monitorSlowSqlAWeek = 0;
        if (CONFIG_MAP == null || CONFIG_MAP.isEmpty()) {
            this.initConfigMap();
        }
        if (CONFIG_MAP != null && !CONFIG_MAP.isEmpty()) {
            bizTotle = CONFIG_MAP.size();
            for (BizConfigBean bizConfigBean : CONFIG_MAP.values()) {
                if (bizConfigBean.isPublishedConfig()) {
                    ++bizPublished;
                }
                if (bizConfigBean.getBizCreateType().intValue() != BizEnums.BizCreateSourceType.Import.getKey()) continue;
                ++bizImport;
            }
        }
        if ((formBeanConcurrentMap = this.cap4FormCacheManager.getForms()) != null && !formBeanConcurrentMap.isEmpty()) {
            for (FormBean formBean : formBeanConcurrentMap.values()) {
                if (formBean == null) continue;
                if (formBean.isFlowForm()) {
                    ++formFlowTotle;
                    continue;
                }
                ++formUnFlowTotle;
            }
        }
        SlowSqlService slowSqlService = (SlowSqlService)AppContext.getBean((String)"slowSqlService");
        TaskExecuteManager taskExecuteManager = (TaskExecuteManager)AppContext.getBean((String)"taskExecuteManager");
        monitorSlowSqlAWeek = slowSqlService.getSlowSqlLastWeekNumber();
        monitorTotalCapacity = taskExecuteManager.getTaskEventFullCount();
        monitorResidualCapacity = taskExecuteManager.capacityLeft();
        monitorWaitExecutedJob = taskExecuteManager.getTaskEventCount();
        bizInfoMap.put("bizTotle", bizTotle);
        bizInfoMap.put("bizPublished", bizPublished);
        bizInfoMap.put("bizUnPublished", bizTotle - bizPublished);
        bizInfoMap.put("bizSelfCreate", bizTotle - bizImport);
        bizInfoMap.put("bizImport", bizImport);
        bizInfoMap.put("formTotle", formFlowTotle + formUnFlowTotle);
        bizInfoMap.put("formFlowTotle", formFlowTotle);
        bizInfoMap.put("formUnFlowTotle", formUnFlowTotle);
        bizInfoMap.put("monitorTotalCapacity", monitorTotalCapacity);
        bizInfoMap.put("monitorResidualCapacity", monitorResidualCapacity);
        bizInfoMap.put("monitorWaitExecutedJob", monitorWaitExecutedJob);
        bizInfoMap.put("monitorSlowSqlAWeek", monitorSlowSqlAWeek);
        return bizInfoMap;
    }

    @Override
    public void doSaveBizConfig4Import(CapBizConfig config, List<CtpBizConfigItem> ctpBizConfigItemList, boolean isUpgrade) throws BusinessException {
        if (config.getExtraAttr("BIZ_SOURCE_VALUE") != null) {
            BizValidateResultVO bizValidateResultVO;
            int sourceValue = (Integer)config.getExtraAttr("BIZ_SOURCE_VALUE");
            if (!isUpgrade && !(bizValidateResultVO = this.validateManager.validateBiz(new BizConfigBean(config), BizOperationEnum4.create_app_save)).isSuccess()) {
                this.logger.info((Object)("\u5bb9\u91cf\u9a8c\u8bc1\u5931\u8d25\uff1a" + config.getName() + "-" + config.getBizCreateType() + "-" + config.getTrial()));
                throw new BusinessException("\u4e0d\u80fd\u521b\u5efa\u65b0\u5e94\u7528\uff0c\u672c\u4f01\u4e1a\u6700\u591a\u80fd\u521b\u5efa" + BizChicken4.getTotalNum() + "\u4e2a\u4e1a\u52a1\u5e94\u7528\uff0c\u82e5\u9700\u7ee7\u7eed\u65b0\u5efa\u8bf7\u8d2d\u4e70\uff01");
            }
        }
        config.setBizSort(this.businessDAO4.findMaxSort());
        config.setBizSourceInfo(this.validateManager.generateValidate(config));
        if (config.getExtraAttr("appLogs") != null) {
            config.setMobileBizConfig(config.getExtraAttr("appLogs").toString());
        }
        this.genImpAppLog(config);
        config.setOwnerId(Long.valueOf(AppContext.currentUserId()));
        config.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
        V3xOrgRole orgRole = new V3xOrgRole();
        orgRole.setId(config.getMenuId());
        orgRole.setName(config.getRoleName());
        orgRole.setCode(config.getMenuId().toString());
        orgRole.setCreateTime((Date)DateUtil.currentTimestamp());
        orgRole.setBond(OrgConstants.ROLE_BOND.BUSINESS.ordinal());
        orgRole.setEnabled(Boolean.valueOf(true));
        PrivMenuBO menuBO = new PrivMenuBO();
        menuBO.setId(config.getMenuId());
        menuBO.setName(config.getName());
        menuBO.setParentId(Long.valueOf(0L));
        menuBO.setCreatedate((Date)DateUtil.currentTimestamp());
        menuBO.setExt2("1");
        menuBO.setExt12(Integer.valueOf(-1));
        menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
        menuBO.setSortid(config.getBizSort());
        if (Strings.isNotEmpty((String)config.getBizIcon())) {
            menuBO.setIcon(config.getBizIcon());
        } else {
            menuBO.setIcon("vp-application");
        }
        ArrayList<PrivMenuBO> list = new ArrayList<PrivMenuBO>();
        list.add(menuBO);
        int bizPage = 0;
        if (config.getExtraAttr("BIZ_PAGE_VALUE") != null) {
            bizPage = (Integer)config.getExtraAttr("BIZ_PAGE_VALUE");
        }
        long parentId = config.getMenuId();
        int sort = 990;
        if (bizPage == 1) {
            CtpBizConfigItem bizConfigItem = new CtpBizConfigItem();
            bizConfigItem.setNewId();
            bizConfigItem.setBizConfigId(config.getId());
            bizConfigItem.setName(ResourceUtil.getString((String)"form.business.menu.bizHomePage.label"));
            bizConfigItem.setFlowMenuType(Integer.valueOf(0));
            bizConfigItem.setSourceType(Integer.valueOf(Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey()));
            bizConfigItem.setSourceId(Long.valueOf(1L));
            bizConfigItem.setFormAppmainId(Long.valueOf(-1L));
            bizConfigItem.setMenuId(Long.valueOf(UUIDLong.longUUID()));
            bizConfigItem.setSortId(Integer.valueOf(sort - 1));
            bizConfigItem.setMenuIcon("");
            menuBO = bizConfigItem.getPrivMenuBO();
            menuBO.setId(bizConfigItem.getMenuId());
            menuBO.setName(bizConfigItem.getName());
            menuBO.setParentId(Long.valueOf(parentId));
            menuBO.setUrl("/cap4/businessTemplateController.do?method=businessIndex&bussId=" + config.getId());
            menuBO.setSortid(Integer.valueOf(sort - 1));
            menuBO.setExt2("2");
            menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
            menuBO.setTarget("newWindow");
            menuBO.setIcon(bizConfigItem.getMenuIcon());
            if (bizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) {
                parentId = menuBO.getId();
                menuBO.setParentId(config.getMenuId());
            }
            list.add(menuBO);
        }
        for (CtpBizConfigItem bizConfigItem : ctpBizConfigItemList) {
            PrivMenuBO tempMenuBO = bizConfigItem.getPrivMenuBO();
            tempMenuBO.setId(bizConfigItem.getMenuId());
            tempMenuBO.setName(bizConfigItem.getName());
            tempMenuBO.setParentId(Long.valueOf(parentId));
            tempMenuBO.setUrl(this.getAction(bizConfigItem, config));
            tempMenuBO.setSortid(Integer.valueOf(sort));
            tempMenuBO.setExt2("2");
            if (Strings.isNotEmpty((String)bizConfigItem.getMenuIcon())) {
                tempMenuBO.setIcon(bizConfigItem.getMenuIcon());
            } else {
                tempMenuBO.setIcon("vp-application");
            }
            if (bizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) {
                parentId = tempMenuBO.getId();
                tempMenuBO.setParentId(config.getMenuId());
            }
            tempMenuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
            list.add(tempMenuBO);
            ++sort;
        }
        this.privilegeManager.insertMenus(list, orgRole, "");
        this.businessDAO4.saveOrUpdateBizConfig(config);
        this.addCache(this.initConfigBean(config.getId()));
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void updateBizIcon(Map<String, Object> map) throws BusinessException {
        Long bizConfigId = ParamUtil.getLong(map, (String)"bizConfigId", null);
        if (bizConfigId != null) {
            BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
            String bizIcon = ParamUtil.getString(map, (String)"bizIcon", null);
            int bizIconType = ParamUtil.getInt(map, (String)"bizIconType", (int)-1);
            if (bizIcon != null && bizIconType >= 0) {
                if (bizIconType == 2) {
                    bizConfigBean.setBizIcon("/fileUpload.do?method=showRTE&fileId=" + bizIcon + "&type=image");
                } else {
                    bizConfigBean.setBizIcon(bizIcon);
                }
                ArrayList<PrivMenuBO> privIconList = new ArrayList<PrivMenuBO>();
                List privMenuBOList = bizConfigBean.getMenuList();
                for (PrivMenuBO privMenuBO : privMenuBOList) {
                    if (privMenuBO.getParentId() == null || privMenuBO.getParentId() != 0L || privMenuBO.getExt12() == null || privMenuBO.getExt12() != -1) continue;
                    privMenuBO.setIcon(bizConfigBean.getBizIcon());
                    privIconList.add(privMenuBO);
                }
                if (Strings.isNotEmpty(privIconList)) {
                    this.privilegeMenuManager.updatePatch(privIconList);
                    this.privilegeMenuManager.updateBiz();
                    this.portalApi.clearPortalMenusCache();
                }
                this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
                this.addCache(this.initConfigBean(bizConfigBean.getId()));
            }
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void updateBizLogicImg(Map<String, Object> map) throws BusinessException {
        Long bizConfigId = ParamUtil.getLong(map, (String)"bizConfigId", null);
        if (bizConfigId != null) {
            BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
            Long bizLogicImgId = ParamUtil.getLong(map, (String)"bizLogicImgId", null);
            if (bizLogicImgId != null) {
                bizConfigBean.setBizLogicImgId(bizLogicImgId);
            }
            this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
            this.addCache(this.initConfigBean(bizConfigBean.getId()));
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void deleteBizLogicImg(Long bizConfigId, Long bizLogicImgId) throws BusinessException {
        if (bizConfigId != null && bizLogicImgId != null) {
            BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
            try {
                this.fileManager.deletePhysicsFile(bizLogicImgId);
            }
            catch (BusinessException e) {
                this.logger.error((Object)"delete logicImg error", (Throwable)e);
            }
            bizConfigBean.setBizLogicImgId(null);
            this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
            this.addCache(this.initConfigBean(bizConfigBean.getId()));
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> bizConfigPublish(Long bizConfigId, int bizClearType) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (bizConfigId != null) {
            BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
            if (!bizConfigBean.getOwnerId().equals(AppContext.currentUserId())) {
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"cap4.form.business.bizPublish.ownerCheck"));
                return result;
            }
            if (!bizConfigBean.isPublishedConfig()) {
                String formIds;
                List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
                if (bizClearType != BizEnums.BizClearType.remainAll.getKey() && Strings.isNotEmpty((String)(formIds = BusinessUtil.getFormIdsByBizItemsAndType(capBizConfigItemList, bizClearType)))) {
                    String[] formIdArray;
                    List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
                    if (Strings.isNotEmpty(checkFormEdit)) {
                        result.put("success", false);
                        result.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                        return result;
                    }
                    boolean isAll = bizClearType == BizEnums.BizClearType.clearAll.getKey();
                    String formType = isAll ? "\u8868\u5355" : Enums.FormType.getEnumByKey((int)bizClearType).getValue();
                    this.logger.info((Object)(AppContext.currentUserName() + " \u53d1\u5e03:" + bizConfigBean.getName() + "\uff0c\u6e05\u9664" + formType + "\u6570\u636e " + formIds));
                    if (!this.cap4FormDesignManager.cleanFormTestData(formIds)) {
                        result.put("success", false);
                        result.put("message", ResourceUtil.getString((String)"cap4.form.app.publish.tips", (Object)bizConfigBean.getName()));
                        return result;
                    }
                    this.capRunningLogManager.saveRunningLog(bizConfigId, bizConfigBean.getName(), 0L, "", 0L, Enums.CapLogType.DELETE.getKey(), "\u300a" + bizConfigBean.getName() + "\u300b" + ResourceUtil.getString((String)"form.log.running.publish.deleteData") + formType + ResourceUtil.getString((String)"form.log.running.data") + "\uff01", AppContext.getCurrentUser().getId(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
                    CAP4SerialNumberManager serialNumberManager = (CAP4SerialNumberManager)AppContext.getBean((String)"cap4SerialNumberManager");
                    for (String formId : formIdArray = formIds.split(",")) {
                        FormBean fb = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
                        if (fb == null) continue;
                        serialNumberManager.resetSerialNumber(fb);
                    }
                }
                for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                    FormBean fb = this.cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
                    if (fb == null) continue;
                    CAPFormDefinition capFormDefinition = fb.toFormDefinition();
                    capFormDefinition.setPublishFlag(Integer.valueOf(Enums.FormPublishFlagEnum.published.getKey()));
                    capFormDefinition.setModifyTime(DateUtil.currentDate());
                    this.cap4FormDefinitionDAO.update(capFormDefinition);
                    this.cap4FormCacheManager.initForm(fb.getId());
                }
                bizConfigBean.setPublishFlag(Integer.valueOf(BizEnums.BizPublishState.published.getKey()));
                bizConfigBean.setUpdateDate(DateUtil.currentDate());
                this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
                this.addCache(this.initConfigBean(bizConfigId));
                this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_Publish, new String[]{AppContext.currentUserName(), bizConfigBean.getName()});
            }
        }
        result.put("success", true);
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> clearFormDataBelongsBiz(Long bizConfigId, String softDog) throws Exception {
        Map<String, Object> result = new HashMap<String, Object>(16);
        if (bizConfigId != null && bizConfigId != 0L) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            String formIds = BusinessUtil.getFormIdsByBizItems(capBizConfigItemList);
            result = this.clearFormData(formIds, softDog, false, 0);
            if (((Boolean)result.get("success")).booleanValue()) {
                BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
                this.capRunningLogManager.saveRunningLog(bizConfigBean.getId(), bizConfigBean.getName(), 0L, "", 0L, Enums.CapLogType.DELDATA.getKey(), "\u300a" + bizConfigBean.getName() + "\u300b" + ResourceUtil.getString((String)"form.monitor.log.running.business.clearData"), AppContext.getCurrentUser().getId(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
            }
            return result;
        }
        result.put("success", true);
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> clearFormData(String formIds, String softDog, Boolean form, int type) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (Strings.isNotEmpty((String)formIds)) {
            String[] formIdArray;
            boolean validate;
            String inputDogNo;
            String sysDogNo = SystemEnvironment.getDogNo();
            if (sysDogNo.startsWith("/1.0/")) {
                sysDogNo = (String)ReflectUtil.invokeMethod((String)"com.seeyon.ctp.util.TextEncoder", (String)"decode", null, (Class[])new Class[]{String.class}, (Object[])new Object[]{sysDogNo});
            }
            String string = inputDogNo = softDog == null ? "" : softDog;
            if (inputDogNo.startsWith("/1.0/")) {
                inputDogNo = (String)ReflectUtil.invokeMethod((String)"com.seeyon.ctp.util.TextEncoder", (String)"decode", null, (Class[])new Class[]{String.class}, (Object[])new Object[]{inputDogNo});
            }
            boolean bl = validate = "123456789".equals(inputDogNo) || inputDogNo.equals(sysDogNo);
            if (!validate) {
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"cap4.form.business.dataClear.dogCheck"));
                this.logger.error((Object)("\u8f93\u5165\u7684\u52a0\u5bc6\u72d7\u53f7inputDogNo\uff1a" + inputDogNo + "123456789\uff0c\u7cfb\u7edf\u8bfb\u53d6\u5230\u7684\u52a0\u5bc6\u72d7\u53f7sysDogNo\uff1a" + sysDogNo + "123456789"));
                return result;
            }
            List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
            if (Strings.isNotEmpty(checkFormEdit)) {
                result.put("success", false);
                result.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                return result;
            }
            ArrayList<CapRunningLog> logList = new ArrayList<CapRunningLog>();
            if (form.booleanValue()) {
                String[] formIdArr;
                for (String formId : formIdArr = formIds.split(",")) {
                    BizConfigBean bizConfigBean = this.findBizConfigByFormId(Long.parseLong(formId));
                    FormBean formbean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
                    long bizId = 0L;
                    String bizName = null;
                    if (bizConfigBean != null) {
                        bizId = bizConfigBean.getId();
                        bizName = bizConfigBean.getName();
                    }
                    logList.add(new CapRunningLog(bizId, bizName, Long.parseLong(formId), formbean.getFormName(), 0L, type, AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), "\u300a" + formbean.getFormName() + "\u300b" + ResourceUtil.getString((String)"form.monitor.log.running.form.clearData"), AppContext.getRemoteAddr()));
                }
            }
            if (!this.cap4FormDesignManager.cleanFormTestData(formIds)) {
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"cap4.form.business.dataClear.error"));
                return result;
            }
            this.capRunningLogManager.saveRunningLog(logList);
            CAP4SerialNumberManager serialNumberManager = (CAP4SerialNumberManager)AppContext.getBean((String)"cap4SerialNumberManager");
            FormCacheManager cacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
            for (String formId : formIdArray = formIds.split(",")) {
                FormBean fb = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
                if (fb == null || fb.isPublished()) continue;
                serialNumberManager.resetSerialNumber(fb);
                cacheManager.initFormSerialNumber(fb.getId());
            }
        }
        result.put("success", true);
        return result;
    }

    private void insertMenus(List<PrivMenuBO> list, V3xOrgRole orgRole, String sAuthorityValue, BizConfigBean config) throws Exception {
        this.privilegeManager.insertMenus(list, orgRole, sAuthorityValue);
        this.privilegeManager.insertCustomizeMenus(sAuthorityValue, config.getMenuId());
    }

    @Override
    public void deleteBizConfig(List<Long> bizConfigIds) throws BusinessException {
        if (bizConfigIds == null || bizConfigIds.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long bizConfigId : bizConfigIds) {
            BizConfigBean bizConfigItem;
            if (bizConfigId == null || (bizConfigItem = this.findBizConfigById(bizConfigId)) == null) continue;
            ids.add(bizConfigItem.getMenuId());
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Biz_Delete, new String[]{AppContext.currentUserName(), bizConfigItem.getName()});
            this.logger.info((Object)ResourceUtil.getString((String)"appLog.action.213", (Object)AppContext.currentUserName(), (Object)bizConfigItem.getName()));
            this.orgManagerDirect.deleteRole2Entity(bizConfigItem.getMenuId(), null, null);
            this.privilegeManager.cleanFormPrivData(bizConfigItem.getMenuId());
            BusinessUtil.sendMsg(null, bizConfigItem);
            CONFIG_MAP.remove((Serializable)bizConfigItem.getId());
            MENU_MAP.remove((Serializable)bizConfigItem.getMenuId());
        }
        this.businessDAO4.deleteBizConfig(bizConfigIds);
        this.roleManager.deleteRole(ids.toArray(new Long[ids.size()]));
        this.privilegeMenuManager.updateBiz();
    }

    @Override
    public boolean checkBizConfigMenuId(Long menuId) throws BusinessException {
        return MENU_MAP.contains((Serializable)menuId);
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public boolean checkBizConfigName(String name, String id) throws BusinessException {
        List<Long> result = this.businessDAO4.findBizConfigsByName(name, AppContext.currentAccountId(), id);
        return result != null && result.size() >= 1;
    }

    @Override
    public String getAction(CtpBizConfigItem bizConfigItem, CapBizConfig bizConfig) {
        return BizUtil.getAction(bizConfig.getMenuId(), bizConfigItem.getFlowMenuType(), bizConfigItem.getSourceType(), bizConfigItem.getSourceId(), bizConfigItem.getFormAppmainId(), bizConfig.getName(), bizConfigItem.getName(), bizConfig.getId());
    }

    @Override
    public List<FormAppBO> getTemplateList(User user, String condition, String textfield, boolean isAll) throws BusinessException {
        List tempTemplates;
        FormAppBO bo;
        CtpTemplateCategory category;
        ArrayList<FormAppBO> list = new ArrayList<FormAppBO>();
        LinkedHashSet<CtpTemplate> templates = new LinkedHashSet<CtpTemplate>();
        LinkedHashSet<Long> boIds = new LinkedHashSet<Long>();
        HashMap<String, CtpTemplateCategory> catgMap = new HashMap<String, CtpTemplateCategory>();
        if (isAll) {
            ArrayList<ModuleType> modus = new ArrayList<ModuleType>();
            modus.add(ModuleType.form);
            List temp = this.templateManager.getSystemTemplatesByMaxAcl(user.getLoginAccount(), modus);
            templates.addAll(temp);
            if (Strings.isNotBlank((String)condition)) {
                for (CtpTemplate ctpTemplate : temp) {
                    if (Strings.isNotBlank((String)condition) && TemplateEnum.searchCondtion.categoryId.name().equals(condition) && !BusinessUtil.searchByCatg(textfield, ctpTemplate.getCategoryId())) {
                        templates.remove(ctpTemplate);
                    }
                    if (!Strings.isNotBlank((String)condition) || !TemplateEnum.searchCondtion.subject.name().equals(condition) || ctpTemplate.getSubject().contains(textfield)) continue;
                    templates.remove(ctpTemplate);
                }
            }
            String[] orgType = new String[]{Enums.FormModuleAuthOrgType.Account.getText(), Enums.FormModuleAuthOrgType.Member.getText(), Enums.FormModuleAuthOrgType.Department.getText(), Enums.FormModuleAuthOrgType.Level.getText(), Enums.FormModuleAuthOrgType.Post.getText(), Enums.FormModuleAuthOrgType.Team.getText()};
            List orgs = this.orgManager.getUserDomainIDs(Long.valueOf(AppContext.currentUserId()), orgType);
            List auths = this.formAuthModuleDAO.selectModuleAuthByOrgList(Enums.FormModuleAuthModuleType.BindAppForm, orgs);
            if (Strings.isNotEmpty((Collection)auths)) {
                for (FormModuleAuth formModuleAuth : auths) {
                    FormBean formBean = this.cap4FormCacheManager.getForm(formModuleAuth.getFormId());
                    if (null == formBean || Strings.isNotBlank((String)condition) && TemplateEnum.searchCondtion.categoryId.name().equals(condition) && !BusinessUtil.searchByCatg(textfield, (Long)formBean.getCategoryId())) continue;
                    FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean(formModuleAuth.getModuleId().toString());
                    if (Strings.isNotBlank((String)condition) && TemplateEnum.searchCondtion.subject.name().equals(condition) && bindAuthBean.getName().indexOf(textfield) == -1 || !boIds.add(bindAuthBean.getId()) || (category = this.templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCategoryId()))) == null) continue;
                    bo = new FormAppBO();
                    bo.setId(bindAuthBean.getId().toString());
                    bo.setSourceValue(bindAuthBean.getId());
                    bo.setCategoryId(category.getName());
                    bo.setFormAppmainId(formBean.getId());
                    bo.setName(bindAuthBean.getName());
                    catgMap.put(category.getName(), category);
                    list.add(bo);
                }
            }
        }
        List<FormBean> formBeans = BusinessUtil.getFormBenaList(user, isAll);
        if (Strings.isNotBlank((String)condition) && TemplateEnum.searchCondtion.categoryId.name().equals(condition)) {
            long catgid = Long.parseLong(textfield);
            formBeans = BusinessUtil.getFormBeanList(catgid, formBeans);
        }
        if (Strings.isNotEmpty((Collection)(tempTemplates = this.templateManager.getSystemFormTemplates(AppContext.currentUserId())))) {
            if (Strings.isNotBlank((String)condition)) {
                for (CtpTemplate ctpTemplate : tempTemplates) {
                    if (TemplateEnum.searchCondtion.categoryId.name().equals(condition)) {
                        long catgid = Long.parseLong(textfield);
                        if (ctpTemplate.getCategoryId() != catgid) continue;
                    }
                    if (TemplateEnum.searchCondtion.subject.name().equals(condition) && !ctpTemplate.getSubject().contains(textfield)) continue;
                    templates.add(ctpTemplate);
                }
            } else {
                templates.addAll(tempTemplates);
            }
        }
        if (null != formBeans) {
            for (FormBean formBean : formBeans) {
                FormBindBean bindBean = formBean.getBind();
                Map unTemplates = bindBean.getUnFlowTemplateMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    FormBindAuthBean template = (FormBindAuthBean)entry.getValue();
                    if (!boIds.add(template.getId()) || Strings.isNotBlank((String)condition) && TemplateEnum.searchCondtion.subject.name().equals(condition) && !template.getName().contains(textfield)) continue;
                    category = this.templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCategoryId()));
                    bo = new FormAppBO();
                    bo.setId(template.getId().toString());
                    bo.setSourceValue(template.getId());
                    bo.setCategoryId(category.getName());
                    bo.setFormAppmainId(formBean.getId());
                    bo.setName(template.getName());
                    catgMap.put(category.getName(), category);
                    list.add(bo);
                }
            }
        }
        for (CtpTemplate template : templates) {
            Long formId;
            if (!boIds.add(template.getId()) || (category = this.templateManager.getCtpTemplateCategory(template.getCategoryId())) == null || !this.cap4FormCacheManager.isEnabled(formId = BusinessUtil.getFormIdByTemplate(template))) continue;
            catgMap.put(category.getName(), category);
            FormAppBO bo2 = new FormAppBO();
            bo2.setId(template.getId().toString());
            bo2.setSourceValue(template.getId());
            bo2.setName(template.getSubject());
            bo2.setCategoryId(category.getName());
            bo2.setFormAppmainId(formId);
            bo2.setSourceType(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey());
            list.add(bo2);
        }
        BusinessUtil.getCategoryBO(catgMap, list, catgMap);
        return list;
    }

    @Override
    public List<PrivMenuBO> checkMenuAuth(Long menuId, Long subMenuId) throws BusinessException {
        ArrayList<PrivMenuBO> menuList = new ArrayList<PrivMenuBO>();
        List list = this.privilegeMenuManager.getListByRole(new Long[]{menuId}, subMenuId);
        V3xOrgRole orgRole = this.orgManager.getRoleById(menuId);
        if (orgRole == null) {
            this.logger.warn((Object)("\u6821\u9a8c\u89d2\u8272\u83dc\u5355\u6743\u9650\u65f6\uff0c\u5bf9\u5e94\u7684\u6743\u9650\u4e0d\u5b58\u5728\uff1a\u89d2\u8272id=" + menuId));
            return menuList;
        }
        String authId = BizUtil.getMenuAuthCheckId(menuId, orgRole);
        BizMenuAuthCheckInterface manager = BizUtil.getMenuAuthCheck(authId);
        if (manager == null) {
            this.logger.warn((Object)("\u6821\u9a8c\u89d2\u8272\u83dc\u5355\u6743\u9650\u65f6\uff0c\u5bf9\u5e94\u7684\u6743\u9650\u6821\u9a8c\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728\uff1aid=" + authId));
            return menuList;
        }
        return manager.checkMenuAuth(list, menuId);
    }

    @Override
    public List<PrivMenuBO> checkMenuAuthForShortCut(Long menuId, List<PrivMenuBO> subMenuList) throws BusinessException {
        ArrayList<PrivMenuBO> menuList = new ArrayList<PrivMenuBO>();
        V3xOrgRole orgRole = this.orgManager.getRoleById(menuId);
        if (orgRole == null) {
            String authId = "formBiz";
            BizMenuAuthCheckInterface manager = BizUtil.getMenuAuthCheck(authId);
            if (manager == null) {
                this.logger.warn((Object)("\u6821\u9a8c\u89d2\u8272\u83dc\u5355\u6743\u9650\u65f6\uff0c\u5bf9\u5e94\u7684\u6743\u9650\u6821\u9a8c\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728\uff1aid=" + authId));
                return menuList;
            }
            return manager.checkMenuAuth(subMenuList, menuId);
        }
        return this.checkMenuAuth(menuId, null);
    }

    @Override
    public Map<String, ImagePortletLayout> checkMenuAuthBatch(Set<Integer> menuType, Map<String, List<PrivMenuBO>> roleMenus) throws BusinessException {
        String authId = "formBiz";
        BizMenuAuthCheckInterface manager = BizUtil.getMenuAuthCheck(authId);
        if (manager == null) {
            this.logger.warn((Object)("\u6821\u9a8c\u89d2\u8272\u83dc\u5355\u6743\u9650\u65f6\uff0c\u5bf9\u5e94\u7684\u6743\u9650\u6821\u9a8c\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728\uff1aid=" + authId));
            return Collections.emptyMap();
        }
        return manager.checkMenuAuthBatch(menuType, roleMenus);
    }

    @Override
    public List<PrivMenuBO> checkMenuAuth(Long menuId) throws BusinessException {
        return this.checkMenuAuth(menuId, null);
    }

    @Override
    public PrivMenu getPrivResourceByMenuId(Long menuId, Long templateId) throws BusinessException {
        List list = this.privilegeMenuManager.getListByRole(new Long[]{menuId});
        for (PrivMenuBO privMenuBO : list) {
            Enums.SourceType sourceType;
            if (privMenuBO.getExt12() == null || Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE != (sourceType = Enums.SourceType.getEnumByKey((int)privMenuBO.getExt12())) || !privMenuBO.getExt17().equals(templateId) || privMenuBO.getExt14() != 2) continue;
            return privMenuBO;
        }
        return null;
    }

    @Override
    public PrivMenu getPrivMenuById(Long menuId) throws BusinessException {
        BizConfigBean configBean = this.findBizConfigByMenuId(menuId);
        List menus = configBean.getMenuList();
        for (PrivMenuBO menuBO : menus) {
            if (!menuBO.getName().equals(configBean.getBizMergeName())) continue;
            return menuBO;
        }
        return this.privilegeMenuManager.findById(menuId);
    }

    public AppLogManager getAppLogManager() {
        return this.appLogManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    @Override
    public void getBizMapsById(Long id, Set<CtpBizMap> set) throws BusinessException {
    }

    @Override
    public void deleteBizMapById(List<Long> ids) throws BusinessException {
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public Map<String, Object> updatePeopleBelongBatch(String bizConfigIds, Long ownerId, String ownerName, String moduleFlag, Long accountId) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean result = true;
        if (Strings.isNotEmpty((String)bizConfigIds)) {
            if ("form".equals(moduleFlag)) {
                List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(bizConfigIds);
                if (Strings.isNotEmpty(checkFormEdit)) {
                    map.put("success", false);
                    map.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                    return map;
                }
                String resultStr = this.cap4FormListManager.changeOwner(bizConfigIds, accountId, ownerId);
                if (!"true".equals(resultStr)) {
                    map.put("success", false);
                    map.put("message", ResourceUtil.getString((String)"cap4.form.business.error.modifyFormBelong"));
                    return map;
                }
                this.reportApi.changeOwnerByCategory(ApplicationCategoryEnum.cap4Form.name(), CommonTools.parseStr2Ids((String)bizConfigIds), accountId, ownerId);
            } else {
                String[] bizConfigIdArray;
                for (String bizConfigId : bizConfigIdArray = bizConfigIds.split(",")) {
                    List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(Long.parseLong(bizConfigId));
                    if (CollectionUtils.isNotEmpty(capBizConfigItemList)) {
                        String formIds = "";
                        for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                            formIds = Strings.joinDelNull((String)",", (String[])new String[]{formIds, capBizConfigItem.getFormId().toString()});
                        }
                        List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
                        if (Strings.isNotEmpty(checkFormEdit)) {
                            map.put("success", false);
                            map.put("message", BusinessUtil.formEditInfo(checkFormEdit));
                            return map;
                        }
                        String resultStr = this.cap4FormListManager.changeOwner(formIds, accountId, ownerId);
                        if (!"true".equals(resultStr)) {
                            map.put("success", false);
                            map.put("message", ResourceUtil.getString((String)"cap4.form.business.error.modifyFormBelong"));
                        }
                        try {
                            this.reportApi.changeOwnerByCategory(ApplicationCategoryEnum.cap4biz.name(), CommonTools.parseStr2Ids((String)bizConfigIds), accountId, ownerId);
                        }
                        catch (BusinessException e) {
                            this.logger.error((Object)e.getMessage(), (Throwable)e);
                            map.put("success", false);
                            map.put("message", ResourceUtil.getString((String)"cap4.form.business.error.modifyReportBelong"));
                            return map;
                        }
                    }
                    BizConfigBean bizConfigBean = this.findBizConfigById(Long.parseLong(bizConfigId));
                    this.portalApi.updatePortalManageAuth(Long.valueOf(Long.parseLong(bizConfigId)), "Member|" + bizConfigBean.getOwnerId());
                }
                this.bizMapManager.updateBizMapBelongs(bizConfigIds, ownerId, ownerName, accountId);
                this.businessDAO4.updatePeopleBelongBatch(bizConfigIds, ownerId, ownerName, moduleFlag, accountId);
                for (String bizConfigId : bizConfigIdArray) {
                    this.addCache(this.initConfigBean(Long.parseLong(bizConfigId)));
                    this.cap4FormCacheManager.sendNotification((Object)Long.parseLong(bizConfigId), CAP4FormCache.FormCacheType.FromBizConfig_Reload, Long.parseLong(bizConfigId));
                }
            }
        }
        map.put("success", true);
        return map;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public String getMembersByRole(Long account, String roleName) throws BusinessException {
        ArrayList orgMembers = new ArrayList();
        V3xOrgAccount orgAccount = this.orgManager.getAccountById(account);
        orgMembers.addAll(this.orgManager.getMembersByRole(orgAccount.getId(), roleName));
        return JSONUtil.toJSONString(orgMembers);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public String validateFormName(String bizConfigIds, String bizConfigNames, Long accountId) throws BusinessException {
        if (Strings.isNotBlank((String)bizConfigNames) && Strings.isNotBlank((String)bizConfigIds)) {
            String message;
            StringBuilder msg = new StringBuilder();
            String[] formNames = bizConfigNames.split(",");
            String[] formIds = bizConfigIds.split(",");
            for (int i = 0; i < formNames.length; ++i) {
                List<CAPFormDefinition> list = this.cap4FormDefinitionDAO.selectByName(formNames[i], accountId);
                FormOwner fo = this.cap4FormCacheManager.getFormOwner(Long.parseLong(formIds[i]));
                Long ownerAccountId = fo == null ? AppContext.currentAccountId() : fo.getOrgAccountId();
                if (ownerAccountId.longValue() == accountId.longValue() || list == null || list.size() <= 0) continue;
                msg.append(formNames[i]).append("\u3001");
            }
            String string = message = !"".equals(msg.toString()) ? msg.toString().substring(0, msg.toString().length() - 1) : null;
            if (message != null) {
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    @AjaxAccess
    public String getFormNames(String ids, String moduleFlag) throws BusinessException {
        return "";
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getIndicatorByQueryId(Long formId, Long queryId) throws BusinessException {
        HashMap<String, Object> resutlMap = new HashMap<String, Object>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (formBean == null) {
            return resutlMap;
        }
        return resutlMap;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> exportBusiness(Map<String, Object> params) throws BusinessException {
        String type = ParamUtil.getString(params, (String)"appExportType", (String)"private_app");
        BusinessEnums.ExportAppType exportAppType = BusinessEnums.ExportAppType.getEnumByKey((String)type);
        boolean trial = false;
        if (BusinessEnums.ExportAppType.CUSTOM_TRAIL == exportAppType) {
            trial = true;
        }
        if (!trial && !ValidityUtil.isValidMplusAccount()) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.certificate.error.tips"));
        }
        long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        BizConfigBean bizConfigBean = (BizConfigBean)CONFIG_MAP.get((Serializable)Long.valueOf(bizConfigId));
        if (bizConfigBean != null) {
            if (bizConfigBean.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.Operate.getKey()) {
                throw new BusinessException("\u8fd0\u7ef4\u5e94\u7528\u4e0d\u80fd\u5bfc\u51fa\uff01");
            }
            try {
                this.loadBizCounts(bizConfigBean);
            }
            catch (Exception e) {
                this.logger.error((Object)"\u521d\u59cb\u5316\u8868\u5355\u6570\u91cf\u76f8\u5173\u6570\u636e\u540e\u4fdd\u5b58\u51fa\u9519\uff01", (Throwable)e);
            }
            params.put("appLogs", this.genExpAppLog((CapBizConfig)bizConfigBean));
        }
        return this.businessImportAndExportManager.exportBusiness(params);
    }

    @Override
    public List<CapBizConfig> findAllBizConfig() throws BusinessException {
        return this.businessDAO4.getAllCtpBizConfig();
    }

    @Override
    public Map<String, Object> handleStatus(Map<String, Object> params) throws BusinessException {
        Long bizId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        String status = ParamUtil.getString(params, (String)"status", (String)"");
        BizConfigBean bizConfigBean = this.findBizConfigById(bizId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bizConfigBean == null) {
            result.put("success", false);
            result.put("message", ResourceUtil.getString((String)"cap4.form.business.bizEnable.error1"));
            return result;
        }
        if (!bizConfigBean.getOwnerId().equals(AppContext.currentUserId())) {
            result.put("success", false);
            result.put("message", ResourceUtil.getString((String)"cap4.form.business.bizPublish.ownerCheck"));
            return result;
        }
        if ("on".equals(status)) {
            return this.startBizBean(bizConfigBean, false);
        }
        if ("off".equals(status)) {
            return this.stopBizBean(bizConfigBean);
        }
        result.put("success", false);
        result.put("message", ResourceUtil.getString((String)"cap4.form.business.bizEnable.error2"));
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getCap4BizInfoCountByFormId(Long formId) throws BusinessException {
        BizConfigBean bizConfigBean = this.findBizConfigByFormId(formId);
        return this.getCap4BizInfoCount(bizConfigBean.getId());
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getCap4BizInfoCount(Long bizConfigId) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BizConfigBean bizConfigBean = this.findBizConfigById(bizConfigId);
        List<CAPFormDefinition> bizForms = this.cap4FormDefinitionDAO.queryBizForms(bizConfigBean.getId(), null);
        Integer bizSelfSectionCount = 0;
        Integer bizRelationForwardCount = 0;
        Integer bizFormCount = bizForms.size();
        Integer bizFormViewCount = 0;
        Integer bizFormFieldCount = 0;
        Integer bizMagicCubeCount = 0;
        for (CAPFormDefinition form : bizForms) {
            Map<String, Object> cap4BizRelation = this.getCap4BizRealtion(String.valueOf(bizConfigId), String.valueOf(form.getId()));
            if (cap4BizRelation == null) continue;
            bizSelfSectionCount = bizSelfSectionCount + (Integer)cap4BizRelation.get("selfSectionCount");
            bizRelationForwardCount = bizRelationForwardCount + (Integer)cap4BizRelation.get("forwardCount");
            FormBean formBean = this.cap4FormCacheManager.getForm(form.getId());
            List formViewList = formBean.getFormViewList();
            bizFormViewCount = bizFormViewCount + formViewList.size();
            List allFieldBeans = formBean.getAllFieldBeans();
            bizFormFieldCount = bizFormFieldCount + allFieldBeans.size();
            bizMagicCubeCount = bizMagicCubeCount + (Integer)cap4BizRelation.get("bizMagicCubeCount");
        }
        result.put("bizConfigId", bizConfigId);
        result.put("name", bizConfigBean.getName());
        result.put("bizRelationCount", bizSelfSectionCount + bizRelationForwardCount);
        result.put("bizFormCount", bizFormCount);
        result.put("bizFormViewCount", bizFormViewCount);
        result.put("bizFormFieldCount", bizFormFieldCount);
        result.put("bizMagicCubeCount", bizMagicCubeCount);
        if (null != bizConfigBean.getAppInfo()) {
            result.put("bizRelationVolume", bizConfigBean.getAppInfo().getBizRelations() + 2);
        }
        if (SystemEnvironment.isDev() || AppContext.hasPlugin((String)"cap_advance")) {
            result.put("devOrCapAdvance", true);
        } else {
            result.put("devOrCapAdvance", false);
        }
        return result;
    }

    private Map<String, Object> startBizBean(BizConfigBean bizConfigBean, boolean hasVerified) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BizValidateResultVO bizValidateResultVO = this.validateManager.validateBiz(bizConfigBean, BizOperationEnum4.create_app_save);
        if (!bizValidateResultVO.isSuccess()) {
            String msg = ResourceUtil.getString((String)"cap4.form.app.start.tips1", (Object)BizChicken4.getTotalNum());
            result.put("message", msg);
            result.put("success", false);
            this.logger.warn((Object)msg);
            return result;
        }
        this.enableBizBean(bizConfigBean);
        this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
        this.addCache(this.initConfigBean(bizConfigBean.getId()));
        if (!hasVerified) {
            this.validateBizConfigBean((BizConfigBean)CONFIG_MAP.get((Serializable)bizConfigBean.getId()));
        }
        this.cap4FormCacheManager.sendNotification((Object)bizConfigBean.getId(), CAP4FormCache.FormCacheType.FromBizConfig_Reload, bizConfigBean.getId());
        this.dispatcherBizFireEvent(bizConfigBean, "update");
        String info = ResourceUtil.getString((String)"cap4.form.app.start.tips2", (Object)bizConfigBean.getName());
        this.logger.info((Object)info);
        result.put("message", info);
        result.put("success", true);
        return result;
    }

    private Map<String, Object> stopBizBean(BizConfigBean bizConfigBean) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.disableBizBean(bizConfigBean);
        this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
        BizConfigBean bizConfigBean1 = this.initConfigBean(bizConfigBean.getId());
        if (!bizConfigBean.isValid()) {
            bizConfigBean1.setValid(bizConfigBean.isValid());
            bizConfigBean1.setInvalidType(bizConfigBean.getInvalidType());
            bizConfigBean1.setInvalidReson(bizConfigBean.getInvalidReson());
        }
        this.addCache(bizConfigBean1);
        this.cap4FormCacheManager.sendNotification((Object)bizConfigBean.getId(), CAP4FormCache.FormCacheType.FromBizConfig_Reload, bizConfigBean.getId());
        this.dispatcherBizFireEvent(bizConfigBean, "update");
        BizValidateResultVO bizValidateResultVO = this.validateManager.validateBiz(bizConfigBean, BizOperationEnum4.delete_app_save);
        if (!bizValidateResultVO.isSuccess()) {
            this.logger.info((Object)("bizValidateResultVO\uff1a" + bizValidateResultVO.getCode()));
        }
        result.put("message", ResourceUtil.getString((String)"cap4.form.business.disabledBiz", (Object)bizConfigBean.getName()));
        result.put("success", true);
        return result;
    }

    private void enableBizBean(BizConfigBean bizConfigBean) throws BusinessException {
        this.logger.info((Object)("\u5f00\u59cb\u542f\u7528\u5e94\u7528\uff1a" + bizConfigBean.getName()));
        List<FormBean> allFormBean = this.getFormBeanListByBizId(bizConfigBean.getId());
        ArrayList<Long> formIds = new ArrayList<Long>();
        for (FormBean formBean : allFormBean) {
            formIds.add(formBean.getId());
        }
        try {
            this.cap4FormListManager.ableForms(Strings.join(formIds, (String)","));
        }
        catch (Exception e) {
            this.logger.error((Object)"\u542f\u7528\u8868\u5355\u51fa\u9519", (Throwable)e);
        }
        List privMenuBOList = bizConfigBean.getMenuList();
        for (PrivMenuBO pm : privMenuBOList) {
            pm.setExt6(Integer.valueOf(0));
        }
        this.privilegeMenuManager.updatePatch(privMenuBOList);
        bizConfigBean.setUseFlag(Integer.valueOf(BizEnums.BizUseFlag.enable.getKey()));
        bizConfigBean.setUpdateDate(DateUtil.currentDate());
        if (BusinessUtil.isBizPage(bizConfigBean)) {
            Set<Long> set = BusinessUtil.getAuthIds(bizConfigBean.getAuthValue());
            PortalNavBo portalNavBo = new PortalNavBo();
            portalNavBo.setId(bizConfigBean.getId() + "");
            portalNavBo.setNavName(bizConfigBean.getName());
            if (Strings.isNotEmpty(set)) {
                this.portalApi.appendThirdPartyToMasterPortalNav("5", portalNavBo, new ArrayList<Long>(set));
                this.portalApi.clearPortalMenusCache();
            }
        }
        try {
            this.reportApi.enableSchStats(bizConfigBean.getId(), ApplicationCategoryEnum.cap4biz.name());
        }
        catch (BusinessException businessException) {
            this.logger.error((Object)"\u542f\u7528\u9759\u6001\u62a5\u8868\u51fa\u9519", (Throwable)businessException);
        }
        this.bizMapManager.activeBizMapByBizId(bizConfigBean.getId());
        this.privilegeMenuManager.updateBiz();
        this.logger.info((Object)("\u7ed3\u675f\u542f\u7528\u5e94\u7528\uff1a" + bizConfigBean.getName()));
    }

    private void disableBizBean(BizConfigBean bizConfigBean) throws BusinessException {
        this.logger.info((Object)("\u5f00\u59cb\u505c\u7528\u5e94\u7528\uff1a" + bizConfigBean.getName()));
        List<FormBean> allFormBean = this.getFormBeanListByBizId(bizConfigBean.getId());
        ArrayList<Long> formIds = new ArrayList<Long>();
        for (FormBean formBean : allFormBean) {
            formIds.add(formBean.getId());
        }
        List privMenuBOList = bizConfigBean.getMenuList();
        for (PrivMenuBO pm : privMenuBOList) {
            pm.setExt6(Integer.valueOf(1));
        }
        this.privilegeMenuManager.updatePatch(privMenuBOList);
        try {
            this.cap4FormListManager.disableForms(Strings.join(formIds, (String)","));
        }
        catch (Exception exception) {
            this.logger.error((Object)"\u505c\u7528\u8868\u5355\u51fa\u9519", (Throwable)exception);
        }
        bizConfigBean.setUseFlag(Integer.valueOf(BizEnums.BizUseFlag.disable.getKey()));
        bizConfigBean.setUpdateDate(DateUtil.currentDate());
        BusinessUtil.removeBizPortalInfo(bizConfigBean);
        this.bizMapManager.inactiveBizMapByBizId(bizConfigBean.getId());
        try {
            this.reportApi.disableSchStats(bizConfigBean.getId(), ApplicationCategoryEnum.cap4biz.name());
        }
        catch (BusinessException businessException) {
            this.logger.error((Object)"\u505c\u7528\u9759\u6001\u62a5\u8868\u51fa\u9519", (Throwable)businessException);
        }
        this.privilegeMenuManager.updateBiz();
        this.portalApi.clearPortalMenusCache();
        this.logger.info((Object)("\u5b8c\u6210\u505c\u7528\u5e94\u7528\uff1a" + bizConfigBean.getName()));
    }

    private void dispatcherBizFireEvent(BizConfigBean bizConfigBean, String operType) {
        ArrayList<BizConfigBean> eventConfigList = new ArrayList<BizConfigBean>();
        eventConfigList.add(bizConfigBean);
        CapBizConfigChangeEvent changeEvent = new CapBizConfigChangeEvent((Object)this);
        changeEvent.setBizConfigBeanList(eventConfigList);
        changeEvent.setHandleType(operType);
        EventDispatcher.fireEventAfterCommit((Event)changeEvent);
    }

    @Override
    public List<BizConfigBean> findBizConfigBeanByOwner(Long memberId) throws BusinessException {
        ArrayList list = Lists.newArrayList();
        Collection values = CONFIG_MAP.values();
        for (BizConfigBean bizConfigBean : values) {
            if (!bizConfigBean.getOwnerId().equals(memberId) || bizConfigBean.isExpire() || bizConfigBean.getUseFlag() == 0 || !bizConfigBean.isValid()) continue;
            list.add(bizConfigBean);
        }
        return list;
    }

    private void addNewMallList(List<Map<String, Object>> list) {
        String url = MallUtil.CLOUD_APP_URL + "/rest/mall/index?action=/api/v5mall/buyList";
        User user = AppContext.getCurrentUser();
        try {
            CloudAppDatas ctpCloudAppData = this.mallApi.getByMemberId(user.getId());
            String accessToken = "";
            if (ctpCloudAppData != null) {
                accessToken = ctpCloudAppData.getAccessToken();
            }
            String code = (String)MallUtil.getMallCommonParams((MallEnum.MallAction)null, new HashMap<String, Object>()).get("code");
            Map corpInfo = this.mplusApi.getCorpInfo();
            if (corpInfo == null) {
                this.logger.info((Object)"\u672a\u7ed1\u5b9a\u4e91\u8054\u8d26\u53f7\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e91\u7aef\u5df2\u8d2d\u5e94\u7528\u5217\u8868");
                return;
            }
            int page = 1;
            int listRows = 50;
            HashMap params = new HashMap();
            params.put("corp_id", corpInfo.get("corpid"));
            params.put("productVersion", SystemEnvironment.getProductVersion());
            params.put("access_token", accessToken);
            params.put("list_rows", 50);
            params.put("page", page);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appID", 9);
            map.put("code", code);
            map.put("params", params);
            this.logger.info((Object)("Query bought app, productVersion:" + SystemEnvironment.getProductVersion()));
            Map<String, Object> resultMap = HttpClientUtil.doPost(url, map);
            if (resultMap != null && "1000".equals(CAPParamUtil.getString(resultMap, (String)"code"))) {
                Map resultData = CAPParamUtil.getParamsMapByKey(resultMap, (String)"data");
                int total = CAPParamUtil.getInteger((Map)resultData, (String)"total");
                if (50 < total) {
                    params.put("list_rows", total);
                    map.put("params", params);
                    resultMap = HttpClientUtil.doPost(url, map);
                    resultData = CAPParamUtil.getParamsMapByKey(resultMap, (String)"data");
                }
                List newMallList = CAPParamUtil.getParamsListByKey((Map)resultData, (String)"data");
                for (Map obj : newMallList) {
                    HashMap<String, Object> transMap = new HashMap<String, Object>();
                    String version = CAPParamUtil.getString((Map)obj, (String)"version") == null ? "" : CAPParamUtil.getString((Map)obj, (String)"version");
                    transMap.put("version", version);
                    transMap.put("size", CAPParamUtil.getString((Map)obj, (String)"package_size") == null ? "0.00" : CAPParamUtil.getString((Map)obj, (String)"package_size"));
                    transMap.put("detailUrl", CAPParamUtil.getString((Map)obj, (String)"_goods_url"));
                    transMap.put("downloadUrl", CAPParamUtil.getString((Map)obj, (String)"goods_package_certificate_url"));
                    transMap.put("name", CAPParamUtil.getString((Map)obj, (String)"goods_name"));
                    transMap.put("bizIcon", CAPParamUtil.getString((Map)obj, (String)"picture_url"));
                    transMap.put("source", "newMall");
                    transMap.put("currentVersion", CAPParamUtil.getString((Map)obj, (String)"current_version"));
                    transMap.put("goodsAppId", CAPParamUtil.getString((Map)obj, (String)"goods_app_id"));
                    transMap.put("orderGoodsId", CAPParamUtil.getString((Map)obj, (String)"order_goods_id"));
                    transMap.put("adaptationPlatform", CAPParamUtil.getString((Map)obj, (String)"adaptation_platform"));
                    Map versionMap = CAPParamUtil.getParamsMapByKey((Map)obj, (String)"_goods_version");
                    transMap.put("versionId", CAPParamUtil.getString((Map)versionMap, (String)"version_id") == null ? "" : CAPParamUtil.getString((Map)versionMap, (String)"version_id"));
                    transMap.put("adaptationVersion", CAPParamUtil.getString((Map)versionMap, (String)"show_adaptation_version") == null ? "" : CAPParamUtil.getString((Map)versionMap, (String)"show_adaptation_version"));
                    transMap.put("versionDesc", CAPParamUtil.getString((Map)versionMap, (String)"version_desc") == null ? "" : CAPParamUtil.getString((Map)versionMap, (String)"version_desc"));
                    transMap.put("createTime", CAPParamUtil.getString((Map)versionMap, (String)"create_time") == null ? "" : CAPParamUtil.getString((Map)versionMap, (String)"create_time"));
                    transMap.put("versionFlag", !this.versionCompare(version, CAPParamUtil.getString((Map)obj, (String)"current_version")));
                    transMap.put("versionLocalFlag", !this.versionCompare(version, CAPParamUtil.getString((Map)obj, (String)"current_version")));
                    list.add(transMap);
                }
            } else {
                this.logger.error((Object)("\u65b0\u5546\u57ce\u5df2\u8d2d\u5217\u8868\u67e5\u8be2\u5931\u8d25" + resultMap));
            }
        }
        catch (BusinessException e) {
            this.logger.info((Object)"\u5df2\u8d2d\u5e94\u7528\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e2) {
            this.logger.info((Object)"\u4e91\u7aef\u5df2\u8d2d\u5e94\u7528\u5217\u8868\u5f02\u5e38", (Throwable)e2);
        }
    }

    private void addOldMallList(List<Map<String, Object>> list) {
        String url = AppContext.getSystemProperty((String)"cloudapp.cloudAppUrl") + "/rest/mall/index?action=/Api/Cap4/buyList";
        User user = AppContext.getCurrentUser();
        CloudAppDatas ctpCloudAppData = this.mallApi.getByMemberId(user.getId());
        String accessToken = "";
        if (ctpCloudAppData != null) {
            accessToken = ctpCloudAppData.getAccessToken();
        }
        String code = (String)MallUtil.getMallCommonParams((MallEnum.MallAction)null, new HashMap<String, Object>()).get("code");
        Map corpInfo = null;
        try {
            corpInfo = this.mplusApi.getCorpInfo();
        }
        catch (BusinessException e) {
            this.logger.error((Object)"\u83b7\u53d6\u4e91\u8054\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        if (corpInfo == null) {
            this.logger.info((Object)"\u672a\u7ed1\u5b9a\u4e91\u8054\u8d26\u53f7\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e91\u7aef\u5df2\u8d2d\u5e94\u7528\u5217\u8868");
            return;
        }
        HashMap params = new HashMap();
        params.put("corp_id", corpInfo.get("corpid"));
        params.put("access_token", accessToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appID", 9);
        map.put("code", code);
        map.put("params", params);
        Map<String, Object> resultMap = HttpClientUtil.doPost(url, map);
        if (resultMap != null && "0".equals(CAPParamUtil.getString(resultMap, (String)"result"))) {
            List oldMallList = CAPParamUtil.getParamsListByKey(resultMap, (String)"data");
            if (oldMallList != null) {
                for (Map obj : oldMallList) {
                    HashMap<String, Object> transMap = new HashMap<String, Object>();
                    transMap.put("version", "V" + CAPParamUtil.getString((Map)obj, (String)"pkg_version"));
                    String size = CAPParamUtil.getString((Map)obj, (String)"package_size") == null ? "0.00" : CAPParamUtil.getString((Map)obj, (String)"package_size");
                    transMap.put("size", size);
                    transMap.put("detailUrl", CAPParamUtil.getString((Map)obj, (String)"url"));
                    transMap.put("downloadUrl", CAPParamUtil.getString((Map)obj, (String)"goods_package_certificate_url"));
                    transMap.put("name", CAPParamUtil.getString((Map)obj, (String)"goods_name"));
                    transMap.put("bizIcon", CAPParamUtil.getString((Map)obj, (String)"goods_icon"));
                    transMap.put("source", "oldMall");
                    transMap.put("versionFlag", false);
                    list.add(transMap);
                }
            }
        } else {
            this.logger.info((Object)("\u67e5\u8be2\u8001\u5546\u57ce\u5931\u8d25\uff1a" + resultMap));
        }
    }

    private boolean versionCompare(String version, String currentVersion) {
        if (Strings.isEmpty((String)version) || Strings.isEmpty((String)currentVersion) || version.equals(currentVersion)) {
            return true;
        }
        String version1 = version.trim().substring(1);
        String currentVersion1 = currentVersion.trim().substring(1);
        String[] versionArray = version1.split("\\.");
        String[] currentVersionArray = currentVersion1.split("\\.");
        for (int i = 0; i < 3; ++i) {
            if (Integer.parseInt(versionArray[i].trim()) < Integer.parseInt(currentVersionArray[i].trim())) {
                return false;
            }
            if (Integer.parseInt(versionArray[i].trim()) == Integer.parseInt(currentVersionArray[i].trim())) continue;
            return true;
        }
        return true;
    }

    private void genCreateAppLog(CapBizConfig config) {
        HashMap<String, String> appLog = new HashMap<String, String>();
        appLog.put("\u52a8\u4f5c", "\u521b\u5efa");
        appLog.put("\u5e94\u7528", config.getName());
        appLog.put("\u521b\u5efa\u4eba", AppContext.currentUserName() + "[" + AppContext.currentUserLoginName() + "]");
        appLog.put("\u521b\u5efa\u65f6\u95f4", DateUtil.currentDateString((String)"yyyy-MM-dd HH:mm:ss"));
        appLog.put("\u5e94\u7528\u521b\u5efa\u5e73\u53f0\u7248\u672c", SystemEnvironment.getProductLine());
        appLog.put("\u5e94\u7528\u521b\u5efa\u6587\u4ef6\u6807\u51c6", "v2.0");
        appLog.put("\u521b\u5efa\u4eba\u4e91\u8054\u4f01\u4e1a", ValidityUtil.getMplusCorpName());
        appLog.put("\u521b\u5efa\u52a0\u5bc6\u72d7\u53f7", CAPBusinessUtil.getDogNo());
        appLog.put("\u521b\u5efa\u4e91\u8054\u4f01\u4e1aID", ValidityUtil.getMplusCorpId());
        config.addAppLog(appLog);
    }

    private void genImpAppLog(CapBizConfig config) {
        HashMap<String, String> appLog = new HashMap<String, String>();
        appLog.put("\u52a8\u4f5c", "\u5b89\u88c5");
        appLog.put("\u5e94\u7528", config.getName());
        appLog.put("\u64cd\u4f5c\u4eba", AppContext.currentUserName() + "[" + AppContext.currentUserLoginName() + "]");
        appLog.put("\u64cd\u4f5c\u65f6\u95f4", DateUtil.currentDateString((String)"yyyy-MM-dd HH:mm:ss"));
        appLog.put("\u5e94\u7528\u64cd\u4f5c\u5e73\u53f0\u7248\u672c", SystemEnvironment.getProductLine());
        appLog.put("\u5e94\u7528\u5b89\u88c5\u6587\u4ef6\u6807\u51c6", "v2.0");
        appLog.put("\u64cd\u4f5c\u4eba\u4e91\u8054\u4f01\u4e1a", ValidityUtil.getMplusCorpName());
        appLog.put("\u64cd\u4f5c\u52a0\u5bc6\u72d7\u53f7", CAPBusinessUtil.getDogNo());
        appLog.put("\u64cd\u4f5c\u4e91\u8054\u4f01\u4e1aID", ValidityUtil.getMplusCorpId());
        config.addAppLog(appLog);
    }

    private Map<String, String> genExpAppLog(CapBizConfig config) {
        HashMap<String, String> appLog = new HashMap<String, String>();
        appLog.put("\u52a8\u4f5c", "\u5bfc\u51fa");
        appLog.put("\u5e94\u7528", config.getName());
        appLog.put("\u64cd\u4f5c\u4eba", AppContext.currentUserName() + "[" + AppContext.currentUserLoginName() + "]");
        appLog.put("\u64cd\u4f5c\u65f6\u95f4", DateUtil.currentDateString((String)"yyyy-MM-dd HH:mm:ss"));
        appLog.put("\u5e94\u7528\u64cd\u4f5c\u5e73\u53f0\u7248\u672c", SystemEnvironment.getProductLine());
        appLog.put("\u5e94\u7528\u5b89\u88c5\u6587\u4ef6\u6807\u51c6", "v2.0");
        appLog.put("\u64cd\u4f5c\u4eba\u4e91\u8054\u4f01\u4e1a", ValidityUtil.getMplusCorpName());
        appLog.put("\u64cd\u4f5c\u52a0\u5bc6\u72d7\u53f7", CAPBusinessUtil.getDogNo());
        appLog.put("\u64cd\u4f5c\u4e91\u8054\u4f01\u4e1aID", ValidityUtil.getMplusCorpId());
        return appLog;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> checkFormEdit4Upgrade(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
        if (CollectionUtils.isNotEmpty(capBizConfigItemList)) {
            String formIds = "";
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                formIds = Strings.joinDelNull((String)",", (String[])new String[]{formIds, capBizConfigItem.getFormId().toString()});
            }
            List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
            if (Strings.isNotEmpty(checkFormEdit)) {
                resultMap.put("success", false);
                resultMap.put("msg", BusinessUtil.formEditInfo(checkFormEdit));
                return resultMap;
            }
        }
        return resultMap;
    }

    public void setBusinessDAO4(BusinessDAO businessDAO4) {
        this.businessDAO4 = businessDAO4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public void setOrgManagerDirect(OrgManagerDirect orgManagerDirect) {
        this.orgManagerDirect = orgManagerDirect;
    }

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public void setPrivilegeManager(PrivilegeManager privilegeManager) {
        this.privilegeManager = privilegeManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCap4FormBusinessRelationManager(CAP4FormBusinessRelationManager cap4FormBusinessRelationManager) {
        this.cap4FormBusinessRelationManager = cap4FormBusinessRelationManager;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setBusinessImportAndExportManager(BusinessImportAndExportManager businessImportAndExportManager) {
        this.businessImportAndExportManager = businessImportAndExportManager;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setValidateManager(ValidateManager validateManager) {
        this.validateManager = validateManager;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }

    public BizMapManager getBizMapManager() {
        return this.bizMapManager;
    }

    public void setBizMapManager(BizMapManager bizMapManager) {
        this.bizMapManager = bizMapManager;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }

    public void setCapConflictMappingDao(CapConflictMappingDao capConflictMappingDao) {
        this.capConflictMappingDao = capConflictMappingDao;
    }

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    public void setBizPortalApi(BizPortalApi bizPortalApi) {
        this.bizPortalApi = bizPortalApi;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public class CacheSyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("CAP4BusinessConfigCacheSyncThread:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    protected class Executor
    implements Runnable {
        protected Executor() {
        }

        public boolean sync() throws BusinessException {
            if (CONFIG_MAP.isEmpty()) {
                return true;
            }
            int sizeIndb = BusinessManagerImpl.this.businessDAO4.getAllCtpBizConfig().size();
            if (CONFIG_MAP.size() != sizeIndb) {
                return false;
            }
            ArrayList bizConfigBeans = new ArrayList(CONFIG_MAP.values());
            Collections.sort(bizConfigBeans, new Comparator<BizConfigBean>(){

                @Override
                public int compare(BizConfigBean o1, BizConfigBean o2) {
                    if (null == o1.getUpdateDate()) {
                        o1.setUpdateDate(o1.getCreateDate());
                    }
                    if (null == o2.getUpdateDate()) {
                        o2.setUpdateDate(o2.getCreateDate());
                    }
                    return o1.getUpdateDate().compareTo(o2.getUpdateDate());
                }
            });
            Date udpateDate1 = ((BizConfigBean)bizConfigBeans.get(bizConfigBeans.size() - 1)).getUpdateDate();
            Date udpateDate2 = BusinessManagerImpl.this.businessDAO4.findMaxUpdateDate();
            return udpateDate1 == null || udpateDate1.equals(udpateDate2);
        }

        @Override
        public void run() {
            while (!BusinessManagerImpl.this.exit.get()) {
                try {
                    if (!this.sync()) {
                        CONFIG_MAP.clear();
                        MENU_MAP.clear();
                    }
                }
                catch (Throwable e) {
                    BusinessManagerImpl.this.logger.error((Object)"CAP4\u5e94\u7528\u4e2d\u7f13\u5b58\u540c\u6b65\u5904\u7406\u7ebf\u7a0b\u5f02\u5e38", e);
                }
                try {
                    Thread.sleep(1800000L);
                }
                catch (InterruptedException e) {
                    BusinessManagerImpl.this.logger.error((Object)"CAP4\u5e94\u7528\u4e2d\u7f13\u5b58\u4f11\u7720\u5f02\u5e38", (Throwable)e);
                }
            }
            BusinessManagerImpl.this.logger.info((Object)"CAP4\u5e94\u7528\u4e2d\u7f13\u5b58\u540c\u6b65\u5904\u7406\u7ebf\u7a0b\u7ed3\u675f");
        }
    }
}

