/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business;

import com.seeyon.cap4.bizportal.api.BizPortalApi;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.BusinessSourceTypeManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.BizUtil;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.PerfUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.flag.SysFlag;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import www.seeyon.com.biz.BizChicken4;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
public class CAP4BusinessController
extends BaseController {
    public static final String SEARCH_BY_CATEGORY = "category";
    public static final String SEARCH_BY_SUBJECT = "subject";
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private FileManager fileManager;
    private CAP4FormListManager cap4FormListManager;
    private OrgManager orgManager;
    private CAP4FormDesignManager cap4FormDesignManager;
    private BizPortalApi bizPortalApi;

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.listBusiness(request, response);
    }

    public ModelAndView listBusinessLicenses(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/managementCenter/listBusinessLicenses");
        modelAndView.addObject("total", (Object)BizChicken4.getTotalNum());
        modelAndView.addObject("used", (Object)BizChicken4.getUsedNum());
        modelAndView.addObject("allow", (Object)BizChicken4.getAllowNum());
        return modelAndView;
    }

    public ModelAndView listBusiness(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigList");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        String type = Strings.escapeJavascript((String)request.getParameter("type"));
        modelAndView.addObject("type", (Object)type);
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView listBusinessApp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView businessAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp/businessAppList");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView businessFormList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp/businessFormList");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView businessMenuList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp/businessMenuList");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView businessFormRelation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp/businessFormRelation");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        modelAndView.addObject("isA6pOrNoCapAdvance", (Object)BusinessUtil.isA6pOrNoCapAdvance());
        return modelAndView;
    }

    public ModelAndView editBusiness(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long bizConfigId;
        BizConfigBean bizConfig;
        ModelAndView mav = new ModelAndView("cap4/form/business/bizconfigNew");
        if (Strings.isNotEmpty((String)request.getParameter("bizConfigId")) && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId = new Long(request.getParameter("bizConfigId")))).getOwnerId().equals(AppContext.currentUserId())) {
            mav.addObject("bizConfig", (Object)bizConfig.getConfig());
            OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
            V3xOrgMember member = orgManager.getMemberById(bizConfig.getCreateUser());
            mav.addObject("createUserName", (Object)member.getName());
            return mav;
        }
        return new ModelAndView("cap4/form/common/noauth");
    }

    public ModelAndView businessPortalSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long bizConfigId;
        BizConfigBean bizConfig;
        ModelAndView mav = new ModelAndView("cap4/form/common/noauth");
        if (Strings.isNotEmpty((String)request.getParameter("bizConfigId")) && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId = new Long(request.getParameter("bizConfigId")))).getOwnerId().equals(AppContext.currentUserId())) {
            boolean showOrHideOldPortal = this.bizPortalApi.showOrHideOldPortal(bizConfigId);
            response.sendRedirect("/seeyon/common/cap4/template/design/dist/index.html?bizId=" + bizConfigId + "&showOrHideOldPortal=" + showOrHideOldPortal);
            return null;
        }
        return mav;
    }

    public ModelAndView businessBaseData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigBaseData");
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        modelAndView.addObject("develop", (Object)AppContext.isRunningModeDevelop());
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        return modelAndView;
    }

    public ModelAndView setOwner(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String edition;
        ModelAndView mav = new ModelAndView("cap4/form/business/bizconfigSetPeopleBelong");
        long currentAccountId = "true".equals(request.getParameter("isBaseInfo")) ? Long.parseLong(request.getParameter("accountId")) : AppContext.currentAccountId();
        String currentAccountName = "true".equals(request.getParameter("isBaseInfo")) ? this.orgManager.getAccountById(Long.valueOf(currentAccountId)).getName() : AppContext.currentAccountName();
        mav.addObject("formAdminList", (Object)this.orgManager.getMembersByRole(Long.valueOf(currentAccountId), OrgConstants.Role_NAME.BusinessDesigner.name()));
        String moduleFlag = request.getParameter("moduleFlag");
        mav.addObject("moduleFlag", (Object)moduleFlag);
        mav.addObject("isAdmin", (Object)AppContext.isAdministrator());
        mav.addObject("currentAccountId", (Object)currentAccountId);
        List accessableAccounts4Tree = this.orgManager.accessableAccounts(Long.valueOf(AppContext.currentUserId()));
        mav.addObject("currAccountName", (Object)currentAccountName);
        if ("form".equals(moduleFlag) && ((edition = ProductEditionEnum.getCurrentProductEditionEnum().getValue()).equals(ProductEditionEnum.enterprise.getValue()) || ((Boolean)SysFlag.sys_isA6Ver.getFlag()).booleanValue())) {
            Iterator var3 = accessableAccounts4Tree.iterator();
            while (var3.hasNext()) {
                V3xOrgAccount a = (V3xOrgAccount)var3.next();
                if (a.getId() == currentAccountId) continue;
                var3.remove();
            }
        }
        request.setAttribute("ffaccessableAccounts4Tree", this.tree(accessableAccounts4Tree));
        return mav;
    }

    public void saveBusinessConfig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bizConfigId = request.getParameter("bizConfigId");
        CapBizConfig bizConfig = new CapBizConfig();
        if (Strings.isBlank((String)bizConfigId)) {
            if (!AppContext.hasPlugin((String)"cap_advance")) {
                throw new BusinessException(ResourceUtil.getString((String)"form.over.power.tips"));
            }
            bizConfig.setNewId();
            bizConfig.putExtraAttr("isNew", "true");
        } else {
            Long bizConfigIdLong = Long.parseLong(bizConfigId);
            bizConfig.setId(bizConfigIdLong);
            BizConfigBean bcb = this.businessManager4.findBizConfigById(bizConfigIdLong);
            if (bcb != null) {
                bizConfig.setUseFlag(bcb.getUseFlag());
            }
        }
        String bizConfigName = request.getParameter("bizConfigName");
        bizConfigName = Strings.escapeJavascript((String)bizConfigName);
        bizConfig.setName(bizConfigName);
        String ownerId = request.getParameter("ownerId");
        if (Strings.isBlank((String)ownerId)) {
            bizConfig.setCreateUser(Long.valueOf(0L));
        } else {
            bizConfig.setOwnerId(Long.valueOf(Long.parseLong(ownerId)));
            bizConfig.setCreateUser(Long.valueOf(Long.parseLong(ownerId)));
        }
        String bizIcon = ReqUtil.getString((HttpServletRequest)request, (String)"bizIcon");
        int bizIconType = ReqUtil.getInt((HttpServletRequest)request, (String)"bizIconType", (int)-1);
        if (Strings.isNotEmpty((String)bizIcon) && bizIconType >= 0) {
            if (bizIconType == 2) {
                bizConfig.setBizIcon("/fileUpload.do?method=showRTE&fileId=" + bizIcon + "&type=image");
            } else {
                bizConfig.setBizIcon(bizIcon);
            }
        }
        bizConfig.putExtraAttr("bizIconType", bizIconType);
        this.businessManager4.doSaveOrUpdateBizConfig(bizConfig);
        bizConfig = this.businessManager4.findBizConfigById(bizConfig.getId());
        super.rendText(response, JSONUtil.toJSONString((Object)bizConfig));
    }

    @Deprecated
    public void listBizFormTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList allList = new ArrayList();
        HashMap returnVale = new HashMap();
        String bizConfigId = request.getParameter("bizConfigId");
        HashMap<String, String> mapParent = new HashMap<String, String>();
        if (Strings.isNotEmpty((String)bizConfigId)) {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(bizConfigId));
            mapParent.put("title", bizConfigBean.getName());
        } else {
            mapParent.put("id", "0");
            mapParent.put("title", ResourceUtil.getString((String)"com.cap.biz.nonamebiz"));
        }
        mapParent.put("pid", "-1");
        mapParent.put("type", "1");
        allList.add(mapParent);
        returnVale.put("list", allList);
        super.rendText(response, JSONUtil.toJSONString(returnVale));
    }

    public ModelAndView newMenu(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bizConfigId = request.getParameter("bizConfigId");
        BizConfigBean bizConfig = new BizConfigBean();
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigMenu");
        List<BusinessSourceTypeManager> list = BizUtil.getCanUseSourceTypeList();
        modelAndView.addObject("createUserName", (Object)AppContext.getCurrentUser().getName());
        bizConfig.setCreateUser(AppContext.getCurrentUser().getId());
        int menu_page = 0;
        if (Strings.isNotBlank((String)bizConfigId) && (bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(bizConfigId))) != null && bizConfig.getOwnerId().equals(AppContext.currentUserId())) {
            List privMenuBOList = bizConfig.getMenuList();
            List<CtpBizConfigItem> items = BusinessUtil.getConfigItem(privMenuBOList, bizConfig.getConfig());
            bizConfig.setItems(items);
            for (PrivMenuBO privMenuBO : privMenuBOList) {
                if (privMenuBO.getExt12().intValue() != Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey()) continue;
                menu_page = 1;
                break;
            }
            modelAndView.addObject("menu_page", (Object)menu_page);
            modelAndView.addObject("bizConfig", (Object)bizConfig);
            modelAndView.addObject("typelist", list);
            modelAndView.addObject("i18nEnable", (Object)SystemEnvironment.functionSwitch((String)"dataI18n"));
            return modelAndView;
        }
        return new ModelAndView("cap4/form/common/noauth");
    }

    @Deprecated
    public ModelAndView editMenu(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/business/bizconfigMenu");
        Long bizConfigId = new Long(request.getParameter("bizConfigId"));
        BizConfigBean bizConfig = this.businessManager4.findBizConfigById(bizConfigId);
        List<BusinessSourceTypeManager> list = BizUtil.getCanUseSourceTypeList();
        mav.addObject("typelist", list);
        mav.addObject("bizConfig", (Object)bizConfig);
        mav.addObject("scopeIds", (Object)bizConfig.getAuthValue());
        mav.addObject("scopeNames", (Object)bizConfig.getAuthText());
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        V3xOrgMember member = orgManager.getMemberById(bizConfig.getCreateUser());
        mav.addObject("createUserName", (Object)member.getName());
        return mav;
    }

    public ModelAndView installApp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/business/managementCenter/managementInstallApp");
        return mav;
    }

    public void saveMenu(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ownerId;
        Map map;
        String bizConfigId;
        CapBizConfig bizConfig = new CapBizConfig();
        List list = ParamUtil.getJsonDomainGroup((String)"domain2");
        String[] sourceTypeAry = new String[list.size()];
        String[] sourceIdAry = new String[list.size()];
        String[] bizConfigItemNameAry = new String[list.size()];
        String[] formAppmainIdAry = new String[list.size()];
        String[] flowMenuTypeNameAry = new String[list.size()];
        String[] menuIdAry = new String[list.size()];
        String[] menuIconAry = new String[list.size()];
        int bizPage = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map map2 = (Map)list.get(i);
            sourceTypeAry[i] = (String)map2.get("sourceType");
            sourceIdAry[i] = (String)map2.get("sourceId");
            menuIdAry[i] = (String)map2.get("menuId");
            String menuName = "";
            String resourceNameKey = ParamUtil.getString((Map)map2, (String)"resourceNameKey");
            if (Strings.isNotEmpty((String)resourceNameKey)) {
                menuName = resourceNameKey;
            } else {
                menuName = (String)map2.get("menuName");
                menuName = menuName.replaceAll("\"", "&quot;");
            }
            bizConfigItemNameAry[i] = menuName;
            formAppmainIdAry[i] = (String)map2.get("formAppmainId");
            flowMenuTypeNameAry[i] = (String)map2.get("flowMenuTypeName");
            flowMenuTypeNameAry[i] = (String)map2.get(flowMenuTypeNameAry[i]);
            menuIconAry[i] = ParamUtil.getString((Map)map2, (String)"menuIcon");
        }
        if (Strings.isEmpty((Collection)list)) {
            Map map3 = ParamUtil.getJsonDomain((String)"domain2");
            sourceTypeAry = new String[1];
            sourceIdAry = new String[1];
            bizConfigItemNameAry = new String[1];
            formAppmainIdAry = new String[1];
            flowMenuTypeNameAry = new String[1];
            menuIdAry = new String[1];
            sourceTypeAry[0] = (String)map3.get("sourceType");
            sourceIdAry[0] = (String)map3.get("sourceId");
            menuIdAry[0] = (String)map3.get("menuId");
            String menuName = "";
            String resourceNameKey = ParamUtil.getString((Map)map3, (String)"resourceNameKey");
            if (Strings.isNotEmpty((String)resourceNameKey)) {
                menuName = resourceNameKey;
            } else {
                menuName = (String)map3.get("menuName");
                menuName = menuName.replaceAll("\"", "&quot;");
            }
            bizConfigItemNameAry[0] = menuName;
            formAppmainIdAry[0] = (String)map3.get("formAppmainId");
            flowMenuTypeNameAry[0] = (String)map3.get("flowMenuTypeName");
            flowMenuTypeNameAry[0] = (String)map3.get(flowMenuTypeNameAry[0]);
            menuIconAry = new String[]{ParamUtil.getString((Map)map3, (String)"menuIcon")};
        }
        if (Strings.isBlank((String)(bizConfigId = (String)(map = ParamUtil.getJsonDomain((String)"domain1")).get("bizConfigId")))) {
            bizConfig.setId(Long.valueOf(0L));
        } else {
            bizConfig.setId(ParamUtil.getLong((Map)map, (String)"bizConfigId", (Long)0L));
        }
        if (null == bizConfig.getId() || bizConfig.getId() == 0L) {
            bizConfig.setNewId();
            bizConfig.putExtraAttr("isNew", "true");
        }
        if (Strings.isBlank((String)(ownerId = (String)map.get("ownerId")))) {
            bizConfig.setCreateUser(Long.valueOf(0L));
        } else {
            bizConfig.setCreateUser(ParamUtil.getLong((Map)map, (String)"ownerId", (Long)0L));
        }
        bizConfig.setName((String)map.get("bizConfigName"));
        bizConfig.putExtraAttr("BIZ_CONFIG_SOURCE_TYPE_ARRAY", sourceTypeAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_SOURCE_ID_ARRAY", sourceIdAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_MENU_NAME_ARRAY", bizConfigItemNameAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_FORM_ID_ARRAY", formAppmainIdAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_MENU_TYPE_ARRAY", flowMenuTypeNameAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_MENU_ID_ARRAY", menuIdAry);
        bizConfig.putExtraAttr("BIZ_CONFIG_MENU_ICON_ARRAY", menuIconAry);
        String sharedScopeIds = Strings.isNotBlank((String)((String)map.get("shareScopeIds"))) ? (String)map.get("shareScopeIds") : "";
        bizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", sharedScopeIds);
        map = ParamUtil.getJsonDomain((String)"domain5");
        if (map != null && Strings.isNotEmpty((String)((String)map.get("appResourceNameKey")))) {
            bizConfig.putExtraAttr("BIZ_CONFIG_MENU_APPNAME_ARRAY", (String)map.get("appResourceNameKey"));
        }
        if (Strings.isNotBlank((String)((String)(map = ParamUtil.getJsonDomain((String)"domain3")).get("bizMerge")))) {
            bizConfig.setBizMerge(Integer.valueOf(1));
            bizConfig.setBizMergeName((String)map.get("bizMergeName"));
        } else {
            bizConfig.setBizMerge(Integer.valueOf(0));
            bizConfig.setBizMergeName(null);
        }
        map = ParamUtil.getJsonDomain((String)"domain4");
        bizPage = ParamUtil.getInt((Map)map, (String)"menu_page", (int)0);
        bizConfig.putExtraAttr("BIZ_PAGE_VALUE", bizPage);
        this.businessManager4.doSaveOrUpdateBizConfig(bizConfig);
        HashMap<String, Boolean> returnVale = new HashMap<String, Boolean>();
        returnVale.put("success", true);
        super.rendText(response, JSONUtil.toJSONString(returnVale));
    }

    public ModelAndView unifiedAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BizConfigBean bizConfig;
        ModelAndView mav = new ModelAndView("cap4/form/business/bizconfigAuth");
        String bizConfigId = ReqUtil.getString((HttpServletRequest)request, (String)"bizConfigId");
        if (Strings.isNotEmpty((String)bizConfigId) && (bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(bizConfigId))).getOwnerId().equals(AppContext.currentUserId())) {
            mav.addObject("bizConfigId", (Object)bizConfigId);
            return mav;
        }
        return new ModelAndView("cap4/form/common/noauth");
    }

    public ModelAndView listbizdata(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/listbizdata");
        String type = request.getParameter("type");
        Map parma = ParamUtil.getJsonParams();
        String queryType = (String)parma.get("queryType");
        String condition = (String)parma.get("condition");
        String textfield = (String)parma.get("textfield");
        BusinessSourceTypeManager sourceType = BizUtil.getSourceTypeById(type);
        String bizConfigId = request.getParameter("bizConfigId");
        Long bizConfigL = 0L;
        if (Strings.isNotBlank((String)bizConfigId)) {
            bizConfigL = Long.parseLong(bizConfigId);
        }
        boolean isAll = false;
        if (Strings.isNotEmpty((String)queryType) && "account".equals(queryType)) {
            isAll = true;
        }
        List allList = sourceType.getFormAppBOList(AppContext.getCurrentUser(), condition, textfield, isAll, bizConfigL);
        boolean needExpan = false;
        if (Strings.isNotBlank((String)condition)) {
            needExpan = true;
        }
        modelAndView.addObject("needExpan", (Object)needExpan);
        request.setAttribute("ffformTemplateTree", (Object)allList);
        return modelAndView;
    }

    @Deprecated
    public ModelAndView listbizdatatree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/listbizdatatree");
        String type = request.getParameter("type");
        BusinessSourceTypeManager sourceType = BizUtil.getSourceTypeById(type);
        if (!Strings.isNotBlank((String)sourceType.getSupportedSearchType())) {
            return this.listbizdata(request, response);
        }
        modelAndView.addObject("queryType", (Object)sourceType.getSupportedSearchType());
        return modelAndView;
    }

    public void createIndexInUniqueByFormId(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formId = request.getParameter("formId");
        PerfUtil.createIndexInUniqueByFormId(Long.valueOf(formId));
        super.rendText(response, "success");
    }

    private List<Map<String, Object>> tree(List<V3xOrgAccount> accessableAccounts4Tree) {
        ArrayList<Map<String, Object>> r = new ArrayList<Map<String, Object>>(accessableAccounts4Tree.size());
        for (V3xOrgAccount a : accessableAccounts4Tree) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", a.getId());
            map.put("name", a.getName());
            map.put("superior", a.getSuperior());
            r.add(map);
        }
        return r;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public CAP4FormListManager getCap4FormListManager() {
        return this.cap4FormListManager;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public CAP4FormDesignManager getCap4FormDesignManager() {
        return this.cap4FormDesignManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setBizPortalApi(BizPortalApi bizPortalApi) {
        this.bizPortalApi = bizPortalApi;
    }
}

