/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemDao;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class CapBizConfigItemManagerImpl
implements CapBizConfigItemManager {
    private CapBizConfigItemDao capBizConfigItemDao;
    private BusinessManager businessManager4;

    @Override
    public List<CapBizConfigItem> findByBizId(Long bizConfigId) throws BusinessException {
        return this.capBizConfigItemDao.findByBizId(bizConfigId);
    }

    @Override
    public CapBizConfigItem findBizInfoByFormId(Long formId) throws BusinessException {
        if (formId != null) {
            return this.capBizConfigItemDao.findBizInfoByFormId(formId);
        }
        return null;
    }

    @Override
    public void saveOrUpdate(Long bizId, Long formId) throws BusinessException {
        CapBizConfigItem capBizConfigItem = this.capBizConfigItemDao.findByBizIdAndFormId(bizId, formId);
        if (capBizConfigItem != null) {
            capBizConfigItem.setModifyTime((Date)DateUtil.currentTimestamp());
            this.capBizConfigItemDao.update(capBizConfigItem);
        } else {
            capBizConfigItem = new CapBizConfigItem();
            capBizConfigItem.setIdIfNew();
            capBizConfigItem.setBizId(bizId);
            capBizConfigItem.setFormId(formId);
            capBizConfigItem.setSort(Integer.valueOf(0));
            capBizConfigItem.setFormType(Integer.valueOf(0));
            capBizConfigItem.setCategoryId(Long.valueOf(-1L));
            capBizConfigItem.setCreateTime((Date)DateUtil.currentTimestamp());
            capBizConfigItem.setModifyTime((Date)DateUtil.currentTimestamp());
            this.capBizConfigItemDao.save(capBizConfigItem);
        }
    }

    @Override
    public List<Long> importBizFormRelation(List<FormBean> formBeanList, Long bizId) throws BusinessException {
        List<CapBizConfigItem> itemList = this.findByBizId(bizId);
        if (Strings.isNotEmpty(itemList)) {
            this.deleteAll(itemList);
        }
        ArrayList<CapBizConfigItem> capBizConfigItemList = new ArrayList<CapBizConfigItem>();
        for (FormBean formBean : formBeanList) {
            capBizConfigItemList.add(this.setCapBizConfigItem(formBean, bizId));
        }
        if (Strings.isNotEmpty(capBizConfigItemList)) {
            return this.capBizConfigItemDao.insert(capBizConfigItemList);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Long> updateBizFormRelation(List<FormBean> formBeanList, Long bizId) throws BusinessException {
        List<CapBizConfigItem> itemList = this.findByBizId(bizId);
        HashSet<Long> formIds = new HashSet<Long>();
        if (Strings.isNotEmpty(itemList)) {
            for (CapBizConfigItem capBizConfigItem : itemList) {
                formIds.add(capBizConfigItem.getFormId());
            }
        }
        ArrayList<CapBizConfigItem> capBizConfigItemList = new ArrayList<CapBizConfigItem>();
        for (FormBean formBean : formBeanList) {
            if (formIds.contains(formBean.getId())) continue;
            capBizConfigItemList.add(this.setCapBizConfigItem(formBean, bizId));
        }
        if (Strings.isNotEmpty(capBizConfigItemList)) {
            return this.capBizConfigItemDao.insert(capBizConfigItemList);
        }
        return Collections.EMPTY_LIST;
    }

    private CapBizConfigItem setCapBizConfigItem(FormBean formBean, Long bizId) {
        CapBizConfigItem capBizConfigItem = new CapBizConfigItem();
        capBizConfigItem.setIdIfNew();
        capBizConfigItem.setBizId(bizId);
        capBizConfigItem.setFormId(formBean.getId());
        capBizConfigItem.setSort(Integer.valueOf(0));
        capBizConfigItem.setFormType(Integer.valueOf(0));
        capBizConfigItem.setCategoryId(Long.valueOf(-1L));
        capBizConfigItem.setCreateTime((Date)DateUtil.currentTimestamp());
        capBizConfigItem.setModifyTime((Date)DateUtil.currentTimestamp());
        return capBizConfigItem;
    }

    @Override
    public void deleteAll(List<CapBizConfigItem> capBizConfigItemList) throws BusinessException {
        this.capBizConfigItemDao.deleteAll(capBizConfigItemList);
    }

    @Override
    public void deleteByBizIdAndFormId(Long bizConfigId, Long formId) throws BusinessException {
        this.capBizConfigItemDao.deleteByBizIdAndFormId(bizConfigId, formId);
    }

    public void setCapBizConfigItemDao(CapBizConfigItemDao capBizConfigItemDao) {
        this.capBizConfigItemDao = capBizConfigItemDao;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

