/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business;

import com.seeyon.cap4.form.modules.business.BizMenuAuthCheckInterface;
import com.seeyon.cap4.form.util.BizUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.form.modules.business.CAPMenuManager;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.enums.PrivMenuTypeEnums;
import com.seeyon.ctp.privilege.manager.FormMenuManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.WORKFLOW)
public class FormMenuManagerImpl
implements FormMenuManager {
    private final Log log = CtpLogFactory.getLog(FormMenuManagerImpl.class);
    private CAPMenuManager cap3FormMenuManager;

    public List<PrivMenuBO> checkMenuAuth(Long memberId, Long accountId, Map<V3xOrgRole, List<PrivMenuBO>> roleMenus0) throws BusinessException {
        String authId;
        if (roleMenus0 == null || roleMenus0.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Object, List<PrivMenuBO>> roleMenusCap4 = new HashMap<Object, List<PrivMenuBO>>();
        HashMap<Object, List<PrivMenuBO>> roleMenusCap3 = new HashMap<Object, List<PrivMenuBO>>();
        for (Map.Entry<V3xOrgRole, List<PrivMenuBO>> roleMenu : roleMenus0.entrySet()) {
            V3xOrgRole orgRole = roleMenu.getKey();
            List<PrivMenuBO> list = roleMenu.getValue();
            boolean cap4Menu = false;
            for (PrivMenuBO privMenuBO : list) {
                if (privMenuBO.getType() == null || privMenuBO.getType().intValue() != PrivMenuTypeEnums.businessCap4Menu.getKey()) continue;
                cap4Menu = true;
                break;
            }
            if (cap4Menu) {
                roleMenusCap4.put(orgRole, list);
                continue;
            }
            roleMenusCap3.put(orgRole, list);
        }
        List cap3PrivMenu = new ArrayList();
        if (this.cap3FormMenuManager != null) {
            cap3PrivMenu = this.cap3FormMenuManager.checkMenuAuth(memberId, accountId, roleMenusCap3);
        }
        HashMap authId2Roles = new HashMap();
        for (Map.Entry entry : roleMenusCap4.entrySet()) {
            V3xOrgRole orgRole = (V3xOrgRole)entry.getKey();
            authId = BizUtil.getMenuAuthCheckId(orgRole.getId(), orgRole);
            Strings.addToMap(authId2Roles, (Object)authId, (Object)orgRole);
        }
        ArrayList<PrivMenuBO> result = new ArrayList<PrivMenuBO>();
        for (Map.Entry authId2Role : authId2Roles.entrySet()) {
            authId = (String)authId2Role.getKey();
            List orgRoles = (List)authId2Role.getValue();
            BizMenuAuthCheckInterface manager = BizUtil.getMenuAuthCheck(authId);
            if (manager == null) {
                this.log.warn((Object)("\u6821\u9a8c\u89d2\u8272\u83dc\u5355\u6743\u9650\u65f6\uff0c\u5bf9\u5e94\u7684\u6743\u9650\u6821\u9a8c\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728\uff1aid=" + authId));
                continue;
            }
            HashMap<V3xOrgRole, List<PrivMenuBO>> roleMenus = new HashMap<V3xOrgRole, List<PrivMenuBO>>();
            for (V3xOrgRole v3xOrgRole : orgRoles) {
                roleMenus.put(v3xOrgRole, (List<PrivMenuBO>)roleMenusCap4.get(v3xOrgRole));
            }
            List<PrivMenuBO> temp = manager.checkMenuAuth(memberId, accountId, roleMenus);
            if (temp == null) continue;
            result.addAll(temp);
        }
        if (Strings.isNotEmpty(cap3PrivMenu)) {
            result.addAll(cap3PrivMenu);
        }
        return result;
    }

    public void setCap3FormMenuManager(CAPMenuManager cap3FormMenuManager) {
        this.cap3FormMenuManager = cap3FormMenuManager;
    }
}

