/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.portal.api.PortalApi;
import java.util.ArrayList;
import java.util.List;

public class Authority4Business
implements BusinessAuthorityManager {
    private BusinessManager businessManager4;

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizConfigId) throws BusinessException {
        BizConfigBean bizConfig;
        ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
        if (bizConfigId != null && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId)) != null) {
            FormAppBO bo = new FormAppBO();
            bo.setId(bizConfigId.toString());
            bo.setFormAppmainId(bizConfigId);
            bo.setSourceType(BizEnums.UnifiedAuthType.BUSINESS.getKey());
            bo.setSourceValue(bizConfigId);
            bo.setName(bizConfig.getName());
            bo.setCategoryId(bizConfig.getName());
            bo.setTitle(bizConfig.getName());
            bo.setSourctTypeName(BizEnums.UnifiedAuthType.BUSINESS.getText());
            bo.setAuthId(bizConfig.getAuthValue());
            bo.setAuthName(bizConfig.getAuthText());
            formBoList.add(bo);
        }
        return formBoList;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO fabo) throws Exception {
        BizConfigBean bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(fabo.getId()));
        CapBizConfig capBizConfig = bizConfig.getConfig();
        capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", fabo.getAuthId());
        this.businessManager4.doSaveOrUpdateBizConfig(capBizConfig);
        PortalApi portalApi = (PortalApi)AppContext.getBean((String)"portalApi");
        portalApi.updatePortalShareAuth(bizConfig.getId(), fabo.getAuthId());
    }

    @Override
    public void removeAuthority(FormAppBO fabo) throws Exception {
        BizConfigBean bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(fabo.getId()));
        CapBizConfig capBizConfig = bizConfig.getConfig();
        capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", "");
        capBizConfig.putExtraAttr("ClearBizAuth", true);
        this.businessManager4.doSaveOrUpdateBizConfig(capBizConfig);
        PortalApi portalApi = (PortalApi)AppContext.getBean((String)"portalApi");
        portalApi.updatePortalShareAuth(bizConfig.getId(), fabo.getAuthId());
    }

    public Integer getSort() {
        return 1;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

