/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateAuth;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Authority4FlowTemplate
implements BusinessAuthorityManager {
    private CapBizConfigItemManager capBizConfigItemManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private TemplateManager templateManager;
    private BusinessManager businessManager4;

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizConfigId) throws BusinessException {
        BizConfigBean bizConfig;
        ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
        if (bizConfigId != null && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId)) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                FormBean fb = this.cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
                if (fb == null || Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                for (CtpTemplate template : templateList) {
                    if (!template.isSystem().booleanValue()) continue;
                    FormAppBO bo = new FormAppBO();
                    bo.setId(template.getId().toString());
                    bo.setFormAppmainId(fb.getId());
                    bo.setSourceType(BizEnums.UnifiedAuthType.FLOWFORMTEMPLATE.getKey());
                    bo.setSourceValue(template.getId());
                    bo.setName(template.getSubject());
                    bo.setCategoryId(bizConfig.getName());
                    bo.setFormAppmainId(template.getFormAppId());
                    bo.setTitle(fb.getFormName());
                    bo.setSourctTypeName(BizEnums.UnifiedAuthType.FLOWFORMTEMPLATE.getText() + "(" + fb.getFormName() + ")");
                    List temAuthList = this.templateManager.getCtpTemplateAuths(template.getId(), Integer.valueOf(ModuleType.collaboration.getKey()));
                    if (temAuthList != null && temAuthList.size() > 0) {
                        bo.setAuthName(Functions.showOrgEntities((Collection)temAuthList, (String)"authId", (String)"authType", null));
                        String authIds = "";
                        for (CtpTemplateAuth cta : temAuthList) {
                            authIds = authIds + cta.getAuthType() + "|" + cta.getAuthId() + ",";
                        }
                        bo.setAuthId(Strings.isNotEmpty((String)authIds) ? authIds.substring(0, authIds.length() - 1) : authIds);
                    }
                    formBoList.add(bo);
                }
            }
        }
        return formBoList;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO fabo) throws Exception {
        if (!this.cap4FormCacheManager.isEnabled(fabo.getFormAppmainId())) {
            return;
        }
        ArrayList<CtpTemplateAuth> ctpTemplateAuthList = new ArrayList<CtpTemplateAuth>();
        String[] authObj = fabo.getAuthId().split(",");
        CtpTemplateAuth templateAuth = null;
        int sort = 1;
        for (String a : authObj) {
            templateAuth = new CtpTemplateAuth();
            String[] authSp = a.split("\\|");
            templateAuth.setId(Long.valueOf(UUIDLong.longUUID()));
            templateAuth.setAuthId(Long.valueOf(Long.parseLong(authSp[1])));
            templateAuth.setAuthType(authSp[0]);
            templateAuth.setModuleId(Long.valueOf(Long.parseLong(fabo.getId())));
            templateAuth.setCreateDate(new Date());
            templateAuth.setModuleType(Integer.valueOf(ModuleType.collaboration.getKey()));
            templateAuth.setSort(Integer.valueOf(sort++));
            ctpTemplateAuthList.add(templateAuth);
        }
        this.templateManager.deleteCtpTemplateAuths(Long.valueOf(Long.parseLong(fabo.getId())), Integer.valueOf(ModuleType.collaboration.getKey()));
        this.templateManager.saveCtpTemplateAuths(ctpTemplateAuthList);
    }

    @Override
    public void removeAuthority(FormAppBO fabo) throws Exception {
        if (!this.cap4FormCacheManager.isEnabled(fabo.getFormAppmainId())) {
            return;
        }
        this.templateManager.deleteCtpTemplateAuths(Long.valueOf(Long.parseLong(fabo.getId())), Integer.valueOf(ModuleType.collaboration.getKey()));
    }

    public Integer getSort() {
        return 3;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

