/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class Authority4Query
implements BusinessAuthorityManager {
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private ReportApi reportApi;

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizConfigId) throws BusinessException {
        BizConfigBean bizConfig;
        ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
        if (bizConfigId != null && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId)) != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("category", ApplicationCategoryEnum.cap4biz.name());
            params.put("categoryId", bizConfig.getId().toString());
            params.put("designType", ReportConstants.DesignType.QUERY.name());
            List reportList = this.reportApi.findDesignWithoutAuth(params);
            for (Map map : reportList) {
                FormAppBO bo = new FormAppBO();
                bo.setId(ParamUtil.getString((Map)map, (String)"designId"));
                bo.setName(ParamUtil.getString((Map)map, (String)"title"));
                bo.setCategoryId(bizConfig.getId().toString());
                String type = map.get("designType").toString();
                bo.setSourceType(BizEnums.UnifiedAuthType.SOURCE_TYPE_QUERY.getKey());
                if (map.get("formmainIds") != null) {
                    String[] formIdArray;
                    String formIds = ParamUtil.getString((Map)map, (String)"formmainIds");
                    ArrayList<String> formNames = new ArrayList<String>();
                    for (String formId : formIdArray = formIds.split(",")) {
                        FormBean fb;
                        if (!Strings.isNotEmpty((String)formId) || (fb = this.cap4FormCacheManager.getForm(Long.parseLong(formId))) == null) continue;
                        formNames.add(fb.getFormName());
                    }
                    bo.setTitle(Strings.join(formNames, (String)","));
                    bo.setSourctTypeName(BizEnums.UnifiedAuthType.SOURCE_TYPE_QUERY.getText() + "(" + Strings.join(formNames, (String)",") + ")");
                } else {
                    bo.setTitle("");
                    bo.setSourctTypeName(BizEnums.UnifiedAuthType.SOURCE_TYPE_QUERY.getText());
                }
                bo.setMultiFormIds(ParamUtil.getString((Map)map, (String)"formmainIds", (String)""));
                bo.setAuthId(ParamUtil.getString((Map)map, (String)"auths", (String)""));
                bo.setAuthName(ParamUtil.getString((Map)map, (String)"authLabels", (String)""));
                bo.setSourceValue(ParamUtil.getLong((Map)map, (String)"designId"));
                formBoList.add(bo);
            }
        }
        return formBoList;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO fabo) throws Exception {
        List<Map<String, Object>> authList = BusinessUtil.getReportAuth(fabo);
        ArrayList<Long> reportList = new ArrayList<Long>();
        reportList.add(fabo.getSourceValue());
        if (CollectionUtils.isNotEmpty(authList)) {
            this.reportApi.deleteDesignAuths(reportList);
            this.reportApi.saveDesignAuths(authList);
        }
    }

    @Override
    public void removeAuthority(FormAppBO fabo) throws Exception {
        ArrayList<Long> reportAuthList = new ArrayList<Long>();
        if (fabo.getSourceValue() != null) {
            reportAuthList.add(fabo.getSourceValue());
            this.reportApi.deleteDesignAuths(reportAuthList);
        }
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public Integer getSort() {
        return 4;
    }
}

