/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.template.bean.TemplateOperationParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.service.CAPTemplateDesignService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Authority4SelfDesignPortal
implements BusinessAuthorityManager {
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPTemplateDesignService capTemplateDesignService;

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizConfigId) throws BusinessException {
        ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
        if (bizConfigId != null) {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplatesForMenu(bizConfigId);
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
                FormAppBO bo = new FormAppBO();
                bo.setId(capBusinessTemplateBO.getId());
                bo.setName(capBusinessTemplateBO.getName());
                bo.setCategoryId(bizConfigId.toString());
                bo.setSourceType(BizEnums.UnifiedAuthType.SOURCE_TYPE_SELFDESIGNPORTAL.getKey());
                bo.setSourctTypeName(BizEnums.UnifiedAuthType.SOURCE_TYPE_SELFDESIGNPORTAL.getText());
                bo.setTitle(capBusinessTemplateBO.getGoodName());
                List<CAPBusinessOrgBO> capBusinessOrgBOList = capBusinessTemplateBO.getCapBusinessOrgBOs();
                if (Strings.isNotEmpty(capBusinessOrgBOList)) {
                    bo.setAuthName(Functions.showOrgEntities(capBusinessOrgBOList, (String)"orgId", (String)"orgType", null));
                    String authIds = "";
                    for (CAPBusinessOrgBO cob : capBusinessOrgBOList) {
                        authIds = authIds + cob.getOrgType() + "|" + cob.getOrgId() + ",";
                    }
                    bo.setAuthId(Strings.isNotEmpty((String)authIds) ? authIds.substring(0, authIds.length() - 1) : authIds);
                }
                formBoList.add(bo);
            }
        }
        return formBoList;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO fabo) throws Exception {
        ArrayList<Long> templateIds = new ArrayList<Long>();
        templateIds.add(Long.valueOf(fabo.getId()));
        ArrayList data = new ArrayList();
        if (Strings.isNotEmpty((String)fabo.getAuthId())) {
            String[] authObj;
            for (String a : authObj = fabo.getAuthId().split(",")) {
                String[] authSp = a.split("\\|");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("orgId", authSp[1]);
                map.put("orgType", authSp[0]);
                data.add(map);
            }
        }
        TemplateOperationParamBean bean = new TemplateOperationParamBean();
        bean.setTemplateIds(templateIds);
        bean.setData(bean.dataDealFieldValue(data));
        this.capTemplateDesignService.multiSaveTemplateOrgAuth(bean);
    }

    @Override
    public void removeAuthority(FormAppBO fabo) throws Exception {
        fabo.setAuthId("");
        this.saveAuthority(fabo);
    }

    public Integer getSort() {
        return 2;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapTemplateDesignService(CAPTemplateDesignService capTemplateDesignService) {
        this.capTemplateDesignService = capTemplateDesignService;
    }
}

