/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class Authority4UnFlowTemplate
implements BusinessAuthorityManager {
    private CapBizConfigItemManager capBizConfigItemManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private FormAuthModuleDAO formAuthModuleDAO;
    private final Log logger = CtpLogFactory.getLog(Authority4UnFlowTemplate.class);

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizConfigId) throws BusinessException {
        BizConfigBean bizConfig;
        ArrayList<FormAppBO> formBoList = new ArrayList<FormAppBO>();
        if (bizConfigId != null && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId)) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                FormBean fb = this.cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
                if (fb == null) continue;
                Map unTemplates = fb.getBind().getUnFlowTemplateMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    FormBindAuthBean template = (FormBindAuthBean)entry.getValue();
                    FormAppBO bo = new FormAppBO();
                    bo.setId(template.getId().toString());
                    bo.setSourceValue(template.getId());
                    bo.setCategoryId(bizConfig.getName());
                    bo.setFormAppmainId(fb.getId());
                    bo.setSourceType(BizEnums.UnifiedAuthType.UNFLOWFORMTEMPLATE.getKey());
                    bo.setSourctTypeName(BizEnums.UnifiedAuthType.UNFLOWFORMTEMPLATE.getText() + "(" + fb.getFormName() + ")");
                    bo.setName(template.getName());
                    bo.setTitle(fb.getFormName());
                    String[] authInfo = template.getAuthStr();
                    if (authInfo != null && authInfo.length > 1) {
                        bo.setAuthId(authInfo[0]);
                        bo.setAuthName(authInfo[1]);
                    }
                    formBoList.add(bo);
                }
            }
        }
        return formBoList;
    }

    public Integer getSort() {
        return 4;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO fabo) throws Exception {
        String[] authObj;
        if (!this.cap4FormCacheManager.isEnabled(fabo.getFormAppmainId())) {
            return;
        }
        ArrayList<FormModuleAuth> moduleList = new ArrayList<FormModuleAuth>();
        for (String au : authObj = fabo.getAuthId().split(",")) {
            FormModuleAuth moduleAuth = new FormModuleAuth();
            moduleAuth.setId(Long.valueOf(UUIDLong.longUUID()));
            moduleAuth.setFormId(fabo.getFormAppmainId());
            moduleAuth.setState(Integer.valueOf(2));
            moduleAuth.setModuleId(Long.valueOf(Long.parseLong(fabo.getId())));
            moduleAuth.setModuleType(Integer.valueOf(Enums.FormModuleAuthModuleType.BindAppForm.getKey()));
            String[] org = au.split("\\|");
            moduleAuth.setOrgType(Integer.valueOf(Enums.FormModuleAuthOrgType.getFormModuleAuthOrgTypeByText((String)org[0]).getKey()));
            moduleAuth.setOrgId(Long.valueOf(Long.parseLong(org[1])));
            moduleList.add(moduleAuth);
        }
        this.formAuthModuleDAO.deleteByModuleId(Long.valueOf(Long.parseLong(fabo.getId())));
        List formModuleAuthList = this.formAuthModuleDAO.selectByModuleId(Long.valueOf(Long.parseLong(fabo.getId())));
        if (CollectionUtils.isNotEmpty((Collection)formModuleAuthList)) {
            this.logger.info((Object)(fabo.getId() + "=\u5220\u9664\u51fa\u9519=" + formModuleAuthList.size()));
            this.formAuthModuleDAO.delete(moduleList);
        }
        this.formAuthModuleDAO.saveOrUpdate(moduleList);
        this.formInit(fabo);
    }

    @Override
    public void removeAuthority(FormAppBO fabo) throws Exception {
        if (!this.cap4FormCacheManager.isEnabled(fabo.getFormAppmainId())) {
            return;
        }
        this.formAuthModuleDAO.deleteByModuleId(Long.valueOf(Long.parseLong(fabo.getId())));
        this.formInit(fabo);
    }

    private void formInit(FormAppBO fabo) throws BusinessException {
        this.cap4FormCacheManager.removeFormBean(fabo.getFormAppmainId());
        this.cap4FormCacheManager.initForm(fabo.getFormAppmainId());
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }
}

