/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.modules.business.impl.BusinessSourceType4FormBindApp;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class BusinessSourceType4FlowTemplate
extends BusinessSourceType4FormBindApp {
    private OrgManager orgManager;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CapBizConfigItemManager capBizConfigItemManager;

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CapBizConfigItemManager getCapBizConfigItemManager() {
        return this.capBizConfigItemManager;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    @Override
    public String getId() {
        return "formApp_flow";
    }

    @Override
    public String getSupportedTypeCode() {
        return "1";
    }

    public boolean isBaseSourceType() {
        return false;
    }

    public String getBaseSourceTypeId() {
        return super.getId();
    }

    @Override
    public List<FormAppBO> getFormAppBOList(User user, String conditionType, String conditionValue, boolean isAll, Long bizId) throws BusinessException {
        ArrayList<FormAppBO> list = new ArrayList<FormAppBO>();
        LinkedHashSet templates = new LinkedHashSet();
        LinkedHashSet<Long> boIds = new LinkedHashSet<Long>();
        ArrayList<ModuleType> categoryList = new ArrayList<ModuleType>();
        categoryList.add(ModuleType.collaboration);
        categoryList.add(ModuleType.form);
        Long accountId = user.getLoginAccount();
        if (!user.isV5Member()) {
            accountId = OrgHelper.getVJoinAllowAccount();
        }
        ArrayList<Long> formIdList = new ArrayList<Long>();
        List<CapBizConfigItem> capBizConfigItemList = this.getCapBizConfigItemManager().findByBizId(bizId);
        if (CollectionUtils.isNotEmpty(capBizConfigItemList)) {
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                formIdList.add(capBizConfigItem.getFormId());
            }
        }
        HashMap<TemplateEnum.searchCondtion, Object> searchCondtionObjectMap = new HashMap<TemplateEnum.searchCondtion, Object>();
        searchCondtionObjectMap.put(TemplateEnum.searchCondtion.formIds, formIdList);
        if (Strings.isNotBlank((String)conditionType) && TemplateEnum.searchCondtion.valueOf((String)conditionType) != null) {
            searchCondtionObjectMap.put(TemplateEnum.searchCondtion.valueOf((String)conditionType), conditionValue);
        }
        if (Strings.isNotEmpty(formIdList)) {
            List tempTemplates = this.getTemplateManager().getSystemTempletes(accountId, categoryList, searchCondtionObjectMap);
            if (Strings.isNotEmpty((Collection)tempTemplates)) {
                templates.addAll(tempTemplates);
            }
            BizConfigBean bizConfigBean = this.getBusinessManager4().findBizConfigById(bizId);
            for (CtpTemplate template : templates) {
                if (!boIds.add(template.getId())) continue;
                Long formId = template.getFormAppId();
                FormBean fb = this.getCap4FormCacheManager().getForm(formId);
                if (!this.getCap4FormCacheManager().isEnabled(fb)) continue;
                FormAppBO bo = new FormAppBO();
                bo.setId(template.getId().toString());
                bo.setSourceValue(template.getId());
                bo.setName(template.getSubject());
                bo.setCategoryId(bizConfigBean.getId().toString());
                bo.setFormAppmainId(formId);
                bo.setTitle(template.getSubject() + "(" + fb.getFormName() + ")");
                V3xOrgMember member = this.getOrgManager().getMemberById(Long.valueOf(fb.getOwnerId()));
                if (member != null) {
                    bo.setFormCreator(member.getName());
                }
                bo.setSourceType(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey());
                list.add(bo);
            }
        }
        return list;
    }

    public boolean checkExist(CtpBizConfigItem bizConfigItem, CapBizConfig bizConfig) throws BusinessException {
        CtpTemplate template = this.getTemplateManager().getCtpTemplate(bizConfigItem.getSourceId());
        return template != null && template.isDelete() == false;
    }
}

