/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.operationcenter;

import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.operationcenter.CAP4OperationCenterManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import www.seeyon.com.biz.CAP4FormClear;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4OperationCenterController
extends BaseController {
    CAP4OperationCenterManager cap4OperationCenterManager;
    CAP4FormCacheManager cap4FormCacheManager;
    private CAP4OperationCenterManager operationCenterManager;
    private BusinessManager businessManager4;

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/operationCenter/operationList");
        modelAndView.addObject("remainDays", (Object)CAP4FormClear.validateMallInfo());
        int softDogType = 0;
        if (SystemEnvironment.isDev()) {
            softDogType = 1;
        } else if (SystemEnvironment.isTG()) {
            softDogType = 2;
        }
        modelAndView.addObject("softDogType", (Object)softDogType);
        return modelAndView;
    }

    public ModelAndView listOperationApp(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/operationApp");
    }

    public ModelAndView colEdit(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/operationColEdit");
    }

    public ModelAndView listFormData(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/operationCenter/queryDataSource");
        Long bizConfigId = ReqUtil.getLong((HttpServletRequest)request, (String)"bizConfigId", (long)0L);
        List<Map<String, Object>> formList = this.businessManager4.getPublishedFormListByBizId(bizConfigId);
        modelAndView.addObject("formList", (Object)JSONUtil.toJSONString(formList));
        return modelAndView;
    }

    public ModelAndView operationNav(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/operationNav");
    }

    public ModelAndView reportDataAuth(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/reportDataAuth");
    }

    public ModelAndView historyLog(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/historyLog");
    }

    public ModelAndView clearFormData(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/clearFormData");
    }

    public ModelAndView clearSpecifyData(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        return new ModelAndView("cap4/form/business/operationCenter/clearSpecifyData");
    }

    public CAP4OperationCenterManager getCap4OperationCenterManager() {
        return this.cap4OperationCenterManager;
    }

    public void setCap4OperationCenterManager(CAP4OperationCenterManager cap4OperationCenterManager) {
        this.cap4OperationCenterManager = cap4OperationCenterManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setOperationCenterManager(CAP4OperationCenterManager operationCenterManager) {
        this.operationCenterManager = operationCenterManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

