/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.business.operationcenter;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.seeyonreport.api.SeeyonreportApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.operationcenter.CAP4OperationCenterManager;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManagerImpl;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormOperationBaseManager;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.log.CapLogDAO;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.po.CapRunningLog;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.ResultInfoVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.utils.DateFormatterUtils;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.CommonTools;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.hibernate.dialect.CTPDBDialect;
import org.hibernate.dialect.Dialect;
import www.seeyon.com.biz.CAP4FormClear;

public class CAP4OperationCenterManagerImpl
implements CAP4OperationCenterManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4OperationCenterManagerImpl.class);
    private CAP4FormDesignManager cap4FormDesignManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private SeeyonreportApi seeyonreportApi;
    private CollaborationApi collaborationApi;
    private BusinessManager businessManager4;
    private CAP4FormListManager cap4FormListManager;
    private TemplateManager templateManager;
    private CAP4FormDataManagerImpl cap4FormDataManager;
    private CapRunningLogManager capRunningLogManager;
    private CapLogDAO capLogDAO;
    private CAP4FormDataDAO cap4FormDataDAO;

    @Override
    @AjaxAccess
    public String validateFormFieldChangeOnMaintenance(Map<String, Object> param) throws BusinessException, SQLException {
        String tableName;
        HashMap<String, Object> resultJson = new HashMap<String, Object>();
        resultJson.put("success", true);
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (formBean == null) {
            resultJson.put("success", false);
            resultJson.put("msg", ResourceUtil.getString((String)"com.cap.operationcenter.noform"));
            return JSONUtil.toJSONString(resultJson);
        }
        Map fieldInfo = (Map)JSONUtil.parseJSONString((String)param.get("fieldInfo").toString());
        String newInputType = fieldInfo.get("inputType").toString();
        if (Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(newInputType)) {
            newInputType = FormFieldComEnum.TEXT.getKey();
        }
        fieldInfo.put("inputType", newInputType);
        fieldInfo.put("from", "maintenance");
        ArrayList tipsArray = new ArrayList();
        List<CAP4FormOperationBaseManager> checkManagers = this.cap4FormDesignManager.getCheckManagerList(formBean.getFormType());
        ResultInfoVO resultInfoVO = null;
        for (CAP4FormOperationBaseManager manager : checkManagers) {
            resultInfoVO = manager.onFieldInfoChange(formBean, fieldInfo);
            if (resultInfoVO.isSuccess()) continue;
            tipsArray.addAll(resultInfoVO.getTipsInfos());
        }
        resultJson.put("details", tipsArray);
        int recordCount = 0;
        if (formBean.getMasterTableBean() != null && Strings.isNotEmpty((String)(tableName = formBean.getMasterTableBean().getTableName()))) {
            recordCount = this.cap4FormDataDAO.selectRecordCount(tableName);
        }
        resultJson.put("recordCount", recordCount);
        resultJson.put("size", tipsArray.size());
        if (tipsArray.size() > 0) {
            resultJson.put("success", false);
        }
        return JSONUtil.toJSONString(resultJson);
    }

    @Override
    @AjaxAccess
    public String getFieldForChangeFieldType(Long formId) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        HashMap resultJson = new HashMap(16);
        ArrayList fieldArray = new ArrayList();
        List allFields = formBean.getAllFieldBeans();
        for (FormFieldBean field : allFields) {
            String inputType = field.getInputType();
            String fieldType = field.getFieldType();
            if ((!FormFieldComEnum.TEXT.getKey().equals(inputType) || field.getFieldType().equalsIgnoreCase(Enums.FieldType.DECIMAL.getKey())) && (!FormFieldComEnum.TEXTAREA.getKey().equals(inputType) || !Enums.FieldType.LONGTEXT.getKey().equals(fieldType))) continue;
            HashMap<String, String> fieldData = new HashMap<String, String>(16);
            fieldData.put("fieldName", field.getName());
            fieldData.put("displayName", field.getDisplay());
            fieldData.put("inputType", field.getInputType());
            fieldData.put("inputTypeText", FormFieldComEnum.getEnumByKey((String)field.getInputType()).getText());
            fieldData.put("fieldType", field.getFieldType());
            fieldData.put("fieldTypeText", Enums.FieldType.getEnumByKey((String)field.getFieldType()).getText());
            fieldData.put("fieldLength", field.getFieldLength());
            fieldArray.add(fieldData);
        }
        resultJson.put("resultJson", fieldArray);
        return JSONUtil.toJSONString(resultJson);
    }

    @Override
    @AjaxAccess
    public String getTargetFieldForChange(Long formId, String fieldName) {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormFieldBean field = formBean.getFieldBeanByName(fieldName);
        String inputType = field.getInputType();
        String fieldType = field.getFieldType();
        HashMap<String, Object> resultJson = new HashMap<String, Object>();
        resultJson.put("fieldName", fieldName);
        resultJson.put("inputType", inputType);
        resultJson.put("fieldType", fieldType);
        String[] canChangeInputType = null;
        String[] canChangeInputTypeText = null;
        String[] canChangeFieldType = null;
        String[] canChangeFieldTypeText = null;
        if (FormFieldComEnum.TEXT.getKey().equals(inputType)) {
            canChangeInputType = new String[]{Enums.FieldType.DECIMAL.getKey(), FormFieldComEnum.EXTEND_DATE.getKey(), FormFieldComEnum.EXTEND_DATETIME.getKey()};
            canChangeInputTypeText = new String[]{Enums.FieldType.DECIMAL.getText(), FormFieldComEnum.EXTEND_DATE.getText(), FormFieldComEnum.EXTEND_DATETIME.getText()};
            canChangeFieldType = new String[]{Enums.FieldType.DECIMAL.getKey(), Enums.FieldType.TIMESTAMP.getKey(), Enums.FieldType.DATETIME.getKey()};
            canChangeFieldTypeText = new String[]{Enums.FieldType.DECIMAL.getText(), Enums.FieldType.TIMESTAMP.getText(), Enums.FieldType.DATETIME.getText()};
        } else if (FormFieldComEnum.TEXTAREA.getKey().equals(inputType) && Enums.FieldType.LONGTEXT.getKey().equals(fieldType)) {
            canChangeInputType = new String[]{FormFieldComEnum.TEXTAREA.getKey()};
            canChangeInputTypeText = new String[]{FormFieldComEnum.TEXTAREA.getText()};
            canChangeFieldType = new String[]{Enums.FieldType.VARCHAR.getKey()};
            canChangeFieldTypeText = new String[]{Enums.FieldType.VARCHAR.getText()};
        }
        resultJson.put("canChangeInputType", canChangeInputType);
        resultJson.put("canChangeInputTypeText", canChangeInputTypeText);
        resultJson.put("canChangeFieldType", canChangeFieldType);
        resultJson.put("canChangeFieldTypeText", canChangeFieldTypeText);
        return JSONUtil.toJSONString(resultJson);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void generateDataset(String formIds) throws BusinessException {
        if (Strings.isNotEmpty((String)formIds)) {
            this.seeyonreportApi.saveOrUpdateFormDataset(CommonTools.parseStr2Ids((String)formIds));
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo showFormDataset(FlipInfo fi, Map<String, Object> paramMap) throws BusinessException {
        HashMap authMap = new HashMap();
        List formList = this.seeyonreportApi.findCap4FormWithDataset();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map form : formList) {
            String hasRptDataSet = String.valueOf(form.get("hasRptDataSet"));
            if (!"true".equals(hasRptDataSet)) continue;
            Long formId = ParamUtil.getLong((Map)form, (String)"formId");
            ids.add(formId);
            authMap.put(formId, form.get("authMembers"));
        }
        if (ids.size() > 0) {
            ArrayList newData = new ArrayList();
            paramMap.put("inParameter", ids);
            this.cap4FormDefinitionDAO.findFormForDataset(fi, paramMap);
            List data = fi.getData();
            for (CAPFormDefinition formDefinition : data) {
                String formName = formDefinition.getName();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formId", formDefinition.getId());
                map.put("formName", formName);
                map.put("categoryId", formDefinition.getCategoryId());
                CtpTemplateCategory ctc = this.templateManager.getCategorybyId(formDefinition.getCategoryId());
                String categoryName = "";
                if (ctc != null) {
                    String i18nName = ResourceUtil.getString((String)ctc.getName());
                    categoryName = StringUtil.checkNull((String)i18nName) ? ctc.getName() : i18nName;
                }
                map.put("categoryName", categoryName);
                map.put("authMembers", authMap.get(formDefinition.getId()));
                newData.add(map);
            }
            fi.setData(newData);
        }
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void deleteFormDataset(String formIds) throws BusinessException {
        if (Strings.isNotEmpty((String)formIds)) {
            this.seeyonreportApi.deleteFormDatasetBatch(CommonTools.parseStr2Ids((String)formIds));
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void saveOrUpdateFormDatasetAuth(String formId, String memberIds) throws BusinessException {
        if (Strings.isNotEmpty((String)formId) && Strings.isNotEmpty((String)memberIds)) {
            this.seeyonreportApi.saveOrUpdateFormDatasetAuth(Long.valueOf(Long.parseLong(formId)), CommonTools.parseStr2Ids((String)memberIds));
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> clearFormData(String formIds, String softDog) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", false);
        if (Strings.isNotEmpty((String)formIds)) {
            boolean validate;
            String[] formIdArr;
            List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formIds);
            if (Strings.isNotEmpty(checkFormEdit)) {
                result.put("success", false);
                result.put("message", BusinessUtil.formEditInfo(checkFormEdit) + ResourceUtil.getString((String)"cap4.form.business.common.formEdit"));
                return result;
            }
            ArrayList<CapRunningLog> logList = new ArrayList<CapRunningLog>();
            for (String formId : formIdArr = formIds.split(",")) {
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(Long.parseLong(formId));
                FormBean formbean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
                long bizId = 0L;
                String bizName = null;
                if (bizConfigBean != null) {
                    bizId = bizConfigBean.getId();
                    bizName = bizConfigBean.getName();
                }
                logList.add(new CapRunningLog(bizId, bizName, Long.parseLong(formId), formbean.getFormName(), 0L, Enums.CapLogType.CLEARDATA.getKey(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), "\u300a" + formbean.getFormName() + "\u300b" + ResourceUtil.getString((String)"form.monitor.log.running.form.clearData"), AppContext.getRemoteAddr()));
            }
            Map map = CAP4FormClear.clearCAP4FormData((String)formIds, (String)softDog);
            boolean bl = validate = map.containsKey("success") && (Boolean)map.get("success") != false;
            if (!validate) {
                return map;
            }
            this.capRunningLogManager.saveRunningLog(logList);
            result.put("success", true);
        }
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> clearSpecifiedFormData(Map<String, Object> param) throws BusinessException {
        FormBean formBean;
        CtpTemplate ctpTemplate;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String softDog = ParamUtil.getString(param, (String)"softDog", (String)"");
        Long templateId = ParamUtil.getLong(param, (String)"templateId", (Long)-1L);
        String summaryIds = ParamUtil.getString(param, (String)"summaryIds", (String)"");
        result.put("success", false);
        if (templateId != -1L && Strings.isNotEmpty((String)summaryIds) && (ctpTemplate = this.templateManager.getCtpTemplate(templateId)) != null && ctpTemplate.getFormAppId() != null && (formBean = this.cap4FormCacheManager.getForm(ctpTemplate.getFormAppId())) != null) {
            boolean validate;
            List<Map<String, Object>> checkFormEdit = this.cap4FormListManager.checkFormIsEdit(formBean.getId() + "");
            if (Strings.isNotEmpty(checkFormEdit)) {
                result.put("success", false);
                result.put("message", BusinessUtil.formEditInfo(checkFormEdit) + ResourceUtil.getString((String)"cap4.form.business.common.formEdit"));
                return result;
            }
            Map map = CAP4FormClear.clearCAP4SpecifiedFormData(param);
            boolean bl = validate = map.containsKey("success") && (Boolean)map.get("success") != false;
            if (!validate) {
                return map;
            }
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
            long bizId = 0L;
            String bizName = null;
            if (bizConfigBean != null) {
                bizId = bizConfigBean.getId();
                bizName = bizConfigBean.getName();
            }
            this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), 0L, Enums.CapLogType.SPECIALDATA.getKey(), "\u300a" + formBean.getFormName() + "\u300b" + ResourceUtil.getString((String)"form.monitor.log.running.form.clearData"), AppContext.getCurrentUser().getId(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
            result.put("success", true);
        }
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getSummarysAndTemplates(FlipInfo fi, Map<String, Object> map) throws BusinessException {
        if (map.isEmpty() && !map.containsKey("templateId")) {
            throw new BusinessException("\u5fc5\u987b\u9009\u62e9\u8868\u5355\u6a21\u677f\uff01");
        }
        return this.collaborationApi.getSummarysAndTemplates(fi, map);
    }

    @Override
    @AjaxAccess
    public String changeFieldData(Map<String, String> paramMap) {
        String formId = paramMap.get("formId");
        String fieldName = paramMap.get("fieldName");
        String newFieldType = paramMap.get("newFieldType");
        String newInputType = paramMap.get("newInputType");
        HashMap<String, String> resObj = new HashMap<String, String>(16);
        if (null == formId || null == fieldName || null == newInputType) {
            resObj.put("success", "false");
            resObj.put("errorMsg", "formId\u3001fieldName\u3001newInputType" + ResourceUtil.getString((String)"cap.template.common.text.notNull"));
        } else {
            if (FormFieldComEnum.EXTEND_DATE.getKey().equalsIgnoreCase(newInputType)) {
                newFieldType = Enums.FieldType.TIMESTAMP.getKey();
            } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equalsIgnoreCase(newInputType)) {
                newFieldType = Enums.FieldType.DATETIME.getKey();
            }
            if (Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(newInputType)) {
                newInputType = FormFieldComEnum.TEXT.getKey();
            }
            String newDigit = paramMap.get("newDigit");
            String newFieldLength = paramMap.get("newFieldLength");
            FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
            FormFieldBean toFieldBean = null;
            try {
                boolean isToDate = FormFieldComEnum.EXTEND_DATE.getKey().equals(newInputType) || FormFieldComEnum.EXTEND_DATETIME.getKey().equals(newInputType);
                toFieldBean = (FormFieldBean)formFieldBean.clone();
                toFieldBean.setInputType(newInputType);
                toFieldBean.setFieldType(newFieldType);
                if (!isToDate) {
                    toFieldBean.setDigitNum(newDigit);
                    toFieldBean.setFieldLength(newFieldLength);
                } else {
                    toFieldBean.setDigitNum(null);
                    toFieldBean.setFieldLength("0");
                }
                List<String> sqls = this.getChangeSql(formBean, toFieldBean, formFieldBean);
                this.cap4FormDataManager.saveBatchChangeData(sqls, toFieldBean, formFieldBean, formBean);
                formBean.getTableByTableName(formFieldBean.getOwnerTableName()).addFormField(formFieldBean);
                formFieldBean.setInputType(newInputType);
                formFieldBean.setFieldType(newFieldType);
                if (!isToDate) {
                    formFieldBean.setDigitNum(newDigit);
                    formFieldBean.setFieldLength(newFieldLength);
                } else {
                    formFieldBean.setDigitNum(null);
                    formFieldBean.setFieldLength("0");
                }
                CAPFormDefinition capFormDefinition = formBean.toFormDefinition();
                capFormDefinition.setModifyTime(DateUtil.currentDate());
                formBean.setModifyDate(DateUtil.currentDate());
                this.cap4FormDefinitionDAO.update(capFormDefinition);
                this.cap4FormCacheManager.initForm(formBean.getId());
                resObj.put("success", "true");
            }
            catch (Exception e) {
                resObj.put("success", "false");
                resObj.put("errorMsg", e.getMessage());
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return JSONUtil.toJSONString(resObj);
    }

    private List<String> getChangeSql(FormBean form, FormFieldBean toFieldBean, FormFieldBean formFieldBean) throws BusinessException {
        String fieldName = toFieldBean.getName() + "_change";
        String tName = toFieldBean.getOwnerTableName();
        LinkedList<String> sqlStr = new LinkedList<String>();
        Dialect dialect = SystemEnvironment.getDialect();
        String oldName = toFieldBean.getName();
        List<Map> fieldData = this.cap4FormDataDAO.selectDataBySql("select id," + toFieldBean.getName() + " from " + tName);
        boolean hasData = false;
        if (null != fieldData && fieldData.size() > 0) {
            hasData = true;
            toFieldBean.setName(fieldName);
            String addColumnSql = form.getTableByTableName(tName).getAddColumnSql(dialect, toFieldBean);
            sqlStr.add(addColumnSql);
            toFieldBean.setName(oldName);
        }
        switch (formFieldBean.getInputTypeEnum()) {
            case TEXT: {
                if (toFieldBean.getFieldType().equals(Enums.FieldType.DECIMAL.getKey())) {
                    for (Map columnData : fieldData) {
                        String id = String.valueOf(columnData.get("id"));
                        Object val = columnData.get(toFieldBean.getName());
                        String numberData = String.valueOf(val);
                        if (null == val || !NumberUtils.isNumber((String)numberData)) {
                            sqlStr.add("update " + tName + " set " + fieldName + " = 0 where id=" + id);
                            continue;
                        }
                        Object dbVal = null;
                        try {
                            dbVal = toFieldBean.getDisplayValue((Object)numberData)[0];
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("\u8fd0\u7ef4\u4e2d\u5fc3\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u5b57\u6bb5" + formFieldBean.getName() + " \u503c\uff1a" + numberData + " \u7c7b\u578b" + formFieldBean.getInputType() + " " + formFieldBean.getFieldType()));
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            dbVal = "0";
                        }
                        String fieldVal = null == dbVal ? "0" : dbVal.toString();
                        sqlStr.add("update " + tName + " set " + fieldName + " = " + fieldVal + " where id=" + id);
                    }
                    break;
                }
                if (toFieldBean.getFieldType().equals(Enums.FieldType.TIMESTAMP.getKey()) || toFieldBean.getInputTypeEnum().equals((Object)FormFieldComEnum.EXTEND_DATE)) {
                    for (Map columnData : fieldData) {
                        String id = String.valueOf(columnData.get("id"));
                        Object val = columnData.get(toFieldBean.getName());
                        String sql = "";
                        String strVal = String.valueOf(val);
                        if (StringUtil.checkNull((String)strVal)) continue;
                        try {
                            Date fieldValue = DateFormatterUtils.strToDate((String)strVal, (String)"yyyy-MM-dd");
                            strVal = Datetimes.formatNoTimeZone((Date)fieldValue, (String)"yyyy-MM-dd");
                            if (ReportDBUtils.isMySQLRuntime()) {
                                sql = "update " + tName + " set " + fieldName + " = date_format('" + strVal + "','%Y-%m-%d') where id=" + id;
                            } else if (ReportDBUtils.isSQLServerRuntime()) {
                                sql = "update " + tName + " set " + fieldName + " = convert(datetime,'" + strVal + "',23) where id=" + id;
                            } else if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime()) {
                                sql = "update " + tName + " set " + fieldName + " = to_date('" + strVal + "','yyyy-mm-dd') where id=" + id;
                            }
                        }
                        catch (Exception b) {
                            sql = "update " + tName + " set " + fieldName + " = null where id=" + id;
                        }
                        if (StringUtils.isEmpty((CharSequence)sql)) continue;
                        sqlStr.add(sql);
                    }
                    break;
                }
                if (!toFieldBean.getFieldType().equals(Enums.FieldType.DATETIME.getKey()) && !toFieldBean.getInputTypeEnum().equals((Object)FormFieldComEnum.EXTEND_DATETIME)) break;
                for (Map columnData : fieldData) {
                    String id = String.valueOf(columnData.get("id"));
                    Object val = columnData.get(toFieldBean.getName());
                    String sql = "";
                    String strVal = String.valueOf(val);
                    if (StringUtil.checkNull((String)strVal)) continue;
                    try {
                        Date fieldValue = DateFormatterUtils.strToDate((String)String.valueOf(val), (String)"yyyy-MM-dd HH:mm");
                        strVal = Datetimes.formatNoTimeZone((Date)fieldValue, (String)"yyyy-MM-dd HH:mm:ss");
                        if (ReportDBUtils.isMySQLRuntime()) {
                            sql = "update " + tName + " set " + fieldName + " = date_format('" + strVal + "','%Y-%m-%d %H:%i:%S') where id=" + id;
                        } else if (ReportDBUtils.isSQLServerRuntime()) {
                            sql = "update " + tName + " set " + fieldName + " = convert(datetime,'" + strVal + "',20) where id=" + id;
                        } else if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime()) {
                            sql = "update " + tName + " set " + fieldName + " = to_date('" + strVal + "','yyyy-mm-dd hh24:mi:ss') where id=" + id;
                        }
                    }
                    catch (Exception b) {
                        sql = "update " + tName + " set " + fieldName + " = null where id=" + id;
                    }
                    sqlStr.add(sql);
                }
                break;
            }
            case TEXTAREA: {
                if (!toFieldBean.getFieldType().equals(Enums.FieldType.VARCHAR.getKey())) break;
                for (Map columnData : fieldData) {
                    String id = String.valueOf(columnData.get("id"));
                    Object val = columnData.get(toFieldBean.getName());
                    if (null == val) continue;
                    String fieldValue = String.valueOf(val);
                    int fieldLength = Integer.parseInt(toFieldBean.getFieldLength()) / 3 - 1;
                    if (fieldValue.length() > fieldLength) {
                        fieldValue = fieldValue.substring(0, fieldLength);
                    }
                    sqlStr.add("update " + tName + " set " + fieldName + " = '" + fieldValue + "' where id=" + id);
                }
                break;
            }
        }
        if (hasData) {
            sqlStr.add("ALTER TABLE " + toFieldBean.getOwnerTableName() + " drop column " + toFieldBean.getName());
            if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
                sqlStr.add("ALTER TABLE " + toFieldBean.getOwnerTableName() + " rename column " + fieldName + " to " + toFieldBean.getName() + " ");
            } else if (ReportDBUtils.isMySQLRuntime() || ReportDBUtils.isSQLServerRuntime()) {
                sqlStr.add(form.getTableByTableName(formFieldBean.getOwnerTableName()).getAddColumnSql(dialect, toFieldBean));
                sqlStr.add("update " + formFieldBean.getOwnerTableName() + " set " + toFieldBean.getName() + "=" + fieldName);
                sqlStr.add("ALTER TABLE " + toFieldBean.getOwnerTableName() + " drop column " + fieldName);
            }
        } else {
            sqlStr.add(this.modifyAColumnSql(toFieldBean, dialect));
        }
        return sqlStr;
    }

    private String modifyAColumnSql(FormFieldBean ffb, Dialect d) {
        StringBuilder sb = new StringBuilder();
        sb.append("alter table ");
        sb.append(ffb.getOwnerTableName()).append(" ");
        sb.append(((CTPDBDialect)d).getModifyColumnString(ffb.getName()));
        int length = StringUtil.checkNull((String)ffb.getFieldLength()) ? 0 : Integer.parseInt(ffb.getFieldLength());
        int digt = StringUtil.checkNull((String)ffb.getDigitNum()) ? 0 : Integer.parseInt(ffb.getDigitNum());
        sb.append(Enums.FieldType.columnSql((Dialect)d, (String)ffb.getFieldType(), (int)length, (int)length, (int)digt));
        return sb.toString();
    }

    public static String getInParameter(List list, String parameter) {
        StringBuffer sb = new StringBuffer();
        if (list.size() > 1000) {
            sb.append("(");
            int num = list.size() / 1000 + 1;
            for (int i = 0; i < num; ++i) {
                String paramStr = StringUtils.join(list.subList(1000 * i, i + 1 == num ? list.size() : 1000 * (i + 1)), (String)",").replace(",", "','");
                if (i == 0) {
                    sb.append(" (" + parameter + " in ('").append(paramStr).append("')");
                    continue;
                }
                sb.append("  or " + parameter + " in ('").append(paramStr).append("')");
            }
            sb.append(")");
        } else {
            sb.append(parameter + " in ('").append(StringUtils.join((Iterable)list, (String)",").replace(",", "','")).append("')\n");
        }
        return sb.toString();
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormDefinitionDAO getCap4FormDefinitionDAO() {
        return this.cap4FormDefinitionDAO;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public void setSeeyonreportApi(SeeyonreportApi seeyonreportApi) {
        this.seeyonreportApi = seeyonreportApi;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManagerImpl cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }

    public void setCapLogDAO(CapLogDAO capLogDAO) {
        this.capLogDAO = capLogDAO;
    }
}

