/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.component.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.component.ComponentLeft2Right;
import com.seeyon.cap4.form.modules.component.Left2RightFilterVO;
import com.seeyon.cap4.form.modules.component.Left2RightVO;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FieldFilterParamVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class Left2RightUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(Left2RightUtil.class);
    private static Map<String, ComponentLeft2Right> left2RightMap = new HashMap<String, ComponentLeft2Right>();
    private static Map<String, Left2RightFilterVO> filterVOMap = new HashMap<String, Left2RightFilterVO>();

    private static void init() {
        if (!left2RightMap.isEmpty()) {
            return;
        }
        Map springMap = AppContext.getBeansOfType(ComponentLeft2Right.class);
        for (Map.Entry entry : springMap.entrySet()) {
            left2RightMap.put(((ComponentLeft2Right)entry.getValue()).getName(), (ComponentLeft2Right)entry.getValue());
            filterVOMap.put(((ComponentLeft2Right)entry.getValue()).getName(), ((ComponentLeft2Right)entry.getValue()).getFilterVO());
        }
    }

    public static ComponentLeft2Right get(String name) {
        Left2RightUtil.init();
        return left2RightMap.get(name);
    }

    public static Left2RightFilterVO getFilterVO(String name) {
        Left2RightUtil.init();
        return filterVOMap.get(name);
    }

    public static List<FormFieldBean> filterFormFieldBean(FormBean formBean, Left2RightFilterVO filterVO) throws BusinessException {
        return Left2RightUtil.filterFormFieldBean(formBean.getAllFieldBeans(), filterVO);
    }

    public static List<FormFieldBean> filterFormFieldBean(List<FormFieldBean> fieldBeans, Left2RightFilterVO filterVO) throws BusinessException {
        ArrayList<FormFieldBean> results = new ArrayList<FormFieldBean>();
        if (Strings.isNotEmpty(fieldBeans)) {
            for (FormFieldBean fieldBean : fieldBeans) {
                if (filterVO.isFilterTextArea() && Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldBean.getFieldType())) continue;
                FormFieldComEnum comEnum = fieldBean.getInputTypeEnum();
                if (filterVO.isFilterAttr() && fieldBean.isAttachment() && (!comEnum.getKey().equals(FormFieldComEnum.EXTEND_IMAGE.getKey()) || filterVO.isFilterImage())) continue;
                if (filterVO.isFilterLbs() && fieldBean.isLbs()) {
                    if (!filterVO.isNotFilterMapLocate() || comEnum != FormFieldComEnum.MAP_LOCATE) continue;
                    results.add(fieldBean);
                    continue;
                }
                if (filterVO.isFilterFlowDealOption() && comEnum == FormFieldComEnum.FLOWDEALOPITION || fieldBean.isCustomerCtrl() && filterVO.isFilterCustom()) continue;
                results.add(fieldBean);
            }
        }
        return results;
    }

    public static List<Left2RightVO> convertFields2Vos(List<FormFieldBean> fieldBeans, boolean needTableName) {
        ArrayList<Left2RightVO> vos = new ArrayList<Left2RightVO>();
        for (FormFieldBean fieldBean : fieldBeans) {
            Left2RightVO vo = new Left2RightVO(fieldBean, needTableName);
            vos.add(vo);
        }
        return vos;
    }

    public static List<FormFieldBean> filterFormFieldBean(FieldFilterParamVO paramVO) throws BusinessException {
        Map<String, List<FormFieldBean>> map = Left2RightUtil.filterFormFieldBeanByTable(paramVO);
        ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
        if (!map.isEmpty()) {
            for (Map.Entry<String, List<FormFieldBean>> et : map.entrySet()) {
                fieldBeans.addAll((Collection<FormFieldBean>)et.getValue());
            }
        }
        return fieldBeans;
    }

    public static Map<String, List<FormFieldBean>> filterFormFieldBeanByTable(FieldFilterParamVO paramVO) throws BusinessException {
        LinkedHashMap<String, List<FormFieldBean>> map = new LinkedHashMap<String, List<FormFieldBean>>();
        FormBean formBean = paramVO.getFormBean();
        if (formBean == null) {
            return map;
        }
        FormTableBean tableBean = paramVO.getTableBean();
        if (tableBean == null) {
            List tableBeans = formBean.getTableList();
            for (FormTableBean table : tableBeans) {
                if (!paramVO.isNeedCollectTable() && table.isCollectTable()) continue;
                map.put(table.getTableName(), Left2RightUtil.filterFieldBean(paramVO, table));
            }
        } else {
            map.put(tableBean.getTableName(), Left2RightUtil.filterFieldBean(paramVO, tableBean));
        }
        return map;
    }

    private static List<FormFieldBean> filterFieldBean(FieldFilterParamVO paramVO, FormTableBean tableBean) throws BusinessException {
        ArrayList<FormFieldBean> results = new ArrayList<FormFieldBean>();
        List fieldBeans = tableBean.getFields();
        for (FormFieldBean fieldBean : fieldBeans) {
            if (Left2RightUtil.filterInputType(paramVO.getInputTypes(), paramVO.isSaveInput(), fieldBean)) continue;
            results.add(fieldBean);
        }
        return results;
    }

    private static boolean filterInputType(List<String> inputTypes, boolean saveInput, FormFieldBean fieldBean) throws BusinessException {
        if (Strings.isNotEmpty(inputTypes) && inputTypes.contains(fieldBean.getInputTypeEnum().getKey())) {
            return !saveInput;
        }
        return false;
    }
}

