/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.authorization;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.engin.authorization.CAP4FormAuthDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormTriggerDataRightVo;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4FormAuthDesignController
extends BaseController {
    private CAP4FormManager cap4FormManager;
    private CAP4FormAuthDesignManager cap4FormAuthDesignManager;
    private FileManager fileManager;
    private CAP4FormDesignManager cap4FormDesignManager;

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/authDesign/designAuth4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        String curPlatName = ReqUtil.getString((HttpServletRequest)request, (String)"curPlat");
        String curViewName = ReqUtil.getString((HttpServletRequest)request, (String)"curViewName");
        FormBean fb = this.cap4FormDesignManager.checkAndLoadForm2Session(formId, "");
        long currentViewId = 0L;
        if (curPlatName != null && Strings.isNotEmpty((String)curViewName)) {
            if ("pc".equals(curPlatName)) {
                currentViewId = fb.getPCFormViewByName(curViewName).getId();
            }
            if ("mb".equals(curPlatName)) {
                currentViewId = fb.getPhoneFormViewByName(curViewName).getId();
            }
        } else {
            currentViewId = ReqUtil.getLong((HttpServletRequest)request, (String)"formViewId", (long)((FormViewBean)fb.getFormViewList().get(0)).getId());
        }
        modelAndView.addObject("textarea", (Object)FormFieldComEnum.TEXTAREA.getKey());
        modelAndView.addObject("flowDealOption", (Object)FormFieldComEnum.FLOWDEALOPITION.getKey());
        modelAndView.addObject("linenumber", (Object)FormFieldComEnum.LINE_NUMBER.getKey());
        modelAndView.addObject("browse", (Object)Enums.FieldAccessType.browse.getKey());
        modelAndView.addObject("add", (Object)Enums.FieldAccessType.add.getKey());
        modelAndView.addObject("edit", (Object)Enums.FieldAccessType.edit.getKey());
        modelAndView.addObject("hide", (Object)Enums.FieldAccessType.hide.getKey());
        modelAndView.addObject("isNotNull", (Object)1);
        modelAndView.addObject("formAuthorizationType", (Object)Enums.FormAuthorizationType.values());
        HashMap<String, String> formObj = new HashMap<String, String>();
        formObj.put("formTitle", fb.getFormName());
        formObj.put("viewId", "" + currentViewId);
        FormViewBean viewBean = fb.getFormView(currentViewId);
        modelAndView.addObject("formBean", (Object)fb);
        modelAndView.addObject("viewBean", (Object)viewBean);
        modelAndView.addObject("formViewId", (Object)currentViewId);
        request.setAttribute("ffform", formObj);
        List auList = viewBean.getOperations();
        for (int i = 0; i < auList.size(); ++i) {
            FormAuthViewBean fvb;
            fvb.putExtraAttr("sysName", (fvb = (FormAuthViewBean)auList.get(i)).isDefaultAuth() ? ResourceUtil.getString((String)"form.system.popedom.sort") : ResourceUtil.getString((String)"form.user.popedom.sort"));
            fvb.putExtraAttr("typeName", Enums.FormAuthorizationType.getEnumByKey((String)fvb.getType()).getI18nStr());
        }
        modelAndView.addObject("authList", (Object)auList);
        return modelAndView;
    }

    public ModelAndView formDesignAuthSlave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("cap4/form/design/authDesign/designAuthSlave4CAP4");
    }

    public ModelAndView formDesignHighAuthSlave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/authDesign/designHighAuthSlave4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        modelAndView.addObject("fb", (Object)fb);
        return modelAndView;
    }

    public ModelAndView formDesignAuthDefault(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/authDesign/designAuthDefaultValue4CAP4");
        String fieldName = ReqUtil.getString((HttpServletRequest)request, (String)"fieldName");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
        Map<String, Object> returnMap = this.cap4FormAuthDesignManager.designAuthDefaultValue(ffb, formId);
        modelAndView.addObject("formFieldBean", (Object)ffb);
        modelAndView.addObject("disableMap", returnMap.get("disableMap"));
        modelAndView.addObject("data_handWork", returnMap.get("data_handWork"));
        modelAndView.addObject("data_system", returnMap.get("data_system"));
        return modelAndView;
    }

    public ModelAndView highAuthDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/authDesign/highAuthDesign4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        long currentViewId = ReqUtil.getLong((HttpServletRequest)request, (String)"formViewId", (long)((FormViewBean)fb.getFormViewList().get(0)).getId());
        modelAndView.addObject("viewType", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"viewType", (String)"view"));
        modelAndView.addObject("authId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"authId", (long)-1L));
        return modelAndView;
    }

    public ModelAndView highAuthFieldAuthDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/authDesign/highAuthFieldAuthDesign4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        long currentViewId = ReqUtil.getLong((HttpServletRequest)request, (String)"formViewId", (long)((FormViewBean)fb.getFormViewList().get(0)).getId());
        modelAndView.addObject("textarea", (Object)FormFieldComEnum.TEXTAREA.getKey());
        modelAndView.addObject("linenumber", (Object)FormFieldComEnum.LINE_NUMBER.getKey());
        modelAndView.addObject("flowdealoption", (Object)FormFieldComEnum.FLOWDEALOPITION.getKey());
        modelAndView.addObject("browse", (Object)Enums.FieldAccessType.browse.getKey());
        modelAndView.addObject("add", (Object)Enums.FieldAccessType.add.getKey());
        modelAndView.addObject("edit", (Object)Enums.FieldAccessType.edit.getKey());
        modelAndView.addObject("hide", (Object)Enums.FieldAccessType.hide.getKey());
        modelAndView.addObject("isNotNull", (Object)1);
        modelAndView.addObject("fb", (Object)fb);
        modelAndView.addObject("formViewId", (Object)currentViewId);
        modelAndView.addObject("viewType", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"viewType", (String)"view"));
        modelAndView.addObject("authId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"authId", (long)-1L));
        modelAndView.addObject("parentId", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"parentId", (String)"authset"));
        return modelAndView;
    }

    public ModelAndView fieldAuthAdvanceSet(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView("cap4/form/design/authDesign/advanceFieldAuthSet4CAP4");
        String fieldName = ReqUtil.getString((HttpServletRequest)request, (String)"fieldName");
        String viewType = ReqUtil.getString((HttpServletRequest)request, (String)"viewType");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
        FormTableBean ftb = fb.getFormTableBeanByFieldName(ffb.getName());
        mav.addObject("field", (Object)ffb);
        mav.addObject("textarea", (Object)FormFieldComEnum.TEXTAREA.getKey());
        mav.addObject("linenumber", (Object)FormFieldComEnum.LINE_NUMBER.getKey());
        mav.addObject("browse", (Object)Enums.FieldAccessType.browse.getKey());
        mav.addObject("add", (Object)Enums.FieldAccessType.add.getKey());
        mav.addObject("edit", (Object)Enums.FieldAccessType.edit.getKey());
        mav.addObject("hide", (Object)Enums.FieldAccessType.hide.getKey());
        mav.addObject("isNotNull", (Object)1);
        mav.addObject("viewType", (Object)viewType);
        return mav;
    }

    public ModelAndView saveAs(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/design/authDesign/authSaveAs");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        String initOperationType = ReqUtil.getString((HttpServletRequest)request, (String)"initOperationType");
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        mav.addObject("formBean", (Object)formBean);
        mav.addObject("initOperationType", (Object)initOperationType);
        ArrayList<Map<String, String>> operationTypeList = new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", Enums.FormAuthorizationType.add.getKey());
                        this.put("text", Enums.FormAuthorizationType.add.getI18nStr());
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", Enums.FormAuthorizationType.update.getKey());
                        this.put("text", Enums.FormAuthorizationType.update.getI18nStr());
                    }
                });
            }
        };
        if (initOperationType.equals(Enums.FormAuthorizationType.show.getKey())) {
            operationTypeList.add(new HashMap<String, String>(){
                {
                    this.put("key", Enums.FormAuthorizationType.show.getKey());
                    this.put("text", Enums.FormAuthorizationType.show.getI18nStr());
                }
            });
        }
        mav.addObject("operationTypeList", (Object)operationTypeList);
        return mav;
    }

    public ModelAndView views4SaveAs(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/design/authDesign/viewList4SaveAs");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        ArrayList<FormTriggerDataRightVo> pcViewList = new ArrayList<FormTriggerDataRightVo>();
        ArrayList<FormTriggerDataRightVo> phoneViewList = new ArrayList<FormTriggerDataRightVo>();
        for (FormViewBean viewBean : formBean.getFormViewList()) {
            FormTriggerDataRightVo showVo = new FormTriggerDataRightVo();
            showVo.setRightId(viewBean.getId() + "");
            showVo.setRightName(viewBean.getFormViewName());
            if (Enums.ViewType.SeeyonForm.getText().equals(viewBean.getFormViewType())) {
                pcViewList.add(showVo);
                continue;
            }
            phoneViewList.add(showVo);
        }
        mav.addObject("pcViewList", pcViewList);
        mav.addObject("phoneViewList", phoneViewList);
        return mav;
    }

    public ModelAndView auths4SaveAs(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/design/authDesign/authList4SaveAs");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        String initOperationType = ReqUtil.getString((HttpServletRequest)request, (String)"initOperationType");
        ArrayList<Map<String, String>> operationTypeList = new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", Enums.FormAuthorizationType.add.getKey());
                        this.put("text", Enums.FormAuthorizationType.add.getI18nStr());
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", Enums.FormAuthorizationType.update.getKey());
                        this.put("text", Enums.FormAuthorizationType.update.getI18nStr());
                    }
                });
            }
        };
        if (initOperationType.equals(Enums.FormAuthorizationType.show.getKey())) {
            operationTypeList.add(new HashMap<String, String>(){
                {
                    this.put("key", Enums.FormAuthorizationType.show.getKey());
                    this.put("text", Enums.FormAuthorizationType.show.getI18nStr());
                }
            });
        }
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        mav.addObject("operationTypeList", (Object)operationTypeList);
        mav.addObject("formBean", (Object)formBean);
        return mav;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public CAP4FormAuthDesignManager getCAP4FormAuthDesignManager() {
        return this.cap4FormAuthDesignManager;
    }

    public void setCap4FormAuthDesignManager(CAP4FormAuthDesignManager cap4FormAuthDesignManager) {
        this.cap4FormAuthDesignManager = cap4FormAuthDesignManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }
}

