/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.authorization;

import com.seeyon.cap4.form.api.ExtendManager;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.authorization.CAP4FormAuthDesignManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.AuthListVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormAuthDesignManagerImpl
implements CAP4FormAuthDesignManager {
    private CAP4FormManager cap4FormManager;
    private FormCacheManager formCacheManager;
    private SerialNumberManager serialNumberManager;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormAuthDesignManagerImpl.class);

    public SerialNumberManager getSerialNumberManager() {
        return this.serialNumberManager;
    }

    public void setSerialNumberManager(SerialNumberManager serialNumberManager) {
        this.serialNumberManager = serialNumberManager;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getAuthById4Edit(long authId, Long formId) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormAuthViewBean favb = null;
        for (FormViewBean fvb : fb.getFormViewList()) {
            favb = fvb.getAuthorizaton(authId);
            if (favb == null) continue;
            resultMap.put("authId", favb.getId());
            resultMap.put("defaultAuth", favb.isDefaultAuth());
            resultMap.put("authTitle", favb.getName());
            resultMap.put("authType", favb.getType());
            resultMap.put("authTypeValue", favb.getType());
            this.getAuthJson(resultMap, fb, favb);
            List list1 = favb.getConditionFormAuthViewBeanList();
            LinkedList<String> list = new LinkedList<String>();
            for (FormAuthViewBean favb1 : list1) {
                FormConditionActionBean fcab = favb1.getFormConditionActionBean();
                HashMap<String, Object> temp = new HashMap<String, Object>();
                HashMap<String, Object> temp1 = new HashMap<String, Object>();
                this.getAuthJson(temp1, fb, favb1);
                temp.put("authId", favb1.getId());
                temp.put("authValue", JSONUtil.toJSONString(temp1));
                temp.put("conditionId", fcab == null ? 0L : fcab.getId());
                temp.put("conditionValue", fcab == null ? "" : fcab.getConditionFormula());
                list.add(JSONUtil.toJSONString(temp));
            }
            resultMap.put("highAuths", list.size() == 0 ? "" : ((Object)list).toString());
            if (list.size() > 0 && !favb.isApartSetAuth()) {
                resultMap.put("advanceAuthType", 0);
                break;
            }
            resultMap.put("advanceAuthType", favb.getAdvanceAuthType());
            break;
        }
        this.cap4FormManager.saveEditingForm(fb);
        return resultMap;
    }

    private void getAuthJson(Map<String, Object> resultMap, FormBean fb, FormAuthViewBean favb) throws BusinessException {
        int count = 0;
        List slaveBean = fb.getSubTableBean();
        for (FormTableBean ftb : slaveBean) {
            String display = Strings.isBlank((String)ftb.getDisplay()) ? "subgroup" + ++count : ftb.getDisplay();
            String escapeDisplay = display.replace(".", "\\.");
            resultMap.put(escapeDisplay, display);
            resultMap.put(escapeDisplay + "_add", "" + favb.hasOperation("my:" + display, "add"));
            resultMap.put(escapeDisplay + "_copy", "" + favb.hasOperation("my:" + display, "copy"));
            resultMap.put(escapeDisplay + "_delete", "" + favb.hasOperation("my:" + display, "delete"));
            resultMap.put(escapeDisplay + "_deleteAll", "" + favb.hasOperation("my:" + display, "deleteAll"));
            resultMap.put(escapeDisplay + "_importData", "" + favb.hasOperation("my:" + display, "importData"));
            resultMap.put(escapeDisplay + "_exportData", "" + favb.hasOperation("my:" + display, "exportData"));
        }
        List list = favb.getFormAuthorizationFieldList();
        for (FormAuthViewFieldBean favfb : list) {
            resultMap.put(favfb.getFieldName() + "_access", favfb.getAccess());
            resultMap.put(favfb.getFieldName() + "_notNull", favfb.getIsNotNull());
            resultMap.put(favfb.getFieldName() + "_defaultValue", favfb.getDefaultValue());
            resultMap.put(favfb.getFieldName() + "_defaultValueType", favfb.getDefaultValueType());
            resultMap.put(favfb.getFieldName() + "_showName", favfb.getShowName());
            resultMap.put(favfb.getFieldName() + "_isInitNull", favfb.getIsInitNull());
            if (!favb.isApartSetAuth()) continue;
            resultMap.put(favfb.getFieldName() + "_fieldHighAuths", favb.getHighFieldAuthJson(favfb.getFieldName()));
        }
    }

    @Override
    @AjaxAccess
    public String deleteAuthByIds(List<Object> ids, long viewId, Long formId) throws BusinessException {
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormAuthViewBean favb = null;
        for (FormViewBean fvb : fb.getFormViewList()) {
            if (fvb.getId() != viewId) continue;
            for (Object id : ids) {
                favb = fvb.getAuthorizaton(Long.parseLong(id.toString()));
                if (null == favb) continue;
                favb.putExtraAttr("FORM_AUTH_DELETE_FLAG", "true");
                fvb.addAuthorizaton(favb);
            }
        }
        this.cap4FormManager.saveEditingForm(fb);
        return "success";
    }

    @Override
    public String saveOrUpdateAuth(Map map) throws BusinessException {
        Object array;
        long authId = Long.parseLong(map.get("authId").toString());
        String type = map.get("authTypeValue").toString();
        long viewId = Long.parseLong(map.get("viewId").toString());
        long formId = Long.parseLong(map.get("formId").toString());
        StringBuilder sb = new StringBuilder();
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormAuthViewBean formAuthViewBean = new FormAuthViewBean();
        FormViewBean fvBean = fb.getFormView(viewId);
        List viewBeans = fvBean.getFormAuthViewBeanListByType(Enums.FormAuthorizationType.getEnumByKey((String)type));
        if (authId != 0L) {
            try {
                formAuthViewBean = (FormAuthViewBean)fvBean.getAuthorizaton(authId).clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            formAuthViewBean.setId(Long.valueOf(UUIDLong.longUUID()));
        }
        boolean hasInitNull = formAuthViewBean.isContainInitNull();
        formAuthViewBean.setFormViewId(viewId);
        formAuthViewBean.setDefaultAuth("true".equals(map.get("defaultAuth").toString()));
        formAuthViewBean.setType(type);
        formAuthViewBean.setAdvanceAuthType(map.get("advanceAuthType") == null || Strings.isEmpty((String)map.get("advanceAuthType").toString()) ? -1 : Integer.parseInt(map.get("advanceAuthType").toString()));
        formAuthViewBean.setName(map.get("authTitle").toString().trim());
        formAuthViewBean.setContainInitNull(false);
        List fieldList = fb.getAllFieldBeans();
        LinkedList<FormAuthViewFieldBean> conditionFieldAuthList = null;
        LinkedList<FormAuthViewFieldBean> conditionFieldAuthList2 = new LinkedList<FormAuthViewFieldBean>();
        for (Object formFieldBean : fieldList) {
            String defaultType;
            FormAuthViewFieldBean formAuthViewFieldBean = new FormAuthViewFieldBean();
            formAuthViewFieldBean.setAccess(map.get(formFieldBean.getName() + "_access").toString());
            formAuthViewFieldBean.setFieldName(formFieldBean.getName());
            formAuthViewFieldBean.setFormFieldBean((FormFieldBean)formFieldBean);
            Object isNotNull = map.get(formFieldBean.getName() + "_notNull");
            formAuthViewFieldBean.setIsNotNull(isNotNull == null || "null".equals(isNotNull.toString()) || Strings.isBlank((String)isNotNull.toString()) ? 0 : Integer.valueOf(isNotNull.toString()));
            formAuthViewFieldBean.setDefaultValue(null);
            formAuthViewFieldBean.setDefaultValueType(null);
            formAuthViewFieldBean.setShowName(null);
            String string = defaultType = map.get(formFieldBean.getName() + "_defaultValueType") != null ? map.get(formFieldBean.getName() + "_defaultValueType").toString() : "";
            if (!"".equals(defaultType)) {
                formAuthViewFieldBean.setDefaultValueType(defaultType);
                formAuthViewFieldBean.setDefaultValue(map.get(formFieldBean.getName() + "_defaultValue") != null ? map.get(formFieldBean.getName() + "_defaultValue").toString() : "");
                formAuthViewFieldBean.setShowName(map.get(formFieldBean.getName() + "_showName").toString());
                String isInitNull = map.get(formFieldBean.getName() + "_isInitNull").toString();
                int initNull = Strings.isBlank((String)isInitNull) ? 0 : Integer.valueOf(isInitNull);
                formAuthViewFieldBean.setIsInitNull(initNull);
                if (initNull == 1) {
                    formAuthViewBean.setContainInitNull(true);
                }
            }
            if (formAuthViewBean.isApartSetAuth() && map.get(formFieldBean.getName() + "_fieldHighAuths") != null && Strings.isNotEmpty((String)map.get(formFieldBean.getName() + "_fieldHighAuths").toString())) {
                conditionFieldAuthList = new LinkedList<FormAuthViewFieldBean>();
                array = (List)JSONUtil.parseJSONString((String)map.get(formFieldBean.getName() + "_fieldHighAuths").toString());
                if (array != null && array.size() > 0) {
                    Iterator initNull = array.iterator();
                    while (initNull.hasNext()) {
                        Map conMap = (Map)initNull.next();
                        this.setFieldAdvanceAuthByJson(conMap, conditionFieldAuthList, fb, (FormFieldBean)formFieldBean);
                    }
                    conditionFieldAuthList2.addAll(conditionFieldAuthList);
                }
                formAuthViewBean.addConditionAuthFieldBean(formFieldBean.getName(), conditionFieldAuthList);
            } else if (formAuthViewBean.getFieldConditionAuths() != null) {
                formAuthViewBean.getFieldConditionAuths().remove(formFieldBean.getName());
            }
            formAuthViewBean.addFormAuthorizationField(formFieldBean.getName(), formAuthViewFieldBean);
        }
        List slaveBean = fb.getSubTableBean();
        for (FormTableBean formTableBean : slaveBean) {
            Object _add = map.get(formTableBean.getDisplay() + "_add");
            Object _copy = map.get(formTableBean.getDisplay() + "_copy");
            Object _delete = map.get(formTableBean.getDisplay() + "_delete");
            Object _deleteAll = map.get(formTableBean.getDisplay() + "_deleteAll");
            Object _importData = map.get(formTableBean.getDisplay() + "_importData");
            Object _exportData = map.get(formTableBean.getDisplay() + "_exportData");
            boolean add = _add == null || "null".equals(_add.toString()) ? false : Boolean.valueOf(_add.toString());
            boolean copy = _copy == null || "null".equals(_copy.toString()) ? false : Boolean.valueOf(_copy.toString());
            boolean delete = _delete == null || "null".equals(_delete.toString()) ? false : Boolean.valueOf(_delete.toString());
            boolean deleteAll = _deleteAll == null || "null".equals(_deleteAll.toString()) ? false : Boolean.valueOf(_deleteAll.toString());
            boolean importData = _importData == null || "null".equals(_importData.toString()) ? false : Boolean.valueOf(_importData.toString());
            boolean exportData = _exportData == null || "null".equals(_exportData.toString()) ? false : Boolean.valueOf(_exportData.toString());
            formAuthViewBean.addFormAuthorizationTable("my:" + formTableBean.getDisplay(), add, copy, delete, deleteAll, importData, exportData);
        }
        this.compareFieldAccess(fb, formAuthViewBean, viewBeans, sb);
        String highAuths = map.get("highAuths").toString();
        LOGGER.info((Object)("highAuths======>" + highAuths));
        if (!"".equals(highAuths)) {
            highAuths = highAuths.replaceAll("\\t\\t\\t\\t                    ", "");
            HashMap<Long, String> newHighAuth = new HashMap<Long, String>();
            Object parseObject = JSONUtil.parseJSONString((String)highAuths);
            if (parseObject instanceof Map) {
                this.doAuths((Map)parseObject, fb, formAuthViewBean, newHighAuth);
            } else if (parseObject instanceof List) {
                array = (List)parseObject;
                LinkedList list = new LinkedList();
                for (int i = 0; i < array.size(); ++i) {
                    list.add(array.get(i));
                }
                for (Map highAuth : list) {
                    this.doAuths(highAuth, fb, formAuthViewBean, newHighAuth);
                }
            }
            for (FormAuthViewBean favb : formAuthViewBean.getConditionFormAuthViewBeanList()) {
                if (newHighAuth.containsKey(favb.getId())) continue;
                favb.putExtraAttr("FORM_AUTH_DELETE_FLAG", "true");
                formAuthViewBean.removeConditionFormAuthViewBean(favb.getId());
            }
            List favb_list = formAuthViewBean.getConditionFormAuthViewBeanList();
            for (int i = 0; i < favb_list.size(); ++i) {
                FormAuthViewBean favb = (FormAuthViewBean)favb_list.get(i);
                if (i == 0) {
                    favb.getFormConditionActionBean().setKeyword(Enums.FormulaConditionLogic.IF.getText());
                } else {
                    favb.getFormConditionActionBean().setKeyword(Enums.FormulaConditionLogic.ELSEIF.getText());
                }
                favb.getFormConditionActionBean().setSortNumber(Integer.valueOf(i));
            }
            if (sb.length() == 0) {
                this.compareFieldAccess(fb, formAuthViewBean, null, sb);
            }
        } else {
            List fieldBeans = fb.getFieldsByType(FormFieldComEnum.FLOWDEALOPITION);
            this.validateNonHighAuths(formAuthViewBean, fieldBeans, conditionFieldAuthList2, sb);
            formAuthViewBean.setAuths(new LinkedHashMap());
        }
        if (sb.length() == 0) {
            fvBean.addAuthorizaton(formAuthViewBean);
        }
        this.cap4FormManager.saveEditingForm(fb);
        return sb.toString();
    }

    @Override
    @AjaxAccess
    public String saveOrUpdateAuth(Map authFieldMap, Map info) throws BusinessException {
        Map params = authFieldMap;
        Map autuIdMap = info;
        for (Map.Entry entryObj : autuIdMap.entrySet()) {
            if (!(entryObj instanceof Map.Entry)) continue;
            Map.Entry entry = entryObj;
            params.put(entry.getKey(), entry.getValue());
        }
        String ret = this.saveOrUpdateAuth(params);
        return ret;
    }

    private void validateNonHighAuths(FormAuthViewBean formAuthViewBean, List<FormFieldBean> ownerFieldBeans, List<FormAuthViewFieldBean> conditionFieldAuthList, StringBuilder sb) {
        if (Enums.FormAuthorizationType.update != Enums.FormAuthorizationType.getEnumByKey((String)formAuthViewBean.getType())) {
            return;
        }
        if (conditionFieldAuthList != null && ownerFieldBeans != null) {
            for (FormAuthViewFieldBean favfb1 : conditionFieldAuthList) {
                for (FormFieldBean formFieldBean : ownerFieldBeans) {
                    FormAuthViewFieldBean favfb2 = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
                    Enums.FieldAccessType accessType1 = Enums.FieldAccessType.getEnumByKey((String)favfb1.getAccess());
                    Enums.FieldAccessType accessType2 = Enums.FieldAccessType.getEnumByKey((String)favfb2.getAccess());
                    if (!favfb1.getFieldName().equals(favfb2.getFieldName()) || !Enums.FieldAccessType.isAddOrEditAccess((Enums.FieldAccessType)accessType1) || !Enums.FieldAccessType.isAddOrEditAccess((Enums.FieldAccessType)accessType2) || accessType1 == accessType2) continue;
                    sb.append(ResourceUtil.getString((String)"form.designauth.notsame.highAuth", (Object)formFieldBean.getDisplay(), (Object)accessType2.getText())).append("<br/>");
                }
            }
        }
    }

    private void setFieldAdvanceAuthByJson(Map map, List<FormAuthViewFieldBean> list, FormBean fb, FormFieldBean ffb) {
        FormAuthViewFieldBean conditionAuthField = new FormAuthViewFieldBean();
        conditionAuthField.setId(Long.valueOf(UUIDLong.longUUID()));
        conditionAuthField.setAccess(map.get("access").toString());
        conditionAuthField.setFieldName(ffb.getName());
        conditionAuthField.setFormFieldBean(ffb);
        Object isNotNull = map.get("isNotNull");
        conditionAuthField.setIsNotNull(isNotNull == null || "null".equals(isNotNull.toString()) ? 0 : Integer.parseInt(isNotNull.toString()));
        conditionAuthField.setDefaultValue(null);
        conditionAuthField.setDefaultValueType(null);
        conditionAuthField.setShowName(null);
        String ifText = Enums.FormulaConditionLogic.IF.getText();
        ifText = list.isEmpty() ? Enums.FormulaConditionLogic.IF.getText() : Enums.FormulaConditionLogic.ELSEIF.getText();
        conditionAuthField.setFormConditionActionBean(fb.getFormConditionActionBean(null, map.get("formulaValue") == null ? "" : map.get("formulaValue").toString(), conditionAuthField.getId() + "", Enums.FormulaConditionType.FORM_AUTHORITY.getKey(), null, list.size(), ifText));
        list.add(conditionAuthField);
    }

    private void compareFieldAccess(FormBean formBean, FormAuthViewBean formAuthViewBean, List<FormAuthViewBean> viewBeans, StringBuilder sb) {
        if (Enums.FormAuthorizationType.update != Enums.FormAuthorizationType.getEnumByKey((String)formAuthViewBean.getType())) {
            return;
        }
        List fieldBeans = formBean.getFieldsByType(FormFieldComEnum.FLOWDEALOPITION);
        if (Strings.isEmpty((Collection)fieldBeans)) {
            return;
        }
        if (viewBeans == null) {
            Map map = formAuthViewBean.getAuths();
            for (Map.Entry et : map.entrySet()) {
                if (sb.length() > 0) break;
                this.compareFieldAccess(fieldBeans, (FormAuthViewBean)et.getValue(), formAuthViewBean, sb, true);
            }
            return;
        }
        if (Strings.isEmpty(viewBeans)) {
            return;
        }
        for (FormAuthViewBean viewBean : viewBeans) {
            if (formAuthViewBean.getId().equals(viewBean.getId()) || !formAuthViewBean.getType().equals(viewBean.getType())) continue;
            this.compareFieldAccess(fieldBeans, formAuthViewBean, viewBean, sb, false);
            if (sb.length() <= 0) continue;
            break;
        }
    }

    private void compareFieldAccess(List<FormFieldBean> fieldBeans, FormAuthViewBean formAuthViewBean, FormAuthViewBean formAuthViewBean2, StringBuilder sb, boolean isHighAuth) {
        for (FormFieldBean formFieldBean : fieldBeans) {
            FormAuthViewFieldBean viewFieldBean1 = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            FormAuthViewFieldBean viewFieldBean2 = formAuthViewBean2.getFormAuthorizationField(formFieldBean.getName());
            Enums.FieldAccessType accessType1 = Enums.FieldAccessType.getEnumByKey((String)viewFieldBean1.getAccess());
            Enums.FieldAccessType accessType2 = Enums.FieldAccessType.getEnumByKey((String)viewFieldBean2.getAccess());
            if (!Enums.FieldAccessType.isAddOrEditAccess((Enums.FieldAccessType)accessType1) || !Enums.FieldAccessType.isAddOrEditAccess((Enums.FieldAccessType)accessType2) || accessType1 == accessType2) continue;
            if (isHighAuth) {
                sb.append(ResourceUtil.getString((String)"form.designauth.notsame.highAuth", (Object)formFieldBean.getDisplay(), (Object)accessType2.getText())).append("<br/>");
                continue;
            }
            sb.append(ResourceUtil.getString((String)"form.designauth.notsame", (Object)formFieldBean.getDisplay(), (Object)formAuthViewBean2.getName(), (Object)accessType2.getText())).append("<br/>");
        }
    }

    private void doAuths(Map highAuth, FormBean fb, FormAuthViewBean ownerformAuthViewBean, Map<Long, String> newHighAuth) {
        String conditionFormula = highAuth.get("conditionValue").toString();
        if (Strings.isBlank((String)conditionFormula) || ResourceUtil.getString((String)"form.authdesign.hightauth.label").equals(conditionFormula)) {
            return;
        }
        String authValues = highAuth.get("authValue").toString();
        authValues = authValues.replaceAll("\\\\", "");
        LOGGER.info((Object)("authValues====>" + authValues));
        Map authValue = (Map)JSONUtil.parseJSONString((String)authValues);
        long authId = Long.parseLong(highAuth.get("authId").toString());
        FormAuthViewBean formAuthViewBean = null;
        if (authId == 0L) {
            formAuthViewBean = new FormAuthViewBean();
            formAuthViewBean.setId(Long.valueOf(UUIDLong.longUUID()));
            ownerformAuthViewBean.addConditonFormAuthViewBean(formAuthViewBean.getId(), formAuthViewBean);
            formAuthViewBean.setParentId(ownerformAuthViewBean.getId());
        } else {
            formAuthViewBean = ownerformAuthViewBean.getConditonFormAuthViewBean(Long.valueOf(authId));
        }
        formAuthViewBean.setDefaultAuth(ownerformAuthViewBean.isDefaultAuth());
        formAuthViewBean.setFormViewId(ownerformAuthViewBean.getFormViewId());
        formAuthViewBean.setType(ownerformAuthViewBean.getType());
        formAuthViewBean.setName(ownerformAuthViewBean.getName());
        List fieldList = fb.getAllFieldBeans();
        for (FormFieldBean formFieldBean : fieldList) {
            FormAuthViewFieldBean formAuthViewFieldBean = new FormAuthViewFieldBean();
            FormAuthViewFieldBean ownerformAuthViewFieldBean = ownerformAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            if (FormFieldComEnum.FLOWDEALOPITION.getKey().equals(formFieldBean.getInputType())) {
                formAuthViewFieldBean.setAccess(ownerformAuthViewFieldBean.getAccess());
            } else {
                formAuthViewFieldBean.setAccess(authValue.get(formFieldBean.getName() + "_access").toString());
            }
            formAuthViewFieldBean.setFieldName(formFieldBean.getName());
            formAuthViewFieldBean.setFormFieldBean(formFieldBean);
            int isNull = 0;
            Object isNotNull = authValue.get(formFieldBean.getName() + "_notNull");
            isNull = StringUtil.checkNull((String)String.valueOf(isNotNull)) ? 0 : Integer.parseInt(String.valueOf(isNotNull));
            formAuthViewFieldBean.setIsNotNull(isNull);
            FormAuthViewFieldBean tempAuthFieldBean = ownerformAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            formAuthViewFieldBean.setDefaultValue(tempAuthFieldBean.getDefaultValue());
            formAuthViewFieldBean.setDefaultValueType(tempAuthFieldBean.getDefaultValueType());
            formAuthViewFieldBean.setShowName(tempAuthFieldBean.getShowName());
            formAuthViewBean.addFormAuthorizationField(formFieldBean.getName(), formAuthViewFieldBean);
        }
        List slaveBean = fb.getSubTableBean();
        for (FormTableBean formTableBean : slaveBean) {
            Object _add = authValue.get(formTableBean.getDisplay() + "_add");
            Object _copy = authValue.get(formTableBean.getDisplay() + "_copy");
            Object _delete = authValue.get(formTableBean.getDisplay() + "_delete");
            Object _deleteAll = authValue.get(formTableBean.getDisplay() + "_deleteAll");
            Object _importData = authValue.get(formTableBean.getDisplay() + "_importData");
            Object _exportData = authValue.get(formTableBean.getDisplay() + "_exportData");
            boolean add = _add != null && "true".equals(_add.toString());
            boolean copy = _copy != null && "true".equals(_copy.toString());
            boolean delete = _delete != null && "true".equals(_delete.toString());
            boolean deleteAll = _deleteAll != null && "true".equals(_deleteAll.toString());
            boolean importData = _importData != null && "true".equals(_importData.toString());
            boolean exportData = _exportData != null && "true".equals(_exportData.toString());
            formAuthViewBean.addFormAuthorizationTable("my:" + formTableBean.getDisplay(), add, copy, delete, deleteAll, importData, exportData);
        }
        formAuthViewBean.setFormConditionActionBean(fb.getFormConditionActionBean(null, conditionFormula, formAuthViewBean.getId() + "", Enums.FormulaConditionType.FORM_AUTHORITY.getKey(), null, 0, Enums.FormulaConditionLogic.IF.getText()));
        newHighAuth.put(formAuthViewBean.getId(), "");
    }

    @Override
    public Map<String, Object> designAuthDefaultValue(FormFieldBean ffb, Long formId) throws BusinessException {
        HashMap<String, Object> returnMap;
        if (ffb.getFormRelation() != null) {
            returnMap = new HashMap<String, Map>(16);
            returnMap.put("disableMap", FormFieldUtil.getDisableMap2AuthDefaultValue((String)"disabled", (String)"disabled", (String)"disabled"));
            returnMap.put("data_handWork", null);
            returnMap.put("data_system", new ArrayList());
        } else {
            FormFieldCtrl ctrl = ffb.getFieldCtrl();
            returnMap = ctrl.getAuthDefaultValueMap(ffb, formId);
        }
        return returnMap;
    }

    @Override
    @AjaxAccess
    public String checkSerialNumberLength(String fieldName, String serialId, Long formId) throws BusinessException {
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
        if (Strings.isDigits((String)serialId)) {
            try {
                FormSerialNumberBean fsb = this.formCacheManager.getSerialNumber(Long.parseLong(serialId));
                if (fsb != null && this.serialNumberManager.getJustDisPlayValue(fsb).length() > Integer.parseInt(ffb.getFieldLength())) {
                    return "SerialNumberLengthTooLarge";
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"\u4f20\u5165\u6570\u5b57\u8d85\u957f\uff0c\u4e0d\u80fd\u8f6c\u578b\u4e3a\u957f\u6574\u5f62\uff0c\u4e0d\u505a\u6d41\u6c34\u53f7\u5224\u65ad", (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public List<FormFieldBean> getFormFieldBean4Import(FormBean fb, List<FormAuthViewBean> authViewBeanList, Enums.FieldAccessType accessType, List<String> comEnums, boolean needSubField) throws BusinessException {
        ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
        FormTableBean tableBean = fb.getMasterTableBean();
        List tableFieldBeans = tableBean.getFields();
        fieldBeans.addAll(this.filterFormFieldBean4Import(fb, comEnums, tableFieldBeans, authViewBeanList, accessType));
        if (needSubField) {
            List beans = fb.getSubTableBean();
            for (FormTableBean formTableBean : beans) {
                tableFieldBeans = formTableBean.getFields();
                fieldBeans.addAll(this.filterFormFieldBean4Import(fb, comEnums, tableFieldBeans, authViewBeanList, accessType));
            }
        }
        return fieldBeans;
    }

    @Override
    public List<FormFieldBean> getFormFieldBean4RepeatImport(FormBean fb, FormAuthViewBean favb, String tableName, List<String> comEnums) throws BusinessException {
        ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
        List beans = fb.getSubTableBean();
        for (FormTableBean formTableBean : beans) {
            if (!tableName.equals(formTableBean.getTableName())) continue;
            List tbfieldBeans = formTableBean.getFields();
            ArrayList<FormFieldBean> expotFields = new ArrayList<FormFieldBean>();
            for (FormFieldBean b : tbfieldBeans) {
                if (!Strings.isEmpty((Collection)b.getFormConditionList())) continue;
                expotFields.add(b);
            }
            ArrayList<FormAuthViewBean> authViewBeanList = new ArrayList<FormAuthViewBean>(1);
            authViewBeanList.add(favb);
            fieldBeans.addAll(this.filterFormFieldBean4Import(fb, comEnums, expotFields, authViewBeanList, null));
            break;
        }
        return fieldBeans;
    }

    private List<FormFieldBean> filterFormFieldBean4Import(FormBean fb, List<String> comEnums, List<FormFieldBean> tableFieldBeans, List<FormAuthViewBean> authViewBeanList, Enums.FieldAccessType accessType) throws BusinessException {
        ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
        for (FormFieldBean fieldBean : tableFieldBeans) {
            String fieldName = fieldBean.getName();
            if (comEnums.contains(fieldBean.getInputType())) continue;
            if (authViewBeanList != null && (accessType == Enums.FieldAccessType.edit || accessType == null || accessType == Enums.FieldAccessType.add)) {
                for (FormAuthViewBean favb : authViewBeanList) {
                    FormAuthViewFieldBean authViewFieldBean = favb.getFormAuthorizationField(fieldName);
                    if (accessType != null && (authViewFieldBean == null || !authViewFieldBean.getAccess().equals(accessType.getKey())) || authViewFieldBean.isSerialNumberDefaultValue()) continue;
                    fieldBeans.add(fieldBean);
                }
                continue;
            }
            if (accessType != Enums.FieldAccessType.browse) continue;
            fieldBeans.add(fieldBean);
        }
        return fieldBeans;
    }

    @Override
    public Map<String, List<String[]>> customSelectDefaultValue(FormFieldComEnum formFieldEnum, Integer externalType) throws BusinessException {
        FormFieldCtrl ctrl = FormFieldUtil.getFormFieldCtrl((String)formFieldEnum.getKey());
        HashMap<String, List<String[]>> returnMap = new HashMap<String, List<String[]>>();
        List selectItems = ctrl.getListShowDefaultVal(externalType);
        ArrayList data_system = new ArrayList();
        if (selectItems != null) {
            data_system.addAll(selectItems);
        }
        returnMap.put("data_system", data_system);
        return returnMap;
    }

    @Override
    public void mergeAuth4Design(FormBean formBean, List<String> deletedTableList, List<String> deletedFormFieldList, Map<String, String> renameTableMap) throws BusinessException {
        for (FormViewBean view : formBean.getFormViewList()) {
            for (FormAuthViewBean favBean : view.getAllOperations()) {
                favBean.removeTableAuth(deletedTableList);
                favBean.removeFormAuthorizationField(deletedFormFieldList);
                favBean.changeTableAuth(renameTableMap);
                favBean.setDefaultAuth(formBean);
            }
        }
    }

    @Override
    @AjaxAccess
    public String checkAuthNameRepeatByForms(Map<String, Object> param) throws BusinessException {
        String[] viewValues;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("success", true);
        Long formId = ParamUtil.getLong(param, (String)"formId");
        String authName = ParamUtil.getString(param, (String)"authName");
        for (String viewId : viewValues = ParamUtil.getString(param, (String)"viewValues").split(";")) {
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("formId", formId);
            p.put("authName", authName);
            p.put("viewId", viewId);
            if (this.checkAuthNameRepeat(p).contains("true")) continue;
            resultMap.put("success", false);
            break;
        }
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    public String checkAuthNameRepeat(Map<String, Object> param) throws BusinessException {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("success", true);
        Long formId = ParamUtil.getLong(param, (String)"formId");
        Long viewId = ParamUtil.getLong(param, (String)"viewId");
        String authName = ParamUtil.getString(param, (String)"authName");
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        FormViewBean formViewBean = formBean.getFormView(viewId.longValue());
        for (FormAuthViewBean formAuthViewBean : formViewBean.getOperations()) {
            if (!formAuthViewBean.getName().equals(authName)) continue;
            resultMap.put("success", false);
            break;
        }
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    public String saveAs(Map<String, Object> param) throws BusinessException {
        ExtendManager extendManager;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Long formId = ParamUtil.getLong(param, (String)"formId");
        Long oldViewId = ParamUtil.getLong(param, (String)"oldViewId");
        Long newViewId = ParamUtil.getLong(param, (String)"viewId");
        Long oldAuthId = ParamUtil.getLong(param, (String)"oldAuthId");
        String authName = ParamUtil.getString(param, (String)"authName");
        String type = ParamUtil.getString(param, (String)"operationType");
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        FormViewBean oldViewBean = formBean.getFormView(oldViewId.longValue());
        FormAuthViewBean oldAuthViewBean = oldViewBean.getAuthorizaton(oldAuthId.longValue());
        FormViewBean formViewBean = formBean.getFormView(newViewId.longValue());
        FormAuthViewBean formAuthViewBean = new FormAuthViewBean();
        formAuthViewBean.setId(Long.valueOf(UUIDLong.longUUID()));
        formAuthViewBean.setFormViewId(newViewId.longValue());
        formAuthViewBean.setName(authName);
        formAuthViewBean.setDefaultAuth(false);
        formAuthViewBean.setType(Strings.isNotBlank((String)type) ? type : oldAuthViewBean.getType());
        formAuthViewBean.setAdvanceAuthType(oldAuthViewBean.getAdvanceAuthType());
        formAuthViewBean.setContainInitNull(oldAuthViewBean.isContainInitNull());
        for (Map.Entry entry : oldAuthViewBean.getFields().entrySet()) {
            FormAuthViewFieldBean oldAuthViewFieldBean = (FormAuthViewFieldBean)entry.getValue();
            FormAuthViewFieldBean formAuthViewFieldBean = new FormAuthViewFieldBean();
            formAuthViewFieldBean.copyBaseProperties(oldAuthViewFieldBean);
            formAuthViewBean.addFormAuthorizationField((String)entry.getKey(), formAuthViewFieldBean);
        }
        for (FormAuthorizationTableBean tableAuth : oldAuthViewBean.getFormAuthorizationTableList()) {
            formAuthViewBean.addFormAuthorizationTable(tableAuth.getTableName(), tableAuth.isAdd(), tableAuth.isCopy(), tableAuth.isDelete(), tableAuth.isDeleteAll(), tableAuth.isImportData(), tableAuth.isExportData());
        }
        for (Map.Entry entry : oldAuthViewBean.getFieldConditionAuths().entrySet()) {
            List subFieldAuthConditionList = (List)entry.getValue();
            ArrayList<FormAuthViewFieldBean> newSubFieldAuthConditionList = new ArrayList<FormAuthViewFieldBean>();
            for (FormAuthViewFieldBean formAuthViewFieldBean : subFieldAuthConditionList) {
                FormAuthViewFieldBean formAuthViewFieldBean2 = new FormAuthViewFieldBean();
                formAuthViewFieldBean2.setId(Long.valueOf(UUIDLong.longUUID()));
                formAuthViewFieldBean2.copyBaseProperties(formAuthViewFieldBean);
                FormConditionActionBean oldConditionBean = formAuthViewFieldBean.getFormConditionActionBean();
                FormConditionActionBean conditionBean = formBean.getFormConditionActionBean(null, oldConditionBean.getConditionFormula(), formAuthViewFieldBean2.getId().toString(), oldConditionBean.getActionType().intValue(), null, oldConditionBean.getSortNumber().intValue(), oldConditionBean.getKeyword(), null, null, oldConditionBean.getForceCheck().intValue());
                formAuthViewFieldBean2.setFormConditionActionBean(conditionBean);
                newSubFieldAuthConditionList.add(formAuthViewFieldBean2);
            }
            formAuthViewBean.addConditionAuthFieldBean((String)entry.getKey(), newSubFieldAuthConditionList);
        }
        if (!oldAuthViewBean.isApartSetAuth()) {
            for (Map.Entry entry : oldAuthViewBean.getAuths().entrySet()) {
                FormAuthViewBean oldHighAuthViewBean = (FormAuthViewBean)entry.getValue();
                FormAuthViewBean highAuthViewBean = new FormAuthViewBean();
                highAuthViewBean.setId(Long.valueOf(UUIDLong.longUUID()));
                highAuthViewBean.setParentId(oldHighAuthViewBean.getParentId());
                highAuthViewBean.setFormViewId(formAuthViewBean.getFormViewId());
                highAuthViewBean.setName(formAuthViewBean.getName());
                highAuthViewBean.setType(oldHighAuthViewBean.getType());
                highAuthViewBean.setContainInitNull(oldHighAuthViewBean.isContainInitNull());
                for (Map.Entry entry2 : oldHighAuthViewBean.getFields().entrySet()) {
                    FormAuthViewFieldBean oldAuthViewFieldBean = (FormAuthViewFieldBean)entry2.getValue();
                    FormAuthViewFieldBean formAuthViewFieldBean = new FormAuthViewFieldBean();
                    formAuthViewFieldBean.copyBaseProperties(oldAuthViewFieldBean);
                    highAuthViewBean.addFormAuthorizationField((String)entry2.getKey(), formAuthViewFieldBean);
                }
                for (FormAuthorizationTableBean formAuthorizationTableBean : oldHighAuthViewBean.getFormAuthorizationTableList()) {
                    highAuthViewBean.addFormAuthorizationTable(formAuthorizationTableBean.getTableName(), formAuthorizationTableBean.isAdd(), formAuthorizationTableBean.isCopy(), formAuthorizationTableBean.isDelete(), formAuthorizationTableBean.isDeleteAll(), formAuthorizationTableBean.isImportData(), formAuthorizationTableBean.isExportData());
                }
                FormConditionActionBean oldConditionBean = oldHighAuthViewBean.getFormConditionActionBean();
                FormConditionActionBean formConditionActionBean = formBean.getFormConditionActionBean(null, oldConditionBean.getConditionFormula(), highAuthViewBean.getId().toString(), oldConditionBean.getActionType().intValue(), null, oldConditionBean.getSortNumber().intValue(), oldConditionBean.getKeyword(), null, null, oldConditionBean.getForceCheck().intValue());
                highAuthViewBean.setFormConditionActionBean(formConditionActionBean);
                formAuthViewBean.addConditonFormAuthViewBean(highAuthViewBean.getId(), highAuthViewBean);
            }
        }
        formViewBean.addAuthorizaton(formAuthViewBean);
        result.put("success", true);
        this.cap4FormManager.saveEditingForm(formBean);
        String outerChecker = AppContext.getSystemProperty((String)"capExtend.bean");
        if (!StringUtil.checkNull((String)outerChecker) && null != (extendManager = (ExtendManager)AppContext.getBean((String)outerChecker))) {
            extendManager.fieldGruopAuthCopy(formId, formAuthViewBean.getId(), oldAuthId);
        }
        return JSONUtil.toJSONString(result);
    }

    @Override
    @AjaxAccess
    public String saveAsByType(Map<String, Object> param) throws BusinessException {
        String saveAsType = ParamUtil.getString(param, (String)"saveAsType");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        Long formId = ParamUtil.getLong(param, (String)"formId");
        Long oldAuthId = ParamUtil.getLong(param, (String)"oldAuthId");
        if ("new".equals(saveAsType)) {
            String[] viewValues = ParamUtil.getString(param, (String)"viewValues").split(";");
            String operationType = ParamUtil.getString(param, (String)"operationType");
            for (String viewId : viewValues) {
                String authName = ParamUtil.getString(param, (String)"authName");
                Long oldViewId = ParamUtil.getLong(param, (String)"oldViewId");
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.put("formId", formId);
                p.put("oldViewId", oldViewId);
                p.put("viewId", viewId);
                p.put("oldAuthId", oldAuthId);
                p.put("authName", authName);
                p.put("operationType", operationType);
                this.saveAs(p);
            }
        } else {
            String[] updateAuthIds;
            for (String updateAuthId : updateAuthIds = ParamUtil.getString(param, (String)"updateAuthIds").split(";")) {
                String ret;
                String[] viewAndAuth = updateAuthId.split("\\.");
                Map<String, Object> sourceAuth = this.getAuthById4Edit(oldAuthId, formId);
                Map<String, Object> targerAuth = this.getAuthById4Edit(Long.valueOf(viewAndAuth[1]), formId);
                sourceAuth.put("viewId", viewAndAuth[0]);
                sourceAuth.put("authId", viewAndAuth[1]);
                sourceAuth.put("defaultAuth", targerAuth.get("defaultAuth"));
                sourceAuth.put("formId", formId);
                sourceAuth.put("authTitle", targerAuth.get("authTitle"));
                sourceAuth.put("authTypeValue", targerAuth.get("authTypeValue"));
                String sourceHighAuths = sourceAuth.get("highAuths").toString();
                if (Strings.isNotEmpty((String)sourceHighAuths)) {
                    Object sourceObj = JSONUtil.parseJSONString((String)sourceHighAuths);
                    if (sourceObj instanceof Map) {
                        ((Map)sourceObj).put("authId", "0");
                        ((Map)sourceObj).put("conditionId", "0");
                    } else if (sourceObj instanceof List) {
                        List array = (List)sourceObj;
                        for (int i = 0; i < array.size(); ++i) {
                            Map map = (Map)array.get(i);
                            map.put("authId", "0");
                            map.put("conditionId", "0");
                        }
                    }
                    sourceAuth.put("highAuths", sourceObj);
                }
                if ((ret = this.saveOrUpdateAuth(sourceAuth)).length() == 0) continue;
                throw new BusinessException(ret);
            }
        }
        return JSONUtil.toJSONString(result);
    }

    @Override
    @AjaxAccess
    public FlipInfo authListPageing(FlipInfo fi, Map<String, Object> params) {
        String initOperationType = String.valueOf(params.get("initOperationType"));
        Long formId = Long.parseLong((String)params.get("formId"));
        String operationType = String.valueOf(params.get("operationType"));
        String formView = String.valueOf(params.get("formView"));
        FormBean formBean = this.cap4FormManager.getEditingForm(formId);
        ArrayList<AuthListVo> list = new ArrayList<AuthListVo>();
        for (FormViewBean viewBean : formBean.getFormViewList()) {
            if (Strings.isNotBlank((String)formView) && viewBean.getId() != Long.parseLong(formView)) continue;
            String viewShowName = Enums.ViewType.SeeyonForm.getText().equals(viewBean.getFormViewType()) ? ResourceUtil.getString((String)"form.view.type.pc.label") + "." + viewBean.getFormViewName() : ResourceUtil.getString((String)"form.view.type.phone.label") + "." + viewBean.getFormViewName();
            for (FormAuthViewBean auth : viewBean.getAllOperations()) {
                if (auth.isDelete() || Strings.isNotBlank((String)operationType) && !auth.getType().equals(operationType) || (initOperationType.equals(Enums.FormAuthorizationType.add.getKey()) || initOperationType.equals(Enums.FormAuthorizationType.update.getKey())) && auth.getType().equals(Enums.FormAuthorizationType.show.getKey())) continue;
                AuthListVo showVo = new AuthListVo();
                showVo.setAuthId(viewBean.getId() + "." + auth.getId());
                showVo.setAuthName(auth.getName());
                showVo.setViewName(viewShowName);
                showVo.setAuthType(Enums.FormAuthorizationType.getEnumByKey((String)auth.getType()).getI18nStr());
                list.add(showVo);
            }
        }
        fi.setData(list);
        return fi;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

