/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formBase;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunctionUitl;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormDefinitionDAOImpl
implements CAP4FormDefinitionDAO {
    private static final Log logger = CtpLogFactory.getLog(CAP4FormDefinitionDAOImpl.class);

    @Override
    public List<CAPFormDefinition> selectAll() throws BusinessException {
        return DBAgent.loadAll(CAPFormDefinition.class);
    }

    @Override
    public CAPFormDefinition selectById(long id) throws BusinessException {
        return (CAPFormDefinition)DBAgent.get(CAPFormDefinition.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public void update(CAPFormDefinition formDefinition) throws BusinessException {
        DBAgent.merge((Object)formDefinition);
    }

    @Override
    public List<Long> insert(List<CAPFormDefinition> formDefinitionList) throws BusinessException {
        DBAgent.saveAll(formDefinitionList);
        return new ArrayList<Long>();
    }

    @Override
    public long insert(CAPFormDefinition formDefinition) throws BusinessException {
        ArrayList<CAPFormDefinition> fList = new ArrayList<CAPFormDefinition>();
        fList.add(formDefinition);
        this.insert(fList);
        return 1L;
    }

    @Override
    public void delete(List<CAPFormDefinition> formDefinitionList) throws BusinessException {
        DBAgent.deleteAll(formDefinitionList);
    }

    @Override
    public void delete(CAPFormDefinition formDefinition) throws BusinessException {
        ArrayList<CAPFormDefinition> formDefinitionList = new ArrayList<CAPFormDefinition>();
        formDefinitionList.add(formDefinition);
        this.delete(formDefinitionList);
    }

    @Override
    public List<Map<String, Object>> selectByFlipInfo(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        String sql = "select new map(fd.id as id,fd.name as name,fd.formType as formType,fo.ownerId as ownerId,fd.categoryId as categoryId,fd.useFlag as useFlag,fd.state as state,fd.createTime as createTime,fd.modifyTime as modifyTime,fo.orgAccountId as orgAccountId,fd.sourceType as sourceType ) from CAPFormDefinition fd , FormOwner fo where fd.id=fo.formId and fd.state in(" + Enums.FormStateEnum.draft.getKey() + "," + Enums.FormStateEnum.official.getKey() + ") ";
        HashMap<String, Object> p = new HashMap<String, Object>();
        if (params != null) {
            for (String key : params.keySet()) {
                String[] s;
                ArrayList<Integer> valueList;
                String tempValue;
                int count = key.indexOf(".");
                String pKey = key;
                Object pValue = params.get(key);
                if (count > -1) {
                    pKey = pKey.substring(count + 1, pKey.length());
                }
                if (key.toLowerCase().contains("name")) {
                    key = "fd.name";
                    sql = sql + " and " + key + " like :" + pKey + " ";
                    if (pValue == null) {
                        pValue = "";
                    }
                    pValue = "%" + pValue.toString() + "%";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("otherownerid")) {
                    key = "fo.ownerId";
                    pKey = "ownerId";
                    sql = sql + " and " + key + " not in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("categoryid")) {
                    key = "fd.categoryId";
                    sql = sql + " and " + key + " = :" + pKey + " ";
                    pValue = Long.parseLong(pValue + "");
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("ownerid")) {
                    key = "fo.ownerId";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("formtype")) {
                    key = "fd.formType";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    tempValue = "" + pValue;
                    valueList = new ArrayList<Integer>();
                    if (tempValue.contains(",")) {
                        for (String t : s = tempValue.split(",")) {
                            valueList.add(Integer.parseInt(t));
                        }
                    } else {
                        valueList.add(Integer.parseInt(tempValue));
                    }
                    p.put(pKey, valueList);
                    continue;
                }
                if (key.toLowerCase().contains("formid")) {
                    key = "fd.id";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if ("state".equalsIgnoreCase(key)) {
                    key = "fd.state";
                    sql = sql + " and " + key + " = :" + pKey + " ";
                    p.put(pKey, Integer.parseInt(pValue + ""));
                    continue;
                }
                if (key.toLowerCase().contains("useflag")) {
                    key = "fd.useFlag";
                    sql = sql + " and " + key + " in(:" + pKey + ") ";
                    tempValue = "" + pValue;
                    valueList = new ArrayList();
                    if (tempValue.contains(",")) {
                        for (String t : s = tempValue.split(",")) {
                            valueList.add(Integer.parseInt(t));
                        }
                    } else {
                        valueList.add(Integer.parseInt(tempValue));
                    }
                    p.put(pKey, valueList);
                    continue;
                }
                if (key.toLowerCase().contains("orgaccountid")) {
                    key = "fo.orgAccountId";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if ("stateList".equalsIgnoreCase(key)) {
                    key = "fd.state";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                sql = sql + " and " + key + " = :" + pKey + " ";
                p.put(pKey, pValue);
            }
        }
        sql = sql + " order by fd.modifyTime desc,fd.id ";
        return DBAgent.findByValueBean((String)sql, p, (FlipInfo)fi);
    }

    @Override
    public List<Map<String, Object>> selectByFilpInfo4Flow(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        String hsql = "select new map(fd.id as id,fd.name as name,fd.formType as formType,bizconfig.name as bindType) from CAPFormDefinition fd,CapBizConfig bizconfig,CapBizConfigItem bizconfigitem where bizconfig.ownerId=:ownerId and fd.formType=:formType and fd.useFlag=:useFlag and fd.id=bizconfigitem.formId and bizconfigitem.bizId=bizconfig.id ";
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("ownerId", AppContext.currentUserId());
        p.put("formType", 6);
        p.put("useFlag", 1);
        if (null != params && params.containsKey("name")) {
            hsql = hsql + "and fd.name like :fname ";
            p.put("fname", "%" + SQLWildcardUtil.escape((String)String.valueOf(params.get("name"))) + "%");
        }
        return DBAgent.findByValueBean((String)hsql, p, (FlipInfo)fi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> findPrepareForm() throws BusinessException {
        StringBuilder sql = new StringBuilder("select id,name,prepare_flag from cap_form_definition  where use_flag=2");
        JDBCAgent jdbc = new JDBCAgent();
        List resultList = null;
        try {
            jdbc.execute(sql.toString());
            resultList = jdbc.resultSetToList();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return resultList;
    }

    @Override
    public List<CAPFormDefinition> selectByName(String name, long accountId) throws BusinessException {
        String sql = "select fd from CAPFormDefinition fd,FormOwner fo where fd.id = fo.formId and fd.name=:name and fo.orgAccountId=:orgAccountId and fd.useFlag in(0,1,3)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", name);
        param.put("orgAccountId", accountId);
        return DBAgent.findByValueBean((String)sql, param);
    }

    @Override
    public List<CtpTemplate> selectTemplate4Forms(Map<String, Object> params, List<FormBean> fbList, Long notInTemplateId) throws BusinessException {
        Collection ids;
        ArrayList<CtpTemplate> cList = new ArrayList<CtpTemplate>();
        if (fbList == null || fbList.size() == 0) {
            return cList;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String hql = "select new map(t as o,a.contentTemplateId as formId) from CtpTemplate t,CtpContentAll a where  t.body=a.id and t.delete=:delete";
        if (notInTemplateId != null) {
            hql = hql + " and t.id != :notInTemplateId";
            map.put("notInTemplateId", notInTemplateId);
        }
        if (params.containsKey("templateName")) {
            hql = hql + " and t.subject like :templateName";
            map.put("templateName", "%" + params.get("templateName") + "%");
        }
        if (params.containsKey("category")) {
            hql = hql + " and t.categoryId = :category";
            map.put("category", Long.parseLong(params.get("category") + ""));
        }
        if (params.containsKey("modifyTime")) {
            Date date1;
            List date = (List)params.get("modifyTime");
            hql = hql + " and t.modifyDate between :beginTime";
            try {
                date1 = DateUtil.parse((String)(StringUtil.checkNull((String)(date.get(0) + "")) ? FormulaFunctionUitl.DEFAULT_DATE : date.get(0) + ""), (String)"yyyy-MM-dd");
                map.put("beginTime", Datetimes.getTodayFirstTime((Date)date1));
            }
            catch (ParseException e) {
                throw new BusinessException((Throwable)e);
            }
            hql = hql + " and :endTime";
            try {
                date1 = DateUtil.parse((String)(StringUtil.checkNull((String)(date.get(1) + "")) ? DateUtil.getDateAndTime() : date.get(1) + ""), (String)"yyyy-MM-dd");
                map.put("endTime", Datetimes.getTodayLastTime((Date)date1));
            }
            catch (ParseException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        ArrayList<Long> formIds = new ArrayList<Long>();
        for (FormBean f : fbList) {
            if (params.containsKey("formname") && !f.getFormName().contains((String)params.get("formname"))) continue;
            formIds.add(f.getId());
        }
        if (formIds.size() == 0) {
            formIds.add(-1L);
        }
        if ((ids = FormUtil.splitCollection(formIds, (int)800)).size() == 1) {
            hql = hql + " and a.contentTemplateId in (:contentTemplateId) ";
            map.put("contentTemplateId", formIds);
        } else {
            hql = hql + " and (";
            Iterator it = ids.iterator();
            int i = 0;
            while (it.hasNext()) {
                hql = hql + "a.contentTemplateId in (:contentTemplateId" + i + ") or ";
                map.put("contentTemplateId" + i, it.next());
                ++i;
            }
            hql = hql + "a.contentTemplateId = 1)";
        }
        map.put("delete", false);
        hql = hql + " order by t.modifyDate desc";
        List o = DBAgent.find((String)hql, map);
        for (Map m : o) {
            CtpTemplate c = (CtpTemplate)m.get("o");
            c.putExtraAttr("formId", (Object)((Long)m.get("formId")));
            cList.add(c);
        }
        return cList;
    }

    @Override
    public List<CAPFormDefinition> selectByCategoryId(long categoryId) throws BusinessException {
        String sql = "select fd from CAPFormDefinition fd where fd.categoryId=:categoryId and deleteFlag=0";
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("categoryId", categoryId);
        return DBAgent.findByValueBean((String)sql, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initUpgradeMap(Map<String, Object> upgradeMap) throws SQLException, BusinessException {
        String sql = "select FORM_ID,OLDID,NEWID,TYPE_FLAG from FORM_UPGRADE_MAPPING";
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.execute(sql);
            List dataList = jdbc.resultSetToList();
            for (int i = 0; i < dataList.size(); ++i) {
                Map rowData = (Map)dataList.get(i);
                String key = String.valueOf(rowData.get("form_id")) + "-" + String.valueOf(rowData.get("oldid"));
                Long value = Long.parseLong(String.valueOf(rowData.get("newid")));
                upgradeMap.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
    }

    @Override
    public void updateFormUserFlag(int state, List<Long> ids, int oldState) throws BusinessException {
        String sql = "update CAPFormDefinition set useFlag =:state where id in (:ids) and useFlag =:oldState";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", state);
        map.put("ids", ids);
        map.put("oldState", oldState);
        DBAgent.bulkUpdate((String)sql, map);
    }

    @Override
    public void updateFormUserFlag() throws BusinessException {
        String sql = "update CAPFormDefinition set useFlag = 1 where useFlag = 3";
        DBAgent.bulkUpdate((String)sql, (Object[])new Object[0]);
        sql = "update CAPFormDefinition set useFlag = 0 where useFlag = 4";
        DBAgent.bulkUpdate((String)sql, (Object[])new Object[0]);
    }

    @Override
    public int selectFormsCount(List<Long> ids) throws BusinessException {
        String sql = "select count(id) from CAPFormDefinition where id in (:ids)";
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", ids);
        List list = DBAgent.find((String)sql, map);
        return Strings.isEmpty((Collection)list) ? 0 : ((Long)list.get(0)).intValue();
    }

    @Override
    public void updateFormModifyTime(Long formId, Date modifyTime) throws BusinessException {
        String hql = "update CAPFormDefinition set modifyTime =:modifyTime where id =:formId";
        HashMap<String, Comparable<Date>> param = new HashMap<String, Comparable<Date>>();
        param.put("modifyTime", modifyTime);
        param.put("formId", formId);
        DBAgent.bulkUpdate((String)hql, param);
    }

    @Override
    public void updateFormCategoryId(Long formId, Long categoryId, Date modifyTime) throws BusinessException {
        String hql = "update CAPFormDefinition set categoryId =:categoryId, modifyTime =:modifyTime where id =:formId";
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>();
        param.put("categoryId", categoryId);
        param.put("modifyTime", modifyTime);
        param.put("formId", formId);
        DBAgent.bulkUpdate((String)hql, param);
    }

    @Override
    public List<CAPFormDefinition> selectFormsByCategoryId(long categoryId) throws BusinessException {
        String sql = "select fd from CAPFormDefinition fd where fd.categoryId=:categoryId and fd.deleteFlag=0 and fd.useFlag=" + Enums.FormUseFlagEnum.enabled.getKey() + " and fd.state =" + Enums.FormStateEnum.official.getKey();
        HashMap p = new HashMap();
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("categoryId", categoryId);
        sql = sql + " order by fd.name, fd.formType ";
        return DBAgent.findByValueBean((String)sql, param);
    }

    @Override
    public List<Map<String, Object>> showFormListByOwner(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        String sql = "select new map(fd.id as id,fd.name as formName,fd.formType as formType,ctc.name as cataName,fd.categoryId as categoryId,fd.useFlag as useFlag,fd.state as state,fd.createTime as createTime,fd.modifyTime as modifyTime ,fd.publishFlag as publishFlag ,fo.orgAccountId as orgAccountId,fo.id as ownerId) from CAPFormDefinition fd , CtpTemplateCategory ctc ,FormOwner fo where fd.categoryId=ctc.id and fd.id = fo.formId and fd.state in(" + Enums.FormStateEnum.draft.getKey() + "," + Enums.FormStateEnum.official.getKey() + ")  and ctc.type != " + ModuleType.cap4Form.getKey() + " and fd.formType=" + Enums.FormType.processesForm.getKey() + " and fd.id not in (select ccf.formId from CapBizConfigItem ccf ) ";
        HashMap<String, Object> p = new HashMap<String, Object>();
        if (params != null) {
            for (String key : params.keySet()) {
                int count = key.indexOf(".");
                String pKey = key;
                Object pValue = params.get(key);
                if (count > -1) {
                    pKey = pKey.substring(count + 1, pKey.length());
                }
                if (!key.toLowerCase().contains("ownerid")) continue;
                key = "fo.ownerId";
                sql = sql + " and " + key + " in (:" + pKey + ") ";
                p.put(pKey, pValue);
            }
        }
        sql = sql + " order by fd.modifyTime desc,fd.name ";
        return DBAgent.findByValueBean((String)sql, p, (FlipInfo)fi);
    }

    @Override
    public List<Map<String, Object>> showFormList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        String sql = "select new map(fd.id as id,fd.name as formName,fd.formType as formType,ctc.name as cataName,fd.categoryId as categoryId,fd.useFlag as useFlag,fd.state as state,fd.createTime as createTime,fd.modifyTime as modifyTime ,fd.publishFlag as publishFlag ,fo.orgAccountId as orgAccountId,fo.ownerId as ownerId) from CAPFormDefinition fd , CtpTemplateCategory ctc ,FormOwner fo where fd.categoryId=ctc.id and fd.id = fo.formId and fd.state in(" + Enums.FormStateEnum.draft.getKey() + "," + Enums.FormStateEnum.official.getKey() + ")  and ctc.type != " + ModuleType.cap4Form.getKey() + " and fd.formType=" + Enums.FormType.processesForm.getKey() + " and fd.id not in (select ccf.formId from CapBizConfigItem ccf ) ";
        HashMap<String, Object> p = new HashMap<String, Object>();
        if (params != null) {
            for (String key : params.keySet()) {
                String[] s;
                ArrayList<Integer> valueList;
                String tempValue;
                int count = key.indexOf(".");
                String pKey = key;
                Object pValue = params.get(key);
                if (count > -1) {
                    pKey = pKey.substring(count + 1, pKey.length());
                }
                if (key.toLowerCase().contains("name")) {
                    key = "fd.name";
                    sql = sql + " and " + key + " like :" + pKey + " ";
                    if (pValue == null) {
                        pValue = "";
                    }
                    pValue = "%" + pValue.toString() + "%";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("otherownerid")) {
                    key = "fo.ownerId";
                    pKey = "ownerId";
                    sql = sql + " and " + key + " not in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("categoryid")) {
                    key = "fd.categoryId";
                    sql = sql + " and " + key + " = :" + pKey + " ";
                    pValue = Long.parseLong(pValue + "");
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("ownerid")) {
                    if (AppContext.isAdministrator()) continue;
                    key = "fo.ownerId";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("formtype")) {
                    key = "fd.formType";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    tempValue = "" + pValue;
                    valueList = new ArrayList<Integer>();
                    if (tempValue.contains(",")) {
                        for (String t : s = tempValue.split(",")) {
                            valueList.add(Integer.parseInt(t));
                        }
                    } else {
                        valueList.add(Integer.parseInt(tempValue));
                    }
                    p.put(pKey, valueList);
                    continue;
                }
                if (key.toLowerCase().contains("formid")) {
                    key = "fd.id";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if ("state".equalsIgnoreCase(key)) {
                    key = "fd.state";
                    sql = sql + " and " + key + " in(:" + pKey + ") ";
                    ArrayList<Integer> valueList2 = new ArrayList<Integer>();
                    String tempValue2 = "" + pValue;
                    if (tempValue2.contains(",")) {
                        for (String t : s = tempValue2.split(",")) {
                            valueList2.add(Integer.parseInt(t));
                        }
                    } else {
                        valueList2.add(Integer.parseInt(tempValue2));
                    }
                    p.put(pKey, valueList2);
                    continue;
                }
                if (key.toLowerCase().contains("useflag")) {
                    key = "fd.useFlag";
                    sql = sql + " and " + key + " in(:" + pKey + ") ";
                    tempValue = "" + pValue;
                    valueList = new ArrayList();
                    if (tempValue.contains(",")) {
                        for (String t : s = tempValue.split(",")) {
                            valueList.add(Integer.parseInt(t));
                        }
                    } else {
                        valueList.add(Integer.parseInt(tempValue));
                    }
                    p.put(pKey, valueList);
                    continue;
                }
                if (key.toLowerCase().contains("publishflag")) {
                    key = " fd.publishFlag ";
                    sql = sql + " and " + key + " = :" + pKey + " ";
                    p.put(pKey, pValue);
                    continue;
                }
                if (key.toLowerCase().contains("orgaccountid")) {
                    key = "fo.orgAccountId";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                if ("stateList".equalsIgnoreCase(key)) {
                    key = "fd.state";
                    sql = sql + " and " + key + " in (:" + pKey + ") ";
                    p.put(pKey, pValue);
                    continue;
                }
                sql = sql + " and " + key + " = :" + pKey + " ";
                p.put(pKey, pValue);
            }
        }
        sql = sql + " order by fd.modifyTime desc,fd.name ";
        return DBAgent.findByValueBean((String)sql, p, (FlipInfo)fi);
    }

    @Override
    public List<CAPFormDefinition> queryBizForms(long categoryId, Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        String sql = "select fd from CAPFormDefinition fd ,CapBizConfigItem f  where fd.id=f.formId  and f.bizId=:categoryId and fd.deleteFlag=0";
        queryParams.put("categoryId", categoryId);
        if (params != null && params.containsKey("name")) {
            sql = sql + " and fd.name like :name ";
            queryParams.put("name", "%" + params.get("name") + "%");
        }
        sql = sql + " order by fd.createTime desc ";
        return DBAgent.findByValueBean((String)sql, queryParams);
    }

    @Override
    public FlipInfo findFormForDataset(FlipInfo fi, Map<String, Object> paramMap) {
        StringBuilder hql = new StringBuilder();
        HashMap<String, Object> namedParameterMap = new HashMap<String, Object>();
        hql.append(" select c4 from CAPFormDefinition c4 where 1=1 ");
        if (paramMap.containsKey("name")) {
            String formName = (String)paramMap.get("name");
            hql.append(" and c4.name like :name");
            namedParameterMap.put("name", "%" + SQLWildcardUtil.escape((String)formName) + "%");
        }
        if (paramMap.get("inParameter") != null) {
            List inParameter = (List)paramMap.get("inParameter");
            Collection ids = FormUtil.splitCollection((Collection)inParameter, (int)800);
            if (ids.size() == 1) {
                hql.append(" and c4.id in (:formIds) ");
                namedParameterMap.put("formIds", inParameter);
            } else {
                hql.append(" and (");
                int i = 0;
                for (Collection col : ids) {
                    if (i > 0) {
                        hql.append(" or ");
                    }
                    hql.append(" c4.id in (:formIds" + i + ") ");
                    namedParameterMap.put("formIds" + i, col);
                    ++i;
                }
                hql.append(" )");
            }
        } else {
            return fi;
        }
        hql.append(" and exists (select fw from FormOwner fw where fw.formId= c4.id and fw.ownerId = :ownerId  and fw.orgAccountId =:orgAccountId ) ");
        hql.append(" order by c4.createTime desc,c4.modifyTime desc ");
        namedParameterMap.put("ownerId", AppContext.currentUserId());
        namedParameterMap.put("orgAccountId", AppContext.currentAccountId());
        DBAgent.find((String)hql.toString(), namedParameterMap, (FlipInfo)fi);
        return fi;
    }
}

