/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formData;

import com.seeyon.cap4.cache.TrackTableListener_CAP4Dynamic;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTableIndexBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.util.CapUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.hibernate.dialect.Dialect;

public class CAP4FormDataDAOImpl
implements CAP4FormDataDAO {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormDataDAOImpl.class);
    String getSqlreg = "(" + Enums.TableType.MASTER.getTableSufName() + "_\\d{4,}.field\\d{4,})|(" + Enums.TableType.SLAVE.getTableSufName() + "_\\d{4,}.field\\d{4,})|(field\\d{4,})";
    Pattern getSqlregPattern = Pattern.compile(this.getSqlreg);
    String selectDatareg = "(" + Enums.TableType.MASTER.getTableSufName() + "_\\d{4,}.field\\d{4,})|(" + Enums.TableType.SLAVE.getTableSufName() + "_\\d{4,}.field\\d{4,})|(field\\d{4,})";
    Pattern selectDataPattern = Pattern.compile(this.selectDatareg);

    @Override
    public int insertOrUpdateMasterData(FormDataMasterBean masterBean) throws BusinessException, SQLException {
        if (masterBean == null || masterBean.getId() == 0L) {
            return -1;
        }
        FormTableBean table = masterBean.getFormTable();
        if (table == null || table.getTableName() == null || "".equals(table.getTableName())) {
            throw new BusinessException();
        }
        CAPFormDataLogUtil.recordTrace(masterBean, "\u4fdd\u5b58DAO\u5165\u5e93\u524d");
        Long formDataId = masterBean.getId();
        Long tempNewId = UUIDLong.longUUID();
        masterBean.setId(tempNewId);
        int count = 0;
        try {
            count = this.insertData((FormDataBean)masterBean);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            masterBean.setId(formDataId);
        }
        this.delete(formDataId, Enums.MasterTableField.id.getKey(), table.getTableName());
        this.updateData(tempNewId, table.getTableName(), "id", formDataId);
        LOGGER.info((Object)("\u63d2\u5165\u6570\u636e\uff0cid\uff1a" + masterBean.getId() + ";table:" + table.getTableName()));
        if (masterBean.getSubTables() != null && masterBean.getSubTables().size() > 0) {
            Map subTables = masterBean.getSubTables();
            ArrayList tableNames = new ArrayList(subTables.keySet());
            Collections.sort(tableNames);
            for (String tableName : tableNames) {
                List subData = (List)subTables.get(tableName);
                LOGGER.info((Object)("\u51c6\u5907\u5220\u9664\u660e\u7ec6\u8868\u6570\u636e\uff1a" + tableName));
                this.delete(masterBean.getId(), Enums.SubTableField.formmain_id.getKey(), tableName);
                LOGGER.info((Object)("\u6210\u529f\u5220\u9664\u660e\u7ec6\u8868\u6570\u636e\uff1a" + tableName));
                LOGGER.info((Object)("\u51c6\u5907\u63d2\u5165\u660e\u7ec6\u8868\u6570\u636e\uff1a" + tableName));
                int ccount = this.insertData(subData);
                LOGGER.info((Object)("[" + tableName + "]\u63d2\u5165" + ccount + "\u884c\u91cd\u590d\u8868\u6570\u636e\u3002"));
            }
        }
        return count;
    }

    @Override
    public int insertData(FormDataBean dataBean) throws BusinessException, SQLException {
        ArrayList<FormDataBean> list = new ArrayList<FormDataBean>();
        list.add(dataBean);
        return this.insertData(list);
    }

    @Override
    public int insertData(List<? extends FormDataBean> formDataBeanList) throws BusinessException, SQLException {
        return this.insertData(formDataBeanList, false);
    }

    @Override
    public int insertData(List<? extends FormDataBean> formDataBeanList, boolean updateSort) throws BusinessException, SQLException {
        if (formDataBeanList == null || formDataBeanList.size() == 0) {
            return -1;
        }
        FormTableBean table = formDataBeanList.get(0).getFormTable();
        if (table == null || table.getTableName() == null) {
            throw new BusinessException();
        }
        String tableName = table.getTableName();
        int maxSort = 0;
        if (updateSort) {
            maxSort = this.selectMaxSort(tableName, Long.parseLong(formDataBeanList.get(0).getFieldValue("formmain_id").toString()));
        }
        List<Map<String, Object>> dataList = this.changeDataBean2DataMap(formDataBeanList, table, updateSort, maxSort);
        return this.insertIntoTable(table, dataList);
    }

    private List<Map<String, Object>> changeDataBean2DataMap(List<? extends FormDataBean> formDataBeanList, FormTableBean table, boolean updateSort, int maxSort) throws BusinessException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < formDataBeanList.size(); ++i) {
            FormDataBean dataBean = formDataBeanList.get(i);
            if (dataBean.getId() == 0L) {
                throw new BusinessException();
            }
            if (table.getTableName().contains("formson")) {
                dataBean.addFieldValue(Enums.SubTableField.formmain_id.getKey(), dataBean.removeFieldValue(Enums.SubTableField.formmain_id.getKey()));
                int sort = i + 1;
                if (updateSort) {
                    sort = ++maxSort;
                }
                dataBean.removeFieldValue(Enums.SubTableField.sort.getKey());
                dataBean.addFieldValue(Enums.SubTableField.sort.getKey(), (Object)sort);
            }
            if (ReportDBUtils.isOracleRuntime()) {
                Map valueMap = dataBean.getRowData();
                LinkedHashMap sortedMap = new LinkedHashMap();
                Set keys = valueMap.keySet();
                ArrayList<String> kList = new ArrayList<String>();
                for (String key : keys) {
                    FormFieldBean field = table.getFieldBeanByName(key);
                    if (field != null) {
                        String fieldType = field.getFieldType();
                        if (null != fieldType && fieldType.equals(Enums.FieldType.LONGTEXT.getKey())) continue;
                        sortedMap.put(key, valueMap.get(key));
                        kList.add(key);
                        continue;
                    }
                    sortedMap.put(key, valueMap.get(key));
                    kList.add(key);
                }
                for (String key : kList) {
                    valueMap.remove(key);
                }
                sortedMap.putAll(valueMap);
                dataList.add(sortedMap);
                continue;
            }
            dataList.add(dataBean.getRowData());
        }
        return dataList;
    }

    @Override
    public int insertData(String tableName, List<Map<String, Object>> formDataList, boolean updateSort) throws BusinessException, SQLException {
        if (formDataList == null || formDataList.size() == 0) {
            return -1;
        }
        if (Strings.isBlank((String)tableName)) {
            throw new BusinessException();
        }
        int maxSort = 0;
        if (updateSort) {
            maxSort = this.selectMaxSort(tableName, Long.parseLong(formDataList.get(0).get("formmain_id").toString()));
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < formDataList.size(); ++i) {
            Map<String, Object> formData = formDataList.get(i);
            if (Long.valueOf(formData.get("id").toString()) == 0L) {
                throw new BusinessException();
            }
            if (tableName.contains("formson")) {
                formData.put(Enums.SubTableField.formmain_id.getKey(), formData.get(Enums.SubTableField.formmain_id.getKey()));
                int sort = i + 1;
                if (updateSort) {
                    sort = ++maxSort;
                }
                formData.put(Enums.SubTableField.sort.getKey(), sort);
            }
            dataList.add(formData);
        }
        return this.insertIntoTable(tableName, dataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectMaxSort(String tableName, Long masterId) throws BusinessException, SQLException {
        String sql = "SELECT MAX(SORT) as sort FROM " + tableName + " WHERE formmain_id = ?";
        JDBCAgent jdbc = null;
        Map m = null;
        try {
            jdbc = new JDBCAgent();
            ArrayList<Long> param = new ArrayList<Long>();
            param.add(masterId);
            jdbc.execute(sql, param);
            m = jdbc.resultSetToMap();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        if (m == null) {
            return 0;
        }
        return m.get("sort") == null ? 0 : Integer.parseInt(String.valueOf(m.get("sort")));
    }

    @Override
    public boolean deleteForm(Long masterId, FormBean formBean) throws BusinessException, SQLException {
        int count = 0;
        List tableList = formBean.getTableList();
        for (int i = 0; i < tableList.size(); ++i) {
            FormTableBean tableBean = (FormTableBean)tableList.get(i);
            count = tableBean.getTableType().equals(Enums.TableType.MASTER.getKey()) ? this.delete(masterId, Enums.SubTableField.id.getKey(), tableBean.getTableName()) : this.delete(masterId, Enums.SubTableField.formmain_id.getKey(), tableBean.getTableName());
        }
        LOGGER.info((Object)("deleteForm \u5220\u9664\u8868\u5355\u6570\u636e form " + formBean.getFormName() + " " + formBean.getId() + " masterId " + masterId + " , count " + count));
        return count > 0;
    }

    @Override
    public int delete(Long dataId, String fieldName, String tableName) throws BusinessException, SQLException {
        return this.delete(new Long[]{dataId}, fieldName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Long[] dataId, String fieldName, String tableName) throws BusinessException {
        if (dataId == null || dataId.length == 0) {
            return 0;
        }
        int count = 0;
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Delete, (String[])new String[]{tableName});
            String sql = "delete from " + tableName + " where " + fieldName + " = ?";
            jdbc.batch1Prepare(sql);
            ArrayList<Long> dataList = null;
            for (Long id : dataId) {
                if (null == id) continue;
                dataList = new ArrayList<Long>(1);
                dataList.add(id);
                jdbc.batch2Add(dataList);
            }
            count = jdbc.batch3Execute();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return count;
    }

    @Override
    public FormDataMasterBean selectDataByMasterId(Long masterId, FormBean formBean, String[] fields) throws BusinessException, SQLException {
        FormDataMasterBean formDataMasterBean = this.selectMasterDataById(masterId, formBean.getMasterTableBean(), fields);
        if (formDataMasterBean == null) {
            return null;
        }
        List tableList = formBean.getSubTableBean();
        for (int i = 0; i < tableList.size(); ++i) {
            FormTableBean tableBean = (FormTableBean)tableList.get(i);
            List<FormDataSubBean> subList = this.selectSubDataByMasterId(formDataMasterBean, tableBean);
            if (Strings.isEmpty(subList)) {
                HashMap rowData = new HashMap();
                FormDataSubBean formDataSubBean = new FormDataSubBean(rowData, tableBean, formDataMasterBean, new boolean[]{true});
                if (subList == null) {
                    subList = new ArrayList<FormDataSubBean>();
                }
                subList.add(formDataSubBean);
            }
            formDataMasterBean.setSubData(tableBean.getTableName(), subList);
        }
        return formDataMasterBean;
    }

    @Override
    public FormDataMasterBean selectMasterDataById(Long id, FormTableBean tableBean, String[] fields) throws BusinessException, SQLException {
        List<FormDataMasterBean> list = this.selectMasterDataById(new Long[]{id}, tableBean, fields);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<FormDataMasterBean> selectMasterDataById(Long[] id, FormTableBean tableBean, String[] fields) throws BusinessException, SQLException {
        return this.selectMasterDataById(id, tableBean, fields, true);
    }

    @Override
    public List<FormDataMasterBean> selectMasterDataById(Long[] id, FormTableBean tableBean, String[] fields, boolean orderBySort) throws BusinessException, SQLException {
        ArrayList<FormDataMasterBean> list = new ArrayList<FormDataMasterBean>();
        String fieldNames = fields == null || fields.length == 0 ? "*" : StringUtils.arrayToString((String[])Enums.MasterTableField.getKeys()) + "," + StringUtils.arrayToString((String[])fields);
        List<Map<String, Object>> dataList = this.selectById(id, Enums.SubTableField.id.getKey(), tableBean, fieldNames, orderBySort);
        if (dataList == null) {
            return list;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> rowData = dataList.get(i);
            FormDataMasterBean formDataMasterBean = new FormDataMasterBean(rowData, tableBean, new boolean[0]);
            list.add(formDataMasterBean);
        }
        return list;
    }

    @Override
    public List<FormDataMasterBean> selectMasterDataById(Long[] ids, FormBean formBean, String[] fields) throws BusinessException, SQLException {
        ArrayList<FormDataMasterBean> list = new ArrayList<FormDataMasterBean>();
        Long[] longArray = ids;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long id = longArray[i];
            FormDataMasterBean masterBean = this.selectDataByMasterId(id, formBean, fields);
            if (masterBean == null) continue;
            list.add(masterBean);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FormDataMasterBean> selectMasterDataList(FlipInfo flipInfo, FormTableBean tableBean, String[] fields, String sortStr, String whereStr, List params) throws BusinessException {
        sortStr = " order by " + (sortStr == null || "".equals(sortStr) ? "start_date" : sortStr) + " ";
        whereStr = whereStr == null || "".equals(whereStr) ? "" : " where " + whereStr + " ";
        String fieldNames = fields == null || fields.length <= 0 ? "*" : StringUtils.arrayToString((String[])Enums.MasterTableField.getKeys()) + "," + StringUtils.arrayToString((String[])fields);
        String sql = "select " + fieldNames + " from " + tableBean.getTableName() + whereStr + sortStr;
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.findByPaging(sql, params, flipInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        List dataList = flipInfo.getData();
        ArrayList<FormDataMasterBean> list = new ArrayList<FormDataMasterBean>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map rowData = (Map)dataList.get(i);
            FormDataMasterBean formDataMasterBean = new FormDataMasterBean(rowData, tableBean, new boolean[0]);
            list.add(formDataMasterBean);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FormDataMasterBean> selectMasterDataList(FlipInfo flipInfo, FormTableBean tableBean, String[] fields, Map<String, Object> where) throws BusinessException {
        String fieldNames = fields == null || fields.length <= 0 ? "*" : " id ," + StringUtils.arrayToString((String[])fields);
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String tableName = tableBean.getTableName();
        sql.append("select " + fieldNames + " from " + tableName);
        if (where != null) {
            if (where.size() > 0) {
                sql.append(" where ");
            }
            Iterator<Map.Entry<String, Object>> iter = where.entrySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (count > 0) {
                    sql.append(" and ");
                }
                ++count;
                if (value instanceof List) {
                    sql.append("  ").append(tableName).append(".").append(key).append(" in (:").append(key).append(") ");
                    params.put(key, value);
                    continue;
                }
                if (value == null) {
                    sql.append("  ").append(tableName).append(".").append(key).append(" is null ").append(" ");
                    continue;
                }
                sql.append("  (").append(tableName).append(".").append(key).append(" = :").append(key).append(" ");
                sql.append("  or ").append(tableName).append(".").append(key).append(" is null ").append(") ");
                params.put(key, value);
            }
        }
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.findNameByPaging(sql.toString(), params, flipInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        List dataList = flipInfo.getData();
        ArrayList<FormDataMasterBean> list = new ArrayList<FormDataMasterBean>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map rowData = (Map)dataList.get(i);
            FormDataMasterBean formDataMasterBean = new FormDataMasterBean(rowData, tableBean, new boolean[0]);
            list.add(formDataMasterBean);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectMasterDataList(FlipInfo flipInfo, FormTableBean tableBean, String sql, List params) {
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.findByPaging(sql, params, flipInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
    }

    @Override
    public List<FormDataSubBean> selectSubDataByMasterId(FormDataMasterBean masterDataBean, FormTableBean tableBean) throws BusinessException, SQLException {
        HashMap<String, FormDataMasterBean> masterDataBeanMap = new HashMap<String, FormDataMasterBean>();
        masterDataBeanMap.put("" + masterDataBean.getId(), masterDataBean);
        return this.selectSubDataByMasterId(masterDataBeanMap, tableBean);
    }

    @Override
    public List<FormDataSubBean> selectSubDataByMasterId(Map<String, FormDataMasterBean> masterDataBeans, FormTableBean tableBean) throws BusinessException, SQLException {
        ArrayList<FormDataSubBean> list = new ArrayList<FormDataSubBean>();
        String fieldNames = "*";
        Long[] masterId = new Long[masterDataBeans.size()];
        Object[] masterIds = masterDataBeans.keySet().toArray();
        for (int i = 0; i < masterIds.length; ++i) {
            masterId[i] = Long.parseLong(String.valueOf(masterIds[i]));
        }
        List<Map<String, Object>> dataList = this.selectById(masterId, Enums.SubTableField.formmain_id.getKey(), tableBean, fieldNames);
        if (dataList != null) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> rowData = dataList.get(i);
                String key = String.valueOf(rowData.get(Enums.SubTableField.formmain_id.getKey()));
                FormDataSubBean formDataSubBean = new FormDataSubBean(rowData, tableBean, masterDataBeans.get(key), new boolean[0]);
                list.add(formDataSubBean);
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> selectDataById(Long[] id, FormTableBean tableBean, String[] fields) throws BusinessException, SQLException {
        String fieldNames = fields == null || fields.length == 0 ? "*" : StringUtils.arrayToString((String[])fields);
        return this.selectById(id, "id", tableBean, fieldNames);
    }

    private List<Map<String, Object>> selectById(Long[] id, String whereId, FormTableBean tableBean, String fields) throws BusinessException, SQLException {
        return this.selectById(id, whereId, tableBean, fields, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> selectById(Long[] id, String whereId, FormTableBean tableBean, String fields, boolean orderBySort) throws BusinessException, SQLException {
        if (id == null || id.length <= 0) {
            return null;
        }
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableBean.getTableName()});
        String sql = "select " + fields + " from " + tableBean.getTableName() + " where " + whereId + " in (" + StringUtils.arrayToString((Long[])id) + ")" + (orderBySort ? " order by sort asc" : "");
        JDBCAgent jdbc = null;
        List dataList = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.execute(sql);
            dataList = jdbc.resultSetToList();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return dataList;
    }

    private int insertIntoTable(FormTableBean table, List<Map<String, Object>> dataList) throws BusinessException {
        if (dataList == null || dataList.size() == 0) {
            return 0;
        }
        StringBuilder fieldNames = new StringBuilder("");
        StringBuilder ps = new StringBuilder("");
        Map<String, Object> rowDataMap = dataList.get(0);
        Set<String> keys = rowDataMap.keySet();
        int count = 0;
        for (String string : keys) {
            String fieldName = string;
            String splitStr = ++count == rowDataMap.size() ? "" : ",";
            fieldNames.append(fieldName + splitStr);
            ps.append("?" + splitStr);
        }
        JDBCAgent jdbc = null;
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Insert, (String[])new String[]{table.getTableName()});
        String sql = "insert into " + table.getTableName() + " (" + fieldNames.toString() + ") values (" + ps.toString() + ")";
        try {
            jdbc = new JDBCAgent();
            TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Insert, table.getTableName());
            jdbc.batch1Prepare(sql);
            for (int i = 0; i < dataList.size(); ++i) {
                rowDataMap = dataList.get(i);
                ArrayList<Object> values = new ArrayList<Object>();
                for (String string : keys) {
                    FormFieldBean field = table.getFieldBeanByName(string);
                    if (field == null && table.isMainTable()) {
                        Enums.MasterTableField e = Enums.MasterTableField.getEnumByKey((String)string);
                        if (e != null) {
                            field = e.getFormFieldBean();
                        } else {
                            LOGGER.error((Object)("\u5b57\u6bb5\uff1a" + string + " \u4e0d\u5e94\u8be5\u51fa\u73b0\u5728\u52a8\u6001\u8868" + table.getTableName() + " \u4e2d\uff01"));
                        }
                    }
                    Object value = rowDataMap.get(string);
                    if (field != null && !StringUtil.checkNull((String)String.valueOf(value))) {
                        value = FormUtil.getDateObject((FormFieldBean)field, (Object)value);
                    }
                    values.add(value);
                }
                TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Insert, table.getTableName());
                jdbc.batch2Add(values);
            }
            count = jdbc.batch3Execute();
        }
        catch (Exception e) {
            this.logDebugSql(table, dataList, fieldNames.toString());
            LOGGER.error((Object)sql);
            LOGGER.error(dataList);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            AppContext.putThreadContext((String)"saveSuccess", (Object)false);
            throw new BusinessException((Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return count;
    }

    private void logDebugSql(FormTableBean table, List<Map<String, Object>> dataList, String fieldNames) {
        Map<String, Object> rowDataMap = dataList.get(0);
        Set<String> keys = rowDataMap.keySet();
        for (int i = 0; i < dataList.size(); ++i) {
            String debugSql = "insert into " + table.getTableName() + " (" + fieldNames + ") values (";
            Map<String, Object> rowData = dataList.get(i);
            int size = rowData.size();
            int c = 0;
            for (String string : keys) {
                ++c;
                FormFieldBean field = table.getFieldBeanByName(string);
                if (field == null && table.isMainTable()) {
                    Enums.MasterTableField masterTableField = Enums.MasterTableField.getEnumByKey((String)string);
                    if (masterTableField != null) {
                        field = masterTableField.getFormFieldBean();
                    } else {
                        LOGGER.error((Object)("\u5b57\u6bb5\uff1a" + string + " \u4e0d\u5e94\u8be5\u51fa\u73b0\u5728\u52a8\u6001\u8868" + table.getTableName() + " \u4e2d\uff01"));
                    }
                }
                Object value = rowDataMap.get(string);
                if (field != null && !StringUtil.checkNull((String)String.valueOf(value))) {
                    value = FormUtil.getDateObject((FormFieldBean)field, (Object)value);
                }
                debugSql = value == null ? debugSql + "null" : (field != null && Enums.FieldType.DECIMAL.getKey().equals(field.getFieldType()) ? debugSql + value : debugSql + "'" + value + "'");
                if (c == size) continue;
                debugSql = debugSql + ",";
            }
            debugSql = debugSql + ")";
            LOGGER.error((Object)("insert db for debug sql : " + debugSql));
        }
    }

    private int insertIntoTable(String tableName, List<Map<String, Object>> dataList) throws BusinessException, SQLException {
        if (dataList == null || dataList.size() == 0) {
            return 0;
        }
        StringBuilder fieldNames = new StringBuilder("");
        StringBuilder ps = new StringBuilder("");
        Map<String, Object> rowDataMap = dataList.get(0);
        Set<String> keys = rowDataMap.keySet();
        int count = 0;
        for (String string : keys) {
            String fieldName = string;
            String splitStr = ++count == rowDataMap.size() ? "" : ",";
            fieldNames.append(fieldName + splitStr);
            ps.append("?" + splitStr);
        }
        JDBCAgent jdbc = null;
        String sql = "insert into " + tableName + " (" + fieldNames.toString() + ") values (" + ps.toString() + ")";
        try {
            jdbc = new JDBCAgent();
            jdbc.batch1Prepare(sql);
            for (int i = 0; i < dataList.size(); ++i) {
                rowDataMap = dataList.get(i);
                ArrayList<Object> values = new ArrayList<Object>();
                for (String string : keys) {
                    Object value = rowDataMap.get(string);
                    values.add(value);
                }
                jdbc.batch2Add(values);
            }
            count = jdbc.batch3Execute();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new SQLException(e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return count;
    }

    @Override
    public boolean updateData(Long id, String tableName, String fieldName, Object fieldValue) throws BusinessException, SQLException {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put(fieldName, fieldValue);
        return this.updateData(id, tableName, fields);
    }

    @Override
    public boolean updateData(Long id, String tableName, Map<String, Object> fields) throws BusinessException, SQLException {
        StringBuilder fieldNames = new StringBuilder("");
        Iterator<Map.Entry<String, Object>> iter = fields.entrySet().iterator();
        if (fields.isEmpty()) {
            LOGGER.error((Object)"\u66f4\u65b0\u5b57\u6bb5\u4e3a\u7a7a");
            return true;
        }
        int count = 0;
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            String splitStr = ++count == fields.size() ? "" : ",";
            fieldNames.append(fieldName + "=?" + splitStr);
            fieldValues.add(fieldValue);
        }
        JDBCAgent jdbc = null;
        boolean isUpdate = false;
        try {
            jdbc = new JDBCAgent();
            JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Update, (String[])new String[]{tableName});
            String sql = "update " + tableName + " set " + fieldNames.toString() + " where id =?";
            fieldValues.add(id);
            isUpdate = jdbc.execute(sql, fieldValues) > 0;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new SQLException(e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDataBatch(String tableName, List<Map<String, Object>> fieldsList) {
        if (fieldsList.isEmpty()) {
            return 0;
        }
        JDBCAgent jdbc = null;
        StringBuilder fieldNames = new StringBuilder("");
        try {
            jdbc = new JDBCAgent();
            String sql = null;
            for (Map<String, Object> fields : fieldsList) {
                Iterator<Map.Entry<String, Object>> iter = fields.entrySet().iterator();
                int count = 0;
                ArrayList<Object> fieldValues = new ArrayList<Object>();
                while (iter.hasNext()) {
                    Map.Entry<String, Object> entry = iter.next();
                    String fieldName = entry.getKey();
                    Object fieldValue = entry.getValue();
                    String splitStr = ++count == fields.size() ? "" : ",";
                    fieldNames.append(fieldName + "=?" + splitStr);
                    fieldValues.add(fieldValue);
                }
                fieldValues.add(fields.get("id"));
                TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Update, tableName);
                if (sql == null) {
                    sql = "update " + tableName + " set " + fieldNames.toString() + " where id =?";
                    jdbc.batch1Prepare(sql);
                }
                jdbc.batch2Add(fieldValues);
            }
            int n = jdbc.batch3Execute();
            return n;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDataBatch(List<? extends FormDataBean> formDataBeanList, FormTableBean formTableBean, boolean updateSort) throws BusinessException, SQLException {
        List<Map<String, Object>> dataList;
        if (formDataBeanList.isEmpty()) {
            return 0;
        }
        int maxSort = 0;
        if (updateSort) {
            maxSort = this.selectMaxSort(formTableBean.getTableName(), Long.parseLong(formDataBeanList.get(0).getFieldValue("formmain_id").toString()));
        }
        if ((dataList = this.changeDataBean2DataMap(formDataBeanList, formTableBean, updateSort, maxSort)).size() > 0) {
            Set<String> fieldNameSet = dataList.get(0).keySet();
            JDBCAgent jdbc = new JDBCAgent();
            StringBuilder fieldNames = new StringBuilder();
            try {
                String sql = null;
                for (Map<String, Object> fields : dataList) {
                    Iterator<String> iter = fieldNameSet.iterator();
                    int count = 0;
                    ArrayList<Object> fieldValues = new ArrayList<Object>();
                    while (iter.hasNext()) {
                        String fieldName = iter.next();
                        String splitStr = ++count == fields.size() ? "" : ",";
                        fieldNames.append(fieldName + "=?" + splitStr);
                        FormFieldBean field = formTableBean.getFieldBeanByName(fieldName);
                        if (field == null && formTableBean.isMainTable()) {
                            Enums.MasterTableField e = Enums.MasterTableField.getEnumByKey((String)fieldName);
                            if (e != null) {
                                field = e.getFormFieldBean();
                            } else {
                                LOGGER.error((Object)("\u5b57\u6bb5\uff1a" + fieldName + " \u4e0d\u5e94\u8be5\u51fa\u73b0\u5728\u52a8\u6001\u8868" + formTableBean.getTableName() + " \u4e2d\uff01"));
                            }
                        }
                        Object fieldValue = fields.get(fieldName);
                        if (field != null && Strings.isNotBlank((String)String.valueOf(fieldValue))) {
                            fieldValue = FormUtil.getDateObject((FormFieldBean)field, (Object)fieldValue);
                        }
                        fieldValues.add(fieldValue);
                    }
                    fieldValues.add(fields.get("id"));
                    TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Update, formTableBean.getTableName());
                    if (sql == null) {
                        sql = "update " + formTableBean.getTableName() + " set " + fieldNames.toString() + " where id =?";
                        jdbc.batch1Prepare(sql);
                    }
                    jdbc.batch2Add(fieldValues);
                }
                int n = jdbc.batch3Execute();
                return n;
            }
            catch (SQLException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                JMTrackUtils.clearTrackTableInfo();
                jdbc.close();
            }
        }
        return 0;
    }

    @Override
    public void saveTable4Db(FormBean fb) throws BusinessException {
        JDBCAgent jdbc = null;
        List tables = fb.getTableList();
        Dialect d = SystemEnvironment.getDialect();
        ArrayList<String> listSQL = new ArrayList<String>();
        for (FormTableBean ftb : tables) {
            listSQL.add(ftb.createTableSql(d));
        }
        try {
            jdbc = new JDBCAgent(true);
            jdbc.executeBatch(listSQL);
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            LOGGER.error((Object)"\u521b\u5efa\u52a8\u6001\u8868\u6709\u95ee\u9898,\u95ee\u9898sql\uff1a");
            for (String sql : listSQL) {
                LOGGER.error((Object)sql);
            }
            throw new BusinessException("\u521b\u5efa\u52a8\u6001\u8868\u6709\u95ee\u9898:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    @Override
    public int saveAddFields4Db(FormBean fb) throws BusinessException {
        JDBCAgent jdbc = null;
        int count = 0;
        try {
            jdbc = new JDBCAgent(true);
            Dialect d = SystemEnvironment.getDialect();
            ArrayList<String> listSQL = new ArrayList<String>();
            for (FormTableBean ftb : fb.getTableList()) {
                listSQL.addAll(this.addColumnSql(ftb, d, jdbc));
            }
            if (listSQL.size() > 0) {
                for (String tt : listSQL) {
                    LOGGER.info((Object)tt);
                }
                count = jdbc.executeBatch(listSQL);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException("\u6dfb\u52a0\u52a8\u6001\u8868\u5b57\u6bb5\u6709\u95ee\u9898", (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> addColumnSql(FormTableBean formTableBean, Dialect d, JDBCAgent jdbc) throws BusinessException {
        List addColumns;
        ArrayList<String> s = new ArrayList<String>();
        if (formTableBean.getExtraAttr("isNew") != null) {
            s.add(formTableBean.createTableSql(d));
        }
        if ((addColumns = (List)formTableBean.getExtraAttr("newField")) != null) {
            try {
                for (String fieldName : addColumns) {
                    FormFieldBean ffb = formTableBean.getFieldBeanByName(fieldName);
                    String preSql = CapUtil.getExistFieldSql((JDBCAgent)jdbc, (String)formTableBean.getTableName(), (String)fieldName);
                    if (Strings.isNotEmpty((String)preSql)) {
                        int count;
                        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{formTableBean.getTableName()});
                        try {
                            count = this.getCount(preSql, jdbc, false);
                        }
                        finally {
                            JMTrackUtils.clearTrackTableInfo();
                        }
                        if (count > 0) {
                            s.add(formTableBean.dropFieldSql(fieldName));
                        }
                    }
                    s.add(formTableBean.getAddColumnSql(d, ffb));
                }
            }
            catch (SQLException e) {
                throw new BusinessException("\u6dfb\u52a0\u52a8\u6001\u8868\u5b57\u6bb5\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        return s;
    }

    @Override
    public void dropFields4Db(FormBean editingForm) throws BusinessException {
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent(true);
            ArrayList<String> listSQL = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            List tables = editingForm.getTableList();
            for (FormTableBean table : tables) {
                List dropFields;
                Map extMap = table.getExtraMap();
                if (!extMap.containsKey("dropFields") || null == (dropFields = (List)extMap.remove("dropFields")) || dropFields.size() <= 0) continue;
                for (String tableField : dropFields) {
                    String[] names = tableField.split("[.]");
                    String tableName = names[0];
                    String fieldName = names[1];
                    sb.append(fieldName).append(",");
                    boolean needExecute = true;
                    String preSql = CapUtil.getExistFieldSql((JDBCAgent)jdbc, (String)tableName, (String)fieldName);
                    if (Strings.isNotEmpty((String)preSql)) {
                        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
                        int count = this.getCount(preSql, jdbc, false);
                        if (count == 0) {
                            needExecute = false;
                        }
                    }
                    if (!needExecute) continue;
                    String sql = "ALTER TABLE " + tableName + " DROP  COLUMN " + fieldName;
                    listSQL.add(sql);
                }
            }
            if (listSQL.size() > 0) {
                jdbc.executeBatch(listSQL);
                LOGGER.info((Object)("\u3010" + editingForm.getFormName() + "\u3011\u5220\u9664\u5b57\u6bb5\uff1a" + sb.toString()));
            }
        }
        catch (SQLException e) {
            String errorMsg = "delete form\u3010" + editingForm.getFormName() + ":" + editingForm.getId() + "\u3011field has problem";
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new BusinessException(errorMsg, (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    @Override
    public int saveModifyFields4Db(List<String> listSQL) throws BusinessException {
        JDBCAgent jdbc = null;
        Dialect dialect = SystemEnvironment.getDialect();
        int count = 0;
        if (Strings.isEmpty(listSQL)) {
            return count;
        }
        try {
            jdbc = new JDBCAgent(true);
            if (dialect.getClass().getName().toLowerCase().contains("sqlserver")) {
                for (String sqlStr : listSQL) {
                    LOGGER.info((Object)sqlStr);
                    jdbc.execute(sqlStr);
                    ++count;
                }
            } else {
                for (String sqlStr : listSQL) {
                    LOGGER.info((Object)sqlStr);
                }
                count = jdbc.executeBatch(listSQL);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException("\u4fee\u6539\u52a8\u6001\u8868\u6709\u95ee\u9898", (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
        return count;
    }

    @Override
    public void saveTableIndex4Db(FormBean formBean, FormBean oldFormBean, boolean needCheckOldIndex) throws BusinessException {
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent(true);
            FormTableIndexBean ftib = new FormTableIndexBean();
            List listSQL = ftib.createTableIndexSql(jdbc, formBean, oldFormBean, needCheckOldIndex);
            if (Strings.isNotEmpty((Collection)listSQL)) {
                for (String sqlStr : listSQL) {
                    LOGGER.info((Object)sqlStr);
                }
                jdbc.executeBatch(listSQL);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException("\u521b\u5efa\u52a8\u6001\u8868\u7d22\u5f15\u6709\u95ee\u9898:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectRecordCount(String tableName) throws BusinessException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "select count(id) as c from " + tableName;
        try {
            int n = this.getCount(sql);
            return n;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectRecordCount(FormTableBean formTableBean, long masterId) throws BusinessException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{formTableBean.getTableName()});
        String sql = "select count(id) as c from " + formTableBean.getTableName() + " where id = " + masterId;
        try {
            int n = this.getCount(sql);
            return n;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    private int getCount(String sql) {
        JDBCAgent jdbc = new JDBCAgent();
        return this.getCount(sql, jdbc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(String sql, JDBCAgent jdbc, boolean needClose) {
        List result = null;
        try {
            jdbc.execute(sql);
            result = jdbc.resultSetToList();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (needClose) {
                jdbc.close();
            }
        }
        if (result == null) {
            return 0;
        }
        Map map = (Map)result.get(0);
        return ((Number)map.get("c")).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectRecordCount(String tableName, String fieldName) throws BusinessException, SQLException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "select count(*) as c  from " + tableName + " where " + fieldName + " is not null";
        try {
            int n = this.getCount(sql);
            return n;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFieldHasData(String tableName, String fieldName) throws BusinessException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "select count(id) as c from " + tableName + " where " + fieldName + " is not null ";
        JDBCAgent jdbc = null;
        int count = 0;
        try {
            jdbc = new JDBCAgent(true);
            count = this.getCount(sql, jdbc, false);
        }
        catch (Exception exception) {
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            if (jdbc != null) {
                jdbc.close();
            }
        }
        return count > 0;
    }

    /*
     * WARNING - void declaration
     */
    private String getSQL(FormBean formBean, String[] showFields, String whereStr, Map<String, String> orderBy) {
        void var13_22;
        String showField;
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        String masterTableName = formBean.getMasterTableBean().getTableName();
        tableNames.add(masterTableName);
        StringBuilder showStr = new StringBuilder("select distinct " + masterTableName + ".id ");
        boolean isOnlyMaster = false;
        for (int i = 0; i < showFields.length; ++i) {
            String tableName;
            String fieldName = showField = showFields[i];
            if (showField.contains(".")) {
                fieldName = showField.substring(showField.indexOf(".") + 1);
            }
            if (Enums.MasterTableField.state == Enums.MasterTableField.getEnumByKey((String)fieldName)) {
                showStr.append(",").append(masterTableName).append(".").append(fieldName);
            } else {
                showStr.append(",").append(showField);
            }
            if (!showField.contains(".") || tableNames.contains(tableName = showField.substring(0, showField.indexOf(".")))) continue;
            tableNames.add(tableName);
        }
        if (tableNames.size() == 1) {
            isOnlyMaster = true;
        }
        if (Strings.isNotBlank((String)whereStr)) {
            whereStr = whereStr.replaceAll("<> null", "is not null");
            whereStr = whereStr.replaceAll("= null", "is null");
            Matcher m = this.getSqlregPattern.matcher(whereStr);
            while (m.find()) {
                showField = m.group();
                String tableName = "";
                if (showField.indexOf(".") > -1) {
                    tableName = showField.substring(0, showField.indexOf("."));
                } else {
                    FormFieldBean ffb = formBean.getFieldBeanByName(showField);
                    if (ffb != null) {
                        tableName = ffb.getOwnerTableName();
                    }
                }
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            whereStr = whereStr.replaceAll("state", masterTableName + ".state");
        }
        StringBuilder orderByStr = new StringBuilder(" order by ");
        HashMap<String, String> enumTable = new HashMap<String, String>();
        if (orderBy != null && orderBy.size() > 0) {
            for (Map.Entry<String, String> e : orderBy.entrySet()) {
                FormFieldBean ffb;
                String tableName;
                String string = e.getKey();
                if (string.indexOf(".") > -1 && !tableNames.contains(tableName = string.substring(0, string.indexOf(".")))) {
                    tableNames.add(tableName);
                }
                if (Strings.isBlank((String)string)) continue;
                String field = string;
                if (string.contains(".")) {
                    field = string.substring(string.indexOf(".") + 1);
                }
                if ((ffb = formBean.getFieldBeanByName(field)) != null && (ffb.getInputType().equalsIgnoreCase(FormFieldComEnum.SELECT.getKey()) || ffb.getInputType().equalsIgnoreCase(FormFieldComEnum.RADIO.getKey()) || ffb.getInputType().equalsIgnoreCase(FormFieldComEnum.IMAGE_SELECT.getKey()) || ffb.getInputType().equalsIgnoreCase(FormFieldComEnum.IMAGE_RADIO.getKey()))) {
                    StringBuilder displayStr = new StringBuilder();
                    displayStr.append("ctp_enum_item_").append(field).append(".").append("sortnumber");
                    orderByStr.append(displayStr.toString()).append(" ").append(e.getValue()).append(",");
                    enumTable.put(string, "ctp_enum_item_" + field);
                } else if (Enums.MasterTableField.state == Enums.MasterTableField.getEnumByKey((String)field)) {
                    orderByStr.append(masterTableName).append(".").append(field).append(" ").append(e.getValue()).append(",");
                } else {
                    orderByStr.append(string).append(" ").append(e.getValue()).append(",");
                }
                if (showStr.indexOf(string) != -1) continue;
                showStr.append(",").append(string);
            }
        }
        orderByStr.append(masterTableName + ".id");
        StringBuilder fromStr = new StringBuilder();
        fromStr.append(" from ").append(masterTableName).append(" ");
        if (tableNames.size() > 1) {
            for (String string : tableNames) {
                if (masterTableName.equals(string)) continue;
                fromStr.append(" left join ").append(string).append(" on (").append(masterTableName).append(".id=").append(string).append(".").append(Enums.SubTableField.formmain_id.getKey()).append(") ");
            }
        }
        for (Map.Entry entry : enumTable.entrySet()) {
            fromStr.append(" left join ").append("ctp_enum_item").append(" ").append((String)entry.getValue()).append(" on (").append((String)entry.getValue()).append(".id=").append((String)entry.getKey()).append(") ");
        }
        StringBuilder sql = new StringBuilder();
        sql.append((CharSequence)showStr).append((CharSequence)fromStr);
        if (Strings.isNotBlank((String)whereStr)) {
            sql.append("where ").append(whereStr);
        }
        if (Strings.isNotBlank((String)orderByStr.toString())) {
            sql.append(" ").append((CharSequence)orderByStr);
        }
        String string = sql.toString();
        if (!(isOnlyMaster && Strings.isNotBlank((String)whereStr) && whereStr.contains("formson_"))) {
            String string2 = string.replaceAll("distinct", "");
        }
        return var13_22;
    }

    @Override
    public FlipInfo selectFormData4Query(FormBean formBean, FlipInfo flipInfo, String[] showFields, String whereStr, Map<String, String> orderBy, List param) throws BusinessException {
        String sql = this.getSQL(formBean, showFields, whereStr, orderBy);
        JDBCAgent jdbc = new JDBCAgent(true);
        try {
            if (flipInfo != null) {
                jdbc.findByPaging(sql, param, flipInfo);
            } else {
                flipInfo = new FlipInfo();
                jdbc.execute(sql, param);
                flipInfo.setData(jdbc.resultSetToList());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)sql, (Throwable)e);
            throw new BusinessException(ResourceUtil.getString((String)"query.result.error.alert"));
        }
        finally {
            jdbc.close();
        }
        return flipInfo;
    }

    @Override
    public List<Map> selectFormDataByTableBean(FormTableBean masterFormTableBean, FormTableBean slaveFormTableBean, String[] showFields, String whereStr, List param) throws BusinessException {
        String fieldNames = showFields == null || showFields.length < 0 ? "*" : StringUtils.arrayToString((String[])showFields);
        String mainShortName = masterFormTableBean.getTableName().replace(Enums.TableType.MASTER.getTableSufName() + "_", "b");
        String slaveShortName = null;
        if (slaveFormTableBean != null && "*".equals(fieldNames)) {
            slaveShortName = slaveFormTableBean.getTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
            fieldNames = slaveShortName + ".id as slave_id ," + mainShortName + ".*," + slaveShortName + ".* ";
        } else if (slaveFormTableBean != null && showFields != null && showFields.length >= 0) {
            slaveShortName = slaveFormTableBean.getTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
            fieldNames = slaveShortName + ".id as slave_id ," + mainShortName + ".id";
            for (String fieldName : showFields) {
                if (StringUtil.checkNull((String)fieldName) || Enums.MasterTableField.getEnumByKey((String)fieldName) != null || Enums.SubTableField.getEnumByKey((String)fieldName) != null) continue;
                FormFieldBean field = masterFormTableBean.getFieldBeanByName(fieldName);
                FormFieldBean formFieldBean = field = field == null ? slaveFormTableBean.getFieldBeanByName(fieldName) : field;
                if (field == null) continue;
                fieldNames = field.isMasterField() ? fieldNames + "," + mainShortName + "." + fieldName : fieldNames + "," + slaveShortName + "." + fieldName;
            }
        }
        StringBuilder sb = new StringBuilder("select ");
        sb.append(fieldNames).append(" from ").append(masterFormTableBean.getTableName()).append(" ").append(mainShortName);
        if (slaveShortName != null) {
            sb.append(",").append(slaveFormTableBean.getTableName()).append(" ").append(slaveShortName);
            whereStr = Strings.isNotBlank((String)whereStr) ? mainShortName + ".id=" + slaveShortName + ".formmain_id and " + whereStr : mainShortName + ".id=" + slaveShortName + ".formmain_id";
        }
        sb.append(Strings.isBlank((String)whereStr) ? "" : " where " + whereStr);
        sb.append(" order by " + mainShortName + ".start_date, " + mainShortName + ".id");
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.execute(sb.toString(), param);
            List list = jdbc.resultSetToList();
            return list;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e, "\u8868\u5355\u67e5\u8be2\u62a5\u9519!!!", new Object[0]);
        }
        finally {
            jdbc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockState(String ids, String tableName, int state) throws BusinessException {
        JDBCAgent jdbc = new JDBCAgent();
        String[] idsArr = ids.split(",");
        String sql = "";
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Update, (String[])new String[]{tableName});
        sql = idsArr.length > 1 ? "UPDATE " + tableName + " SET STATE= " + state + " WHERE ID IN (" + ids + ") " : "UPDATE " + tableName + " SET STATE= " + state + " WHERE ID = " + ids;
        boolean result = false;
        try {
            result = jdbc.execute(sql) > 0;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            jdbc.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findLock(String ids, String tableName) throws BusinessException {
        int count;
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "SELECT count(*) as c FROM " + tableName + " WHERE STATE= " + Enums.FormDataStateEnum.UNFLOW_LOCKED.getKey() + " AND ID IN (" + ids + ") ";
        try {
            count = this.getCount(sql);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map> getLockState(String ids, String tableName) throws BusinessException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "SELECT id,state FROM " + tableName + " WHERE  ID IN (" + ids + ") ";
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.execute(sql);
            List list = jdbc.resultSetToList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error((Object)sql, (Throwable)e);
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
            jdbc.close();
        }
        return null;
    }

    @Override
    public boolean isExist(String ids, String tableName) throws BusinessException, SQLException {
        return this.isExistReturnCount(ids, tableName) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isExistReturnCount(String ids, String tableName) throws BusinessException, SQLException {
        JMTrackUtils.putTrackTableInfo((JMSQLOperation)JMSQLOperation.Select, (String[])new String[]{tableName});
        String sql = "SELECT count(*) as c FROM " + tableName + " WHERE  ID IN (" + ids + ") ";
        try {
            int n = this.getCount(sql);
            return n;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ckeckDataExist(List<SimpleObjectBean> list, String tableName, String fieldsLogic) throws BusinessException {
        JDBCAgent jdbc = new JDBCAgent();
        StringBuilder sb = new StringBuilder("");
        sb.append("SELECT count(*) as c FROM ").append(tableName).append(" WHERE ");
        ArrayList<String> fieldValues = new ArrayList<String>();
        for (SimpleObjectBean sob : list) {
            sb.append(fieldsLogic).append(" ").append(sob.getName()).append(" =? ");
            fieldValues.add(sob.getValue());
        }
        sb = new StringBuilder(sb.toString().replaceFirst(fieldsLogic + " ", ""));
        List result = null;
        try {
            jdbc.execute(sb.toString(), fieldValues);
            result = jdbc.resultSetToList();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        if (result == null) {
            return false;
        }
        Map map = (Map)result.get(0);
        int count = ((Number)map.get("c")).intValue();
        return count > 0;
    }

    @Override
    public List<Map> getValueByMap(String[] returnFields, Map<String, Object> hm, String tableName, String fieldsLogic) throws BusinessException {
        String fieldNames = returnFields == null || returnFields.length < 0 ? "*" : StringUtils.arrayToString((String[])returnFields);
        StringBuilder sb = new StringBuilder("");
        sb.append("SELECT ").append(fieldNames).append(" FROM ").append(tableName).append(" WHERE ");
        JDBCAgent jdbc = new JDBCAgent();
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : hm.entrySet()) {
            sb.append(fieldsLogic).append(" ").append(entry.getKey()).append(" =? ");
            fieldValues.add(entry.getValue());
        }
        sb = new StringBuilder(sb.toString().replaceFirst(fieldsLogic + " ", ""));
        List result = null;
        try {
            jdbc.execute(sb.toString(), fieldValues);
            result = jdbc.resultSetToList();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return result;
    }

    @Override
    public List<Map> selectDataBySql(String sql) throws BusinessException {
        JDBCAgent jdbc = new JDBCAgent();
        List result = null;
        try {
            jdbc.execute(sql);
            result = jdbc.resultSetToList();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return result;
    }

    @Override
    public List<Map> selectDataBySql(String sql, List<Object> params) throws BusinessException {
        JDBCAgent jdbc = new JDBCAgent();
        List result = null;
        try {
            jdbc.execute(sql, params);
            result = jdbc.resultSetToList();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return result;
    }

    @Override
    public List<Map> selectDataForPhoneIndicator(FormBean formBean, String showSql, String whereStr, List param, String type, String fieldName) throws BusinessException {
        FormFieldBean fieldBean;
        StringBuilder showStr = new StringBuilder("SELECT ");
        showStr.append(showSql);
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        String masterTableName = formBean.getMasterTableBean().getTableName();
        tableNames.add(masterTableName);
        String tempName = fieldName;
        if (tempName.contains(".")) {
            tempName = tempName.substring(tempName.indexOf(".") + 1);
        }
        if ((fieldBean = formBean.getFieldBeanByName(tempName)) != null) {
            tableNames.add(formBean.getFormTableBeanByFieldName(tempName).getTableName());
        }
        if (Strings.isNotBlank((String)whereStr)) {
            whereStr = whereStr.replaceAll("<> null", "is not null");
            whereStr = whereStr.replaceAll("= null", "is null");
            Matcher m = this.selectDataPattern.matcher(whereStr);
            while (m.find()) {
                String showField = m.group();
                String tableName = "";
                if (showField.indexOf(".") > -1) {
                    tableName = showField.substring(0, showField.indexOf("."));
                } else {
                    FormFieldBean ffb = formBean.getFieldBeanByName(showField);
                    if (ffb != null) {
                        tableName = ffb.getOwnerTableName();
                    }
                }
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            whereStr = whereStr.replaceAll("state", masterTableName + ".state");
        }
        StringBuilder fromStr = new StringBuilder();
        fromStr.append(" FROM ").append(masterTableName).append(" ");
        if (tableNames.size() > 1) {
            for (String n : tableNames) {
                if (masterTableName.equals(n)) continue;
                fromStr.append(" LEFT JOIN ").append(n).append(" ON (").append(masterTableName).append(".id=").append(n).append(".").append(Enums.SubTableField.formmain_id.getKey()).append(") ");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append((CharSequence)showStr).append((CharSequence)fromStr);
        if (Strings.isNotBlank((String)whereStr)) {
            sql.append(" where ").append(whereStr);
        }
        ArrayList<Map> result = new ArrayList();
        if ("earliest".equals(type) || "latest".equals(type)) {
            if (sql.indexOf("where") < 0) {
                sql.append(" where " + fieldName + " is not null");
            } else {
                sql.append(" and " + fieldName + " is not null");
            }
            String orderBy = "";
            orderBy = "earliest".equals(type) ? " ORDER BY " + fieldName + " ASC" : " ORDER BY " + fieldName + " DESC";
            sql.append(" ").append(orderBy);
            List<Map> list = this.selectDataBySql(sql.toString(), param);
            if (Strings.isNotEmpty(list)) {
                result.add(list.get(0));
            }
        } else {
            result = this.selectDataBySql(sql.toString(), param);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlipInfo selectDataBySql(String sql, List<Object> params, FlipInfo flipInfo) throws BusinessException {
        JDBCAgent jdbc = new JDBCAgent();
        LOGGER.info((Object)("sql : " + sql + "   \u53c2\u6570\uff1a" + params));
        try {
            jdbc.findByPaging(sql, params, flipInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return flipInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectDataCount(String tableName) throws BusinessException, SQLException {
        String sql = "select count(id) from " + tableName;
        JDBCAgent jdbc = new JDBCAgent();
        ResultSet result = null;
        int r = 0;
        try {
            jdbc.execute(sql);
            result = jdbc.getQueryResult();
            if (result.next()) {
                r = result.getInt(1);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return r;
    }

    @Override
    public void insertOrUpdateMasterData(List<FormDataMasterBean> masterBeanList, boolean needDelete) throws BusinessException, SQLException {
        if (Strings.isEmpty(masterBeanList)) {
            return;
        }
        if (needDelete) {
            this.deleteMasterData(masterBeanList);
        }
        this.insertData(masterBeanList, false);
        if (masterBeanList.get(0).getSubTables() != null && masterBeanList.get(0).getSubTables().size() > 0) {
            for (String tableName : masterBeanList.get(0).getSubTables().keySet()) {
                ArrayList subBeanList = new ArrayList();
                for (FormDataMasterBean masterBean : masterBeanList) {
                    subBeanList.addAll(masterBean.getSubData(tableName));
                }
                int count = this.insertData(subBeanList, true);
                LOGGER.info((Object)("[" + tableName + "]\u63d2\u5165" + count + "\u884c\u91cd\u590d\u8868\u6570\u636e\u3002"));
            }
        }
    }

    @Override
    public void deleteMasterData(List<FormDataMasterBean> masterBeanList) throws BusinessException, SQLException {
        block9: {
            List masterIDs;
            Set subTables;
            String masterTable;
            block8: {
                Long[] mIDs;
                Map<String, Object> resultMap = this.changeList2Ids(masterBeanList);
                if (resultMap == null) {
                    return;
                }
                masterTable = (String)resultMap.get("masterTable");
                subTables = (Set)resultMap.get("subTables");
                masterIDs = (List)resultMap.get("masterIDs");
                if (masterIDs.size() <= 1000) break block8;
                int size = masterIDs.size();
                int end = 0;
                for (int i = 0; i < size / 1000; ++i) {
                    mIDs = new Long[1000];
                    end = (i + 1) * 1000;
                    int k = 0;
                    for (int j = i * 1000; j < end; ++j) {
                        mIDs[k++] = (Long)masterIDs.get(j);
                    }
                    this.delete(mIDs, Enums.MasterTableField.id.getKey(), masterTable);
                    for (String table : subTables) {
                        this.delete(mIDs, Enums.SubTableField.formmain_id.getKey(), table);
                    }
                }
                if (end >= size) break block9;
                mIDs = new Long[size - end];
                int k = 0;
                for (int j = end; j < size; ++j) {
                    mIDs[k++] = (Long)masterIDs.get(j);
                }
                this.delete(mIDs, Enums.MasterTableField.id.getKey(), masterTable);
                for (String table : subTables) {
                    this.delete(mIDs, Enums.SubTableField.formmain_id.getKey(), table);
                }
                break block9;
            }
            Long[] mIDs = new Long[masterIDs.size()];
            for (int i = 0; i < masterIDs.size(); ++i) {
                mIDs[i] = (Long)masterIDs.get(i);
            }
            this.delete(mIDs, Enums.MasterTableField.id.getKey(), masterTable);
            for (String table : subTables) {
                this.delete(mIDs, Enums.SubTableField.formmain_id.getKey(), table);
            }
        }
    }

    private Map<String, Object> changeList2Ids(List<FormDataMasterBean> masterBeanList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Long> masterIDs = new ArrayList<Long>();
        HashSet subTables = new HashSet();
        String masterTable = "";
        for (FormDataMasterBean masterBean : masterBeanList) {
            if (masterBean == null || masterBean.getId() == 0L) {
                return null;
            }
            FormTableBean table = masterBean.getFormTable();
            if (table == null || table.getTableName() == null || "".equals(table.getTableName())) {
                return null;
            }
            masterIDs.add(masterBean.getId());
            masterTable = table.getTableName();
            if (masterBean.getSubTables() == null || masterBean.getSubTables().size() <= 0) continue;
            subTables.addAll(masterBean.getSubTables().keySet());
        }
        resultMap.put("masterIDs", masterIDs);
        resultMap.put("masterTable", masterTable);
        resultMap.put("subTables", subTables);
        return resultMap;
    }

    @Override
    public Map selectDataBySummaryIdOrAffairId(String summaryOrAffairId) throws BusinessException, SQLException {
        String sql = "select form_app_id form_id, form_recordid data_id from ctp_affair where id = ";
        sql = sql + summaryOrAffairId;
        sql = sql + " union all ";
        sql = sql + "select form_appid form_id, form_recordid data_id from col_summary where id = ";
        List<Map> resultMap = this.selectDataBySql(sql = sql + summaryOrAffairId);
        if (Strings.isEmpty(resultMap)) {
            return null;
        }
        return resultMap.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FormDataMasterBean> selectMasterDataList(FormBean formBean, FlipInfo flipInfo) throws BusinessException, SQLException {
        StringBuilder sql = new StringBuilder("select ");
        FormTableBean mainTable = formBean.getMasterTableBean();
        sql.append(mainTable.getTableName()).append(".id,").append(Enums.MasterTableField.start_date.getKey()).append(",").append(Enums.MasterTableField.start_member_id.getKey());
        sql.append(" from ").append(mainTable.getTableName()).append(" ");
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.findByPaging(sql.toString(), new ArrayList(), flipInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        List dataList = flipInfo.getData();
        Long[] ids = new Long[dataList.size()];
        for (int i = 0; i < dataList.size(); ++i) {
            Map rowData = (Map)dataList.get(i);
            ids[i] = Long.valueOf(rowData.get("id").toString());
        }
        List<Map<String, Object>> masterList = this.selectById(ids, Enums.MasterTableField.id.getKey(), mainTable, "*");
        HashMap<String, List<Map<String, Object>>> subDataMaps = new HashMap<String, List<Map<String, Object>>>();
        List tableList = formBean.getSubTableBean();
        for (FormTableBean tableBean : tableList) {
            List<Map<String, Object>> subDataMap = this.selectById(ids, Enums.SubTableField.formmain_id.getKey(), tableBean, "*");
            subDataMaps.put(tableBean.getTableName(), subDataMap);
        }
        ArrayList<FormDataMasterBean> resultList = new ArrayList<FormDataMasterBean>();
        if (masterList != null) {
            for (Map<String, Object> rowData : masterList) {
                FormDataMasterBean formDataMasterBean = new FormDataMasterBean(rowData, mainTable, new boolean[0]);
                resultList.add(formDataMasterBean);
                for (Map.Entry entry : subDataMaps.entrySet()) {
                    List subDataMap = (List)entry.getValue();
                    ArrayList<FormDataSubBean> subBeans = new ArrayList<FormDataSubBean>();
                    for (Map subData : subDataMap) {
                        String key = String.valueOf(subData.get(Enums.SubTableField.formmain_id.getKey()));
                        if (!key.equals(formDataMasterBean.getId().toString())) continue;
                        FormDataSubBean formDataSubBean = new FormDataSubBean(subData, formBean.getTableByTableName((String)entry.getKey()), formDataMasterBean, new boolean[0]);
                        subBeans.add(formDataSubBean);
                    }
                    formDataMasterBean.setSubData((String)entry.getKey(), subBeans);
                }
            }
        }
        return resultList;
    }

    @Override
    public void updateDataState2Unlock(List<FormDataMasterBean> masterBeanList) throws BusinessException, SQLException {
        Map<String, Object> resultMap = this.changeList2Ids(masterBeanList);
        if (resultMap == null) {
            return;
        }
        String masterTable = (String)resultMap.get("masterTable");
        List masterIDs = (List)resultMap.get("masterIDs");
        if (masterIDs.size() > 1000) {
            Long[] mIDs;
            int size = masterIDs.size();
            int end = 0;
            for (int i = 0; i < size / 1000; ++i) {
                mIDs = new Long[1000];
                end = (i + 1) * 1000;
                int k = 0;
                for (int j = i * 1000; j < end; ++j) {
                    mIDs[k++] = (Long)masterIDs.get(j);
                }
                this.updateDataState2Unlock(masterTable, mIDs);
            }
            if (end < size) {
                mIDs = new Long[size - end];
                int k = 0;
                for (int j = end; j < size; ++j) {
                    mIDs[k++] = (Long)masterIDs.get(j);
                }
                this.updateDataState2Unlock(masterTable, mIDs);
            }
        } else {
            Long[] mIDs = new Long[masterIDs.size()];
            for (int i = 0; i < masterIDs.size(); ++i) {
                mIDs[i] = (Long)masterIDs.get(i);
            }
            this.updateDataState2Unlock(masterTable, mIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataState2Unlock(String masterTable, Long[] masterIds) throws BusinessException, SQLException {
        JDBCAgent jdbc = new JDBCAgent();
        try {
            String sql = " update " + masterTable + " set state = 1 where id in(" + StringUtils.arrayToString((Long[])masterIds) + ")";
            jdbc.execute(sql);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
    }

    @Override
    public List<Map> selectTargetDataId(FormTableBean masterFormTableBean, FormTableBean slaveFormTableBean, String whereStr, List param) throws BusinessException {
        String mainShortName = masterFormTableBean.getTableName().replace(Enums.TableType.MASTER.getTableSufName() + "_", "b");
        String fieldNames = mainShortName + ".id";
        String slaveShortName = null;
        if (slaveFormTableBean != null) {
            slaveShortName = slaveFormTableBean.getTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
            fieldNames = fieldNames + ", " + slaveShortName + ".id as slave_id";
        }
        StringBuilder sb = new StringBuilder("select ");
        sb.append(fieldNames).append(" from ").append(masterFormTableBean.getTableName()).append(" ").append(mainShortName);
        if (slaveShortName != null) {
            sb.append(",").append(slaveFormTableBean.getTableName()).append(" ").append(slaveShortName);
            whereStr = Strings.isNotBlank((String)whereStr) ? mainShortName + ".id=" + slaveShortName + ".formmain_id and " + whereStr : mainShortName + ".id=" + slaveShortName + ".formmain_id";
        }
        sb.append(Strings.isBlank((String)whereStr) ? "" : " where " + whereStr);
        sb.append(" order by " + mainShortName + ".start_date, " + mainShortName + ".id");
        JDBCAgent jdbc = new JDBCAgent();
        try {
            LOGGER.info((Object)("\u56de\u5199sql : " + sb.toString()));
            jdbc.execute(sb.toString(), param);
            List list = jdbc.resultSetToList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e, "\u56de\u5199\u67e5\u8be2\u76ee\u6807\u6570\u636e", new Object[0]);
        }
        finally {
            jdbc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAllFormDataByTableName(List<String> tableName) throws BusinessException {
        boolean result = false;
        ArrayList<String> sqlBatch = new ArrayList<String>();
        for (int i = 0; i < tableName.size(); ++i) {
            String sql = "DELETE FROM " + tableName.get(i);
            sqlBatch.add(sql);
        }
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.executeBatch(sqlBatch);
            result = true;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return result;
    }

    @Override
    public List<Long> selectModuleIdByFormId(long formId) throws BusinessException {
        ArrayList<Long> moduleIds = new ArrayList<Long>();
        String sql = "SELECT MODULE_ID AS MODULEID FROM CTP_CONTENT_ALL WHERE CONTENT_TEMPLATE_ID = " + formId + " AND CONTENT_DATA_ID IS NOT NULL";
        JDBCAgent jdbc = new JDBCAgent();
        try {
            jdbc.execute(sql);
            List dataList = jdbc.resultSetToList();
            if (Strings.isNotEmpty((Collection)dataList)) {
                for (int i = 0; i < dataList.size(); ++i) {
                    Map rowData = (Map)dataList.get(i);
                    moduleIds.add(Long.valueOf(rowData.get("moduleid").toString()));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e, "\u67e5\u627e\u9644\u4ef6MODULEID\u51fa\u9519", new Object[0]);
        }
        finally {
            jdbc.close();
        }
        return moduleIds;
    }

    @Override
    public List getTableDataListForExport(String table, Map<String, Object> params, String fields, String masterSortSql) throws BusinessException {
        List resultList;
        fields = fields == null ? "*" : fields;
        StringBuilder sql = new StringBuilder("SELECT ").append(fields).append(" FROM ").append(table);
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            if (params != null && params.size() > 0) {
                List masterParams;
                String masterSql = params.get("masterSql") != null ? (String)params.get("masterSql") : null;
                List list = masterParams = params.get("masterParams") != null ? (List)params.get("masterParams") : new ArrayList();
                if (masterSql != null) {
                    if (table.startsWith("formmain")) {
                        sql.append(" WHERE id IN ( ").append(masterSql).append(" )");
                        if (Strings.isNotBlank((String)masterSortSql)) {
                            sql.append(masterSortSql);
                        } else {
                            sql.append(" ORDER BY id ASC ");
                        }
                    } else {
                        sql.append(" WHERE formmain_id IN ( ").append(masterSql).append(" ) ORDER BY formmain_id ASC, sort ASC");
                    }
                }
                LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868sub table \u751f\u6210\u7684\u67e5\u8be2sql\u8bed\u53e5: " + sql.toString()));
                LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868sub table \u751f\u6210\u7684\u67e5\u8be2sql\u53c2\u6570\uff1a" + masterParams));
                jdbc.execute(sql.toString(), masterParams);
            } else {
                LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868sub table \u751f\u6210\u7684\u67e5\u8be2sql\u8bed\u53e5: " + sql.toString()));
                jdbc.execute(sql.toString());
            }
            resultList = jdbc.resultSetToList();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("getTableDataListForExport " + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
        }
        return resultList == null ? new ArrayList() : resultList;
    }
}

