/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formData;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.enums.ColHandleType;
import com.seeyon.apps.collaboration.enums.CollaborationEnum;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.apps.index.api.IndexApi;
import com.seeyon.apps.taskmanage.api.TaskmanageApi;
import com.seeyon.cap4.cache.TrackTableListener_CAP4Dynamic;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormQueryResult;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheRemove;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunctionUitl;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationRecordDAO;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormDataStateResultVO;
import com.seeyon.cap4.monitor.uniqueIndex.unit.FormUniqueIndexForCap4;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.affair.manager.AffairManager;
import com.seeyon.ctp.common.affair.util.AffairUtil;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.comment.Comment;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.publicqrcode.manager.PublicQrCodeManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.modules.engin.formula.function.FormFormulaFunctionCompareEnumValue;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.monitor.histories.HistoryObj;
import com.seeyon.ctp.monitor.histories.HistoryObjManager;
import com.seeyon.ctp.monitor.histories.ISaveData;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.monitor.utils.MonitorUtil;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import com.seeyon.v3x.system.signet.domain.V3xHtmDocumentSignature;
import com.seeyon.v3x.system.signet.domain.V3xSignet;
import com.seeyon.v3x.system.signet.manager.SignetManager;
import com.seeyon.v3x.system.signet.manager.V3xHtmDocumentSignatManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.taglibs.standard.functions.Functions;

public class CAP4FormDataManagerImpl
implements CAP4FormDataManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormDataManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private CollaborationApi collaborationApi;
    private AffairManager affairManager;
    private SignetManager signetManager;
    private V3xHtmDocumentSignatManager v3xHtmDocumentSignatManager;
    private OrgManager orgManager;
    private LbsManager lbsManager;
    private IndexApi indexApi;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private CAPFormDataCacheManager capFormDataCacheManager;
    private CAP4FormRelationActionManager cap4FormRelationActionManager;
    private CAP4FormRelationRecordDAO cap4FormRelationRecordDAO;
    private PublicQrCodeManager publicQrCodeManager;
    private static Pattern toDatePattern = Pattern.compile("to_date\\(([^()]*)\\)");
    private static Pattern fieldPattern = Pattern.compile("(\\{[^}|^{]*\\})");
    private static Pattern sysPattern = Pattern.compile("(\\[[^]|^\\[]*\\])");
    private static final String AUDIT = "formaudit";
    private static final String vouch = "vouch";
    private static final String APART_AUTH_MAP = "apartAuthMap";
    private static final String SUB_TABLE_AUTH_MAP = "subTableAuthMap";
    private static final String NULLS_FIRST = " NULLS FIRST";
    private static final String NULLS_LAST = " NULLS LAST";

    public PublicQrCodeManager getPublicQrCodeManager() {
        return this.publicQrCodeManager;
    }

    public void setPublicQrCodeManager(PublicQrCodeManager publicQrCodeManager) {
        this.publicQrCodeManager = publicQrCodeManager;
    }

    @Override
    public void calc4EditingForm(com.seeyon.cap4.form.bean.FormBean form, com.seeyon.cap4.form.bean.FormFieldBean resultFormFieldBean, FormDataMasterBean cacheMasterData, FormDataSubBean subDataBean, Set<String> fillBackFields, FormAuthViewBean authViewBean, boolean needDealSysRelation) throws BusinessException {
        String errorFormulaStr = "";
        Long recordId = subDataBean == null ? 0L : subDataBean.getId();
        try {
            String formulaType = FormulaEnums.getFormulaTypeByFieldType((String)resultFormFieldBean.getFieldType());
            Object value = null;
            boolean isChange = false;
            Map params = cacheMasterData.getFormulaMap(formulaType);
            params.put("formDataBean", cacheMasterData);
            params.put("formBean", form);
            FormDataMasterBean dataBean = null;
            boolean isDelRow = false;
            if (!resultFormFieldBean.isMasterField() && subDataBean != null) {
                if (!resultFormFieldBean.getOwnerTableName().equals(subDataBean.getFormTable().getTableName())) {
                    return;
                }
                dataBean = subDataBean;
                if (dataBean != null) {
                    params.putAll(dataBean.getFormulaMap(formulaType));
                    params.put("subDataBean", dataBean);
                } else {
                    isDelRow = true;
                }
            } else {
                dataBean = cacheMasterData;
            }
            if (!isDelRow) {
                FormFormulaBean formulaBean = this.getFormFormulaBean(form, cacheMasterData, resultFormFieldBean, subDataBean, resultFormFieldBean.isMasterField());
                if (null == formulaBean) {
                    return;
                }
                String forumlaStr = formulaBean.getExecuteFormulaForGroove();
                forumlaStr = this.replaceFormulaStr(resultFormFieldBean, formulaType, forumlaStr, form, cacheMasterData, subDataBean == null ? 0L : subDataBean.getId(), params);
                params.put("formulaType", formulaType);
                errorFormulaStr = "\u6570\u636e\uff1a" + cacheMasterData.getId() + " \u5b57\u6bb5\uff1a" + resultFormFieldBean.getName() + resultFormFieldBean.getDisplay() + " forumlaStr:" + forumlaStr;
                value = FormulaUtil.doResult((String)forumlaStr, (Map)params);
                value = FormUtil.formatCalcValue((com.seeyon.cap4.form.bean.FormFieldBean)resultFormFieldBean, (Object)value, (String)formulaType);
                Object oldVal = dataBean.getFieldValue(resultFormFieldBean.getName());
                if (null == oldVal) {
                    oldVal = "";
                }
                if (!String.valueOf(value).equals(String.valueOf(oldVal))) {
                    isChange = true;
                }
                if (this.isPreRow(resultFormFieldBean) && "".equals(value)) {
                    isChange = false;
                }
                if (isChange) {
                    dataBean.addFieldValue(resultFormFieldBean.getName(), value, true, fillBackFields);
                }
            }
            if (isChange) {
                if (resultFormFieldBean.isMasterField()) {
                    this.calcAllWithFieldIn(form, resultFormFieldBean, cacheMasterData, null, fillBackFields, authViewBean, needDealSysRelation);
                } else {
                    this.calcAllWithFieldIn(form, resultFormFieldBean, cacheMasterData, subDataBean, fillBackFields, authViewBean, needDealSysRelation);
                }
            }
        }
        catch (StackOverflowError e) {
            LOGGER.error((Object)(errorFormulaStr + "  " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)(errorFormulaStr + "  " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Set<String> calcAll(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean masterData, FormAuthViewBean auth, boolean needFillBack, boolean needCalSN, boolean needDealSysRelation, boolean dealDefaultVal) throws BusinessException {
        Long start = System.currentTimeMillis();
        HashSet<String> fillBackFields = null;
        if (needFillBack) {
            fillBackFields = new HashSet<String>();
        }
        HashMap changeTag = null;
        Object o = AppContext.getThreadContext((String)"fieldChangeTag");
        if (null != o) {
            changeTag = (HashMap)o;
        } else {
            changeTag = new HashMap();
            AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
        }
        HashMap<String, Object> routeMap = new HashMap<String, Object>();
        try {
            FormTableBean masterTableBean = formBean.getMasterTableBean();
            List masterFields = masterTableBean.getFields();
            for (com.seeyon.cap4.form.bean.FormFieldBean field : masterFields) {
                this.calc(formBean, masterData, auth, field, null, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
            }
            Map subDataBeans = masterData.getSubTables();
            for (String tName : subDataBeans.keySet()) {
                FormTableBean subTableBean;
                List subFields;
                List subRows = (List)subDataBeans.get(tName);
                if (null == subRows || subRows.size() <= 0 || (subFields = (subTableBean = formBean.getTableByTableName(tName)).getFields()).size() <= 0) continue;
                for (FormDataSubBean subRow : subRows) {
                    for (com.seeyon.cap4.form.bean.FormFieldBean subField : subFields) {
                        this.calc(formBean, masterData, auth, subField, subRow, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                    }
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            AppContext.removeThreadContext((String)"fieldChangeTag");
        }
        Long end = System.currentTimeMillis();
        LOGGER.info((Object)("\u6570\u636e:" + masterData.getId() + " calcAll\u603b\u65f6\u95f4\uff1a" + (end - start)));
        return fillBackFields;
    }

    private void calc(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean data, FormAuthViewBean auth, com.seeyon.cap4.form.bean.FormFieldBean resultField, FormDataSubBean subData, Map<String, Object> routeMap, Set<String> fillBackFields, boolean dealDefaultVal, boolean needCalSN, boolean needDealSysRelation) throws BusinessException {
        String routeKey;
        boolean currentIsMaster = resultField.isMasterField();
        String fieldName = resultField.getName();
        if (!currentIsMaster && null == subData || currentIsMaster && null == data) {
            LOGGER.error((Object)("\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5calc\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff0c\u5f53\u524d\u8ba1\u7b97\u7ed3\u679c\u5b57\u6bb5\u662f" + (currentIsMaster ? "\u4e3b\u8868" : "\u660e\u7ec6\u8868") + "\u5b57\u6bb5\uff0c\u4f46\u662f\u4f20\u5165\u7684\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
            if (!routeMap.containsKey(fieldName)) {
                routeMap.put(fieldName, null);
            }
            return;
        }
        String string = routeKey = currentIsMaster ? fieldName : subData.generageFillbackKey(fieldName);
        if (!routeMap.containsKey(routeKey)) {
            boolean isCalcResultField;
            FormRelation relation;
            FormDataMasterBean currentData;
            routeMap.put(routeKey, null);
            Object object = currentData = currentIsMaster ? data : subData;
            if (dealDefaultVal && null != auth) {
                this.dealFieldDefaultVal((FormDataBean)currentData, auth, needCalSN, resultField, fillBackFields);
            }
            if ((relation = resultField.getFormRelation()) != null) {
                com.seeyon.cap4.form.bean.FormFieldBean fromFieldBean = formBean.getFieldBeanByName(relation.getToRelationAttr());
                this.calc(formBean, data, auth, fromFieldBean, subData, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                if (resultField.getInputTypeEnum().getKey().equals(FormFieldComEnum.SELECT.getKey())) {
                    AppContext.putThreadContext((String)"isFrom", (Object)"calcAll");
                    this.cap4FormRelationActionManager.dealEnumRelation(formBean, data, auth, resultField, subData, fillBackFields, needDealSysRelation, null);
                    AppContext.removeThreadContext((String)"isFrom");
                } else if (this.cap4FormRelationActionManager.getInnerRelationValueChanged(fromFieldBean, subData) || Boolean.TRUE.equals(data.getExtraAttr("waitSendByBackOrRepeal"))) {
                    com.seeyon.cap4.form.bean.FormFieldBean toFormFieldBean = formBean.getFieldBeanByName(relation.getToRelationAttr());
                    AppContext.putThreadContext((String)"isFrom", (Object)"calcAll");
                    this.cap4FormRelationActionManager.dealRelationByType(formBean, data, auth, resultField, subData, fillBackFields, toFormFieldBean.getPossibleRelationAttrType(), needDealSysRelation);
                    AppContext.removeThreadContext((String)"isFrom");
                }
            }
            if (needDealSysRelation && this.cap4FormRelationActionManager.isSysRelation(formBean.getId(), resultField.getName())) {
                List<FormRelationshipBean> formRelationshipBeans = this.cap4FormRelationActionManager.getValidFormRelationshipBeansByMappingFieldName(formBean.getId(), fieldName, FormRelationEnums.ViewSelectType.system);
                block0: for (FormRelationshipBean formRelationshipBean : formRelationshipBeans) {
                    FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
                    Map<String, String> conditionFields = this.cap4FormRelationActionManager.getRelationFormulaFieldMap(formRelationshipMapBean.getConditionFormula());
                    for (String string2 : conditionFields.keySet()) {
                        com.seeyon.cap4.form.bean.FormFieldBean conditionFieldBean = formBean.getFieldBeanByName(string2);
                        if (conditionFieldBean.isMasterField()) {
                            this.calc(formBean, data, auth, conditionFieldBean, subData, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                            continue;
                        }
                        List subDatas = (List)data.getSubTables().get(conditionFieldBean.getOwnerTableName());
                        if (subDatas == null) continue;
                        for (FormDataSubBean tempSubData : subDatas) {
                            this.calc(formBean, data, auth, conditionFieldBean, tempSubData, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                        }
                    }
                    Map changeFields = (Map)AppContext.getThreadContext((String)"fieldChangeTag");
                    for (String conditionField3 : conditionFields.keySet()) {
                        com.seeyon.cap4.form.bean.FormFieldBean conditionFieldBean = formBean.getFieldBeanByName(conditionField3);
                        Map changeField = (Map)changeFields.get(conditionFieldBean.getOwnerTableName());
                        boolean hasContainField = false;
                        if (changeField != null) {
                            Object c;
                            if (conditionFieldBean.isMasterField()) {
                                c = (Boolean)changeField.get(conditionField3);
                                hasContainField = c != null && ((Boolean)c).equals(true);
                            } else if (subData != null) {
                                c = (Boolean)changeField.get(subData.generageFillbackKey(conditionField3));
                                hasContainField = c != null && ((Boolean)c).equals(true);
                            } else {
                                for (String changeFieldName : changeField.keySet()) {
                                    if (!changeFieldName.startsWith(conditionField3)) continue;
                                    hasContainField = true;
                                    break;
                                }
                            }
                        }
                        if (!hasContainField && !this.cap4FormRelationActionManager.forceDealSysRelation(resultField, auth, formRelationshipBean)) continue;
                        AppContext.putThreadContext((String)"isFrom", (Object)"calcAll");
                        this.cap4FormRelationActionManager.dealSysRelationByShipBean(data, subData, fillBackFields, formRelationshipBean);
                        AppContext.removeThreadContext((String)"isFrom");
                        Map formRelationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
                        for (String fromField : formRelationFieldMap.keySet()) {
                            com.seeyon.cap4.form.bean.FormFieldBean tempField = formBean.getFieldBeanByName(fromField);
                            if (tempField.isMasterField()) {
                                routeMap.put(fromField, null);
                                continue;
                            }
                            if (subData == null) {
                                routeMap.put(fromField, null);
                                continue;
                            }
                            routeMap.put(subData.generageFillbackKey(fromField), null);
                        }
                        continue block0;
                    }
                }
            }
            boolean bl = isCalcResultField = !Strings.isEmpty((Collection)resultField.getFormConditionList());
            if (isCalcResultField) {
                Set inFormulaFields = resultField.getInFormulaFields();
                for (com.seeyon.cap4.form.bean.FormFieldBean tempField : inFormulaFields) {
                    boolean tempFieldIsmaster = tempField.isMasterField();
                    if (currentIsMaster && tempFieldIsmaster || !currentIsMaster && tempFieldIsmaster || !currentIsMaster && !tempFieldIsmaster) {
                        this.calc(formBean, data, auth, tempField, subData, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                        continue;
                    }
                    if (!currentIsMaster || tempFieldIsmaster) continue;
                    String subTableName = tempField.getOwnerTableName();
                    List list = (List)data.getSubTables().get(subTableName);
                    for (FormDataSubBean tempSubData : list) {
                        this.calc(formBean, data, auth, tempField, tempSubData, routeMap, fillBackFields, dealDefaultVal, needCalSN, needDealSysRelation);
                    }
                }
                String formulaType = FormulaEnums.getFormulaTypeByFieldType((String)resultField.getFieldType());
                FormFormulaBean formulaBean = this.getFormFormulaBean(formBean, data, resultField, subData, currentIsMaster);
                if (null == formulaBean) {
                    return;
                }
                String forumlaStr = formulaBean.getExecuteFormulaForGroove();
                Map param = data.getFormulaMap(formulaType);
                param.put("formDataBean", data);
                param.put("formBean", formBean);
                if (!currentIsMaster && null != subData) {
                    param.putAll(subData.getFormulaMap(formulaType));
                    param.put("subDataBean", subData);
                }
                forumlaStr = this.replaceFormulaStr(resultField, formulaType, forumlaStr, formBean, data, subData == null ? 0L : subData.getId(), param);
                param.put("formulaType", formulaType);
                Object object3 = FormulaUtil.doResult((String)forumlaStr, (Map)param);
                object3 = FormUtil.formatCalcValue((com.seeyon.cap4.form.bean.FormFieldBean)resultField, (Object)object3, (String)formulaType);
                if (!currentIsMaster) {
                    subData.addFieldValue(fieldName, object3, true, fillBackFields);
                } else {
                    data.addFieldValue(fieldName, object3, true, fillBackFields);
                }
            }
            routeMap.put(routeKey, data.getFieldValue(fieldName));
            if (!currentData.containsField(fieldName)) {
                currentData.addFieldValue(fieldName, null, false, fillBackFields);
            }
        }
    }

    private FormFormulaBean getFormFormulaBean(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean data, com.seeyon.cap4.form.bean.FormFieldBean resultField, FormDataSubBean subData, boolean currentIsMaster) throws BusinessException {
        boolean isOrdinaryFormula = resultField.isOrdinaryFormula();
        FormFormulaBean formulaBean = null;
        if (isOrdinaryFormula) {
            formulaBean = resultField.getFormulaBean(null);
        } else {
            Map conditionMap = data.getFormulaMap("componentType_condition");
            conditionMap.put("formDataBean", data);
            conditionMap.put("formBean", formBean);
            if (!currentIsMaster && null != subData) {
                conditionMap.putAll(subData.getFormulaMap("componentType_condition"));
            }
            formulaBean = resultField.getFormulaBean(conditionMap);
        }
        return formulaBean;
    }

    @Override
    public void procFieldDefaultVal(FormDataBean formData, FormAuthViewBean auth, boolean needCalSN, com.seeyon.cap4.form.bean.FormFieldBean field) throws BusinessException {
        this.dealFieldDefaultVal(formData, auth, needCalSN, field, null);
    }

    private void dealFieldDefaultVal(FormDataBean formData, FormAuthViewBean auth, boolean needCalSN, com.seeyon.cap4.form.bean.FormFieldBean field, Set<String> fillBackFields) throws BusinessException {
        String fieldName = field.getName();
        FormAuthViewFieldBean fieldAuth = auth.getFormAuthorizationField(fieldName);
        if (fieldAuth != null) {
            Object value = formData.getFieldValue(fieldName);
            boolean forceDefault = fieldAuth.getIsInitNull() == 1;
            boolean isSerialField = fieldAuth.isSerialNumberDefaultValue();
            if (forceDefault || needCalSN && isSerialField || fieldAuth.getDefaultValue() != null && value == null && Strings.isNotBlank((String)fieldAuth.getAccess()) && !fieldAuth.getAccess().equals(Enums.FieldAccessType.design.getKey()) && !isSerialField) {
                String[] defaultValue = fieldAuth.getValue();
                if (forceDefault || !StringUtil.checkNull((String)String.valueOf(defaultValue[0]))) {
                    value = defaultValue[0];
                    formData.addFieldValue(fieldName, field.getDefaultVal4Db(value), fillBackFields);
                }
                if (needCalSN && isSerialField && StringUtil.checkNull((String)String.valueOf(value))) {
                    String serialValue = this.cap4SerialNumberManager.getSerialNumber(fieldAuth);
                    if (FormFieldComEnum.TEXTAREA != field.getInputTypeEnum() && serialValue.length() > field.getMaxLength(false)) {
                        value = serialValue.substring(0, field.getMaxLength(true));
                        formData.addFieldValue(fieldName, field.getDefaultVal4Db(value), fillBackFields);
                    } else {
                        value = serialValue;
                        formData.addFieldValue(fieldName, field.getDefaultVal4Db(value), fillBackFields);
                    }
                    LOGGER.info((Object)("\u5b57\u6bb5\uff1a" + field.getDisplay() + "(" + fieldName + ")\u901a\u8fc7\u6743\u9650:" + auth.getName() + "(" + auth.getId() + ")\u4ea7\u751f\u6d41\u6c34\u53f7 : " + formData.getFieldValue(fieldName)));
                }
            }
        }
    }

    private String replaceFormulaStr(com.seeyon.cap4.form.bean.FormFieldBean resultField, String formulaType, String forumlaStr, com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean cacheMasterData, Long recordId, Map<String, Object> param) throws BusinessException {
        int hasSN;
        if (formulaType.equals("formulaType_varchar")) {
            String[] strs;
            for (String str : strs = forumlaStr.split("\\+")) {
                com.seeyon.cap4.form.bean.FormFieldBean field = formBean.getFieldBeanByName(str = str.trim());
                if (field == null) continue;
                Object val = null;
                val = field.isMasterField() ? cacheMasterData.getFieldValue(str) : cacheMasterData.getSubDataMapById(field.getOwnerTableName(), recordId).get(field.getName());
                String valueStr = String.valueOf(field.getDisplayValue(val, false)[1]);
                valueStr = valueStr.replace("\\", "\\\\").replace("'", "\\'");
                valueStr = valueStr.replaceAll("\r", "@@SEEYON_V5_huiche@@");
                if ((valueStr = valueStr.replaceAll("\n", "@@SEEYON_V5_huanghang@@")).contains("script")) {
                    valueStr = valueStr.replaceAll("script", "@seeyon_script");
                }
                param.put(field.getName(), valueStr);
            }
            if (forumlaStr.indexOf(FormulaEnums.FunctionSymbol.to_date.getKey()) >= 0) {
                Matcher matcher = toDatePattern.matcher(forumlaStr);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String group1 = matcher.group(1);
                    matcher.appendReplacement(sb, group1);
                }
                matcher.appendTail(sb);
                forumlaStr = sb.toString();
            }
        }
        if ((hasSN = forumlaStr.indexOf(FormulaEnums.DataFieldType.serialNumber.getKey())) >= 0) {
            String tempSerialData = null;
            tempSerialData = resultField.isMasterField() ? resultField.getName() + "_" + formBean.getId() + "_" + cacheMasterData.getId() + "_" + "0" : resultField.getName() + "_" + formBean.getId() + "_" + cacheMasterData.getId() + "_" + recordId;
            AppContext.putThreadContext((String)"serialCalFunctionKey", (Object)tempSerialData);
        }
        return forumlaStr;
    }

    @Override
    public void calcAllWithFieldIn(com.seeyon.cap4.form.bean.FormBean form, com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, FormDataMasterBean cacheMasterData, FormDataSubBean formDataSubBean, Set<String> fillBackFields, FormAuthViewBean authViewBean, boolean needDealSysRelation) throws BusinessException {
        try {
            Long recordId = formDataSubBean == null ? 0L : formDataSubBean.getId();
            String changeFieldName = formFieldBean.getName();
            List allFields = form.getAllFieldBeans();
            for (com.seeyon.cap4.form.bean.FormFieldBean tempFormField : allFields) {
                List subDataBeans;
                List actions = tempFormField.getFormConditionList();
                if (actions == null || actions.size() <= 0 || !FormulaUtil.isFieldExistFormula((List)actions, (String)changeFieldName) || changeFieldName.equalsIgnoreCase(tempFormField.getName())) continue;
                if (tempFormField.isMasterField()) {
                    this.calc4EditingForm(form, tempFormField, cacheMasterData, formDataSubBean, fillBackFields, authViewBean, needDealSysRelation);
                    continue;
                }
                if (recordId != null && recordId != -1L && recordId != 0L) {
                    if (this.isPreRow(tempFormField)) {
                        subDataBeans = cacheMasterData.getSubData(tempFormField.getOwnerTableName());
                        for (FormDataSubBean subDataBean : subDataBeans) {
                            this.calc4EditingForm(form, tempFormField, cacheMasterData, subDataBean, fillBackFields, authViewBean, needDealSysRelation);
                        }
                        continue;
                    }
                    this.calc4EditingForm(form, tempFormField, cacheMasterData, formDataSubBean, fillBackFields, authViewBean, needDealSysRelation);
                    continue;
                }
                subDataBeans = cacheMasterData.getSubData(tempFormField.getOwnerTableName());
                if (subDataBeans == null) continue;
                for (FormDataSubBean subDataBean : subDataBeans) {
                    this.calc4EditingForm(form, tempFormField, cacheMasterData, subDataBean, fillBackFields, authViewBean, needDealSysRelation);
                }
            }
            if (formFieldBean.isInInnerRelation()) {
                if (formFieldBean.getInputTypeEnum().getKey().equals(FormFieldComEnum.SELECT.getKey())) {
                    this.cap4FormRelationActionManager.dealEnumRelation(form, cacheMasterData, authViewBean, formFieldBean, formDataSubBean, fillBackFields, needDealSysRelation, null);
                } else {
                    this.cap4FormRelationActionManager.dealRelationByType(form, cacheMasterData, authViewBean, formFieldBean, formDataSubBean, fillBackFields, formFieldBean.getPossibleRelationAttrType(), needDealSysRelation);
                }
            }
            if (formFieldBean.isInRelationCondition() && (needDealSysRelation || fillBackFields != null && fillBackFields.contains(formFieldBean.isSubField() && formDataSubBean != null ? formDataSubBean.generageFillbackKey(formFieldBean.getName()) : cacheMasterData.generageFillbackKey(formFieldBean.getName()))) && !"true".equals(String.valueOf(AppContext.getThreadContext((String)"ignoreFillMasterField")))) {
                this.cap4FormRelationActionManager.dealSysRelation(form, cacheMasterData, authViewBean, formFieldBean, formDataSubBean, fillBackFields);
            }
        }
        catch (StackOverflowError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(ResourceUtil.getString((String)"form.data.formula.calc.error.label"));
        }
    }

    private FormAuthViewBean getOriginalAuthViewBean(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean) {
        FormAuthViewBean originalAuth = null;
        HashMap apartAuthMap = null;
        HashMap subTableAuthMap = null;
        if (formAuthViewBean == null) {
            apartAuthMap = new HashMap();
            subTableAuthMap = new HashMap();
            formDataMasterBean.getExtraMap().put(APART_AUTH_MAP, apartAuthMap);
            formDataMasterBean.getExtraMap().put(SUB_TABLE_AUTH_MAP, subTableAuthMap);
            return originalAuth;
        }
        Long pid = formAuthViewBean.getParentId();
        originalAuth = pid != null && pid != 0L && !formAuthViewBean.isApartSetAuth() ? formBean.getAuthViewBeanById(pid) : formAuthViewBean;
        if (originalAuth.getAdvanceAuthType() == -1) {
            apartAuthMap = new HashMap();
            subTableAuthMap = new HashMap();
            formDataMasterBean.getExtraMap().put(APART_AUTH_MAP, apartAuthMap);
            formDataMasterBean.getExtraMap().put(SUB_TABLE_AUTH_MAP, subTableAuthMap);
            originalAuth = null;
            return originalAuth;
        }
        if (formDataMasterBean.getExtraAttr(APART_AUTH_MAP) == null) {
            apartAuthMap = new HashMap();
            formDataMasterBean.getExtraMap().put(APART_AUTH_MAP, apartAuthMap);
        }
        if (formDataMasterBean.getExtraAttr(SUB_TABLE_AUTH_MAP) == null) {
            subTableAuthMap = new HashMap();
            formDataMasterBean.getExtraMap().put(SUB_TABLE_AUTH_MAP, subTableAuthMap);
        }
        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
        Object formViewType = formDataMasterBean.getExtraMap().get("formViewType");
        if (formViewType == null) {
            formDataMasterBean.getExtraMap().put("formViewType", formViewBean.getFormViewType());
        } else if (!String.valueOf(formViewType).equals(formViewBean.getFormViewType())) {
            apartAuthMap = new HashMap();
            subTableAuthMap = new HashMap();
            formDataMasterBean.getExtraMap().put(APART_AUTH_MAP, apartAuthMap);
            formDataMasterBean.getExtraMap().put("formViewType", formViewBean.getFormViewType());
            formDataMasterBean.getExtraMap().put(SUB_TABLE_AUTH_MAP, subTableAuthMap);
        }
        return originalAuth;
    }

    @Override
    public Map<String, Object> dealFormRightChangeResult(com.seeyon.cap4.form.bean.FormBean formBean, FormAuthViewBean oldFormAuthViewBean, FormDataMasterBean formDataMasterBean, boolean needCalc) throws NumberFormatException, BusinessException {
        HashMap<String, Object> auths;
        block13: {
            Object subMap;
            List fieldBeenList;
            auths = new HashMap<String, Object>();
            FormAuthViewBean originalAuth = this.getOriginalAuthViewBean(formBean, formDataMasterBean, oldFormAuthViewBean);
            Map apartAuthMap = (Map)formDataMasterBean.getExtraAttr(APART_AUTH_MAP);
            Map subTableAuthMap = (Map)formDataMasterBean.getExtraAttr(SUB_TABLE_AUTH_MAP);
            auths.put(APART_AUTH_MAP, apartAuthMap);
            auths.put(SUB_TABLE_AUTH_MAP, subTableAuthMap);
            if (!needCalc || originalAuth == null) break block13;
            Map formMasterFormulaMap = formDataMasterBean.getFormulaMap("componentType_condition");
            FormAuthViewBean newFormAuthViewBean = oldFormAuthViewBean.isApartSetAuth() ? originalAuth : this.getRightFormAuthViewBean(originalAuth, formMasterFormulaMap);
            formDataMasterBean.putExtraAttr("viewRight", (BasePO)newFormAuthViewBean);
            List subTableBeans = formBean.getSubTableBean();
            for (Object subTableBean : subTableBeans) {
                FormAuthorizationTableBean formAuthorizationTableBean = newFormAuthViewBean.getSubTableAuth(subTableBean.getDisplay());
                subTableAuthMap.put(subTableBean.getTableName(), formAuthorizationTableBean);
            }
            if (oldFormAuthViewBean.getId().longValue() != newFormAuthViewBean.getId().longValue() || oldFormAuthViewBean.isApartSetAuth()) {
                fieldBeenList = formBean.getMasterTableBean().getFields();
                for (Object fieldBean : fieldBeenList) {
                    FormAuthViewFieldBean oldFormAuthViewFieldBean;
                    if (oldFormAuthViewBean.isApartSetAuth()) {
                        List subAuthConditions = newFormAuthViewBean.getConditionFieldAuthList(fieldBean.getName());
                        if (!Strings.isNotEmpty((Collection)subAuthConditions)) continue;
                        FormAuthViewFieldBean advanceFieldAuthBean = this.getFormAuthorizationField(newFormAuthViewBean, fieldBean.getName(), formMasterFormulaMap);
                        FormAuthViewFieldBean cacheAuth = (FormAuthViewFieldBean)apartAuthMap.get(fieldBean.getName());
                        if (cacheAuth != null && cacheAuth.getAccess().equals(advanceFieldAuthBean.getAccess()) && cacheAuth.getIsNotNull() == advanceFieldAuthBean.getIsNotNull()) continue;
                        apartAuthMap.put(fieldBean.getName(), advanceFieldAuthBean);
                        continue;
                    }
                    FormAuthViewFieldBean formAuthViewFieldBean = newFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                    FormAuthViewFieldBean cacheAuth = (FormAuthViewFieldBean)apartAuthMap.get(fieldBean.getName());
                    FormAuthViewFieldBean formAuthViewFieldBean2 = oldFormAuthViewFieldBean = cacheAuth == null ? oldFormAuthViewBean.getFormAuthorizationField(fieldBean.getName()) : cacheAuth;
                    if (oldFormAuthViewFieldBean.getAccess().equals(formAuthViewFieldBean.getAccess()) && oldFormAuthViewFieldBean.getIsNotNull() == formAuthViewFieldBean.getIsNotNull()) continue;
                    apartAuthMap.put(fieldBean.getName(), formAuthViewFieldBean);
                }
                subMap = formDataMasterBean.getSubTables();
                for (FormTableBean subTable : formBean.getSubTableBean()) {
                    List subDataLine = (List)subMap.get(subTable.getTableName());
                    if (subDataLine == null || subDataLine.size() <= 0) continue;
                    List subFieldList = subTable.getFields();
                    for (FormDataSubBean tempFormDataSubBean : subDataLine) {
                        Map subFormulaMap = tempFormDataSubBean.getFormulaMap("componentType_condition");
                        for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : subFieldList) {
                            FormAuthViewFieldBean oldFormAuthViewFieldBean;
                            String authKey = fieldBean.getName() + "_" + tempFormDataSubBean.getId();
                            if (oldFormAuthViewBean.isApartSetAuth()) {
                                formMasterFormulaMap.putAll(subFormulaMap);
                                List subAuthConditions = newFormAuthViewBean.getConditionFieldAuthList(fieldBean.getName());
                                if (!Strings.isNotEmpty((Collection)subAuthConditions)) continue;
                                FormAuthViewFieldBean advanceFieldAuthBean = this.getFormAuthorizationField(newFormAuthViewBean, fieldBean.getName(), formMasterFormulaMap);
                                FormAuthViewFieldBean cacheAuth = (FormAuthViewFieldBean)apartAuthMap.get(authKey);
                                if (cacheAuth != null && cacheAuth.getAccess().equals(advanceFieldAuthBean.getAccess()) && cacheAuth.getIsNotNull() == advanceFieldAuthBean.getIsNotNull()) continue;
                                apartAuthMap.put(authKey, advanceFieldAuthBean);
                                continue;
                            }
                            FormAuthViewFieldBean formAuthViewFieldBean = newFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                            FormAuthViewFieldBean cacheAuth = (FormAuthViewFieldBean)apartAuthMap.get(authKey);
                            FormAuthViewFieldBean formAuthViewFieldBean3 = oldFormAuthViewFieldBean = cacheAuth == null ? oldFormAuthViewBean.getFormAuthorizationField(fieldBean.getName()) : cacheAuth;
                            if (oldFormAuthViewFieldBean.getAccess().equalsIgnoreCase(formAuthViewFieldBean.getAccess()) && oldFormAuthViewFieldBean.getIsNotNull() == formAuthViewFieldBean.getIsNotNull()) continue;
                            apartAuthMap.put(authKey, formAuthViewFieldBean);
                        }
                    }
                }
            } else {
                fieldBeenList = formBean.getMasterTableBean().getFields();
                for (Object fieldBean : fieldBeenList) {
                    FormAuthViewFieldBean oldFormAuthViewFieldBean = oldFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                    FormAuthViewFieldBean formAuthViewFieldBean = newFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                    if (oldFormAuthViewFieldBean.getAccess().equalsIgnoreCase(formAuthViewFieldBean.getAccess()) && oldFormAuthViewFieldBean.getIsNotNull() == formAuthViewFieldBean.getIsNotNull()) continue;
                    apartAuthMap.put(fieldBean.getName(), formAuthViewFieldBean);
                }
                subMap = formDataMasterBean.getSubTables();
                for (FormTableBean subTable : formBean.getSubTableBean()) {
                    List subDataLine = (List)subMap.get(subTable.getTableName());
                    if (subDataLine == null || subDataLine.size() <= 0) continue;
                    List subFieldList = subTable.getFields();
                    for (FormDataSubBean tempFormDataSubBean : subDataLine) {
                        for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : subFieldList) {
                            String authKey = fieldBean.getName() + "_" + tempFormDataSubBean.getId();
                            FormAuthViewFieldBean formAuthViewFieldBean = newFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                            FormAuthViewFieldBean oldFormAuthViewFieldBean = oldFormAuthViewBean.getFormAuthorizationField(fieldBean.getName());
                            if (oldFormAuthViewFieldBean.getAccess().equalsIgnoreCase(formAuthViewFieldBean.getAccess()) && oldFormAuthViewFieldBean.getIsNotNull() == formAuthViewFieldBean.getIsNotNull()) continue;
                            apartAuthMap.put(authKey, formAuthViewFieldBean);
                        }
                    }
                }
            }
        }
        return auths;
    }

    private FormAuthViewBean getRightFormAuthViewBean(FormAuthViewBean formAuthViewBean, Map<String, Object> dataMap) throws BusinessException {
        Object value;
        FormAuthViewBean conditionAuth = null;
        if (formAuthViewBean.getParentId() == 0L && !formAuthViewBean.isApartSetAuth() && (value = FormulaUtil.doResult((String)FormulaUtil.getConditionFormulaStr((List)formAuthViewBean.getFormConditionActionBeanList()), dataMap)) != null) {
            conditionAuth = formAuthViewBean.getConditonFormAuthViewBean(Long.valueOf(Long.parseLong(value + "")));
            CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
            capFormManager.addRightId(conditionAuth.getId());
            return conditionAuth;
        }
        return formAuthViewBean;
    }

    private String getFieldFinalAccess(com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, String access) {
        if ((Enums.FieldAccessType.add.getKey().equals(access) || Enums.FieldAccessType.edit.getKey().equals(access)) && formFieldBean.isCalcField()) {
            return Enums.FieldAccessType.browse.getKey();
        }
        return access;
    }

    @Override
    public void mergeFormData(FormDataMasterBean masterData, FormDataMasterBean cacheData, com.seeyon.cap4.form.bean.FormBean fb) {
        Object subTableName;
        Map masterDataMap = masterData.getRowData();
        for (Map.Entry objEntry : masterDataMap.entrySet()) {
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName((String)objEntry.getKey());
            if (ffb != null) {
                cacheData.addFieldValue((String)objEntry.getKey(), objEntry.getValue());
            }
            if (ffb != null || !"unique_MD5".equals(objEntry.getKey())) continue;
            cacheData.addFieldValue((String)objEntry.getKey(), objEntry.getValue());
        }
        Map frontSubDataMapList = masterData.getSubTables();
        Map cacheSubDataMapList = cacheData.getSubTables();
        HashMap delMap = null;
        for (Map.Entry cacheDataEntry : cacheSubDataMapList.entrySet()) {
            subTableName = (String)cacheDataEntry.getKey();
            List cacheSubDataList = (List)cacheDataEntry.getValue();
            List frontSubDataList = (List)frontSubDataMapList.get(subTableName);
            List cacheNotShowSubDataIds = cacheData.getNotShowSubDataIds((String)subTableName);
            if (frontSubDataList == null) continue;
            boolean hasEqualsData = false;
            for (FormDataSubBean cacheSubLineData : cacheSubDataList) {
                for (FormDataSubBean frontSubLineData : frontSubDataList) {
                    hasEqualsData = cacheSubLineData.getId().longValue() == frontSubLineData.getId().longValue();
                    if (!hasEqualsData) continue;
                    break;
                }
                if (hasEqualsData) continue;
                if (delMap == null) {
                    delMap = new HashMap();
                }
                if (delMap.get(subTableName) == null) {
                    delMap.put(subTableName, new ArrayList());
                }
                if (cacheNotShowSubDataIds != null && cacheNotShowSubDataIds.contains(cacheSubLineData.getId())) continue;
                ((List)delMap.get(subTableName)).add(cacheSubLineData);
            }
        }
        if (delMap != null && delMap.size() > 0) {
            for (Map.Entry delEntry : delMap.entrySet()) {
                for (FormDataSubBean delSubBean : (List)delEntry.getValue()) {
                    ((List)cacheSubDataMapList.get(delEntry.getKey())).remove(delSubBean);
                }
            }
        }
        for (Map.Entry frontDataEntry : frontSubDataMapList.entrySet()) {
            subTableName = (String)frontDataEntry.getKey();
            List frontSubDataList = (List)frontDataEntry.getValue();
            ArrayList<FormDataSubBean> cacheSubDataList = (ArrayList<FormDataSubBean>)cacheSubDataMapList.get(subTableName);
            int i = 0;
            for (FormDataSubBean frontSubLineData : frontSubDataList) {
                boolean hasEqualsData = false;
                if (cacheSubDataList == null) {
                    cacheSubDataList = new ArrayList<FormDataSubBean>();
                    cacheSubDataMapList.put(subTableName, cacheSubDataList);
                }
                for (FormDataSubBean cacheSubLineData : cacheSubDataList) {
                    hasEqualsData = cacheSubLineData.getId().longValue() == frontSubLineData.getId().longValue();
                    if (!hasEqualsData) continue;
                    Map frontRowDataMap = frontSubLineData.getRowData();
                    for (Map.Entry entry : frontRowDataMap.entrySet()) {
                        cacheSubLineData.addFieldValue((String)entry.getKey(), entry.getValue());
                    }
                }
                if (!hasEqualsData) {
                    cacheSubDataList.add(i, frontSubLineData);
                }
                ++i;
            }
        }
    }

    private boolean isPreRow(com.seeyon.cap4.form.bean.FormFieldBean resultBean) {
        boolean isPreRow = false;
        List fcabs = resultBean.getFormConditionList();
        if (fcabs != null && fcabs.size() > 0) {
            block0: for (FormConditionActionBean fcab : fcabs) {
                if (isPreRow) break;
                List cfs = fcab.getAllFormulaList();
                for (CtpFormula cf : cfs) {
                    String expression = cf.getExpression();
                    if (expression == null || expression.replaceAll(" ", "").indexOf(FormulaEnums.FunctionSymbol.preRow.getKey() + "(") <= -1) continue;
                    isPreRow = true;
                    continue block0;
                }
            }
        }
        return isPreRow;
    }

    @Override
    public boolean delFormData(Long formId, String ids, Long templateId) throws BusinessException, SQLException {
        return this.delFormData(formId, ids, templateId, true);
    }

    @Override
    public String setLock(Long formId, String ids, Long templateId) throws NumberFormatException, BusinessException, SQLException {
        String returnStr = "1";
        com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
        String[] id = ids.split(",");
        for (int j = 0; j < id.length; ++j) {
            String lockInfo = this.cap4FormManager.checkDataLockFormEdit(id[j], true, false);
            if (!Strings.isNotBlank((String)lockInfo)) continue;
            returnStr = ResourceUtil.getString((String)"form.unflow.setLock.tips", (Object)(j + 1), (Object)lockInfo);
            return returnStr;
        }
        ArrayList<String> updateId = new ArrayList<String>();
        for (int j = 0; j < id.length; ++j) {
            if (StringUtil.checkNull((String)id[j])) continue;
            updateId.add(id[j]);
        }
        if (updateId.size() > 0) {
            Date dateQueryStart = new Date();
            String updateIds = StringUtils.join((Object[])updateId.toArray(), (String)",");
            this.cap4FormDataDAO.updateLockState(updateIds, fb.getMasterTableBean().getTableName(), Enums.FormDataStateEnum.UNFLOW_LOCKED.getKey());
            LOGGER.info((Object)("setLockOrUnlock lock update query time " + (new Date().getTime() - dateQueryStart.getTime()) + "ms , params ids : " + updateIds));
        }
        return returnStr;
    }

    @Override
    public boolean unLock(Long formId, String ids, Long templateId) throws BusinessException, SQLException {
        com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
        String[] id = ids.split(",");
        ArrayList<String> updateId = new ArrayList<String>();
        for (int j = 0; j < id.length; ++j) {
            if (StringUtil.checkNull((String)id[j])) continue;
            updateId.add(id[j]);
        }
        if (updateId.size() > 0) {
            Date dateQueryStart = new Date();
            String updateIds = StringUtils.join((Object[])updateId.toArray(), (String)",");
            this.cap4FormDataDAO.updateLockState(updateIds, fb.getMasterTableBean().getTableName(), Enums.FormDataStateEnum.UNFLOW_UNLOCK.getKey());
            LOGGER.info((Object)("setLockOrUnlock lock update query time " + (new Date().getTime() - dateQueryStart.getTime()) + "ms , params ids : " + updateIds));
        }
        return true;
    }

    @Override
    public FlipInfo getFormMasterDataListByFormId(FlipInfo flipInfo, Map<String, Object> params, boolean forExport) throws BusinessException {
        Long formId = Long.parseLong(params.get("formId") + "");
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        String templateIdStr = String.valueOf(params.get("formTemplateId"));
        String auth = FormUtil.getUnflowFormAuth((com.seeyon.cap4.form.bean.FormBean)formBean, (String)templateIdStr);
        flipInfo = this.getFormDataList(flipInfo, params, formBean, false);
        flipInfo.setData(FormUtil.setShowValueList((com.seeyon.cap4.form.bean.FormBean)formBean, (String)auth, (List)flipInfo.getData(), (boolean)false, (boolean)forExport, (boolean)false));
        return flipInfo;
    }

    @Override
    public FlipInfo getFormDataList(FlipInfo flipInfo, Map<String, Object> params, com.seeyon.cap4.form.bean.FormBean formBean, boolean reverse) throws BusinessException {
        FormQueryResult queryResult = this.getFormDataQueryResult(flipInfo, params, formBean, reverse);
        return queryResult.getFlipInfo();
    }

    @Override
    public FormQueryResult getFormDataQueryResult(FlipInfo flipInfo, Map<String, Object> params, com.seeyon.cap4.form.bean.FormBean formBean, boolean reverse) throws BusinessException {
        Long currentUserId = AppContext.currentUserId();
        boolean isNeedPage = true;
        FormQueryTypeEnum queryType = FormQueryTypeEnum.infoManageQuery;
        FormQueryWhereClause customCondition = this.getCustomConditionFormQueryWhereClause(formBean, params);
        List customOrderBy = (List)params.get("userOrderBy");
        Set customShowFields = (Set)params.get("customShowFields");
        FormQueryWhereClause relationSqlWhereClause = this.getRelationConditionFormQueryWhereClause(formBean, params);
        List dataConditions = (List)params.get("dataConditions");
        FormQueryWhereClause dataConditionWhereCause = this.getFieldDataConditionFormQueryWhereClause(formBean, dataConditions, true);
        Long templeteId = Long.parseLong(Strings.isBlank((String)String.valueOf(params.get("formTemplateId") == null ? "" : params.get("formTemplateId"))) ? "0" : params.get("formTemplateId") + "");
        return this.getFormQueryResult(currentUserId, flipInfo, isNeedPage, formBean, templeteId, queryType, customCondition, customOrderBy, customShowFields, relationSqlWhereClause, dataConditionWhereCause, reverse);
    }

    @Override
    public FormQueryWhereClause getRelationConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> params) {
        try {
            String fromFormIdStr = ParamUtil.getString(params, (String)"fromFormId");
            if (Strings.isNotBlank((String)fromFormIdStr)) {
                com.seeyon.cap4.form.bean.FormFieldBean fromRelationAttr;
                FormDataMasterBean fromData;
                Long fromFormId = ParamUtil.getLong(params, (String)"fromFormId");
                Long fromRecordId = ParamUtil.getLong(params, (String)"fromRecordId");
                Long fromDataId = ParamUtil.getLong(params, (String)"fromDataId");
                String fromRelationAttrStr = ParamUtil.getString(params, (String)"fromRelationAttr");
                com.seeyon.cap4.form.bean.FormBean fromForm = this.cap4FormCacheManager.getForm(fromFormId);
                FormFormulaBean conditionFormFormulaBean = this.changeFormFormulaBean(fromForm, fromData = this.cap4FormManager.getSessioMasterDataBean(fromDataId), fromRecordId, fromRelationAttr = fromForm.getFieldBeanByName(fromRelationAttrStr));
                if (null != conditionFormFormulaBean) {
                    AppContext.putThreadContext((String)"isRelationCondition", (Object)true);
                    FormQueryWhereClause whereClause = conditionFormFormulaBean.getExecuteFormulaForWhereClauseSQL(formBean, true, true);
                    AppContext.removeThreadContext((String)"isRelationCondition");
                    String relationSql = whereClause.getAllSqlClause();
                    if (!StringUtil.checkNull((String)relationSql)) {
                        for (FormTableBean table : formBean.getTableList()) {
                            String tablePrefix = "b" + Functions.substringAfter((String)table.getTableName(), (String)"_");
                            if (relationSql.indexOf(tablePrefix) == -1) continue;
                            relationSql = relationSql.replace(tablePrefix, table.getTableName());
                        }
                    }
                    whereClause.setAllSqlClause(relationSql);
                    return whereClause;
                }
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"", (Throwable)e);
        }
        return null;
    }

    @Override
    public FormQueryWhereClause getCustomConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> customParams) {
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        StringBuilder sb = new StringBuilder("");
        ArrayList queryParams = new ArrayList();
        for (String key : customParams.keySet()) {
            if (customParams.get(key) == null || Strings.isBlank((String)String.valueOf(customParams.get(key))) || "sortStr".equals(key) || "formId".equals(key) || "formTemplateId".equals(key) || "fromFormId".equals(key) || "fromDataId".equals(key) || "fromRecordId".equals(key) || "fromRelationAttr".equals(key) || "userOrderBy".equals(key) || !"userConditions".equals(key)) continue;
            ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
            Object temO = customParams.get(key);
            if (temO instanceof Map) {
                tempList.add((Map)temO);
            } else {
                tempList.addAll((List)temO);
            }
            FormQueryWhereClause myWhereClause = this.getSQLStrWhereClause(tempList, formBean, true);
            if (null != myWhereClause && Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                sb.append(myWhereClause.getAllSqlClause());
            }
            if (null == myWhereClause || null == myWhereClause.getQueryParams() || myWhereClause.getQueryParams().isEmpty()) continue;
            queryParams.addAll(myWhereClause.getQueryParams());
        }
        whereClause.setQueryParams(queryParams);
        whereClause.setAllSqlClause(sb.toString());
        return whereClause;
    }

    private FormFormulaBean changeFormFormulaBean(com.seeyon.cap4.form.bean.FormBean fromForm, FormDataMasterBean fromData, Long fromRecordId, com.seeyon.cap4.form.bean.FormFieldBean fromRelationAttr) throws Exception {
        if (null == fromRelationAttr.getFormRelation() || null == fromRelationAttr.getFormRelation().getViewConditionId()) {
            return null;
        }
        String subTableName = fromRelationAttr.isSubField() ? fromRelationAttr.getOwnerTableName() : null;
        return this.changeFormFormulaBean(fromForm, fromData, fromRecordId, subTableName, fromRelationAttr.getFormRelation().getViewConditionId());
    }

    @Override
    public FormFormulaBean changeFormFormulaBean(com.seeyon.cap4.form.bean.FormBean fromForm, FormDataMasterBean fromData, Long fromRecordId, String subTableName, Long conditionId) throws Exception {
        if (conditionId == null || conditionId == 0L) {
            return null;
        }
        FormFormulaBean formFormulaBean = this.cap4FormCacheManager.loadFormFormulaBean(fromForm, conditionId);
        return this.changeFormFormulaBean(fromForm, fromData, fromRecordId, subTableName, formFormulaBean);
    }

    @Override
    public FormFormulaBean changeFormFormulaBean(com.seeyon.cap4.form.bean.FormBean fromForm, FormDataMasterBean fromData, Long fromRecordId, String subTableName, FormFormulaBean formFormulaBean) throws Exception {
        if (formFormulaBean == null) {
            return null;
        }
        FormFormulaBean conditionFormFormulaBean = (FormFormulaBean)formFormulaBean.clone();
        List formulaBaseBeans = conditionFormFormulaBean.getFormulaBeanList();
        ArrayList<FormFormulaBean.FormulaBaseBean> replaceFormulaBaseBeans = new ArrayList<FormFormulaBean.FormulaBaseBean>();
        String masterTableName = fromForm.getMasterTableBean().getTableName();
        String masterTablePre = "a" + Functions.substringAfter((String)masterTableName, (String)"_");
        subTableName = Strings.isBlank((String)subTableName) ? "" : subTableName;
        String subTablePre = Strings.isBlank((String)subTableName) ? "" : "a" + Functions.substringAfter((String)subTableName, (String)"_");
        for (FormFormulaBean.FormulaBaseBean formulaBaseBean : formulaBaseBeans) {
            if (formulaBaseBean instanceof FormFormulaBean.FormulaDataFieldBean) {
                FormFormulaBean.FormulaBaseBean changeBean = this.changeFormulaBaseBean(conditionFormFormulaBean, (FormFormulaBean.FormulaDataFieldBean)formulaBaseBean, fromForm, fromData, fromRecordId, masterTablePre, subTableName, subTablePre);
                replaceFormulaBaseBeans.add(changeBean);
                continue;
            }
            if (formulaBaseBean instanceof FormFormulaBean.FormulaFunctionBean) {
                List temp = ((FormFormulaBean.FormulaFunctionBean)formulaBaseBean).getList();
                ArrayList<FormFormulaBean.FormulaBaseBean> list = new ArrayList<FormFormulaBean.FormulaBaseBean>();
                for (FormFormulaBean.FormulaBaseBean tempBean : temp) {
                    if (tempBean instanceof FormFormulaBean.FormulaDataFieldBean) {
                        FormFormulaBean.FormulaBaseBean changeBean = this.changeFormulaBaseBean(conditionFormFormulaBean, (FormFormulaBean.FormulaDataFieldBean)tempBean, fromForm, fromData, fromRecordId, masterTablePre, subTableName, subTablePre);
                        list.add(changeBean);
                        continue;
                    }
                    list.add(tempBean);
                }
                ((FormFormulaBean.FormulaFunctionBean)formulaBaseBean).setList(list);
                replaceFormulaBaseBeans.add(formulaBaseBean);
                continue;
            }
            replaceFormulaBaseBeans.add(formulaBaseBean);
        }
        conditionFormFormulaBean.setFormulaBeanList(replaceFormulaBaseBeans);
        return conditionFormFormulaBean;
    }

    private FormFormulaBean.FormulaBaseBean changeFormulaBaseBean(FormFormulaBean formFormulaBean, FormFormulaBean.FormulaDataFieldBean formulaDataFieldBean, com.seeyon.cap4.form.bean.FormBean fromForm, FormDataMasterBean fromData, Long fromRecordId, String masterTablePre, String subTableName, String subTablePre) throws BusinessException {
        String value = formulaDataFieldBean.getValue();
        if (value.contains(masterTablePre) || Strings.isNotBlank((String)subTablePre) && value.contains(subTablePre)) {
            String fieldName = value.substring(value.indexOf(".") + 1, value.length());
            com.seeyon.cap4.form.bean.FormFieldBean field = fromForm.getFieldBeanByName(fieldName);
            if (field == null) {
                field = Enums.MasterTableField.getEnumByKey((String)fieldName).getFormFieldBean();
            }
            String fieldValue = "";
            if (field.isMasterField()) {
                fieldValue = this.formatSqlParm(field, (FormDataBean)fromData);
            } else {
                FormDataSubBean subBean = fromData.getFormDataSubBeanById(subTableName, fromRecordId);
                fieldValue = this.formatSqlParm(field, (FormDataBean)subBean);
            }
            if (field.getFieldType().equals(Enums.FieldType.DECIMAL.getKey())) {
                if (StringUtil.checkNull((String)fieldValue)) {
                    fieldValue = "0";
                }
            } else if (field.getFieldType().equals(Enums.FieldType.TIMESTAMP.getKey())) {
                if (StringUtil.checkNull((String)fieldValue)) {
                    fieldValue = FormulaFunctionUitl.DEFAULT_DATE;
                }
                fieldValue = FormulaEnums.FunctionSymbol.to_date.getKey() + "('" + fieldValue + "')";
            } else if (field.getFieldType().equals(Enums.FieldType.DATETIME.getKey())) {
                if (StringUtil.checkNull((String)fieldValue)) {
                    fieldValue = FormulaFunctionUitl.DEFAULT_DATE_TIME;
                }
                fieldValue = FormulaEnums.FunctionSymbol.to_date.getKey() + "('" + fieldValue + "')";
            } else if (!StringUtil.checkNull((String)fieldValue)) {
                fieldValue = "'" + fieldValue + "'";
            }
            FormFormulaBean.FormulaValueBean newBean = new FormFormulaBean.FormulaValueBean(formFormulaBean);
            newBean.setValue(fieldValue);
            return newBean;
        }
        return formulaDataFieldBean;
    }

    private String formatSqlParm(com.seeyon.cap4.form.bean.FormFieldBean field, FormDataBean fromData) {
        Object obj = fromData.getFieldValue(field.getName());
        String fieldValue = field.getFieldType().equals(Enums.FieldType.TIMESTAMP.getKey()) ? (StringUtil.checkNull((String)String.valueOf(obj)) ? FormulaFunctionUitl.DEFAULT_DATE : (obj instanceof Date ? DateUtil.format((Date)((Date)obj), (String)"yyyy-MM-dd") : String.valueOf(obj))) : (field.getFieldType().equals(Enums.FieldType.DATETIME.getKey()) ? (StringUtil.checkNull((String)String.valueOf(obj)) ? FormulaFunctionUitl.DEFAULT_DATE_TIME : (obj instanceof Date ? DateUtil.formatDateTime((Date)((Date)obj)) : String.valueOf(obj))) : String.valueOf(obj));
        return fieldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormDataStateResultVO updateDataState(ColSummary colSummary, CtpAffair affair, ColHandleType type, List<Comment> list) throws BusinessException, SQLException {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(colSummary.getFormAppid());
        String[] tableArray = formBean.getAllTableNameArray();
        TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Delete, tableArray);
        try {
            FormDataStateResultVO formDataStateResultVO = this.doUpdateDataState(formBean, colSummary, affair, type, list);
            return formDataStateResultVO;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    private final FormDataStateResultVO doUpdateDataState(com.seeyon.cap4.form.bean.FormBean formBean, ColSummary colSummary, CtpAffair affair, ColHandleType type, List<Comment> list) throws BusinessException, SQLException {
        boolean hasSetValue;
        FormDataStateResultVO resultVo = null;
        LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u6570\u636eID\uff1a" + colSummary.getFormRecordid() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name()));
        List fieldBeans = formBean.getFieldsByType(FormFieldComEnum.FLOWDEALOPITION);
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormTriggerBean.TriggerPoint conditionState = null;
        List tempList = null;
        HashMap<String, List<String>> subRelationFieldList = new HashMap<String, List<String>>();
        Map<String, Object> subMap = null;
        HashMap<String, Map<String, Object>> tableDataMap = new HashMap<String, Map<String, Object>>();
        boolean needTrigger = false;
        boolean needFillBackDealOpition = false;
        boolean needCalcAll = false;
        String triggerEventSourceEnum = "";
        switch (type) {
            case save: {
                this.getStateMap(map, false, colSummary.getStartMemberId(), DateUtil.currentTimestamp(), true);
                break;
            }
            case send: 
            case autosend: {
                needTrigger = true;
                conditionState = FormTriggerBean.TriggerPoint.FlowSend;
                if (this.isChildrenWorkFlow(colSummary)) {
                    needTrigger = false;
                }
                this.getStateMap(map, true, colSummary.getStartMemberId(), DateUtil.currentTimestamp(), needTrigger);
                triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.send.getKey();
                break;
            }
            case wait: {
                needFillBackDealOpition = true;
                needTrigger = true;
                conditionState = FormTriggerBean.TriggerPoint.FlowSend;
                triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.wait.getKey();
                break;
            }
            case finish: {
                if (!(colSummary.getNewflowType() != null && colSummary.getNewflowType() == 1 || colSummary.isAudited() != null && colSummary.isAudited().booleanValue())) {
                    this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_UNAUDITED.getKey(), AppContext.currentUserId(), DateUtil.currentTimestamp());
                }
                LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + "\u63d0\u4ea4\u5904\u7406"));
                conditionState = FormTriggerBean.TriggerPoint.FlowSend;
                triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.finish.getKey();
                if (AUDIT.equals(affair.getNodePolicy())) {
                    if (colSummary.isAudited().booleanValue()) {
                        this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_AUDITEDPASS.getKey(), AppContext.currentUserId(), DateUtil.currentTimestamp());
                        LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + "\u5ba1\u6838\u901a\u8fc7"));
                        triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.audit.getKey();
                    } else {
                        this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS.getKey(), AppContext.currentUserId(), DateUtil.currentTimestamp());
                    }
                    needCalcAll = true;
                } else if (vouch.equals(affair.getNodePolicy())) {
                    if (Strings.equals((Object)colSummary.getVouch(), (Object)1)) {
                        this.getStateMap(map, Enums.UpdateDataType.FORM_VOUCH, Enums.FormDataRatifyFlagEnum.FLOW_VOUCHPASS.getKey(), AppContext.currentUserId(), DateUtil.currentTimestamp());
                        conditionState = FormTriggerBean.TriggerPoint.FlowState_Ratify;
                        LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + "\u6838\u5b9a\u901a\u8fc7"));
                        triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.ratify.getKey();
                    } else {
                        this.getStateMap(map, Enums.UpdateDataType.FORM_VOUCH, Enums.FormDataRatifyFlagEnum.FLOW_VOUCHUNPASS.getKey(), AppContext.currentUserId(), DateUtil.currentTimestamp());
                    }
                    needCalcAll = true;
                }
                needTrigger = true;
                needFillBackDealOpition = true;
                break;
            }
            case stepBack: {
                if (AUDIT.equals(affair.getNodePolicy())) {
                    needCalcAll = true;
                    this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS.getKey(), 0L, DateUtil.currentTimestamp());
                } else if (vouch.equals(affair.getNodePolicy())) {
                    needCalcAll = true;
                    this.getStateMap(map, Enums.UpdateDataType.FORM_VOUCH, Enums.FormDataRatifyFlagEnum.FLOW_VOUCHUNPASS.getKey(), 0L, DateUtil.currentTimestamp());
                }
                needFillBackDealOpition = true;
                break;
            }
            case stepStop: {
                if (!this.isChildrenWorkFlow(colSummary)) {
                    map.put(Enums.MasterTableField.finishedflag.getKey(), Enums.FromDataFinishedFlagEnum.STOP.getKey());
                }
                needCalcAll = true;
                try {
                    this.cap4FormTriggerManager.rollBackWithHolding(colSummary.getFormRecordid());
                }
                catch (Exception e) {
                    LOGGER.error((Object)"\u7ec8\u6b62\u9884\u63d0\u6570\u636e\u8fd8\u539f\u62a5\u9519", (Throwable)e);
                }
                needFillBackDealOpition = true;
                LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + "\u6d41\u7a0b\u7ec8\u6b62"));
                break;
            }
            case repeal: {
                String repealAndEmpty;
                this.getStateMap(map, false, colSummary.getStartMemberId(), DateUtil.currentTimestamp(), true);
                for (com.seeyon.cap4.form.bean.FormFieldBean formFieldBean : fieldBeans) {
                    map.put(formFieldBean.getName(), "");
                }
                Map advancedSet = formBean.getAdvancedSet();
                String repealType = "not";
                Map set = null;
                List<String> fieldNames = null;
                if (null != advancedSet && "custom".equals(repealType = (String)(set = (Map)JSONUtil.parseJSONString((String)(repealAndEmpty = (String)advancedSet.get("repealAndEmpty")), Map.class)).get("type"))) {
                    String showFieldList = (String)set.get("showFieldList");
                    fieldNames = Arrays.asList(showFieldList.split(","));
                }
                LOGGER.info((Object)("\u5f00\u59cb\u56de\u9000\u6e05\u7a7a\u6570\u636e\uff0ctype=" + repealType));
                WorkflowApiManager wapi = (WorkflowApiManager)AppContext.getBean((String)"wapi");
                String viewAuths = wapi.getNodeFormOperationNameFromRunning(colSummary.getProcessId(), null);
                String rightId = this.getStarterRightId(formBean, viewAuths);
                if (Strings.isNotBlank((String)rightId)) {
                    FormAuthViewBean viewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
                    if (viewBean == null) {
                        LOGGER.error((Object)("\u6d41\u7a0b\u64a4\u9500\uff0c\u83b7\u53d6\u5230\u7684\u6743\u9650\u4e3anull\uff0c\u5bf9\u5e94operationId = " + rightId));
                    } else {
                        List viewFieldBeans = viewBean.getFormAuthorizationFieldList();
                        for (FormAuthViewFieldBean avfb : viewFieldBeans) {
                            FormFieldCtrl ctrl;
                            com.seeyon.cap4.form.bean.FormFieldBean fieldBean = avfb.getFormFieldBean();
                            if (fieldBean == null) {
                                LOGGER.warn((Object)("\u5f53\u524d\u89c6\u56fe\u6743\u9650\u4e2d\u7684\u5b57\u6bb5\uff1a" + avfb.getFieldName() + " \u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u6b64\u5904\u51fa\u73b0\u7a7a\u5c5e\u4e8e\u5386\u53f2\u6570\u636e\uff0c\u5fc5\u987b\u8fdb\u884c\u8fc7\u6ee4"));
                                continue;
                            }
                            if (!this.neadClearSerialNumber(fieldBean, formBean) || null == (ctrl = fieldBean.getFieldCtrl()) || !ctrl.needClearWhenBackToStarter()) continue;
                            HashMap<String, Long> attachments = new HashMap<String, Long>();
                            attachments.put("reference", colSummary.getId());
                            if ("normal".equals(repealType)) {
                                FormAuthViewFieldBean auth = viewBean.getFormAuthorizationField(fieldBean.getName());
                                if (auth.isEditAuth()) continue;
                                this.clearWhenBackToStarter(colSummary, formBean, map, subRelationFieldList, tableDataMap, fieldBean, ctrl, attachments, subMap, tempList);
                                continue;
                            }
                            if (!"custom".equals(repealType) || !fieldNames.contains(fieldBean.getName())) continue;
                            this.clearWhenBackToStarter(colSummary, formBean, map, subRelationFieldList, tableDataMap, fieldBean, ctrl, attachments, subMap, tempList);
                        }
                    }
                }
                try {
                    this.cap4FormTriggerManager.rollBackWithHolding(colSummary.getFormRecordid());
                }
                catch (Exception e) {
                    LOGGER.error((Object)"\u64a4\u9500\u4fdd\u5b58\u5f85\u53d1\u9884\u63d0\u6570\u636e\u8fd8\u539f\u62a5\u9519", (Throwable)e);
                }
                needFillBackDealOpition = true;
                break;
            }
            case takeBack: {
                if (AUDIT.equals(affair.getNodePolicy())) {
                    needCalcAll = true;
                    this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_UNAUDITED.getKey(), 0L, null);
                } else if (vouch.equals(affair.getNodePolicy())) {
                    needCalcAll = true;
                    this.getStateMap(map, Enums.UpdateDataType.FORM_VOUCH, Enums.FormDataRatifyFlagEnum.FLOW_UNVOUCH.getKey(), 0L, null);
                }
                needFillBackDealOpition = true;
                break;
            }
            case specialback: {
                boolean isRepeal = AppContext.getThreadContext((String)"isRepeal_4_form_use") == null ? false : (Boolean)AppContext.getThreadContext((String)"isRepeal_4_form_use");
                LOGGER.info((Object)("\u6307\u5b9a\u56de\u9000\uff0c\u662f\u5426\u56de\u9000\u5230\u53d1\u8d77\u8005\uff1aisRepeal = " + isRepeal));
                if (isRepeal) {
                    this.getStateMap(map, false, colSummary.getStartMemberId(), DateUtil.currentTimestamp(), true);
                    try {
                        LOGGER.info((Object)"\u6307\u5b9a\u56de\u9000\uff0c\u9884\u63d0\u56de\u6eda");
                        this.cap4FormTriggerManager.rollBackWithHolding(colSummary.getFormRecordid());
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"\u64a4\u9500\u4fdd\u5b58\u5f85\u53d1\u9884\u63d0\u6570\u636e\u8fd8\u539f\u62a5\u9519", (Throwable)e);
                    }
                }
                needFillBackDealOpition = true;
                break;
            }
        }
        if (!this.isChildrenWorkFlow(colSummary) && colSummary.getState() != null && colSummary.getState().intValue() == CollaborationEnum.flowState.finish.ordinal()) {
            conditionState = conditionState == FormTriggerBean.TriggerPoint.FlowSend ? FormTriggerBean.TriggerPoint.FlowState_Send_OR_Finished : (conditionState == FormTriggerBean.TriggerPoint.FlowState_Ratify ? FormTriggerBean.TriggerPoint.FlowState_Ratify_OR_Finished : FormTriggerBean.TriggerPoint.FlowState_Finished);
            map.put(Enums.MasterTableField.finishedflag.getKey(), Enums.FromDataFinishedFlagEnum.END_YES.getKey());
            needTrigger = true;
            needCalcAll = true;
            LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + "\u6d41\u7a0b\u7ed3\u675f"));
        }
        if (needFillBackDealOpition && (hasSetValue = this.getDealOpition(formBean, map, fieldBeans, list, colSummary, affair))) {
            needCalcAll = true;
        }
        LOGGER.info((Object)(colSummary.getSubject() + "\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u72b6\u6001\u2026\u2026\u2026\u2026\u8868\u5355\u540d\u79f0\uff1a" + formBean.getFormName() + " " + formBean.getId() + " \u6570\u636eID\uff1a" + colSummary.getFormRecordid() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + map));
        FormDataMasterBean masterDataBean = this.cap4FormManager.getSessioMasterDataBean(colSummary.getFormRecordid());
        if (masterDataBean != null) {
            masterDataBean.addFieldValue(map);
        }
        if (!this.isInformNode(affair)) {
            map.put(Enums.MasterTableField.modify_date.getKey(), DateUtil.currentTimestamp());
            map.put(Enums.MasterTableField.modify_member_id.getKey(), AppContext.currentUserId());
        } else {
            needTrigger = false;
            needCalcAll = false;
        }
        boolean needCalc = this.needCalcAll(formBean);
        if (needCalcAll && needCalc) {
            if (masterDataBean == null) {
                masterDataBean = this.cap4FormDataDAO.selectDataByMasterId(colSummary.getFormRecordid(), formBean, null);
            }
            masterDataBean.addFieldValue(map);
            this.calcAll(formBean, masterDataBean, null, false, false, false, false);
            this.cap4FormManager.saveOrUpdateFormData(masterDataBean, formBean.getId(), true);
        } else {
            this.cap4FormDataDAO.updateData(colSummary.getFormRecordid(), formBean.getMasterTableBean().getTableName(), map);
        }
        if (!tableDataMap.isEmpty()) {
            masterDataBean = this.cap4FormDataDAO.selectDataByMasterId(colSummary.getFormRecordid(), formBean, null);
            for (Map.Entry et : tableDataMap.entrySet()) {
                List subBeans = masterDataBean.getSubData((String)et.getKey());
                LOGGER.info((Object)(colSummary.getSubject() + " \u5f00\u59cb\u6e05\u7a7a\u660e\u7ec6\u8868\u6570\u636e\uff1a\u660e\u7ec6\u8868\u540d\u79f0" + (String)et.getKey() + " \u64cd\u4f5c\u7c7b\u578b\u662f\uff1a" + type.name() + et.getValue()));
                tempList = (List)subRelationFieldList.get(et.getKey());
                if (!Strings.isNotEmpty((Collection)subBeans)) continue;
                for (FormDataSubBean formDataSubBean : subBeans) {
                    this.cap4FormRelationRecordDAO.deleteFieldRecord(colSummary.getFormRecordid(), tempList, formDataSubBean.getId());
                    this.cap4FormDataDAO.updateData(formDataSubBean.getId(), (String)et.getKey(), (Map)et.getValue());
                }
            }
        }
        if (needTrigger && formBean.getFormType() == Enums.FormType.processesForm.getKey() && Strings.isNotEmpty((Collection)formBean.getFormTriggerIdList())) {
            LOGGER.info((Object)"\u9700\u8981\u6267\u884c\u89e6\u53d1\uff0c\u8fdb\u5165\u89e6\u53d1\u6267\u884c\u5224\u65ad\u2026\u2026\u2026\u2026");
            AppContext.putThreadContext((String)("TRIGGER_PARAM_SUMMARY_PRE_" + colSummary.getId()), (Object)colSummary);
            resultVo = this.cap4FormTriggerManager.doPreWrite(ModuleType.collaboration.getKey(), colSummary.getId(), formBean, colSummary.getFormRecordid(), conditionState, colSummary.getSubject());
            AppContext.removeThreadContext((String)("TRIGGER_PARAM_SUMMARY_PRE_" + colSummary.getId()));
            this.cap4FormTriggerManager.doTrigger(affair, ModuleType.collaboration.getKey(), colSummary.getId(), conditionState, triggerEventSourceEnum);
        }
        if (colSummary.getFormRecordid() != null) {
            this.cap4FormManager.removeSessionMasterDataBean(colSummary.getFormRecordid());
        }
        this.capFormDataCacheManager.remove(colSummary.getFormRecordid());
        return resultVo;
    }

    private boolean needCalcAll(com.seeyon.cap4.form.bean.FormBean formBean) {
        List fields = formBean.getAllFieldBeans();
        for (com.seeyon.cap4.form.bean.FormFieldBean field : fields) {
            List conditionActionBeans;
            Set inFormulaFields = field.getInFormulaFields();
            if (null != inFormulaFields && inFormulaFields.size() > 0) {
                for (com.seeyon.cap4.form.bean.FormFieldBean formulaField : inFormulaFields) {
                    if (!FormFieldComEnum.FLOWDEALOPITION.getKey().equalsIgnoreCase(formulaField.getInputType())) continue;
                    return true;
                }
            }
            if ((conditionActionBeans = field.getFormConditionList()) == null) continue;
            for (FormConditionActionBean formConditionActionBean : conditionActionBeans) {
                List ctpFormulas = formConditionActionBean.getAllFormulaList();
                if (ctpFormulas == null) continue;
                for (CtpFormula ctpFormula : ctpFormulas) {
                    String expression = ctpFormula.getExpression();
                    if (StringUtil.checkNull((String)expression) || expression.indexOf(FormulaEnums.SystemDataField.approvalState.getKey()) == -1 && expression.indexOf(FormulaEnums.SystemDataField.ratifyState.getKey()) == -1 && expression.indexOf(FormulaEnums.SystemDataField.flowState.getKey()) == -1 && expression.indexOf(FormulaEnums.SystemDataField.createDate.getKey()) == -1 && expression.indexOf(FormulaEnums.SystemDataField.modify_date.getKey()) == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String getStarterRightId(com.seeyon.cap4.form.bean.FormBean formBean, String viewAuths) {
        boolean onglyMobileView = false;
        ArrayList<String> mobileRightIds = new ArrayList<String>();
        String[] parts = viewAuths.split("_");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.contains(".")) continue;
            String[] viewAuth = part.split("[.]");
            String viewId = viewAuth[0];
            String rightId = viewAuth[1];
            FormViewBean formView = formBean.getFormView(Long.valueOf(viewId).longValue());
            if (formView.isPc()) {
                List fieldList = formView.getFieldList();
                if (fieldList.size() != 1 || !"".equals(fieldList.get(0))) continue;
                onglyMobileView = true;
                continue;
            }
            mobileRightIds.add(rightId);
        }
        String rightId = null;
        rightId = onglyMobileView && mobileRightIds.size() > 0 ? (String)mobileRightIds.get(0) : FormUtil.parseOperationId((String)viewAuths);
        return rightId;
    }

    private boolean neadClearSerialNumber(com.seeyon.cap4.form.bean.FormFieldBean fieldBean, com.seeyon.cap4.form.bean.FormBean formBean) throws BusinessException {
        String serid = this.cap4SerialNumberManager.getSerialNumberIds4Formula(fieldBean.getFormulaData());
        if (Strings.isNotBlank((String)serid)) {
            return false;
        }
        List allFormAuthViewBeans = formBean.getAllFormAuthViewBeans(false);
        for (FormAuthViewBean formAuthViewBean : allFormAuthViewBeans) {
            List viewFieldBeans = formAuthViewBean.getFormAuthorizationFieldList();
            for (FormAuthViewFieldBean formAuthViewFieldBean : viewFieldBeans) {
                com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = formAuthViewFieldBean.getFormFieldBean();
                if (formFieldBean == null || !fieldBean.getName().equals(formFieldBean.getName()) || !Strings.isNotBlank((String)formAuthViewFieldBean.getDefaultValueType()) || !Strings.isNotBlank((String)formAuthViewFieldBean.getDefaultValue()) || !formAuthViewFieldBean.isSerialNumberDefaultValue()) continue;
                return false;
            }
        }
        return true;
    }

    private void clearWhenBackToStarter(ColSummary colSummary, com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> map, Map<String, List<String>> subRelationFieldList, Map<String, Map<String, Object>> tableDataMap, com.seeyon.cap4.form.bean.FormFieldBean fieldBean, FormFieldCtrl ctrl, Map<String, Long> attachments, Map<String, Object> subMap, List<String> tempList) throws BusinessException, SQLException {
        if (fieldBean.isMasterField()) {
            FormDataMasterBean masterDataBean;
            Object value;
            if (fieldBean.isAttachment() && null != (value = (masterDataBean = this.cap4FormDataDAO.selectDataByMasterId(colSummary.getFormRecordid(), formBean, null)).getRowData().get(fieldBean.getName()))) {
                Long subReference = Long.parseLong(String.valueOf(value));
                attachments.put("subReference", subReference);
            }
            ctrl.clearWhenBackToStarter(formBean, colSummary.getFormRecordid(), fieldBean, map, attachments);
            if (fieldBean.isRelationSelectedField()) {
                this.cap4FormRelationRecordDAO.deleteFieldRecord(colSummary.getFormRecordid(), fieldBean.getName(), (Long)0L);
            }
        } else {
            subMap = tableDataMap.get(fieldBean.getOwnerTableName());
            if (subMap == null) {
                subMap = new HashMap<String, Object>();
            }
            if (fieldBean.isAttachment()) {
                FormDataMasterBean masterDataBean = this.cap4FormDataDAO.selectDataByMasterId(colSummary.getFormRecordid(), formBean, null);
                List subBeans = masterDataBean.getSubData(fieldBean.getOwnerTableName());
                for (FormDataSubBean formDataSubBean : subBeans) {
                    Object value = formDataSubBean.getRowData().get(fieldBean.getName());
                    if (null != value) {
                        Long subReference = Long.parseLong(String.valueOf(value));
                        attachments.put("subReference", subReference);
                    }
                    ctrl.clearWhenBackToStarter(formBean, colSummary.getFormRecordid(), fieldBean, subMap, attachments);
                }
            } else {
                ctrl.clearWhenBackToStarter(formBean, colSummary.getFormRecordid(), fieldBean, subMap, attachments);
            }
            tableDataMap.put(fieldBean.getOwnerTableName(), subMap);
            if (fieldBean.isRelationSelectedField()) {
                tempList = subRelationFieldList.get(fieldBean.getOwnerTableName());
                if (tempList == null) {
                    tempList = new ArrayList<String>();
                }
                tempList.add(fieldBean.getName());
                subRelationFieldList.put(fieldBean.getOwnerTableName(), tempList);
            }
        }
    }

    private String getFirstEditRightId(CtpAffair affair, com.seeyon.cap4.form.bean.FormBean formBean) {
        String rightId = "";
        String rithtStr = affair.getMultiViewStr();
        String[] bindViewOperation = affair.getFirstViewAndOperation();
        if (Strings.isNotBlank((String)bindViewOperation[1])) {
            rightId = bindViewOperation[1];
        }
        return rightId;
    }

    @Override
    public void updateDataState(Long formId, Long dataId, String type, int state) throws BusinessException {
        Enums.UpdateDataType updateDataType;
        FormDataMasterBean masterBean = this.cap4FormManager.getSessioMasterDataBean(dataId);
        if (masterBean != null && (updateDataType = Enums.UpdateDataType.getTypeByName((String)type)) != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (updateDataType != Enums.UpdateDataType.FORM_FLOW) {
                this.getStateMap(map, updateDataType, state, AppContext.currentUserId(), DateUtil.currentTimestamp());
            } else {
                this.getStateMap(map, updateDataType, state, masterBean.getStartMemberId(), masterBean.getStartDate());
            }
            masterBean.addFieldValue(map);
        }
    }

    private void getStateMap(Map<String, Object> map, boolean isSend, Long senderId, Date date, boolean setFormFlow) {
        if (isSend) {
            this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_UNAUDITED.getKey(), 0L, null);
        } else {
            this.getStateMap(map, Enums.UpdateDataType.FORM_AUDIT, Enums.FormDataStateEnum.FLOW_DRAFT.getKey(), 0L, null);
        }
        this.getStateMap(map, Enums.UpdateDataType.FORM_VOUCH, Enums.FormDataRatifyFlagEnum.FLOW_UNVOUCH.getKey(), 0L, null);
        if (setFormFlow) {
            this.getStateMap(map, Enums.UpdateDataType.FORM_FLOW, Enums.FromDataFinishedFlagEnum.END_NO.getKey(), senderId, date);
        }
    }

    private void getStateMap(Map<String, Object> map, Enums.UpdateDataType type, int state, Long memberId, Date date) {
        if (map == null) {
            return;
        }
        switch (type) {
            case FORM_AUDIT: {
                map.put(Enums.MasterTableField.state.getKey(), state);
                if (state == Enums.FormDataStateEnum.FLOW_UNAUDITED.getKey()) break;
                map.put(Enums.MasterTableField.approve_date.getKey(), date);
                map.put(Enums.MasterTableField.approve_member_id.getKey(), memberId);
                break;
            }
            case FORM_FLOW: {
                map.put(Enums.MasterTableField.finishedflag.getKey(), state);
                map.put(Enums.MasterTableField.start_member_id.getKey(), memberId);
                map.put(Enums.MasterTableField.start_date.getKey(), date);
                map.put(Enums.MasterTableField.modify_member_id.getKey(), memberId);
                map.put(Enums.MasterTableField.modify_date.getKey(), date);
                break;
            }
            case FORM_VOUCH: {
                map.put(Enums.MasterTableField.ratifyflag.getKey(), state);
                map.put(Enums.MasterTableField.ratify_date.getKey(), date);
                map.put(Enums.MasterTableField.ratify_member_id.getKey(), memberId);
                break;
            }
        }
    }

    private boolean getDealOpition(com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> masterBean, List<com.seeyon.cap4.form.bean.FormFieldBean> fieldBeans, List<Comment> comments, ColSummary colSummary, CtpAffair affair) throws BusinessException {
        boolean hasSetValue = false;
        if (Strings.isEmpty(comments)) {
            return hasSetValue;
        }
        for (com.seeyon.cap4.form.bean.FormFieldBean formFieldBean : fieldBeans) {
            List<Comment> temp;
            if (!this.needFillBackDealOpition(formBean, formFieldBean, affair, true)) continue;
            boolean needBackComments = false;
            boolean needTemporaryComments = true;
            boolean needNullComments = true;
            boolean needTransferComments = true;
            String formatType = formFieldBean.getFormatType();
            if (Strings.isNotBlank((String)formatType)) {
                if (formatType.contains(Enums.FlowDealOptionsType.nullToShow.getKey())) {
                    needNullComments = false;
                }
                if (formatType.contains(Enums.FlowDealOptionsType.temporaryToShow.getKey())) {
                    needTemporaryComments = false;
                }
                if (!formatType.contains(Enums.FlowDealOptionsType.backToShow.getKey())) {
                    needBackComments = true;
                }
                if (formatType.contains(Enums.FlowDealOptionsType.transferToShow.getKey())) {
                    needTransferComments = false;
                }
            }
            if (Strings.isNotEmpty(temp = this.getComments(formBean, formFieldBean, comments, colSummary, needBackComments, needTemporaryComments, needNullComments, needTransferComments, affair))) {
                String value = this.getDealOptionValue(formFieldBean, temp);
                if (formFieldBean.getFieldType().equals(Enums.FieldType.VARCHAR.getKey())) {
                    int length;
                    int n = length = formFieldBean.getFieldLength() == null || !Strings.isDigits((String)formFieldBean.getFieldLength()) ? 0 : Integer.parseInt(formFieldBean.getFieldLength());
                    if (value.length() > length / 3) {
                        LOGGER.info((Object)("\u8868\u5355\uff1a" + formBean.getFormName() + "\u7684\u5b57\u6bb5" + formFieldBean.getName() + "\u610f\u89c1\u56de\u586b\u8d85\u957f\u88ab\u622a\u53d6\uff0c\u539f\u610f\u89c1\uff1a" + value));
                        value = value.substring(0, length / 3);
                    }
                }
                masterBean.put(formFieldBean.getName(), value);
            } else {
                masterBean.put(formFieldBean.getName(), "");
            }
            hasSetValue = true;
        }
        return hasSetValue;
    }

    private String getDealOptionValue(com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, List<Comment> comments) throws BusinessException {
        StringBuilder sb = new StringBuilder();
        String value = null;
        int j = comments.size();
        for (int i = 0; i < j; ++i) {
            Comment comment = comments.get(i);
            value = this.getDealOption(comment, formFieldBean.getFormatType(), formFieldBean.getName());
            sb.append(value);
            if (i == j - 1) continue;
            sb.append("\r\n\r\n");
        }
        return sb.toString();
    }

    private Map<Long, List<Comment>> groupCommentByAffair(List<Comment> commonts, ColSummary colSummary, boolean flag, boolean needBackComments, boolean needTemporaryComments, boolean needNullComments) throws BusinessException {
        LinkedHashMap<Long, List<Comment>> map = new LinkedHashMap<Long, List<Comment>>();
        ArrayList<Comment> temp = new ArrayList<Comment>();
        Long id = null;
        for (Comment comment : commonts) {
            ArrayList<Comment> list;
            if (flag) {
                id = comment.getAffairId();
                list = (ArrayList<Comment>)map.get(comment.getAffairId());
            } else {
                id = comment.getCreateId();
                list = (List)map.get(comment.getCreateId());
            }
            if (list == null) {
                if (id == null) continue;
                list = new ArrayList<Comment>();
                map.put(id, list);
            }
            if (Strings.isBlank((String)comment.getContent()) && !needNullComments || this.isTemporaryComment(comment) && !needTemporaryComments || this.isRollBackComment(comment) && !needBackComments || !this.isFillBackComment(comment)) continue;
            if (this.isCancelComment(comment)) {
                for (Map.Entry et : map.entrySet()) {
                    ((List)et.getValue()).clear();
                }
                temp.clear();
            }
            list.add(comment);
            temp.add(comment);
        }
        map.put(0L, temp);
        return map;
    }

    private String getDealOption(Comment comment, String typeStr, String fieldName) throws BusinessException {
        String roleName;
        StringBuilder sb = new StringBuilder();
        String transactor = "";
        if (Strings.isNotBlank((String)comment.getExtAtt2())) {
            transactor = ResourceUtil.getString((String)"form.dealopition.by.other.label", (Object)comment.getExtAtt2());
        }
        String crlfAndTenSpace = "\r\n    ";
        String space = " ";
        String leftMiddle = "[";
        String rightMiddle = "]";
        V3xOrgMember member = this.orgManager.getMemberById(comment.getCreateId());
        Long departmentId = member.getOrgDepartmentId();
        Long postId = member.getOrgPostId();
        if (comment.getDepartmentId() != null) {
            departmentId = comment.getDepartmentId();
        }
        if (comment.getPostId() != null) {
            postId = comment.getPostId();
        }
        if (Strings.isBlank((String)(roleName = comment.getRoleName()))) {
            V3xOrgPost orgPost = this.orgManager.getPostById(postId);
            roleName = orgPost == null ? "" : orgPost.getName();
        }
        V3xOrgDepartment department = this.orgManager.getDepartmentById(departmentId);
        String att = com.seeyon.cap4.form.util.StringUtils.fixStrWithSpace((String)this.getAtt(comment), (int)5);
        String inscribe = comment.getContent();
        if (Strings.isBlank((String)inscribe)) {
            inscribe = "";
        }
        String inscribeWithCrlfAndTenSpace = inscribe.replace("\n", crlfAndTenSpace);
        Long affairId = comment.getAffairId();
        if (Strings.isBlank((String)typeStr)) {
            sb.append(att).append(space).append(inscribe).append(crlfAndTenSpace).append(member.getName()).append(transactor).append(space).append(comment.getCreateDateStr());
        } else {
            boolean isIncludeAtt = typeStr.contains(Enums.FlowDealOptionsType.att.getKey());
            boolean isIncludeInscribe = typeStr.contains(Enums.FlowDealOptionsType.inscribe.getKey());
            boolean hasDept = typeStr.contains(Enums.FlowDealOptionsType.dept.getKey());
            boolean hasPost = typeStr.contains(Enums.FlowDealOptionsType.post.getKey());
            boolean hasSecondRow = this.hasSecondRow(typeStr);
            if (isIncludeAtt) {
                sb.append(att).append(space);
            }
            if (isIncludeInscribe) {
                if (isIncludeAtt) {
                    sb.append(inscribeWithCrlfAndTenSpace);
                } else {
                    sb.append(inscribe);
                }
            }
            if ((isIncludeAtt || isIncludeInscribe) && hasSecondRow) {
                sb.append(crlfAndTenSpace);
            }
            if (this.hasSecondRow(typeStr)) {
                String[] types = typeStr.split(",");
                if (hasDept || hasPost) {
                    sb.append(leftMiddle);
                }
                block8: for (String one : types) {
                    Enums.FlowDealOptionsType type = Enums.FlowDealOptionsType.getEnumItemByKey((String)one);
                    if (null == type) {
                        LOGGER.error((Object)("\u5904\u7406\u6d41\u7a0b\u610f\u89c1\u627e\u4e0d\u5230\u679a\u4e3e\u7c7b\u578b\uff0c\u7c7b\u578bkey:" + one + "\uff0c\u5b57\u6bb5" + fieldName));
                        continue;
                    }
                    switch (type) {
                        case dept: {
                            sb.append(department.getName()).append(space);
                            continue block8;
                        }
                        case post: {
                            sb.append(roleName).append(space);
                            continue block8;
                        }
                        case name: {
                            sb.append(member.getName()).append(transactor).append(space);
                            continue block8;
                        }
                        case signet: {
                            sb.append(this.getSignetAndSaveHtmlSignet(member, fieldName, affairId, transactor));
                            continue block8;
                        }
                        case date: {
                            sb.append(comment.getCreateDateStr().substring(0, 10)).append(space);
                            continue block8;
                        }
                        case time: {
                            sb.append(comment.getCreateDateStr().substring(comment.getCreateDateStr().length() - 5)).append(space);
                            continue block8;
                        }
                        default: {
                            sb.append("");
                        }
                    }
                }
                sb.deleteCharAt(sb.toString().length() - 1);
                if (hasDept || hasPost) {
                    sb.append(rightMiddle);
                }
            }
        }
        return sb.toString();
    }

    private boolean hasSecondRow(String formatStr) {
        return Strings.isNotBlank((String)formatStr) && (formatStr.contains(Enums.FlowDealOptionsType.dept.getKey()) || formatStr.contains(Enums.FlowDealOptionsType.post.getKey()) || formatStr.contains(Enums.FlowDealOptionsType.name.getKey()) || formatStr.contains(Enums.FlowDealOptionsType.signet.getKey()) || formatStr.contains(Enums.FlowDealOptionsType.date.getKey()) || formatStr.contains(Enums.FlowDealOptionsType.time.getKey()));
    }

    private String getAtt(Comment comment) {
        String result = "          ";
        if (this.isDealAtt(comment)) {
            String dealLocale = comment.getDealLocale();
            if (StringUtil.checkNull((String)dealLocale)) {
                result = this.getLocaleDealValue(comment);
            } else {
                Locale locale = null;
                String[] split = dealLocale.split("_");
                String language = split[0];
                String region = "";
                if (split.length > 1) {
                    region = split[1];
                }
                List allLocales = LocaleContext.getAllLocales();
                for (Locale aLocale : allLocales) {
                    if (!aLocale.getLanguage().equals(language) || !aLocale.getCountry().equals(region)) continue;
                    locale = aLocale;
                    break;
                }
                if (null == locale) {
                    LOGGER.error((Object)("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u8bed\u8a00\uff1a" + dealLocale + ",\u4f7f\u7528\u5f53\u524d\u767b\u5f55\u73af\u5883\u8bed\u8a00\u56fd\u9645\u5316"));
                    result = this.getLocaleDealValue(comment);
                } else {
                    String stringByParams;
                    String extAtt1 = comment.getExtAtt1();
                    if (extAtt1.equals(stringByParams = ResourceUtil.getStringByParams(locale, (String)extAtt1, null))) {
                        LOGGER.error((Object)("\u5f53\u524d\u8bed\u8a00\uff1a" + dealLocale + "\u65e0\u6cd5\u627e\u5230key:" + stringByParams + "\u7684\u56fd\u9645\u5316\u8d44\u6e90\uff0c\u4f7f\u7528\u9ed8\u8ba4\u8bed\u8a00\u56fd\u9645\u5316"));
                        Locale sysSetDefaultLocale = LocaleContext.getSysSetDefaultLocale();
                        stringByParams = ResourceUtil.getStringByParams((Locale)sysSetDefaultLocale, (String)extAtt1, null);
                    }
                    result = "disagree".equals(comment.getExtAtt4()) ? "\u3010" + stringByParams + "\u3011" : "\u3010" + stringByParams + "\u3011  ";
                }
            }
        }
        return result;
    }

    private String getLocaleDealValue(Comment comment) {
        if ("disagree".equals(comment.getExtAtt4())) {
            return "\u3010" + ResourceUtil.getString((String)comment.getExtAtt1()) + "\u3011";
        }
        return "\u3010" + ResourceUtil.getString((String)comment.getExtAtt1()) + "\u3011  ";
    }

    private String getSignetAndSaveHtmlSignet(V3xOrgMember member, String fieldName, Long affairId, String transactor) {
        String space = " ";
        String memberName = member.getName();
        StringBuilder res = new StringBuilder();
        List signetList = this.signetManager.findSignetByMemberId(member.getId());
        V3xSignet selfSignet = null;
        if (signetList != null && !signetList.isEmpty()) {
            for (V3xSignet v3xSignet : signetList) {
                if (v3xSignet.getMarkType() != 0 || selfSignet != null && !selfSignet.getMarkDate().before(v3xSignet.getMarkDate())) continue;
                selfSignet = v3xSignet;
            }
        }
        if (selfSignet != null) {
            long summaryId = UUIDLong.longUUID();
            V3xHtmDocumentSignature htmlDocSignature = new V3xHtmDocumentSignature();
            htmlDocSignature.setId(Long.valueOf(summaryId));
            htmlDocSignature.setSummaryId(summaryId);
            htmlDocSignature.setFieldName(fieldName + "_" + summaryId);
            htmlDocSignature.setUserName(memberName);
            htmlDocSignature.setSignetType(Integer.valueOf(1));
            htmlDocSignature.setDateTime(DateUtil.currentTimestamp());
            if (affairId != null) {
                htmlDocSignature.setAffairId(affairId);
            }
            htmlDocSignature.setFieldValue(FormUtil.byte2Hex((byte[])selfSignet.getMarkBodyByte()));
            this.v3xHtmDocumentSignatManager.save(htmlDocSignature);
            res.append("@signet@").append(memberName).append("_").append(fieldName).append("_").append(summaryId).append("@signet@");
            res.append(transactor).append(space);
        } else {
            res.append(memberName).append(transactor).append(space);
        }
        return res.toString();
    }

    private List<Comment> getComments(com.seeyon.cap4.form.bean.FormBean formBean, com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, List<Comment> allComments, ColSummary colSummary, boolean needBackComments, boolean needTemporaryComments, boolean needNullComments, boolean needTransferComments, CtpAffair affair) throws BusinessException {
        ArrayList<Comment> list = new ArrayList<Comment>();
        Map<Long, List<Comment>> map = this.groupCommentByAffair(allComments, colSummary, false, needBackComments, needTemporaryComments, needNullComments);
        List<Comment> comments = map.get(0L);
        Comment com = null;
        for (Comment comment : comments) {
            if (Strings.isBlank((String)comment.getContent()) && !needNullComments || this.isTemporaryComment(comment) && !needTemporaryComments || this.isRollBackComment(comment) && !needBackComments || this.isTransfer(comment) && !needTransferComments) continue;
            if (this.isCancelComment(comment)) {
                list.clear();
                continue;
            }
            if (!this.isFillBackComment(comment) || null == comment.getAffairId() || !this.needFillBackDealOpition(formBean, formFieldBean, comment.getAffairId(), true, affair)) continue;
            if (this.needFillBackDealOpition(formBean, formFieldBean, comment.getAffairId(), false, affair)) {
                if (comment.getCtype().intValue() != Comment.CommentType.comment.getKey()) continue;
                list.add(comment);
                continue;
            }
            List<Comment> temp = map.get(comment.getCreateId());
            if (!Strings.isNotEmpty(temp)) continue;
            for (Comment c : temp) {
                if (c.getCtype().intValue() != Comment.CommentType.comment.getKey() || this.isTransfer(c) && !needTransferComments || !this.needFillBackDealOpition(formBean, formFieldBean, c.getAffairId(), true, affair)) continue;
                com = c;
            }
            if (com == null || this.isRollBackComment(com) && !needBackComments || comment.getCtype().intValue() == Comment.CommentType.draft.getKey() || list.contains(com)) continue;
            list.add(com);
        }
        return list;
    }

    private boolean isInformNode(CtpAffair affair) {
        return "inform".equals(affair.getNodePolicy());
    }

    private boolean isRollBackComment(Comment comment) {
        return Strings.isNotBlank((String)comment.getExtAtt3()) && "collaboration.dealAttitude.rollback".equals(comment.getExtAtt3());
    }

    private boolean isTemporaryComment(Comment comment) {
        return Strings.isNotBlank((String)comment.getExtAtt3()) && "collaboration.dealAttitude.temporaryAbeyance".equals(comment.getExtAtt3());
    }

    private boolean isFillBackComment(Comment comment) {
        if (comment.getCtype() == null) {
            return false;
        }
        return Comment.CommentType.comment.getKey() == comment.getCtype().intValue() || Comment.CommentType.draft.getKey() == comment.getCtype().intValue();
    }

    private boolean isCancelComment(Comment comment) {
        return Strings.isNotBlank((String)comment.getExtAtt3()) && "collaboration.dealAttitude.cancelProcess".equals(comment.getExtAtt3());
    }

    private boolean isDealAtt(Comment comment) {
        return Strings.isNotBlank((String)comment.getExtAtt1());
    }

    private boolean isTransfer(Comment comment) {
        return Strings.isNotBlank((String)comment.getExtAtt3()) && "collaboration.dealAttitude.transfer".equals(comment.getExtAtt3());
    }

    private boolean needFillBackDealOpition(com.seeyon.cap4.form.bean.FormBean formBean, com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, Long affairID, boolean isAdd, CtpAffair affair) throws BusinessException {
        if (affairID.equals(affair.getId())) {
            return this.needFillBackDealOpition(formBean, formFieldBean, affair, isAdd);
        }
        CtpAffair aAffair = this.affairManager.get(affairID);
        if (aAffair == null) {
            LOGGER.error((Object)("\u7ec4\u88c5\u6d41\u7a0b\u610f\u89c1\u65f6\uff0c\u4e8b\u9879\uff1a" + affairID + "\u88ab\u5220\u9664\uff0c\u8be5\u4e8b\u9879\u5bf9\u5e94\u610f\u89c1\u4e0d\u7ec4\u88c5\u2026\u2026"));
            return false;
        }
        return this.needFillBackDealOpition(formBean, formFieldBean, aAffair, isAdd);
    }

    private boolean needFillBackDealOpition(com.seeyon.cap4.form.bean.FormBean formBean, com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, CtpAffair affair, boolean isAdd) throws BusinessException {
        boolean isMbLogin;
        boolean needFillBack = false;
        if (affair == null) {
            LOGGER.error((Object)("\u7ec4\u88c5\u6d41\u7a0b\u610f\u89c1\u65f6\uff0c\u5b57\u6bb5\uff1a" + formFieldBean.getName() + "\u5bf9\u5e94\u4e8b\u9879\u88ab\u5220\u9664\uff0c\u8be5\u4e8b\u9879\u5bf9\u5e94\u610f\u89c1\u4e0d\u7ec4\u88c5\u2026\u2026"));
            return needFillBack;
        }
        if (AffairUtil.isFormReadonly((CtpAffair)affair)) {
            LOGGER.info((Object)("\u7ec4\u88c5\u6d41\u7a0b\u610f\u89c1\u65f6\uff0c\u4e8b\u9879\uff1a" + affair.getId() + "\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u8be5\u4e8b\u9879\u5bf9\u5e94\u610f\u89c1\u4e0d\u7ec4\u88c5\u2026\u2026"));
            return needFillBack;
        }
        boolean bl = isMbLogin = Constants.login_sign.pc.value() != AppContext.getCurrentUser().getLoginSign() && Constants.login_sign.ucpc.value() != AppContext.getCurrentUser().getLoginSign();
        if (!isMbLogin) {
            String rightId = this.getFirstEditRightId(affair, formBean);
            if ("".equals(rightId)) {
                LOGGER.error((Object)("\u7ec4\u88c5\u6d41\u7a0b\u610f\u89c1\u65f6\uff0c\u4e8b\u9879\uff1a" + affair.getId() + "\u5bf9\u5e94\u6743\u9650\u4e0d\u5b58\u5728\uff0c\u8be5\u4e8b\u9879\u5bf9\u5e94\u610f\u89c1\u4e0d\u7ec4\u88c5\u2026\u2026"));
                return needFillBack;
            }
            FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(rightId));
            if (formAuthViewBean == null) {
                LOGGER.error((Object)("\u7ec4\u88c5\u6d41\u7a0b\u610f\u89c1\u65f6\uff0c\u4e8b\u9879\u5bf9\u5e94\u6743\u9650\uff1a" + rightId + "\u88ab\u5220\u9664\uff0c\u8be5\u4e8b\u9879\u5bf9\u5e94\u610f\u89c1\u4e0d\u7ec4\u88c5\u2026\u2026"));
                return needFillBack;
            }
            FormAuthViewFieldBean authViewFieldBean = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            needFillBack = this.isNeedFillBack(isAdd, authViewFieldBean);
        } else {
            String rithtStr = affair.getMultiViewStr();
            if (rithtStr != null && !"".equals(rithtStr)) {
                String[] viewAndOperation;
                for (String tempRightStr : viewAndOperation = rithtStr.split("_")) {
                    FormAuthViewFieldBean authViewFieldBean;
                    String[] bindViewAndOperation = tempRightStr.split("[.]");
                    String operationId = null;
                    operationId = bindViewAndOperation.length > 1 ? bindViewAndOperation[1] : bindViewAndOperation[0];
                    FormAuthViewBean authViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(operationId)));
                    if ((authViewBean.getType().equals(Enums.FormAuthorizationType.add.getKey()) || authViewBean.getType().equals(Enums.FormAuthorizationType.update.getKey())) && (needFillBack = this.isNeedFillBack(isAdd, authViewFieldBean = authViewBean.getFormAuthorizationField(formFieldBean.getName())))) break;
                }
            }
        }
        return needFillBack;
    }

    private boolean isNeedFillBack(boolean isAdd, FormAuthViewFieldBean authViewFieldBean) {
        boolean result = false;
        if (authViewFieldBean != null) {
            String accessType = authViewFieldBean.getAccess();
            boolean isAddAuth = Enums.FieldAccessType.add.getKey().equals(accessType);
            if (isAddAuth || Enums.FieldAccessType.edit.getKey().equals(accessType)) {
                if (isAdd) {
                    result = true;
                } else if (isAddAuth) {
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    @CAPFormDataCacheRemove
    public void insertOrUpdateMasterData(FormDataMasterBean masterData) throws BusinessException, SQLException {
        this.cap4FormDataDAO.insertOrUpdateMasterData(masterData);
        this.dataTrace((FormDataBean)masterData, "\u5b58\u50a8\u8868\u5355");
    }

    @Override
    public Map<String, Object> validateDataUnique(com.seeyon.cap4.form.bean.FormBean fb, FormDataMasterBean cacheMasterData) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String msg = "1";
        if (Strings.isNotEmpty((Collection)fb.getUniqueFieldList())) {
            for (List list : fb.getUniqueFieldList()) {
                if (!this.isUniqueMarked(fb, cacheMasterData, list)) continue;
                String s = "";
                for (String fName : list) {
                    com.seeyon.cap4.form.bean.FormFieldBean fieldBean = fb.getFieldBeanByName(fName);
                    if (Strings.isBlank((String)s)) {
                        s = s + fieldBean.getDisplay();
                        continue;
                    }
                    s = s + "," + fieldBean.getDisplay();
                }
                resultMap.put("uniqueField", list);
                msg = ResourceUtil.getString((String)"form.data.validate.uniqueFlag", (Object)s);
                break;
            }
            UniqueIndexUtil.mergeUniqueCache((long)fb.getId(), (List)fb.getUniqueFieldList());
        }
        resultMap.put("msg", msg);
        return resultMap;
    }

    @Override
    public boolean isUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, FormDataMasterBean formData, List<String> fieldList) throws BusinessException {
        boolean isSlaveExist;
        int max = 1;
        ArrayList<String> allTableName = new ArrayList<String>();
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<String> slaveList = new ArrayList<String>();
        String subTableName = "";
        tableNameList.add(fb.getMasterTableBean().getTableName());
        Map masterMap = formData.getRowData();
        for (int i = 0; i < fieldList.size(); ++i) {
            String masterValue;
            String fieldName = fieldList.get(i);
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (ffb.isMasterField() && (Strings.isBlank((String)(masterValue = String.valueOf(masterMap.get(fieldName)))) || "null".equals(masterValue))) {
                return false;
            }
            String tableName = ffb.getOwnerTableName();
            List subList = formData.getSubData(tableName);
            if (subList != null && subList.size() > max) {
                max = subList.size();
            }
            allTableName.add(tableName);
            if (!tableNameList.contains(tableName)) {
                tableNameList.add(tableName);
            }
            if (ffb == null || ffb.isMasterField()) continue;
            slaveList.add(fieldName);
            if (!"".equals(subTableName)) continue;
            subTableName = ffb.getOwnerTableName();
        }
        if (!"".equals(subTableName) && (isSlaveExist = this.isExistSameSlaveValue(formData.getSubData(subTableName), slaveList))) {
            return true;
        }
        JDBCAgent jdbc = null;
        try {
            int i;
            jdbc = new JDBCAgent();
            StringBuilder sql = new StringBuilder();
            sql.append(" select " + (String)tableNameList.get(0) + ".id from ");
            String countSql = " select count(" + (String)tableNameList.get(0) + ".id) from ";
            for (i = 0; i < tableNameList.size(); ++i) {
                if (i == 0) {
                    sql.append((String)tableNameList.get(i));
                    countSql = countSql + (String)tableNameList.get(i);
                    continue;
                }
                sql.append(" left join " + (String)tableNameList.get(i) + " on " + (String)tableNameList.get(0) + ".id=" + (String)tableNameList.get(i) + ".formmain_id ");
                countSql = countSql + " left join " + (String)tableNameList.get(i) + " on " + (String)tableNameList.get(0) + ".id=" + (String)tableNameList.get(i) + ".formmain_id ";
            }
            sql.append(" where   ");
            for (i = 0; i < fieldList.size(); ++i) {
                int k;
                if (i == fieldList.size() - 1) {
                    for (k = 0; k < tableNameList.size(); ++k) {
                        if (!((String)tableNameList.get(k)).equals(allTableName.get(i))) continue;
                        sql.append((String)tableNameList.get(k) + "." + fieldList.get(i) + "= ? ");
                    }
                    continue;
                }
                for (k = 0; k < tableNameList.size(); ++k) {
                    if (!((String)tableNameList.get(k)).equals(allTableName.get(i))) continue;
                    sql.append((String)tableNameList.get(k) + "." + fieldList.get(i) + "= ?  and ");
                }
            }
            sql.append(" and " + (String)tableNameList.get(0) + ".id <> " + formData.getId());
            boolean isExistDB = false;
            for (int i2 = 0; i2 < max; ++i2) {
                ArrayList<Timestamp> valueList = new ArrayList<Timestamp>();
                Timestamp value = null;
                boolean flag = false;
                for (int k = 0; k < fieldList.size(); ++k) {
                    String s;
                    com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldList.get(k));
                    List dataList = formData.getDataList(fieldList.get(k));
                    if (ffb.isMasterField()) {
                        value = dataList != null && dataList.size() > 0 ? (Timestamp)dataList.get(0) : null;
                    } else {
                        Timestamp timestamp = value = i2 >= dataList.size() ? null : (Timestamp)dataList.get(i2);
                    }
                    if (value == null) {
                        flag = true;
                        break;
                    }
                    if (Enums.FieldType.DATETIME.getKey().equals(ffb.getFieldType())) {
                        if (value instanceof Date) {
                            s = DateUtil.getDate((Date)value, (String)"yyyy-MM-dd HH:mm");
                            value = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd HH:mm");
                        } else if (value instanceof String) {
                            value = DateUtil.parseTimestamp((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm");
                        }
                    } else if (Enums.FieldType.TIMESTAMP.getKey().equals(ffb.getFieldType())) {
                        if (value instanceof Date) {
                            s = DateUtil.getDate((Date)value, (String)"yyyy-MM-dd");
                            value = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd");
                        } else if (value instanceof String) {
                            value = DateUtil.parseTimestamp((String)String.valueOf(value), (String)"yyyy-MM-dd");
                        }
                    }
                    valueList.add(value);
                }
                if (flag) continue;
                int c = 0;
                long beginTime = System.currentTimeMillis();
                jdbc.execute(sql.toString(), valueList);
                c = jdbc.resultSetToList().size();
                int count = sql.indexOf("?") > -1 ? c : 0;
                this.putMonitorParam(fb, fieldList, sql.toString(), jdbc, countSql, beginTime);
                if (count <= 0) continue;
                isExistDB = true;
                break;
            }
            boolean bl = isExistDB;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error((Object)(fb.getFormName() + " \u5224\u65ad\u6570\u636e\u552f\u4e00\u6807\u8bc6\u53d1\u751f\u5f02\u5e38\uff1a" + formData.getId() + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    private void putMonitorParam(com.seeyon.cap4.form.bean.FormBean fb, List<String> fieldList, String sql, JDBCAgent jdbc, String countSql, long beginTime) {
        if (fb == null || fieldList == null || fieldList.isEmpty() || jdbc == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MONITOR_INDEX_SQL", sql);
        try {
            int count = jdbc.count(countSql, new HashMap());
            map.put("MONITOR_INDEX_DATA_COUNT", count);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            map.put("MONITOR_INDEX_DATA_COUNT", -1);
        }
        FormUniqueIndexForCap4.putUniqueRunInfo(fb, fieldList, System.currentTimeMillis() - beginTime, map);
    }

    private void putMonitorParam(com.seeyon.cap4.form.bean.FormBean fb, List<String> fieldList, String sql, int count, long beginTime) {
        if (fb == null || fieldList == null || fieldList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MONITOR_INDEX_SQL", sql);
        map.put("MONITOR_INDEX_DATA_COUNT", count);
        FormUniqueIndexForCap4.putUniqueRunInfo(fb, fieldList, System.currentTimeMillis() - beginTime, map);
    }

    private void putMonitorParam(com.seeyon.cap4.form.bean.FormBean fb, String fieldName, String sql, int count, long beginTime) {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(fieldName);
        this.putMonitorParam(fb, fieldList, sql, count, beginTime);
    }

    private boolean isExistSameSlaveValue(List<FormDataSubBean> subDatas, List<String> fields) {
        boolean isExist = false;
        if (Strings.isNotEmpty(subDatas) && Strings.isNotEmpty(fields)) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> subLineDataList = new ArrayList<String>();
            for (FormDataSubBean fdsb : subDatas) {
                for (int i = 0; i < fields.size(); ++i) {
                    Object subValue = fdsb.getFieldValue(fields.get(i));
                    if (subValue == null) {
                        sb.setLength(0);
                        break;
                    }
                    sb.append(subValue);
                }
                if (sb.length() < 1) continue;
                if (subLineDataList.contains(sb.toString())) {
                    isExist = true;
                    break;
                }
                subLineDataList.add(sb.toString());
                sb.setLength(0);
            }
        }
        return isExist;
    }

    @Override
    public String getReplaceMsg(String msg, com.seeyon.cap4.form.bean.FormBean fb, Map<String, Object> data, boolean needSubData) throws BusinessException {
        LOGGER.info((Object)("\u5f00\u59cb\u6267\u884c\u5b57\u7b26\u4e32\u8868\u5355\u6570\u636e\u66ff\u6362\uff1a\u5bf9\u8c61->" + msg + " \u5f53\u524d\u767b\u5f55\u8bed\u8a00 " + AppContext.getLocale()));
        String subject = msg;
        HashSet<String> needReplaceStrList = new HashSet<String>();
        Matcher fieldMatcher = fieldPattern.matcher(subject);
        while (fieldMatcher.find()) {
            needReplaceStrList.add(fieldMatcher.group(1));
        }
        Matcher sysMatcher = sysPattern.matcher(subject);
        while (sysMatcher.find()) {
            needReplaceStrList.add(sysMatcher.group(1));
        }
        String value = null;
        boolean needReplace = false;
        for (String key : needReplaceStrList) {
            com.seeyon.cap4.form.bean.FormFieldBean tempFieldBean;
            String tempKey = key.substring(1, key.length() - 1);
            com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = tempFieldBean = fb == null ? null : fb.getFieldBeanByDisplay(tempKey);
            if (tempFieldBean != null) {
                if (needSubData) {
                    value = tempFieldBean.getDisplayValue(data.get(tempFieldBean.getName()), false)[1].toString();
                    needReplace = true;
                } else if (tempFieldBean.isMasterField()) {
                    Object dbValue = data.get(tempFieldBean.getName());
                    value = tempFieldBean.getDisplayValue(dbValue, false)[1].toString();
                    needReplace = true;
                }
            } else {
                FormulaEnums.SystemDataField dataField = FormulaEnums.SystemDataField.getEnumByText((String)tempKey);
                if (dataField != null) {
                    needReplace = true;
                    value = dataField.getKey();
                    switch (dataField) {
                        case approvalState: {
                            value = Enums.FormDataStateEnum.getFlowFormDataStateEnumByKey((int)((Integer)data.get(Enums.MasterTableField.state.getKey()))).getText();
                            break;
                        }
                        case createDate: {
                            value = DateUtil.format((Date)((Date)data.get(value)), (String)"yyyy-MM-dd HH:mm");
                            break;
                        }
                        case creator: {
                            value = this.orgManager.getMemberById((Long)data.get(value)).getName();
                            break;
                        }
                        case flowState: {
                            value = Enums.FromDataFinishedFlagEnum.getFlowStateByKey((int)((Integer)data.get(Enums.MasterTableField.finishedflag.getKey()))).getText();
                            break;
                        }
                        case modify_date: {
                            value = DateUtil.format((Date)((Date)data.get(value)), (String)"yyyy-MM-dd HH:mm");
                            break;
                        }
                        case ratifyState: {
                            value = Enums.FormDataRatifyFlagEnum.getFromLogOperateTypeByKey((int)((Integer)data.get(Enums.MasterTableField.ratifyflag.getKey()))).getText();
                            break;
                        }
                    }
                } else if (tempKey.contains("System")) {
                    String realKey = key.substring(key.indexOf(".") + 1);
                    FormulaEnums.FormulaVar var = FormulaEnums.FormulaVar.getEnumByText((String)realKey);
                    if (var != null) {
                        needReplace = true;
                        value = var.getValue();
                    }
                } else {
                    FormulaEnums.FormulaVar var = FormulaEnums.FormulaVar.getEnumByText((String)tempKey);
                    if (var != null) {
                        needReplace = true;
                        String obj = var.getValue();
                        value = obj == null ? "" : obj.toString();
                    }
                }
            }
            if (needReplace) {
                if (StringUtil.checkNull(value)) {
                    value = "";
                }
                subject = subject.replace(key, value);
            }
            needReplace = false;
        }
        LOGGER.info((Object)("\u7ed3\u675f\u6267\u884c\u5b57\u7b26\u4e32\u8868\u5355\u6570\u636e\u66ff\u6362\uff1a\u7ed3\u679c-> " + subject));
        return subject;
    }

    @Override
    public List<Map<String, Object>> getFormSlaveDataListById(String[] returnFields, String table, String whereId, List<Long> ids) throws BusinessException {
        if (ids != null) {
            String fieldNames = returnFields == null || returnFields.length == 0 ? "*" : com.seeyon.cap4.form.util.StringUtils.arrayToString((String[])returnFields);
            List[] subIds = Strings.splitList(ids, (int)1000);
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            for (List subId : subIds) {
                StringBuilder sql = new StringBuilder("select " + fieldNames + " from " + table + " where " + whereId + " in (");
                for (int i = 0; i < subId.size(); ++i) {
                    if (i == subId.size() - 1) {
                        sql.append("?");
                        continue;
                    }
                    sql.append("?,");
                }
                sql.append(" ) order by sort asc");
                JDBCAgent jdbc = new JDBCAgent();
                try {
                    jdbc.execute(sql.toString(), subId);
                    List resList = jdbc.resultSetToList();
                    if (resList == null) continue;
                    resultList.addAll(resList);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessException((Throwable)e);
                }
                finally {
                    if (jdbc != null) {
                        jdbc.close();
                    }
                }
            }
            return resultList;
        }
        return null;
    }

    @Override
    public boolean delFormData(Long formId, String ids, Long templateId, boolean needLog) throws BusinessException, SQLException {
        com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
        ModuleType moduleType = null;
        switch (Enums.FormType.getEnumByKey((int)fb.getFormType())) {
            case unFlowForm: {
                moduleType = ModuleType.cap4UnflowForm;
                break;
            }
        }
        String[] id = ids.split(",");
        LOGGER.info((Object)("delFormData ids length : " + id.length + ", formId:" + formId + ", formTemplateId:" + templateId + ", ids:" + ids));
        ArrayList<Long> deleteMasterIds = new ArrayList<Long>();
        for (int j = 0; j < id.length; ++j) {
            if (!this.cap4FormDataDAO.isExist(id[j], fb.getMasterTableBean().getTableName())) continue;
            Long masterId = Long.parseLong(id[j]);
            if (AppContext.hasPlugin((String)"index")) {
                this.indexApi.delete(Long.valueOf(Long.parseLong(id[j])), Integer.valueOf(ApplicationCategoryEnum.form.getKey()));
            }
            MainbodyService.getInstance().getContentManager().deleteContentAllByModuleId(moduleType, Long.valueOf(Long.parseLong(id[j])));
            this.deleteForm(Long.parseLong(id[j]), fb);
            this.lbsManager.deleteAttendanceInfoByMasterDataId(Long.parseLong(id[j]));
            if (moduleType == ModuleType.cap4UnflowForm && AppContext.hasPlugin((String)"taskmanage")) {
                boolean hasTaskTrigger = false;
                for (Long triggerId : fb.getFormTriggerIdList()) {
                    FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                    if (triggerBean == null || !FormTriggerBean.TriggerBusinessType.Task.getKey().equals(triggerBean.getType())) continue;
                    hasTaskTrigger = true;
                    break;
                }
                if (hasTaskTrigger) {
                    TaskmanageApi taskManageApi = (TaskmanageApi)AppContext.getBean((String)"taskmanageApi");
                    taskManageApi.deleteTaskInfoBySourceRecordId(Long.valueOf(Long.parseLong(id[j])));
                }
            }
            deleteMasterIds.add(masterId);
        }
        this.publicQrCodeManager.deletePublicQrCodeByObjectIds(deleteMasterIds);
        this.cap4FormRelationActionManager.deleteCAPFormRelationRecordByFromMasterIds(deleteMasterIds);
        return true;
    }

    @Override
    public void deleteNotInFormDataLbs(FormDataMasterBean cacheMasterData, String type) {
        try {
            Long formId = cacheMasterData.getFormTable().getFormId();
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            List fields = formBean.getAllFieldBeans();
            ArrayList<Long> notInIds = new ArrayList<Long>();
            for (com.seeyon.cap4.form.bean.FormFieldBean field : fields) {
                if ((StringUtil.checkNull((String)field.getInputType()) || !field.getInputType().equalsIgnoreCase(type)) && (StringUtil.checkNull((String)String.valueOf(field.getFormatType())) || !field.getFormatType().equalsIgnoreCase(type))) continue;
                if (field.isMasterField()) {
                    Object val = cacheMasterData.getFieldValue(field.getName());
                    if (StringUtil.checkNull((String)String.valueOf(val))) continue;
                    try {
                        notInIds.add(Long.parseLong(String.valueOf(val)));
                    }
                    catch (Exception e) {
                        LOGGER.info((Object)("\u5730\u56fe\u6807\u6ce8\u5b57\u6bb5\u5220\u9664\u65f6ID\u8f6c\u6362\u5f02\u5e38\uff0c\u5b57\u6bb5\uff1a" + field.getName() + field.getDisplay() + " \u503c\uff1a" + val));
                    }
                    continue;
                }
                List subFieldVals = cacheMasterData.getDataList(field.getName());
                for (Object subFieldVal : subFieldVals) {
                    if (StringUtil.checkNull((String)String.valueOf(subFieldVal))) continue;
                    try {
                        notInIds.add(Long.parseLong(String.valueOf(subFieldVal)));
                    }
                    catch (Exception e) {
                        LOGGER.info((Object)("\u5730\u56fe\u6807\u6ce8\u5b57\u6bb5\u5220\u9664\u65f6ID\u8f6c\u6362\u5f02\u5e38\uff0c\u5b57\u6bb5\uff1a" + field.getName() + field.getDisplay() + " \u503c\uff1a" + subFieldVal));
                    }
                }
            }
            if (notInIds.size() > 0) {
                this.lbsManager.deleteNotInFormData(cacheMasterData.getId().longValue(), notInIds);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<com.seeyon.cap4.form.bean.FormFieldBean> getBatchUpdateFieldBeans(com.seeyon.cap4.form.bean.FormBean formBean, String templateId) throws BusinessException {
        FormBindBean bindBean;
        FormBindAuthBean bindAuthBean;
        String auth;
        List fieldBeans = null;
        if (formBean.getFormType() == Enums.FormType.unFlowForm.getKey() && Strings.isNotBlank((String)(auth = (bindAuthBean = (bindBean = formBean.getBind()).getFormBindAuthBean(templateId)).getAuthByName(FormBindAuthBean.AuthName.BATHUPDATE.getKey())))) {
            List authBeans = FormUtil.convertFieldName2BeanList((String)auth, (String)",", (com.seeyon.cap4.form.bean.FormBean)formBean);
            fieldBeans = FormDesignUtil.getBathUpdateFields((com.seeyon.cap4.form.bean.FormBean)formBean, (List)authBeans);
        }
        return fieldBeans;
    }

    @Override
    public FormQueryWhereClause getFormQueryResultClauseForExport(com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> params) throws BusinessException {
        Long currentUserId = AppContext.currentUserId();
        FormQueryWhereClause customCondition = this.getCustomConditionFormQueryWhereClause(formBean, params);
        List customOrderBy = (List)params.get("userOrderBy");
        Set customShowFields = (Set)params.get("customShowFields");
        FormQueryWhereClause relationSqlWhereClause = this.getRelationConditionFormQueryWhereClause(formBean, params);
        Long templeteId = Long.parseLong(Strings.isBlank((String)String.valueOf(params.get("formTemplateId") == null ? "" : params.get("formTemplateId"))) ? "0" : params.get("formTemplateId") + "");
        List dataConditions = CAPParamUtil.getParamsListByKey(params, (String)"dataConditions");
        FormQueryWhereClause dataConditionWhereCause = this.getFieldDataConditionFormQueryWhereClause(formBean, dataConditions, true);
        FormQueryWhereClause formQueryWhereClause = null;
        try {
            formQueryWhereClause = this.getFormQuerySql(currentUserId, formBean, templeteId, FormQueryTypeEnum.unFlowExport, customCondition, customOrderBy, customShowFields, relationSqlWhereClause, dataConditionWhereCause, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"getFormQueryResultClauseForExport \u8868\u5355\u83b7\u53d6sql\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("getFormQueryResultClauseForExport \u8868\u5355\u83b7\u53d6sql\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
        }
        return formQueryWhereClause;
    }

    @Override
    @CAPFormDataCacheRemove
    public int insertData(FormDataBean dataBean) throws BusinessException, SQLException {
        int count = this.cap4FormDataDAO.insertData(dataBean);
        this.dataTrace(dataBean, "\u5b58\u50a8\u8868\u5355");
        return count;
    }

    @Override
    @CAPFormDataCacheRemove
    public int insertData(List<? extends FormDataBean> dataList) throws BusinessException, SQLException {
        int count = this.cap4FormDataDAO.insertData(dataList);
        for (FormDataBean formDataBean : dataList) {
            this.dataTrace(formDataBean, "\u5b58\u50a8\u8868\u5355");
        }
        return count;
    }

    @Override
    @CAPFormDataCacheRemove
    public int insertData(List<? extends FormDataBean> formDataBeanList, boolean updateSort) throws BusinessException, SQLException {
        int count = this.cap4FormDataDAO.insertData(formDataBeanList, updateSort);
        for (FormDataBean formDataBean : formDataBeanList) {
            this.dataTrace(formDataBean, "\u5b58\u50a8\u8868\u5355");
        }
        return count;
    }

    @Override
    @CAPFormDataCacheRemove(byId=true, formBeanPosition=2)
    public boolean deleteForm(Long masterId, com.seeyon.cap4.form.bean.FormBean formBean) throws BusinessException, SQLException {
        boolean deleteForm = this.cap4FormDataDAO.deleteForm(masterId, formBean);
        this.dataTrace(masterId, formBean, "\u5220\u9664\u8868\u5355");
        return deleteForm;
    }

    @Override
    @Deprecated
    public FormQueryWhereClause getSQLStrWhereClause(List<Map<String, Object>> conditions, Object object, boolean needTableName) {
        ArrayList<Object> queryParams = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        if (Strings.isNotEmpty(conditions)) {
            com.seeyon.cap4.form.bean.FormBean formBean = null;
            FormBean formBean3 = null;
            if (object instanceof com.seeyon.cap4.form.bean.FormBean) {
                formBean = (com.seeyon.cap4.form.bean.FormBean)object;
            } else {
                formBean3 = (FormBean)object;
            }
            String masterTableName = formBean != null ? formBean.getMasterTableBean().getTableName() : formBean3.getMasterTableBean().getTableName();
            sb.append("(");
            int j = conditions.size();
            for (int i = 0; i < j; ++i) {
                Map<String, Object> m;
                block89: {
                    Object o;
                    String op;
                    String name;
                    String ownerTableName;
                    m = conditions.get(i);
                    String fieldName = String.valueOf(m.get(FormUtil.FIELDNAME));
                    com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = null;
                    FormFieldBean formFieldBean3 = null;
                    if (formBean != null) {
                        formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                    } else {
                        formFieldBean3 = formBean3.getFieldBeanByName(fieldName, true);
                    }
                    if (formBean != null && formFieldBean == null || formBean3 != null && formFieldBean3 == null) {
                        FormUtil.getOneAndOneSql((StringBuilder)sb, m, (int)i, (int)j);
                        continue;
                    }
                    String string = ownerTableName = formFieldBean != null ? formFieldBean.getOwnerTableName() : formFieldBean3.getOwnerTableName();
                    if (needTableName) {
                        fieldName = ownerTableName + "." + fieldName;
                    }
                    String finalInputType = formFieldBean != null ? formFieldBean.getFinalInputType() : formFieldBean3.getFinalInputType(true);
                    String fieldType = formFieldBean != null ? formFieldBean.getFieldType() : formFieldBean3.getFieldType();
                    String string2 = name = formFieldBean != null ? formFieldBean.getName() : formFieldBean3.getName();
                    if (Enums.MasterTableField.state.getKey().equals(name) || Enums.MasterTableField.ratifyflag.getKey().equals(name) || Enums.MasterTableField.finishedflag.getKey().equals(name)) {
                        finalInputType = ReportConstants.FieldComType.CUSTOMENUM.getComName();
                    }
                    sb.append(FormUtil.isNull2Str((Object)m.get(FormUtil.LEFTCHAR)));
                    if (FormFieldComEnum.CHECKBOX.getKey().equalsIgnoreCase(finalInputType)) {
                        String value = FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE));
                        String option = String.valueOf(m.get(FormUtil.OPERATION));
                        sb.append("(");
                        if (Strings.isBlank((String)value) || value.contains(",")) {
                            sb.append(" 1 = 1 ");
                        } else if ("1".equals(value)) {
                            if ("=".equals(option)) {
                                sb.append(fieldName).append(" ").append(option).append(" ? ");
                                queryParams.add(value);
                            } else if ("<>".equals(option)) {
                                sb.append("(").append(fieldName).append(" ").append(option).append(" ? or ").append(fieldName).append(" is null ").append(")");
                                queryParams.add(value);
                            }
                        } else if ("0".equals(value)) {
                            if ("=".equals(option)) {
                                sb.append("(").append(fieldName).append(" ").append(option).append(" ? or ").append(fieldName).append(" is null ").append(")");
                                queryParams.add(value);
                            } else if ("<>".equals(option)) {
                                sb.append(fieldName).append(" = '1' ");
                            }
                        }
                        sb.append(")");
                        sb.append(FormUtil.isNull2Str((Object)m.get(FormUtil.RIGHTCHAR)));
                        if (i >= j - 1) continue;
                        sb.append(m.get(FormUtil.ROWOPERATION).toString()).append(" ");
                        continue;
                    }
                    if (Strings.isNotBlank((String)FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE))) && ("<>".equals(m.get(FormUtil.OPERATION).toString()) || "not_like".equals(m.get(FormUtil.OPERATION).toString()))) {
                        sb.append("(");
                        if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                            sb.append("(").append(fieldName + " is null or ").append(fieldName + " = '' ").append(")");
                        } else {
                            sb.append(fieldName + " is null ");
                        }
                        sb.append(" or ");
                    }
                    if (Strings.isBlank((String)FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE)))) {
                        if ("<=".equals(m.get(FormUtil.OPERATION).toString()) || "<".equals(m.get(FormUtil.OPERATION).toString()) || ">=".equals(m.get(FormUtil.OPERATION).toString()) || ">".equals(m.get(FormUtil.OPERATION).toString())) {
                            sb.append(" (1 = 1) ");
                        } else if ("=".equals(m.get(FormUtil.OPERATION).toString()) || "like".equals(m.get(FormUtil.OPERATION).toString()) || "include".equals(m.get(FormUtil.OPERATION).toString())) {
                            if (FormFieldComEnum.IMAGE_RADIO.getKey().equalsIgnoreCase(finalInputType)) {
                                sb.append("(").append(fieldName).append(" = '0' or ");
                            }
                            if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                                sb.append("(").append(fieldName + " is null or ").append(fieldName + " = '' ").append(")");
                            } else {
                                sb.append(fieldName + " is null ");
                            }
                            if (FormFieldComEnum.IMAGE_RADIO.getKey().equalsIgnoreCase(finalInputType)) {
                                sb.append(")");
                            }
                        } else if ("<>".equals(m.get(FormUtil.OPERATION).toString()) || "not_like".equals(m.get(FormUtil.OPERATION).toString())) {
                            if (FormFieldComEnum.IMAGE_RADIO.getKey().equalsIgnoreCase(finalInputType)) {
                                sb.append(fieldName).append(" <> '0' ");
                            } else if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                                sb.append("(").append(fieldName + " is not null or ").append(fieldName + " <> '' ").append(")");
                            } else {
                                sb.append(fieldName + " is not null ");
                            }
                        }
                        sb.append(FormUtil.isNull2Str((Object)m.get(FormUtil.RIGHTCHAR))).append(" ");
                        if (i >= j - 1) continue;
                        sb.append(m.get(FormUtil.ROWOPERATION).toString()).append(" ");
                        continue;
                    }
                    if ("0".equals(FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE))) && FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(finalInputType)) {
                        sb.append(" (1 = 1) ");
                        sb.append(FormUtil.isNull2Str((Object)m.get(FormUtil.RIGHTCHAR))).append(" ");
                        if (i >= j - 1) continue;
                        sb.append(m.get(FormUtil.ROWOPERATION).toString()).append(" ");
                        continue;
                    }
                    if (Enums.MasterTableField.start_date.getKey().equalsIgnoreCase(name) || Enums.MasterTableField.modify_date.getKey().equalsIgnoreCase(name)) {
                        try {
                            FormQueryWhereClause myWhereClause = FormUtil.getDateTimeWhereClauseSql(m, (String)masterTableName, (boolean)needTableName);
                            if (null == myWhereClause) break block89;
                            if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                sb.append(myWhereClause.getAllSqlClause());
                            }
                            if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                queryParams.addAll(myWhereClause.getQueryParams());
                            }
                        }
                        catch (ParseException e) {
                            LOGGER.error((Object)"\u8bbe\u7f6e\u5f00\u59cb\u65e5\u671f\uff0c\u7ed3\u675f\u65e5\u671f\u65f6\u6761\u4ef6\u65f6\uff0c\u5f02\u5e38", (Throwable)e);
                        }
                    } else if (Enums.MasterTableField.getEnumByKey((String)fieldName) != null && !FormFieldComEnum.EXTEND_MEMBER.getKey().equalsIgnoreCase(finalInputType)) {
                        op = m.get(FormUtil.OPERATION).toString();
                        o = FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE));
                        fieldName = FormUtil.getFieldName4SQL((String)fieldName, (String)masterTableName, (boolean)false);
                        sb.append(fieldName).append(op).append(" ? ");
                        queryParams.add(String.valueOf(o));
                    } else {
                        op = m.get(FormUtil.OPERATION).toString();
                        o = FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE));
                        if (FormFieldComEnum.EXTEND_MEMBER.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.EXTEND_LEVEL.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.EXTEND_POST.getKey().equalsIgnoreCase(finalInputType)) {
                            op = "<>".equals(op) ? "not in" : "in";
                            fieldName = FormUtil.getFieldName4SQL((String)fieldName, (String)ownerTableName, (boolean)false);
                            StringBuilder valueSb = new StringBuilder();
                            String[] values = String.valueOf(o).split(",");
                            int l = values.length;
                            for (int k = 0; k < l; ++k) {
                                if (k == l - 1) {
                                    valueSb.append("?");
                                } else {
                                    valueSb.append("?,");
                                }
                                queryParams.add(values[k]);
                            }
                            sb.append(fieldName).append(" ").append(op).append(" (").append(valueSb.toString()).append(") ");
                        } else {
                            String value = "?";
                            boolean isEnumField = false;
                            if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.RADIO.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.IMAGE_RADIO.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.IMAGE_SELECT.getKey().equalsIgnoreCase(finalInputType) || ReportConstants.FieldComType.CUSTOMENUM.getComName().equals(finalInputType)) {
                                FormQueryWhereClause myWhereClause;
                                if (formBean != null) {
                                    com.seeyon.cap4.form.modules.engin.formula.function.FormFormulaFunctionCompareEnumValue enumFunction = new com.seeyon.cap4.form.modules.engin.formula.function.FormFormulaFunctionCompareEnumValue();
                                    myWhereClause = enumFunction.getEnumCompareWhereClause(true, formBean, true, false, fieldName, op, String.valueOf(o));
                                    if (null != myWhereClause) {
                                        if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                            sb.append(myWhereClause.getAllSqlClause());
                                        }
                                        if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                            queryParams.addAll(myWhereClause.getQueryParams());
                                        }
                                    }
                                } else {
                                    FormFormulaFunctionCompareEnumValue enumFunction3 = new FormFormulaFunctionCompareEnumValue();
                                    myWhereClause = enumFunction3.getEnumCompareWhereClause(true, formBean3, true, false, fieldName, op, String.valueOf(o));
                                    if (null != myWhereClause) {
                                        if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                            sb.append(myWhereClause.getAllSqlClause());
                                        }
                                        if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                            queryParams.addAll(myWhereClause.getQueryParams());
                                        }
                                    }
                                }
                                isEnumField = true;
                            }
                            if (!isEnumField) {
                                fieldName = FormUtil.getFieldName4SQL((String)fieldName, (String)ownerTableName, (boolean)false);
                                if (!FormulaEnums.ConditionSymbol.include.getKey().equals(op)) {
                                    if (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equalsIgnoreCase(finalInputType)) {
                                        FormQueryWhereClause myWhereClause = FormUtil.getDepartmentsLogicWhereClauseSQL((String)"", (String)String.valueOf(o), (String)fieldName, (String)op);
                                        if (null != myWhereClause) {
                                            if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                                sb.append(myWhereClause.getAllSqlClause());
                                            }
                                            if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                                queryParams.addAll(myWhereClause.getQueryParams());
                                            }
                                        }
                                    } else if (FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equalsIgnoreCase(finalInputType)) {
                                        FormQueryWhereClause myWhereClause = FormUtil.getMultilDepartmentEqualNotEqualWhereClauseSQL((String)"", (String)String.valueOf(o), (String)fieldName, (String)op);
                                        if (null != myWhereClause) {
                                            if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                                sb.append(myWhereClause.getAllSqlClause());
                                            }
                                            if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                                queryParams.addAll(myWhereClause.getQueryParams());
                                            }
                                        }
                                    } else if (op.contains(FormulaEnums.ConditionSymbol.like.getKey())) {
                                        op = op.replace(FormulaEnums.ConditionSymbol.like.getKey(), " " + FormulaEnums.ConditionSymbol.like.getKey()).replace("_", "");
                                        if (FormFieldComEnum.TEXT.getKey().equalsIgnoreCase(finalInputType) || FormFieldComEnum.TEXTAREA.getKey().equalsIgnoreCase(finalInputType)) {
                                            String[] values = o.toString().split("[ ]");
                                            sb.append("(");
                                            for (int k = 0; k < values.length; ++k) {
                                                sb.append(fieldName).append(" ").append(op).append(" ").append(" ? ").append(SQLWildcardUtil.setEscapeCharacter());
                                                queryParams.add("%" + SQLWildcardUtil.escape((String)values[k]) + "%");
                                                if (k == values.length - 1) continue;
                                                sb.append(" and ");
                                            }
                                            sb.append(" )");
                                        } else {
                                            o = "%" + SQLWildcardUtil.escape((String)String.valueOf(o)) + "%";
                                            queryParams.add(o);
                                            sb.append(fieldName).append(" ").append(op).append(" ").append(value).append(" ");
                                        }
                                    } else {
                                        o = FormUtil.getHQLObject((Object)(formBean != null ? formBean : formBean3), (String)fieldName, (String)String.valueOf(o));
                                        queryParams.add(o);
                                        sb.append(fieldName).append(" ").append(op).append(" ").append(value).append(" ");
                                    }
                                } else {
                                    StringBuilder valueStr = new StringBuilder();
                                    String oStr = String.valueOf(o);
                                    if (oStr.contains(",")) {
                                        String[] oStrs = oStr.split(",");
                                        valueStr.append(" (");
                                        for (int k = 0; k < oStrs.length; ++k) {
                                            FormQueryWhereClause myWhereClause = FormUtil.getDepartmentsLogicWhereClauseSQL((String)"", (String)oStrs[k], (String)fieldName, (String)" like ");
                                            if (null != myWhereClause) {
                                                if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                                    valueStr.append(myWhereClause.getAllSqlClause());
                                                }
                                                if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                                    queryParams.addAll(myWhereClause.getQueryParams());
                                                }
                                            }
                                            if (k == oStrs.length - 1) continue;
                                            valueStr.append(" or ");
                                        }
                                        valueStr.append(" )");
                                    } else {
                                        FormQueryWhereClause myWhereClause = FormUtil.getDepartmentsLogicWhereClauseSQL((String)"", (String)oStr, (String)fieldName, (String)" like ");
                                        if (null != myWhereClause) {
                                            if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                                                valueStr.append(myWhereClause.getAllSqlClause());
                                            }
                                            if (null != myWhereClause.getQueryParams() && !myWhereClause.getQueryParams().isEmpty()) {
                                                queryParams.addAll(myWhereClause.getQueryParams());
                                            }
                                        }
                                    }
                                    sb.append((CharSequence)valueStr);
                                }
                            }
                        }
                    }
                }
                sb.append(FormUtil.isNull2Str((Object)m.get(FormUtil.RIGHTCHAR))).append(" ");
                if (Strings.isNotBlank((String)FormUtil.isNull2Str((Object)m.get(FormUtil.FIELDVALUE))) && ("<>".equals(m.get(FormUtil.OPERATION).toString()) || "not_like".equals(m.get(FormUtil.OPERATION).toString()))) {
                    sb.append(")");
                }
                if (i >= j - 1) continue;
                sb.append(m.get(FormUtil.ROWOPERATION).toString()).append(" ");
            }
            sb.append(") ");
        }
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        whereClause.setAllSqlClause(sb.toString());
        whereClause.setQueryParams(queryParams);
        return whereClause;
    }

    @Override
    public FormQueryResult getFormQueryResult(Long currentUserId, FlipInfo flipInfo, boolean isNeedPage, com.seeyon.cap4.form.bean.FormBean formBean, Long templeteId, FormQueryTypeEnum queryType, FormQueryWhereClause customCondition, List<Map<String, Object>> customOrderBy, Set<String> customShowFields, FormQueryWhereClause relationSqlWhereClause, FormQueryWhereClause dataConditionWhereCause, boolean reverse) throws BusinessException {
        this.infoQueryTypeLog(queryType);
        try {
            FormQueryWhereClause querySql = this.getFormQuerySql(currentUserId, formBean, templeteId, queryType, customCondition, customOrderBy, customShowFields, relationSqlWhereClause, dataConditionWhereCause, reverse);
            LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868\u751f\u6210\u7684\u67e5\u8be2sql\u8bed\u53e5\uff1a" + querySql.getAllSqlClause()));
            LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868\u751f\u6210\u7684\u67e5\u8be2sql\u53c2\u6570\uff1a" + querySql.getQueryParams()));
            FormTableBean masterTableBean = formBean.getMasterTableBean();
            this.cap4FormDataDAO.selectMasterDataList(flipInfo, masterTableBean, querySql.getAllSqlClause(), querySql.getQueryParams());
            FormQueryResult queryResult = new FormQueryResult();
            queryResult.setFlipInfo(flipInfo);
            queryResult.setQuerySql(querySql.getAllSqlClause());
            queryResult.setQueryParams(querySql.getQueryParams());
            return queryResult;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8868\u5355\u516c\u5171\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("\u8868\u5355\u516c\u5171\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private FormQueryWhereClause getFormQuerySql(Long currentUserId, com.seeyon.cap4.form.bean.FormBean formBean, Long templeteId, FormQueryTypeEnum queryType, FormQueryWhereClause customSqlWhereClause, List<Map<String, Object>> customOrderBy, Set<String> customShowFields, FormQueryWhereClause relationSqlWhereClause, FormQueryWhereClause dataConditionWhereCause, boolean reverse) throws Exception {
        StringBuffer sql = new StringBuffer("");
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        FormBindBean bindBean = formBean.getBind();
        List<FormBindAuthBean> bindAuthList = new ArrayList();
        if (templeteId == null || templeteId == 0L) {
            bindAuthList = bindBean.getUnflowFormBindAuthByUserId(currentUserId);
        } else {
            FormBindAuthBean firstFormBindAuthBean = bindBean.getFormBindAuthBean(String.valueOf(templeteId));
            bindAuthList.add(firstFormBindAuthBean);
        }
        int size = bindAuthList.size();
        boolean multiBinds = size != 1;
        String[] bindSqls = new String[size];
        FormBindAuthBean firstFormBindAuthBean = null;
        ArrayList<FormQueryWhereClause> whereClauseList = new ArrayList<FormQueryWhereClause>();
        for (int i = 0; i < size; ++i) {
            FormBindAuthBean bindAuth = (FormBindAuthBean)bindAuthList.get(i);
            if (i == 0) {
                firstFormBindAuthBean = bindAuth;
            }
            FormQueryWhereClause oneWhereClause = this.getFormQueryWhereClauseForOneBind(formBean, firstFormBindAuthBean, bindAuth, customSqlWhereClause, relationSqlWhereClause, dataConditionWhereCause, multiBinds, reverse, customOrderBy, customShowFields, queryType);
            if (whereClauseList.isEmpty()) {
                whereClauseList.add(oneWhereClause);
                continue;
            }
            boolean isAdd = false;
            block1: for (FormQueryWhereClause formQueryWhereClause : whereClauseList) {
                String whereSql = formQueryWhereClause.getWhereClause();
                if (whereSql.equals(oneWhereClause.getWhereClause())) {
                    List queryParams = formQueryWhereClause.getQueryParams();
                    List oneQueryParams = oneWhereClause.getQueryParams();
                    if (Strings.isNotEmpty((Collection)queryParams) && queryParams.size() == oneQueryParams.size()) {
                        for (int k = 0; k < queryParams.size(); ++k) {
                            Object o2;
                            Object o1 = queryParams.get(k);
                            if (Strings.equals(o1, o2 = oneQueryParams.get(k))) continue;
                            isAdd = true;
                            continue block1;
                        }
                        continue;
                    }
                    LOGGER.error((Object)("--sql param is error-->" + queryParams + "<----->" + oneQueryParams));
                    continue;
                }
                isAdd = true;
            }
            if (!isAdd) continue;
            whereClauseList.add(oneWhereClause);
        }
        if (multiBinds && whereClauseList.size() > 1) {
            ArrayList allParams = new ArrayList();
            for (int i = 0; i < whereClauseList.size(); ++i) {
                FormQueryWhereClause abindWhereClause = (FormQueryWhereClause)whereClauseList.get(i);
                if (i == 0) {
                    sql.append(" ").append(abindWhereClause.getAllSqlClause()).append(" ");
                    if (Strings.isBlank((String)abindWhereClause.getWhereClause())) {
                        break;
                    }
                } else if (Strings.isNotBlank((String)abindWhereClause.getWhereClause())) {
                    for (String formson : abindWhereClause.getFormsons()) {
                        if (sql.indexOf(formson) != -1) continue;
                        sql = sql.replace(sql.indexOf("where"), sql.indexOf("where") + 5, "," + formson + " where");
                    }
                    sql.append(" or ").append(abindWhereClause.getWhereClause());
                } else {
                    sql.append(" or 1=1 ");
                }
                if (null == abindWhereClause.getQueryParams() || abindWhereClause.getQueryParams().isEmpty()) continue;
                allParams.addAll(abindWhereClause.getQueryParams());
            }
            String sortFields = firstFormBindAuthBean.getSortStr(masterTableBean.getTableName(), reverse);
            sortFields = " order by " + (Strings.isBlank((String)sortFields) ? "" : sortFields + ",");
            String collation = " asc ";
            if (reverse) {
                collation = "desc";
            }
            sortFields = !sortFields.contains("start_date") ? sortFields + masterTableBean.getTableName() + ".start_date " + collation + " " : sortFields.substring(0, sortFields.lastIndexOf(","));
            sql.append(sortFields).append(",").append(masterTableBean.getTableName()).append(".id ").append(collation).append(" ");
            FormQueryWhereClause allQueryClause = new FormQueryWhereClause();
            allQueryClause.setAllSqlClause(sql.toString().replaceAll("<> null", "is not null"));
            allQueryClause.setQueryParams(allParams);
            return allQueryClause;
        }
        if (multiBinds && whereClauseList.size() == 1) {
            String collation;
            String sortFields;
            FormQueryWhereClause queryClause = (FormQueryWhereClause)whereClauseList.get(0);
            String s = queryClause.getAllSqlClause();
            if (Strings.isNotBlank((String)s) && s.indexOf("order by") < 0) {
                sortFields = firstFormBindAuthBean.getSortStr(masterTableBean.getTableName(), reverse);
                sortFields = " order by " + (Strings.isBlank((String)sortFields) ? "" : sortFields + ",");
                collation = " asc ";
                if (reverse) {
                    collation = "desc";
                }
            } else {
                if (Strings.isNotBlank((String)s)) {
                    queryClause.setAllSqlClause(queryClause.getAllSqlClause().replaceAll("<> null", "is not null"));
                }
                return queryClause;
            }
            sortFields = !sortFields.contains("start_date") ? sortFields + masterTableBean.getTableName() + ".start_date " + collation + " " : sortFields.substring(0, sortFields.lastIndexOf(","));
            StringBuilder sortFieldsSb = new StringBuilder("");
            sortFieldsSb.append(sortFields).append(",").append(masterTableBean.getTableName()).append(".id ").append(collation).append(" ");
            queryClause.setAllSqlClause(queryClause.getAllSqlClause().replaceAll("<> null", "is not null") + sortFieldsSb.toString());
            return queryClause;
        }
        FormQueryWhereClause queryClause = (FormQueryWhereClause)whereClauseList.get(0);
        if (Strings.isNotBlank((String)queryClause.getAllSqlClause())) {
            String allSql = queryClause.getAllSqlClause();
            allSql = allSql.replaceAll("<> null", "is not null");
            if (Strings.isNotBlank((String)queryClause.getOrderByClause())) {
                allSql = allSql + "order by " + queryClause.getOrderByClause();
            }
            queryClause.setAllSqlClause(allSql);
        }
        return queryClause;
    }

    private FormQueryWhereClause getFormQueryWhereClauseForOneBind(com.seeyon.cap4.form.bean.FormBean formBean, FormBindAuthBean firstFormBindAuthBean, FormBindAuthBean bindAuth, FormQueryWhereClause customSqlWhereClause, FormQueryWhereClause relationSqlWhereClause, FormQueryWhereClause dataConditionWhereCause, boolean multiBinds, boolean reverse, List<Map<String, Object>> customOrderBy, Set<String> customShowFields, FormQueryTypeEnum queryType) {
        String contentDataId;
        FormFormulaBean formulaBean = bindAuth.getFormFormulaBean();
        FormQueryWhereClause allWhereClause = new FormQueryWhereClause();
        ArrayList queryParams = new ArrayList();
        StringBuffer sb = new StringBuffer("");
        if (formulaBean != null) {
            FormQueryWhereClause formulaWhereClause = formulaBean.getExecuteFormulaForWhereClauseSQL(null, true, true);
            if (null != formulaWhereClause) {
                if (Strings.isNotBlank((String)formulaWhereClause.getAllSqlClause())) {
                    sb.append(" (").append(formulaWhereClause.getAllSqlClause()).append(") ");
                }
                if (null != formulaWhereClause.getQueryParams() && !formulaWhereClause.getQueryParams().isEmpty()) {
                    queryParams.addAll(formulaWhereClause.getQueryParams());
                }
            }
            if (null != customSqlWhereClause) {
                if (Strings.isNotBlank((String)customSqlWhereClause.getAllSqlClause())) {
                    sb.append(" and (").append(customSqlWhereClause.getAllSqlClause()).append(") ");
                }
                if (null != customSqlWhereClause.getQueryParams() && !customSqlWhereClause.getQueryParams().isEmpty()) {
                    queryParams.addAll(customSqlWhereClause.getQueryParams());
                }
            }
            if (null != relationSqlWhereClause) {
                if (Strings.isNotBlank((String)relationSqlWhereClause.getAllSqlClause())) {
                    sb.append(" and (").append(relationSqlWhereClause.getAllSqlClause()).append(") ");
                }
                if (null != relationSqlWhereClause.getQueryParams() && !relationSqlWhereClause.getQueryParams().isEmpty()) {
                    queryParams.addAll(relationSqlWhereClause.getQueryParams());
                }
            }
            if (null != dataConditionWhereCause) {
                if (Strings.isNotBlank((String)dataConditionWhereCause.getAllSqlClause())) {
                    sb.append(" and (").append(dataConditionWhereCause.getAllSqlClause()).append(") ");
                }
                if (null != dataConditionWhereCause.getQueryParams() && !dataConditionWhereCause.getQueryParams().isEmpty()) {
                    queryParams.addAll(dataConditionWhereCause.getQueryParams());
                }
            }
        } else {
            boolean hasSql = false;
            if (null != customSqlWhereClause) {
                if (Strings.isNotBlank((String)customSqlWhereClause.getAllSqlClause())) {
                    sb.append(" (").append(customSqlWhereClause.getAllSqlClause()).append(") ");
                    hasSql = true;
                }
                if (null != customSqlWhereClause.getQueryParams() && !customSqlWhereClause.getQueryParams().isEmpty()) {
                    queryParams.addAll(customSqlWhereClause.getQueryParams());
                }
            }
            if (null != relationSqlWhereClause) {
                if (Strings.isNotBlank((String)relationSqlWhereClause.getAllSqlClause())) {
                    if (hasSql) {
                        sb.append(" and (").append(relationSqlWhereClause.getAllSqlClause()).append(") ");
                    } else {
                        sb.append(" (").append(relationSqlWhereClause.getAllSqlClause()).append(") ");
                        hasSql = true;
                    }
                }
                if (null != relationSqlWhereClause.getQueryParams() && !relationSqlWhereClause.getQueryParams().isEmpty()) {
                    queryParams.addAll(relationSqlWhereClause.getQueryParams());
                }
            }
            if (null != dataConditionWhereCause) {
                if (Strings.isNotBlank((String)dataConditionWhereCause.getAllSqlClause())) {
                    if (hasSql) {
                        sb.append(" and (").append(dataConditionWhereCause.getAllSqlClause()).append(") ");
                    } else {
                        sb.append(" (").append(dataConditionWhereCause.getAllSqlClause()).append(") ");
                    }
                }
                if (null != dataConditionWhereCause.getQueryParams() && !dataConditionWhereCause.getQueryParams().isEmpty()) {
                    queryParams.addAll(dataConditionWhereCause.getQueryParams());
                }
            }
        }
        boolean fromCheckRight = false;
        String string = contentDataId = AppContext.getThreadContext((String)"check_right_data_id") == null ? "" : AppContext.getThreadContext((String)"check_right_data_id").toString();
        if (Strings.isNotBlank((String)contentDataId)) {
            fromCheckRight = true;
        }
        String whereClause = sb.toString();
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        List showFieldObjs = firstFormBindAuthBean.getShowFieldList();
        for (int i = 0; i < showFieldObjs.size(); ++i) {
            SimpleObjectBean showField = (SimpleObjectBean)showFieldObjs.get(i);
            String fieldName = showField.getName();
            if (!fieldName.contains(".")) {
                fieldName = masterTableBean.getTableName() + "." + fieldName;
            }
            fieldSet.add(fieldName);
        }
        if (customShowFields != null && !customShowFields.isEmpty()) {
            for (String field : customShowFields) {
                if (field.indexOf(".") == -1) {
                    field = masterTableBean.getTableName() + "." + field;
                }
                fieldSet.add(field);
            }
        }
        String[] constFieldStrs = Enums.MasterTableField.getKeys();
        for (int i = 0; i < constFieldStrs.length; ++i) {
            String constFieldStr = masterTableBean.getTableName() + "." + constFieldStrs[i];
            if (fieldSet.contains(constFieldStr)) continue;
            fieldSet.add(constFieldStr);
        }
        String[] fields = new String[fieldSet.size()];
        int j = 0;
        for (String s : fieldSet) {
            fields[j++] = s;
        }
        String fieldNames = com.seeyon.cap4.form.util.StringUtils.arrayToString((String[])fields);
        StringBuffer sql = new StringBuffer();
        if (fromCheckRight || queryType == FormQueryTypeEnum.unFlowExport) {
            sql.append(" select ").append(masterTableBean.getTableName()).append(".id");
        } else {
            sql.append(" select DISTINCT ").append(fieldNames);
        }
        sql.append(" from ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
        List allFields = formBean.getAllFieldBeans();
        StringBuffer from = new StringBuffer(" ");
        for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : allFields) {
            if (fieldBean.isConstantField() || fieldBean.isMasterField()) continue;
            if (from.indexOf(fieldBean.getOwnerTableName()) == -1 && sql.indexOf(fieldBean.getName()) != -1) {
                from.append(",").append(fieldBean.getOwnerTableName());
                allWhereClause.putFormson(fieldBean.getOwnerTableName());
            }
            if (from.indexOf(fieldBean.getOwnerTableName()) == -1 && whereClause.indexOf(fieldBean.getName()) != -1) {
                from.append(",").append(fieldBean.getOwnerTableName());
                allWhereClause.putFormson(fieldBean.getOwnerTableName());
            }
            if (from.indexOf(fieldBean.getOwnerTableName()) != -1 || whereClause.indexOf(fieldBean.getName()) == -1) continue;
            from.append(",").append(fieldBean.getOwnerTableName());
            allWhereClause.putFormson(fieldBean.getOwnerTableName());
        }
        sql.append(from);
        List subTables = formBean.getSubTableBean();
        StringBuffer subTablewhereSb = new StringBuffer("");
        for (int i = 0; i < subTables.size(); ++i) {
            if (((FormTableBean)subTables.get(i)).isMainTable() || sql.indexOf(((FormTableBean)subTables.get(i)).getTableName()) == -1 || subTablewhereSb.indexOf(((FormTableBean)subTables.get(i)).getTableName()) != -1) continue;
            subTablewhereSb.append(" (").append(((FormTableBean)subTables.get(i)).getTableName()).append(".").append(Enums.SubTableField.formmain_id.getKey()).append("=").append(formBean.getMasterTableBean().getTableName()).append(".").append(Enums.MasterTableField.id.getKey()).append(") ");
            subTablewhereSb.append(" and ");
        }
        int andIndex = subTablewhereSb.lastIndexOf("and ");
        if (andIndex != -1) {
            subTablewhereSb = subTablewhereSb.replace(andIndex, andIndex + "and ".length(), "");
        }
        if (!StringUtil.checkNull((String)subTablewhereSb.toString().trim())) {
            whereClause = subTablewhereSb.append(" and ").append(whereClause).toString();
        }
        if (fromCheckRight) {
            whereClause = !StringUtil.checkNull((String)whereClause.trim()) ? " " + masterTableBean.getTableName() + ".id = " + contentDataId + " and " + whereClause : " " + masterTableBean.getTableName() + ".id = " + contentDataId;
        }
        if (!StringUtil.checkNull((String)whereClause.trim())) {
            sql.append(" where ");
            whereClause = FormUtil.changeAndAddNullWhereSql((String)whereClause);
            sql.append(whereClause);
        }
        allWhereClause.setWhereClause(whereClause);
        andIndex = sql.lastIndexOf("and ");
        if (andIndex != -1 && andIndex == sql.length() - "and ".length()) {
            sql = sql.replace(andIndex, andIndex + "and ".length(), "");
        }
        boolean customSort = false;
        if (!Strings.isEmpty(customOrderBy)) {
            this.getCustomOrderByString(customOrderBy, allWhereClause, reverse, masterTableBean.getTableName());
            customSort = true;
        }
        if (!(multiBinds || customSort || fromCheckRight || queryType == FormQueryTypeEnum.unFlowExport)) {
            String sortFields = firstFormBindAuthBean.getSortStr(masterTableBean.getTableName(), reverse);
            sortFields = " order by " + (Strings.isBlank((String)sortFields) ? "" : sortFields + ",");
            String collation = " asc ";
            if (reverse) {
                collation = "desc";
            }
            sortFields = !sortFields.contains("start_date") ? sortFields + masterTableBean.getTableName() + ".start_date " + collation + " " : sortFields.substring(0, sortFields.lastIndexOf(","));
            sql.append(" ").append(sortFields).append(",").append(masterTableBean.getTableName()).append(".id ").append(collation).append(" ");
        }
        allWhereClause.setAllSqlClause(sql.toString());
        allWhereClause.setQueryParams(queryParams);
        return allWhereClause;
    }

    @Override
    public void getCustomOrderByString(List<Map<String, Object>> sortList, FormQueryWhereClause allWhereClause, boolean reverse, String tableName) {
        String tablePrefix;
        LinkedHashSet<String> sortSet = new LinkedHashSet<String>();
        String string = tablePrefix = Strings.isNotBlank((String)tableName) ? tableName + "." : "";
        if (Strings.isNotEmpty(sortList)) {
            boolean orderByHasNull = this.orderByHasNull();
            for (Map<String, Object> map : sortList) {
                String orderType = map.get("orderType").toString();
                String fieldName = String.valueOf(map.get("fieldName"));
                StringBuilder sb = new StringBuilder();
                sb.append(tablePrefix).append(fieldName).append(" ").append(orderType);
                if (orderByHasNull) {
                    if ("asc".equalsIgnoreCase(orderType)) {
                        sb.append(NULLS_FIRST);
                    } else {
                        sb.append(NULLS_LAST);
                    }
                }
                sortSet.add(sb.toString());
            }
        }
        if (sortSet.isEmpty() || !org.apache.commons.lang3.StringUtils.join(sortSet, (String)",").contains(Enums.MasterTableField.start_date.getKey())) {
            sortSet.add(tablePrefix + Enums.MasterTableField.start_date.getKey() + " asc");
        }
        sortSet.add(tablePrefix + Enums.MasterTableField.id.getKey() + " asc");
        allWhereClause.setOrderByClause(org.apache.commons.lang3.StringUtils.join(sortSet, (String)","));
    }

    private boolean orderByHasNull() {
        boolean result = false;
        String dbType = SystemEnvironment.getDatabaseType();
        if ("dm dbms".equals(dbType) || "Oracle".equalsIgnoreCase(dbType) || "PostgreSQL".equalsIgnoreCase(dbType)) {
            result = true;
        }
        return result;
    }

    @Override
    public String checkBindsNum(Map<String, Object> params) {
        Long formId;
        com.seeyon.cap4.form.bean.FormBean formBean;
        String msg = "";
        String formIdStr = (String)params.get("formId");
        if (Strings.isNotBlank((String)formIdStr) && (formBean = this.cap4FormCacheManager.getForm(formId = Long.valueOf(Long.parseLong(formIdStr)))).getFormType() == Enums.FormType.unFlowForm.getKey()) {
            FormBindBean bindBean = formBean.getBind();
            long currentUserId = AppContext.getCurrentUser().getId();
            List bindAuthList = new ArrayList();
            try {
                bindAuthList = bindBean.getUnflowFormBindAuthByUserId(Long.valueOf(currentUserId));
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            if (bindAuthList.size() > 5) {
                msg = ResourceUtil.getString((String)"form.check.bindnum");
            }
        }
        return msg;
    }

    private boolean isChildrenWorkFlow(ColSummary colSummary) {
        return Integer.valueOf(ColConstant.NewflowType.child.ordinal()).equals(colSummary.getNewflowType());
    }

    @Override
    @CAPFormDataCacheRemove
    public void insertMasterData(List<FormDataMasterBean> masterBeanList) throws BusinessException, SQLException {
        this.insertOrUpdateMasterData(masterBeanList, false);
        for (FormDataMasterBean masterBean : masterBeanList) {
            this.dataTrace((FormDataBean)masterBean, "\u5b58\u50a8\u8868\u5355");
        }
    }

    @Override
    @CAPFormDataCacheRemove(dataBeanPosition=1)
    public void insertOrUpdateMasterData(List<FormDataMasterBean> masterBeanList, boolean needDelete) throws BusinessException, SQLException {
        this.cap4FormDataDAO.insertOrUpdateMasterData(masterBeanList, needDelete);
        for (FormDataMasterBean masterBean : masterBeanList) {
            this.dataTrace((FormDataBean)masterBean, "\u5b58\u50a8\u8868\u5355");
        }
    }

    @Override
    @CAPFormDataCacheRemove
    public void deleteMasterData(List<FormDataMasterBean> masterBeanList) throws BusinessException, SQLException {
        this.cap4FormDataDAO.deleteMasterData(masterBeanList);
        for (FormDataMasterBean masterBean : masterBeanList) {
            this.dataTrace((FormDataBean)masterBean, "\u5220\u9664\u8868\u5355");
        }
    }

    @Override
    @CAPFormDataCacheRemove(byId=true, formBeanPosition=2)
    public void deleteData(Long masterId, com.seeyon.cap4.form.bean.FormBean formBean) throws BusinessException, SQLException {
        this.cap4FormDataDAO.deleteForm(masterId, formBean);
        this.dataTrace(masterId, formBean, "\u5220\u9664\u8868\u5355");
    }

    @Override
    public void deleteFlowData(com.seeyon.cap4.form.bean.FormBean formBean, List<Long> summaryIds) throws BusinessException, SQLException {
        if (Strings.isEmpty(summaryIds)) {
            return;
        }
        LOGGER.info((Object)("deleteFlowData " + formBean.getId() + " user " + AppContext.currentUserId() + " summaryIds " + summaryIds.toString()));
        Iterator<Long> iterator = summaryIds.iterator();
        ArrayList<Long> masterIds = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Long summaryId = iterator.next();
            ColSummary colSummary = this.collaborationApi.getColSummary(summaryId);
            if (colSummary == null) continue;
            this.deleteData(colSummary.getFormRecordid(), formBean);
            masterIds.add(colSummary.getFormRecordid());
        }
        this.cap4FormRelationActionManager.deleteCAPFormRelationRecordByFromMasterIds(masterIds);
    }

    @Override
    public boolean isUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, List<String> fieldList, List<String> indexList, List<FormDataMasterBean> masterBeans) throws BusinessException {
        String mainTableName = fb.getMasterTableBean().getTableName();
        String subTableName = "";
        boolean hasMainTable = false;
        boolean hasSubTable = false;
        ArrayList<String> subFieldList = new ArrayList<String>();
        ArrayList<String> mainFieldList = new ArrayList<String>();
        boolean subIndexField = false;
        String indexFieldName = null;
        for (String fieldName : fieldList) {
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (ffb.isMasterField()) {
                hasMainTable = true;
                mainFieldList.add(fieldName);
                continue;
            }
            hasSubTable = true;
            subTableName = ffb.getOwnerTableName();
            subFieldList.add(fieldName);
            if (subIndexField || !indexList.contains(fieldName)) continue;
            subIndexField = true;
            indexFieldName = fieldName;
        }
        JDBCAgent jdbc = null;
        try {
            HashMap<String, List<Object>> subIndexValueListMap;
            jdbc = new JDBCAgent(false);
            if (hasMainTable && hasSubTable && subIndexField) {
                boolean executeNewLogic = false;
                subIndexValueListMap = new HashMap<String, List<Object>>();
                block12: for (FormDataMasterBean masterBean : masterBeans) {
                    for (String subField : subFieldList) {
                        if (subField == null || masterBean == null) continue;
                        List dataList = masterBean.getDataList(subField);
                        if (dataList != null && dataList.get(0) != null && dataList.size() > 0) {
                            subIndexValueListMap.put(subField, dataList);
                            executeNewLogic = true;
                            continue;
                        }
                        executeNewLogic = false;
                        continue block12;
                    }
                }
                if (executeNewLogic) {
                    boolean bl = this.hasSubTableUniqueMarked(fb, jdbc, fieldList, subIndexValueListMap, subFieldList, mainTableName, subTableName);
                    return bl;
                }
                boolean bl = this.isUniqueMarked(fb, fieldList);
                return bl;
            }
            if (hasMainTable && !hasSubTable) {
                boolean executeNewLogic = false;
                HashMap<String, List<Object>> mainIndexValueListMap = new HashMap<String, List<Object>>();
                block14: for (FormDataMasterBean masterBean : masterBeans) {
                    for (String mainField : mainFieldList) {
                        if (mainField == null || masterBean == null) continue;
                        List dataList = masterBean.getDataList(mainField);
                        if (dataList != null && dataList.get(0) != null && dataList.size() > 0) {
                            executeNewLogic = true;
                            mainIndexValueListMap.put(mainField, dataList);
                            continue;
                        }
                        executeNewLogic = false;
                        continue block14;
                    }
                }
                if (executeNewLogic) {
                    boolean bl = this.hasOnlyMainTableUniqueMarked(fb, jdbc, fieldList, mainIndexValueListMap, mainTableName);
                    return bl;
                }
                boolean bl = this.isUniqueMarked(fb, fieldList);
                return bl;
            }
            if (!hasMainTable && hasSubTable) {
                boolean executeNewLogic = false;
                subIndexValueListMap = new HashMap();
                for (FormDataMasterBean masterBean : masterBeans) {
                    if (indexFieldName == null || masterBean == null) continue;
                    List dataList = masterBean.getDataList(indexFieldName);
                    if (dataList != null && dataList.get(0) != null && dataList.size() > 0) {
                        executeNewLogic = true;
                        subIndexValueListMap.put(indexFieldName, dataList);
                        continue;
                    }
                    executeNewLogic = false;
                    break;
                }
                if (executeNewLogic) {
                    boolean bl = this.hasOnlySubTableUniqueMarked(fb, jdbc, fieldList, indexFieldName, subIndexValueListMap, subTableName);
                    return bl;
                }
                boolean bl = this.isUniqueMarked(fb, fieldList);
                return bl;
            }
            boolean executeNewLogic = this.isUniqueMarked(fb, fieldList);
            return executeNewLogic;
        }
        catch (Throwable e) {
            LOGGER.info((Object)("\u552f\u4e00\u6807\u8bc6-newlogic\uff1a" + mainTableName + " \u8868\u5355\u540d\u79f0:" + fb.getFormName() + "\u3002\u5177\u4f53\u9519\u8bef\u89c1" + e.getMessage()));
            throw new BusinessException(e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    private boolean hasOnlySubTableUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, JDBCAgent jdbc, List<String> fieldList, String indexFieldName, Map<String, List<Object>> indexValueListMap, String tableName) throws BusinessException {
        long beginTime = System.currentTimeMillis();
        String selectFields = Strings.join(fieldList, (String)",");
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append(selectFields).append(" from ");
        sqlSb.append(tableName);
        sqlSb.append(" where ");
        ArrayList<Object> param = new ArrayList<Object>();
        int count = 0;
        try {
            for (int i = 0; i < fieldList.size(); ++i) {
                String field = fieldList.get(i);
                com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(field);
                if (field.indexOf(indexFieldName) == -1) {
                    boolean isTime = false;
                    if (Enums.FieldType.DATETIME.getKey().equals(ffb.getFieldType()) || Enums.FieldType.TIMESTAMP.getKey().equals(ffb.getFieldType())) {
                        isTime = true;
                    }
                    if (isTime) {
                        sqlSb.append(" " + field + " is not null ");
                    } else if (JDBCAgent.getDBType().contains("server")) {
                        sqlSb.append(" isnull(" + field + ", '0') != '0' ");
                    } else if ("oracle".equals(JDBCAgent.getDBType()) || "dm dbms".equals(JDBCAgent.getDBType())) {
                        sqlSb.append(" NVL(" + field + ", '0') != '0' ");
                    } else if ("mysql".equals(JDBCAgent.getDBType())) {
                        sqlSb.append(" ifnull(" + field + ", '0') != '0' ");
                    } else if ("postgre".equals(JDBCAgent.getDBType())) {
                        sqlSb.append(" coalesce(" + field + ", '0') != '0' ");
                    } else {
                        sqlSb.append("= " + field + " is not null ");
                    }
                    if (i >= fieldList.size() - 1) continue;
                    sqlSb.append("and");
                    continue;
                }
                sqlSb.append(" " + field + " in(");
                List<Object> subIndexValueList = indexValueListMap.get(field);
                if (subIndexValueList == null) continue;
                for (int j = 0; j < subIndexValueList.size(); ++j) {
                    Object value = subIndexValueList.get(j);
                    if (j < subIndexValueList.size() - 1) {
                        sqlSb.append("?,");
                    } else if (i < fieldList.size() - 1) {
                        sqlSb.append("?) and ");
                    } else {
                        sqlSb.append("?)");
                    }
                    param.add(this.getObjectUniqueMarked(value, ffb));
                }
            }
            sqlSb.append(") t");
            int allNum = 0;
            StringBuilder allCount = new StringBuilder();
            allCount.append("select count(*) as count from (select ");
            allCount.append((CharSequence)sqlSb);
            jdbc.execute(allCount.toString(), param);
            Map m = jdbc.resultSetToMap();
            count = allNum = m.get("count") == null ? 0 : Integer.parseInt(String.valueOf(m.get("count")));
            int distinctNum = 0;
            StringBuilder distinctCount = new StringBuilder();
            distinctCount.append("select count(*) as count from (select DISTINCT ");
            distinctCount.append((CharSequence)sqlSb);
            jdbc.execute(distinctCount.toString(), param);
            m = jdbc.resultSetToMap();
            int n = distinctNum = m.get("count") == null ? 0 : Integer.parseInt(String.valueOf(m.get("count")));
            if (allNum > distinctNum) {
                LOGGER.info((Object)("\u4e3b\u8868\u4e0d\u6ee1\u8db3\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + " param:" + param + " allNum:" + allNum + " distinctNum:" + distinctNum));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u5355\u91cd\u590d\u8868\u4e0d\u6ee1\u8db3\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + "  param:" + param));
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
            this.putMonitorParam(fb, fieldList, sqlSb.toString(), count, beginTime);
        }
        return true;
    }

    private boolean hasOnlyMainTableUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, JDBCAgent jdbc, List<String> fieldList, Map<String, List<Object>> mainIndexValueListMap, String mainTableName) throws BusinessException {
        long beginTime = System.currentTimeMillis();
        String selectFields = Strings.join(fieldList, (String)",");
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select count(*) as count from (select ");
        sqlSb.append(selectFields).append(" from ");
        sqlSb.append(mainTableName);
        sqlSb.append(" where ");
        ArrayList<Object> param = new ArrayList<Object>();
        int count = 0;
        try {
            block5: for (int i = 0; i < fieldList.size(); ++i) {
                String field = fieldList.get(i);
                if (i < fieldList.size() - 1) {
                    sqlSb.append(field + "=? and ");
                } else {
                    sqlSb.append(field + "=?");
                }
                com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(field);
                for (Object obj : mainIndexValueListMap.get(field)) {
                    if (obj == null) {
                        param.add("");
                        continue;
                    }
                    param.add(this.getObjectUniqueMarked(obj, ffb));
                    continue block5;
                }
            }
            sqlSb.append(") t");
            jdbc.execute(sqlSb.toString(), param);
            Map m = jdbc.resultSetToMap();
            int n = count = m.get("count") == null ? 0 : Integer.parseInt(String.valueOf(m.get("count")));
            if (count > 1) {
                LOGGER.info((Object)("\u4e3b\u8868\u4e0d\u6ee1\u8db3\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + " param:" + param + " count:" + count + " dataCount:" + count));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u4e3b\u8868\u4e0d\u6ee1\u8db3\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + "  param:" + param));
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
            this.putMonitorParam(fb, fieldList, sqlSb.toString(), count, beginTime);
        }
        return true;
    }

    private boolean hasSubTableUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, JDBCAgent jdbc, List<String> fieldList, Map<String, List<Object>> subIndexValueListMap, List<String> subFieldList, String mainTableName, String subTableName) throws BusinessException {
        long beginTime = System.currentTimeMillis();
        String selectFields = Strings.join(fieldList, (String)",");
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select sum(num) as count from (select count(*) as num, ").append(selectFields).append(" from (");
        ArrayList<Object> valueList = new ArrayList<Object>();
        int count = 0;
        try {
            StringBuilder paramAll = new StringBuilder();
            StringBuilder param = null;
            int index = 0;
            int dataCount = 0;
            for (String subField : subFieldList) {
                String paramSql;
                ++index;
                paramAll.append(subField).append(" in(");
                com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(subField);
                int tempCount = 0;
                param = new StringBuilder();
                for (Object obj : subIndexValueListMap.get(subField)) {
                    if (obj == null) continue;
                    param.append(" ?,");
                    valueList.add(this.getObjectUniqueMarked(obj, ffb));
                    ++tempCount;
                }
                if (dataCount < tempCount) {
                    dataCount = tempCount;
                }
                if (Strings.isNotEmpty((String)(paramSql = param.toString()))) {
                    paramSql = paramSql.substring(0, paramSql.lastIndexOf(","));
                }
                paramAll.append(paramSql).append(")");
                if (index >= subFieldList.size()) continue;
                paramAll.append(" and ");
            }
            sqlSb.append("select ").append(selectFields).append(" from ").append(mainTableName).append(" fm,");
            sqlSb.append(" (").append("select formmain_id, ").append(Strings.join(subFieldList, (String)",")).append(" from ").append(subTableName);
            sqlSb.append(" where ").append((CharSequence)paramAll);
            sqlSb.append(" group by formmain_id, ").append(Strings.join(subFieldList, (String)",")).append(" ) fs ");
            sqlSb.append(" where fm.id = fs.formmain_id ");
            sqlSb.append(") a group by ").append(selectFields).append(" having count(*) > 1) b");
            jdbc.execute(sqlSb.toString(), valueList);
            Map m = jdbc.resultSetToMap();
            int n = count = m.get("count") == null ? 0 : Integer.parseInt(String.valueOf(m.get("count")));
            if (count > 1) {
                LOGGER.info((Object)("\u4e0d\u6ee1\u8db3\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + " param:" + valueList + " count:" + count + " dataCount:" + dataCount));
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            LOGGER.info((Object)("\u552f\u4e00\u6807\u8bc6\uff1a" + sqlSb.toString() + " param:" + valueList));
            throw new BusinessException(e);
        }
        finally {
            jdbc.close();
            this.putMonitorParam(fb, fieldList, sqlSb.toString(), count, beginTime);
        }
        return true;
    }

    private Object getObjectUniqueMarked(Object obj, com.seeyon.cap4.form.bean.FormFieldBean ffb) throws Exception {
        if (Enums.FieldType.DATETIME.getKey().equals(ffb.getFieldType())) {
            if (obj instanceof Date) {
                String s = DateUtil.getDate((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm");
                obj = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd HH:mm");
            } else if (obj instanceof String) {
                obj = DateUtil.parseTimestamp((String)String.valueOf(obj), (String)"yyyy-MM-dd HH:mm");
            }
        } else if (Enums.FieldType.TIMESTAMP.getKey().equals(ffb.getFieldType())) {
            if (obj instanceof Date) {
                String s = DateUtil.getDate((Date)((Date)obj), (String)"yyyy-MM-dd");
                obj = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd");
            } else if (obj instanceof String) {
                obj = DateUtil.parseTimestamp((String)String.valueOf(obj), (String)"yyyy-MM-dd");
            }
        }
        return obj;
    }

    @Override
    public boolean isUniqueMarked(com.seeyon.cap4.form.bean.FormBean fb, List<String> fieldList) throws BusinessException {
        String mainTableName = fb.getMasterTableBean().getTableName();
        String subTableName = "";
        boolean hasMainTable = false;
        boolean hasSubTable = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder whereSb = new StringBuilder();
        String str = "";
        for (String fieldName : fieldList) {
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (!hasSubTable && ffb.isSubField()) {
                subTableName = ffb.getOwnerTableName();
                hasSubTable = true;
            }
            if (!hasMainTable && ffb.isMasterField()) {
                hasMainTable = true;
            }
            sb.append(fieldName).append(", ");
            boolean isTime = false;
            if (Enums.FieldType.DATETIME.getKey().equals(ffb.getFieldType()) || Enums.FieldType.TIMESTAMP.getKey().equals(ffb.getFieldType())) {
                isTime = true;
            }
            str = isTime ? " " + fieldName + " is not null and" : (ReportDBUtils.isSQLServerRuntime() ? " isnull(" + fieldName + ", '0') != '0' and" : (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime() ? " NVL(" + fieldName + ", '0') != '0' and" : (ReportDBUtils.isMySQLRuntime() ? " ifnull(" + fieldName + ", '0') != '0' and" : (ReportDBUtils.isPostgreSQLRuntime() ? " coalesce(" + fieldName + ", '0') != '0' and" : " " + fieldName + " is not null and"))));
            whereSb.append(str);
        }
        String selectSql = sb.toString();
        selectSql = selectSql.substring(0, selectSql.length() - 2);
        String where = whereSb.toString();
        where = com.seeyon.cap4.form.util.StringUtils.replaceLast((String)where, (String)"and", (String)"");
        String tableName = "";
        if (hasMainTable) {
            tableName = mainTableName;
        }
        String unionSQL = "";
        if (hasSubTable) {
            if (hasMainTable) {
                tableName = tableName + " fm, " + subTableName + " fs";
                unionSQL = "fm.id = fs.formmain_id and ";
            } else {
                tableName = subTableName;
            }
        }
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append("select ");
        sqlSB.append(selectSql);
        sqlSB.append(" from ").append(tableName);
        sqlSB.append(" where ");
        sqlSB.append(unionSQL);
        sqlSB.append(where);
        long beginTime = System.currentTimeMillis();
        String sql = "select count(*) as nnum from (" + sqlSB.toString() + ") t";
        List<Map> result = this.cap4FormDataDAO.selectDataBySql(sql);
        int v_size1 = result == null ? 0 : Integer.valueOf(result.get(0).get("nnum").toString());
        this.putMonitorParam(fb, fieldList, sql, v_size1, beginTime);
        LOGGER.info((Object)("\u552f\u4e00\u6807\u8bc61:" + v_size1));
        sqlSB = new StringBuilder();
        sqlSB.append("select distinct ");
        sqlSB.append(selectSql);
        sqlSB.append(" from ").append(tableName);
        sqlSB.append(" where ");
        sqlSB.append(unionSQL);
        sqlSB.append(where);
        beginTime = System.currentTimeMillis();
        sql = "select count(*) as nnum from (" + sqlSB.toString() + ") t";
        result = this.cap4FormDataDAO.selectDataBySql(sql);
        int v_size2 = result == null ? 0 : Integer.valueOf(result.get(0).get("nnum").toString());
        this.putMonitorParam(fb, fieldList, sql, v_size2, beginTime);
        LOGGER.info((Object)("\u552f\u4e00\u6807\u8bc62:" + v_size2));
        return v_size1 <= v_size2;
    }

    @Override
    public boolean isFieldUnique(com.seeyon.cap4.form.bean.FormBean fb, String fieldName, List<Object> valueList) throws BusinessException {
        com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
        String tableName = ffb.getOwnerTableName();
        if (ffb.isMasterField() && valueList.size() > 1 || ffb.isSubField()) {
            ArrayList<Object> list = new ArrayList<Object>();
            boolean isExist = false;
            for (Object value : valueList) {
                if (value == null) continue;
                if (list.contains(value)) {
                    isExist = true;
                    break;
                }
                list.add(value);
            }
            if (isExist) {
                return false;
            }
        }
        JDBCAgent jdbc = new JDBCAgent();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            sql.append(" select count(id) as num from " + tableName + " where ");
            int tempNum = 0;
            for (int j = 0; j < valueList.size(); ++j) {
                String s;
                Object value = valueList.get(j);
                if (value == null) continue;
                boolean isTime = false;
                if (Enums.FieldType.DATETIME.getKey().equals(ffb.getFieldType())) {
                    if (value instanceof Date) {
                        s = DateUtil.getDate((Date)((Date)value), (String)"yyyy-MM-dd HH:mm");
                        value = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd HH:mm");
                    } else if (value instanceof String) {
                        value = DateUtil.parseTimestamp((String)String.valueOf(value), (String)"yyyy-MM-dd HH:mm");
                    }
                    isTime = true;
                } else if (Enums.FieldType.TIMESTAMP.getKey().equals(ffb.getFieldType())) {
                    if (value instanceof Date) {
                        s = DateUtil.getDate((Date)((Date)value), (String)"yyyy-MM-dd");
                        value = DateUtil.parseTimestamp((String)s, (String)"yyyy-MM-dd");
                    } else if (value instanceof String) {
                        value = DateUtil.parseTimestamp((String)String.valueOf(value), (String)"yyyy-MM-dd");
                    }
                    isTime = true;
                }
                String str = "";
                str = isTime ? " " + fieldName + " is not null" : (ReportDBUtils.isSQLServerRuntime() ? " isnull(" + fieldName + ", '0') != '0'" : (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime() ? " NVL(" + fieldName + ", '0') != '0'" : (ReportDBUtils.isMySQLRuntime() ? " ifnull(" + fieldName + ", '0') != '0'" : (ReportDBUtils.isPostgreSQLRuntime() ? " coalesce(" + fieldName + ", '0') != '0'" : " " + fieldName + " is not null"))));
                if (j == 0) {
                    sql.append(" (" + ffb.getName() + " =  ? and " + str + ") ");
                } else if (sql.indexOf("?") > -1) {
                    sql.append(" or (" + ffb.getName() + " =  ? and " + str + ") ");
                } else {
                    sql.append(" (" + ffb.getName() + " =  ? and " + str + ") ");
                }
                values.add(value);
                ++tempNum;
            }
            int count = 0;
            if (sql.indexOf("?") > -1) {
                long beginTime = System.currentTimeMillis();
                jdbc.execute(sql.toString(), values);
                Map m = jdbc.resultSetToMap();
                count = m.get("num") == null ? 0 : Integer.parseInt(String.valueOf(m.get("num")));
                this.putMonitorParam(fb, fieldName, sql.toString(), count, beginTime);
            }
            LOGGER.info((Object)("\u6570\u636e\u552f\u4e00\uff1a" + sql.toString() + " param:" + values + " count:" + count + " tempNum:" + tempNum));
            if (count > tempNum) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u6570\u636e\u552f\u4e00\uff1a" + sql.toString() + " param:" + values));
            LOGGER.error((Object)(ffb.getName() + " \u505a\u6570\u636e\u552f\u4e00\u5224\u65ad\u65f6\u5f02\u5e38\uff0c" + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
        }
        return true;
    }

    @Override
    public FlipInfo getFormMasterDataListBySearch(FlipInfo flipInfo, Map<String, Object> params, boolean forExport) throws BusinessException {
        Long formId = Long.parseLong(params.get("formId") + "");
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        String templateIdStr = String.valueOf(params.get("formTemplateId"));
        String auth = FormUtil.getUnflowFormAuth((com.seeyon.cap4.form.bean.FormBean)formBean, (String)templateIdStr);
        Long currentUserId = AppContext.currentUserId();
        boolean isNeedPage = true;
        FormQueryTypeEnum queryType = FormQueryTypeEnum.infoManageQuery;
        FormQueryWhereClause customCondition = FormSearchUtil.getCustomConditionFormQueryWhereClause(formBean, params);
        List customOrderBy = (List)params.get("userOrderBy");
        HashSet<String> customShowFields = new HashSet<String>();
        FormQueryWhereClause relationSqlWhereClause = this.getRelationConditionFormQueryWhereClause(formBean, params);
        Long templeteId = Long.parseLong(Strings.isBlank((String)String.valueOf(params.get("formTemplateId") == null ? "" : params.get("formTemplateId"))) ? "0" : params.get("formTemplateId") + "");
        List dataConditions = (List)params.get("dataConditions");
        FormQueryWhereClause dataConditionWhereCause = this.getFieldDataConditionFormQueryWhereClause(formBean, dataConditions, true);
        FormQueryResult queryResult = this.getFormQueryResult(currentUserId, flipInfo, isNeedPage, formBean, templeteId, queryType, customCondition, customOrderBy, customShowFields, relationSqlWhereClause, dataConditionWhereCause, false);
        flipInfo.setData(FormUtil.setShowValueList((com.seeyon.cap4.form.bean.FormBean)formBean, (String)auth, (List)flipInfo.getData(), (boolean)false, (boolean)forExport, (boolean)false));
        return queryResult.getFlipInfo();
    }

    @Override
    public void refreshCustomControls(Map<String, Object> params) {
        try {
            com.seeyon.cap4.form.bean.FormBean formBean = (com.seeyon.cap4.form.bean.FormBean)params.get("formBean");
            List allCustomFields = formBean.getCustomFields();
            for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : allCustomFields) {
                params.put("formFieldBean", fieldBean);
                ((FormFieldCustomCtrl)fieldBean.getFieldCtrl()).refresh(params);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("failed to refresh custom controls! cause:" + e.getMessage()), (Throwable)e);
        }
    }

    private void dataTrace(FormDataBean formDataBean, String operateType) {
        if (MonitorUtil.needDataTrace((long)formDataBean.getFormTable().getFormId())) {
            if (formDataBean instanceof FormDataMasterBean) {
                FormDataMasterBean formDataMasterBean = (FormDataMasterBean)formDataBean;
                HistoryObj masterHistoryObj = HistoryObjManager.newObj((long)formDataMasterBean.getId(), (String)formDataMasterBean.getFormTable().getTableName(), (String)operateType, (String)"\u8868\u5355\u5b58\u50a8001", (ISaveData)new FormDataTraceBean(formDataMasterBean.getFormTable()));
                HistoryObjManager.getInstance().put(masterHistoryObj);
                if (formDataMasterBean.getSubTables() != null && formDataMasterBean.getSubTables().size() > 0) {
                    Map subTables = formDataMasterBean.getSubTables();
                    ArrayList tableNames = new ArrayList(subTables.keySet());
                    Collections.sort(tableNames);
                    for (String tableName : tableNames) {
                        List subDatas = (List)subTables.get(tableName);
                        for (FormDataSubBean subData : subDatas) {
                            HistoryObj subHistoryObj = HistoryObjManager.newObj((long)subData.getId(), (String)tableName, (String)operateType, (String)"\u8868\u5355\u5b58\u50a8001", (ISaveData)new FormDataTraceBean(subData.getFormTable()));
                            HistoryObjManager.getInstance().put(subHistoryObj);
                        }
                    }
                }
            } else if (formDataBean instanceof FormDataSubBean) {
                FormDataSubBean formDataSubBean = (FormDataSubBean)formDataBean;
                HistoryObj subHistoryObj = HistoryObjManager.newObj((long)formDataSubBean.getId(), (String)formDataSubBean.getFormTable().getTableName(), (String)"\u5b58\u50a8\u8868\u5355", (String)"\u8868\u5355\u5b58\u50a8001", (ISaveData)new FormDataTraceBean(formDataSubBean.getFormTable()));
                HistoryObjManager.getInstance().put(subHistoryObj);
            }
        }
    }

    private void dataTrace(Long masterId, com.seeyon.cap4.form.bean.FormBean formBean, String operateType) {
        List tableList = formBean.getTableList();
        for (int i = 0; i < tableList.size(); ++i) {
            FormTableBean tableBean = (FormTableBean)tableList.get(i);
            if (!MonitorUtil.needDataTrace((long)tableBean.getFormId())) continue;
            HistoryObj masterHistoryObj = HistoryObjManager.newObj((long)masterId, (String)tableBean.getTableName(), (String)operateType, (String)"\u8868\u5355\u5b58\u50a8001", (ISaveData)new FormDataTraceBean(tableBean));
            HistoryObjManager.getInstance().put(masterHistoryObj);
        }
    }

    @Override
    public FormAuthViewFieldBean getFormAuthorizationField(FormAuthViewBean authViewBean, String fieldName, Map<String, Object> dataMap) {
        Map fields = authViewBean.getFields();
        if (authViewBean.isApartSetAuth() && dataMap != null) {
            int viewState;
            int n = viewState = dataMap.get("Seeyon_Form_ViewState") == null ? -1 : Integer.parseInt(dataMap.get("Seeyon_Form_ViewState").toString());
            if (viewState == 4) {
                return (FormAuthViewFieldBean)fields.get(fieldName);
            }
            List subFieldAuthList = (List)authViewBean.getFieldConditionAuths().get(fieldName);
            HashMap<Long, FormAuthViewFieldBean> subMap = new HashMap<Long, FormAuthViewFieldBean>();
            if (subFieldAuthList != null && !subFieldAuthList.isEmpty()) {
                ArrayList<FormConditionActionBean> fcabList = new ArrayList<FormConditionActionBean>();
                for (FormAuthViewFieldBean favfb : subFieldAuthList) {
                    fcabList.add(favfb.getFormConditionActionBean());
                    subMap.put(favfb.getId(), favfb);
                }
                try {
                    Object value = FormulaUtil.doResult((String)FormulaUtil.getConditionFormulaStr(fcabList), dataMap);
                    return subMap.get(value) == null ? (FormAuthViewFieldBean)fields.get(fieldName) : authViewBean.getFormFieldAuthByViewState((FormAuthViewFieldBean)subMap.get(value), viewState);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("\u9ad8\u7ea7\u5b57\u6bb5\u6743\u9650\u83b7\u53d6\u51fa\u9519[viewId:" + authViewBean.getId() + " fieldName:" + fieldName + " error:" + e.getLocalizedMessage() + "]"));
                    return (FormAuthViewFieldBean)fields.get(fieldName);
                }
            }
        }
        return (FormAuthViewFieldBean)fields.get(fieldName);
    }

    @Override
    public FormQueryWhereClause getFieldDataConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, List<Map<String, Object>> dataConditions, boolean needTableName) {
        if (dataConditions == null || dataConditions.size() <= 0) {
            return null;
        }
        FormQueryWhereClause formQueryWhereClause = new FormQueryWhereClause();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        int j = dataConditions.size();
        for (int i = 0; i < j; ++i) {
            sb.append("(");
            Map<String, Object> condition = dataConditions.get(i);
            String fieldName = String.valueOf(condition.get("fieldName"));
            String tableName = condition.get("aliasTableName") == null ? null : String.valueOf(condition.get("aliasTableName"));
            com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
            if (formFieldBean != null && tableName == null) {
                tableName = formFieldBean.getOwnerTableName();
            }
            if (needTableName) {
                fieldName = tableName + "." + fieldName;
            }
            String fieldType = formFieldBean == null ? String.valueOf(condition.get("fieldType")) : formFieldBean.getFieldType();
            List fieldValue = (List)condition.get("fieldValue");
            String operation = String.valueOf(condition.get("operation"));
            boolean hasNull = false;
            if ("Like".equals(operation) && fieldValue != null && fieldValue.size() > 0) {
                if (fieldValue.size() == 1 && Strings.isBlank((String)((String)fieldValue.get(0)))) {
                    sb.append(fieldName).append(" IS NULL ");
                    if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                        sb.append(" OR ").append(fieldName).append(" = '' ");
                    }
                } else {
                    sb.append(fieldName);
                    sb.append(" IN (");
                    hasNull = this.getSqlAndParams(sb, formBean, fieldName, fieldValue, params);
                    sb.append(")");
                    if (hasNull) {
                        sb.append(" OR ").append(fieldName).append(" IS NULL ");
                        if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                            sb.append(" OR ").append(fieldName).append(" = '' ");
                        }
                    }
                }
            } else if ("Like".equals(operation) && (fieldValue == null || fieldValue.size() == 0)) {
                sb.append(" 1 = 2 ");
            } else if ("NotLike".equals(operation) && fieldValue != null && fieldValue.size() > 0) {
                if (fieldValue.size() == 1 && Strings.isBlank((String)((String)fieldValue.get(0)))) {
                    sb.append(fieldName).append(" IS NOT NULL ");
                    if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                        sb.append(" OR ").append(fieldName).append(" <> '' ");
                    }
                } else {
                    sb.append(fieldName);
                    sb.append(" NOT IN (");
                    hasNull = this.getSqlAndParams(sb, formBean, fieldName, fieldValue, params);
                    sb.append(")");
                    if (hasNull) {
                        sb.append(" and (").append(fieldName).append(" IS NOT NULL ");
                        if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                            sb.append(" OR ").append(fieldName).append(" <> '' )");
                        } else {
                            sb.append(")");
                        }
                    } else {
                        sb.append(" OR ").append(fieldName).append(" IS NULL ");
                        if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                            sb.append(" OR ").append(fieldName).append(" = '' ");
                        }
                    }
                }
            } else {
                sb.append(" 1 = 1 ");
            }
            if (i == j - 1) {
                sb.append(")");
                continue;
            }
            sb.append(") AND ");
        }
        formQueryWhereClause.setAllSqlClause(sb.toString());
        formQueryWhereClause.setQueryParams(params);
        return formQueryWhereClause;
    }

    private boolean getSqlAndParams(StringBuilder sb, com.seeyon.cap4.form.bean.FormBean formBean, String fieldName, List<String> fieldValue, List<Object> params) {
        boolean hasNull = false;
        int j = fieldValue.size();
        for (int i = 0; i < j; ++i) {
            String value = fieldValue.get(i);
            if (Strings.isBlank((String)value)) {
                hasNull = true;
                continue;
            }
            if (i == j - 1) {
                sb.append("?");
            } else if (i == j - 2 && Strings.isBlank((String)fieldValue.get(i + 1))) {
                sb.append("?");
            } else {
                sb.append("?,");
            }
            Object o = FormUtil.getHQLObject((Object)formBean, (String)fieldName, (String)value);
            params.add(o);
            if (i != 1000) continue;
            return hasNull;
        }
        return hasNull;
    }

    @Override
    public void updateData(Long formId, Long dataId, Enums.FormDataStateEnum formDataStateEnum) throws BusinessException, SQLException {
        com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
        if (fb != null) {
            this.cap4FormDataDAO.updateData(dataId, fb.getMasterTableBean().getTableName(), "state", formDataStateEnum.getKey());
        }
    }

    @Override
    public boolean updateData(Long id, String tableName, String fieldName, Object fieldValue) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.updateData(id, tableName, fieldName, fieldValue);
    }

    @Override
    public boolean updateData(Long id, String tableName, Map<String, Object> fields) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.updateData(id, tableName, fields);
    }

    @Override
    public List<FormDataMasterBean> selectMasterDataList(FlipInfo flipInfo, FormTableBean tableBean, String[] fields, Map<String, Object> where) throws BusinessException {
        return this.cap4FormDataDAO.selectMasterDataList(flipInfo, tableBean, fields, where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CAPFormDataCacheRemove(byFormId=true, formBeanPosition=4)
    public void saveBatchChangeData(List<String> sqlStr, com.seeyon.cap4.form.bean.FormFieldBean toFieldBean, com.seeyon.cap4.form.bean.FormFieldBean formFieldBean, com.seeyon.cap4.form.bean.FormBean formBean) throws BusinessException {
        JDBCAgent jdbc = null;
        String formName = formBean.getFormName();
        String fieldName = toFieldBean.getName();
        Connection conn = null;
        boolean oldSet = false;
        try {
            if (sqlStr.size() > 0) {
                if (ReportDBUtils.isSQLServerRuntime()) {
                    conn = JDBCAgent.getRawConnection();
                    oldSet = conn.getAutoCommit();
                    conn.setAutoCommit(true);
                    for (String s : sqlStr) {
                        LOGGER.info((Object)s);
                        PreparedStatement preparedStatement = null;
                        try {
                            preparedStatement = conn.prepareStatement(s);
                            preparedStatement.execute();
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (null == preparedStatement) continue;
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e) {
                                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                } else {
                    jdbc = new JDBCAgent();
                    jdbc.executeBatch(sqlStr);
                }
            }
            LOGGER.info((Object)("\u8868\u5355" + formName + " ID\uff1a" + formBean.getId() + "\u5b57\u6bb5\uff1a" + fieldName + " \u4ece " + formFieldBean.getFieldType() + " \u8f6c\u4e3a " + toFieldBean.getFieldType() + "\uff0c\u6570\u636e\u8f6c\u6362\u5b8c\u6210"));
        }
        catch (SQLException e) {
            LOGGER.error((Object)("\u8868\u5355" + formName + " ID\uff1a" + formBean.getId() + "\u5b57\u6bb5\uff1a" + fieldName + " \u4ece " + formFieldBean.getFieldType() + " \u8f6c\u4e3a " + toFieldBean.getFieldType() + "\u65f6\uff0c\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u5c06\u8d4b\u4e88\u9ed8\u8ba4\u503c"));
            LOGGER.error((Object)"sql:");
            LOGGER.error((Object)JSONUtil.toJSONString(sqlStr));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jdbc) {
                jdbc.close();
            }
            if (null != conn) {
                try {
                    conn.setAutoCommit(oldSet);
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<String, Map<String, Object>> getClearFields(com.seeyon.cap4.form.bean.FormBean formBean, String rightId) throws BusinessException {
        String repealAndEmptyStr;
        Object repealAndEmpty;
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> masterMap = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> subFields = new HashMap<String, HashMap<String, Object>>();
        result.put(formBean.getMasterTableBean().getTableName(), masterMap);
        if (null == rightId) {
            LOGGER.error((Object)"\u6e05\u7a7a\u5b57\u6bb5\u65f6\u4f20\u5165\u7684\u6743\u9650ID\u4e3a\u7a7a\uff01");
            return null;
        }
        Map advancedSet = formBean.getAdvancedSet();
        String repealType = "not";
        List<String> fieldNames = null;
        if (null != advancedSet && "custom".equals(repealType = (String)(repealAndEmpty = (Map)JSONUtil.parseJSONString((String)(repealAndEmptyStr = (String)advancedSet.get("repealAndEmpty")), new HashMap().getClass())).get("type"))) {
            String showFieldList = (String)repealAndEmpty.get("showFieldList");
            fieldNames = Arrays.asList(showFieldList.split(","));
        }
        LOGGER.info((Object)("\u6e05\u7a7a\u7c7b\u578b\uff1atype=" + repealType));
        List flowdealOptions = formBean.getFieldsByType(FormFieldComEnum.FLOWDEALOPITION);
        for (com.seeyon.cap4.form.bean.FormFieldBean formFieldBean : flowdealOptions) {
            masterMap.put(formFieldBean.getName(), null);
        }
        if ("not".equals(repealType)) {
            return result;
        }
        FormAuthViewBean viewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
        if (viewBean == null) {
            LOGGER.error((Object)("\u6d41\u7a0b\u64a4\u9500\uff0c\u83b7\u53d6\u5230\u7684\u6743\u9650\u4e3anull\uff0c\u5bf9\u5e94operationId = " + rightId));
            return null;
        }
        LOGGER.info((Object)("\u6e05\u7a7a\u6743\u9650ID=" + rightId + " \u6743\u9650\u540d\u79f0=" + viewBean.getName()));
        List viewFieldBeans = viewBean.getFormAuthorizationFieldList();
        for (FormAuthViewFieldBean avfb : viewFieldBeans) {
            FormFieldCtrl ctrl;
            com.seeyon.cap4.form.bean.FormFieldBean fieldBean = avfb.getFormFieldBean();
            if (fieldBean == null) {
                LOGGER.warn((Object)("\u5f53\u524d\u89c6\u56fe\u6743\u9650\u4e2d\u7684\u5b57\u6bb5\uff1a" + avfb.getFieldName() + " \u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u6b64\u5904\u51fa\u73b0\u7a7a\u5c5e\u4e8e\u5386\u53f2\u6570\u636e\uff0c\u5fc5\u987b\u8fdb\u884c\u8fc7\u6ee4"));
                continue;
            }
            if (flowdealOptions.contains(fieldBean) || !this.neadClearSerialNumber(fieldBean, formBean) || null == (ctrl = fieldBean.getFieldCtrl()) || !ctrl.needClearWhenBackToStarter()) continue;
            if ("normal".equals(repealType)) {
                FormAuthViewFieldBean auth = viewBean.getFormAuthorizationField(fieldBean.getName());
                if (!auth.isEditAuth()) {
                    if (fieldBean.isMasterField()) {
                        masterMap.put(fieldBean.getName(), null);
                        continue;
                    }
                    HashMap<String, Object> subMap = (HashMap<String, Object>)subFields.get(fieldBean.getOwnerTableName());
                    if (subMap == null) {
                        subMap = new HashMap<String, Object>();
                    }
                    subMap.put(fieldBean.getName(), null);
                    subFields.put(fieldBean.getOwnerTableName(), subMap);
                    continue;
                }
                LOGGER.info((Object)("\u4e0d\u6e05\u7a7a\u6570\u636e\uff0cfieldName=" + fieldBean.getName() + "\u6743\u9650=" + avfb.getAccess()));
                continue;
            }
            if (!"custom".equals(repealType) || !fieldNames.contains(fieldBean.getName())) continue;
            if (fieldBean.isMasterField()) {
                masterMap.put(fieldBean.getName(), null);
            } else {
                HashMap<String, Object> subMap = (HashMap<String, Object>)subFields.get(fieldBean.getOwnerTableName());
                if (subMap == null) {
                    subMap = new HashMap<String, Object>();
                }
                subMap.put(fieldBean.getName(), null);
                subFields.put(fieldBean.getOwnerTableName(), subMap);
            }
            LOGGER.info((Object)("\u6e05\u7a7a\u6570\u636e\uff0cfieldName=" + fieldBean.getName() + "\u6743\u9650=" + avfb.getAccess()));
        }
        if (!subFields.isEmpty()) {
            result.putAll(subFields);
        }
        return result;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setAffairManager(AffairManager affairManager) {
        this.affairManager = affairManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setLbsManager(LbsManager lbsManager) {
        this.lbsManager = lbsManager;
    }

    public void setIndexApi(IndexApi indexApi) {
        this.indexApi = indexApi;
    }

    public void setCap4FormRelationActionManager(CAP4FormRelationActionManager cap4FormRelationActionManager) {
        this.cap4FormRelationActionManager = cap4FormRelationActionManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public void setCap4FormRelationRecordDAO(CAP4FormRelationRecordDAO cap4FormRelationRecordDAO) {
        this.cap4FormRelationRecordDAO = cap4FormRelationRecordDAO;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    public void setSignetManager(SignetManager signetManager) {
        this.signetManager = signetManager;
    }

    public void setV3xHtmDocumentSignatManager(V3xHtmDocumentSignatManager v3xHtmDocumentSignatManager) {
        this.v3xHtmDocumentSignatManager = v3xHtmDocumentSignatManager;
    }

    private void infoQueryTypeLog(FormQueryTypeEnum queryType) {
        if (LOGGER.isInfoEnabled()) {
            if (queryType == FormQueryTypeEnum.baseManageQuery) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u4e1a\u52a1\u751f\u6210\u5668\u6570\u636e\u7ef4\u62a4\u5217\u8868\u67e5\u8be2\u3010\u57fa\u7840\u6570\u636e\u3011");
            } else if (queryType == FormQueryTypeEnum.infoManageQuery) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u4e1a\u52a1\u751f\u6210\u5668\u6570\u636e\u7ef4\u62a4\u5217\u8868\u67e5\u8be2\u3010\u4fe1\u606f\u7ba1\u7406\u3011");
            } else if (queryType == FormQueryTypeEnum.flowRelationQuery) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u6d41\u7a0b\u76f8\u5173\u8868\u5355\u67e5\u8be2");
            } else if (queryType == FormQueryTypeEnum.relationFormQuery) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u5173\u8054\u8868\u5355\u67e5\u8be2");
            } else if (queryType == FormQueryTypeEnum.formQuery) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u8868\u5355\u67e5\u8be2");
            } else if (queryType == FormQueryTypeEnum.unFlowCheckRight) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u65e0\u6d41\u7a0b\u6743\u9650\u6821\u9a8c");
            } else if (queryType == FormQueryTypeEnum.unFlowExport) {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u65e0\u6d41\u7a0b\u5bfc\u51fa");
            } else {
                LOGGER.info((Object)"\u67e5\u8be2\u7c7b\u578b\uff1a\u672a\u77e5\u67e5\u8be2");
            }
        }
    }

    class FormDataTraceBean
    implements ISaveData {
        private FormTableBean formTableBean;

        public FormDataTraceBean(FormTableBean formTableBean) {
            this.formTableBean = formTableBean;
        }

        public String toSaveText() {
            return this.formTableBean.toJSON();
        }

        public FormTableBean getFormTableBean() {
            return this.formTableBean;
        }

        public void setFormTableBean(FormTableBean formTableBean) {
            this.formTableBean = formTableBean;
        }
    }
}

