/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formData;

import com.seeyon.cap4.cache.TrackTableListener_CAP4Dynamic;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheRemove;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.template.aspect.AopUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormDataMasterBean;
import com.seeyon.ctp.form.bean.FormTableBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class CAPFormDataAspect {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataAspect.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private CAPFormDataCacheManager capFormDataCacheManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheRemove)")
    public Object removeCache(ProceedingJoinPoint joinPoint) throws Throwable {
        String[] tableArray;
        CAPFormDataCacheRemove capFormDataCacheRemove = AopUtil.getMethodAnnotation((JoinPoint)joinPoint, CAPFormDataCacheRemove.class);
        Object[] args = joinPoint.getArgs();
        ArrayList<String> masterIds = new ArrayList<String>();
        Long formId = null;
        if (capFormDataCacheRemove.byFormId()) {
            Object formObj = capFormDataCacheRemove.formBeanPosition() == -1 ? null : args[capFormDataCacheRemove.formBeanPosition() - 1];
            tableArray = this.getFormTableArray(formObj);
            formId = this.getFormId(formObj);
        } else {
            tableArray = this.operationByDataBean(capFormDataCacheRemove, args, masterIds);
        }
        if (tableArray != null) {
            TrackTableListener_CAP4Dynamic.putTrackTableInfo(JMSQLOperation.Delete, tableArray);
        }
        LOGGER.info((Object)("removeCache masterIds " + masterIds + " , formId " + formId));
        try {
            Object obj = joinPoint.proceed(args);
            if (capFormDataCacheRemove.byFormId()) {
                if (formId != null) {
                    this.capFormDataCacheManager.removeByFormId(formId);
                }
            } else if (Strings.isNotEmpty(masterIds)) {
                this.capFormDataCacheManager.remove(masterIds.toArray(new String[masterIds.size()]));
            }
            Object object = obj;
            return object;
        }
        finally {
            JMTrackUtils.clearTrackTableInfo();
        }
    }

    private String[] operationByDataBean(CAPFormDataCacheRemove capFormDataCacheRemove, Object[] args, List<String> masterIds) throws BusinessException {
        Object data;
        String[] tableArray = null;
        Object object = data = args.length > 0 ? args[capFormDataCacheRemove.dataBeanPosition() - 1] : null;
        if (capFormDataCacheRemove.byId()) {
            if (data instanceof List) {
                masterIds.addAll((List)data);
            } else {
                masterIds.add(String.valueOf(data));
            }
            Object formObj = capFormDataCacheRemove.formBeanPosition() == -1 ? null : args[capFormDataCacheRemove.formBeanPosition() - 1];
            tableArray = this.getFormTableArray(formObj);
        } else {
            ArrayList<Object> dataBeans;
            if (data instanceof List) {
                dataBeans = (ArrayList<Object>)data;
            } else {
                dataBeans = new ArrayList<Object>(1);
                dataBeans.add(data);
            }
            HashSet<Long> formIds = new HashSet<Long>();
            ArrayList<String> tableList = new ArrayList<String>();
            for (Object e : dataBeans) {
                com.seeyon.cap4.form.bean.FormBean formBean;
                com.seeyon.cap4.form.bean.FormDataMasterBean formDataMasterBean;
                if (e instanceof com.seeyon.cap4.form.bean.FormDataMasterBean) {
                    formDataMasterBean = (com.seeyon.cap4.form.bean.FormDataMasterBean)e;
                    masterIds.add(formDataMasterBean.getId().toString());
                    if (formIds.contains(formDataMasterBean.getFormTable().getFormId())) continue;
                    formBean = this.cap4FormCacheManager.getForm(formDataMasterBean.getFormTable().getFormId());
                    tableList.addAll(formBean.getAllTableName());
                    formIds.add(formDataMasterBean.getFormTable().getFormId());
                    continue;
                }
                if (!(e instanceof FormDataMasterBean)) continue;
                formDataMasterBean = (FormDataMasterBean)e;
                masterIds.add(formDataMasterBean.getId().toString());
                if (formIds.contains(formDataMasterBean.getFormTable().getFormId())) continue;
                formBean = this.formCacheManager.getForm(formDataMasterBean.getFormTable().getFormId().longValue());
                tableList.addAll(Arrays.asList(this.getCAP3TableArray((FormBean)formBean)));
                formIds.add(formDataMasterBean.getFormTable().getFormId());
            }
            tableArray = tableList.toArray(new String[tableList.size()]);
        }
        return tableArray;
    }

    private String[] getFormTableArray(Object formObj) throws BusinessException {
        String[] tableArray = null;
        if (formObj == null) {
            throw new BusinessException("annotation remove form data cache form bean position is error");
        }
        if (formObj instanceof com.seeyon.cap4.form.bean.FormBean) {
            com.seeyon.cap4.form.bean.FormBean formBean = (com.seeyon.cap4.form.bean.FormBean)formObj;
            tableArray = formBean.getAllTableNameArray();
        } else if (formObj instanceof FormBean) {
            FormBean formBean = (FormBean)formObj;
            tableArray = this.getCAP3TableArray(formBean);
        }
        return tableArray;
    }

    private Long getFormId(Object formObj) throws BusinessException {
        Long formId = null;
        if (formObj == null) {
            throw new BusinessException("annotation remove form data cache form bean position is error");
        }
        if (formObj instanceof com.seeyon.cap4.form.bean.FormBean) {
            formId = ((com.seeyon.cap4.form.bean.FormBean)formObj).getId();
        } else if (formObj instanceof FormBean) {
            formId = ((FormBean)formObj).getId();
        }
        return formId;
    }

    private String[] getCAP3TableArray(FormBean formBean) {
        List tableBeanList = formBean.getTableList();
        String[] tableArray = new String[tableBeanList.size()];
        int i = 0;
        for (FormTableBean tableBean : tableBeanList) {
            tableArray[i] = tableBean.getTableName();
            ++i;
        }
        return tableArray;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }
}

