/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formData;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.impl.CAP4DataCacheManager;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheLoadManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataLoaderContext;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataPojo;
import com.seeyon.ctp.cap.api.constant.CAPFormEnum;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormDataMasterBean;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormDataCacheManagerImpl
implements CAPFormDataCacheManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataCacheManagerImpl.class);
    private CAP4DataCacheManager<CAPFormDataPojo, CAPFormDataLoaderContext> cacheManager;
    private CAPFormDataCacheLoadManager<com.seeyon.cap4.form.bean.FormDataMasterBean> cap4FormDataCacheLoadManager;
    private CAPFormDataCacheLoadManager<FormDataMasterBean> cap3FormDataCacheLoadManager;

    public void init() throws Exception {
        if (this.cacheManager != null) {
            LOGGER.info((Object)("\u521d\u59cb\u5316\u8868\u5355\u6570\u636e\u7f13\u5b58manager\uff0c\u5df2\u521d\u59cb\u5316\uff0cisLocal " + this.reloadBean() + " , finish " + this.cacheManager.getClass().getName()));
            return;
        }
        CacheEngine.getInstance().init();
        ICacheManager<CAPFormDataPojo, CAPFormDataLoaderContext> manager = CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class);
        if (manager instanceof CAP4DataCacheManager) {
            this.cacheManager = (CAP4DataCacheManager)manager;
        }
        LOGGER.info((Object)("\u521d\u59cb\u5316\u8868\u5355\u6570\u636e\u7f13\u5b58manager\uff0cisLocal " + this.reloadBean() + " , finish" + (this.cacheManager == null ? "cacheManager is null" : this.cacheManager.getClass().getName())));
    }

    public void remove(Long formMasterId) {
        if (this.cacheManager != null) {
            this.cacheManager.remove(this.getCacheKey(formMasterId));
            LOGGER.info((Object)("remove cache by id " + formMasterId));
        }
    }

    public void remove(String[] ids) {
        if (this.cacheManager != null) {
            for (String id : ids) {
                this.cacheManager.remove(this.getCacheKey(id));
                LOGGER.info((Object)("remove cache by ids " + id));
            }
        }
    }

    public void removeByFormId(Long formId) {
        if (this.cacheManager != null) {
            this.cacheManager.removeAllId2Keys(String.valueOf(formId));
            LOGGER.info((Object)("remove cache by formId " + formId));
        }
    }

    public com.seeyon.cap4.form.bean.FormDataMasterBean get4Data(Long formMasterId, Long formId) {
        return this.getData(formMasterId, formId, this.cap4FormDataCacheLoadManager, CAPFormEnum.FormVersion.FOUR);
    }

    public FormDataMasterBean get3Data(Long formMasterId, Long formId) {
        return this.getData(formMasterId, formId, this.cap3FormDataCacheLoadManager, CAPFormEnum.FormVersion.THREE);
    }

    private <T> T getData(Long formMasterId, Long formId, CAPFormDataCacheLoadManager<T> loadManager, CAPFormEnum.FormVersion formVersion) {
        Object formDataMasterBean;
        if (this.cacheManager == null) {
            formDataMasterBean = loadManager.getData(formMasterId, formId);
        } else {
            CAPFormDataLoaderContext loaderContext = new CAPFormDataLoaderContext();
            loaderContext.setFormId(formId);
            loaderContext.setFormMasterId(formMasterId);
            loaderContext.setFormVersion(formVersion);
            CAPFormDataPojo pojo = this.cacheManager.getFromCache(this.getCacheKey(formMasterId), loaderContext);
            if (pojo == null || pojo.getDataBean() == null) {
                formDataMasterBean = null;
            } else if (this.reloadBean() || !pojo.getLoadByNew()) {
                LOGGER.info((Object)("dataId " + formMasterId + " load by map to bean"));
                Map tableMap = loadManager.object2JsonMap(pojo.getDataBean());
                formDataMasterBean = loadManager.jsonMap2Object(tableMap);
            } else {
                formDataMasterBean = pojo.getDataBean();
            }
        }
        return (T)formDataMasterBean;
    }

    private String getCacheKey(Long formMasterId) {
        return this.getCacheKey(String.valueOf(formMasterId));
    }

    private String getCacheKey(String formMasterId) {
        return formMasterId;
    }

    private boolean reloadBean() {
        return this.cacheManager != null && this.cacheManager.isLocalCache();
    }

    public void setCap4FormDataCacheLoadManager(CAPFormDataCacheLoadManager<com.seeyon.cap4.form.bean.FormDataMasterBean> cap4FormDataCacheLoadManager) {
        this.cap4FormDataCacheLoadManager = cap4FormDataCacheLoadManager;
    }

    public void setCap3FormDataCacheLoadManager(CAPFormDataCacheLoadManager<FormDataMasterBean> cap3FormDataCacheLoadManager) {
        this.cap3FormDataCacheLoadManager = cap3FormDataCacheLoadManager;
    }
}

