/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.base.formData;

import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheLoadManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataLoaderContext;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataPojo;
import com.seeyon.ctp.cap.api.constant.CAPFormEnum;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormDataMasterBean;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormDataCacheObjectLoader
implements ICacheObjectLoader<CAPFormDataPojo, CAPFormDataLoaderContext> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataCacheObjectLoader.class);
    private static final String CHARSET = "UTF-8";
    private static final String VERSION = "version";
    private static final String DATA = "data";
    private CAPFormDataCacheLoadManager<com.seeyon.cap4.form.bean.FormDataMasterBean> cap4FormDataCacheLoadManager = (CAPFormDataCacheLoadManager)AppContext.getBean((String)"cap4FormDataCacheLoadManager");
    private CAPFormDataCacheLoadManager<FormDataMasterBean> cap3FormDataCacheLoadManager = (CAPFormDataCacheLoadManager)AppContext.getBean((String)"cap3FormDataCacheLoadManager");

    @Override
    public CAPFormDataPojo loadObject(String aKey, CAPFormDataLoaderContext aContext) {
        LOGGER.info((Object)("dataId " + aKey + " load from db"));
        if (CAPFormEnum.FormVersion.FOUR.equals((Object)aContext.getFormVersion())) {
            com.seeyon.cap4.form.bean.FormDataMasterBean formDataMasterBean = (com.seeyon.cap4.form.bean.FormDataMasterBean)this.cap4FormDataCacheLoadManager.getData(aContext.getFormMasterId(), aContext.getFormId());
            if (formDataMasterBean != null) {
                return this.getPojo(formDataMasterBean, false);
            }
        } else {
            FormDataMasterBean formDataMasterBean = (FormDataMasterBean)this.cap3FormDataCacheLoadManager.getData(aContext.getFormMasterId(), aContext.getFormId());
            if (formDataMasterBean != null) {
                return this.getPojo(formDataMasterBean, false);
            }
        }
        return null;
    }

    @Override
    public String object2JsonStr(CAPFormDataPojo aObject) {
        HashMap<String, Object> map = null;
        if (aObject != null) {
            boolean isCap4 = aObject.isCAP4();
            Map dataMap = isCap4 ? this.cap4FormDataCacheLoadManager.object2JsonMap((Object)((com.seeyon.cap4.form.bean.FormDataMasterBean)aObject.getDataBean())) : this.cap3FormDataCacheLoadManager.object2JsonMap((Object)((FormDataMasterBean)aObject.getDataBean()));
            if (dataMap != null) {
                map = new HashMap<String, Object>(2);
                map.put(VERSION, isCap4 ? CAPFormEnum.FormVersion.FOUR.getName() : CAPFormEnum.FormVersion.THREE.getName());
                map.put(DATA, dataMap);
            }
        } else {
            LOGGER.error((Object)"object2JsonStr aObject is null");
        }
        return map == null ? null : JSONUtil.toJSONString(map);
    }

    @Override
    public CAPFormDataPojo jsonStr2Object(String jsonStr) {
        if (Strings.isBlank((String)jsonStr)) {
            return null;
        }
        Map map = (Map)JSONUtil.parseJSONString((String)jsonStr);
        if (map != null && !map.isEmpty()) {
            if (CAPFormEnum.FormVersion.FOUR.getName().equals(map.get(VERSION))) {
                com.seeyon.cap4.form.bean.FormDataMasterBean formDataMasterBean = (com.seeyon.cap4.form.bean.FormDataMasterBean)this.cap4FormDataCacheLoadManager.jsonMap2Object((Map)map.get(DATA));
                if (formDataMasterBean != null) {
                    LOGGER.info((Object)("dataId " + formDataMasterBean.getId() + " load from cache"));
                    return this.getPojo(formDataMasterBean, true);
                }
            } else {
                FormDataMasterBean formDataMasterBean = (FormDataMasterBean)this.cap3FormDataCacheLoadManager.jsonMap2Object((Map)map.get(DATA));
                if (formDataMasterBean != null) {
                    LOGGER.info((Object)("dataId " + formDataMasterBean.getId() + " load from cache"));
                    return this.getPojo(formDataMasterBean, true);
                }
            }
        }
        return null;
    }

    private <T> CAPFormDataPojo<T> getPojo(T dataBean, boolean loadNew) {
        CAPFormDataPojo<T> pojo = new CAPFormDataPojo<T>();
        pojo.setDataBean(dataBean);
        pojo.setLoadByNew(loadNew);
        return pojo;
    }

    @Override
    public byte[] object2Bytes(CAPFormDataPojo aObject) {
        String jsonStr = this.object2JsonStr(aObject);
        return jsonStr == null ? null : jsonStr.getBytes();
    }

    @Override
    public CAPFormDataPojo bytes2Object(byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        String jsonStr = null;
        try {
            jsonStr = new String(aBytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"bytes2Object exception", (Throwable)e);
        }
        return this.jsonStr2Object(jsonStr);
    }
}

