/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.bind;

import com.seeyon.apps.project.api.ProjectApi;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.modules.engin.bind.CAP4FormBindDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.permission.manager.PermissionManager;
import com.seeyon.ctp.common.permission.vo.PermissionVO;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4FormBindDesignController
extends BaseController {
    private CAP4FormManager cap4FormManager;
    private CAP4FormBindDesignManager cap4FormBindDesignManager;
    private ProjectApi projectApi;
    private PermissionManager permissionManager;
    private CAP4FormDesignManager cap4FormDesignManager;

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav;
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormDesignManager.checkAndLoadForm2Session(formId, "");
        if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
            mav = new ModelAndView("cap4/form/design/bindDesign/flowFormBindDesign4CAP4");
            if (fb.getBind().getExtraAttr("batchId") == null) {
                fb.getBind().putExtraAttr("batchId", UUIDLong.longUUID());
                if (Strings.isEmpty((Collection)fb.getBind().getFlowTemplateList())) {
                    List<CtpTemplate> templateList = this.cap4FormManager.getFormSystemTemplate(fb.getId());
                    fb.getBind().setFlowTemplateList(templateList);
                }
            }
            FormAuthViewBean startAuth = fb.getNewFormAuthViewBean();
            FormAuthViewBean nomorlAuth = (FormAuthViewBean)fb.getUpdateAndShowFormAuthViewBeans().get(0);
            mav.addObject("startOperation", (Object)startAuth.getId());
            mav.addObject("nomorlOperation", (Object)nomorlAuth.getId());
            PermissionVO vo = this.permissionManager.getDefaultPermissionByConfigCategory("col_flow_perm_policy", Long.valueOf(AppContext.currentAccountId()));
            mav.addObject("defaultPolicyId", (Object)vo.getName());
            mav.addObject("defaultPolicyName", (Object)vo.getLabel());
            List projectSummaries = new ArrayList();
            if (AppContext.hasPlugin((String)"project")) {
                projectSummaries = this.projectApi.findProjectsByAccountId(Long.valueOf(AppContext.currentAccountId()));
            }
            mav.addObject("project", projectSummaries);
            mav.addObject("productId", (Object)SystemProperties.getInstance().getProperty("system.ProductId"));
        } else {
            mav = new ModelAndView("cap4/form/design/bindDesign/bindDesign4CAP4");
            mav.addObject("add", (Object)Enums.FormAuthorizationType.add.getKey());
            mav.addObject("browse", (Object)Enums.FormAuthorizationType.show.getKey());
            mav.addObject("update", (Object)Enums.FormAuthorizationType.update.getKey());
            mav.addObject("pcViewList", (Object)fb.getFormViewList(Enums.ViewType.SeeyonForm));
            mav.addObject("phoneViewList", (Object)fb.getFormViewList(Enums.ViewType.Phone));
            mav.addObject("unFlowForm", (Object)Enums.FormType.unFlowForm.getKey());
            mav.addObject("processesForm", (Object)Enums.FormType.processesForm.getKey());
            List logFieldList = fb.getBind().getLogFieldList();
            String logs = "";
            String logsId = "";
            for (String log : logFieldList) {
                logsId = logsId + log + ",";
                logs = logs + fb.getFieldBeanByName(log.substring(log.indexOf(".") + 1)).getDisplay() + ",";
            }
            mav.addObject("logsId", (Object)("".equals(logsId) ? "" : logsId.substring(0, logsId.length() - 1)));
            mav.addObject("logs", (Object)("".equals(logs) ? "" : logs.substring(0, logs.length() - 1)));
        }
        mav.addObject("formBean", (Object)fb);
        mav.addObject("redTemplete", (Object)fb.hasRedTemplete());
        return mav;
    }

    public ModelAndView bindAuthDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/bindDesign/bindAuthDesign4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        mav.addObject("add", (Object)Enums.FormAuthorizationType.add.getKey());
        mav.addObject("browse", (Object)Enums.FormAuthorizationType.show.getKey());
        mav.addObject("update", (Object)Enums.FormAuthorizationType.update.getKey());
        mav.addObject("pcViewList", (Object)fb.getFormViewList(Enums.ViewType.SeeyonForm));
        mav.addObject("phoneViewList", (Object)fb.getFormViewList(Enums.ViewType.Phone));
        mav.addObject("formBean", (Object)fb);
        return mav;
    }

    public ModelAndView bindAuthDesignSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map params = ParamUtil.getJsonParams();
        this.cap4FormBindDesignManager.saveOrUpdateBindAuth(params);
        response.sendRedirect("../cap4/bindDesign.do?method=index&formId=" + (String)params.get("formId") + Functions.csrfSuffix());
        return null;
    }

    public ModelAndView bindLogsAndCodeSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map params = ParamUtil.getJsonParams();
        this.cap4FormBindDesignManager.saveOrUpdateCodeAndLogs(params);
        return null;
    }

    public ModelAndView editFlowTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=UTF-8");
        String id = ReqUtil.getString((HttpServletRequest)request, (String)"id");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        DataContainer dc = new DataContainer();
        dc.putAll(this.cap4FormBindDesignManager.editFlowTemplate(id, formId));
        String result = dc.getJson();
        response.getWriter().println(StringEscapeUtils.escapeHtml((String)result));
        response.getWriter().flush();
        response.getWriter().close();
        return null;
    }

    public ModelAndView cycleSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/bindDesign/cycleSetting4CAP4");
        return mav;
    }

    public ModelAndView advancePigeonhole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/bindDesign/advancePigeonhole4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        List tempList = fb.getAllFieldBeans();
        ArrayList<FormFieldBean> fieldList = new ArrayList<FormFieldBean>();
        for (FormFieldBean f : tempList) {
            if (!f.isMasterField() || !FormFieldComEnum.RADIO.getKey().equals(f.getInputType()) && !FormFieldComEnum.SELECT.getKey().equals(f.getInputType()) && !FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(f.getInputType()) && !FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(f.getInputType())) continue;
            fieldList.add(f);
        }
        mav.addObject("formBean", (Object)fb);
        mav.addObject("fieldList", fieldList);
        mav.addObject("redTemplete", (Object)fb.hasRedTemplete());
        return mav;
    }

    public ModelAndView saveFlowTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map params = ParamUtil.getJsonDomain((String)"templateNameSet");
        List fileList = ParamUtil.getJsonDomainGroup((String)"fileArea");
        this.cap4FormBindDesignManager.saveOrUpdateFlowTemplate(params, fileList);
        response.sendRedirect("../cap4/bindDesign.do?method=index&formId=" + (String)params.get("formId") + Functions.csrfSuffix());
        return null;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormBindDesignManager(CAP4FormBindDesignManager cap4FormBindDesignManager) {
        this.cap4FormBindDesignManager = cap4FormBindDesignManager;
    }

    public void setProjectApi(ProjectApi projectApi) {
        this.projectApi = projectApi;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }
}

