/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.bind;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionInitManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.vo.FormOperateConditionVo;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormBindInitManagerImpl
implements CAP4FormDefinitionInitManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormBindInitManagerImpl.class);
    private FormAuthModuleDAO formAuthModuleDAO;
    private CAP4FormCacheManager cap4FormCacheManager;

    @Override
    public void initDefinitionAttr(FormBean formBean, CAPFormDefinition definition) throws BusinessException {
        if (Strings.isNotEmpty((String)definition.getAppbindInfo())) {
            try {
                FormBindBean bindBean;
                if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                    bindBean = new FormBindBean();
                    bindBean.setFormBean(formBean);
                    this.initFlowBusinessFromJson(bindBean, definition.getAppbindInfo());
                    List moduleAuthList = this.formAuthModuleDAO.selectByFormIdAndModuleType(formBean.getId(), Integer.valueOf(Enums.FormModuleAuthModuleType.FlowBusiness.getKey()));
                    if (Strings.isNotEmpty((Collection)moduleAuthList)) {
                        for (FormModuleAuth formModuleAuth : moduleAuthList) {
                            FormFlowBusinessBean flowBusiness = bindBean.getFlowBusinessBean("" + formModuleAuth.getModuleId());
                            if (flowBusiness == null) continue;
                            flowBusiness.getModuleAuthList().add(formModuleAuth);
                        }
                    }
                } else {
                    bindBean = (FormBindBean)JSONUtil.parseJSONString((String)definition.getAppbindInfo(), FormBindBean.class);
                    bindBean.setFormBean(formBean);
                    this.initBindAuthFromJson(bindBean, definition.getAppbindInfo());
                    List moduleAuthList = this.formAuthModuleDAO.selectByFormIdAndModuleType(formBean.getId(), Integer.valueOf(Enums.FormModuleAuthModuleType.BindAppForm.getKey()));
                    if (Strings.isNotEmpty((Collection)moduleAuthList)) {
                        for (FormModuleAuth formModuleAuth : moduleAuthList) {
                            FormBindAuthBean formBindAuthBean = bindBean.getFormBindAuthBean("" + formModuleAuth.getModuleId());
                            if (formBindAuthBean == null) continue;
                            formBindAuthBean.getModuleAuthList().add(formModuleAuth);
                        }
                    }
                }
                formBean.setBind(bindBean);
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u89e3\u6790\u5e94\u7528\u7ed1\u5b9a\u4fe1\u606f\u65f6\u5f02\u5e38: " + formBean.getId()), (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
        }
    }

    private void initBindAuthFromJson(FormBindBean formBindBean, String jsonString) throws BusinessException {
        String bindAuthStr;
        Map jsonMap = (Map)JSONUtil.parseJSONString((String)jsonString);
        if (jsonMap.size() > 0 && Strings.isNotEmpty((String)(bindAuthStr = jsonMap.get("formBindAuthList").toString()))) {
            List jsonArray = (List)JSONUtil.parseJSONString((String)bindAuthStr, List.class);
            for (Map object : jsonArray) {
                FormBindAuthBean bindAuth = (FormBindAuthBean)JSONUtil.parseJSONString((String)object.toString(), FormBindAuthBean.class);
                bindAuth.setFormBindBean(formBindBean);
                this.initBeanFromJson(bindAuth, object);
                formBindBean.addFormBindAuthBean(bindAuth);
            }
        }
    }

    private void initBeanFromJson(FormBindAuthBean bindAuth, Map<String, Object> jsonObject) throws BusinessException {
        bindAuth.getUpdateAuthList().clear();
        bindAuth.setUpdateAuthList(this.initSimpleObjectBean(jsonObject.get("updateAuthList").toString()));
        bindAuth.getAuthList().clear();
        bindAuth.setAuthList(this.initSimpleObjectBean(jsonObject.get("authList").toString()));
        bindAuth.getSearchFieldList().clear();
        bindAuth.setSearchFieldList(this.initSimpleObjectBean(jsonObject.get("searchFieldList").toString()));
        String formulaJson = jsonObject.get("formFormula").toString();
        Map formulaMap = (Map)JSONUtil.parseJSONString((String)formulaJson, Map.class);
        if (!formulaMap.isEmpty()) {
            Long formulaId = Long.parseLong(formulaMap.get("value").toString());
            FormFormulaBean ffb = this.cap4FormCacheManager.loadFormFormulaBean(bindAuth.getFormBindBean().getFormBean(), formulaId);
            bindAuth.setFormFormulaBean(ffb);
        }
        if (jsonObject.containsKey("customBtnList")) {
            List customBtnList = (List)jsonObject.get("customBtnList");
            bindAuth.setCustomBtnList(customBtnList);
        }
        if (!jsonObject.containsKey("btnShowOrderList")) {
            FormDesignUtil.upgradeBindAuth((FormBindAuthBean)bindAuth);
        }
        FormDesignUtil.initBtnShowOrderMap((FormBindAuthBean)bindAuth);
    }

    private void initFlowBusinessFromJson(FormBindBean formBindBean, String jsonString) throws BusinessException {
        String bindAuthStr;
        Map jsonMap = (Map)JSONUtil.parseJSONString((String)jsonString);
        if (jsonMap.size() > 0 && Strings.isNotEmpty((String)(bindAuthStr = jsonMap.get("flowBusinessList").toString()))) {
            List jsonArray = (List)JSONUtil.parseJSONString((String)bindAuthStr, List.class);
            for (Map object : jsonArray) {
                FormFlowBusinessBean flowBusiness = (FormFlowBusinessBean)JSONUtil.parseJSONString((String)object.toString(), FormFlowBusinessBean.class);
                flowBusiness.setFormBindBean(formBindBean);
                this.initFlowBeanFromJson(flowBusiness, object);
                formBindBean.addFormFlowBusinessBean(flowBusiness);
            }
        }
    }

    private void initFlowBeanFromJson(FormFlowBusinessBean flowBusiness, Map<String, Object> jsonObject) throws BusinessException {
        flowBusiness.getBtnInfoList().clear();
        flowBusiness.setBtnInfoList(this.initSimpleObjectBean(jsonObject.get("btnInfoList").toString()));
        flowBusiness.getSearchFieldList().clear();
        flowBusiness.setSearchFieldList(this.initSimpleObjectBean(jsonObject.get("searchFieldList").toString()));
        String preConditionJson = jsonObject.get("preCondition").toString();
        List preConditionList = (List)JSONUtil.parseJSONString((String)preConditionJson, List.class);
        if (Strings.isNotEmpty((Collection)preConditionList)) {
            ArrayList<FormOperateConditionVo> preCondition = new ArrayList<FormOperateConditionVo>();
            for (Map pre : preConditionList) {
                FormOperateConditionVo temp = new FormOperateConditionVo(pre);
                if (temp.isEmpty()) continue;
                preCondition.add(temp);
            }
            flowBusiness.setPreCondition(preCondition);
        }
        if (jsonObject.containsKey("customBtnList")) {
            List customBtnList = (List)jsonObject.get("customBtnList");
            flowBusiness.setCustomBtnList(customBtnList);
        }
        FormDesignUtil.initFlowBusinessBtnOrderMap((FormFlowBusinessBean)flowBusiness);
    }

    private List<SimpleObjectBean> initSimpleObjectBean(String sobJsonString) {
        ArrayList<SimpleObjectBean> sobList = new ArrayList<SimpleObjectBean>();
        List jsonArray = (List)JSONUtil.parseJSONString((String)sobJsonString, List.class);
        for (Map object : jsonArray) {
            SimpleObjectBean simpleObjectBean = (SimpleObjectBean)JSONUtil.parseJSONString((String)object.toString(), SimpleObjectBean.class);
            Object extMapObj = object.get("extMap");
            if (null != extMapObj) {
                String extMapJson = extMapObj.toString();
                Map extMap = (Map)JSONUtil.parseJSONString((String)extMapJson, Map.class);
                for (Map.Entry entry : extMap.entrySet()) {
                    simpleObjectBean.addExtAttr((String)entry.getKey(), entry.getValue() == null ? "" : String.valueOf(entry.getValue()));
                }
            }
            sobList.add(simpleObjectBean);
        }
        return sobList;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public Integer getSort() {
        return 3;
    }
}

