/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.bind;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateAuth;
import com.seeyon.ctp.common.quartz.QuartzJob;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UniqueList;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CAP4FormBindQuartzJob
implements QuartzJob {
    private static final Log log = LogFactory.getLog(CAP4FormBindQuartzJob.class);
    public static final String FORMBIND_JOBNAME = "FormBind_JobName_";
    public static final String FORMBIND_GROUPNAME = "FormBind_GroupName";
    private CAP4FormManager cap4FormManager;
    private CAP4FormDataManager cap4FormDataManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private TemplateManager templateManager;
    private OrgManager orgManager;
    private CollaborationApi collaborationApi;
    private WorkflowApiManager wapi;

    public synchronized void execute(Map<String, String> parameters) {
        log.info((Object)"\u8868\u5355\u6a21\u677f\u81ea\u52a8\u53d1\u8d77-\u5b9a\u65f6\u4efb\u52a1\u6267\u884c********************");
        try {
            Long templateId = NumberUtils.toLong((String)parameters.get("templateId"));
            CtpTemplate template = this.getTemplateManager().getCtpTemplate(templateId);
            if (template == null || template.isDelete().booleanValue()) {
                log.warn((Object)"\u8868\u5355\u6a21\u677f\u81ea\u52a8\u53d1\u8d77\uff1atemplate is null");
                return;
            }
            List templateAuths = this.getTemplateManager().getCtpTemplateAuths(template.getId(), template.getModuleType());
            if (Strings.isEmpty((Collection)templateAuths)) {
                log.warn((Object)"\u8868\u5355\u6a21\u677f\u81ea\u52a8\u53d1\u8d77\uff1atemplateAuth is empty");
                return;
            }
            Long formId = NumberUtils.toLong((String)parameters.get("formId"));
            FormBean formBean = this.getCap4FormCacheManager().getForm(formId);
            if (!this.getCap4FormCacheManager().isEnabled(formBean)) {
                log.warn((Object)"\u8868\u5355\u6a21\u677f\u81ea\u52a8\u53d1\u8d77\uff1aformBean is null");
                return;
            }
            UniqueList list = new UniqueList();
            for (CtpTemplateAuth templateAuth : templateAuths) {
                list.add(templateAuth.getAuthType() + "|" + templateAuth.getAuthId());
            }
            String templateAuthStr = StringUtils.join((Collection)list, (String)",");
            String cycleSender = parameters.get("cycleSender");
            if (Strings.isNotBlank((String)cycleSender) && Strings.isNotBlank((String)templateAuthStr)) {
                Set members2;
                Set members1 = this.getOrgManager().getMembersByTypeAndIds(cycleSender);
                List members = Strings.getIntersection((Collection)members1, (Collection)(members2 = this.getOrgManager().getMembersByTypeAndIds(templateAuthStr)));
                if (Strings.isNotEmpty((Collection)members)) {
                    for (V3xOrgMember member : members) {
                        if (member == null || !member.isValid()) continue;
                        this.transSendColl(member.getId(), template, formBean);
                    }
                } else {
                    log.warn((Object)("\u8bbe\u7f6e\u7684\u53d1\u8d77\u4eba\u4e0d\u5728\u6388\u6743\u8303\u56f4\u5185\uff0c\u4e0d\u6267\u884c\uff0c\u53d1\u8d77\u4eba\uff1a" + cycleSender + ", \u6388\u6743\uff1a" + templateAuthStr));
                }
            } else {
                log.warn((Object)("\u53d1\u8d77\u4eba\u6216\u8005\u6388\u6743\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\uff0c\u53d1\u8d77\u4eba\uff1a" + cycleSender + ", \u6388\u6743\uff1a" + templateAuthStr));
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8868\u5355\u6a21\u677f\u81ea\u52a8\u53d1\u8d77\uff1a", (Throwable)e);
        }
    }

    private void transSendColl(Long senderId, CtpTemplate template, FormBean formBean) throws Exception {
        FormTriggerUtil.addCurrentUser4TriggerAction(senderId);
        HashMap<String, Comparable<Long>> dataMap = new HashMap<String, Comparable<Long>>();
        dataMap.put(Enums.MasterTableField.start_member_id.getKey(), senderId);
        dataMap.put(Enums.MasterTableField.modify_member_id.getKey(), senderId);
        dataMap.put(Enums.MasterTableField.start_date.getKey(), DateUtil.currentTimestamp());
        String operationId = FormUtil.parseOperationId((String)this.getWapi().getNodeFormOperationName(template.getWorkflowId(), null));
        FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(operationId));
        AppContext.putThreadContext((String)"isNew", (Object)true);
        HashMap changeTag = new HashMap();
        AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
        FormDataMasterBean formDataMasterBean = FormDataMasterBean.newInstance((FormBean)formBean);
        AppContext.removeThreadContext((String)"isNew");
        formDataMasterBean.putExtraAttr("isNew", true);
        formDataMasterBean.addFieldValue(dataMap);
        formDataMasterBean.setStartMemberId(senderId.longValue());
        formDataMasterBean.setModifyMemberId(senderId.longValue());
        formDataMasterBean.setStartDate((Date)dataMap.get(Enums.MasterTableField.start_date.getKey()));
        this.getCap4FormManager().putSessioMasterDataBean(formBean, formDataMasterBean, false, false);
        formDataMasterBean.putExtraAttr("needProduceValue", "true");
        formDataMasterBean.putExtraAttr("moduleId", (Object)formDataMasterBean.getId());
        this.getCap4FormDataManager().calcAll(formBean, formDataMasterBean, formAuthViewBean, false, true, true, true);
        AppContext.removeThreadContext((String)"fieldChangeTag");
        formDataMasterBean.checkData(formBean);
        this.getCap4FormDataManager().insertOrUpdateMasterData(formDataMasterBean);
        this.getColPubManager().transSendColl(ColConstant.SendType.auto, template.getId(), senderId, formDataMasterBean.getId(), null, formDataMasterBean.getId());
        List serialRecordList = (List)formDataMasterBean.getExtraAttr("serialCalRecords");
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialCalRecordManager.save(serialRecordList);
        }
    }

    public CAP4FormManager getCap4FormManager() {
        if (this.cap4FormManager == null) {
            this.cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
        }
        return this.cap4FormManager;
    }

    public CAP4FormDataManager getCap4FormDataManager() {
        if (this.cap4FormDataManager == null) {
            this.cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
        }
        return this.cap4FormDataManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        if (this.cap4FormCacheManager == null) {
            this.cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        }
        return this.cap4FormCacheManager;
    }

    public TemplateManager getTemplateManager() {
        if (this.templateManager == null) {
            this.templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        }
        return this.templateManager;
    }

    public OrgManager getOrgManager() {
        if (this.orgManager == null) {
            this.orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        }
        return this.orgManager;
    }

    public CollaborationApi getColPubManager() {
        if (this.collaborationApi == null) {
            this.collaborationApi = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        }
        return this.collaborationApi;
    }

    public WorkflowApiManager getWapi() {
        if (this.wapi == null) {
            this.wapi = (WorkflowApiManager)AppContext.getBean((String)"wapi");
        }
        return this.wapi;
    }
}

