/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.businessRelation;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldExtendCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldLineNumber;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldMapCtrl;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseDesignInterface;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.vo.FormTriggerDataRightVo;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.v3x.worktimeset.domain.WorkTimeCurrency;
import com.seeyon.v3x.worktimeset.manager.WorkTimeSetManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4FormBusinessRelationController
extends BaseController {
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormBusinessRelationManager cap4FormBusinessRelationManager;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private CAP4FormListManager cap4FormListManager;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormBusinessRelationController.class);

    public ModelAndView editRelation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int i;
        String targetTable;
        ModelAndView mav = new ModelAndView("cap4/form/businessRelation/cap4FormRelation");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        Long targetFormId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetFormId", (long)0L);
        Long relationId = ReqUtil.getLong((HttpServletRequest)request, (String)"relationId", (long)0L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"view");
        String from = ReqUtil.getString((HttpServletRequest)request, (String)"formManager", (String)"false");
        FormDesignUtil.checkBusinessRelationPlugins((String)type, (String)from);
        FormRelationshipBean formRelationshipBean = new FormRelationshipBean();
        if (!"new".equals(type)) {
            formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            formId = formRelationshipBean.getSourceFormId();
            targetFormId = formRelationshipBean.getTargetFormId();
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetFormId);
        mav.addObject("formBean", (Object)formBean);
        mav.addObject("targetFormBean", (Object)targetFormBean);
        List targetAllField = targetFormBean.getAllFieldBeans();
        ArrayList<FormFieldBean> targetRemoveField = new ArrayList<FormFieldBean>();
        for (FormFieldBean formFieldBean : targetAllField) {
            if (!formFieldBean.isCustomerCtrl()) continue;
            targetRemoveField.add(formFieldBean);
        }
        targetAllField.removeAll(targetRemoveField);
        mav.addObject("targetFieldList", (Object)targetAllField);
        List uniques = targetFormBean.getUniqueFieldList();
        ArrayList<List<FormFieldBean>> uniqueList = new ArrayList<List<FormFieldBean>>();
        ArrayList<FormFieldBean> tempFields = new ArrayList<FormFieldBean>();
        for (List list : uniques) {
            ArrayList<FormFieldBean> fieldBeanList = new ArrayList<FormFieldBean>();
            for (Object fieldName : list) {
                FormFieldBean formField = targetFormBean.getFieldBeanByName((String)fieldName);
                fieldBeanList.add(formField);
                tempFields.add(formField);
            }
            uniqueList.add(this.removeExtendField(fieldBeanList));
        }
        boolean hasUnique = uniqueList.size() != 0;
        mav.addObject("uniqueList", uniqueList);
        mav.addObject("hasUnique", (Object)hasUnique);
        List allFields = formBean.getAllFieldBeans();
        mav.addObject("srcAllField", this.removeExtendField(allFields));
        List otherFields = targetFormBean.getAllFieldBeans();
        otherFields.removeAll(tempFields);
        mav.addObject("otherFields", this.removeExtendField(otherFields));
        ArrayList<FormFieldBean> fieldList = new ArrayList<FormFieldBean>();
        for (FormFieldBean temp : allFields) {
            FormFieldCtrl formFieldCtrl = temp.getFieldCtrl();
            if (!formFieldCtrl.canRelation()) continue;
            fieldList.add(temp);
        }
        mav.addObject("fieldList", fieldList);
        mav.addObject("targetFormName", (Object)targetFormBean.getFormName());
        List targetTableList = targetFormBean.getTableList();
        mav.addObject("targetTableList", (Object)targetTableList);
        mav.addObject("uniqueFieldList", (Object)targetFormBean.getUniqueFieldList());
        mav.addObject("showSystem", (Object)(!targetFormBean.isFlowForm() ? 1 : 0));
        mav.addObject("flowForm", (Object)formBean.isFlowForm());
        mav.addObject("sourceTableList", (Object)formBean.getTableList());
        mav.addObject("hasDetailTable", (Object)(formBean.getTableList().size() > 1 ? 1 : 0));
        boolean canSwitch = true;
        if ("modify".equals(type)) {
            canSwitch = formBean.getState() == Enums.FormStateEnum.official.getKey() ? this.cap4FormBusinessRelationManager.canSwitchRelationState(formId) : true;
        }
        mav.addObject("canSwitch", (Object)canSwitch);
        if ("new".equals(type)) {
            formRelationshipBean.setSourceFormId(formId.longValue());
            formRelationshipBean.setTargetFormId(targetFormId.longValue());
            formRelationshipBean.setState(Enums.BusinessRelationState.ON.getKey());
            formRelationshipBean.setRelationType(FormRelationEnums.ViewSelectType.user.getKey());
            targetTable = "";
            String targetTableDisplay = targetFormBean.getFormName() + "(";
            i = 0;
            for (FormTableBean temp : targetTableList) {
                if (i > 0) {
                    targetTable = targetTable + ",";
                    targetTableDisplay = targetTableDisplay + "\u3001";
                }
                targetTable = targetTable + temp.getTableName();
                targetTableDisplay = targetTableDisplay + temp.getDisplay();
                ++i;
            }
            targetTableDisplay = targetTableDisplay + ")";
            formRelationshipBean.setTargetTable(targetTable);
            formRelationshipBean.putExtraAttr("targetTableDisplay", targetTableDisplay);
        } else {
            targetTable = formRelationshipBean.getTargetTable();
            String[] selectedTable = targetTable.split(",");
            i = 0;
            String newTargetTable = "";
            String targetTableDisplay = targetFormBean.getFormName() + "(";
            for (String tableName : selectedTable) {
                FormTableBean formTableBean = targetFormBean.getTableByTableName(tableName);
                if (formTableBean == null) continue;
                if (i > 0) {
                    targetTableDisplay = targetTableDisplay + "\u3001";
                    newTargetTable = newTargetTable + ",";
                }
                newTargetTable = newTargetTable + tableName;
                targetTableDisplay = targetTableDisplay + formTableBean.getDisplay();
                ++i;
            }
            formRelationshipBean.setTargetTable(newTargetTable);
            targetTableDisplay = targetTableDisplay + ")";
            formRelationshipBean.putExtraAttr("targetTableDisplay", targetTableDisplay);
            AppContext.putThreadContext((String)"toDisplay", (Object)true);
            mav.addObject("dataJson", (Object)formRelationshipBean.toJSON());
        }
        mav.addObject("formRelationshipBean", (Object)formRelationshipBean);
        List list = FormRelationEnums.SpecialRelationItem.list();
        ArrayList<FormFieldBean> specialFieldList = new ArrayList<FormFieldBean>();
        for (Map l : list) {
            specialFieldList.add((FormFieldBean)l.get("fieldBean"));
        }
        mav.addObject("specialRelationItem", specialFieldList);
        String tableName = formBean.getMasterTableBean().getTableName();
        String[] split = tableName.split("_");
        mav.addObject("masterTableName", (Object)tableName);
        mav.addObject("tableNumber", (Object)split[1]);
        return mav;
    }

    private List<FormFieldBean> removeExtendField(List<FormFieldBean> fields) {
        ArrayList<FormFieldBean> result = new ArrayList<FormFieldBean>();
        for (FormFieldBean field : fields) {
            FormFieldCtrl ctrl = field.getFieldCtrl();
            if (ctrl instanceof FormFieldExtendCtrl || ctrl instanceof FormFieldMapCtrl || ctrl instanceof FormFieldCustomCtrl || ctrl instanceof FormFieldLineNumber) continue;
            result.add(field);
        }
        return result;
    }

    public ModelAndView listFormData(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView modelAndView = new ModelAndView("cap4/form/business/bizconfigApp/businessFlowFormList");
        FlipInfo flipInfo = this.cap4FormListManager.showFormList(new FlipInfo(-1), null);
        List data = flipInfo.getData();
        modelAndView.addObject("formList", (Object)JSONUtil.toJSONString((Object)data));
        return modelAndView;
    }

    public ModelAndView formCommitSetting(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessRelation/formCommitSetting");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List pcViewList = formBean.getFormViewList(Enums.ViewType.SeeyonForm);
        List phoneViewList = formBean.getFormViewList(Enums.ViewType.Phone);
        mav.addObject("pcViewList", (Object)pcViewList);
        mav.addObject("phoneViewList", (Object)phoneViewList);
        return mav;
    }

    public ModelAndView selectView(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessRelation/selectView");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List pcViewList = formBean.getFormViewList(Enums.ViewType.SeeyonForm);
        List phoneViewList = formBean.getFormViewList(Enums.ViewType.Phone);
        mav.addObject("browse", (Object)Enums.FormAuthorizationType.show.getKey());
        mav.addObject("pcViewList", (Object)pcViewList);
        mav.addObject("phoneViewList", (Object)phoneViewList);
        return mav;
    }

    public ModelAndView relationSelectorSet(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessRelation/relationSelectorSet");
        return mav;
    }

    public ModelAndView selectOperate(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/selectOperate");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List pcViewList = formBean.getFormViewList(Enums.ViewType.SeeyonForm);
        List phoneViewList = formBean.getFormViewList(Enums.ViewType.Phone);
        mav.addObject("browse", (Object)Enums.FormAuthorizationType.show.getKey());
        mav.addObject("pcViewList", (Object)pcViewList);
        mav.addObject("phoneViewList", (Object)phoneViewList);
        return mav;
    }

    public ModelAndView triggerDateTimeSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/timeset4CAP4");
        Long formId = ParamUtil.getLong((Map)request.getParameterMap(), (String)"formId", (Long)-1L);
        FormBean fb = this.cap4FormCacheManager.getForm(formId);
        mav.addObject("formBean", (Object)fb);
        WorkTimeSetManager workTimeSetManager = (WorkTimeSetManager)AppContext.getBean((String)"workTimeSetManager");
        WorkTimeCurrency workTimeCurrency = workTimeSetManager.findComnWorkTimeSet(String.valueOf(Calendar.getInstance().get(1)), String.valueOf(Calendar.getInstance().get(2) + 1), Long.valueOf(AppContext.currentAccountId()), false);
        String amWorkTimeBeginTime = workTimeCurrency.getAmWorkTimeBeginTime();
        if (amWorkTimeBeginTime.startsWith("0")) {
            amWorkTimeBeginTime = amWorkTimeBeginTime.substring(1);
        }
        mav.addObject("timeQuartz", (Object)amWorkTimeBeginTime);
        return mav;
    }

    public ModelAndView prewriteSet(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView model = new ModelAndView("cap4/form/businessTrigger/prewriteSet4CAP4");
        LinkedList targetFieldList = new LinkedList();
        LinkedList sourceFieldList = new LinkedList();
        String selectedFieldList = ReqUtil.getString((HttpServletRequest)request, (String)"selectedFieldList", (String)"");
        Long targetId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetId", (long)-1L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"form");
        model.addObject("type", (Object)type);
        if ("magicInterface".equals(type)) {
            Map extMapper;
            MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(targetId);
            if (entity != null && (extMapper = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class)) != null) {
                List fillback = (List)extMapper.get("fillback");
                Map fieldLimit = (Map)extMapper.get("fieldLimit");
                for (Object t : fillback) {
                    Object limit = fieldLimit.get(t.toString());
                    if (limit == null) continue;
                    HashMap<String, Object> limitMapper = new HashMap<String, Object>();
                    limitMapper.put("limitConfig", JSONUtil.parseJSONString((String)limit.toString()));
                    limitMapper.put("name", t);
                    if (selectedFieldList.contains(t.toString())) {
                        targetFieldList.add(limitMapper);
                        continue;
                    }
                    sourceFieldList.add(limitMapper);
                }
            }
        } else {
            FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetId);
            if (targetFormBean != null) {
                for (FormFieldBean ffb : targetFormBean.getAllFieldBeans()) {
                    if (!Enums.FieldType.DECIMAL.getKey().equals(ffb.getFieldType()) || !FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType())) continue;
                    if (selectedFieldList.contains(ffb.getName())) {
                        targetFieldList.add(ffb);
                        continue;
                    }
                    sourceFieldList.add(ffb);
                }
            }
        }
        model.addObject("sourceFieldList", sourceFieldList);
        model.addObject("targetFieldList", targetFieldList);
        return model;
    }

    public ModelAndView multiFieldsSet(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView model = new ModelAndView("cap4/form/businessTrigger/multiFieldsSet4CAP4");
        LinkedList<FormFieldBean> fieldList = new LinkedList<FormFieldBean>();
        String selectedFields = ReqUtil.getString((HttpServletRequest)request, (String)"selectedFields", (String)"");
        Long targetId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetId", (long)-1L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"form");
        model.addObject("type", (Object)type);
        if ("magicInterface".equals(type)) {
            MagicInterfaceDefineEntity magicEntity = this.magicInterfaceDefineDao.loadDefineById(targetId);
            List<FormFieldBean> attchmentFields = MagicPrivateUtils.checkAttachmentFields(magicEntity);
            for (FormFieldBean f : attchmentFields) {
                if (!selectedFields.contains(f.getName())) continue;
                fieldList.add(f);
            }
        } else {
            FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetId);
            if (targetFormBean != null) {
                for (FormFieldBean ffb : targetFormBean.getAllFieldBeans()) {
                    if (!ffb.isAttachment() || !selectedFields.contains(ffb.getName())) continue;
                    fieldList.add(ffb);
                }
            }
        }
        model.addObject("fieldList", fieldList);
        return model;
    }

    public ModelAndView triggerTemplateSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/triggerTemplate4CAP4");
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type");
        if ("magicInterface".equals(type)) {
            String targetId = ReqUtil.getString((HttpServletRequest)request, (String)"targetId");
            try {
                Map extMapper;
                long id = Long.parseLong(targetId);
                MagicInterfaceDefineEntity data = this.magicInterfaceDefineDao.loadDefineById(id);
                if (data != null && (extMapper = (Map)JSONUtil.parseJSONString((String)data.getExt1(), Map.class)) != null) {
                    List templates = (List)extMapper.get("templates");
                    if (templates != null) {
                        for (Map t : templates) {
                            if (!t.containsKey("displayName")) continue;
                            t.put("name", t.get("displayName"));
                        }
                    }
                    mav.addObject("templateList", (Object)templates);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("\u89e6\u53d1\u6a21\u7248\u9009\u62e9\u662f \u6570\u636e\u63a5\u53e3\u51fa\u9519\uff0c\u539f\u56e0: " + e.getLocalizedMessage()));
            }
        } else {
            String targetFormId = ReqUtil.getString((HttpServletRequest)request, (String)"targetFormId");
            FormBean targetForm = this.cap4FormCacheManager.getForm(Long.valueOf(targetFormId));
            ArrayList<SimpleObjectBean> templateList = new ArrayList<SimpleObjectBean>();
            if (targetForm != null && targetForm.isFlowForm()) {
                List<CtpTemplate> list = this.cap4FormManager.getFormSystemTemplate(targetForm.getId());
                for (CtpTemplate template : list) {
                    if (template.getState().intValue() != TemplateEnum.State.normal.ordinal()) continue;
                    SimpleObjectBean object = new SimpleObjectBean();
                    object.setId(template.getId());
                    object.setName(template.getSubject());
                    templateList.add(object);
                }
            }
            mav.addObject("templateList", templateList);
        }
        return mav;
    }

    public ModelAndView dataRightSet(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/dataRightSet");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetFormId", (long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        String actionType = ReqUtil.getString((HttpServletRequest)request, (String)"actionType", (String)"");
        if (Strings.isNotEmpty((String)actionType)) {
            if ("triggerSource".equals(actionType)) {
                mav = new ModelAndView("cap4/form/businessTrigger/triggerSourceSet");
                List pcViewList = formBean.getFormViewList(Enums.ViewType.SeeyonForm);
                List phoneViewList = formBean.getFormViewList(Enums.ViewType.Phone);
                mav.addObject("browse", (Object)Enums.FormAuthorizationType.show.getKey());
                mav.addObject("pcViewList", (Object)pcViewList);
                mav.addObject("phoneViewList", (Object)phoneViewList);
            } else {
                mav = new ModelAndView("cap4/form/businessTrigger/dataRightSet4Msg");
                ArrayList<FormTriggerDataRightVo> pcViewList = new ArrayList<FormTriggerDataRightVo>();
                ArrayList<FormTriggerDataRightVo> phoneViewList = new ArrayList<FormTriggerDataRightVo>();
                for (FormViewBean viewBean : formBean.getFormViewList()) {
                    for (FormAuthViewBean auth : viewBean.getAllOperations()) {
                        if (auth.isDelete() || !Enums.FormAuthorizationType.show.getKey().equals(auth.getType())) continue;
                        FormTriggerDataRightVo showVo = new FormTriggerDataRightVo();
                        showVo.setRightId(viewBean.getId() + "." + auth.getId());
                        showVo.setRightName(viewBean.getFormViewName() + "." + auth.getName());
                        if (Enums.ViewType.SeeyonForm.getText().equals(viewBean.getFormViewType())) {
                            pcViewList.add(showVo);
                            continue;
                        }
                        phoneViewList.add(showVo);
                    }
                }
                mav.addObject("pcViewList", pcViewList);
                mav.addObject("phoneViewList", phoneViewList);
            }
        } else {
            ArrayList<FormTriggerDataRightVo> addAuthList = new ArrayList<FormTriggerDataRightVo>();
            ArrayList<FormTriggerDataRightVo> editAuthList = new ArrayList<FormTriggerDataRightVo>();
            for (FormViewBean viewBean : formBean.getFormViewList()) {
                String viewShowName = Enums.ViewType.SeeyonForm.getText().equals(viewBean.getFormViewType()) ? ResourceUtil.getString((String)"form.view.type.pc.label") + "." + viewBean.getFormViewName() : ResourceUtil.getString((String)"form.view.type.phone.label") + "." + viewBean.getFormViewName();
                for (FormAuthViewBean auth : viewBean.getAllOperations()) {
                    if (auth.isDelete()) continue;
                    FormTriggerDataRightVo rightVo = new FormTriggerDataRightVo();
                    rightVo.setRightId(viewBean.getId() + "." + auth.getId());
                    rightVo.setRightName(viewShowName + "." + auth.getName());
                    if (Enums.FormAuthorizationType.add.getKey().equals(auth.getType())) {
                        addAuthList.add(rightVo);
                        continue;
                    }
                    if (!Enums.FormAuthorizationType.update.getKey().equals(auth.getType())) continue;
                    editAuthList.add(rightVo);
                }
            }
            mav.addObject("addAuthList", addAuthList);
            mav.addObject("editAuthList", editAuthList);
        }
        return mav;
    }

    public ModelAndView editTrigger(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/outerDesign4CAP4");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        Long targetFormId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetFormId", (long)0L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"view");
        String from = ReqUtil.getString((HttpServletRequest)request, (String)"formManager", (String)"false");
        FormDesignUtil.checkBusinessRelationPlugins((String)type, (String)from);
        if (!"new".equals(type)) {
            Long triggerId = ReqUtil.getLong((HttpServletRequest)request, (String)"triggerId", (long)0L);
            FormTriggerBean nowTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
            if (nowTriggerBean == null) {
                throw new BusinessException("\u73af\u5883\u5f02\u5e38\u6216\u8005\uff0c\u5f53\u524d\u89e6\u53d1\u5df2\u5220\u9664\uff01" + triggerId);
            }
            formId = nowTriggerBean.getSourceFormId();
            targetFormId = nowTriggerBean.getTargetFormId();
        }
        FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetFormId);
        FormBean sourceFormBean = this.cap4FormCacheManager.getForm(formId);
        ArrayList<FormFieldBean> sourceFieldList = new ArrayList<FormFieldBean>();
        ArrayList<FormFieldBean> sourceConditionFieldList = new ArrayList<FormFieldBean>();
        if (sourceFormBean.isFlowForm()) {
            sourceFieldList.add(FormTriggerUtil.getSourceFieldBean(sourceFormBean, "flowTitleName"));
        }
        FormTriggerUtil.filterMappingFields(sourceFormBean, sourceFieldList, sourceConditionFieldList);
        ArrayList<FormFieldBean> targetFormFieldList = new ArrayList<FormFieldBean>();
        ArrayList<FormFieldBean> targetConditionFieldList = new ArrayList<FormFieldBean>();
        FormTriggerUtil.filterMappingFields(targetFormBean, targetFormFieldList, targetConditionFieldList);
        ArrayList uniqueFieldList = new ArrayList();
        List uniqueFields = targetFormBean.getUniqueFieldList();
        if (Strings.isNotEmpty((Collection)uniqueFields)) {
            for (List fields : uniqueFields) {
                ArrayList<FormFieldBean> uniques = new ArrayList<FormFieldBean>();
                for (String field : fields) {
                    FormFieldBean fieldBean = targetFormBean.getFieldBeanByName(field);
                    uniques.add(fieldBean);
                }
                targetConditionFieldList.removeAll(uniques);
                uniqueFieldList.add(uniques);
            }
        }
        mav.addObject("targetFormBean", (Object)targetFormBean);
        mav.addObject("hasUnique", (Object)Strings.isNotEmpty(uniqueFieldList));
        mav.addObject("uniqueFieldList", uniqueFieldList);
        mav.addObject("targetFieldList", targetFormFieldList);
        mav.addObject("targetConditionFieldList", targetConditionFieldList);
        Enums.FormType sourceType = Enums.FormType.getEnumByKey((int)sourceFormBean.getFormType());
        Enums.FormType targetType = Enums.FormType.getEnumByKey((int)targetFormBean.getFormType());
        ArrayList<FormTriggerBaseDesignInterface> actionList = new ArrayList<FormTriggerBaseDesignInterface>();
        actionList.addAll(FormTriggerUtil.getDesignManagerList(sourceType, targetType, FormTriggerBean.TriggerBusinessType.FormOuter));
        type = Strings.escapeJavascript((String)type);
        mav.addObject("type", (Object)type);
        mav.addObject("sourceFormBean", (Object)sourceFormBean);
        mav.addObject("sourceFieldList", sourceFieldList);
        mav.addObject("sourceConditionFieldList", sourceConditionFieldList);
        mav.addObject("actionList", actionList);
        return mav;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormBusinessRelationManager(CAP4FormBusinessRelationManager cap4FormBusinessRelationManager) {
        this.cap4FormBusinessRelationManager = cap4FormBusinessRelationManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }
}

