/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.businessRelation;

import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAP4FormBusinessRelationDAOImpl
implements CAP4FormBusinessRelationDAO {
    @Override
    public List<CAPFormBusinessRelation> selectAll() throws BusinessException {
        return DBAgent.loadAll(CAPFormBusinessRelation.class);
    }

    @Override
    public List<CAPFormBusinessRelation> selectAll(long sourceFormId) throws BusinessException {
        String hql = " from CAPFormBusinessRelation f where f.sourceFormId = :sourceFormId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("sourceFormId", sourceFormId);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public List<CAPFormBusinessRelation> selectTwoWayRelation(long formId) throws BusinessException {
        String hql = " from CAPFormBusinessRelation f where f.sourceFormId = :formId or f.targetFormId = :formId ";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("formId", formId);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public CAPFormBusinessRelation selectById(long id) throws BusinessException {
        return (CAPFormBusinessRelation)DBAgent.get(CAPFormBusinessRelation.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public void save(CAPFormBusinessRelation relation) throws BusinessException {
        DBAgent.save((Object)relation);
    }

    @Override
    public void saveList(List<CAPFormBusinessRelation> relationList) throws BusinessException {
        DBAgent.saveAll(relationList);
    }

    @Override
    public void delete(CAPFormBusinessRelation relation) throws BusinessException {
        DBAgent.delete((Object)relation);
    }

    @Override
    public void delete(List<CAPFormBusinessRelation> relationList) throws BusinessException {
        DBAgent.deleteAll(relationList);
    }

    @Override
    public void deleteById(long id) throws BusinessException {
        String hql = "delete from CAPFormBusinessRelation f where f.id = ?";
        DBAgent.bulkUpdate((String)hql, (Object[])new Object[]{id});
    }

    @Override
    public void deleteBySourceFormId(long sourceFormId) throws BusinessException {
        String hql = "delete from CAPFormBusinessRelation f where f.sourceFormId = ?";
        DBAgent.bulkUpdate((String)hql, (Object[])new Object[]{sourceFormId});
    }

    @Override
    public List<CAPFormBusinessRelation> selectByFormIdAndType(long sourceFormId, String type) throws BusinessException {
        String hql = " from CAPFormBusinessRelation f where f.sourceFormId = :sourceFormId and f.type = :type";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFormId", sourceFormId);
        map.put("type", type);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public List<CAPFormBusinessRelation> selectByTargetFormId(Long targetFormId) throws BusinessException {
        String hql = " from CAPFormBusinessRelation f where f.targetFormId = :targetFormId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("targetFormId", targetFormId);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public List<CAPFormBusinessRelation> selectByTargetFormIdAndType(Long targetFormId, String type) throws BusinessException {
        String hql = " from CAPFormBusinessRelation f where f.targetFormId = :targetFormId and f.type = :type";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetFormId", targetFormId);
        map.put("type", type);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public int getRelationCount(Map<String, Object> param) throws BusinessException {
        StringBuilder sql = new StringBuilder(" from CAPFormBusinessRelation f where 1=1 ");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            sql.append(" and f.").append(entry.getKey()).append(" = :").append(entry.getValue());
        }
        return DBAgent.find((String)sql.toString(), param).size();
    }
}

