/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.businessRelation;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4BusinessRelation;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.util.FormRelationshipBeanSortComparatorByDate;
import com.seeyon.cap4.form.util.FormTriggerBeanSortComparatorByDate;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.utils.MagicHandleFormUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4FormBusinessRelationManagerImpl
implements CAP4FormBusinessRelationManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormBusinessRelationManagerImpl.class);
    private CAP4FormDesignManager cap4FormDesignManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private FormulaDAO formulaDAO;
    private ICAP4MagicManager cap4MagicManager;
    private CAP4FormManager cap4FormManager;

    @Override
    @AjaxAccess
    public boolean canSwitchRelationState(Long formId) throws BusinessException {
        return !this.cap4FormDesignManager.hasFormData(formId);
    }

    @Override
    @AjaxAccess
    public boolean validateRelationName(Long formId, String relationId, String relationName) {
        if (Strings.isBlank((String)relationName)) {
            return true;
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List relationshipIdList = formBean.getFormRelationshipIdList();
        if (relationshipIdList.size() > 0) {
            for (Long id : relationshipIdList) {
                FormRelationshipBean relationshipBean;
                if (id.toString().equals(relationId) || !(relationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(id)).getName().equals(relationName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @AjaxAccess
    public String saveBusinessRelation(Map<String, Object> infoMap) throws BusinessException {
        DataContainer dc = new DataContainer();
        FormRelationshipBean formRelationshipBean = new FormRelationshipBean();
        FormRelationshipBean oldRelationshipBean = null;
        boolean isNew = false;
        Long relationId = ParamUtil.getLong(infoMap, (String)"id", (Long)0L);
        if (relationId.equals(0L)) {
            relationId = UUIDLong.longUUID();
            isNew = true;
            formRelationshipBean.setCreateId(Long.valueOf(AppContext.currentUserId()));
            formRelationshipBean.setCreateTime(DateUtil.currentDate());
        } else {
            oldRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            formRelationshipBean.setCreateId(oldRelationshipBean.getCreateId());
            formRelationshipBean.setCreateTime(oldRelationshipBean.getCreateTime());
        }
        formRelationshipBean.setModifyTime(DateUtil.currentDate());
        formRelationshipBean.setId(relationId);
        String name = ParamUtil.getString(infoMap, (String)"name");
        formRelationshipBean.setName(name);
        int state = ParamUtil.getInt(infoMap, (String)"state");
        formRelationshipBean.setState(state);
        formRelationshipBean.setApplicationType(FormRelationEnums.relationApplicationType.between.getKey());
        int relationType = ParamUtil.getInt(infoMap, (String)"relationType");
        formRelationshipBean.setRelationType(relationType);
        Long sourceFormId = ParamUtil.getLong(infoMap, (String)"sourceFormId");
        formRelationshipBean.setSourceFormId(sourceFormId.longValue());
        Long targetFormId = ParamUtil.getLong(infoMap, (String)"targetFormId");
        formRelationshipBean.setTargetFormId(targetFormId.longValue());
        String targetTable = ParamUtil.getString(infoMap, (String)"targetTable");
        formRelationshipBean.setTargetTable(targetTable);
        Object mappingObj = infoMap.get("relationMapList");
        LinkedList<FormRelationshipMapBean> mappingBeanList = new LinkedList<FormRelationshipMapBean>();
        formRelationshipBean.setRelationMapList(mappingBeanList);
        FormRelationshipMapBean formRelationshipMapBean = null;
        List relationMapList = (List)mappingObj;
        FormBean sourceForm = this.cap4FormCacheManager.getForm(sourceFormId);
        ArrayList<CtpFormula> list = new ArrayList<CtpFormula>();
        for (Object temp : relationMapList) {
            Map oneMapping = (Map)temp;
            formRelationshipMapBean = new FormRelationshipMapBean();
            if (FormRelationEnums.ViewSelectType.user.getKey() == relationType) {
                String condition;
                String queryFieldList;
                Map sortMap;
                String sortInfo;
                formRelationshipMapBean.setSelectedField(String.valueOf(oneMapping.get("selectedField")));
                String selectorName = ParamUtil.getString((Map)oneMapping, (String)"selectorName", (String)"");
                if (Strings.isNotEmpty((String)selectorName)) {
                    formRelationshipMapBean.setSelectorName(selectorName);
                }
                formRelationshipMapBean.setFillInRow(ParamUtil.getInt((Map)oneMapping, (String)"fillInRow").intValue());
                if (1 == formRelationshipMapBean.getFillInRow()) {
                    formRelationshipMapBean.setButtonName(ParamUtil.getString((Map)oneMapping, (String)"buttonName"));
                    formRelationshipMapBean.setButtonLocation(ParamUtil.getString((Map)oneMapping, (String)"buttonLocation"));
                }
                formRelationshipMapBean.setEditFieldValue(ParamUtil.getInt((Map)oneMapping, (String)"editFieldValue").intValue());
                formRelationshipMapBean.setAutoFillRepeat(ParamUtil.getInt((Map)oneMapping, (String)"autoFillRepeat").intValue());
                int viewThrough = ParamUtil.getInt((Map)oneMapping, (String)"viewThrough");
                formRelationshipMapBean.setViewThrough(viewThrough);
                if (1 == viewThrough) {
                    String pcView = ParamUtil.getString((Map)oneMapping, (String)"pcView");
                    formRelationshipMapBean.setPcView(pcView);
                    String phoneView = ParamUtil.getString((Map)oneMapping, (String)"phoneView");
                    formRelationshipMapBean.setPhoneView(phoneView);
                }
                int listThrough = ParamUtil.getInt((Map)oneMapping, (String)"listThrough");
                formRelationshipMapBean.setListThrough(listThrough);
                if (1 == listThrough) {
                    String listPcView = ParamUtil.getString((Map)oneMapping, (String)"listPcView");
                    formRelationshipMapBean.setListPcView(listPcView);
                    String listPhoneView = ParamUtil.getString((Map)oneMapping, (String)"listPhoneView");
                    formRelationshipMapBean.setListPhoneView(listPhoneView);
                }
                List mapping = (List)oneMapping.get("mapping");
                LinkedList mappingList = new LinkedList();
                for (Object obj : mapping) {
                    HashMap finalMapping = new HashMap();
                    Map map = (Map)obj;
                    finalMapping.put(map.get("source"), map.get("target"));
                    mappingList.add(finalMapping);
                }
                formRelationshipMapBean.setRelationFieldMap(mappingList);
                String showList = ParamUtil.getString((Map)oneMapping, (String)"showFieldList");
                String showTextList = ParamUtil.getString((Map)oneMapping, (String)"showFieldListText");
                formRelationshipMapBean.setShowFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)showList, (String)showTextList));
                String sortFieldList = ParamUtil.getString((Map)oneMapping, (String)"sortFieldList");
                if (Strings.isNotBlank((String)sortFieldList) && Strings.isNotBlank((String)(sortInfo = (String)(sortMap = (Map)JSONUtil.parseJSONString((String)sortFieldList, Map.class)).get("sortInfo")))) {
                    String sortDisplay = sortMap.get("sortDisplay").toString();
                    formRelationshipMapBean.setSortFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.OrderBy.getKey(), (String)sortInfo, (String)sortDisplay));
                }
                if (Strings.isNotBlank((String)(queryFieldList = ParamUtil.getString((Map)oneMapping, (String)"queryFieldList")))) {
                    String queryFieldListText = ParamUtil.getString((Map)oneMapping, (String)"queryFieldListText");
                    formRelationshipMapBean.setQueryFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)queryFieldList, (String)queryFieldListText));
                }
                if (StringUtil.checkNull((String)(condition = String.valueOf(oneMapping.get("dataFilterCondition"))))) {
                    formRelationshipMapBean.setConditionFormulaId(0L);
                } else {
                    FormFormulaBean filterFormula = new FormFormulaBean(sourceForm);
                    filterFormula.setId(Long.valueOf(UUIDLong.longUUID()));
                    filterFormula.loadFromFormula(condition);
                    list.add(sourceForm.newCTPFormula4Save(filterFormula, 2));
                    formRelationshipMapBean.setConditionFormulaId(filterFormula.getFormulaId().longValue());
                }
            } else {
                String sortInfo;
                String controlTriggerList;
                String triggerRefreshOperation;
                formRelationshipMapBean.setShowUnmatchTip(ParamUtil.getInt((Map)oneMapping, (String)"showUnmatchTip", (int)0).intValue());
                formRelationshipMapBean.setWaitSentRefresh(ParamUtil.getInt((Map)oneMapping, (String)"waitSentRefresh", (int)0).intValue());
                String refreshOperation = ParamUtil.getString((Map)oneMapping, (String)"refreshOperation", (String)"");
                if (Strings.isNotBlank((String)refreshOperation)) {
                    String updateAuthView;
                    Map operationMap = (Map)JSONUtil.parseJSONString((String)refreshOperation);
                    String addAuthView = (String)operationMap.get("addAuthView");
                    if (Strings.isNotBlank((String)addAuthView)) {
                        formRelationshipMapBean.setRefreshOperationAdd(addAuthView);
                    }
                    if (Strings.isNotBlank((String)(updateAuthView = (String)operationMap.get("updateAuthView")))) {
                        formRelationshipMapBean.setRefreshOperationUpdate(updateAuthView);
                    }
                }
                if (Strings.isNotBlank((String)(triggerRefreshOperation = ParamUtil.getString((Map)oneMapping, (String)"triggerRefreshOperation", (String)"")))) {
                    String updateAuthView;
                    Map operationMap = (Map)JSONUtil.parseJSONString((String)triggerRefreshOperation);
                    String addAuthView = (String)operationMap.get("addAuthView");
                    if (Strings.isNotBlank((String)addAuthView)) {
                        formRelationshipMapBean.setTriggerOperationAdd(addAuthView);
                    }
                    if (Strings.isNotBlank((String)(updateAuthView = (String)operationMap.get("updateAuthView")))) {
                        formRelationshipMapBean.setTriggerOperationUpdate(updateAuthView);
                    }
                }
                if (Strings.isNotBlank((String)(controlTriggerList = ParamUtil.getString((Map)oneMapping, (String)"controlTriggerList", (String)"")))) {
                    String controlTriggerText = ParamUtil.getString((Map)oneMapping, (String)"controlTriggerText", (String)"");
                    formRelationshipMapBean.setControlTriggerSet(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)controlTriggerList, (String)controlTriggerText));
                }
                formRelationshipMapBean.setRefreshButton(ParamUtil.getInt((Map)oneMapping, (String)"refreshButton", (int)0).intValue());
                if (1 == formRelationshipMapBean.getRefreshButton()) {
                    formRelationshipMapBean.setButtonName(ParamUtil.getString((Map)oneMapping, (String)"buttonName"));
                    formRelationshipMapBean.setButtonLocation(ParamUtil.getString((Map)oneMapping, (String)"buttonLocation"));
                }
                if (Strings.isNotBlank((String)(sortInfo = ParamUtil.getString((Map)oneMapping, (String)"sortInfo", (String)"")))) {
                    String sortDisplay = ParamUtil.getString((Map)oneMapping, (String)"sortDisplay", (String)"");
                    formRelationshipMapBean.setSortFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.OrderBy.getKey(), (String)sortInfo, (String)sortDisplay));
                }
                List mapping = (List)oneMapping.get("mapping");
                LinkedList mappingList = new LinkedList();
                for (Object obj : mapping) {
                    HashMap finalMapping = new HashMap();
                    Map map = (Map)obj;
                    finalMapping.put(map.get("source"), map.get("target"));
                    mappingList.add(finalMapping);
                }
                formRelationshipMapBean.setRelationFieldMap(mappingList);
                String condition = ParamUtil.getString((Map)oneMapping, (String)"dataFilterCondition", (String)"");
                if (Strings.isBlank((String)condition)) {
                    formRelationshipMapBean.setConditionFormulaId(0L);
                } else {
                    FormFormulaBean formFormulaBean = new FormFormulaBean(sourceForm);
                    formFormulaBean.setId(Long.valueOf(UUIDLong.longUUID()));
                    formFormulaBean.loadFromFormula(condition);
                    list.add(sourceForm.newCTPFormula4Save(formFormulaBean, 2));
                    formRelationshipMapBean.setConditionFormulaId(formFormulaBean.getFormulaId().longValue());
                }
            }
            mappingBeanList.add(formRelationshipMapBean);
        }
        this.deleteCtpFormula(oldRelationshipBean);
        this.formulaDAO.insertList(list);
        if (!isNew) {
            this.cap4FormBusinessRelationDAO.deleteById(formRelationshipBean.getId());
        }
        this.cap4FormBusinessRelationDAO.save(formRelationshipBean.toCAPFormBusinessRelation());
        this.cap4FormCacheManager.removeFormBean(sourceFormId);
        this.cap4FormCacheManager.initForm(sourceFormId);
        dc.put("success", (Object)true);
        dc.put("result", (Object)formRelationshipBean);
        return dc.getJson();
    }

    private void deleteCtpFormula(FormRelationshipBean formRelationship) throws BusinessException {
        if (null == formRelationship) {
            return;
        }
        ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
        List relationshipMapList = formRelationship.getRelationMapList();
        for (FormRelationshipMapBean relationship : relationshipMapList) {
            CtpFormula ctpFormula;
            Long formulaId = relationship.getConditionFormulaId();
            if (formulaId == 0L || null == (ctpFormula = this.cap4FormCacheManager.getFormula(formulaId))) continue;
            ctpFormulas.add(ctpFormula);
        }
        this.formulaDAO.deleteList(ctpFormulas);
        DBAgent.evict(ctpFormulas);
    }

    @Override
    @AjaxAccess
    public String deleteBusinessRelation(Long relationId) throws BusinessException {
        if (!AppContext.hasPlugin((String)"cap_advance") && !AppContext.hasPlugin((String)"cap_base")) {
            throw new BusinessException(ResourceUtil.getString((String)"form.over.power.tips"));
        }
        FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
        if (formRelationshipBean == null) {
            return "";
        }
        this.deleteCtpFormula(formRelationshipBean);
        this.cap4FormBusinessRelationDAO.deleteById(relationId);
        this.cap4FormCacheManager.removeFormBean(formRelationshipBean.getSourceFormId());
        this.cap4FormCacheManager.initForm(formRelationshipBean.getSourceFormId());
        this.cap4MagicManager.deleteReflectionByShip(formRelationshipBean);
        return "";
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getBusinessRelationByFormId(Long sourceFormId, Long targetFormId) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<FormRelationshipBean> relationList = new ArrayList<FormRelationshipBean>();
        relationList.addAll(this.getFormRelationshipListByFormId(sourceFormId, targetFormId, FormRelationEnums.relationApplicationType.between.getKey()));
        relationList.addAll(this.getFormRelationshipListByFormId(targetFormId, sourceFormId, FormRelationEnums.relationApplicationType.between.getKey()));
        if (!Strings.isEmpty(relationList)) {
            Collections.sort(relationList, FormRelationshipBeanSortComparatorByDate.getInstance());
        }
        ArrayList<FormTriggerBean> triggerList = new ArrayList<FormTriggerBean>();
        triggerList.addAll(this.getFormTriggerListByFormId(sourceFormId, targetFormId));
        triggerList.addAll(this.getFormTriggerListByFormId(targetFormId, sourceFormId));
        if (!Strings.isEmpty(triggerList)) {
            Collections.sort(triggerList, FormTriggerBeanSortComparatorByDate.getInstance());
        }
        DataContainer relationDc = new DataContainer();
        relationDc.put("relationList", relationList);
        relationDc.put("triggerList", triggerList);
        resultMap.put("success", true);
        resultMap.put("relationship", relationDc.getJson());
        return resultMap;
    }

    @Override
    public List<FormRelationshipBean> getFormRelationshipListByFormId(Long sourceFormId, Long targetFormId, String applicationType) throws BusinessException {
        ArrayList<FormRelationshipBean> relationList = new ArrayList<FormRelationshipBean>();
        FormBean formBean = this.cap4FormCacheManager.getForm(sourceFormId);
        if (formBean != null && Strings.isNotEmpty((Collection)formBean.getFormRelationshipIdList())) {
            for (Long relationId : formBean.getFormRelationshipIdList()) {
                FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (relationBean == null || relationBean.getTargetFormId() != targetFormId.longValue() || !relationBean.getApplicationType().equals(applicationType)) continue;
                relationList.add(relationBean);
            }
        }
        return relationList;
    }

    @Override
    public List<FormTriggerBean> getFormTriggerListByFormId(Long sourceFormId, Long targetFormId) throws BusinessException {
        ArrayList<FormTriggerBean> triggerList = new ArrayList<FormTriggerBean>();
        FormBean formBean = this.cap4FormCacheManager.getForm(sourceFormId);
        if (formBean != null && Strings.isNotEmpty((Collection)formBean.getFormTriggerIdList())) {
            for (Long triggerId : formBean.getFormTriggerIdList()) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (triggerBean == null || triggerBean.getTargetFormId() != targetFormId.longValue()) continue;
                triggerList.add(triggerBean);
            }
        }
        return triggerList;
    }

    @Override
    public Map<String, Object> getRelationOrTriggerCountByFormId(Long sourceFormId, Map<String, Object> formIdMap) throws BusinessException {
        if (formIdMap == null || !formIdMap.containsKey("targetFormIdSet") || !formIdMap.containsKey("othersFormIdSet")) {
            return null;
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(sourceFormId);
        HashMap<String, Object> relationMap = new HashMap<String, Object>();
        int selfRelCount = 0;
        int selfSectionCount = 0;
        int forwardCount = 0;
        int bizMagicCubeCount = 0;
        if (formBean != null) {
            relationMap.put("sourceFormName", formBean.getFormName());
            relationMap.put("sourceFormId", sourceFormId);
            relationMap.put("sourceFormType", formBean.getFormType());
            ArrayList targetList = new ArrayList();
            Set targetFormIdSet = (Set)formIdMap.get("targetFormIdSet");
            Set othersFormIdSet = (Set)formIdMap.get("othersFormIdSet");
            for (Long targetFormId : targetFormIdSet) {
                FormBean reRelationFormBean;
                int ifTwoWay = 0;
                int relCount = 0;
                HashMap<String, Object> targetMap = new HashMap<String, Object>();
                if (!othersFormIdSet.contains(targetFormId)) {
                    if (Strings.isNotEmpty((Collection)formBean.getFormRelationshipIdList())) {
                        for (Long relationId : formBean.getFormRelationshipIdList()) {
                            FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                            if (relationBean == null || relationBean.getTargetFormId() != targetFormId.longValue()) continue;
                            if (FormRelationEnums.relationApplicationType.between.getKey().equals(relationBean.getApplicationType())) {
                                ++relCount;
                                ++forwardCount;
                                continue;
                            }
                            if (!FormRelationEnums.relationApplicationType.inner.getKey().equals(relationBean.getApplicationType())) continue;
                            ++selfRelCount;
                            if (FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(relationBean.getRelationObjType())) {
                                ++selfSectionCount;
                            }
                            if (!FormRelationEnums.RelationObjType.CREATE_DATA_SERVICE.getKey().equals(relationBean.getRelationObjType()) && !FormRelationEnums.RelationObjType.CALL_DATA_SERVICE.getKey().equals(relationBean.getRelationObjType())) continue;
                            ++bizMagicCubeCount;
                        }
                    }
                    if (Strings.isNotEmpty((Collection)formBean.getFormTriggerIdList())) {
                        for (Long triggerId : formBean.getFormTriggerIdList()) {
                            FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                            if (triggerBean == null || triggerBean.getTargetFormId() != targetFormId.longValue()) continue;
                            if (FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType())) {
                                ++relCount;
                                ++forwardCount;
                                continue;
                            }
                            ++selfRelCount;
                            if (FormTriggerBean.TriggerBusinessType.FormSelf.getKey().equals(triggerBean.getType())) {
                                ++selfSectionCount;
                            }
                            if (!FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) && !FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) continue;
                            ++bizMagicCubeCount;
                        }
                    }
                }
                if ((reRelationFormBean = this.cap4FormCacheManager.getForm(targetFormId)) != null) {
                    if (Strings.isNotEmpty((Collection)reRelationFormBean.getFormRelationshipIdList())) {
                        for (Long relationId : reRelationFormBean.getFormRelationshipIdList()) {
                            FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                            if (relationBean == null || relationBean.getTargetFormId() != sourceFormId.longValue() || !FormRelationEnums.relationApplicationType.between.getKey().equals(relationBean.getApplicationType())) continue;
                            ++relCount;
                            if (othersFormIdSet.contains(targetFormId)) {
                                ifTwoWay = 2;
                                continue;
                            }
                            ifTwoWay = 1;
                        }
                    }
                    if (Strings.isNotEmpty((Collection)reRelationFormBean.getFormTriggerIdList())) {
                        for (Long triggerId : reRelationFormBean.getFormTriggerIdList()) {
                            FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                            if (triggerBean == null || triggerBean.getTargetFormId() != sourceFormId.longValue() || !FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType())) continue;
                            ++relCount;
                            if (othersFormIdSet.contains(targetFormId)) {
                                ifTwoWay = 2;
                                continue;
                            }
                            ifTwoWay = 1;
                        }
                    }
                }
                targetMap.put("targetFormId", targetFormId);
                FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetFormId);
                if (targetFormBean == null || relCount <= 0) continue;
                targetMap.put("targetFormName", targetFormBean.getFormName());
                targetMap.put("targetFormType", targetFormBean.getFormType());
                targetMap.put("relCount", relCount);
                targetMap.put("ifTwoWay", ifTwoWay);
                targetList.add(targetMap);
            }
            relationMap.put("selfSectionCount", selfSectionCount);
            relationMap.put("selfRelCount", selfRelCount);
            relationMap.put("targetInfo", targetList);
            relationMap.put("forwardCount", forwardCount);
            relationMap.put("bizMagicCubeCount", bizMagicCubeCount);
            return relationMap;
        }
        return null;
    }

    @Override
    public List<FormRelationshipBean> selectTwoWayRelation(long formId) throws BusinessException {
        ArrayList<FormRelationshipBean> relationList = new ArrayList<FormRelationshipBean>();
        List<CAPFormBusinessRelation> allList = this.cap4FormBusinessRelationDAO.selectTwoWayRelation(formId);
        for (CAPFormBusinessRelation business : allList) {
            FormRelationshipBean relation;
            if (!Enums.FormBusinessRelationType.RELATION.getKey().equals(business.getType()) || (relation = this.cap4FormCacheManager.getFormRelationshipBean(business.getId())) == null || relationList.contains(relation)) continue;
            relationList.add(relation);
        }
        return relationList;
    }

    @Override
    public List<FormTriggerBean> selectTwoWayTrigger(long formId) throws BusinessException {
        ArrayList<FormTriggerBean> triggerList = new ArrayList<FormTriggerBean>();
        List<CAPFormBusinessRelation> allList = this.cap4FormBusinessRelationDAO.selectTwoWayRelation(formId);
        for (CAPFormBusinessRelation business : allList) {
            FormTriggerBean triggerBean;
            if (!Enums.FormBusinessRelationType.TRIGGER.getKey().equals(business.getType()) || (triggerBean = this.cap4FormCacheManager.getFormTriggerBean(business.getId())) == null || triggerList.contains(triggerBean)) continue;
            triggerList.add(triggerBean);
        }
        return triggerList;
    }

    @Override
    public List<FormRelationshipBean> getFormRelationshipBeanByTargetFormId(Long targetFormId) throws BusinessException {
        ArrayList<FormRelationshipBean> relationshipBeenList = new ArrayList<FormRelationshipBean>();
        List<CAPFormBusinessRelation> businessRelations = this.cap4FormBusinessRelationDAO.selectByTargetFormIdAndType(targetFormId, Enums.FormBusinessRelationType.RELATION.getKey());
        if (businessRelations != null) {
            FormRelationshipBean formRelationshipBean = null;
            for (CAPFormBusinessRelation temp : businessRelations) {
                formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(temp.getId());
                if (formRelationshipBean == null) continue;
                relationshipBeenList.add(formRelationshipBean);
            }
        }
        return relationshipBeenList;
    }

    @Override
    public List<FormTriggerBean> getFormTriggerBeanByTargetFormId(Long targetFormId) throws BusinessException {
        ArrayList<FormTriggerBean> formTriggerBeanList = new ArrayList<FormTriggerBean>();
        List<CAPFormBusinessRelation> businessRelations = this.cap4FormBusinessRelationDAO.selectByTargetFormIdAndType(targetFormId, Enums.FormBusinessRelationType.TRIGGER.getKey());
        if (businessRelations != null) {
            FormTriggerBean formTriggerBean = null;
            for (CAPFormBusinessRelation temp : businessRelations) {
                formTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(temp.getId());
                if (formTriggerBean == null) continue;
                formTriggerBeanList.add(formTriggerBean);
            }
        }
        return formTriggerBeanList;
    }

    @Override
    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean, FormRelationshipBean formRelationshipBean) throws BusinessException {
        HashMap<String, String> valueShareMap = new HashMap<String, String>();
        FormBean targetFormBean = businessDataBean.isUpgrade() ? businessDataBean.getAppUpgradeCacheBean().getForm(Long.valueOf(formRelationshipBean.getTargetFormId())) : this.cap4FormCacheManager.getForm(formRelationshipBean.getTargetFormId());
        FormBean sourceFormBean = businessDataBean.isUpgrade() ? businessDataBean.getAppUpgradeCacheBean().getForm(Long.valueOf(formRelationshipBean.getSourceFormId())) : this.cap4FormCacheManager.getForm(formRelationshipBean.getSourceFormId());
        valueShareMap.put("name", formRelationshipBean.getName());
        valueShareMap.put("sourceForm", sourceFormBean.getFormName());
        valueShareMap.put("targetForm", formRelationshipBean.getTargetFormId() == 0L || targetFormBean == null ? "" : targetFormBean.getFormName());
        valueShareMap.put("type", ResourceUtil.getString((String)"form.businesstype.type.relation"));
        valueShareMap.put("location", ResourceUtil.getString((String)"com.cap.import.app.relation.filter.condition.label"));
        boolean isMagic = false;
        if (FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType()) && !FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(formRelationshipBean.getRelationObjType())) {
            isMagic = true;
        }
        List relationMapList = formRelationshipBean.getRelationMapList();
        if (!isMagic) {
            for (FormRelationshipMapBean relationMapBean : relationMapList) {
                FormFormulaBean conditionFormula = relationMapBean.getConditionFormula();
                if (conditionFormula == null) continue;
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.putAll(valueShareMap);
                FormDesignUtil.redirectFormulaBean((Long)formRelationshipBean.getId(), (String)String.valueOf(relationMapBean.getConditionFormulaId()), (FormFormulaBean)conditionFormula, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4BusinessRelation.class, (FormBean)targetFormBean);
            }
        } else {
            for (FormRelationshipMapBean relationMapBean : relationMapList) {
                FormFormulaBean conditionFormula = relationMapBean.getConditionFormula();
                IMagicInterfaceDefineDao magicInterfaceDefineDao = (IMagicInterfaceDefineDao)AppContext.getBean((String)"magicInterfaceDefineDao");
                Map params = relationMapBean.getParams();
                String businessId = ParamUtil.getString((Map)params, (String)"businessId");
                String versionId = ParamUtil.getString((Map)params, (String)"versionId");
                String methodName = ParamUtil.getString((Map)params, (String)"methodName");
                if (conditionFormula == null) continue;
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.putAll(valueShareMap);
                MagicInterfaceDefineEntity entity = magicInterfaceDefineDao.getEntityFormCache(businessId, versionId, methodName);
                if (entity == null) continue;
                FormDesignUtil.redirectFormulaBean((Long)formRelationshipBean.getId(), (String)String.valueOf(relationMapBean.getConditionFormulaId()), (FormFormulaBean)conditionFormula, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4BusinessRelation.class, (MagicInterfaceDefineEntity)entity, (int)1);
            }
        }
    }

    @Override
    public void updateRedirectData(List<Map<String, Object>> redirectMap, FormRelationshipBean formRelationshipBean, List<FormBean> formBeanList) throws BusinessException {
        boolean isMagic = false;
        if (FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType()) && !FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(formRelationshipBean.getRelationObjType())) {
            isMagic = true;
        }
        List relationMapList = formRelationshipBean.getRelationMapList();
        if (!isMagic) {
            for (Map<String, Object> orgMap : redirectMap) {
                Long locationId = Long.valueOf(orgMap.get("location").toString());
                for (FormRelationshipMapBean relationMapBean : relationMapList) {
                    Long conditionFormulaId = relationMapBean.getConditionFormulaId();
                    if (conditionFormulaId.equals(0L) || !locationId.equals(conditionFormulaId)) continue;
                    FormFormulaBean conditionFormula = relationMapBean.getConditionFormula();
                    conditionFormula.updateFormula4BizRedirect(orgMap.get("oldValue").toString(), orgMap.get("newValue").toString(), formBeanList);
                }
            }
        } else {
            for (Map<String, Object> orgMap : redirectMap) {
                Long locationId = Long.valueOf(orgMap.get("location").toString());
                for (FormRelationshipMapBean relationMapBean : relationMapList) {
                    Long conditionFormulaId = relationMapBean.getConditionFormulaId();
                    if (conditionFormulaId.equals(0L) || !locationId.equals(conditionFormulaId)) continue;
                    IMagicInterfaceDefineDao magicInterfaceDefineDao = (IMagicInterfaceDefineDao)AppContext.getBean((String)"magicInterfaceDefineDao");
                    Map params = relationMapBean.getParams();
                    String businessId = ParamUtil.getString((Map)params, (String)"businessId");
                    String versionId = ParamUtil.getString((Map)params, (String)"versionId");
                    String methodName = ParamUtil.getString((Map)params, (String)"methodName");
                    MagicInterfaceDefineEntity entity = magicInterfaceDefineDao.getEntityFormCache(businessId, versionId, methodName);
                    MagicServiceDetail serviceDetail = MagicPrivateUtils.convert(entity);
                    FormFormulaBean conditionFormula = relationMapBean.getConditionFormula();
                    conditionFormula.updateFormula4BizRedirect(orgMap.get("oldValue").toString(), orgMap.get("newValue").toString(), serviceDetail, 1);
                }
            }
        }
    }

    @Override
    public Map<String, Object> filterRelationship4QueryBtn(Long formId, String tableName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList relations = new ArrayList();
        resultMap.put("relations", relations);
        try {
            FormBean formBean = this.cap4FormManager.getForm(formId, false);
            List relationIdList = formBean.getFormRelationshipIdList();
            for (Long relationId : relationIdList) {
                FormRelationshipBean relationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(relationshipBean.getTargetFormVersion()) || FormRelationEnums.ViewSelectType.system.getKey() != relationshipBean.getRelationType() || !relationshipBean.canUseInShowFormBtn(tableName)) continue;
                HashMap<String, Object> relationInfoMap = new HashMap<String, Object>();
                relationInfoMap.putAll(this.getRelationDetailInfoMap(relationshipBean));
                relations.add(relationInfoMap);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u83b7\u53d6\u672c\u4e1a\u52a1\u5305\u5185\u5173\u8054\u5173\u7cfb\u5f02\u5e38\uff01" + e.getMessage()), (Throwable)e);
        }
        return resultMap;
    }

    private Map<String, Object> getRelationDetailInfoMap(FormRelationshipBean relationshipBean) {
        HashMap<String, Object> detailInfoMap = new HashMap<String, Object>();
        if (relationshipBean != null) {
            detailInfoMap.put("relationId", String.valueOf(relationshipBean.getId()));
            detailInfoMap.put("relationName", relationshipBean.getName());
            Long targetFormId = relationshipBean.getTargetFormId();
            if ((targetFormId == null || targetFormId == 0L) && FormRelationEnums.relationApplicationType.inner.getKey().equals(relationshipBean.getApplicationType())) {
                FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)relationshipBean.relationMapList.get(0);
                String bid = ParamUtil.getString((Map)formRelationshipMapBean.getParams(), (String)"businessId", (String)"");
                String version = ParamUtil.getString((Map)formRelationshipMapBean.getParams(), (String)"versionId", (String)"");
                String methodName = ParamUtil.getString((Map)formRelationshipMapBean.getParams(), (String)"methodName", (String)"");
                targetFormId = MagicHandleFormUtils.getProviderFormId(bid, version, methodName);
            }
            FormBean currentFormBean = this.cap4FormCacheManager.getForm(relationshipBean.getSourceFormId());
            FormBean targetFormBean = this.cap4FormCacheManager.getForm(targetFormId);
            detailInfoMap.put("targetFormName", targetFormBean.getFormName());
            detailInfoMap.put("targetFormId", String.valueOf(targetFormId));
            ArrayList pcRights = new ArrayList();
            ArrayList mbRights = new ArrayList();
            List formViewBeanList = targetFormBean.getFormViewList();
            for (FormViewBean formViewBean : formViewBeanList) {
                List operations = formViewBean.getAllOperations();
                for (FormAuthViewBean formAuthViewBean : operations) {
                    if (formAuthViewBean.isDelete() || !Enums.FormAuthorizationType.show.getKey().equals(formAuthViewBean.getType())) continue;
                    HashMap<String, String> authInfoMap = new HashMap<String, String>();
                    authInfoMap.put("rightId", formViewBean.getId() + "." + formAuthViewBean.getId());
                    authInfoMap.put("rightName", formViewBean.getFormViewName() + "." + formAuthViewBean.getName());
                    if (Enums.ViewType.SeeyonForm.getText().equals(formViewBean.getFormViewType())) {
                        pcRights.add(authInfoMap);
                        continue;
                    }
                    mbRights.add(authInfoMap);
                }
            }
            Map conditionMap = ((FormRelationshipMapBean)relationshipBean.getRelationMapList().get(0)).getSystemRelationConditionMap();
            StringBuilder sb = new StringBuilder();
            sb.append(ResourceUtil.getString((String)"form.ctrl.showformdata.relationcondition"));
            sb.append("&#10;");
            sb.append(ResourceUtil.getString((String)"form.ctrl.showformdata.sourceform")).append(currentFormBean.getFormName()).append("      ").append(ResourceUtil.getString((String)"form.ctrl.showformdata.targetform")).append(targetFormBean.getFormName()).append("&#10;");
            String doubleNull = "  ";
            for (Map.Entry entry : conditionMap.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                sb.append(key).append(doubleNull).append("=").append(doubleNull).append(val).append(doubleNull).append("and &#10;");
            }
            detailInfoMap.put("title", sb.toString());
            detailInfoMap.put("pcRights", pcRights);
            detailInfoMap.put("mbRights", mbRights);
        }
        return detailInfoMap;
    }

    @Override
    public Map<String, Object> getSysRelationDetailInfoMap(String relationId) {
        FormRelationshipBean relationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(Long.parseLong(relationId));
        return this.getRelationDetailInfoMap(relationshipBean);
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

