/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.businessRelation;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormInnerBusinessManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormRelationshipBeanSortComparatorByDate;
import com.seeyon.cap4.form.util.FormTriggerBeanSortComparatorByDate;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.business.bind.IMagicBindServicesHandle;
import com.seeyon.cap4.magic.business.incision.ICAP4MagicIncisionManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.AttributeType;
import com.seeyon.cap4.magic.vo.IncisionResult;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormTableBean;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;

public class CAP4FormInnerBusinessManagerImpl
implements CAP4FormInnerBusinessManager {
    private CAP4FormDesignManager cap4FormDesignManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private FormulaDAO formulaDAO;
    private CAP4FormBusinessRelationManager cap4FormBusinessRelationManager;
    private ICAP4MagicIncisionManager cap4MagicIncisionManager;
    private IMagicBindServicesHandle magicBindServicesHandle;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormInnerBusinessManagerImpl.class);
    private CapBizConfigItemManager capBizConfigItemManager;
    public ICAP4MagicManager cap4MagicManager;
    private BusinessManager businessManager4;

    @Override
    @AjaxAccess
    public Map<String, Object> getFormSource4Relation(Map<String, Object> params) throws BusinessException {
        if (params == null) {
            return null;
        }
        long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String sourceType = ParamUtil.getString(params, (String)"sourceType", (String)"");
        MagicFormBean fb = this.getFormBean(formId, sourceType);
        if (fb == null) {
            return null;
        }
        String targetTable = "";
        int i = 0;
        for (MagicFormTableBean temp : fb.getTableList()) {
            if (i > 0) {
                targetTable = targetTable + ",";
            }
            targetTable = targetTable + temp.getTableName();
            ++i;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("allFieldBean", fb.getAllFieldBeans(1));
        result.put("formId", String.valueOf(fb.getId()));
        result.put("showSystem", !fb.isFlowForm());
        result.put("tableName", targetTable);
        result.put("uniqueList", fb.getUniqueFieldList());
        return result;
    }

    private MagicFormBean getFormBean(Long formId, String sourceType) {
        MagicFormBean result = null;
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(sourceType)) {
            result = new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3, formId);
        } else if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(sourceType)) {
            result = new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM, formId);
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getRelationConfigInfo(Map<String, Object> params) throws BusinessException {
        long relationId = ParamUtil.getLong(params, (String)"relationId", (Long)0L);
        FormRelationshipBean ship = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
        if (ship == null) {
            return null;
        }
        long targetFormId = ship.getTargetFormId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "1");
        result.put("targetSoureType", ship.getTargetFormVersion());
        HashMap<String, Object> targetInfo = new HashMap<String, Object>();
        result.put("name", ship.getName());
        ArrayList<String> mapShipBean = new ArrayList<String>();
        MagicEnums.ServiceOwnerType providerType = MagicEnums.ServiceOwnerType.getEnumByType((String)ship.getTargetFormVersion());
        if (providerType != null) {
            MagicFormBean fb = new MagicFormBean(providerType, targetFormId);
            if (fb.isNull()) {
                result.put("interface", "1");
                HashMap<String, MagicInterfaceDefineEntity> targetInterface = new HashMap<String, MagicInterfaceDefineEntity>();
                for (Object t : ship.getRelationMapList()) {
                    String point = "";
                    MagicEnums.BusinessMethodType st = null;
                    if (FormRelationEnums.ViewSelectType.user.getKey() == t.getRelationshipBean().getRelationType()) {
                        result.put("showSystem", false);
                        st = MagicEnums.BusinessMethodType.RELATION_USER;
                        point = t.getRelationshipBean().getId() + "_" + t.getSelectedField();
                    } else if (FormRelationEnums.ViewSelectType.auto_increase_row.getKey() == t.getRelationshipBean().getRelationType()) {
                        result.put("showSystem", false);
                        st = MagicEnums.BusinessMethodType.RELATION_USER;
                        point = t.getRelationshipBean().getId() + "_" + FormRelationEnums.ViewSelectType.auto_increase_row.name();
                    } else {
                        result.put("showSystem", true);
                        st = MagicEnums.BusinessMethodType.RELATION_SYS;
                        point = t.getRelationshipBean().getId() + "_" + t.getConditionFormulaId();
                    }
                    MagicInterfaceDefineEntity entity = this.cap4MagicManager.getServiceEntryByCallPoint(point, st);
                    Map<String, Object> dc = this.convertShipBean((FormRelationshipMapBean)t, entity);
                    if (entity != null) {
                        dc.put("targetId", String.valueOf(entity.getId()));
                        targetInterface.put(String.valueOf(entity.getId()), entity);
                    }
                    mapShipBean.add(JSONUtil.toJSONString(dc));
                }
                String relationT = ship.getRelationType() == FormRelationEnums.ViewSelectType.system.getKey() ? MagicEnums.BusinessMethodType.RELATION_SYS.getName() : MagicEnums.BusinessMethodType.RELATION_USER.getName();
                for (MagicInterfaceDefineEntity entity : targetInterface.values()) {
                    MagicServiceDetail detail = MagicPrivateUtils.convert(entity, relationT);
                    targetInfo.put(detail.getId(), detail);
                }
                result.put("targetInfo", targetInfo);
            } else {
                result.put("interface", "0");
                targetInfo.put("targetFormId", String.valueOf(targetFormId));
                CapBizConfigItem item = this.capBizConfigItemManager.findBizInfoByFormId(targetFormId);
                if (item != null) {
                    BizConfigBean bean = this.businessManager4.findBizConfigById(item.getBizId());
                    targetInfo.put("name", fb.getFormName() + "(" + bean.getName() + ")");
                } else {
                    targetInfo.put("name", fb.getFormName());
                }
                targetInfo.put("allFieldBean", fb.getAllFieldBeans(1));
                targetInfo.put("uniqueList", fb.getUniqueFieldList());
                result.put("showSystem", !fb.isFlowForm());
                result.put("targetInfo", targetInfo);
                String targetTable = "";
                int i = 0;
                for (MagicFormTableBean temp : fb.getTableList()) {
                    if (i > 0) {
                        targetTable = targetTable + ",";
                    }
                    targetTable = targetTable + temp.getTableName();
                    ++i;
                }
                targetInfo.put("tableName", targetTable);
                for (FormRelationshipMapBean t : ship.getRelationMapList()) {
                    mapShipBean.add(t.toJSON());
                }
            }
        }
        result.put("shipList", mapShipBean);
        result.put("relationType", ship.getRelationType());
        result.put("state", ship.getState());
        result.put("relationObjType", ship.getRelationObjType());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> convertShipBean(FormRelationshipMapBean ship, MagicInterfaceDefineEntity entity) {
        Map dc = ship.toJsonObject(null);
        dc.put("outServiceParams", ship.getParams("outServiceParams"));
        ArrayList<DataContainer> dcList = new ArrayList<DataContainer>();
        for (Map map : ship.getRelationFieldMap()) {
            DataContainer relationDc = new DataContainer();
            for (Map.Entry entry : map.entrySet()) {
                relationDc.put((String)entry.getKey(), entry.getValue());
            }
            dcList.add(relationDc);
        }
        String relationT = ship.getRelationshipBean().getRelationType() == FormRelationEnums.ViewSelectType.system.getKey() ? MagicEnums.BusinessMethodType.RELATION_SYS.getName() : MagicEnums.BusinessMethodType.RELATION_USER.getName();
        MagicServiceDetail serviceDetail = MagicPrivateUtils.convert(entity, relationT);
        HashMap<String, AttributeType> attributeTypeMap = new HashMap<String, AttributeType>();
        if (serviceDetail.getResultConfig() != null) {
            for (AttributeType at : serviceDetail.getResultConfig().getAttrs()) {
                attributeTypeMap.put(at.getName(), at);
            }
        }
        dc.put("showUnmatchTip", ship.getShowUnmatchTip());
        dc.put("relationFieldList", dcList);
        if (Strings.isEmpty((Collection)ship.getShowFieldList())) {
            dc.put("showFieldList", "");
        } else {
            void var9_13;
            String string = "";
            String showFieldListText = "";
            int i = 0;
            for (SimpleObjectBean field : ship.getShowFieldList()) {
                void var9_15;
                if (i > 0) {
                    String string2 = (String)var9_13 + ",";
                    showFieldListText = showFieldListText + ",";
                }
                String string3 = (String)var9_15 + field.getName();
                if (attributeTypeMap.containsKey(field.getName())) {
                    showFieldListText = showFieldListText + ((AttributeType)attributeTypeMap.get(field.getName())).getDisplayName();
                    if (Strings.isNotBlank((String)field.getValue()) && field.getValue().contains("(") && field.getValue().contains(")")) {
                        int start = field.getValue().lastIndexOf("(");
                        int end = field.getValue().lastIndexOf(")");
                        showFieldListText = showFieldListText + field.getValue().substring(start, end) + ")";
                    }
                } else {
                    showFieldListText = showFieldListText + field.getValue();
                }
                ++i;
            }
            dc.put("showFieldList", var9_13);
            dc.put("showFieldListText", showFieldListText);
        }
        CAP4FormCacheManager cAP4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        FormBean sourceForm = cAP4FormCacheManager.getForm(ship.getRelationshipBean().getSourceFormId());
        FormFormulaBean formulab = null;
        if (ship.getRelationshipBean().getRelationType() == 1) {
            if (Strings.isEmpty((Collection)ship.getQueryFieldList())) {
                dc.put("queryFieldList", "");
            } else {
                List conditionSet;
                LinkedList<Object> conditions = new LinkedList<Object>();
                if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(entity.getSubType()) || MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(entity.getSubType())) {
                    conditions.addAll(attributeTypeMap.keySet());
                } else if (serviceDetail.getArgsMapper() != null && (conditionSet = (List)serviceDetail.getArgsMapper().get("condition")) != null) {
                    for (AttributeType a : conditionSet) {
                        conditions.add(a.getName());
                    }
                }
                String queryFieldListStr = "";
                String queryFieldListText = "";
                int i = 0;
                for (SimpleObjectBean field : ship.getQueryFieldList()) {
                    if (!conditions.contains(field.getName())) continue;
                    if (i > 0) {
                        queryFieldListStr = queryFieldListStr + ",";
                        queryFieldListText = queryFieldListText + ",";
                    }
                    queryFieldListStr = queryFieldListStr + field.getName();
                    queryFieldListText = queryFieldListText + field.getValue();
                    ++i;
                }
                dc.put("queryFieldList", queryFieldListStr);
                dc.put("queryFieldListText", queryFieldListText);
            }
            if (0L != ship.getConditionFormulaId()) {
                try {
                    formulab = cAP4FormCacheManager.loadFormFormulaBean(sourceForm, ship.getConditionFormulaId());
                }
                catch (BusinessException e) {
                    LOGGER.info((Object)("\u83b7\u53d6\u6761\u4ef6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                }
                if (formulab != null) {
                    dc.put("dataFilterCondition", formulab.getFormulaForDisplay(MagicPrivateUtils.convert(entity), 1));
                }
            }
        } else if (0L != ship.getConditionFormulaId()) {
            try {
                formulab = cAP4FormCacheManager.loadFormFormulaBean(sourceForm, ship.getConditionFormulaId());
            }
            catch (BusinessException e) {
                LOGGER.info((Object)("\u83b7\u53d6\u6761\u4ef6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            }
            if (formulab != null) {
                if (FormRelationEnums.ViewSelectType.system.getKey() == ship.getRelationshipBean().getRelationType()) {
                    String sysJson = FormUtil.getConditionJson((String)formulab.getFormulaForDisplay());
                    List sysRelationFieldMap = (List)JSONUtil.parseJSONString((String)sysJson);
                    ArrayList<DataContainer> sysRelation = new ArrayList<DataContainer>();
                    for (Map map : sysRelationFieldMap) {
                        DataContainer sysRelationDc = new DataContainer();
                        for (Map.Entry entry : map.entrySet()) {
                            sysRelationDc.put((String)entry.getKey(), entry.getValue());
                        }
                        sysRelation.add(sysRelationDc);
                    }
                    dc.put("sysRelationFieldMap", sysRelation);
                } else {
                    dc.put("dataFilterCondition", formulab.getFormulaForDisplay(MagicPrivateUtils.convert(entity), 1));
                }
            }
        }
        if (ship.getSortFieldList() != null) {
            DataContainer sortMap = new DataContainer();
            LinkedList tempList = new LinkedList();
            CAP4FormInnerBusinessManagerImpl.setMapList4SimpleObject("sortInfo", "sortDisplay", ship.getSortFieldList(), (Map<String, Object>)sortMap, attributeTypeMap);
            dc.put("sortFieldList", sortMap);
        }
        ArrayList<DataContainer> interflowConditionMaps = new ArrayList<DataContainer>();
        DataContainer interflowCondtionItem = null;
        if (ship.getInterflowConditionMapList() != null) {
            for (Map map : ship.getInterflowConditionMapList()) {
                interflowCondtionItem = new DataContainer();
                interflowCondtionItem.putAll(map);
                interflowConditionMaps.add(interflowCondtionItem);
            }
        }
        if (Strings.isEmpty((Collection)ship.getControlTriggerSet())) {
            dc.put("controlTriggerSet", "");
        } else {
            String controlTriggerList = "";
            String controlTriggerText = "";
            int i = 0;
            for (SimpleObjectBean field : ship.getControlTriggerSet()) {
                if (i > 0) {
                    controlTriggerList = controlTriggerList + ",";
                    controlTriggerText = controlTriggerText + ",";
                }
                controlTriggerList = controlTriggerList + field.getName();
                controlTriggerText = controlTriggerText + field.getValue();
                ++i;
            }
            dc.put("controlTriggerList", controlTriggerList);
            dc.put("controlTriggerText", controlTriggerText);
        }
        dc.put("interflowConditionMapList", interflowConditionMaps);
        return dc;
    }

    public static void setMapList4SimpleObject(String name, String value, List<SimpleObjectBean> list, Map<String, Object> map, Map<String, AttributeType> attributeTypeMap) {
        StringBuilder names = new StringBuilder("");
        StringBuilder values = new StringBuilder("");
        boolean isOrderBy = "orderByNameList".equals(name) || "oldOrderByNameList".equals(name) || "sortInfo".equals(name);
        for (int i = 0; i < list.size(); ++i) {
            StringBuilder temp = new StringBuilder("");
            SimpleObjectBean o = list.get(i);
            String s = i == list.size() - 1 ? "" : ",";
            String n = o.getName();
            names.append(n).append(s);
            String v = o.getValue();
            String fieldName = n.substring(n.indexOf(".") + 1);
            String realDisplay = null;
            AttributeType at = attributeTypeMap.get(fieldName);
            realDisplay = at != null ? at.getDisplayName() : FormulaEnums.SystemDataField.getEnumByKey((String)n).getText();
            temp.append(realDisplay);
            if (v.contains("(") && v.contains(")") && v.indexOf("(") < v.indexOf(")")) {
                temp.append(v.substring(v.indexOf("("), v.indexOf(")") + 1));
            }
            if (isOrderBy) {
                SimpleObjectBean.OrderByValue order = SimpleObjectBean.OrderByValue.getEnumByKey((String)v);
                temp.append(order.getSymbol());
            }
            v = temp.toString();
            values.append(v).append(s);
        }
        map.put(name, names.toString());
        map.put(value, values.toString());
    }

    private String handleSaveInnerRelation(Map<String, Object> infoMap, boolean isService) throws BusinessException {
        HashMap<String, Serializable> dc = new HashMap<String, Serializable>();
        FormRelationshipBean formRelationshipBean = new FormRelationshipBean();
        boolean isNew = false;
        Long relationId = ParamUtil.getLong(infoMap, (String)"id", (Long)0L);
        FormRelationshipBean oldRelationshipBean = null;
        if (relationId.equals(0L)) {
            relationId = UUIDLong.longUUID();
            isNew = true;
            formRelationshipBean.setCreateId(Long.valueOf(AppContext.currentUserId()));
            formRelationshipBean.setCreateTime(DateUtil.currentDate());
            formRelationshipBean.setModifyTime(DateUtil.currentDate());
        } else {
            oldRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            formRelationshipBean.setCreateId(oldRelationshipBean.getCreateId());
            formRelationshipBean.setCreateTime(oldRelationshipBean.getCreateTime());
            formRelationshipBean.setModifyTime(DateUtil.currentDate());
        }
        formRelationshipBean.setId(relationId);
        String name = ParamUtil.getString(infoMap, (String)"name");
        formRelationshipBean.setName(name);
        int state = ParamUtil.getInt(infoMap, (String)"state");
        formRelationshipBean.setState(state);
        formRelationshipBean.setApplicationType(FormRelationEnums.relationApplicationType.inner.getKey());
        String relationObjType = ParamUtil.getString(infoMap, (String)"targetType");
        boolean isAutoCollect = false;
        if (FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(relationObjType)) {
            isAutoCollect = true;
        }
        formRelationshipBean.setRelationObjType(relationObjType);
        int relationType = ParamUtil.getInt(infoMap, (String)"relationType");
        formRelationshipBean.setRelationType(relationType);
        Long sourceFormId = ParamUtil.getLong(infoMap, (String)"sourceFormId");
        formRelationshipBean.setSourceFormId(sourceFormId.longValue());
        Long targetFormId = ParamUtil.getLong(infoMap, (String)"targetId", (Long)0L);
        formRelationshipBean.setTargetFormId(targetFormId.longValue());
        String targetTable = ParamUtil.getString(infoMap, (String)"targetTable");
        formRelationshipBean.setTargetTable(targetTable);
        Object mappingObj = infoMap.get("relationMapList");
        LinkedList<FormRelationshipMapBean> mappingBeanList = new LinkedList<FormRelationshipMapBean>();
        formRelationshipBean.setRelationMapList(mappingBeanList);
        FormRelationshipMapBean formRelationshipMapBean = null;
        List relationMapList = (List)mappingObj;
        FormBean sourceForm = this.cap4FormCacheManager.getForm(sourceFormId);
        ArrayList<CtpFormula> list = new ArrayList<CtpFormula>();
        for (Object temp : relationMapList) {
            Object sortInfo;
            Map oneMapping = (Map)temp;
            formRelationshipMapBean = new FormRelationshipMapBean();
            if (!isAutoCollect) {
                formRelationshipMapBean.getParams().put("targetType", ParamUtil.getString(infoMap, (String)"targetType"));
            }
            if (FormRelationEnums.ViewSelectType.user.getKey() == relationType) {
                Map sortMap;
                formRelationshipMapBean.setSelectedField(String.valueOf(oneMapping.get("selectedField")));
                String selectorName = ParamUtil.getString((Map)oneMapping, (String)"selectorName", (String)"");
                if (Strings.isNotEmpty((String)selectorName)) {
                    formRelationshipMapBean.setSelectorName(selectorName);
                }
                formRelationshipMapBean.setFillInRow(ParamUtil.getInt((Map)oneMapping, (String)"fillInRow").intValue());
                formRelationshipMapBean.setButtonName(ParamUtil.getString((Map)oneMapping, (String)"buttonName"));
                formRelationshipMapBean.setButtonLocation(ParamUtil.getString((Map)oneMapping, (String)"buttonLocation"));
                formRelationshipMapBean.setEditFieldValue(ParamUtil.getInt((Map)oneMapping, (String)"editFieldValue").intValue());
                formRelationshipMapBean.setAutoFillRepeat(ParamUtil.getInt((Map)oneMapping, (String)"autoFillRepeat").intValue());
                int viewThrough = ParamUtil.getInt((Map)oneMapping, (String)"viewThrough");
                formRelationshipMapBean.setViewThrough(viewThrough);
                if (1 == viewThrough) {
                    String pcView = ParamUtil.getString((Map)oneMapping, (String)"pcView");
                    formRelationshipMapBean.setPcView(pcView);
                    String phoneView = ParamUtil.getString((Map)oneMapping, (String)"phoneView");
                    formRelationshipMapBean.setPhoneView(phoneView);
                }
                int listThrough = ParamUtil.getInt((Map)oneMapping, (String)"listThrough");
                formRelationshipMapBean.setListThrough(listThrough);
                if (1 == listThrough) {
                    String listPcView = ParamUtil.getString((Map)oneMapping, (String)"listPcView");
                    formRelationshipMapBean.setListPcView(listPcView);
                    String listPhoneView = ParamUtil.getString((Map)oneMapping, (String)"listPhoneView");
                    formRelationshipMapBean.setListPhoneView(listPhoneView);
                }
                List mapping = (List)oneMapping.get("mapping");
                LinkedList mappingList = new LinkedList();
                for (Map.Entry<Long, Object> obj : mapping) {
                    HashMap finalMapping = new HashMap();
                    Map map = (Map)((Object)obj);
                    finalMapping.put(map.get("source"), map.get("target"));
                    mappingList.add(finalMapping);
                }
                formRelationshipMapBean.setRelationFieldMap(mappingList);
                String showList = ParamUtil.getString((Map)oneMapping, (String)"showFieldList");
                String showTextList = ParamUtil.getString((Map)oneMapping, (String)"showFieldListText");
                formRelationshipMapBean.setShowFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)showList, (String)showTextList));
                String sortFieldList = ParamUtil.getString((Map)oneMapping, (String)"sortFieldList");
                if (Strings.isNotBlank((String)sortFieldList) && (sortMap = (Map)JSONUtil.parseJSONString((String)sortFieldList, Map.class)) != null) {
                    String sortInfo2 = (String)sortMap.get("sortInfo");
                    String sortDisplay = (String)sortMap.get("sortDisplay");
                    formRelationshipMapBean.setSortFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.OrderBy.getKey(), (String)sortInfo2, (String)sortDisplay));
                }
                String queryFieldList = ParamUtil.getString((Map)oneMapping, (String)"queryFieldList");
                String queryFieldListText = ParamUtil.getString((Map)oneMapping, (String)"queryFieldListText");
                formRelationshipMapBean.setQueryFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)queryFieldList, (String)queryFieldListText));
                String condition = String.valueOf(oneMapping.get("dataFilterCondition"));
                if (StringUtil.checkNull((String)condition)) {
                    formRelationshipMapBean.setConditionFormulaId(0L);
                    if (oneMapping.containsKey("interflowConditionMapList")) {
                        List interflowConditionMapList = (List)oneMapping.get("interflowConditionMapList");
                        formRelationshipMapBean.setInterflowConditionMapList(interflowConditionMapList);
                    }
                } else if (isService) {
                    long targetId = ParamUtil.getLong((Map)oneMapping, (String)"targetId", (Long)0L);
                    MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(targetId);
                    FormFormulaBean filterFormula = MagicPrivateUtils.convertFormula4Magic(condition, sourceForm, MagicPrivateUtils.convert(entity), 1);
                    list.add(sourceForm.newCTPFormula4Save(filterFormula, 2));
                    formRelationshipMapBean.setConditionFormulaId(filterFormula.getFormulaId().longValue());
                } else {
                    FormFormulaBean filterFormula = new FormFormulaBean(sourceForm);
                    filterFormula.setId(Long.valueOf(UUIDLong.longUUID()));
                    filterFormula.loadFromFormula(condition);
                    list.add(sourceForm.newCTPFormula4Save(filterFormula, 2));
                    formRelationshipMapBean.setConditionFormulaId(filterFormula.getFormulaId().longValue());
                    formRelationshipMapBean.setConditionFormula(filterFormula);
                }
            } else if (FormRelationEnums.ViewSelectType.auto_collect.getKey() == relationType) {
                this.packageCollectMapping(formRelationshipMapBean, oneMapping, sourceForm, list);
            } else {
                String controlTriggerList;
                String triggerRefreshOperation;
                formRelationshipMapBean.setShowUnmatchTip(ParamUtil.getInt((Map)oneMapping, (String)"showUnmatchTip", (int)0).intValue());
                formRelationshipMapBean.setWaitSentRefresh(ParamUtil.getInt((Map)oneMapping, (String)"waitSentRefresh", (int)0).intValue());
                String refreshOperation = ParamUtil.getString((Map)oneMapping, (String)"refreshOperation", (String)"");
                if (Strings.isNotBlank((String)refreshOperation)) {
                    String updateAuthView;
                    Map operationMap = (Map)JSONUtil.parseJSONString((String)refreshOperation);
                    String addAuthView = (String)operationMap.get("addAuthView");
                    if (Strings.isNotBlank((String)addAuthView)) {
                        formRelationshipMapBean.setRefreshOperationAdd(addAuthView);
                    }
                    if (Strings.isNotBlank((String)(updateAuthView = (String)operationMap.get("updateAuthView")))) {
                        formRelationshipMapBean.setRefreshOperationUpdate(updateAuthView);
                    }
                }
                if (Strings.isNotBlank((String)(triggerRefreshOperation = ParamUtil.getString((Map)oneMapping, (String)"triggerRefreshOperation", (String)"")))) {
                    String updateAuthView;
                    Map operationMap = (Map)JSONUtil.parseJSONString((String)triggerRefreshOperation);
                    String addAuthView = (String)operationMap.get("addAuthView");
                    if (Strings.isNotBlank((String)addAuthView)) {
                        formRelationshipMapBean.setTriggerOperationAdd(addAuthView);
                    }
                    if (Strings.isNotBlank((String)(updateAuthView = (String)operationMap.get("updateAuthView")))) {
                        formRelationshipMapBean.setTriggerOperationUpdate(updateAuthView);
                    }
                }
                if (Strings.isNotBlank((String)(controlTriggerList = ParamUtil.getString((Map)oneMapping, (String)"controlTriggerList", (String)"")))) {
                    String controlTriggerText = ParamUtil.getString((Map)oneMapping, (String)"controlTriggerText", (String)"");
                    formRelationshipMapBean.setControlTriggerSet(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.ShowField.getKey(), (String)controlTriggerList, (String)controlTriggerText));
                }
                formRelationshipMapBean.setRefreshButton(ParamUtil.getInt((Map)oneMapping, (String)"refreshButton", (int)0).intValue());
                if (1 == formRelationshipMapBean.getRefreshButton()) {
                    formRelationshipMapBean.setButtonName(ParamUtil.getString((Map)oneMapping, (String)"buttonName"));
                    formRelationshipMapBean.setButtonLocation(ParamUtil.getString((Map)oneMapping, (String)"buttonLocation"));
                }
                if (Strings.isNotBlank((String)(sortInfo = ParamUtil.getString((Map)oneMapping, (String)"sortInfo", (String)"")))) {
                    String sortDisplay = ParamUtil.getString((Map)oneMapping, (String)"sortDisplay", (String)"");
                    formRelationshipMapBean.setSortFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.OrderBy.getKey(), (String)sortInfo, (String)sortDisplay));
                }
                List mapping = (List)oneMapping.get("mapping");
                LinkedList mappingList = new LinkedList();
                for (Object obj : mapping) {
                    HashMap finalMapping = new HashMap();
                    Map map = (Map)obj;
                    finalMapping.put(map.get("source"), map.get("target"));
                    mappingList.add(finalMapping);
                }
                formRelationshipMapBean.setRelationFieldMap(mappingList);
                formRelationshipMapBean.setId(Long.valueOf(UUID.randomUUID().getLeastSignificantBits()));
                String condition = String.valueOf(oneMapping.get("dataFilterCondition"));
                if (Strings.isBlank((String)condition)) {
                    formRelationshipMapBean.setConditionFormulaId(0L);
                } else if (isService) {
                    long targetId = ParamUtil.getLong((Map)oneMapping, (String)"targetId", (Long)0L);
                    MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(targetId);
                    FormFormulaBean filterFormula = MagicPrivateUtils.convertFormula4Magic(condition, sourceForm, MagicPrivateUtils.convert(entity), 1);
                    list.add(sourceForm.newCTPFormula4Save(filterFormula, 2));
                    formRelationshipMapBean.setConditionFormulaId(filterFormula.getFormulaId().longValue());
                    formRelationshipMapBean.setConditionFormula(filterFormula);
                } else {
                    FormFormulaBean filterFormula = new FormFormulaBean(sourceForm);
                    filterFormula.setId(Long.valueOf(UUIDLong.longUUID()));
                    filterFormula.loadFromFormula(condition);
                    list.add(sourceForm.newCTPFormula4Save(filterFormula, 2));
                    formRelationshipMapBean.setConditionFormulaId(filterFormula.getFormulaId().longValue());
                    formRelationshipMapBean.setConditionFormula(filterFormula);
                }
            }
            String paramsStr = ParamUtil.getString((Map)oneMapping, (String)"paramsArray", null);
            if (paramsStr != null) {
                List paramsArray = (List)JSONUtil.parseJSONString((String)paramsStr, List.class);
                ArrayList<SimpleObjectBean> params = new ArrayList<SimpleObjectBean>();
                sortInfo = paramsArray.iterator();
                while (sortInfo.hasNext()) {
                    Object item = sortInfo.next();
                    Map itemObj = (Map)JSONUtil.parseJSONString((String)item.toString(), Map.class);
                    SimpleObjectBean sob = new SimpleObjectBean();
                    String attrMapping = ParamUtil.getString((Map)itemObj, (String)"attrMapping", (String)"");
                    String attrConfigDisplay = ParamUtil.getString((Map)itemObj, (String)"attrConfigDisplay", (String)"");
                    String attrName = ParamUtil.getString((Map)itemObj, (String)"attrName", (String)"");
                    String attrConfigType = ParamUtil.getString((Map)itemObj, (String)"attrConfigType", (String)"");
                    sob.setName(attrName);
                    sob.setValue(attrMapping);
                    sob.setType(attrConfigType);
                    sob.setDisplay(attrConfigDisplay);
                    params.add(sob);
                }
                formRelationshipMapBean.putParams("outServiceParams", params);
            }
            if (isService) {
                long targetId = ParamUtil.getLong((Map)oneMapping, (String)"targetId", (Long)0L);
                MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(targetId);
                formRelationshipMapBean.putParams("businessId", (Object)entity.getBusinessId());
                formRelationshipMapBean.putParams("versionId", (Object)entity.getVersionId());
                formRelationshipMapBean.putParams("methodName", (Object)entity.getMethodName());
            }
            mappingBeanList.add(formRelationshipMapBean);
        }
        this.deleteCtpFormula(relationId);
        this.formulaDAO.insertList(list);
        if (!isNew) {
            this.cap4FormBusinessRelationDAO.deleteById(formRelationshipBean.getId());
        }
        if (isService) {
            formRelationshipBean.setTargetFormId(0L);
        }
        if (!isAutoCollect && !isService) {
            String targetSourceType = ParamUtil.getString(infoMap, (String)"targetSourceType");
            MagicEnums.ServiceOwnerType providerType = null;
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(targetSourceType)) {
                providerType = MagicEnums.ServiceOwnerType.DEFAULT_FORM;
            } else if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(targetSourceType)) {
                providerType = MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3;
            }
            ICAP4MagicIncisionManager magicIncisionManager = MagicPrivateUtils.getMagicIncisionManager(providerType);
            if (magicIncisionManager != null) {
                formRelationshipBean.setTargetFormVersion(targetSourceType);
                this.magicReflectionRelationDao.deleteByActionOrShipId(String.valueOf(formRelationshipBean.getId()));
                HashMap<Long, MagicReflectionRelationPO> allRefletionRelations = new HashMap<Long, MagicReflectionRelationPO>();
                for (FormRelationshipMapBean shipMapBean : formRelationshipBean.getRelationMapList()) {
                    IncisionResult incisionResult = magicIncisionManager.relationIncision(formRelationshipBean, shipMapBean, true);
                    Set<Long> existesInterface = incisionResult.getExistsInterfaces();
                    Map<Long, MagicInterfaceDefineEntity> interfaces = incisionResult.getInterfaces();
                    allRefletionRelations.putAll(incisionResult.getReflections());
                    for (Map.Entry<Long, MagicInterfaceDefineEntity> entry : interfaces.entrySet()) {
                        MagicInterfaceDefineEntity e = entry.getValue();
                        shipMapBean.putParams("businessId", (Object)e.getBusinessId());
                        shipMapBean.putParams("versionId", (Object)e.getVersionId());
                        shipMapBean.putParams("methodName", (Object)e.getMethodName());
                    }
                }
                if (!allRefletionRelations.isEmpty()) {
                    this.magicReflectionRelationDao.saveAll(new ArrayList<MagicReflectionRelationPO>(allRefletionRelations.values()));
                }
            }
        } else if (isService) {
            this.magicBindServicesHandle.handleRealtionShip(formRelationshipBean, true);
        }
        this.cap4FormBusinessRelationDAO.save(formRelationshipBean.toCAPFormBusinessRelation());
        this.cap4FormCacheManager.removeFormBean(sourceFormId);
        this.cap4FormCacheManager.initForm(sourceFormId);
        dc.put("success", Boolean.valueOf(true));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("id", String.valueOf(formRelationshipBean.getId()));
        result.put("name", formRelationshipBean.getName());
        result.put("type", "relation");
        dc.put("result", result);
        return JSONUtil.toJSONString(dc);
    }

    private void packageCollectMapping(FormRelationshipMapBean formRelationshipMapBean, Map<String, Object> oneMapping, FormBean formBean, List<CtpFormula> formulaList) {
        int refreshButton;
        formRelationshipMapBean.setAutoCollectType(FormRelationEnums.AutoCollectType.CURRENT.getKey());
        String fromTable = ParamUtil.getString(oneMapping, (String)"fromTable");
        String toTable = ParamUtil.getString(oneMapping, (String)"toTable");
        HashMap<String, String> collectMapping = new HashMap<String, String>(1);
        collectMapping.put(fromTable, toTable);
        formRelationshipMapBean.setCollectMapping(collectMapping);
        formRelationshipMapBean.setButtonLocation(toTable);
        String sortInfo = ParamUtil.getString(oneMapping, (String)"sortInfo", (String)"");
        if (Strings.isNotBlank((String)sortInfo)) {
            String sortDisplay = ParamUtil.getString(oneMapping, (String)"sortDisplay", (String)"");
            formRelationshipMapBean.setSortFieldList(FormUtil.getSimpleObjectList((String)SimpleObjectBean.ColumnType.OrderBy.getKey(), (String)sortInfo, (String)sortDisplay));
        }
        if ((refreshButton = ParamUtil.getInt(oneMapping, (String)"refreshButton", (int)0).intValue()) == 1) {
            String buttonName = ParamUtil.getString(oneMapping, (String)"buttonName");
            formRelationshipMapBean.setRefreshButton(refreshButton);
            formRelationshipMapBean.setButtonName(buttonName);
        }
        int forceRefresh = ParamUtil.getInt(oneMapping, (String)"forceRefresh", (int)0);
        formRelationshipMapBean.setForceRefresh(forceRefresh);
        if (formRelationshipMapBean.isForceRefresh()) {
            String updateAuthView;
            String operation = ParamUtil.getString(oneMapping, (String)"refreshOperation");
            Map operationMap = (Map)JSONUtil.parseJSONString((String)operation);
            String addAuthView = (String)operationMap.get("addAuthView");
            if (Strings.isNotBlank((String)addAuthView)) {
                formRelationshipMapBean.setRefreshOperationAdd(addAuthView);
            }
            if (Strings.isNotBlank((String)(updateAuthView = (String)operationMap.get("updateAuthView")))) {
                formRelationshipMapBean.setRefreshOperationUpdate(updateAuthView);
            }
        }
        List mapping = (List)oneMapping.get("mapping");
        LinkedList mappingList = new LinkedList();
        for (Object obj : mapping) {
            Map map = (Map)obj;
            HashMap<String, String> finalMapping = new HashMap<String, String>();
            String targetField = (String)map.get("targetField");
            String sourceField = (String)map.get("sourceField");
            finalMapping.put(targetField, sourceField);
            FormFieldBean leftField = formBean.getFieldBeanByName(targetField);
            if (leftField.getFieldType().equals(Enums.FieldType.DECIMAL.getKey()) && FormFieldComEnum.TEXT.getKey().equals(leftField.getInputType())) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(sourceField);
                finalMapping.put("display", ParamUtil.getString((Map)map, (String)"display"));
                if (formFieldBean == null) {
                    FormFormulaBean formFormulaBean = new FormFormulaBean(formBean);
                    formFormulaBean.setId(Long.valueOf(UUIDLong.longUUID()));
                    formFormulaBean.loadFromFormula(sourceField);
                    formulaList.add(formBean.newCTPFormula4Save(formFormulaBean, 2));
                    finalMapping.put("formulaId", String.valueOf(formFormulaBean.getFormulaId()));
                }
            }
            mappingList.add(finalMapping);
        }
        formRelationshipMapBean.setRelationFieldMap(mappingList);
    }

    @Override
    @AjaxAccess
    public String saveFormInnerRelation(Map<String, Object> infoMap) throws BusinessException {
        String targetType = ParamUtil.getString(infoMap, (String)"targetType", (String)"magicOuterForm");
        boolean isService = false;
        if ("magicInterface".equals(targetType)) {
            isService = true;
        }
        return this.handleSaveInnerRelation(infoMap, isService);
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getFormInnerBusiness(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        long sourceFormId = ParamUtil.getLong(params, (String)"sourceFormId", (Long)0L);
        ArrayList<FormRelationshipBean> relationList = new ArrayList<FormRelationshipBean>();
        ArrayList<FormTriggerBean> triggerList = new ArrayList<FormTriggerBean>();
        FormBean formBean = this.cap4FormCacheManager.getForm(sourceFormId);
        if (formBean != null && Strings.isNotEmpty((Collection)formBean.getFormRelationshipIdList())) {
            for (Long relationId : formBean.getFormRelationshipIdList()) {
                FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (relationBean == null || !relationBean.getApplicationType().equals(FormRelationEnums.relationApplicationType.inner.getKey())) continue;
                relationList.add(relationBean);
            }
        }
        if (formBean != null && Strings.isNotEmpty((Collection)formBean.getFormTriggerIdList())) {
            for (Long triggerId : formBean.getFormTriggerIdList()) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (triggerBean == null || FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType())) continue;
                triggerList.add(triggerBean);
            }
        }
        DataContainer relationDc = new DataContainer();
        if (!Strings.isEmpty(relationList)) {
            Collections.sort(relationList, FormRelationshipBeanSortComparatorByDate.getInstance());
        }
        relationDc.put("relationList", relationList);
        if (!Strings.isEmpty(triggerList)) {
            Collections.sort(triggerList, FormTriggerBeanSortComparatorByDate.getInstance());
        }
        relationDc.put("triggerList", triggerList);
        resultMap.put("success", true);
        resultMap.put("relationship", relationDc.getJson());
        return resultMap;
    }

    private void deleteCtpFormula(long relationId) throws BusinessException {
        FormRelationshipBean formRelationship = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
        if (null == formRelationship) {
            return;
        }
        ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
        List relationshipMapList = formRelationship.getRelationMapList();
        for (FormRelationshipMapBean relationship : relationshipMapList) {
            Map collectFormulaBean;
            CtpFormula ctpFormula;
            Long formulaId = relationship.getConditionFormulaId();
            if (formulaId != 0L && null != (ctpFormula = this.cap4FormCacheManager.getFormula(formulaId))) {
                ctpFormulas.add(ctpFormula);
            }
            if ((collectFormulaBean = relationship.getCollectFormulaBean()) == null) continue;
            for (Map.Entry entry : collectFormulaBean.entrySet()) {
                formulaId = (Long)entry.getKey();
                CtpFormula ctpFormula2 = this.cap4FormCacheManager.getFormula(formulaId);
                if (null == ctpFormula2) continue;
                ctpFormulas.add(ctpFormula2);
            }
        }
        this.formulaDAO.deleteList(ctpFormulas);
    }

    @Override
    @AjaxAccess
    public Map<String, Object> checkLoopCollect(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", true);
        Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        Long currentRelationId = ParamUtil.getLong(params, (String)"relationId", (Long)0L);
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        String fromTable = ParamUtil.getString(params, (String)"fromTable", (String)"");
        String toTable = ParamUtil.getString(params, (String)"toTable", (String)"");
        if (Strings.isBlank((String)fromTable) || Strings.isBlank((String)toTable)) {
            return result;
        }
        ArrayList<FormRelationshipBean> collectRelationList = new ArrayList<FormRelationshipBean>();
        List relationIdList = formBean.getFormRelationshipIdList();
        for (Long relationId : relationIdList) {
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            if (formRelationshipBean == null || formRelationshipBean.getRelationType() != FormRelationEnums.ViewSelectType.auto_collect.getKey() || formRelationshipBean.getId().equals(currentRelationId)) continue;
            collectRelationList.add(formRelationshipBean);
        }
        HashSet<String> collectPath = new HashSet<String>();
        collectPath.add(fromTable);
        if (this.hasLoopNesting(collectPath, fromTable, toTable, collectRelationList)) {
            result.put("success", false);
        }
        return result;
    }

    private boolean hasLoopNesting(Set<String> collectPath, String fromTable, String toTable, List<FormRelationshipBean> collectRelationList) {
        FormRelationshipMapBean mapBean;
        if (Strings.isEmpty(collectRelationList)) {
            return false;
        }
        ArrayList<FormRelationshipBean> subList = new ArrayList<FormRelationshipBean>();
        for (FormRelationshipBean temp : collectRelationList) {
            mapBean = (FormRelationshipMapBean)temp.getRelationMapList().get(0);
            if (!mapBean.getButtonLocation().equals(fromTable)) continue;
            subList.add(temp);
        }
        if (subList.size() == 0) {
            return false;
        }
        for (FormRelationshipBean temp : subList) {
            mapBean = (FormRelationshipMapBean)temp.getRelationMapList().get(0);
            Map collectMapping = mapBean.getCollectMapping();
            String sourceTable = "";
            Iterator iterator = collectMapping.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                sourceTable = key = (String)iterator.next();
            }
            collectPath.add(sourceTable);
            if (collectPath.contains(toTable)) {
                return true;
            }
            if (!this.hasLoopNesting(collectPath, sourceTable, toTable, collectRelationList)) continue;
            return true;
        }
        return false;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormDesignManager getCap4FormDesignManager() {
        return this.cap4FormDesignManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public CAP4FormBusinessRelationDAO getCap4FormBusinessRelationDAO() {
        return this.cap4FormBusinessRelationDAO;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public ICAP4MagicIncisionManager getCap4MagicIncisionManager() {
        return this.cap4MagicIncisionManager;
    }

    public void setCap4MagicIncisionManager(ICAP4MagicIncisionManager cap4MagicIncisionManager) {
        this.cap4MagicIncisionManager = cap4MagicIncisionManager;
    }

    public CAP4FormBusinessRelationManager getCap4FormBusinessRelationManager() {
        return this.cap4FormBusinessRelationManager;
    }

    public void setCap4FormBusinessRelationManager(CAP4FormBusinessRelationManager cap4FormBusinessRelationManager) {
        this.cap4FormBusinessRelationManager = cap4FormBusinessRelationManager;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public CapBizConfigItemManager getCapBizConfigItemManager() {
        return this.capBizConfigItemManager;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public IMagicBindServicesHandle getMagicBindServicesHandle() {
        return this.magicBindServicesHandle;
    }

    public void setMagicBindServicesHandle(IMagicBindServicesHandle magicBindServicesHandle) {
        this.magicBindServicesHandle = magicBindServicesHandle;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }
}

