/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.businessRelation;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormTriggerDesignManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerRecordDAO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CAP4FormTriggerDesignManagerImpl
implements CAP4FormTriggerDesignManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTriggerDesignManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private FormulaDAO formulaDAO;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private ICAP4MagicManager cap4MagicManager;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private BusinessManager businessManager4;

    @Override
    @AjaxAccess
    public Map<String, Object> editTrigger(String triggerId) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.valueOf(triggerId));
        if (triggerBean != null) {
            FormTriggerConditionBean filterCondition;
            map.put("triggerId", triggerBean.getId());
            map.put("triggerName", triggerBean.getName());
            map.put("state", triggerBean.getState());
            map.put("triggerType", triggerBean.getType());
            map.put("triggerPoint", triggerBean.getTriggerPoint());
            if (FormTriggerBean.TriggerPoint.Condition_Operation.getKey().equals(triggerBean.getTriggerPoint())) {
                map.put("pcRight", triggerBean.getPcRight());
                map.put("phoneRight", triggerBean.getPhoneRight());
            }
            if ((filterCondition = triggerBean.getFilterCondition()) == null) {
                map.put("filterConditionId", "");
                map.put("filterConditionFormulaId", "");
                map.put("filterConditionValue", "");
            } else {
                map.put("filterConditionId", filterCondition.getId());
                map.put("filterConditionFormulaId", filterCondition.getConditionFormulaId());
                map.put("filterConditionValue", filterCondition.getConditionFormula() == null ? "" : filterCondition.getConditionFormula().getFormulaForDisplay());
            }
            FormTriggerConditionBean dateCondition = triggerBean.getDateCondition();
            if (dateCondition == null) {
                map.put("timeConditionId", "");
                map.put("timeFormulaId", "");
                map.put("timeQuartz", "");
            } else {
                map.put("timeConditionId", dateCondition.getId());
                map.put("timeFormulaId", dateCondition.getConditionFormulaId());
                map.put("timeQuartz", dateCondition.getTimeFrequency() + "|" + dateCondition.getConditionFormula().getFormulaForDisplay() + "|" + dateCondition.getTriggerTime());
            }
            if (FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.Message.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) {
                ArrayList<Map> actionMapList = new ArrayList<Map>();
                map.put("actionList", actionMapList);
                for (FormTriggerActionBean action : triggerBean.getActionList()) {
                    Map paramMap = FormTriggerUtil.getDesignManagerByKey(action.getType()).getParamFromAction(triggerBean, action);
                    actionMapList.add(paramMap);
                }
            }
            map.put("deadCycle", this.validateTrigger4Save(triggerBean.getSourceFormId(), triggerBean.getTargetFormId()));
        }
        return map;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getActionList(String triggerId) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.valueOf(triggerId));
        if (triggerBean != null) {
            ArrayList<Map> actionMapList = new ArrayList<Map>();
            map.put("actionList", actionMapList);
            for (FormTriggerActionBean action : triggerBean.getActionList()) {
                Map paramMap = FormTriggerUtil.getDesignManagerByKey(action.getType()).getParamFromAction(triggerBean, action);
                actionMapList.add(paramMap);
            }
            map.put("type", triggerBean.getType());
        }
        return map;
    }

    @Override
    @AjaxAccess
    public boolean validateTriggerName(String formId, String triggerId, String triggerName) {
        if (Strings.isBlank((String)triggerName)) {
            return true;
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId));
        List triggerIdList = formBean.getFormTriggerIdList();
        if (triggerIdList.size() > 0) {
            for (Long id : triggerIdList) {
                FormTriggerBean triggerBean;
                if (id.toString().equals(triggerId) || (triggerBean = this.cap4FormCacheManager.getFormTriggerBean(id)) == null || !triggerBean.getName().equals(triggerName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @AjaxAccess
    public String validateTrigger4Save(Long sourceFormId, Long targetFormId) {
        String result = "";
        if (targetFormId == null || 0L == targetFormId) {
            return result;
        }
        try {
            Set<Long> formIdSet = this.getTargetFormIdSet(targetFormId, 5, 0, null);
            if (formIdSet.contains(sourceFormId)) {
                StringBuilder sb = new StringBuilder();
                for (Long formId : formIdSet) {
                    if (formId.equals(sourceFormId)) continue;
                    FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                    sb.append(formBean.getFormName()).append("\u3001");
                }
                String formNames = sb.toString();
                formNames = formNames.substring(0, formNames.length() - 1);
                return "deadCycle" + formNames;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u6821\u9a8c\u5f02\u5e38 " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    private Set<Long> getTargetFormIdSet(Long formId, int maxIndex, int nowIndex, Set<Long> formIdSet) throws BusinessException {
        Set<Long> resultList = formIdSet;
        if (resultList == null) {
            resultList = new LinkedHashSet<Long>();
        }
        resultList.add(formId);
        if (nowIndex > maxIndex) {
            return resultList;
        }
        ++nowIndex;
        List triggerIdList = Collections.emptyList();
        FormBean fb = this.cap4FormCacheManager.getForm(formId);
        if (fb != null) {
            triggerIdList = fb.getFormTriggerIdList();
        }
        for (Long triggerId : triggerIdList) {
            Long targetFormId;
            Set<Long> tempList;
            FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
            if (triggerBean == null) continue;
            if (FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) {
                List<Long> targetIds = this.cap4MagicManager.getServiceProviderSource(triggerBean);
                if (targetIds.isEmpty()) continue;
                for (Long t : targetIds) {
                    if (!resultList.add(t)) continue;
                    tempList = this.getTargetFormIdSet(t, maxIndex, nowIndex, resultList);
                    resultList.addAll(tempList);
                }
                continue;
            }
            if (!FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType()) || (targetFormId = Long.valueOf(triggerBean.getTargetFormId())) == 0L || !resultList.add(targetFormId)) continue;
            tempList = this.getTargetFormIdSet(targetFormId, maxIndex, nowIndex, resultList);
            resultList.addAll(tempList);
        }
        return resultList;
    }

    @Override
    @AjaxAccess
    public String saveTrigger2DB(Map<String, String> baseInfo, List<Map<String, String>> actionList) throws BusinessException {
        FormTriggerBean triggerBean;
        String triggerId = baseInfo.get("triggerId");
        HashMap<String, Serializable> dc = new HashMap<String, Serializable>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isNew = true;
        if ("".equals(triggerId) || "-1".equals(triggerId)) {
            triggerBean = new FormTriggerBean();
            triggerBean.setId(Long.valueOf(UUIDLong.longUUID()));
            triggerBean.setCreateId(Long.valueOf(AppContext.currentUserId()));
            triggerBean.setCreateTime(DateUtil.currentDate());
        } else {
            isNew = false;
            triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.parseLong(triggerId));
            this.deleteFormulaInTrigger(triggerBean.getNeedDelFormulaList());
        }
        triggerBean.setModifyTime(DateUtil.currentDate());
        triggerBean.clearFormulaList();
        triggerBean.setName(baseInfo.get("triggerName").trim());
        triggerBean.setState(Integer.valueOf(baseInfo.get("state")).intValue());
        triggerBean.setSourceFormId(Long.valueOf(baseInfo.get("sourceFormId")).longValue());
        FormBean sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
        if (Strings.isNotBlank((String)baseInfo.get("targetFormId"))) {
            triggerBean.setTargetFormId(Long.valueOf(baseInfo.get("targetFormId")).longValue());
        } else {
            triggerBean.setTargetFormId(0L);
        }
        triggerBean.setType(baseInfo.get("triggerType"));
        triggerBean.setTriggerPoint(baseInfo.get("triggerPoint"));
        if (FormTriggerBean.TriggerPoint.Condition_Operation.getKey().equals(triggerBean.getTriggerPoint())) {
            triggerBean.setPcRight(baseInfo.get("pcRight"));
            triggerBean.setPhoneRight(baseInfo.get("phoneRight"));
        } else {
            triggerBean.setPcRight("");
            triggerBean.setPhoneRight("");
        }
        String filterConditionId = baseInfo.get("filterConditionId");
        String filterConditionValue = baseInfo.get("filterConditionValue");
        if (Strings.isNotBlank((String)filterConditionValue)) {
            FormTriggerConditionBean filterCondition = new FormTriggerConditionBean(triggerBean);
            filterCondition.setId(Long.valueOf("".equals(filterConditionId) ? UUIDLong.longUUID() : Long.valueOf(filterConditionId)));
            filterCondition.setType(FormTriggerBean.ConditionType.form.getKey());
            FormFormulaBean filterFormula = new FormFormulaBean(sourceForm);
            filterFormula.loadFromFormula(filterConditionValue);
            if (Strings.isNotBlank((String)baseInfo.get("filterConditionFormulaId"))) {
                filterFormula.setFormulaId(Long.valueOf(baseInfo.get("filterConditionFormulaId")));
            }
            filterCondition.setConditionFormulaId(filterFormula.getFormulaId() == null ? "" : "" + filterFormula.getFormulaId());
            filterCondition.setConditionFormula(filterFormula);
            triggerBean.setFilterCondition(filterCondition);
            triggerBean.addFormula(filterFormula);
        } else {
            triggerBean.setFilterCondition(null);
        }
        String oldTimeQuartz = "";
        FormTriggerConditionBean oldDateCondition = triggerBean.getDateCondition();
        if (oldDateCondition != null) {
            oldTimeQuartz = oldDateCondition.getTimeFrequency() + "|" + oldDateCondition.getConditionFormula().getFormulaForDisplay() + "|" + oldDateCondition.getTriggerTime();
        }
        String timeConditionId = baseInfo.get("timeConditionId");
        String timeQuartz = baseInfo.get("timeQuartz");
        if (Strings.isNotBlank((String)timeQuartz)) {
            FormTriggerConditionBean dateCondition = new FormTriggerConditionBean(triggerBean);
            dateCondition.setType(FormTriggerBean.ConditionType.date.getKey());
            dateCondition.setId(Long.valueOf(Strings.isBlank((String)timeConditionId) ? UUIDLong.longUUID() : Long.parseLong(timeConditionId)));
            String[] timeQuarts = timeQuartz.split("\\|");
            dateCondition.setTimeFrequency(timeQuarts[0]);
            dateCondition.setTriggerTime((String)timeQuarts[2]);
            FormFormulaBean formFormulaBean = new FormFormulaBean(sourceForm);
            formFormulaBean.loadFromFormula((String)timeQuarts[1]);
            if (Strings.isNotBlank((String)baseInfo.get("timeFormulaId"))) {
                formFormulaBean.setFormulaId(Long.valueOf(baseInfo.get("timeFormulaId")));
            }
            dateCondition.setConditionFormulaId(formFormulaBean.getFormulaId() == null ? "" : "" + formFormulaBean.getFormulaId());
            dateCondition.setConditionFormula(formFormulaBean);
            triggerBean.setDateCondition(dateCondition);
            triggerBean.addFormula(formFormulaBean);
            timeQuartz = dateCondition.getTimeFrequency() + "|" + dateCondition.getConditionFormula().getFormulaForDisplay() + "|" + dateCondition.getTriggerTime();
        } else {
            triggerBean.setDateCondition(null);
            timeQuartz = "";
        }
        if (FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) {
            this.magicReflectionRelationDao.deleteByActionOrShipId(String.valueOf(triggerBean.getId()));
        }
        ArrayList<FormTriggerActionBean> actionBeanList = new ArrayList<FormTriggerActionBean>();
        for (Map map : actionList) {
            String actionType = (String)map.get("actionType");
            FormTriggerActionBean actionBean = FormTriggerUtil.getDesignManagerByKey(actionType).getActionFromMap(triggerBean, map);
            actionBeanList.add(actionBean);
        }
        triggerBean.setActionList(actionBeanList);
        this.formulaDAO.insertList(triggerBean.getCtpFormulaList());
        if (!isNew) {
            this.cap4FormBusinessRelationDAO.deleteById(triggerBean.getId());
        }
        CAPFormBusinessRelation businessRelation = triggerBean.toCAPFormBusinessRelation();
        this.cap4FormBusinessRelationDAO.save(businessRelation);
        if (isNew) {
            this.cap4FormTriggerRecordDAO.createTriggerRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
        }
        this.cap4FormCacheManager.removeFormBean(triggerBean.getSourceFormId());
        this.cap4FormCacheManager.initForm(triggerBean.getSourceFormId());
        this.cap4FormTriggerManager.updateTriggerQuartzJob(triggerBean, isNew, oldTimeQuartz, timeQuartz);
        LOGGER.info((Object)("\u4fdd\u5b58\u4e1a\u52a1\u5173\u7cfb\uff1a" + triggerBean.getId() + triggerBean.getName()));
        result.put("success", true);
        result.put("id", String.valueOf(businessRelation.getId()));
        result.put("name", businessRelation.getName());
        dc.put("result", result);
        dc.put("success", Boolean.valueOf(true));
        return JSONUtil.toJSONString(dc);
    }

    @Override
    @AjaxAccess
    public void deleteTrigger(List<String> ids) throws BusinessException {
        if (!AppContext.hasPlugin((String)"cap_advance") && !AppContext.hasPlugin((String)"cap_base")) {
            throw new BusinessException(ResourceUtil.getString((String)"form.over.power.tips"));
        }
        HashSet<Long> formIds = new HashSet<Long>();
        for (String id : ids) {
            FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.valueOf(id));
            if (triggerBean != null) {
                formIds.add(triggerBean.getSourceFormId());
                if (triggerBean.hasTimeCondition()) {
                    QuartzHolder.deleteQuartzJobByGroup((String)id);
                }
                this.deleteFormulaInTrigger(triggerBean.getFormulaList());
                this.cap4MagicManager.deleteReflectionsByTrigger(triggerBean);
            }
            this.cap4FormBusinessRelationDAO.deleteById(Long.valueOf(id));
        }
        for (Long formId : formIds) {
            this.cap4FormCacheManager.removeFormBean(formId);
            this.cap4FormCacheManager.initForm(formId);
        }
        LOGGER.info((Object)("\u5220\u9664\u4e1a\u52a1\u5173\u7cfb\u6210\u529f\uff1a" + ids));
    }

    private void deleteFormulaInTrigger(List<FormFormulaBean> formulaList) throws BusinessException {
        if (Strings.isNotEmpty(formulaList)) {
            ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
            for (FormFormulaBean formula : formulaList) {
                CtpFormula ctpFormula;
                if (formula == null || formula.getFormulaId() == null || (ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId())) == null) continue;
                ctpFormulas.add(ctpFormula);
            }
            this.formulaDAO.deleteList(ctpFormulas);
            this.cap4FormCacheManager.removeFormula(ctpFormulas);
        }
    }

    @Override
    @AjaxAccess
    public String getSubTableNameInCondition(long formId, String conditionStr, boolean needDefault) throws BusinessException {
        List beans;
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (Strings.isNotEmpty((String)conditionStr)) {
            Set<FormTableBean> subTableBeans = this.getSubTableBeanInCondition(formBean, conditionStr);
            for (FormTableBean table : subTableBeans) {
                if (table.isMainTable()) continue;
                return table.getTableName();
            }
        }
        if (needDefault && Strings.isNotEmpty((Collection)(beans = formBean.getSubTableBean())) && beans.size() == 1) {
            return ((FormTableBean)beans.get(0)).getTableName();
        }
        return "";
    }

    @Override
    @AjaxAccess
    public boolean senderIsSubField(long formId, String conditionStr, String senderStr) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (Strings.isEmpty((Collection)formBean.getSubTableBean()) || formBean.getSubTableBean().size() == 1) {
            return false;
        }
        String[] senderArr = FormTriggerUtil.getFieldName(senderStr);
        FormTableBean senderTableBean = formBean.getFormTableBeanByFieldName(senderArr[1]);
        return !senderTableBean.isMainTable() && senderTableBean.getTableName().equalsIgnoreCase(this.getSubTableNameInCondition(formId, conditionStr, false));
    }

    @Override
    @AjaxAccess
    public boolean senderIsSubField(long formId, String conditionStr, String senderStr, String msContent) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (Strings.isEmpty((Collection)formBean.getSubTableBean()) || formBean.getSubTableBean().size() == 1) {
            return false;
        }
        String[] senderArr = FormTriggerUtil.getFieldName(senderStr);
        FormTableBean senderTableBean = formBean.getFormTableBeanByFieldName(senderArr[1]);
        if (senderTableBean.isMainTable()) {
            return false;
        }
        Set<FormTableBean> conditionSubTableBeans = this.getSubTableBeanInCondition(formBean, conditionStr);
        Set<FormTableBean> msgSubTableBeans = FormTriggerUtil.getSubTableBeanInMsgContent(formBean, msContent);
        return !conditionSubTableBeans.contains(senderTableBean) && !msgSubTableBeans.contains(senderTableBean);
    }

    private Set<FormTableBean> getSubTableBeanInCondition(FormBean formBean, String conditionStr) throws BusinessException {
        HashSet<FormTableBean> subTableBeans = new HashSet<FormTableBean>();
        FormFormulaBean formulaBean = new FormFormulaBean(formBean);
        formulaBean.loadFromFormula(conditionStr);
        Set fieldBeans = formulaBean.getInFormulaFormFieldBean();
        for (FormFieldBean fieldBean : fieldBeans) {
            subTableBeans.add(formBean.getTableByTableName(fieldBean.getOwnerTableName()));
        }
        return subTableBeans;
    }

    @Override
    @AjaxAccess
    public String getSubTableNameInMsgContent(long formId, String msg) throws BusinessException {
        List beans;
        Set<FormTableBean> subTableList;
        String subTableName = "";
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (Strings.isNotEmpty((String)msg) && Strings.isNotEmpty(subTableList = FormTriggerUtil.getSubTableBeanInMsgContent(formBean, msg)) && subTableList.size() == 1) {
            Iterator<FormTableBean> iterator = subTableList.iterator();
            subTableName = iterator.next().getTableName();
        }
        if ("".equals(subTableName) && Strings.isNotEmpty((Collection)(beans = formBean.getSubTableBean())) && beans.size() == 1) {
            subTableName = ((FormTableBean)beans.get(0)).getTableName();
        }
        return subTableName;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public void setCap4FormTriggerRecordDAO(CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO) {
        this.cap4FormTriggerRecordDAO = cap4FormTriggerRecordDAO;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

