/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.design.impl;

import com.seeyon.apps.ai.api.AIApi;
import com.seeyon.apps.ai.util.AIUtil;
import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.FormSaveAsBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.component.FormCollectionAscSortComparator;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormOperationBaseManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessExportConstant;
import com.seeyon.cap4.form.modules.importandexport.BusinessFormExportManager4FormView;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.modules.log.CapLogDAO;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.CapUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.ResultInfoVO;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cdp.CDPAgent;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.i18n.expand.ResourceConsts;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.publicqrcode.manager.PublicQrCodeManager;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.service.FormManager;
import com.seeyon.ctp.login.event.UserLogoutEvent;
import com.seeyon.ctp.login.online.OnlineUser;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class CAP4FormDesignManagerImpl
implements CAP4FormDesignManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormDesignManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private AttachmentManager attachmentManager;
    private CAP4FormDataDAO cap4FormDataDAO;
    private WorkflowApiManager wapi;
    private CapBizConfigItemManager capBizConfigItemManager;
    private BusinessManager businessManager4;
    private MainbodyManager ctpMainbodyManager;
    private CollaborationApi collaborationApi;
    private AIApi aiApi;
    private FormManager formManager;
    private FormCacheManager formCacheManager;
    private SerialNumberManager serialNumberManager;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private CapLogDAO capLogDAO;
    private FileManager fileManager;
    BusinessImportAndExportManager businessImportAndExportManager;
    private PublicQrCodeManager publicQrCodeManager;
    private List<CAP4FormOperationBaseManager> designManagers = new ArrayList<CAP4FormOperationBaseManager>();
    private Map<String, CAP4FormOperationBaseManager> designManagerMap = new HashMap<String, CAP4FormOperationBaseManager>();

    public PublicQrCodeManager getPublicQrCodeManager() {
        return this.publicQrCodeManager;
    }

    public void setPublicQrCodeManager(PublicQrCodeManager publicQrCodeManager) {
        this.publicQrCodeManager = publicQrCodeManager;
    }

    public void setBusinessImportAndExportManager(BusinessImportAndExportManager businessImportAndExportManager) {
        this.businessImportAndExportManager = businessImportAndExportManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    public void init() throws BusinessException {
        Map map = AppContext.getBeansOfType(CAP4FormOperationBaseManager.class);
        for (Map.Entry et : map.entrySet()) {
            CAP4FormOperationBaseManager manager = (CAP4FormOperationBaseManager)et.getValue();
            if (!manager.canUse()) continue;
            this.designManagers.add(manager);
            this.designManagerMap.put(manager.getId(), manager);
        }
    }

    @Override
    public FormBean addEditForm(FormBean bean) {
        bean.setEditFlag(1);
        HashMap<Long, FormBean> formBeanMap = (HashMap<Long, FormBean>)AppContext.getSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()));
        if (formBeanMap == null) {
            formBeanMap = new HashMap<Long, FormBean>();
        }
        formBeanMap.put(bean.getId(), bean);
        AppContext.putSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()), formBeanMap);
        LOGGER.info((Object)(FormUtil.getLocalIpAddress() + " " + AppContext.currentUserId() + AppContext.currentUserName() + " \u6dfb\u52a0\u7f16\u8f91\u8868\u5355 " + bean.getId()));
        return bean;
    }

    @Override
    public FormBean getEditingForm(boolean needLog, Long formId) {
        return this.getEditingForm(needLog, AppContext.currentUserId(), formId);
    }

    @Override
    public FormBean getEditingForm(boolean needLog, Long userId, Long formId) {
        try {
            Map formBeanMap = (Map)AppContext.getSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()));
            if (formBeanMap == null) {
                return null;
            }
            FormBean bean = (FormBean)formBeanMap.get(formId);
            if (needLog && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(FormUtil.getLocalIpAddress() + " " + userId + " \u83b7\u53d6\u7f16\u8f91\u8868\u5355\u5bf9\u8c61\u4e3a:" + (bean == null)));
            }
            return bean;
        }
        catch (InfrastructureException infrastructureException) {
            return null;
        }
    }

    @Override
    public void saveEditingForm(FormBean bean) {
        if (SystemEnvironment.isDistributedMode()) {
            HashMap<Long, FormBean> formBeanMap = (HashMap<Long, FormBean>)AppContext.getSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()));
            if (formBeanMap == null) {
                formBeanMap = new HashMap<Long, FormBean>();
            }
            formBeanMap.put(bean.getId(), bean);
            AppContext.putSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()), formBeanMap);
        }
    }

    @Override
    public void removeEditForm(boolean needLog, Long formId) {
        this.removeEditForm(needLog, AppContext.currentUserId(), formId);
    }

    @Override
    public void removeEditForm(boolean needLog, Long userId, Long formId) {
        Map formBeanMap = (Map)AppContext.getSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + userId));
        if (formBeanMap != null) {
            formBeanMap.remove(formId);
        }
        if (needLog) {
            LOGGER.info((Object)(FormUtil.getLocalIpAddress() + " " + userId + " \u79fb\u9664\u7f16\u8f91\u8868\u5355:" + formId));
        }
        if (SystemEnvironment.isDistributedMode()) {
            AppContext.putSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + userId), (Object)formBeanMap);
        }
    }

    @Override
    public void removeEditFormByUser(boolean needLog, Long userId) {
        AppContext.removeSessionArrribute((String)("CURRENT_EDIT_FORM_CAP_" + userId));
        if (needLog && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(FormUtil.getLocalIpAddress() + " " + userId + " \u79fb\u9664\u6240\u6709\u7f16\u8f91\u8868\u5355 "));
        }
    }

    @Override
    @AjaxAccess
    public boolean checkFormIsEdit(Long formID) {
        Map formBeanMap = (Map)AppContext.getSessionContext((String)("CURRENT_EDIT_FORM_CAP_" + AppContext.currentUserId()));
        boolean result = false;
        if (null != formBeanMap) {
            result = formBeanMap.containsKey(formID);
        }
        return result;
    }

    @Override
    public FormBean checkAndLoadForm2Session(Long formId, String createType) throws BusinessException {
        FormBean formBean = null;
        if (!StringUtil.checkNull((String)String.valueOf(formId)) && !formId.equals(0L)) {
            FormBean form = this.getEditingForm(true, formId);
            if (null == form) {
                form = this.cap4FormCacheManager.getForm(formId);
                FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
                boolean hasRight = FormUtil.isRightEditForm((long)AppContext.currentUserId(), (FormOwner)formOwner);
                if (!hasRight) {
                    throw new BusinessException(ResourceUtil.getString((String)"form.edit.noright"));
                }
                try {
                    formBean = (FormBean)form.clone();
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error((Object)"clone FormBean error!", (Throwable)e);
                }
            } else {
                formBean = form;
            }
            if (null == form) {
                throw new BusinessException("\u627e\u4e0d\u5230id\u4e3a " + String.valueOf(formId) + " \u7684\u8868\u5355,\u65e0\u6cd5\u8fdb\u884c\u7f16\u8f91\u3002");
            }
        } else {
            formBean = new FormBean();
            formBean.setNewId();
            formBean.setFormName("");
            formBean.setState(0);
            formBean.setEditFlag(1);
            formBean.setOwnerId(AppContext.currentUserId());
            formBean.setCreatorId(AppContext.currentUserId());
            formBean.setCreateDate(DateUtil.currentDate());
            Enums.FormType formType = null;
            formType = "flow".equals(createType) ? Enums.FormType.processesForm : Enums.FormType.unFlowForm;
            formBean.setFormType(formType.getKey());
        }
        this.addEditForm(formBean);
        return formBean;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String designForm(Map<String, Object> param) throws BusinessException {
        Long formId = 0L;
        Long categoryId = 0L;
        if (!StringUtil.checkNull((String)String.valueOf(param.get("formId")))) {
            formId = Long.parseLong(String.valueOf(param.get("formId")));
        }
        if (!StringUtil.checkNull((String)String.valueOf(param.get("categoryId")))) {
            categoryId = Long.parseLong(String.valueOf(param.get("categoryId")));
        }
        String silent = String.valueOf(param.get("silent"));
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Long bizConfigId = ParamUtil.getLong(param, (String)"bizConfigId", (Long)0L);
        if (!bizConfigId.equals(0L) && formId.equals(0L) && !AppContext.hasPlugin((String)"cap_advance")) {
            throw new BusinessException(ResourceUtil.getString((String)"form.over.power.tips"));
        }
        boolean showOtherSave = true;
        if (!AppContext.hasPlugin((String)"cap_advance") && !bizConfigId.equals(0L)) {
            showOtherSave = false;
        }
        result.put("showOtherSave", showOtherSave);
        result.put("cap_advance", AppContext.hasPlugin((String)"cap_advance"));
        String createType = String.valueOf(param.get("formType"));
        String viewType = param.get("viewType") == null ? "" : String.valueOf(param.get("viewType"));
        Locale locale = AppContext.getLocale();
        result.put("isDevelop", AppContext.isRunningModeDevelop());
        result.put("locale", locale.toString());
        String removeTag = String.valueOf(param.get("removeTag"));
        if (!StringUtil.checkNull((String)removeTag) && "true".equals(removeTag)) {
            this.cap4FormManager.removeEditForm(formId);
        }
        FormBean formBean = null;
        formBean = "preview".equals(viewType) ? this.cap4FormCacheManager.getForm(formId) : this.checkAndLoadForm2Session(formId, createType);
        if (null == formBean) {
            result.put("success", false);
            result.put("message", ResourceUtil.getString((String)"cap4.form.design.tips7", (Object)formId));
        } else {
            if (showOtherSave) {
                if (!bizConfigId.equals(0L)) {
                    BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
                    if (bizConfigBean.isMallApp() && formBean.getFormAttribute() == BusinessEnums.FormAttribute.GOODS || BusinessEnums.FormAttribute.SINGLETEMPLATEFORM.getKey().equals(formBean.getFormAttribute().getKey())) {
                        result.put("saveAsMsg", ResourceUtil.getString((String)"com.cap.import.form.cant.save.as.tips"));
                    }
                } else if (BusinessEnums.FormAttribute.SINGLETEMPLATEFORM.getKey().equals(formBean.getFormAttribute().getKey())) {
                    result.put("saveAsMsg", ResourceUtil.getString((String)"com.cap.import.form.cant.save.as.tips"));
                }
            }
            result.put("success", true);
            result.put("formId", String.valueOf(formBean.getId()));
            List canUseFormFieldCtrl = FormFieldUtil.getCanUseFieldCtrlKeyMap4FormType((Enums.FormType)Enums.FormType.getEnumByKey((int)formBean.getFormType()));
            Map customCtrlInfoMap = FormFieldUtil.getCustomCtrlJsonObjList((Enums.FormType)Enums.FormType.getEnumByKey((int)formBean.getFormType()));
            if (!customCtrlInfoMap.isEmpty()) {
                canUseFormFieldCtrl.add(customCtrlInfoMap);
            }
            if (!"true".equalsIgnoreCase(silent)) {
                result.put("allowedCtrls", canUseFormFieldCtrl);
                result.put("formBaseInfo", formBean.getJsonObj4Design());
            }
            if (!categoryId.equals(0L)) {
                formBean.setCategoryId(categoryId.longValue());
            }
            ArrayList allLanList = new ArrayList();
            List allLocales = LocaleContext.getAllLocales();
            for (Locale loc : allLocales) {
                HashMap<String, String> lanMap = new HashMap<String, String>();
                lanMap.put("key", loc.toString());
                lanMap.put("name", ResourceConsts.getLanguageName((String)I18nUtil.getLocalAsString((Locale)loc)));
                allLanList.add(lanMap);
            }
            result.put("allLan", allLanList);
        }
        return JSONUtil.toJSONString(result);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String downLoadCustomCtrl(Map<String, Object> param) throws BusinessException {
        HashMap<String, String> resultObj = new HashMap<String, String>();
        File customCtrlFolder = SystemEnvironment.getClusterPublicFolder((String)"capCustomCtrls");
        String name = ParamUtil.getString(param, (String)"name");
        String ctrlUrl = ParamUtil.getString(param, (String)"url");
        if (StringUtil.checkNull((String)name) || StringUtil.checkNull((String)ctrlUrl)) {
            resultObj.put("success", "false");
            resultObj.put("errorMsg", ResourceUtil.getString((String)"cap4.form.design.tips1"));
            return JSONUtil.toJSONString(resultObj);
        }
        boolean hasCtrl = false;
        File toFile = new File(customCtrlFolder, name);
        if (toFile.exists()) {
            hasCtrl = true;
        } else {
            try {
                toFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (hasCtrl) {
            resultObj.put("success", "false");
            resultObj.put("errorMsg", ResourceUtil.getString((String)"cap4.form.design.tips2"));
            return JSONUtil.toJSONString(resultObj);
        }
        this.downFile(ctrlUrl, toFile);
        return JSONUtil.toJSONString(resultObj);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String getCustomList() throws BusinessException {
        File[] files;
        HashMap result = new HashMap();
        ArrayList<String> unicName = new ArrayList<String>();
        ArrayList resultJsonObjs = new ArrayList();
        Map deployedCustomCtrls = FormFieldUtil.getCustomCtrlMap();
        for (FormFieldCustomCtrl customCtrl : deployedCustomCtrls.values()) {
            HashMap<String, Object> customJsonObj;
            if (customCtrl.canUse()) {
                customJsonObj = new HashMap(2);
                customJsonObj.put("name", customCtrl.getText());
                customJsonObj.put("deployed", 1);
                if (!unicName.contains(customCtrl.getText())) {
                    resultJsonObjs.add(customJsonObj);
                    unicName.add(customCtrl.getText());
                    continue;
                }
                LOGGER.info((Object)("\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u540d\u4e3a\uff1a" + customCtrl.getText() + "\u7684\u81ea\u5b9a\u4e49\u63a7\u4ef6"));
                continue;
            }
            customJsonObj = new HashMap<String, Object>();
            customJsonObj.put("name", customCtrl.getText());
            customJsonObj.put("deployed", 2);
            if (!unicName.contains(customCtrl.getText())) {
                unicName.add(customCtrl.getText());
                resultJsonObjs.add(customJsonObj);
                continue;
            }
            LOGGER.info((Object)("\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u540d\u4e3a\uff1a" + customCtrl.getText() + "\u7684\u81ea\u5b9a\u4e49\u63a7\u4ef6"));
        }
        File customCtrlFolder = SystemEnvironment.getClusterPublicFolder((String)"capCustomCtrls");
        if (customCtrlFolder.exists() && customCtrlFolder.isDirectory() && (files = customCtrlFolder.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                String fname;
                if (!f.exists() || !f.isFile() || !f.getName().toLowerCase().contains(".zip") || (fname = f.getName()).contains("_imported")) continue;
                HashMap<String, Object> customJsonObj = new HashMap<String, Object>(2);
                customJsonObj.put("name", f.getName());
                customJsonObj.put("deployed", 3);
                if (!unicName.contains(f.getName())) {
                    unicName.add(f.getName());
                    resultJsonObjs.add(customJsonObj);
                    continue;
                }
                LOGGER.info((Object)("\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u540d\u4e3a\uff1a" + f.getName() + "\u7684\u81ea\u5b9a\u4e49\u63a7\u4ef6"));
            }
        }
        result.put("result", resultJsonObjs);
        return JSONUtil.toJSONString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downFile(String ctrlUrl, File toFile) {
        int byteread = 0;
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            URL url = new URL(ctrlUrl);
            URLConnection conn = url.openConnection();
            inStream = conn.getInputStream();
            fs = new FileOutputStream(toFile);
            byte[] buffer = new byte[1204];
            while ((byteread = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null != fs) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String validateFormName(Map<String, Object> param) throws BusinessException {
        String formName = ParamUtil.getString(param, (String)"formName");
        Long formId = ParamUtil.getLong(param, (String)"formId");
        return this.validateFormName(formName, this.getEditingForm(true, formId));
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String validateFormName(String formName, FormBean formBean) throws BusinessException {
        DataContainer result = new DataContainer();
        try {
            formName = formName.trim();
            List<CAPFormDefinition> list = this.cap4FormDefinitionDAO.selectByName(formName, AppContext.currentAccountId());
            if (list != null) {
                if (list.size() >= 2) {
                    result.put("success", (Object)true);
                    result.put("result", (Object)"1");
                    return result.getJson();
                }
                if (list.size() == 1) {
                    CAPFormDefinition fdf = list.get(0);
                    if (formBean == null || fdf.getId().longValue() != formBean.getId().longValue()) {
                        result.put("success", (Object)true);
                        result.put("result", (Object)"1");
                        return result.getJson();
                    }
                }
            }
            result.put("success", (Object)true);
            result.put("result", (Object)"0");
        }
        catch (Exception e) {
            result.put("success", (Object)false);
            result.put("error", (Object)e.getMessage());
        }
        return result.getJson();
    }

    @Override
    @AjaxAccess
    public boolean hasRedTemplete(String tableName) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getFormByFormTableName(tableName);
        return formBean != null && formBean.hasRedTemplete();
    }

    @Override
    @AjaxAccess
    public boolean hasFormData(Long formId) throws BusinessException {
        FormBean formBean = this.cap4FormManager.getForm(formId);
        FormTableBean formTableBean = formBean.getMasterTableBean();
        try {
            int count = this.cap4FormDataDAO.selectRecordCount(formTableBean.getTableName());
            return count > 0;
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public DataContainer saveFrom(Map<String, Object> param, DataContainer result) throws BusinessException {
        boolean hasRight;
        String state = ParamUtil.getString(param, (String)"state");
        Long formId = ParamUtil.getLong(param, (String)"formId");
        LOGGER.info((Object)("\u4fdd\u5b58\u8868\u5355\uff1a" + formId));
        FormBean fb = this.getEditingForm(true, formId);
        if (fb != null && fb.getState() == Enums.FormStateEnum.official.getKey()) {
            state = String.valueOf(Enums.FormStateEnum.official.getKey());
        }
        FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
        if (fb == null) {
            LOGGER.info((Object)("\u4fdd\u5b58\u8868\u5355\u51fa\u9519\uff1a\u8868\u5355" + formId + "\u5728\u5f53\u524d\u7f16\u8f91\u8868\u5355\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u3002"));
            return result;
        }
        if (Strings.isNotBlank((String)state) && !"null".equals(state)) {
            fb.setState(Integer.parseInt(state));
        }
        if (!(hasRight = FormUtil.isRightEditForm((long)AppContext.currentUserId(), (FormOwner)formOwner))) {
            result.put("success", (Object)false);
            result.put("error", (Object)ResourceUtil.getString((String)"form.edit.noright"));
            return result;
        }
        Long bizConfigId = ParamUtil.getLong(param, (String)"bizConfigId", null);
        if (bizConfigId != null) {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
            if (bizConfigBean != null && bizConfigBean.isPublishedConfig()) {
                fb.setPublishFlag(Enums.FormPublishFlagEnum.published.getKey());
            }
            this.capBizConfigItemManager.saveOrUpdate(bizConfigId, formId);
        }
        this.cap4FormManager.saveOrUpdateFormBean(fb);
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String saveForm2DB(Map<String, Object> param) {
        DataContainer result = new DataContainer();
        try {
            this.saveFrom(param, result);
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u4fdd\u5b58\u8868\u5355\u51fa\u9519:" + e.getMessage()), (Throwable)e);
            result.put("success", (Object)false);
            result.put("error", (Object)e.getMessage());
        }
        return result.getJson();
    }

    @Override
    @AjaxAccess
    public String getFormTemplateCategorys() throws BusinessException {
        List<CtpTemplateCategory> templeteCategories = this.cap4FormManager.getFormCategoryListByMyAccount();
        HashMap<String, ArrayList<Map<String, String>>> result = new HashMap<String, ArrayList<Map<String, String>>>();
        ArrayList<Long> categoryTypes = new ArrayList<Long>();
        categoryTypes.add(Long.valueOf(ModuleType.form.getKey()));
        categoryTypes.add(Long.valueOf(ModuleType.collaboration.getKey()));
        ArrayList<Map<String, String>> contain = new ArrayList<Map<String, String>>();
        this.getTemplateCategory(templeteCategories, categoryTypes, 1, contain);
        result.put("category", contain);
        return JSONUtil.toJSONString(result);
    }

    private List<Map<String, String>> getTemplateCategory(List<CtpTemplateCategory> categories, List<Long> currentNode, int level, List<Map<String, String>> contain) throws BusinessException {
        for (CtpTemplateCategory category : categories) {
            Long parentId = category.getParentId();
            if (!currentNode.contains(parentId)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String space = "";
            for (int i = 0; i < level - 1; ++i) {
                space = space + "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            String catyName = space + category.getName();
            map.put("id", category.getId().toString());
            map.put("parentId", category.getParentId().toString());
            map.put("title", catyName);
            contain.add(map);
            ArrayList<Long> categoryTypes = new ArrayList<Long>();
            categoryTypes.add(category.getId());
            this.getTemplateCategory(categories, categoryTypes, level + 1, contain);
        }
        return contain;
    }

    @Override
    @AjaxAccess
    public String formDataIsUnique(Map<String, Object> params) throws BusinessException {
        Long formId = ParamUtil.getLong(params, (String)"formId");
        String uniqueStr = (String)params.get("unique");
        Map uniqueMap = (Map)JSONUtil.parseJSONString((String)uniqueStr, Map.class);
        ArrayList uniqueList = new ArrayList();
        if (uniqueMap != null && !uniqueMap.isEmpty()) {
            List sonUnique;
            List mainUnique = (List)uniqueMap.get("formmain");
            if (mainUnique != null) {
                uniqueList.addAll(mainUnique);
            }
            if ((sonUnique = (List)uniqueMap.get("formsons")) != null) {
                for (int i = 0; i < sonUnique.size(); ++i) {
                    Map sonMap = (Map)sonUnique.get(i);
                    List sonList = (List)sonMap.get("fields");
                    uniqueList.addAll(sonList);
                }
            }
        }
        boolean result = false;
        List notUnicFields = null;
        for (List unicFields : uniqueList) {
            result = this.isFieldHasUniqueMarked(formId, unicFields);
            if (!result) continue;
            notUnicFields = unicFields;
            break;
        }
        HashMap<String, Object> resJson = new HashMap<String, Object>();
        if (result) {
            resJson.put("success", false);
            resJson.put("result", notUnicFields);
        } else {
            resJson.put("success", true);
        }
        return JSONUtil.toJSONString(resJson);
    }

    @Override
    @AjaxAccess
    public String validateFormNameRepeat(String formName, Long formId, String categoryId) throws BusinessException {
        try {
            formName = formName.trim();
            FormBean fb = this.cap4FormManager.getEditingForm(formId);
            List<CAPFormDefinition> formList = this.cap4FormDefinitionDAO.selectByCategoryId(Long.valueOf(categoryId));
            ArrayList<CAPFormDefinition> sameNameList = new ArrayList<CAPFormDefinition>();
            for (CAPFormDefinition formDefinition : formList) {
                if (!formDefinition.getName().equals(formName)) continue;
                sameNameList.add(formDefinition);
            }
            if (sameNameList.size() >= 2) {
                return "-4";
            }
            if (sameNameList.size() == 1) {
                CAPFormDefinition fdf = (CAPFormDefinition)sameNameList.get(0);
                if (null == fb || fdf.getId().longValue() != fb.getId().longValue()) {
                    return "-4";
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFieldHasUniqueMarked(Long formId, List<String> newFieldList) throws BusinessException {
        ArrayList<String> tableNameList = new ArrayList<String>();
        FormBean fb = this.getEditingForm(true, formId);
        if (fb != null) {
            tableNameList.add(fb.getMasterTableBean().getTableName());
            for (int k = 0; k < newFieldList.size(); ++k) {
                String fieldName = newFieldList.get(k);
                FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
                String tableName = ffb.getOwnerTableName();
                if (tableNameList.contains(tableName)) continue;
                tableNameList.add(tableName);
            }
            JDBCAgent jdbc = null;
            ResultSet result = null;
            try {
                jdbc = new JDBCAgent();
                StringBuilder sql = new StringBuilder();
                sql.append(" select count(" + (String)tableNameList.get(0) + ".id) from ");
                for (int i = 0; i < tableNameList.size(); ++i) {
                    if (i == 0) {
                        sql.append((String)tableNameList.get(i));
                        continue;
                    }
                    sql.append(" left join " + (String)tableNameList.get(i) + " on " + (String)tableNameList.get(0) + ".id=" + (String)tableNameList.get(i) + ".formmain_id ");
                }
                StringBuilder temp = new StringBuilder(" where ");
                for (String aNewFieldList : newFieldList) {
                    temp.append(aNewFieldList).append(" is not null and ");
                }
                temp.append(" 1=1 ");
                sql.append((CharSequence)temp);
                sql.append(" group  by ");
                for (int i = 0; i < newFieldList.size(); ++i) {
                    if (i == newFieldList.size() - 1) {
                        sql.append(newFieldList.get(i)).append(" ");
                        continue;
                    }
                    sql.append(newFieldList.get(i) + ",");
                }
                sql.append(" having count(" + (String)tableNameList.get(0) + ".id) >1 ");
                jdbc.execute(sql.toString());
                result = jdbc.getQueryResult();
                int count = 0;
                if (result.next()) {
                    count = result.getInt(1);
                }
                if (count > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)(newFieldList + "ajax \u5224\u65ad\u6570\u636e\u552f\u4e00\u65f6\u5f02\u5e38\uff1a"), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != result) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (jdbc != null) {
                    jdbc.close();
                }
            }
        }
        return false;
    }

    private String searchDataBaseForUnique(List<String> uniqueFields, String tableName) throws BusinessException {
        String condtion = "";
        for (String fieldName : uniqueFields) {
            condtion = condtion + fieldName + ", ";
        }
        int index = condtion.lastIndexOf(",");
        condtion = condtion.substring(0, index);
        String totalSql = "select count(*) from " + tableName;
        String sql = "select count(distinct " + condtion + ") from " + tableName;
        JDBCAgent agent = null;
        try {
            agent = new JDBCAgent();
            int total = 0;
            agent.execute(totalSql);
            Map m = agent.resultSetToMap();
            if (m.size() > 0) {
                total = (Integer)m.values().toArray()[0];
            }
            int count = 0;
            agent.execute(sql);
            Map m1 = agent.resultSetToMap();
            if (m1.size() > 0) {
                count = (Integer)m1.values().toArray()[0];
            }
            if (count == total) {
                String string = "true";
                return string;
            }
            String string = uniqueFields.toString();
            return string;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (null != agent) {
                agent.close();
            }
        }
    }

    @Override
    @AjaxAccess
    public String validateGenerateData(Map<String, Object> param) throws BusinessException, SQLException {
        ResultInfoVO resultInfoVO = new ResultInfoVO(true);
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        String type = ParamUtil.getString(param, (String)"type");
        String name = ParamUtil.getString(param, (String)"name");
        boolean validatePublish = Boolean.parseBoolean(ParamUtil.getString(param, (String)"validatePublish", (String)"true"));
        FormBean formBean = this.getEditingForm(true, formId);
        FormBean cacheForm = this.cap4FormCacheManager.getForm(formId);
        if (cacheForm == null) {
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        if (formBean == null) {
            resultInfoVO.setMsg(ResourceUtil.getString((String)"cap4.form.design.tips3"));
            resultInfoVO.setSuccess(false);
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formId);
        boolean needCheckData = false;
        if (bizConfigBean == null && formBean.isPublished()) {
            needCheckData = true;
        } else if (bizConfigBean != null && bizConfigBean.isPublishedConfig()) {
            needCheckData = true;
        }
        if (!validatePublish || needCheckData) {
            if ("field".equals(type)) {
                int count;
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(name);
                FormFieldBean cacheField = cacheForm.getFieldBeanByName(name);
                if (formFieldBean != null && cacheField != null && (count = this.cap4FormDataDAO.selectRecordCount(formFieldBean.getOwnerTableName(), name)) > 0) {
                    resultInfoVO.setSuccess(false);
                    resultInfoVO.setMsg(ResourceUtil.getString((String)"form.check.field.has.data.tips"));
                    return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
                }
            } else if ("table".equals(type)) {
                int count;
                FormTableBean formTableBean = formBean.getTableByTableName(name);
                FormTableBean oldTableBean = cacheForm.getTableByTableName(name);
                if (formTableBean != null && oldTableBean != null && (count = this.cap4FormDataDAO.selectRecordCount(formTableBean.getTableName())) > 0) {
                    resultInfoVO.setSuccess(false);
                    resultInfoVO.setMsg(ResourceUtil.getString((String)"form.check.field.has.data.tips"));
                    return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
                }
            }
        }
        return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
    }

    @Override
    @AjaxAccess
    public String checkView4Delete(Map<String, Object> param) throws BusinessException {
        ResultInfoVO resultInfoVO = new ResultInfoVO(true);
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        Long viewId = ParamUtil.getLong(param, (String)"viewId", (Long)0L);
        if (viewId == null || viewId == 0L || viewId == -1L) {
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        FormBean formBean = this.getEditingForm(true, formId);
        if (formBean == null) {
            resultInfoVO.setMsg(ResourceUtil.getString((String)"cap4.form.design.tips3"));
            resultInfoVO.setSuccess(false);
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        FormViewBean formViewBean = formBean.getFormView(viewId.longValue());
        if (formViewBean == null) {
            resultInfoVO.setMsg(ResourceUtil.getString((String)"cap4.form.design.tips4"));
            resultInfoVO.setSuccess(false);
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formId);
        List<CAP4FormOperationBaseManager> checkManagers = this.getCheckManagerList(formBean.getFormType());
        for (CAP4FormOperationBaseManager manager : checkManagers) {
            if (bizConfigBean == null && manager.externalBusiness() || (resultInfoVO = manager.checkView4Delete(formBean, viewId)).isSuccess()) continue;
            break;
        }
        return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
    }

    @Override
    @AjaxAccess
    public String checkTable4Delete(Map<String, Object> param) throws BusinessException, SQLException {
        CAP4FormOperationBaseManager manager;
        ResultInfoVO resultInfoVO = new ResultInfoVO(true);
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        String tableName = ParamUtil.getString(param, (String)"tableName");
        FormBean formBean = this.getEditingForm(true, formId);
        if (formBean == null) {
            resultInfoVO.setMsg(ResourceUtil.getString((String)"cap4.form.design.tips3"));
            resultInfoVO.setSuccess(false);
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        FormTableBean formTableBean = formBean.getTableByTableName(tableName);
        if (formTableBean == null) {
            return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
        }
        BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(formId);
        List<CAP4FormOperationBaseManager> checkManagers = this.getCheckManagerList(formBean.getFormType());
        Iterator<CAP4FormOperationBaseManager> iterator = checkManagers.iterator();
        while (iterator.hasNext() && (resultInfoVO = (manager = iterator.next()).checkTable4Delete(formBean, tableName)).isSuccess()) {
        }
        return JSONUtil.toJSONString((Object)resultInfoVO.getJsonObject());
    }

    @Override
    @AjaxAccess
    public String checkHasBind4Publish(Map<String, Object> param) throws BusinessException {
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        FormBean formBean = this.getEditingForm(true, formId);
        if (formBean.getBind().getFlowTemplateList().size() == 0 && formBean.getBind().getUnFlowTemplateMap().size() == 0) {
            return ResourceUtil.getString((String)"cap4.form.design.tips5");
        }
        return "true";
    }

    @Override
    public List<CAP4FormOperationBaseManager> getCheckManagerList(int formType) {
        Enums.FormType typeEnum = Enums.FormType.getEnumByKey((int)formType);
        if (typeEnum == null) {
            return null;
        }
        return this.getCheckManagerList(typeEnum);
    }

    @Override
    public List<CAP4FormOperationBaseManager> getCheckManagerList(Enums.FormType formType) {
        ArrayList<CAP4FormOperationBaseManager> result = new ArrayList<CAP4FormOperationBaseManager>();
        for (CAP4FormOperationBaseManager temp : this.designManagers) {
            if (!temp.canUse4FormType(formType)) continue;
            result.add(temp);
        }
        Collections.sort(result, FormCollectionAscSortComparator.getInstance());
        return result;
    }

    @Override
    public CAP4FormOperationBaseManager getCheckManager(String managerId) {
        return this.designManagerMap.get(managerId);
    }

    @Override
    @AjaxAccess
    public boolean bizConfigPublish(FormBean formBean) throws BusinessException {
        BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(formBean.getId());
        if (capBizConfig != null) {
            return capBizConfig.isPublishedConfig();
        }
        return formBean.getPublishFlag() == 1;
    }

    @ListenEvent(event=UserLogoutEvent.class, async=true)
    public void listenEventUserLogout(UserLogoutEvent event) {
        List users = event.getUsers();
        if (Strings.isNotEmpty((Collection)users)) {
            for (UserLogoutEvent.LogoutUser user : users) {
                OnlineUser ou = user.getUser();
                if (ou == null) continue;
                this.removeEditFormByUser(false, ou.getInternalId());
            }
        }
    }

    @Override
    public boolean cleanFormTestData(String formId) throws BusinessException {
        LOGGER.info((Object)("\u7528\u6237\uff1a" + AppContext.currentUserId() + ",\u65f6\u95f4\uff1a" + DateUtil.currentDateDefaultString() + ",\u8868\u5355ID\uff1a" + formId + ",\u6267\u884c\u8868\u5355\u6570\u636e\u6e05\u7406\u3002"));
        ArrayList<String> tableName = new ArrayList<String>();
        String[] formIds = formId.split(",");
        StringBuilder hql = new StringBuilder();
        hql.append(" from CtpContentAll cc");
        hql.append(" where cc.contentTemplateId = :contentTemplateId");
        hql.append(" and cc.contentDataId is not null");
        for (String fId : formIds) {
            FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(fId));
            if (null == fb) {
                return false;
            }
            if (fb.getState() == Enums.FormStateEnum.draft.getKey()) continue;
            try {
                HashMap<String, Long> param = new HashMap<String, Long>();
                param.put("contentTemplateId", fb.getId());
                List contentAll = this.ctpMainbodyManager.getContentList(hql.toString(), param);
                if (Strings.isNotEmpty((Collection)contentAll)) {
                    ArrayList<Long> moduleIds = new ArrayList<Long>();
                    ArrayList<Long> dataIds = new ArrayList<Long>();
                    for (CtpContentAll content : contentAll) {
                        moduleIds.add(content.getModuleId());
                        dataIds.add(content.getContentDataId());
                    }
                    this.attachmentManager.deleteByReference(moduleIds);
                    this.publicQrCodeManager.deletePublicQrCodeByObjectIds(dataIds);
                }
                List tableList = fb.getTableList();
                for (FormTableBean table : tableList) {
                    tableName.add(table.getTableName());
                }
                this.collaborationApi.deleteCollDatasPhysical(fb.getId());
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u5220\u9664\u8868\u5355" + fb.getId() + "\u6d4b\u8bd5\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        boolean isSuccess = true;
        if (Strings.isNotEmpty(tableName)) {
            isSuccess = this.cap4FormDataDAO.deleteAllFormDataByTableName(tableName);
        }
        return isSuccess;
    }

    @Override
    public boolean validateProcessMonitor(String monitorArray, String templateId, String formId) throws BusinessException {
        if (CDPAgent.isEnabled() && AppContext.hasPlugin((String)"ai")) {
            try {
                FormBean fb = this.getEditingForm(false, Long.parseLong(formId));
                List newTemplateList = fb.getBind().getFlowTemplateList();
                ArrayList<Object> allMonitor = new ArrayList<Object>();
                if (Strings.isNotBlank((String)monitorArray)) {
                    allMonitor.addAll((Collection)JSONUtil.parseJSONString((String)monitorArray, List.class));
                }
                for (CtpTemplate template : newTemplateList) {
                    if ((template.getId() + "").equals(templateId)) continue;
                    String processMonitorJSON = (String)template.getExtraAttr("FLOW_TEMPLATE_EXT_PROCESS_MONITOR");
                    List processMonitorList = null;
                    processMonitorList = Strings.isBlank((String)processMonitorJSON) ? this.aiApi.getByTemplateId(Long.valueOf(template.getId())) : (List)JSONUtil.parseJSONString((String)processMonitorJSON, List.class);
                    if (processMonitorList == null || processMonitorList.isEmpty()) continue;
                    for (Object obj : processMonitorList) {
                        allMonitor.add(JSONUtil.parseJSONString((String)JSONUtil.toJSONString(obj)));
                    }
                }
                if (allMonitor.isEmpty()) {
                    return false;
                }
                return AIUtil.checkRepeatMonitor(allMonitor);
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u68c0\u67e5\u667a\u80fd\u6d41\u7a0b\u76d1\u63a7\u9879\u62a5\u9519\uff1a", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    @AjaxAccess
    public List bussinessList() throws BusinessException {
        return this.businessManager4.getBusinessList4CurrentUser();
    }

    @Override
    @AjaxAccess
    public Map<String, Object> saveAs(Map<String, Object> params) throws BusinessException {
        FormSaveAsBean saveAsBean = new FormSaveAsBean();
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormBean newFormBean = null;
        try {
            FormBean fb;
            BizConfigBean oldBizConfig;
            String formname = (String)params.get("formnewname");
            String formId = (String)params.get("formId");
            String bizId = (String)params.get("bizId");
            if (!StringUtil.checkNull((String)bizId)) {
                saveAsBean.setSaveToBizId(Long.valueOf(Long.parseLong(bizId)));
            }
            if (null != (oldBizConfig = this.businessManager4.findBizConfigByFormId((fb = this.cap4FormManager.getEditingForm(Long.parseLong(formId))).getId()))) {
                saveAsBean.setOldBizId(oldBizConfig.getId());
            }
            try {
                newFormBean = (FormBean)fb.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BusinessException("\u8868\u5355\u62f7\u8d1d\u5f02\u5e38");
            }
            saveAsBean.setOldFormBean(fb);
            saveAsBean.handleFormSimpleInfo(newFormBean, formname, bizId, saveAsBean);
            int count = newFormBean.getTableList().size();
            Long num = this.formManager.getFormTableNumber(count);
            ArrayList tables = new ArrayList();
            saveAsBean.handleMasterTable(newFormBean, num, saveAsBean.getHtTable(), saveAsBean.getTableName(), tables);
            num = num + 1L;
            saveAsBean.handleSubTable(newFormBean, num, saveAsBean.getHtTable(), saveAsBean.getTableName(), tables);
            newFormBean.setTableList(tables);
            ArrayList directSaveList = new ArrayList();
            ArrayList<FormSerialNumber> serialnumbers = new ArrayList<FormSerialNumber>();
            Set<Long> serialNumberIds = this.cap4SerialNumberManager.getSerialNumber4FormBean(newFormBean);
            for (Long l : serialNumberIds) {
                FormSerialNumber formSerialNumber = this.serialNumberManager.querySerialNumberById(l);
                serialnumbers.add(formSerialNumber);
            }
            ArrayList<FormSerialNumber> serialNumbers = new ArrayList<FormSerialNumber>();
            for (FormSerialNumber formSerialNumber : serialnumbers) {
                FormSerialNumber newFormSerialNumber = this.handleSerialNumber(saveAsBean, formSerialNumber);
                serialNumbers.add(newFormSerialNumber);
            }
            saveAsBean.setFormSerialNumberList(serialNumbers);
            directSaveList.addAll(serialNumbers);
            DBAgent.saveAll(directSaveList);
            this.formCacheManager.initFormSerialNumber(serialNumbers);
            List<CAP4FormOperationBaseManager> list = this.getCheckManagerList(newFormBean.getFormType());
            Iterator<CAP4FormOperationBaseManager> managers = list.iterator();
            while (managers.hasNext()) {
                managers.next().formSaveAs(newFormBean, saveAsBean);
            }
            newFormBean.getBind().setFormCode(null);
            ArrayList<FormConditionActionBean> newCheckRuleList = new ArrayList<FormConditionActionBean>();
            FormCheckRuleBean newCheckRuleBean = newFormBean.getCheckRuleBean();
            if (newCheckRuleBean != null) {
                for (FormConditionActionBean conditionBean : newCheckRuleBean.getCheckRuleList()) {
                    FormConditionActionBean formConditionActionBean = newFormBean.getFormConditionActionBean(null, conditionBean.getConditionFormula(), conditionBean.getResultFormula(), conditionBean.getActionType().intValue(), null, conditionBean.getSortNumber().intValue(), conditionBean.getKeyword(), conditionBean.getDescription(), conditionBean.getAllFormulaList() != null && conditionBean.getAllFormulaList().size() > 0 ? ((CtpFormula)conditionBean.getAllFormulaList().get(0)).getDescription() : null, conditionBean.getForceCheck().intValue());
                    formConditionActionBean.setShowDetail(Integer.valueOf(conditionBean.getShowDetail()));
                    newCheckRuleList.add(formConditionActionBean);
                }
                newCheckRuleBean.setCheckRuleList(newCheckRuleList);
            }
            List customFunctionList = newFormBean.getCustomFunctionList();
            for (FormCustomFunction formCustomFunction : customFunctionList) {
                formCustomFunction.setNewId();
                formCustomFunction.setFormId(newFormBean.getId());
            }
            newFormBean.setFormTriggerIdList(null);
            newFormBean.setFormRelationshipIdList(null);
            if (Strings.isNotBlank((String)bizId)) {
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(bizId));
                if (null != bizConfigBean) {
                    newFormBean.setPublishFlag(bizConfigBean.getPublishFlag().intValue());
                }
                CapBizConfigItem capBizConfigItem = new CapBizConfigItem();
                capBizConfigItem.setIdIfNew();
                capBizConfigItem.setBizId(Long.valueOf(Long.parseLong(bizId)));
                capBizConfigItem.setFormId(newFormBean.getId());
                capBizConfigItem.setSort(Integer.valueOf(0));
                capBizConfigItem.setFormType(Integer.valueOf(0));
                capBizConfigItem.setCategoryId(Long.valueOf(-1L));
                capBizConfigItem.setCreateTime(DateUtil.currentDate());
                capBizConfigItem.setModifyTime(DateUtil.currentDate());
                DBAgent.save((Object)capBizConfigItem);
            }
            this.cap4FormManager.saveOrUpdateFormBean(newFormBean);
            result.put("formId", newFormBean.getId());
            result.put("success", true);
            return result;
        }
        catch (BusinessException businessException) {
            List formSerialNumberList = saveAsBean.getFormSerialNumberList();
            for (FormSerialNumber formSerialNumber : formSerialNumberList) {
                this.formCacheManager.removeFormSerialNumberBean(formSerialNumber.getId().longValue());
            }
            if (newFormBean != null && newFormBean.getId() != null) {
                this.cap4FormCacheManager.removeFormBean(newFormBean.getId());
            }
            LOGGER.error((Object)businessException.getMessage(), (Throwable)businessException);
            throw businessException;
        }
    }

    public FormSerialNumber handleSerialNumber(FormSaveAsBean saveAsBean, FormSerialNumber serialNumber_old) {
        Integer digit;
        Integer state;
        Long minValue;
        String version;
        String prefix;
        FormSerialNumber serialNumber = new FormSerialNumber();
        Long newId = saveAsBean.genNewIdByOldId(serialNumber_old.getId());
        serialNumber.setId(newId);
        Long serialFormId = serialNumber_old.getFormId();
        Long newFormId = saveAsBean.genNewIdByOldId(serialFormId);
        serialNumber.setFormId(newFormId);
        Integer ruleReset = serialNumber_old.getRuleReset();
        if (ruleReset != null) {
            serialNumber.setRuleReset(ruleReset);
        }
        if (!StringUtil.checkNull((String)(prefix = serialNumber_old.getPrefix()))) {
            serialNumber.setPrefix(prefix);
        }
        serialNumber.setCreateDate(new Date(System.currentTimeMillis()));
        String suffix = serialNumber_old.getSuffix();
        if (!StringUtil.checkNull((String)suffix)) {
            serialNumber.setSuffix(suffix);
        }
        if (!StringUtil.checkNull((String)(version = serialNumber_old.getVersion()))) {
            serialNumber.setVersion(version);
        }
        String textTimeFront = serialNumber_old.getTextTimeFront();
        serialNumber.setTextTimeFront(textTimeFront);
        Integer timeDate = serialNumber_old.getTimeDate();
        if (timeDate != null) {
            serialNumber.setTimeDate(timeDate);
        }
        if ((minValue = serialNumber_old.getMinValue()) != null) {
            serialNumber.setMinValue(minValue);
        } else {
            serialNumber.setMinValue(Long.valueOf(1L));
        }
        serialNumber.setAccountId(Long.valueOf(AppContext.currentAccountId()));
        String textTimeBehindStr = serialNumber_old.getTextTimeBehind();
        serialNumber.setTextTimeBehind(textTimeBehindStr);
        String variableName = serialNumber_old.getVariableName();
        String newVariableName = this.checkSerialNumberName(variableName);
        saveAsBean.addOldAndNewStringMap(variableName, newVariableName);
        serialNumber.setVariableName(newVariableName);
        Long numberStep = serialNumber_old.getNumberStep();
        if (numberStep != null) {
            serialNumber.setNumberStep(numberStep);
        }
        if ((state = serialNumber_old.getState()) != null) {
            serialNumber.setState(state);
        }
        serialNumber.setValue(serialNumber.getMinValue());
        Integer fixLenShow = serialNumber_old.getFixLenShow();
        if (fixLenShow != null) {
            serialNumber.setFixLenShow(fixLenShow);
        }
        if ((digit = serialNumber_old.getDigit()) != null) {
            serialNumber.setDigit(digit);
        }
        return serialNumber;
    }

    private String checkSerialNumberName(String name) {
        String returnName = name;
        FormSerialNumberBean fsnb = this.formCacheManager.getSerialNumberByName(name, Long.valueOf(AppContext.currentAccountId()));
        if (fsnb != null) {
            returnName = name + "1";
            return this.checkSerialNumberName(returnName);
        }
        return returnName;
    }

    @Override
    @AjaxAccess
    public String designFormBind(Map<String, Object> param) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String formId = param.get("formId") == null ? "" : String.valueOf(param.get("formId"));
            Long fId = Strings.isBlank((String)formId) ? 0L : Long.valueOf(formId);
            FormBean fb = this.checkAndLoadForm2Session(fId, "");
            resultMap.put("formName", fb.getFormName());
            FormBindBean bindBean = fb.getBind();
            if (fb.isFlowForm()) {
                ArrayList pendingList = new ArrayList();
                ArrayList integratedList = new ArrayList();
                Map flowBusinessMap = bindBean.getFlowBusinessMap();
                for (Map.Entry entry : flowBusinessMap.entrySet()) {
                    FormFlowBusinessBean flowBusiness = (FormFlowBusinessBean)entry.getValue();
                    HashMap<String, String> flowBusinessInfoMap = new HashMap<String, String>();
                    flowBusinessInfoMap.put("id", String.valueOf(flowBusiness.getId()));
                    flowBusinessInfoMap.put("name", flowBusiness.getName());
                    if (Enums.FlowBusinessType.PENDING.getKey().equals(flowBusiness.getType())) {
                        pendingList.add(flowBusinessInfoMap);
                        continue;
                    }
                    integratedList.add(flowBusinessInfoMap);
                }
                resultMap.put("listType", Enums.FlowBusinessType.values());
                resultMap.put("fixBtn", Enums.FlowBusinessFixField.values());
                resultMap.put("pendingList", pendingList);
                resultMap.put("integratedList", integratedList);
            } else {
                resultMap.put("formCode", bindBean.getFormCode());
                List logFieldList = bindBean.getLogFieldList();
                String logs = "";
                String logsId = "";
                for (String log : logFieldList) {
                    logsId = logsId + log + ",";
                    logs = logs + fb.getFieldBeanByName(log.substring(log.indexOf(".") + 1)).getDisplay() + ",";
                }
                resultMap.put("logsId", "".equals(logsId) ? "" : logsId.substring(0, logsId.length() - 1));
                resultMap.put("logs", "".equals(logs) ? "" : logs.substring(0, logs.length() - 1));
                ArrayList bindAuthInfoList = new ArrayList();
                Map bindAuthBeanMap = bindBean.getUnFlowTemplateMap();
                for (Map.Entry entry : bindAuthBeanMap.entrySet()) {
                    FormBindAuthBean bindAuthBean = (FormBindAuthBean)entry.getValue();
                    HashMap<String, String> bindAuthInfoMap = new HashMap<String, String>();
                    bindAuthInfoMap.put("id", String.valueOf(bindAuthBean.getId()));
                    bindAuthInfoMap.put("name", bindAuthBean.getName());
                    bindAuthInfoList.add(bindAuthInfoMap);
                }
                resultMap.put("bindAuthList", bindAuthInfoList);
                resultMap.put("allViewAuthList", fb.getAuth4BindDesign());
            }
            resultMap.put("showPosition", FormBindAuthBean.ShowPosition.getJsonString());
            List canUseBtns = FormFieldUtil.getCanUseBindBtnMapInfos((Enums.FormType)Enums.FormType.getEnumByKey((int)fb.getFormType()));
            resultMap.put("customBtns", canUseBtns);
            resultMap.put("success", "true");
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u5e94\u7528\u7ed1\u5b9a\u7f16\u8f91\u5f02\u5e38\uff01" + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("error", ResourceUtil.getString((String)"cap4.form.design.tips6"));
        }
        return JSONUtil.toJSONString(resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> importView(String fileId) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String tempContent = "";
        if (StringUtil.checkNull((String)fileId)) {
            throw new BusinessException("fileId should not be null!");
        }
        Long fileIdLong = Long.parseLong(fileId);
        File importFile = this.fileManager.getFile(fileIdLong, DateUtil.currentDate());
        if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.specified.file.tips"));
        }
        String unZipDir = BusinessExportConstant.TEMP_DIR + File.separator + UUIDLong.absLongUUID();
        File unZipFile = new File(unZipDir);
        try {
            ZipUtil.unzip((File)importFile, (File)unZipFile, (String)"ahfhaflafpon");
            File[] files = unZipFile.listFiles()[0].listFiles();
            File jsonFile = null;
            File viewsFileFolder = null;
            File attachmentFile = null;
            File extensionFile = null;
            for (File tempFile : files) {
                if (tempFile.isFile() && "cappackageinfo.json".equals(tempFile.getName())) {
                    jsonFile = tempFile;
                    continue;
                }
                if (tempFile.isFile() && "extension.json".equals(tempFile.getName())) {
                    extensionFile = tempFile;
                    continue;
                }
                if (tempFile.isDirectory() && "views".equals(tempFile.getName())) {
                    viewsFileFolder = tempFile;
                    continue;
                }
                if (!tempFile.isDirectory() || !"attachment".equals(tempFile.getName())) continue;
                attachmentFile = tempFile;
            }
            if (null == jsonFile) {
                String jsonFileNullMsg = "cappackageinfo.json can not be null!";
                LOGGER.error((Object)jsonFileNullMsg);
                throw new BusinessException(jsonFileNullMsg);
            }
            if (null == viewsFileFolder) {
                String viewFileNullMsg = "views can not be null!";
                LOGGER.error((Object)viewFileNullMsg);
                throw new BusinessException(viewFileNullMsg);
            }
            if (null == attachmentFile || !attachmentFile.isDirectory()) {
                String attFileNullMsg = "attachment can not be null!";
                LOGGER.error((Object)attFileNullMsg);
                throw new BusinessException(attFileNullMsg);
            }
            File[] background = attachmentFile.listFiles();
            String packageStr = FileUtils.readFileToString((File)jsonFile, (String)"UTF-8");
            Map packageMap = (Map)JSONUtil.parseJSONString((String)packageStr);
            if (!"view".equals(packageMap.get("type"))) {
                throw new BusinessException("this package is not view package!");
            }
            File[] viewFile = viewsFileFolder.listFiles();
            if (viewFile.length != 1) {
                throw new BusinessException("size of view file is not one!");
            }
            try {
                tempContent = FileUtils.readFileToString((File)viewFile[0], (String)"UTF-8");
            }
            catch (IOException e) {
                throw new BusinessException("read view file error!");
            }
            Matcher matcher = BusinessFormExportManager4FormView.pattern.matcher(tempContent);
            StringBuffer sb = new StringBuffer();
            String uploadFolder = "";
            Date now = new Date(System.currentTimeMillis());
            String nowStr = DateUtil.format((Date)now, (String)"yyyy-MM-dd");
            try {
                uploadFolder = this.fileManager.getFolder(now, true);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            HashMap<String, String> oldNewMap = new HashMap<String, String>();
            while (matcher.find()) {
                String oldFileName = matcher.group(2);
                Long newFileNameId = UUIDLong.longUUID();
                String newFileName = String.valueOf(newFileNameId);
                for (File att : background) {
                    if (!att.getName().equals(oldFileName)) continue;
                    File newAttFile = new File(uploadFolder + File.separator + newFileName);
                    try {
                        newAttFile.createNewFile();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    FileUtil.copyFile((File)att, (File)newAttFile);
                    oldNewMap.put(oldFileName, newFileName);
                    break;
                }
                matcher.appendReplacement(sb, "&createDate=" + nowStr + "&fileId=" + newFileName);
            }
            matcher.appendTail(sb);
            String contentStr = sb.toString();
            for (Map.Entry entry : oldNewMap.entrySet()) {
                contentStr = contentStr.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            resultMap.put("viewContent", contentStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            new BusinessException((Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)unZipFile);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> importViewOrForm4Mall(Map<String, Object> params) throws BusinessException {
        String fileType = (String)params.get("fileType");
        String fileUrl = (String)params.get("fileUrl");
        String fileId = "0";
        String fileName = String.valueOf(UUIDLong.absLongUUID());
        File file = new File(BusinessExportConstant.TEMP_DIR, fileName);
        boolean downloadResult = HttpClientUtil.doHttpFileDownload(fileUrl, file);
        if (!downloadResult) {
            String errorMsg = "Failed to download files from mall,The fileUrl is:" + fileUrl;
            LOGGER.error((Object)errorMsg);
            throw new BusinessException(errorMsg);
        }
        V3XFile v3XFile = this.fileManager.save(file, ApplicationCategoryEnum.cap4Form, fileName, DateUtil.currentDate(), Boolean.valueOf(false));
        fileId = String.valueOf(v3XFile.getId());
        Map<String, Object> resultMap = null;
        if ("view".equals(fileType)) {
            resultMap = this.importView(fileId);
        } else {
            String bizConfigId = (String)params.get("bizConfigId");
            String from = "";
            if (StringUtil.checkNull((String)bizConfigId)) {
                bizConfigId = "0";
            }
            from = "0".equals(bizConfigId) ? BusinessEnums.ExportType.FORM.getKey() : BusinessEnums.ExportType.APPLICATION.getKey();
            int importType = Integer.parseInt(String.valueOf(params.get("importType")));
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("from", from);
            paramMap.put("fileId", fileId);
            paramMap.put("bizConfigId", bizConfigId);
            paramMap.put("formType", importType);
            resultMap = this.businessImportAndExportManager.formSetup(paramMap);
        }
        return resultMap;
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> exportView(Map<String, Object> params) throws BusinessException {
        String paramName = "viewContent";
        if (!params.containsKey(paramName)) {
            throw new BusinessException("\u6ca1\u6709\u4f20\u5165\u89c6\u56fe\u5185\u5bb9viewContent\uff0c\u8bf7\u4f20\u5165\u89c6\u56fe\u5185\u5bb9\uff01");
        }
        String viewName = (String)params.get("viewName");
        String viewContent = (String)params.get(paramName);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        StringBuilder url = new StringBuilder();
        String fileId = String.valueOf(date.getTime());
        if (StringUtil.checkNull((String)viewName)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"\u5bfc\u51fa\u89c6\u56fe\u7684\u65f6\u5019\u6ca1\u6709\u4f20\u5165\u89c6\u56fe\u540d\u79f0\uff01\u91c7\u7528\u968f\u673a\u540d\u79f0");
            }
            viewName = fileId;
        }
        url.append("fileUpload.do?method=download&fileId=").append(fileId);
        url.append("&createDate=").append(DateUtil.format((Date)date));
        url.append("&v=").append(SecurityHelper.digest((Object[])new Object[]{fileId})).append("&filename=").append(viewName).append(".fview");
        resultMap.put("fileurl", url.toString());
        String baseFolder = this.fileManager.getNowFolder(true);
        Long subFolder = UUIDLong.absLongUUID();
        String rootPath = baseFolder + File.separator + String.valueOf(subFolder) + File.separator;
        CapUtil.writeFile((String)(rootPath + "views" + File.separator), (String)(String.valueOf(subFolder) + ".view"), (String)viewContent);
        Map extensionInfo = CapUtil.generateExtensionInfoMap();
        CapUtil.writeFile((String)rootPath, (String)"extension.json", (String)JSONUtil.toJSONString((Object)extensionInfo));
        HashMap<String, String> packageInfoMap = new HashMap<String, String>();
        packageInfoMap.put("type", "view");
        CapUtil.writeFile((String)rootPath, (String)"cappackageinfo.json", (String)JSONUtil.toJSONString(packageInfoMap));
        try {
            File attFile = new File(rootPath + "attachment" + File.separator);
            if (!attFile.exists()) {
                attFile.mkdirs();
            }
            Matcher matcher = FormViewBean.pattern.matcher(viewContent);
            FileManager fileManager = (FileManager)AppContext.getBean((String)"fileManager");
            while (matcher.find()) {
                String createDate = matcher.group(1);
                String fileIdStr = matcher.group(2);
                Long imgFileId = Long.parseLong(fileIdStr);
                File file = fileManager.getFile(imgFileId, DateUtil.parse((String)createDate, (String)"yyyy-MM-dd"));
                if (null != file && file.exists()) {
                    File destination = new File(rootPath + "attachment" + File.separator + fileIdStr);
                    if (!destination.exists()) {
                        destination.createNewFile();
                    }
                    FileUtil.copyFile((File)file, (File)destination);
                    continue;
                }
                LOGGER.info((Object)("\u9644\u4ef6(id:" + fileIdStr + " createDate:" + createDate + ") \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u62f7\u8d1d\uff01"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        File rootFile = new File(rootPath);
        String toFileName = rootFile.getParent() + File.separator + fileId;
        File toFile = new File(toFileName);
        try {
            ZipUtil.zip((File)rootFile, (File)toFile, (String)"ahfhaflafpon", (boolean)true);
        }
        catch (ZipException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)rootFile);
        }
        return resultMap;
    }

    @Override
    @AjaxAccess
    public String quickCreateField(Map<String, String> param) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String type = param.get("type");
            String id = String.valueOf(param.get("id"));
            String formType = param.get("formType");
            String tableType = param.get("tableType");
            if (Strings.isNotEmpty((String)type)) {
                if ("biz".equals(type)) {
                    HashMap bizInfoMap;
                    ArrayList bizInfoMapList = new ArrayList();
                    List bizList = this.businessManager4.getBusinessList4CurrentUser(true);
                    if (Strings.isNotEmpty((Collection)bizList)) {
                        for (Map en : bizList) {
                            bizInfoMap = new HashMap();
                            bizInfoMap.put("id", en.get("id"));
                            bizInfoMap.put("name", en.get("name"));
                            bizInfoMapList.add(bizInfoMap);
                        }
                    }
                    bizInfoMap = new HashMap();
                    bizInfoMap.put("id", "-1");
                    bizInfoMap.put("name", ResourceUtil.getString((String)"cap.form.business.formmanagement"));
                    bizInfoMapList.add(bizInfoMap);
                    resultMap.put("info", bizInfoMapList);
                } else if (Strings.isNotEmpty((String)id)) {
                    if ("form".equals(type)) {
                        ArrayList formInfoMapList = new ArrayList();
                        if ("-1".equals(id)) {
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("ownerId", AppContext.currentUserId());
                            params.put("orgAccountId", AppContext.currentAccountId());
                            FlipInfo fi = new FlipInfo();
                            fi.setSize(-1);
                            List<Map<String, Object>> listMap = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(fi, params);
                            if (Strings.isNotEmpty(listMap)) {
                                for (Map<String, Object> en : listMap) {
                                    HashMap<String, Object> formInfoMap = new HashMap<String, Object>();
                                    formInfoMap.put("id", en.get("id"));
                                    formInfoMap.put("name", en.get("formName"));
                                    formInfoMapList.add(formInfoMap);
                                }
                            }
                        } else {
                            List<FormBean> formBeanList = this.businessManager4.getFormBeanListByBizId(Long.valueOf(id));
                            if (Strings.isNotEmpty(formBeanList)) {
                                for (FormBean form : formBeanList) {
                                    HashMap<String, Object> formInfoMap = new HashMap<String, Object>();
                                    formInfoMap.put("id", form.getId());
                                    formInfoMap.put("name", form.getFormName());
                                    formInfoMapList.add(formInfoMap);
                                }
                            }
                        }
                        resultMap.put("info", formInfoMapList);
                    } else if ("field".equals(type)) {
                        FormBean form = this.cap4FormCacheManager.getForm(Long.valueOf(id));
                        List fieldBeanList = form.getAllFieldBeans();
                        ArrayList fieldInfoMapList = new ArrayList();
                        for (FormFieldBean field : fieldBeanList) {
                            if (FormFieldComEnum.LINE_NUMBER.getKey().equals(field.getInputType()) || ("unflow".equals(formType) || "sub".equals(tableType)) && FormFieldComEnum.FLOWDEALOPITION.getKey().equals(field.getInputType())) continue;
                            HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>();
                            fieldInfoMap.put("name", field.getName());
                            fieldInfoMap.put("display", field.getDisplay());
                            fieldInfoMap.put("type", field.getInputType());
                            fieldInfoMap.put("fieldType", field.getFieldType());
                            fieldInfoMap.put("fieldLength", field.getFieldLength());
                            fieldInfoMap.put("digitNum", field.getDigitNum());
                            fieldInfoMap.put("formatType", field.getFormatType());
                            if (field.isEnumField()) {
                                fieldInfoMap.put("enumInfo", field.getEnumParams());
                                EnumManager selectManager = (EnumManager)AppContext.getBean((String)"enumManagerNew");
                                try {
                                    fieldInfoMap.put("enumName", selectManager.getENameById(Long.valueOf(field.getEnumId())));
                                }
                                catch (BusinessException e) {
                                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            fieldInfoMap.put("isCustomCtrl", field.isCustomerCtrl());
                            fieldInfoMap.put("desc", field.getDesc());
                            fieldInfoMapList.add(fieldInfoMap);
                        }
                        resultMap.put("info", fieldInfoMapList);
                    }
                }
            }
            resultMap.put("success", "true");
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u5feb\u901f\u751f\u6210\u5b57\u6bb5\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("error", "\u5feb\u901f\u751f\u6210\u5b57\u6bb5\u63a5\u53e3\u5f02\u5e38");
        }
        return JSONUtil.toJSONString(resultMap);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setWapi(WorkflowApiManager wapi) {
        this.wapi = wapi;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public MainbodyManager getCtpMainbodyManager() {
        return this.ctpMainbodyManager;
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    public CollaborationApi getCollaborationApi() {
        return this.collaborationApi;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setAiApi(AIApi aiApi) {
        this.aiApi = aiApi;
    }

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setSerialNumberManager(SerialNumberManager serialNumberManager) {
        this.serialNumberManager = serialNumberManager;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public void setCapLogDAO(CapLogDAO capLogDAO) {
        this.capLogDAO = capLogDAO;
    }
}

