/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.field;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.field.CAP4FormFieldDesignManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.constants.ProductVersionEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class CAP4FormFieldDesignController
extends BaseController {
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormFieldDesignManager cap4FormFieldDesignManager;
    private FileManager fileManager;
    private EnumManager enumManagerNew;
    private OrgManager orgManager;
    private TemplateManager templateManager;
    private AttachmentManager attachmentManager;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormFieldDesignController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView removeEditingForm(HttpServletRequest request, HttpServletResponse response) {
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        PrintWriter out = null;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            this.cap4FormManager.removeEditForm(formId);
            out = response.getWriter();
            result.put("success", true);
        }
        catch (IOException e) {
            result.put("success", false);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                out.println(JSONUtil.toJSONString(result));
                out.flush();
                out.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView headerJs(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("expires", -1L);
            out = response.getWriter();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                String resSuffix = "?V=" + ProductVersionEnum.getCurrentVersion().name() + "_" + SystemProperties.getInstance().getProperty("product.build.date") + "_" + SystemEnvironment.getPluginCRC();
                out.println(StringEscapeUtils.escapeHtml((String)("var _locale = '" + AppContext.getLocale() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _ctxPath = '" + request.getContextPath() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _ctxServer= '" + request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _isDevelop= '" + AppContext.isRunningModeDevelop() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _sessionid = '" + request.getSession().getId() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _editionI18nSuffix = '" + ProductEditionEnum.getCurrentProductEditionEnum().getI18nSuffix() + "';")));
                out.println(StringEscapeUtils.escapeHtml((String)("var _resSuffix = '" + resSuffix + "';")));
                HttpSession session = AppContext.getRawSession();
                Object token = null;
                token = session == null ? "" : session.getAttribute("CSRFTOKEN");
                if (StringUtil.checkNull((String)String.valueOf(token))) {
                    token = "";
                }
                out.println(StringEscapeUtils.escapeHtml((String)("var CSRFTOKEN= '" + token + "';")));
                out.flush();
                out.close();
            }
        }
        return null;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView formulaAdvanceSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/fieldDesign/advanceSet4CAP4");
        String fieldType = request.getParameter("fieldType");
        String formId = request.getParameter("formId");
        String receiverId = request.getParameter("receiverId");
        fieldType = Strings.escapeJavascript((String)fieldType);
        formId = Strings.escapeJavascript((String)formId);
        receiverId = Strings.escapeJavascript((String)receiverId);
        mav.addObject("fieldType", (Object)fieldType);
        mav.addObject("formId", (Object)formId);
        mav.addObject("receiverId", (Object)receiverId);
        mav.addObject("calType", (Object)receiverId);
        return mav;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView setFlowdealoptionFormat(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/fieldDesign/setFlowdealoptionsFormat");
        String formatStr = request.getParameter("formatStr");
        ArrayList<Enums.FlowDealOptionsType> opinionTypes = new ArrayList<Enums.FlowDealOptionsType>();
        for (Enums.FlowDealOptionsType entity : Enums.FlowDealOptionsType.values()) {
            opinionTypes.add(entity);
        }
        mav.addObject("formatStr", (Object)formatStr);
        mav.addObject("hasSetted", (Object)Strings.isNotBlank((String)formatStr));
        mav.addObject("opinionTypes", opinionTypes);
        return mav;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView subTableRelationSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("ctp/form/design/fieldDesign/subTableRelationSet");
        String step = request.getParameter("step");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId");
        FormBean fb = this.cap4FormManager.getEditingForm(formId);
        if ("2".equals(step)) {
            mav = new ModelAndView("ctp/form/design/fieldDesign/dataRelationSet");
            String fromSub = request.getParameter("fromSub");
            String toSub = request.getParameter("toSub");
            mav.addObject("fromSub", (Object)fromSub);
            mav.addObject("toSub", (Object)toSub);
            FormTableBean fromTable = fb.getTableByTableName(fromSub);
            FormTableBean toTable = fb.getTableByTableName(toSub);
            mav.addObject("fromFieldList", (Object)fromTable.getFields());
            mav.addObject("toFieldList", (Object)toTable.getFields());
        }
        if (fb != null) {
            mav.addObject("subTables", (Object)fb.getSubTableBean());
        }
        return mav;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView formAdvancedSet(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView("cap4/form/design/fieldDesign/formAdvancedSet");
        String formId = request.getParameter("formId");
        FormBean editingForm = this.cap4FormManager.getEditingForm(Long.valueOf(formId));
        HashMap<String, Map> advancedSet = editingForm.getAdvancedSet();
        ArrayList<String> displayNames = new ArrayList<String>();
        if (null != advancedSet && advancedSet.containsKey("repealAndEmpty")) {
            String repealAndEmpty = (String)advancedSet.get("repealAndEmpty");
            Map set = (Map)JSONUtil.parseJSONString((String)repealAndEmpty, Map.class);
            String type = (String)set.get("type");
            if ("custom".equals(type)) {
                String showFieldList = (String)set.get("showFieldList");
                List<String> fields = Arrays.asList(showFieldList.split(","));
                List allFieldBeans = editingForm.getAllFieldBeans();
                for (String fieldName : fields) {
                    for (FormFieldBean formFieldBean : allFieldBeans) {
                        if (!fieldName.equals(formFieldBean.getName())) continue;
                        displayNames.add(formFieldBean.getDisplay());
                    }
                }
                set.put("showFieldListText", ((Object)displayNames).toString());
            }
            advancedSet.put("repealAndEmpty", set);
        } else {
            advancedSet = new HashMap<String, Map>();
        }
        mav.addObject("advancedSet", advancedSet);
        mav.addObject("isFlow", (Object)editingForm.isFlowForm());
        return mav;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView repealAndEmpty(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView("cap4/form/design/fieldDesign/repealAndEmptySet");
        return mav;
    }

    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public ModelAndView advanceCheckRuleSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/design/fieldDesign/advanceCheckRuleSet");
        mav.addObject("formId", (Object)request.getParameter("formId"));
        return mav;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public CAP4FormFieldDesignManager getCap4FormFieldDesignManager() {
        return this.cap4FormFieldDesignManager;
    }

    public void setCap4FormFieldDesignManager(CAP4FormFieldDesignManager cap4FormFieldDesignManager) {
        this.cap4FormFieldDesignManager = cap4FormFieldDesignManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

