/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.field;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionInitManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;

public class CAP4FormFieldInitManagerImpl
implements CAP4FormDefinitionInitManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormFieldInitManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    @Override
    public void initDefinitionAttr(FormBean formBean, CAPFormDefinition formDefinition) throws BusinessException {
        if (Strings.isNotEmpty((String)formDefinition.getFieldInfo())) {
            Map fieldInfo = (Map)JSONUtil.parseJSONString((String)formDefinition.getFieldInfo());
            Map masterTableInfo = (Map)fieldInfo.get("front_formmain");
            List subInfos = (List)fieldInfo.get("formsons");
            ArrayList<Map> tableInfoMaps = new ArrayList<Map>();
            tableInfoMaps.add(masterTableInfo);
            tableInfoMaps.addAll(subInfos);
            int index = 0;
            for (Map tableInfoMap : tableInfoMaps) {
                FormTableBean tableBean = this.initFormTable(tableInfoMap, formBean.getId(), index);
                ++index;
                this.cap4FormCacheManager.addTable(tableBean.getTableName(), tableBean, formBean.getId());
                formBean.getTableList().add(tableBean);
            }
        }
    }

    FormTableBean initFormTable(Map<String, Object> tableInfo, Long formId, int tableIndex) throws BusinessException {
        List fieldInfoMaps;
        String tableType;
        String tableName;
        if (tableInfo == null) {
            throw new BusinessException("Table\u4fe1\u606f\u6ca1\u6709\u4f20\u5165");
        }
        FormTableBean tempFormTableBean = new FormTableBean();
        Long id = tableInfo.get("id") == null ? 0L : Long.valueOf(tableInfo.get("id").toString());
        if (!id.equals(0L)) {
            tempFormTableBean.setId(id);
        }
        if ((tableName = (String)tableInfo.get("tableName")) == null) {
            throw new BusinessException("Table \u7684 name \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormTableBean.setTableName(tableName);
        String frontTableName = (String)tableInfo.get("frontTableName");
        if (frontTableName == null) {
            throw new BusinessException("Table \u7684 frontTableName \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormTableBean.setFrontTableName(frontTableName);
        String display = (String)tableInfo.get("display");
        if (display != null) {
            tempFormTableBean.setDisplay(display);
        }
        if ((tableType = (String)tableInfo.get("tableType")) == null) {
            throw new BusinessException("Table \u7684 tabletype \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormTableBean.setTableType(tableType);
        String ownerTable = (String)tableInfo.get("ownerTable");
        if (ownerTable == null) {
            throw new BusinessException("Table \u7684 ownerTable \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormTableBean.setOwnerTable(ownerTable);
        Object emptyLineRule = tableInfo.get("emptyLineRule");
        if (emptyLineRule != null) {
            tempFormTableBean.setEmptyLineRule(Integer.valueOf(emptyLineRule.toString()).intValue());
            tempFormTableBean.setEmptyLineFields((List)tableInfo.get("emptyLineFields"));
        }
        if ((fieldInfoMaps = (List)tableInfo.get("fieldInfo")) == null) {
            throw new BusinessException("fieldInfo\u8282\u70b9\u6ca1\u6709\u4f20\u5165");
        }
        tempFormTableBean.setFormId(formId);
        tempFormTableBean.setTableIndex(tableIndex);
        for (Map fitem : fieldInfoMaps) {
            FormFieldBean tempFieldBean = this.initFormField(fitem);
            if (null == tempFieldBean) continue;
            tempFieldBean.setFormConditionList(this.cap4FormCacheManager.getFieldFormulaCondition(tempFieldBean.getId()));
            tempFieldBean.setOwnerTableName(tempFormTableBean.getTableName());
            tempFieldBean.setOwnerTableDisplay(tempFormTableBean.getDisplay());
            tempFieldBean.setOwnerTableIndex(tableIndex);
            if (tempFieldBean.isConstantField()) continue;
            tempFormTableBean.addFormField(tempFieldBean);
            this.cap4FormCacheManager.addField(tempFieldBean.getId(), tempFieldBean, formId);
        }
        return tempFormTableBean;
    }

    private FormRelation loadFormRelationBean(Long relationId) throws BusinessException {
        FormRelation formRelation;
        ConcurrentMap<Long, FormRelation> relationMaps = this.cap4FormCacheManager.getRelations();
        if (relationMaps != null && (formRelation = (FormRelation)relationMaps.get(relationId)) != null) {
            return formRelation;
        }
        return null;
    }

    private FormFieldBean initFormField(Map<String, Object> fieldInfo) throws BusinessException {
        String enumInfo;
        String customParam;
        String inputType;
        String formatType;
        String desc;
        String display;
        if (fieldInfo == null) {
            throw new BusinessException("\u5b57\u6bb5\u5b9a\u4e49\u4fe1\u606f\u6ca1\u6709\u4f20\u5165\uff01");
        }
        FormFieldBean tempFormFieldBean = new FormFieldBean();
        String name = (String)fieldInfo.get("name");
        if (name == null) {
            throw new BusinessException("\u5b57\u6bb5\u5b9a\u4e49\u4fe1\u606f\u7684name \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormFieldBean.setName(name);
        if (tempFormFieldBean.isConstantField()) {
            return null;
        }
        String idStr = (String)fieldInfo.get("id");
        if (idStr != null) {
            tempFormFieldBean.setId(Long.valueOf(Long.parseLong(idStr)));
        }
        if ((display = (String)fieldInfo.get("display")) != null) {
            tempFormFieldBean.setDisplay(display);
        }
        if ((desc = (String)fieldInfo.get("desc")) != null) {
            tempFormFieldBean.setDesc(desc);
        }
        if ((formatType = (String)fieldInfo.get("formatType")) != null) {
            if (tempFormFieldBean.getInputTypeEnum() == FormFieldComEnum.FLOWDEALOPITION) {
                tempFormFieldBean.setFormatType(FormUtil.transOldFlowOption((String)formatType));
            } else {
                tempFormFieldBean.setFormatType(formatType);
            }
        }
        if ((inputType = (String)fieldInfo.get("type")) == null) {
            throw new BusinessException("FieldInput \u7684 type \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormFieldBean.setInputType(inputType);
        if (tempFormFieldBean.isCustomerCtrl() && null != (customParam = (String)fieldInfo.get("customParam"))) {
            tempFormFieldBean.setCustomParam(customParam);
        }
        String fieldType = (String)fieldInfo.get("fieldType");
        if (!tempFormFieldBean.isConstantField() && fieldType == null) {
            throw new BusinessException("FieldInput \u7684 fieldType \u5c5e\u6027\u672a\u5b9a\u4e49");
        }
        tempFormFieldBean.setFieldType(fieldType);
        String fieldLength = (String)fieldInfo.get("fieldLength");
        if (fieldLength != null && Strings.isNotBlank((String)fieldLength)) {
            String fl = fieldLength;
            if (fl.contains(",")) {
                String[] flenStrArr = fl.split(",");
                tempFormFieldBean.setFieldLength(flenStrArr[0]);
                tempFormFieldBean.setDigitNum(flenStrArr[1]);
            } else {
                tempFormFieldBean.setFieldLength(fl);
                tempFormFieldBean.setDigitNum("0");
            }
        }
        tempFormFieldBean.setNull(true);
        String relationId = (String)fieldInfo.get("relationId");
        if (!StringUtil.checkNull((String)relationId)) {
            tempFormFieldBean.setFormRelation(this.loadFormRelationBean(Long.parseLong(relationId)));
        }
        if (!StringUtil.checkNull((String)(enumInfo = (String)fieldInfo.get("enumInfo")))) {
            tempFormFieldBean.setEnumParams(enumInfo);
        }
        String formulaInfo = (String)fieldInfo.get("formulaInfo");
        if (FormFieldComEnum.EXTEND_IMAGE.equals((Object)tempFormFieldBean.getInputTypeEnum())) {
            String maxImgSize = (String)fieldInfo.get("maxImgSize");
            if (!StringUtil.checkNull((String)maxImgSize)) {
                tempFormFieldBean.setMaxImgSize(Integer.parseInt(maxImgSize));
            } else {
                tempFormFieldBean.setMaxImgSize(1);
            }
        }
        return tempFormFieldBean;
    }

    public Integer getSort() {
        return 1;
    }
}

