/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula;

import com.seeyon.cap4.form.modules.engin.formula.CAP4FormCustomFunctionManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.modules.engin.formula.FormCustomFunctionDAO;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.service.FormCache;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormCustomFunctionManagerImpl
implements CAP4FormCustomFunctionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormCustomFunctionManagerImpl.class);
    private FormCustomFunctionDAO formCustomFunctionDAO;
    private CAP4FormManager cap4FormManager;
    private FileManager fileManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private OrgManager orgManager;
    private FormCacheManager formCacheManager;

    @Override
    @AjaxAccess
    public FlipInfo customFunctionList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        String formulaType = params.get("returnType") == null ? "" : params.get("returnType").toString();
        String componentType = params.get("componentType") == null ? "" : params.get("componentType").toString();
        int returnType = FormulaEnums.CustomFunctionType.VARCHAR.getKey();
        returnType = "componentType_condition".equals(componentType) ? FormulaEnums.CustomFunctionType.BOOLEAN.getKey() : ("formulaType_number".equals(formulaType) || "auto_number".equals(formulaType) ? FormulaEnums.CustomFunctionType.DECIMAL.getKey() : FormulaEnums.CustomFunctionType.VARCHAR.getKey());
        Long formId = params.get("formId") == null ? 0L : Long.parseLong(params.get("formId").toString());
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getForm(formId);
        List customList = form.getCustomFunctionList();
        ArrayList<FormCustomFunction> newList = new ArrayList<FormCustomFunction>();
        if (form != null && customList != null) {
            for (FormCustomFunction custom : customList) {
                if (custom.getReturnType() != returnType) continue;
                newList.add(custom);
            }
        }
        ArrayList list = new ArrayList();
        for (FormCustomFunction formCustom : newList) {
            Enums.FormCustomFuncAuditEnum auditEnum;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", formCustom.getId());
            map.put("functionName", formCustom.getFunctionName());
            if (formCustom.getFunctionParam() != null && formCustom.getFunctionParam().split("\\|").length > 1) {
                map.put("functionParam", formCustom.getFunctionParam().split("\\|")[1]);
                map.put("selectParam", formCustom.getFunctionParam().split("\\|")[0]);
            } else {
                map.put("functionParam", "");
                map.put("selectParam", "");
            }
            map.put("codeType", "Groovy");
            map.put("returnType", FormulaEnums.CustomFunctionType.getEnumByKey((int)formCustom.getReturnType()).getText());
            if (formCustom.getAuditState() == null) {
                formCustom.setAuditState(Integer.valueOf(Enums.FormCustomFuncAuditEnum.AUDITEDPASS.getKey()));
            }
            map.put("auditState", (auditEnum = Enums.FormCustomFuncAuditEnum.getAuditEnumByKey((int)formCustom.getAuditState())) == null ? "" : auditEnum.getText());
            list.add(map);
        }
        fi.setData(list);
        fi.setTotal(list.size());
        return fi;
    }

    @Override
    @AjaxAccess
    public boolean checkFunctionName(Long _id, String functionName, Long formId) throws BusinessException {
        List list;
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getEditingForm(formId);
        Long id = _id == null ? 0L : _id;
        List customFunctionList = this.formCustomFunctionDAO.selectByName(functionName, Long.valueOf(form == null ? 0L : form.getId()));
        List list2 = list = form == null ? null : form.getCustomFunctionList();
        if (customFunctionList != null && customFunctionList.size() == 1 && customFunctionList.get(0) != null && ((FormCustomFunction)customFunctionList.get(0)).getId().longValue() != id.longValue() || customFunctionList != null && customFunctionList.size() > 1) {
            return true;
        }
        if (list != null) {
            boolean isExist = false;
            for (FormCustomFunction custom : list) {
                if (custom == null || !custom.getFunctionName().equals(functionName) || custom.getId().longValue() == id.longValue()) continue;
                isExist = true;
                break;
            }
            return isExist;
        }
        return false;
    }

    @Override
    public void addCache(FormCustomFunction formCustomFunction, Long formId) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getEditingForm(formId);
        if (form != null) {
            List oldList = form.getCustomFunctionList();
            oldList = oldList == null ? new ArrayList() : oldList;
            oldList.add(formCustomFunction);
            form.setCustomFunctionList(oldList);
            this.cap4FormManager.saveEditingForm(form);
        }
    }

    @Override
    public void updateCache(FormCustomFunction formCustomFunction, Long formId) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getEditingForm(formId);
        FormCustomFunction oldCustom = this.selectById(formCustomFunction == null ? 0L : formCustomFunction.getId(), formId);
        if (form != null) {
            List list = form.getCustomFunctionList();
            list.remove(oldCustom);
            list.add(formCustomFunction);
            form.setCustomFunctionList(list);
            this.cap4FormManager.saveEditingForm(form);
        }
    }

    @Override
    public FormCustomFunction selectById(Long id, Long formId) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getEditingForm(formId);
        List list = form == null ? null : form.getCustomFunctionList();
        FormCustomFunction result = null;
        if (list != null) {
            for (FormCustomFunction custom : list) {
                if (custom == null || id == null || custom.getId().longValue() != id.longValue()) continue;
                result = custom;
            }
        }
        return result;
    }

    @Override
    public List<FormCustomFunction> getFormCustomFunctionList(Long formId) {
        return this.cap4FormCacheManager.getFormCustomFunction(formId);
    }

    @Override
    public void delById(Long id, Long formId) throws BusinessException {
        FormCustomFunction customFunction = this.selectById(id, formId);
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getEditingForm(formId);
        List list = form.getCustomFunctionList();
        if (list != null) {
            list.remove(customFunction);
            this.cap4FormManager.saveEditingForm(form);
        }
    }

    @Override
    @AjaxAccess
    public String preGroovyCode(String functionName, String codeText, int returnType) {
        String msg = "success";
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AjaxAccess
    public Map<String, String> readCodeFromFile(Long fieldId) {
        InputStreamReader read = null;
        BufferedReader bufferedReader = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String successTxt = "success";
        try {
            StringBuilder sb = new StringBuilder();
            File file = this.fileManager.getFile(fieldId);
            if (file.isFile() && file.exists()) {
                read = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
                bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    sb.append(lineTxt);
                }
                result.put("info", sb.toString().trim());
                read.close();
            } else {
                successTxt = ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.nofile");
            }
        }
        catch (Exception e) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (read != null) {
                    read.close();
                }
            }
            catch (IOException e1) {
                LOGGER.error((Object)ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.readfileerror"), (Throwable)e1);
            }
            successTxt = ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.readfileerror") + e.getMessage();
            LOGGER.error((Object)ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.readfileerror"), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (read != null) {
                    read.close();
                }
            }
            catch (IOException e1) {
                LOGGER.error((Object)ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.readfileerror"), (Throwable)e1);
            }
        }
        result.put("result", successTxt);
        return result;
    }

    @Override
    @AjaxAccess
    public void updateAuditState(Map<String, Object> param) throws BusinessException {
        Long id = ParamUtil.getLong(param, (String)"id", (Long)0L);
        int auditState = ParamUtil.getInt(param, (String)"auditState", (int)0);
        this.formCustomFunctionDAO.updateAuditState(id, auditState);
        List list = null;
        Long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
        com.seeyon.cap4.form.bean.FormBean formBean4 = this.cap4FormCacheManager.getForm(formId);
        boolean isCap4 = true;
        if (formBean4 != null) {
            list = formBean4.getCustomFunctionList();
        } else {
            FormBean formBean3 = this.formCacheManager.getForm(formId.longValue());
            if (formBean3 == null) {
                LOGGER.error((Object)("\u8868\u5355\u88ab\u5220\u9664\uff0c" + formId));
                return;
            }
            list = formBean3.getCustomFunctionList();
            isCap4 = false;
        }
        if (Strings.isNotEmpty((Collection)list)) {
            for (FormCustomFunction function : list) {
                if (!id.equals(function.getId())) continue;
                function.setAuditState(Integer.valueOf(auditState));
            }
            list = this.formCacheManager.getFormCustomFunction(formId);
            if (Strings.isNotEmpty((Collection)list)) {
                for (FormCustomFunction function : list) {
                    if (!id.equals(function.getId())) continue;
                    function.setAuditState(Integer.valueOf(auditState));
                }
            }
            if (isCap4) {
                this.cap4FormCacheManager.sendNotification((Object)(formId + "_" + id + "_" + auditState), CAP4FormCache.FormCacheType.CustomFunction_Reload, formId);
            } else {
                this.formCacheManager.sendNotification((Object)(formId + "_" + id + "_" + auditState), FormCache.FormCacheType.CustomFunction_Reload);
            }
        }
    }

    @Override
    @AjaxAccess
    public FlipInfo selectCustomFuncByFlipInfo(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        List functionList = this.formCustomFunctionDAO.selectCustomFuncByFlipInfo(fi, params);
        ArrayList resultList = new ArrayList();
        if (Strings.isNotEmpty((Collection)functionList)) {
            for (FormCustomFunction func : functionList) {
                Enums.FormCustomFuncAuditEnum auditEnum;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("id", func.getId());
                rowMap.put("formId", func.getFormId());
                rowMap.put("functionName", func.getFunctionName());
                rowMap.put("codeText", func.getCodeText());
                rowMap.put("returnType", FormulaEnums.CustomFunctionType.getEnumByKey((int)func.getReturnType()).getText());
                if (func.getAuditState() == null) {
                    func.setAuditState(Integer.valueOf(Enums.FormCustomFuncAuditEnum.AUDITEDPASS.getKey()));
                }
                rowMap.put("auditState", (auditEnum = Enums.FormCustomFuncAuditEnum.getAuditEnumByKey((int)func.getAuditState())) == null ? "" : auditEnum.getText());
                Long formId = func.getFormId();
                String formName = "";
                Long ownerId = 0L;
                Long ownerAccountId = 0L;
                com.seeyon.cap4.form.bean.FormBean formBean4 = this.cap4FormCacheManager.getForm(formId);
                if (formBean4 != null) {
                    formName = formBean4.getFormName();
                    ownerId = this.cap4FormCacheManager.getFormOwner(formId).getOwnerId();
                    ownerAccountId = this.cap4FormCacheManager.getFormOwner(formId).getOrgAccountId();
                } else {
                    FormBean formBean3 = this.formCacheManager.getForm(formId.longValue());
                    if (formBean3 == null) {
                        LOGGER.error((Object)("\u8868\u5355\u88ab\u5220\u9664\uff0c" + formId));
                        continue;
                    }
                    formName = formBean3.getFormName();
                    ownerId = this.formCacheManager.getFormOwner(formId).getOwnerId();
                    ownerAccountId = this.formCacheManager.getFormOwner(formId).getOrgAccountId();
                }
                rowMap.put("formName", formName);
                rowMap.put("ownerName", this.orgManager.getMemberById(ownerId).getName());
                rowMap.put("ownerAccount", this.orgManager.getAccountById(ownerAccountId).getName());
                resultList.add(rowMap);
            }
        }
        fi.setData(resultList);
        return fi;
    }

    public void setFormCustomFunctionDAO(FormCustomFunctionDAO formCustomFunctionDAO) {
        this.formCustomFunctionDAO = formCustomFunctionDAO;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }
}

